<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
<meta name="keywords" content="百联保">
<meta name="description" content="百联保是百川信（厦门）网络技术有限公司基于金融创新并响应互联网＋计划搭建的第三方金融服务平台。秉承开拓金融创新，减轻企业负担的服务理念，百联保利用互联网平台优势并结合保险的市场作用，将与保证金、银行保函、担保公司保函具备同等效力的保证保险保函纳入经贸合作的担保形式之一，旨在减轻企业资金负担，简化申办流程，缩短办理周期，为企业客户提供低成本、高效率、安全专业的新型互联网金融服务。">

<title>百联保—我的订单</title>
<link href="<c:url value='/resources/css/public.css' />" rel="stylesheet" type="text/css" />
<link href="<c:url value='/resources/css/personal_center.css' />" rel="stylesheet" type="text/css" />

</head>
<body>
<div id="masks" class="mask"></div>
<!-- 弹出窗口 开始 -->
<div class="finish_handle">
    <div class="hint_title">
    	<span class="mar_left10">提示</span>
    	<span id="close" onclick="closeWinD()"><img src="<c:url value='/resources/images/hint_close.jpg' />" width="14" height="15"></span>
    </div>
    <div class="clear"></div>
    <p><label>已完成操作，</label><a href="javascript:void();" onclick="fluchHtmlL()">刷新</a><label>页面</label></p>
</div>
<!-- 弹出窗口 结束 -->
<jsp:include page="../../header.jsp"/>
<!-- 个人中心 我的订单 内容部分 开始 -->
<div class="per_centerwar"><!-- per_centerwar start -->
	<div class="per_centersub"><!-- per_centersub star -->
    	<div class="per_cenleftwar"><!-- per_cenleftwar star -->
        	<div class="my_acount">
            	<p><img src="<c:url value='/resources/images/my_acount.jpg' />" width="32" height="32" title="我的账户"></p>
            	<p><a href="<c:url value='/user/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">我的账户</a></p>
            </div>
            <div class="clear"></div>
            <div class="acount_list">
            	<ul>
                    <li class="acount_active">
                        <a href="<c:url value='/policy/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/my_order.png' />" width="17" height="19"></label>
                            <span>我的订单</span>
                        </a>
                    </li>
                    <div class="clear"></div>
                    <li>
                        <a href="<c:url value='/report/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/refer.png' />" width="22" height="21"></label>
                            <span>理赔查询</span>
                        </a>
                    </li>
                    <div class="clear"></div>
                    <li>
                        <a href="<c:url value='/user/personal/init?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/com_data.png' />" width="21" height="15"></label>
                            <span>企业资料</span>
                        </a>
                    </li>
                    <div class="clear"></div>
                    <li>
                        <a href="<c:url value='/appMsg/index?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
                            <label><img src="<c:url value='/resources/images/insure_mes.png' />" width="19" height="20"></label>
                            <span>投保人资料</span>
                        </a>
                    </li>
                </ul>
            </div>
        </div><!-- per_cenleftwar end -->
        <div class="per_cenrightwar"><!-- per_cenrightwar start -->
        	 <div class="order_list"><!-- order_list start -->
            	<ul>
                	<li class="order_activ"><a href="javascript:void(0);" onclick="loadPolicy(this,'IN_FORCE');">保障中（<strong>${ forcetotal}</strong>）</a></li>
                    <li><a href="javascript:void(0);" onclick="loadPolicy(this,'LAPSED');">已过期（<strong>${lapsedtotal }</strong>）</a></li>
                    <li><a href="javascript:void(0);" onclick="loadPolicy(this,'PENDING');">待支付（<strong>${pendtotal }</strong>）</a></li>
                    <li><a href="javascript:void(0);" onclick="loadPolicy(this,'APPLIED');">投保中（<strong>${appliedtotal }</strong>）</a></li>
                    <li><a href="javascript:void(0);" onclick="loadPolicy(this,'OFFLINE');">线下（<strong>${offlinetotal }</strong>）</a></li>
                </ul>
            </div><!-- order_list end -->
            <div class="clear"></div>
            <div class="insur_ance" id="insur_ance_list"><!-- insur_ance start -->
                <c:if test="${status eq 'IN_FORCE' }">

				<c:if test="${policyList.size()>0 }">
				<c:forEach items="${policyList }" var="list">
						<div class="insur_list"><!-- insur_list start -->
							<div>
						    	<c:if test="${list.agreementSpec.productType eq 'CONBID' && list.agreementSpec.productClass eq 'JGL' }">
						    	<img src="<c:url value='/resources/images/inqu_img1.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'CONBID' && list.agreementSpec.productClass eq 'ZCL' }">
						    	<img src="<c:url value='/resources/images/inqu_img6.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'WAGEPAY' }">
						    	<img src="<c:url value='/resources/images/pay_img.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'CONQUALITY' }">
						    	<img src="<c:url value='/resources/images/product_img3.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'PERFORMANCE' }">
						    	<img src="<c:url value='/resources/images/product_img2.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'PACT' }">
						    	<img src="<c:url value='/resources/images/product_img1.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    </div>
						    <div class="inli_text">
						    	<a href="<c:url value='/order/policyDetail/${list.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
						        	<h4>${list.agreementSpec.name  }<c:if test="${list.agreementSpec.productClass != 'RESTS' }">(${list.agreementSpec.productClass.name })</c:if></h4>
						            <p>订单号：${list.policyTransaction.tradeSerialNumber }</p>
						            <p>保单号：${list.external_reference }</p>
						            <p>保费：${list.grossPremium }元</p>
						            <p>订单日期：<fmt:formatDate pattern="yyyy-MM-dd" value="${list.policyTransaction.startTime}"/></p>
						        </a>
						    </div>
						    <div class="skip">
						    	<p>${list.policyStatus.name }</p>
						        <%-- <span><a href="<c:url value='' />">批单</a></span> --%>
						    	<a href="<c:url value='/order/policyDetail/${list.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="aborder mar_left35">保单详情</a>
						    </div>
						</div><!-- insur_list end -->
					
				</c:forEach>
				</c:if>
				
				<c:if test="${policyList.size()==0 }">
				<!-- 无任何订单记录 开始 -->
				<div class="anony_mous"><p>无任何订单记录，<a href="<c:url value='/?ACCESS_TOKEN=${ACCESS_TOKEN}' />">立即购买</a></p></div>
				 <!-- 无任何订单记录 结束 -->
				</c:if>
				</c:if>
                <c:if test="${status eq 'LAPSED' }">
				<c:if test="${policyList.size()>0 }">
				<c:forEach items="${policyList }" var="list">
					
						<div class="insur_list"><!-- insur_list start -->
							<div>
						    	<c:if test="${list.agreementSpec.productType eq 'CONBID' && list.agreementSpec.productClass eq 'JGL' }">
						    	<img src="<c:url value='/resources/images/inqu_img1.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'CONBID' && list.agreementSpec.productClass eq 'ZCL' }">
						    	<img src="<c:url value='/resources/images/inqu_img6.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'WAGEPAY' }">
						    	<img src="<c:url value='/resources/images/pay_img.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'CONQUALITY' }">
						    	<img src="<c:url value='/resources/images/product_img3.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'PERFORMANCE' }">
						    	<img src="<c:url value='/resources/images/product_img2.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'PACT' }">
						    	<img src="<c:url value='/resources/images/product_img1.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    </div>
						    <div class="inli_text">
						    	<a href="<c:url value='/order/policyDetail/${list.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
						        	<h4>${list.agreementSpec.name  }<c:if test="${list.agreementSpec.productClass != 'RESTS' }">(${list.agreementSpec.productClass.name })</c:if></h4>
						            <p>订单号：${list.policyTransaction.tradeSerialNumber }</p>
						            <p>保单号：${list.external_reference }</p>
						            <p>保费：${list.grossPremium }元</p>
						            <p>订单日期：<fmt:formatDate pattern="yyyy-MM-dd" value="${list.policyTransaction.startTime}"/></p>
						        </a>
						    </div>
						    <div class="skip">
						    	<p>${list.policyStatus.name }</p>
						    </div>
						</div><!-- insur_list end -->
				</c:forEach>
				</c:if>
				
				<c:if test="${policyList.size()==0 }">
				<!-- 无任何订单记录 开始 -->
				<div class="anony_mous"><p>无任何订单记录，<a href="<c:url value='/?ACCESS_TOKEN=${ACCESS_TOKEN}' />">立即购买</a></p></div>
				 <!-- 无任何订单记录 结束 -->
				</c:if>
				</c:if>
				<c:if test="${status eq 'PENDING' }">
				<c:if test="${policyList.size()>0 }">
				<c:forEach items="${policyList }" var="list">
					
						<div class="insur_list"><!-- insur_list start -->
							<div>
						    	<c:if test="${list.agreementSpec.productType eq 'CONBID' && list.agreementSpec.productClass eq 'JGL' }">
						    	<img src="<c:url value='/resources/images/inqu_img1.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'CONBID' && list.agreementSpec.productClass eq 'ZCL' }">
						    	<img src="<c:url value='/resources/images/inqu_img6.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'WAGEPAY' }">
						    	<img src="<c:url value='/resources/images/pay_img.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'CONQUALITY' }">
						    	<img src="<c:url value='/resources/images/product_img3.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'PERFORMANCE' }">
						    	<img src="<c:url value='/resources/images/product_img2.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'PACT' }">
						    	<img src="<c:url value='/resources/images/product_img1.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    </div>
						    <div class="inli_text">
						    	<a href="<c:url value='/order/policyDetail/${list.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
						        	<h4>${list.agreementSpec.name  }<c:if test="${list.agreementSpec.productClass != 'RESTS' }">(${list.agreementSpec.productClass.name })</c:if></h4>
						            <p>订单号：${list.policyTransaction.tradeSerialNumber }</p>
						            <c:if test="${list.agreementSpec.productType eq 'CONBID' }"><p>保费：${list.grossPremium }元</p></c:if>
						            <p>订单日期：<fmt:formatDate pattern="yyyy-MM-dd" value="${list.policyTransaction.startTime}"/></p>
						        </a>
						    </div>
						    <div class="skip">
						    	<p>${list.policyStatus.name }</p>
						        <span><a href="javascript:void();" onclick="deletePolicy('${list.oid }','${status }');">删除</a></span>
						        <c:choose>
						        	<c:when test="${list.agreementSpec.productType eq 'CONBID' }">
						        		<c:if test="${not empty list.policySerialNumber && empty list.external_reference }">
						        		<a href="${list.policyTransaction.showUrl }" target="_blank" class="aborder mar_left35" onclick="fluchHtml()">立即支付</a>
						        		</c:if>
						        		<c:if test="${empty list.policySerialNumber }">
								        <a href="<c:url value='/product/sale/policyPay/${list.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="aborder mar_left35">立即支付</a>
						        		</c:if>
						        	</c:when>
						        	<c:otherwise>
						        		<a href="<c:url value='/?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="aborder mar_left35">继续购买</a>
						        	</c:otherwise>
						        </c:choose>
						        
						    </div>
						</div><!-- insur_list end -->
				</c:forEach>
				</c:if>
				
				<c:if test="${policyList.size()==0 }">
				<!-- 无任何订单记录 开始 -->
				<div class="anony_mous"><p>无任何订单记录，<a href="<c:url value='/?ACCESS_TOKEN=${ACCESS_TOKEN}' />">立即购买</a></p></div>
				 <!-- 无任何订单记录 结束 -->
				</c:if>
				</c:if>
				<c:if test="${status eq 'APPLIED' }">
				<c:if test="${policyList.size()>0 }">
				<c:forEach items="${policyList }" var="list">
						<div class="insur_list"><!-- insur_list start -->
							<div>
						    	<c:if test="${list.agreementSpec.productType eq 'CONBID' && list.agreementSpec.productClass eq 'JGL' }">
						    	<img src="<c:url value='/resources/images/inqu_img1.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'CONBID' && list.agreementSpec.productClass eq 'ZCL' }">
						    	<img src="<c:url value='/resources/images/inqu_img6.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'WAGEPAY' }">
						    	<img src="<c:url value='/resources/images/pay_img.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'CONQUALITY' }">
						    	<img src="<c:url value='/resources/images/product_img3.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'PERFORMANCE' }">
						    	<img src="<c:url value='/resources/images/product_img2.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'PACT' }">
						    	<img src="<c:url value='/resources/images/product_img1.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    </div>
						    <div class="inli_text">
						    	<a href="<c:url value='/product/sale/continueFill/${list.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
						        	<h4>${list.agreementSpec.name  }<c:if test="${list.agreementSpec.productClass != 'RESTS' }">(${list.agreementSpec.productClass.name })</c:if></h4>
						            <p>订单号：${list.policyTransaction.tradeSerialNumber }</p>
						            <p>保费：${list.grossPremium }元</p>
						            <p>订单日期：<fmt:formatDate pattern="yyyy-MM-dd" value="${list.policyTransaction.startTime}"/></p>
						        </a>
						    </div>
						    <div class="skip">
						    	<p>${list.policyStatus.name }</p>
						        <span><a href="javascript:void();" onclick="deletePolicy('${list.oid }','${status }');">删除</a></span>
						        <a href="<c:url value='/product/sale/continueFill/${list.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="aborder mar_left35">继续投保</a>
						    </div>
						</div><!-- insur_list end -->
					
				</c:forEach>
				</c:if>
				
				<c:if test="${policyList.size()==0 }">
				<!-- 无任何订单记录 开始 -->
				<div class="anony_mous"><p>无任何订单记录，<a href="<c:url value='/?ACCESS_TOKEN=${ACCESS_TOKEN}' />">立即购买</a></p></div>
				 <!-- 无任何订单记录 结束 -->
				</c:if>
				</c:if>
				
				<c:if test="${status eq 'OFFLINE' }">

				<c:if test="${policyList.size()>0 }">
				<c:forEach items="${policyList }" var="list">
						<div class="insur_list"><!-- insur_list start -->
							<div>
						    	<c:if test="${list.agreementSpec.productType eq 'CONBID' && list.agreementSpec.productClass eq 'JGL' }">
						    	<img src="<c:url value='/resources/images/inqu_img1.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'CONBID' && list.agreementSpec.productClass eq 'ZCL' }">
						    	<img src="<c:url value='/resources/images/inqu_img6.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'WAGEPAY' }">
						    	<img src="<c:url value='/resources/images/pay_img.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'CONQUALITY' }">
						    	<img src="<c:url value='/resources/images/product_img3.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'PERFORMANCE' }">
						    	<img src="<c:url value='/resources/images/product_img2.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    	<c:if test="${list.agreementSpec.productType eq 'PACT' }">
						    	<img src="<c:url value='/resources/images/product_img1.jpg' />" width="199" height="103" title="${list.agreementSpec.name  }">
						    	</c:if>
						    </div>
						    <div class="inli_text">
						    	<a href="<c:url value='/order/policyDetail/${list.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
						        	<h4>${list.agreementSpec.name  }<c:if test="${list.agreementSpec.productClass != 'RESTS' }">(${list.agreementSpec.productClass.name })</c:if></h4>
						            <p>订单号：${list.policyTransaction.tradeSerialNumber }</p>
						            <p>保单号：${list.external_reference }</p>
						            <%-- <p>保费：${list.grossPremium }元</p> --%>
						            <p>订单日期：<fmt:formatDate pattern="yyyy-MM-dd" value="${list.policyTransaction.startTime}"/></p>
						        </a>
						    </div>
						    <div class="skip">
						    	<p>${list.policyStatus.name }</p>
						        <%-- <span><a href="<c:url value='' />">批单</a></span> --%>
						    	<a href="<c:url value='/order/policyDetail/${list.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="aborder mar_left35">保单详情</a>
						    </div>
						</div><!-- insur_list end -->
					
				</c:forEach>
				</c:if>
				
				<c:if test="${policyList.size()==0 }">
				<!-- 无任何订单记录 开始 -->
				<div class="anony_mous"><p>无任何订单记录，<a href="<c:url value='/?ACCESS_TOKEN=${ACCESS_TOKEN}' />">立即购买</a></p></div>
				 <!-- 无任何订单记录 结束 -->
				</c:if>
				</c:if>
            </div><!-- insur_ance end -->
        </div><!-- per_cenrightwar end -->
    </div><!-- per_centersub end -->
    <div class="clear"></div>
</div><!-- per_centerwar end -->
<!-- 个人中心  我的订单 内容部分 结束 -->
<!-- 内容部分  注册  结束 -->
<jsp:include page="../../index/multi_f.jsp" />
<script src="<c:url value='/resources/script/jquery-1.8.3.min.js' />" type="text/javascript"></script>
<script src="<c:url value='/resources/js/insurance.js' />" type="text/javascript"></script>

<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';
$(function(){
	var signU = '${uSign}';
	if(signU != ''){
		var coSin = 1;
		$(".order_list ul li").each(function(){
			if(Number(signU) == coSin){
				$(this).attr("class","order_activ");
			}else{
				$(this).attr("class","");
			}
			coSin ++;
		});
	}
	
});
function loadPolicy(vl,status){
	$(".order_list ul li").each(function(){
		$(this).attr("class","");
	});
	$(vl).parent().attr("class","order_activ");
	$.ajax({
		type: 'POST',
		url: baseUrl + "/policy/index",
		data:{'status': status},
		dataType:"html",
		cache: false,
		success: function(data){
			$("#insur_ance_list").html(data);
			resPostView();
		}
	}); 
}

function deletePolicy(oid,status){
	$.ajax({
		type: 'POST',
		url: baseUrl + "/policy/policyDelete/"+oid,
		data:{'status': status},
		dataType:"json",
		cache: false,
		success: function(json){
			if (json.statusCode == '200') {
				alert(json.resultDto.message);
				$.ajax({
					type: 'POST',
					url: baseUrl + "/policy/index",
					data:{'status': status},
					dataType:"html",
					cache: false,
					success: function(data){
						$("#insur_ance_list").html(data);
						resPostView();
					}
				}); 
			}else{
	        	alert(json.resultDto.message);
	        }
		}
	}); 
}

function resPostView(){
	if(Number($("#heiPolicy_val").val())>370){
		$(".per_centerwar").css("height",Number($("#heiPolicy_val").val())+150);
	}else{
		$(".per_centerwar").attr("style","");
		var windowHight = $(window).height();
		var ft = $(".heightFooter").outerHeight();
		var ct = $(".per_centerwar").outerHeight();
		var num_ = windowHight - ft - 112 - ct;
		if(num_>0){
			$(".per_centerwar").css("height",num_ + ct - 30);
		}
	}
}

function fluchHtml(){
	$("#masks").css({
		"height":$(document).height(),
		"width":$(document).width()
}).show();
	$(".finish_handle").show();
}
function fluchHtmlL(){
	location.reload(true);
}
function closeWinD(){
	$("#masks").hide();
	location.reload(true);
}
</script>
</html>