<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>用户登录</title>

	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/public.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />
	<style>
		.go-to-register {
			cursor: pointer;
			height: 70px;
			width: 70px;
			background-image: url(https://img.alicdn.com/imgextra/i3/O1CN01yz6fEl1MwaRtkJyvf_!!6000000001499-55-tps-70-70.svg);
			position: absolute;
			top: 0px;
			right: 0px;
			text-align: right;
		}
		.go-to-register span {
			font-size: 14px;
			color: rgb(255, 255, 255);
			font-weight: 500;
			position: relative;
			top: 10px;
			right: 7px;
		}
	</style>
</head>
<body id="login-regis">
<div class="head-more">
	<div class="more-content clearfix">
		<div class="logo fl">
			<a href="<c:url value='/' />">
				<img src="<c:url value='/resources/version_new/images/bai-logo.png' />" alt="百联保logo">
				<span>用户登录</span>
			</a>
		</div>
	</div>
</div>
<div class="s-login">
	<div class="go-to-register"><span onclick="loginChange(0)">个人</span></div>
	<form action="<c:url value='/user/clientUserLogin'/>" method="post">
		<div class="login-content">
			<h2>企业登录</h2>
			<div class="select-content">
				<div class="content-describe">
					<div class="dec-inp">
						<div class="tooltip-more">
							<input type="text" placeholder="请输入邮箱地址/用户名"  name="j_username_2"  id="j_username_2" class="s1 s-tooltip">
							<div class="tooltip s-none">
								<h3>填写提示</h3>
								<p>企业用户支持邮箱、用户名登录</p>
							</div>
							<p class="error s-email-error"></p>
						</div>
						<input type="password" placeholder="请输入登录密码(密码为6-20位数字和字母组合)" name="j_password_2"  id="j_password_2" class="s2">
						<p class="error pwd-e0error"></p>
					</div>
				</div>
			</div>
			<div class="dec-pic clearfix">
				<p class="fl"><input type="text" placeholder="请输入右侧验证码" value="" class="s3" id="right-code"></p>
				<div class="fr" id="v_container"></div>
				<p class="error error-code"></p>
			</div>
			<div class="login-foot">
				<div class="forget-password">
					<a href="<c:url value="/user/pwd/rest/init" />">忘记密码？</a>
				</div>
				<div class="login">
					<a href="javascript:;" class="ert" onclick="tijiaoLogin()">登录</a>
				</div>
				<div class="sign-up">
					<p>还没账号？<a href="<c:url value="/user/register/init" />">立即注册>></a></p>
				</div>
			</div>
		</div>
	</form>
</div>
<script src="<c:url value='/resources/version_new/js/jquery-1.8.3.min.js' />"></script>
<script src="<c:url value='/resources/version_new/js/gVerify.js' />"></script>
<script src="<c:url value='/resources/version_new/js/login.js?3' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script src="<c:url value='/resources/version_new/js/placeholder.js' />"></script>

<script type='text/javascript' src='https://webchat.7moor.com/javascripts/7moorInit.js?accessId=d7359b20-9dec-11ec-a564-cd73c4e7850a&autoShow=true&language=ZHCN' async='async'>
</script>
<script>
	$(function(){
		if (window!=top)
			top.location.href = window.location.href;
		init_public_key();
	});
	var baseUrl = '${pageContext.request.contextPath }';

	var verifyCode = new GVerify("v_container");

	function loginChange(_sign){
		var url = window.location.href;
		if(_sign == 1){
			url = url.replace("/login","/loginc");
		}else{
			url = url.replace("/loginc","/login");
		}
		window.location.href = url;
	}
	function checkCodes() {
		if ($('#right-code').val() == "") {
			$('.error-code').html("验证码不能为空").addClass('wed');
			$('#right-code').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
			return e_code_ok = false;
		} else if (verifyCode.validate(document.getElementById("right-code").value)) {
			$('.error-code').html("").removeClass('wed');
			$('#right-code').css({"border":"1px solid #e6e6e6","box-shadow":"none"});
			return e_code_ok = true;
		} else{
			$('.error-code').html("验证码输入有错").addClass('wed');
			$('#right-code').css({"border":"1px solid red","box-shadow":"0 0 5px #fa4c4c"});
			return e_code_ok = false;
		};
	}

	function init_public_key() {
		$.ajax({
			type: 'POST',
			url: baseUrl+"/synopsis/get/public_key",
			dataType:"json",
			async: false,
			success: function(json){
				if(json.retType == '0'){
					$('#public_key').val(json.data);
				}
			}
		});
	}

	$('#right-code').blur(function () {
		checkCodes();
	})
	function tijiaoLogin() {

		var  rurl="${url}";
		var j_username=$("#j_username_2").val();
		var j_password=$("#j_password_2").val();
		var j_type="2";
		if(j_username==""||j_password==""){
			layer.msg("用户名，和密码不能为空");
		}else{

			var  rightCode= $("#right-code").val();
			if(verifyCode.validate(rightCode)){

				var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
				$.ajax({
					type: 'POST',
					url: baseUrl+"/user/login/clentLogin1",
					data:{j_username:j_username
						,j_password:j_password
						,j_type:j_type
						,rurl:rurl},
					dataType:"json",
					async: false,
					success: function(data){

						layer.close(index);
						if(data.status =="200"){
							layer.msg('登录成功！', {time:2000});
//							layer.msg(data.msg, {
//								btn: ['登录']
//								,yes: function(index, layero){
//									location.href=data.redirectUrl;
//								}
//							});
							location.href=data.redirectUrl;
//							setTimeout(function(){
//
//							},1000);
						}else{
							layer.msg(""+data.msg);
						}
					}
				});
			}
			else{
				layer.msg("验证码输入错误请重新输入。");

			}

		}


	}

	$("body").keydown(function() {

		var theEvent = window.event || arguments.callee.caller.arguments[0];
		if (theEvent.keyCode == "13") {//keyCode=13是回车键
			tijiaoLogin();
		}
	});


//	$("input").placeholder();
</script>
<script>

</script>
</body>
</html>