<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<div class="modal-content">
		  <div class="modal-header bg-f8fafc">
		  	<div class="pal-41"><img src="<c:url value='/resources/versions-2.0/images/public/bao.png' />" class="img-responsive"></div>
		  </div>
		  <form id="commonLoginForm" action="<c:url value='/j_spring_security_check'/>" method="post">
			  <div class="modal-body">
			  	<p>
			  		<label>邮箱地址</label>
			  		<input type="text" name="j_username" id="j_username" class="form-control" placeholder="请输入邮箱地址" />
			  	</p>
			  	<p class="reset-pwd">
			  		<label>密码</label><a href="#reset-pwd" data-toggle="modal"  data-dismiss="modal" class="pull-right">忘记密码</a>
			  		<input type="password" name="j_password" id="j_password" class="form-control" placeholder="" />
			  	</p> 
			  	<div class="mt-20">
			  		<label>验证码</label>
			  		<div class="row">
			  			<div class="col-sm-9 col-xs-9 has-loser has-feedback">
			  				<input type='hidden' name='yzType' value="0" />
		                	<input type="text" class="form-control" placeholder="请输入验证码" onblur="checkYzm('ryzm')" id="ryzm" name='j_captcha'/>
			  				<span class="glyphicon glyphicon-remove form-control-feedback t-icon-m" aria-hidden="true"></span> 
			  			</div>
			  			<div class="col-sm-3 col-xs-3 pl-0 br-img ryzm_width"><img id="imageF" src="<c:url value='/user/image.htm'/>" onclick="changeImg()"/></div>
			  			
			  		</div>
			  		<div class="clear"></div>
			  	</div>
			  	<p><button type="button" class="btn notarize-btn w-100" id="loginUp" onclick="login('commonLoginForm')">登录</button></p>
			  </div>
			  <div class="modal-footer">
				<div class="bo-conten">
					<span class="pull-left" >还没有账号？</span><a href="#register" class="pull-right" data-toggle="modal"  data-dismiss="modal">立即注册</a>
				</div>
			 </div> 
		  </form> 
		</div>
		<!-- 点击确认弹出修改成功 默认隐藏-->
		<div class="resu-btn">登录成功！</div>


<script type="text/javascript">
	$(function(){
		$("#loginForm").keydown(function(e){
			 var e = e || event,
			 keycode = e.which || e.keyCode;
			 if (keycode==13) {
			  	$("#loginUp").trigger("click");
			 }
		});
	});
	var baseUrl = '${pageContext.request.contextPath }';
	
    function changeImg() {  
        $('#imageF').hide().attr('src','<c:url value='/user/image.htm'/>'+ '?'+ Math.floor(Math.random() * 100)).fadeIn();  
    }
    
    function replaceLogin(va_){
    	if(va_ == '1'){
    		$.ajax({
    			type: 'POST',
    			url: baseUrl + "/user/replaceLogin",
    			data:{
    				'num':va_
    			},
    			dataType:"html",
    			cache: false,
    			success: function(data){
    				$("#commonLoginForm").html(data);
    				$("#bidLoginForm").html('');
    			}
    		}); 
    	}
    	if(va_ == '2'){
    		$.ajax({
    			type: 'POST',
    			url: baseUrl + "/user/replaceLogin",
    			data:{
    				'num':va_
    			},
    			dataType:"html",
    			cache: false,
    			success: function(data){
    				$("#bidLoginForm").html(data);
    				$("#commonLoginForm").html('');
    			}
    		}); 
    	}
    }
    
    /**检查验证码 */
    function checkYzm(obj) {
    	var ryzm = $("#"+obj).val();
    	if(ryzm != $("#ryzm").attr("defaultValue") && ryzm != "") {
    		$(".forget_pwd").children().remove("label");
    		$.ajax({
    			type: 'POST',
    			url: baseUrl + "/user/register/checkYzm.json",
    			data:{'captcha': ryzm},
    			dataType:"json",
    			cache: false,
    			success: function(json){
    				if(json.statusCode == '300') {
    					$(".forget_pwd").children().remove("label");
    					$(".forget_pwd").children("a").before("<label class='log_hint'>验证码不正确</label>");
    					changeImg();
    					$("#ryzm").val($("#ryzm").attr("defaultValue"));
    					$("#ryzm").focus();
    				}else{
    		    		$(".forget_pwd").children().remove("label");
    		    	}
    			}
    		}); 
    	}else{
    		$(".forget_pwd").children("a").before("<label class='log_hint'>请输入验证码</label>");
    	}
    }
    
  	/**检查必选项 */
    function checkLoginRequiredField(){
    	var j_username = $("#j_username").val();
    	var j_password = $("#j_password").val();
    	var ryzm = $("#ryzm").val();
    	//var autoLoginFlg = $("#autoLoginFlg").val();
    	var regConfirmPassword = $("#regConfirmPassword").val();
    	
    	if ( j_username == "" || $("#j_username").val() == $("#j_username").attr("defaultValue")) {
    		$(".forget_pwd").children("a").before("<label class='log_hint'>请输入用户名</label>");
    		return false;
    	}else{
    		$(".forget_pwd").children().remove("label");
    	}
    	if ( j_password == ""  || $("#j_password").val() == "密码") {
    		$(".forget_pwd").children("a").before("<label class='log_hint'>请输入密码</label>");
    		return false;
    	}else{
    		$(".forget_pwd").children().remove("label");
    	}
    	
    	//if (autoLoginFlg == 0) {
    		if( ryzm == "" || $("#ryzm").val() == $("#ryzm").attr("defaultValue")){
    			checkYzm('ryzm');
    			return false;
    		}
    	//}
    	
    	return true;
    }
  	
	//使用remember me实现
	/** 登录失败，将autoLogin设置为false 避免自动登录死循环 */
	/* function changeAutoLogin(){
		var expiresSecond = 15 * 24 * 3600;//过期时间，单位：秒
		var date = new Date();
		var ms = expiresSecond * 1000;
		date.setTime(date.getTime() + ms);
		//直接修改autoLogin = false;
		document.cookie = "autoLogin=false;expires=" + date.toGMTString() + ";path=" + baseUrl + '/user/login';
	} */
	
    function login(id_){
    	
    	var flag = checkLoginRequiredField();
    	
    	if (flag){ 
    		/* 使用 remember me 实现自动登录
    		//使用JS实现自动登录,将信息保存到cookies
    		if(document.getElementById("autoLogin").checked == true){
    			document.getElementById("rememberPassword").checked = true;
    		}
    	
    		var date = new Date();
			var ms = expiresSecond * 1000;
			date.setTime(date.getTime() + ms);
    		document.cookie="rememberPassword="+document.getElementById("rememberPassword").checked+";expires=" + date.toGMTString();
        	document.cookie="autoLogin="+document.getElementById("autoLogin").checked+";expires=" + date.toGMTString();
        	document.cookie="bcxusername="+document.getElementById("j_username").value+";expires=" + date.toGMTString();
        	//加密
    		var password=unicode(document.getElementById("j_password").value);
        	document.cookie="bcxpassword="+password+";expires=" + date.toGMTString();
        	
    		saveCookie(); */
    		
    		var $form = $("#"+id_);
    		$form.submit();
    	}
    }

    /* $(document).ready(function(){
    	var erro = $("div.jzmm_area").eq(0).html();
    	 var $message = $.trim(erro);
    	if($message == "用户名或密码不正确"){
    		$("div.jzmm_area").eq(0).remove();
    		$("#error").html("用户名或密码不正确！");
    	}
    }); */
    
    /*使用 remember me实现 
    //自动登录
    $(function(){
    	recoverCookie();
    }); */
</script>
</body>
</html>