<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-回溯预览</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/rrweb/css/rrweb.min.css?001' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/rrweb/css/style.css?002' />" />
<%--		<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/rrweb@latest/dist/rrweb.min.css"/>--%>
<%--		<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/rrweb-player@latest/dist/style.css" />--%>
		<link rel="stylesheet" href="https://cdn.staticfile.org/layui/2.5.7/css/layui.css">
		<script src="https://cdn.staticfile.org/layui/2.5.7/layui.js"></script>
		<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb.min.js?002' />"></script>
		<script type="text/javascript" src="<c:url value='/resources/rrweb/js/index.js?001' />"></script>
<%--		<script src="https://cdn.jsdelivr.net/npm/rrweb@latest/dist/rrweb.min.js"></script>--%>
<%--		<script src="https://cdn.jsdelivr.net/npm/rrweb-player@latest/dist/index.js"></script>--%>
	</head>
	<style>
		#search-result {
			height: 600px;
			overflow-y: auto;
		}
	</style>
<body style="background: rgba(244,245,246,1);">
	<jsp:include page="../index/multi_h.jsp"/>
	
	<div class="container" style="padding-bottom: 50px; padding-top: 20px;">
		<div class="row" style="height: 660px">
			<div class="col-sm-4 col-xs-4">
				<form class="layui-form" action="">
					<div class="layui-form-item">
						<label class="layui-form-label">保单号</label>
						<div class="layui-input-inline">
							<input type="text" name="keyword" required lay-verify="required" placeholder="保单号" autocomplete="off" class="layui-input">
						</div>
						<button type="submit" class="layui-btn layui-btn-primary">搜索</button>
					</div>
				</form>
				<div class="clear"></div>
				<div id="search-result"></div>
			</div>
			<div class="col-sm-8 col-xs-8" id="replayer-container">

			</div>
		</div>
	</div>
	
	<jsp:include page="../index/multi_f.jsp" />
</body>

<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';

$(function(){
	
});
// 监听提交事件
$('.layui-form').on('submit', function(event) {
	event.preventDefault(); // 阻止表单默认提交行为
	var keyword = $(this).find('input[name="keyword"]').val(); // 获取输入的关键词
	search(keyword); // 调用搜索函数
});
// 搜索函数
function search(keyword) {
	// 发送Ajax请求到后端服务器进行搜索操作
	$.ajax({
		url: baseUrl + '/file/reader/playerList/${sign}', // 后端搜索接口地址
		type: 'POST', // 请求类型为GET
		data: { keyword: keyword }, // 将关键词作为参数传递
		success: function(data) {
			$('#search-result').html(data); // 将生成的HTML片段插入到指定区域中（假设id为search-result的元素用于展示搜索结果）
		},
		error: function() {
			// 处理请求失败的情况，例如显示错误信息或重新加载页面等操作
			alert('搜索出错，请稍后重试'); // 弹出错误提示框（可根据实际需求进行处理）
		}
	});
}
function player(path) {
	if(path && path.indexOf('.png')>-1){
		document.getElementById("replayer-container").innerHTML='<a target="_blank" href="'+path+'"><img src="'+path+'" width="780px" height="100%"></a>';
		return;
	}
	// 发送Ajax请求到后端服务器进行搜索操作
	$.ajax({
		url: baseUrl + '/file/reader/txt/${sign}', // 后端搜索接口地址
		type: 'POST', // 请求类型为GET
		data: { path: path }, // 将关键词作为参数传递
		success: function(data) {
			var events = JSON.parse(data);
			document.getElementById("replayer-container").innerHTML="";
			new rrwebPlayer({
				target: document.getElementById('replayer-container'),
				props: {
					events,
				},
			});
			/*const replayer = new rrweb.Replayer(JSON.parse(data));
			// 获取div元素
			var container = document.getElementById('replayer-container');
			replayer.target(container);
			replayer.play();*/
		},
		error: function() {
			// 处理请求失败的情况，例如显示错误信息或重新加载页面等操作
			alert('搜索出错，请稍后重试'); // 弹出错误提示框（可根据实际需求进行处理）
		}
	});
}
function copyAll(){
	let titles = [];
	document.querySelectorAll('.copyCon').forEach(function(element) {
		if (element.title) {
			titles.push(element.title);
		}
	});
	if ('clipboard' in navigator) {
		let allTitles = titles.join('\n'); // 使用换行符分隔每个title
		navigator.clipboard.writeText(allTitles)
				.then(() => layer.msg('已复制到剪切面板'))
				.catch(err => layer.msg('复制失败: ', err));
	} else {
		console.warn('Clipboard API not supported');
	}
}
</script>
</html>
