<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />  <meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
<meta name="keywords" content="百联保">
<meta name="description" content="百联保是百川信（厦门）网络技术有限公司基于金融创新并响应互联网＋计划搭建的第三方金融服务平台。秉承开拓金融创新，减轻企业负担的服务理念，百联保利用互联网平台优势并结合保险的市场作用，将与保证金、银行保函、担保公司保函具备同等效力的保证保险保函纳入经贸合作的担保形式之一，旨在减轻企业资金负担，简化申办流程，缩短办理周期，为企业客户提供低成本、高效率、安全专业的新型互联网金融服务。">

<title>百联保—保单查询</title>
<link rel="stylesheet" type="text/css" href="<c:url value='/resources/css/public.css' />" />
<link rel="stylesheet" type="text/css" href="<c:url value='/resources/css/inquire.css' />" />
<link href="<c:url value='/resources/css/personal_center.css' />" rel="stylesheet" type="text/css" />

</head>
<body>
	<jsp:include page="../../header.jsp"/>
	<!-- 保单查询 内容部分  开始 -->
        <div class="inqu_war">
        <div class="clear"></div>
        	<div class="inqu_sub"><!-- inqu_sub start -->
            	<div class="chit_war">
                	<div class="policy_inqu">
                    	<h4>保单查询</h4>
                        <p>请选择您要查询保单的险种</p>
                    </div>
                    <form id="policySerchForm" method="post">
                    <div class="policy_input">
                    	<p>
                        	<span class="pi_1"><strong>*</strong>输入保单号</span>
                            <span class="pi_2"><input type="text" name="policySerialNumber" id="policySerialNumber"></span>
                            <%-- <label class="hint_red"><img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空"></label> --%>
                        </p>
                        <div class="clear"></div>
                        <p>
                        	<span class="pi_1"><strong>*</strong>被保险人姓名</span>
                            <span class="pi_2"><input type="text" name="name" id="name"></span>
                            <%-- <label class="hint_red"><img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空"></label> --%>
                        </p>
                        <div class="clear"></div>
                        <p class="pi_verifi">
							<span class="pi_1">验证码</span>
							<span><input type="text" id="ryzm" name='j_captcha' onblur="checkYzm(this)" placeholder="输入验证码"></span>
							<label class="pi_yard"><img id="imageF" src="<c:url value='/user/image.htm'/>" onclick="changeImg()" width="100%" /></label>
							<label class="hint_red"><img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="不能为空"></label>
						</p>
                        <div class="clear"></div>
                        <div class="inquire_bnt"><a href="javascript:void(0);" id="policySerchUp" onclick="policySearch();">查询保单</a></div>
                    </div>
                    </form>
                    <div class="clear"></div>
	                <div id="policyMsg">  
	                	
	            	</div>
                </div>
                
            </div><!-- inqu_sub end -->
            <div class="clear"></div>
            
        </div>
		<!-- 保单查询 内容部分  结束 -->
	
	<jsp:include page="../../index/multi_f.jsp" />
</body>

<script src="<c:url value='/resources/script/jquery-1.8.3.min.js' />" type="text/javascript"></script>
<script src="<c:url value='/resources/js/insurance.js' />" type="text/javascript"></script>

<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';
$(function(){
	$(".nav ul li").each(function(){
		$(this).attr("class","");
	});
	var co = 1;
	$(".nav ul li").each(function(){
		if(co == 4){
			$(this).attr("class","active");
		}
		co ++;
	});
	winH();
});
$(function(){
	$("#policySerchForm").keydown(function(e){
		 var e = e || event,
		 keycode = e.which || e.keyCode;
		 if (keycode==13) {
		  	$("#policySerchUp").trigger("click");
		 }
	});
});

/*** 修改验证码图*/
function changeImg() {  
    $('#imageF').hide().attr('src','<c:url value='/user/image.htm'/>'+ '?'+ Math.floor(Math.random() * 100)).fadeIn();  
}

/** 校验验证码 */
function checkYzm(obj) {
	console.log(obj);
	if (obj.value == "" || $("#ryzm").val() == $("#ryzm").attr("defaultValue")) {
		$("#ryzm").parent().next().next().children().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="验证码不能为空">');
		$("#ryzm").parent().next().next().children().attr("style","display:block;");
		return false;
	}else{
    	$("#ryzm").parent().next().next().children().attr("style","display:none;");
    }
	
	if (obj.value != $("#ryzm").attr("defaultValue") && obj.value != "") {
		$.ajax({
			type : 'POST',
			url : baseUrl + "/user/register/checkYzm.json",
			data : {
				'captcha' : obj.value
			},
			dataType : "json",
			success : function(json) {
				if (json.statusCode == '300') {
					$("#ryzm").parent().next().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="验证码错误">');
		    		$("#ryzm").parent().next().next().attr("style","display:block;");
					changeImg();
					$("#ryzm").val($("#ryzm").attr("defaultValue"));
					$("#ryzm").focus();
				}else{
		        	$("#ryzm").parent().next().next().attr("style","display:none;");
		        }
			}
		});
	}
}

function policySearch(){
	var policySerialNumber = $("#policySerialNumber").val();
	var name = $("#name").val();
	if ( policySerialNumber == "" || $("#policySerialNumber").val() == $("#policySerialNumber").attr("defaultValue")) {
		$("#policySerialNumber").parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="保单号不能为空">');
		$("#policySerialNumber").parent().next().attr("style","display:block;");
		return false;
	}else{
    	$("#policySerialNumber").parent().next().attr("style","display:none;");
    }
	
	if ( name == "" || $("#name").val() == $("#name").attr("defaultValue")) {
		$("#name").parent().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="保单号不能为空">');
		$("#name").parent().next().attr("style","display:block;");
		return false;
	}else{
    	$("#name").parent().next().attr("style","display:none;");
    }
	
	if ($("#ryzm").val() == "" || $("#ryzm").val() == $("#ryzm").attr("defaultValue")) {
		$("#ryzm").parent().next().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="验证码不能为空">');
		$("#ryzm").parent().next().next().attr("style","display:block;");
		return false;
	}else{
    	$("#ryzm").parent().next().next().attr("style","display:none;");
    }
	
	$.ajax({
		type : 'POST',
		url : baseUrl + "/user/register/checkYzm.json",
		data : {
			'captcha' : $("#ryzm").val()
		},
		dataType : "json",
		success : function(json) {
			if (json.statusCode == '300') {
				$("#ryzm").parent().next().next().html('<img src="<c:url value='/resources/images/reg_error.png' />" width="18" height="18" title="验证码错误">');
	    		$("#ryzm").parent().next().next().attr("style","display:block;");
				changeImg();
				$("#ryzm").val($("#ryzm").attr("defaultValue"));
				$("#ryzm").focus();
			}else{
				$.ajax({
					type: 'POST',
					url: baseUrl + "/synopsis/search/policySearch",
					data:$("#policySerchForm").serialize(),
					dataType:"html",
					cache: false,
					success: function(data){
						$("#policyMsg").html(data);
					}
				}); 
	        }
		}
	});
	
}
function winH(){
	var inqu_subH = $(".inqu_sub").outerHeight();
	var bzbx_topwarH = $(".bzbx_topwar").outerHeight();
	var bzbx_navwarH = $(".bzbx_navwar").outerHeight();
	var heightFooterH = $(".heightFooter").outerHeight();
	var windowHight = $(window).height();//浏览器窗口高度
	var tbH = bzbx_topwarH + bzbx_navwarH + heightFooterH;
	if(tbH + inqu_subH < windowHight){
		var sH = windowHight - tbH - inqu_subH;
		$(".inqu_sub").css("height",inqu_subH + sH - 31);
	}
}
</script>
</html>
