<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
<meta name="keywords" content="百联保">
<meta name="description" content="">
<title>百联保—产品详情页</title>
<link rel="stylesheet" type="text/css" href="<c:url value='/resources/css/public.css' />" />
<link rel="stylesheet" type="text/css" href="<c:url value='/resources/css/details.css' />" />

</head>
<body>
	<jsp:include page="../header.jsp"/>
	<div class="clear"></div>
		<!-- 产品详情页 开始 -->
        <div class="det_content">
        	<!-- 产品详情页 导航 开始 -->
            <div id="subNav">
            	<div class="det_nav">
                    <h4><a href="#getback">${context.name }</a></h4>
                    <ul class="wrap">
                        <li class="adv_active"><a href="#product_feature" class="adv_product adv_active">产品特点</a></li>
                        <li><a href="#safeguard_plan" class="adv_plan">保障计划</a></li>
                        <li><a href="#claims_process" class="adv_process">理赔流程</a></li>
                        <li><a href="#insurance_clause" class="adv__clause">保险条款</a></li>
                    </ul>
                    <div class="promptly_buy"><a href="<c:url value='/product/sale/${context.logoName}/${context.oid }/0?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">立即购买</a></div>
                </div>
            </div>
            <!-- 产品详情页 导航 结束 -->  
            <c:if test="${context.productType eq 'CONBID' && context.productClass eq 'JGL'  }">
            <!-- 工程投标保证保险 开始 -->
            <div class="clear"></div>
            <div class="engin_war">
            	<div class="engin_sub">
                	<h3>${context.name }(${context.productClass.name })</h3>
                    <p>低成本、高效率、 手续简、速度捷  </p>
                    <p>投标保证不犹豫！</p>
                    <div class="eng_img">
                        <div class="img_big">
                            <img src="<c:url value='/resources/images/engin_img2.png' />" width="656" height="318" title="${context.name }">
                        </div>
                        <div class="img_small">
                            <img src="<c:url value='/resources/images/engin_img1.png' />" width="289" height="231" title="${context.name }">
                        </div>
                    </div>
                </div>
            </div>
            <!-- 工程投标保证保险 结束 -->
            </c:if><c:if test="${context.productType eq 'CONBID' && context.productClass eq 'ZCL'  }">
            <!-- 工程投标保证保险 开始 -->
            <div class="clear"></div>
            <div class="zhengcai_war">
            	<div class="zhengcai_sub">
                    <div>
                    	<h3>${context.name }<br/>(${context.productClass.name })</h3>
                    </div>
                    <div>
                    	<img src="<c:url value='/resources/images/zhengcai_img2.png' />" width="275" height="259" title="工程投标保证保险(政采类)">
                    </div>
            	</div>
            </div>
            <!-- 工程投标保证保险 结束 -->
            </c:if><c:if test="${context.productType eq 'PERFORMANCE' }">
            <!-- 建设合同履约保证保险 开始 -->
            <div class="clear"></div>
            <div class="contract_war">
            	<div class="contract_sub">
                    <div>
                    	<h3>${context.name }</h3>
                    </div>
                    <div>
                    	<img src="<c:url value='/resources/images/contract_img2.png' />" width="239" height="274" title="${context.name }">
                    </div>
            	</div>
            </div>
            <!-- 建设合同履约保证保险 结束 -->
             </c:if><c:if test="${context.productType eq 'CONQUALITY' }">     
            <!-- 建设工程质量保证保险 开始 -->
            <div class="clear"></div>
            <div class="quality_war">
            	<div class="quality_sub">
                	<div>
                    	<h3>${context.name }</h3>
                    </div>
                    <div>
                    	<img src="<c:url value='/resources/images/quality_img2.png' />" width="296" height="231" title="${context.name }">
                    </div>
                </div>
            </div>
            <!-- 建设工程质量保证保险 结束 -->
            </c:if><c:if test="${context.productType eq 'WAGEPAY' }">
            <!-- 建筑业企业人工 开始 -->
            <div class="clear"></div>
            <div class="build_war">
            	<div class="build_sub">
                	<div>
                    	<h3>${context.name}</h3>
                    </div>
                    <div>
                    	<img src="<c:url value='/resources/images/build_img2.png' />" width="250" height="314" title="${context.name}">
                    </div>
                </div>
            </div>
            <!-- 建筑业企业人工 结束 -->
            
            </c:if><c:if test="${context.productType eq 'CONBID' || context.productType eq 'WAGEPAY' || context.productType eq 'CONQUALITY' || context.productType eq 'PERFORMANCE' }">
            <!-- 产品特点 开始-->
            <div class="clear"></div>
            <div id="product_feature">
            	<div class="feature_war">
                	<div class="feature_left">
                		<p>马上投保，立享超值保障</p>
                	<c:if test="${context.productType eq 'CONBID' && context.productClass eq 'JGL'  }">
                		<p>给企业一份<label>安心与承诺</label></p>
                        <p>特省心：<label>轻松购买，省心安心</label></p>
                        <p>特全面：<label>适用于各建设工程投标保证</label></p>
                        <p>特划算：<label>低保费享高保障</label></p>
                	</c:if>
                	<c:if test="${context.productType eq 'CONBID' && context.productClass eq 'ZCL'  }">
                		<p>给您一份<label>安心与承诺</label></p>
                        <p>成本低：<label>保费低廉，不占用企业流动资金</label></p>
                        <p>时效高：<label>在线投保，即时生效</label></p>
                        <p>超便捷：<label>无需提供繁杂资信文件</label></p>
                	</c:if>
                	<c:if test="${context.productType eq 'WAGEPAY' }">
                		<p>给建筑从业者一份<label>安心与承诺</label></p>
                        <p>特省心：<label>轻松购买，省心安心</label></p>
                        <p>特全面：<label>适用于各建设业企业人工工资支付保证</label></p>
                        <p>特划算：<label>低保费享高保障</label></p>
                	</c:if>
                	<c:if test="${context.productType eq 'PERFORMANCE' }">
                		<p>给您一份<label>安心与承诺</label></p>
                        <p>特省心：<label>轻松购买，省心安心</label></p>
                        <p>特全面：<label>适用于各建设合同履约保证</label></p>
                        <p>特划算：<label>低保费享高保障</label></p>
                	</c:if>
                	<c:if test="${context.productType eq 'CONQUALITY' }">
                		<p>给您一份<label>安心与承诺</label></p>
                        <p>特省心：<label>轻松购买，省心安心</label></p>
                        <p>特全面：<label>适用于各建设工程质量保证</label></p>
                        <p>特划算：<label>低保费享高保障</label></p>
                	</c:if>
                    	
                        
                        
                        <ul>
                        	<li>
                                <p><img src="<c:url value='/resources/images/save_worry.png' />" width="50" height="50" title="省心"></p>
                                <p>省心</p>
                            </li>
                            <li>
                                <p><img src="<c:url value='/resources/images/overall.png' />" width="50" height="50" title="全面"></p>
                                <p>全面</p>
                            </li>
                            <li>
                                <p><img src="<c:url value='/resources/images/weigh.png' />" width="50" height="50" title="划算"></p>
                                <p>划算</p>
                            </li>
                        </ul>
                    </div>
                    <div class="feature_right">
                    	<img src="<c:url value='/resources/images/exchange2.png' />" width="250" height="427">
                    </div>
                </div>
            </div>
            <!-- 产品特点 结束--> 
            </c:if>
            
            <c:if test="${context.productType eq 'PACT' }">
            <!-- 业主合同款支付保证保险 开始 -->
            <div class="clear"></div>
            <div class="owner_war">
            	<div class="owner_sub">
                    <div>
                    	<h3>${context.name }</h3>
                    </div>
                    <div>
                    	<img src="<c:url value='/resources/images/owner_img2.png' />" width="307" height="303" title="${context.name }">
                    </div>
            	</div>
            </div>
            <!-- 业主合同款支付保证保险 结束 -->
            
            <!-- 产品特点 开始-->
            <div class="clear"></div>
            <div id="product_feature">
            	<div class="feature_war">
                	<div class="feature_left">
                    	<p>马上投保，立享超值保障</p>
                        <p>给企业一份<label>安心与承诺</label></p>
                        <p>特省心：<label>轻松购买，省心安心</label></p>
                        <p>特全面：<label>适用于各业主合同款支付保证</label></p>
                        <p>特划算：<label>低保费享高保障</label></p>
                        <ul>
                        	<li>
                                <p><img src="<c:url value='/resources/images/save_worry.png' />" width="50" height="50" title="省心"></p>
                                <p>省心</p>
                            </li>
                            <li>
                                <p><img src="<c:url value='/resources/images/overall.png' />" width="50" height="50" title="全面"></p>
                                <p>全面</p>
                            </li>
                            <li>
                                <p><img src="<c:url value='/resources/images/weigh.png' />" width="50" height="50" title="划算"></p>
                                <p>划算</p>
                            </li>
                        </ul>
                    </div>
                   
                    <div class="feature_right">
                    	<img src="<c:url value='/resources/images/exchange.png' />" width="503" height="279">
                    </div>
                </div>
            </div>
            <!-- 产品特点 结束--> 
            </c:if>
             <!-- 保障计划 开始-->
            <div id="safeguard_plan">
            	<div class="plan_war">
                	<p class="first_planp">低成本 适用于各${context.name }</p>
                    <div class="limit">
                    <c:if test="${planList.size()>1 }">
                    <c:forEach items="${planList }" var="list" varStatus="index">
                    	<!-- 额度1 开始 -->
                    	<div class="limit_sub" onClick="proPlanPath(${index.count },'${list.oid }')">
                        	<h4>${list.name }</h4>
                            <div class="plan_safeg">
                                <p><span>保障项目</span><span>保障额度</span></p>
                                <div class="clear"></div>
                                <c:forEach items="${list.amountSpec }" var="asc">
                                <p><span>${context.name }</span><span><strong>${asc.description }</strong></span></p>
                                </c:forEach>
                            </div>
                             <div class="clear"></div>
                            <div class="plan_check">
                            	<span>保费<strong>${list.premium }元</strong></span>
                                <%-- <input type="radio" id="chek${index.count }" name="planOid" value="${list.oid }" onclick="proPlanPath('${list.oid }')">
                                <label  for="chek${index.count }"></label> --%>
                                <img src="<c:url value='/resources/images/opt.jpg' />" width="37" height="37" class="img_none" id="ch_limit${index.count }">
                            </div>
                        </div>
                        <!-- 额度1 结束 -->
                   </c:forEach>
                   </c:if>	
                   <c:if test="${planList.size()==1 }">
                   <div class="limit_war">
                    <c:forEach items="${planList }" var="list" varStatus="index">
                    	<!-- 额度1 开始 -->
                    	<div class="limit_sub">
                        	<h4>${list.name }</h4>
                            <div class="plan_safeg">
                                <p><span>保障项目</span><span>保障额度</span></p>
                                <div class="clear"></div>
                                <c:forEach items="${list.amountSpec }" var="asc">
                                <p><span>${context.name }</span><span><strong>${asc.description }</strong></span></p>
                                </c:forEach>
                            </div>
                             <div class="clear"></div>
                            <div class="plan_check">
                            	<span class="lin_h5">
                                	<strong>超低保费</strong><br/><label id="proInfoLab">（保费数值根据项目而定）</label>
                                </span>
                            	<%-- <span><strong>超低保费</strong><br/>（保费数值根据项目而定）</span>
                                <input type="radio" id="chek${index.count }" name="planOid" value="${list.oid }" onclick="proPlanPath('${list.oid }')">
                                <label  for="chek${index.count }"></label> --%>
                            </div>
                        </div>
                        <!-- 额度1 结束 -->
                   </c:forEach>
                   </div>
                   </c:if>	                       
                    </div>
                    <p class="last_planp">投保简单方便，保障全面，还等什么呢？</p>
                    <p class="plan_buy"><a id="proPlanPath" href="<c:url value='/product/sale/${context.logoName}/${context.oid }/0?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">立即购买</a></p>
                </div>
            </div>
            <!-- 保障计划 结束-->  
            
            
            <!-- 理赔流程 开始-->
            <div id="claims_process">
            	<div class="process_war">
                	<h4>理赔流程</h4>
                    <h5>需要理赔时，我们将为您提供快速便捷理赔申请服务。</h5>
                    <!-- 流程 开始 -->
                    <div class="flow_war">
                    	<div class="flow_sub">
                        	<label>1</label>
                            <div>
                            	<img src="<c:url value='/resources/images/upward.jpg' />" width="22" height="19" class="pos_img">
                            	<p><strong>拨打95500报案</strong></p>
                                <p>拨打全国统一报案电话95500。</p>
                            </div>
                        </div>
                        <div class="flow_sub">
                        	<label>2</label>
                            <div>
                            	<img src="<c:url value='/resources/images/upward.jpg' />" width="22" height="19" class="pos_img">
                            	<p><strong>准备材料</strong></p>
                                <p>服务人员告知需要准备哪些材料。</p>
                            </div>
                        </div>
                        <div class="flow_sub">
                        	<label>3</label>
                            <div>
                            	<img src="<c:url value='/resources/images/upward.jpg' />" width="22" height="19" class="pos_img">
                            	<p><strong>理赔手续</strong></p>
                                <p>带着材料到，找工作人员进行办理。</p>
                            </div>
                        </div>
                        <div class="flow_sub">
                        	<label>4</label>
                            <div>
                            	<img src="<c:url value='/resources/images/upward.jpg' />" width="22" height="19" class="pos_img">
                            	<p><strong>审核</strong></p>
                                <p>确属保险责任范围的事故，我们将在赔付协议达成后尽快赔款。</p>
                            </div>
                        </div>
                    </div>
                    <!-- 流程 结束 -->
                </div>
            </div>
            <!-- 理赔流程 结束-->

            <!-- 保险条款 开始-->
            <div id="insurance_clause">
            	<div class="clause_war">
                	<h4>${context.name }(${context.productClass.name })</h4>
                    <p>保险条款列表</p>
                    <p><img src="<c:url value='/resources/images/list.jpg' />" width="83" height="79" title="建设工程投标保证保险"></p>
                    <p><a href="<c:url value='/policy/clause/${context.oid }' />">《${context.name }条款》</a></p>
                </div>
            </div>
            <!-- 保险条款 开始-->
             
        </div>
        <!-- 产品详情页 结束 -->
	<jsp:include page="../index/multi_f.jsp" />
</body>

<script src="<c:url value='/resources/script/jquery-1.8.3.min.js' />" type="text/javascript"></script>
<script src="<c:url value='/resources/js/insurance.js' />" type="text/javascript"></script>

<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';
$(function(){
	//优势页面点击子导航
		var subNav_active = $(".adv_active");
		var subNav_scroll = function(target){
			subNav_active.removeClass	("adv_active");
			target.parent().addClass("adv_active");
			subNav_active = target.parent();
		};
		$("#subNav a").click(function(){
			subNav_scroll($(this));
			var target = $(this).attr("href");
			var targetScroll = $(target).offset().top - 80;
			$("html,body").animate({scrollTop:targetScroll},300);
			return false;
		});
		//页面跳转时定位
		if(window.location.hash){
			var targetScroll = $(window.location.hash).offset().top - 80;
			$("html,body").animate({scrollTop:targetScroll},300);
		}
		$(window).scroll(function(){
			var $this = $(this);
			var targetTop = $(this).scrollTop();
			var nav = $("#pfooter");
			if(nav.length){
				var footerTop = nav.offset().top;
			}
			var height = $(window).height();
			
			if (targetTop >= 300){
				$("#subNav").addClass("fixedSubNav");
				$(".empty-placeholder").removeClass("hidden");
			}else{
				$("#subNav").removeClass("fixedSubNav");
				$(".empty-placeholder").addClass("hidden");
			}
			if(targetTop < 500){
				subNav_scroll($(".adv_product"));
			}else if(targetTop > 920 && targetTop < 1020){
					subNav_scroll($(".adv_plan"));
			}else if(targetTop > 1020 && targetTop < 1520){
					subNav_scroll($(".adv_process"));
			}else if(targetTop > 1620 && targetTop < 2120){
					subNav_scroll($(".adv__clause"));
			}else if(targetTop > 2620 && targetTop < 3120){
					subNav_scroll($(".adv_payment"));
			}/*else if(targetTop > 3651 && targetTop < 4071){
					subNav_scroll($(".adv_promise"));
			}else if(targetTop > 4163 && targetTop < 4473){
					subNav_scroll($(".adv_ride"));
			}*/
			else if(targetTop > 3120){
				subNav_scroll($(".adv_finance"));
			}
		})
	}());
	
function proPlanPath(idCo,va_l) {
	if(idCo == "1"){
		$("#ch_limit1").addClass("img_block");
		$("#ch_limit2").removeClass("img_block");
		$("#ch_limit3").removeClass("img_block");
	}else if(idCo == "2"){
		$("#ch_limit2").addClass("img_block");
		$("#ch_limit1").removeClass("img_block");
		$("#ch_limit3").removeClass("img_block");
	}else if(idCo == "3"){
		$("#ch_limit3").addClass("img_block");
		$("#ch_limit1").removeClass("img_block");
		$("#ch_limit2").removeClass("img_block");
	}
	$("#proPlanPath").attr("href",baseUrl + "/product/sale/" + '${context.logoName}' + "/" + '${context.oid }' + "/" + va_l);
}
</script>
</html>
