<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<div class="tender-war">
	<div class="query-criteria">
		<form id="doSetAssignedForm">
			<div class="query-result">
				<table class="table">
					<thead>
					<tr>
						<th>产品名称</th>
						<th>产品类型</th>
						<th>价格</th>
						<th>供应商</th>
						<th>总佣金</th>
						<th>下级佣金</th>
					</tr>
					</thead>
					<tbody>
					<input name="resellerID" value="${resellerID }" type="hidden">
					<c:choose>
						<c:when test="${empty productList }">
							<tr><td colspan="6" style="text-align: center;">无查询结果</td></tr>
						</c:when>
						<c:otherwise>
							<c:forEach items="${productList }" var="product">
								<tr>
									<td title="${product.productName }">${product.productName }</td>
									<td title="${fns:getDictLabel (product.productType,'product_type','')}">${fns:getDictLabel (product.productType,"product_type","")}</td>
									<td>-<%--${empty product.premiumMin ? '-' : product.premiumMin eq '0.00' ? '-' : product.premiumMin }--%></td>
									<td title="${product.insuranceName }">${product.insuranceName }</td>
									<td>${product.totalRebate }%</td>
									<td>
										<input Data-Val="Required" type="text" id="junior_${product.oid }" style="width: 100px" value="" DATA-SG="${product.oid }" onblur="numVerify(this,'${product.totalRebate }')">%
										<input type="hidden" name="juniorBrokerage" id="hjunior_${product.oid }">
									</td>
								</tr>
							</c:forEach>
						</c:otherwise>
					</c:choose>
					</tbody>
				</table>
			</div>
			<div class="btn-bottom pull-right">
				<p>
					<a href="javascript:void(0);" onclick="openProductListToLast(${resellerID });" class="clearing pull-left">上一步</a>
					<a href="javascript:void(0);" onclick="doSetAssignedForm();" class="clearing pull-left">完成分配</a>
				</p>
			</div>
		</form>
	</div>
</div>
<script>
    /**
     * 提交 setAssignedForm 表单，做新增分配产品数据业务 productList_set.jsp页面中调用
     */
    function doSetAssignedForm(){
        var i=0;
        $("input[name='juniorBrokerage']").each(function(){
            var _n = $(this).val();
            if(_n == ''){
                i = 1;
                return false;
			}
		});
        if(i == 0){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $.ajax({
                type : 'POST',
                url : baseUrl + "/pc/reseller/setAssignedOfBrokerage",
                data : $('#doSetAssignedForm').serialize(),
                dataType : "json",
                success : function(data) {
                    layer.close(index);
                    layer.msg(data.message);
                    if(data.status == '200'){
                        assignedInitModelReset('${resellerID}');
                    }
                },
                error: function(){
                    layer.close(index);
                }
            });
        }
    }
    function numVerify(_this,_total){
        var result = $('#'+_this.id).val();
        if(result != ''){
            if(parseFloat(result).toString() != "NaN"&&parseFloat(result)>0){
                if(parseFloat(_total) >= parseFloat(result)){
                    $('#h'+_this.id).val($(_this).attr("DATA-SG")+';'+result);
                }else{
                    $('#'+_this.id).val('');
                    document.getElementById(_this.id).scrollIntoView();
                    layer.msg("分配佣金不能大于总拥金！");
                    $(_this).focus();
                }
            }else{
                $('#'+_this.id).val('');
                document.getElementById(_this.id).scrollIntoView();
                layer.msg("请输入正确的佣金！");
                $(_this).focus();
            }
        }else{
            document.getElementById(_this.id).scrollIntoView();
            layer.msg("必填项不能为空！");
            $(_this).focus();
        }
    }
</script>
