<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<form id="someAssignedCheckForm">
<h4 style="margin-top: 0;">已分配产品列表</h4>
<div class="query-result" id="assigned_pageResult">
	<table class="table">
		<thead>
			<tr>
				<th class="choice check-box"><input type="checkbox" value="反选" id="acball" onclick="choiseAll_x('acball','aoids');">
					<label for="acball"></label>
				</th>
				<th>ID</th>
				<th>产品名称</th>
				<th>产品类型</th>
				<th>价格</th>
				<th>总返佣</th>
				<th>分配返佣</th>
				<th>供应商</th>
			</tr>
		</thead>
		<tbody>
		<input name="resellerID" value="${resellerID }" type="hidden">
		<c:choose>
			<c:when test="${empty assignedList }">
				<tr><td colspan="8" style="text-align: center;">无查询结果</td></tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${assignedList }" var="assigned">
					<tr>
						<td class="choice check-box">
							<input type="checkbox" id="checkbox${assigned.oid }" value="${assigned.oid }" name="aoids" onclick="choiseOid_x('acball','aoids')">
							<label for="checkbox${assigned.oid }"></label>
						</td>
						<td title="${assigned.oid }">${assigned.oid }</td>
						<td title="${assigned.productName }">${assigned.productName }</td>
						<td title="${fns:getDictLabel (assigned.productType,'product_type','')}">${fns:getDictLabel (assigned.productType,"product_type","")}</td>
						<td>-<%--${empty assigned.premiumMin ? '-' : assigned.premiumMin eq '0.00' ? '-' : assigned.premiumMin }--%></td>
						<td>${assigned.totalRebate }%</td>
						<td>${assigned.brokerage }%</td>
						<td title="${assigned.insuranceName }">${assigned.insuranceName }</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
		</tbody>
	</table>
</div>
<div class="btn-bottom pull-right">
	<p>
		<a href="javascript:void(0);" onclick="deleteAssignedCheckBox('${resellerID}',$('input[name=aoids]:checked').length,$('#someAssignedCheckForm').serialize());" class="clearing pull-left" style="margin-right: 10px">删除</a>
		<a href="javascript:void(0);" onclick="openProductListModel('${resellerID}');" class="clearing pull-left">新增</a>
	</p>
</div>
</form>
<script>


	/*$(function(){
        getAssignedListForPage();
	});

	function getAssignedListForPage(){
		var index = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/pc/reseller/assignedList",
			data : $("#assignedForm").serialize(),
			dataType : "text",
			success : function(data) {
				layer.close(index);
				$("#assigned_pageResult").html(data);
			},
			error: function(){
				layer.close(index);
			}
		});
	}*/
	
	
	function deleteAssignedCheckBox(_resID,checkLength,someValueForm){
		layer.confirm('确定删除所选条目？', {
			  btn: ['确定','取消'] //按钮
			}, function(){
//				layer.closeAll();
				var index = layer.load(0, {shade: [0.3,'#808080']});
				if(checkLength >0){
					$.ajax({
						type : 'POST',
						url : baseUrl + "/pc/reseller/deleteSomeAssigned.json",
						data : someValueForm,
						dataType : "json",
						success : function(data) {
							layer.close(index);
							layer.msg(data.message);
							if(data.status=="200"){
                                assignedInitModelReset(_resID);
							}
						},
						error: function(){
							layer.close(index);
						}
					});
				}else{
					layer.msg("请选择需要删除条目！");
				}
			}, function(){			  
			});
	}
</script>