<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
	<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
	<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
	<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
	<title>百联保-我的账户</title>
</head>

<body>
<jsp:include page="../index/multi_h.jsp"/>
<div class="container">
	<div class="addr">
		<span>当前位置：</span>
		<span class="current">首页 > </span>
		<a class="active" href="<c:url value='/pc/index?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">我的账户</a>
	</div>
	<jsp:include page="../index/multi_pc_l.jsp"/>

	<!--右边常用联系人内容区开始-->
	<div class="right contacts">
		<div class="container real">

			<div class="step-title">
				<h1 class="title">实名认证</h1>
				<ul class="real-step" style="margin-left: 30%;">
					<li class="active">
						<span class="step-name">验证方式</span>
						<i class="step-left"></i>
						<span class="step-num">1</span>
						<i class="step-left step-right"></i>
					</li>
					<li>
						<span class="step-name">验证身份</span>
						<i class="step-left"></i>
						<span class="step-num">2</span>
						<i class="step-left step-right"></i>
					</li>
					<li>
						<span class="step-name">实名认证</span>
						<i class="step-left"></i>
						<span class="step-num">3</span>
						<i class="step-left step-right"></i>
					</li>
					<li>
						<span class="step-name">认证成功</span>
						<i class="step-left"></i>
						<span class="step-num">4</span>
						<i class="step-left step-right"></i>
					</li>
				</ul>
			</div>
			<div class="real-name real-methods" style="width: auto; margin-left: 0;">

				<ul class="step-list">
					<li class="pd-0">
						<span>账户：</span>
						<span class="tel-phone">
                           ${userdetail.login_name}
                    </span>
					</li>
					<li >
						<h4 class="real-method">请选择身份验证方式</h4>
						<h5 class="real-tel">验证手机号</h5>
						<span class="wty">通过您账户绑定的手机号${userdetail.telephone}进行身份验证</span>
						<c:if test="${empty userdetail.telephone}">
							<button type="button" class="btn real-btn tyu gray-btn">立即验证</button>
						</c:if>
						<c:if test="${not empty userdetail.telephone}">
							<button type="button" class="btn real-btn tyu"  onclick="phoneValidate()">立即验证</button>
						</c:if>
					</li>

					<li   class="no-border">
						<h5 class="real-email">验证邮箱</h5>
						<span class="wty">通过您账户绑定的邮箱${userdetail.email}进行身份验证</span>
						<%--<button type="button" class="btn real-btn" onclick="emailValidate()">立即验证</button>--%>
						<c:if test="${empty userdetail.email}">
							<button type="button" class="btn real-btn tyu gray-btn" >立即验证</button>
						</c:if>
						<c:if test="${not empty userdetail.email }">
							<button type="button" class="btn real-btn tyu" onclick="emailValidate()">立即验证</button>
						</c:if>
					</li>
				</ul>
			</div>
			<%--手机--%>
			<div id="phoneSet" class="real-name real-cart phone-val">
				<ul class="step-list">
					<li>
						<span>账户：</span>
						<span class="tel-phone">
							${userdetail.login_name}
						</span>
					</li>
					<li class="no-border">
						<h4 class="real-method">当前手机号：
							<span class="current-phone">${userdetail.telephone}</span>
						</h4>
						<div class="real-num">
							<label for="realNumPhone">验证码：</label>
							<input type="text" placeholder="请输入右侧验证码" id="realNumPhone" class="inp">
							<span class="real-map"  id="v_container_phone"></span>
						</div>
						<div class="real-num">
							<label for="realPhone">短信验证码：</label>
							<input type="text" placeholder="请输入手机验证码" name="realPhone" id="realPhone" class="inp">
							<button class="btn get-real phone-code">获取手机验证码</button>
						</div>
						<button class="btn next-btn" onclick="phoneValidateCode()">下一步</button>
					</li>
				</ul>
			</div>
			<%--邮箱--%>
			<div id="emailSet" class="real-name real-cart email-val">
				<ul class="step-list">
					<li>
						<span>账户：</span>
						<span class="tel-phone">
							${userdetail.login_name}
						</span>
					</li>
					<li class="no-border">
						<h4 class="real-method">当前邮箱号：
							<span class="current-phone">${userdetail.email}</span>
						</h4>
						<div class="real-num">
							<label for="realNumEmail">验证码：</label>
							<input type="text" placeholder="请输入右侧验证码" id="realNumEmail" class="inp">
							<span class="real-map"  id="v_container_email"></span>
						</div>
						<div class="real-num">
							<label for="realEmail">邮箱验证码：</label>
							<input type="text" placeholder="请输入邮箱验证码" id="realEmail" class="inp">
							<button class="btn get-real email-code">获取邮箱验证码</button>
						</div>
						<button class="btn next-btn" onclick="emailValidateCode()">下一步</button>
					</li>
				</ul>
			</div>

			<div class="real-name real-phone">

				<ul class="step-list">
					<li>
						<span>账户：</span>
						<span class="tel-phone">
							${userdetail.login_name}
                    </span>
					</li>
					<form method="post" id="form1">
						<li class="no-border">
							<div class="real-num">
								<label for="newPhone">姓名：</label>
								<input type="text" placeholder="请输入你的姓名" name="real_name" id="newPhone" class="inp sm-inp">
							</div>
							<div class="real-num">
								<label for="realCard">身份证号：</label>
								<input type="text" placeholder="请输入正确的身份证号" name="real_card" id="realCard" class="inp sm-inp">
							</div>
							<div class="real-num">
								<label for="v_container">验证码：</label>
								<input type="text" placeholder="请输入右侧验证码" id="v_container" class="inp">
								<span class="real-map"  id="v_container_code"></span>
							</div>
							<button class="btn next-btn" type="button"  onclick="subForm()">下一步</button>
						</li>
					</form>
				</ul>
			</div>
			<div class="real-name real-succ">

				<div class="real-text">实名认证成功！</div>
				<a href="<c:url value='/pc/myAccount?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="btn my-btn">我的资料</a>
				<a href="<c:url value='/?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="btn index-btn">首页</a>
			</div>
		</div>

	</div>
	<!--右边编辑常用联系人结束  企业用户-->

</div>
<jsp:include page="../index/multi_f.jsp"/>

</body>

</html>
<script src="<c:url value='/resources/version_new/js/jquery-1.8.3.min.js' />"></script>
<script src="<c:url value='/resources/version_new/js/gVerify.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>

<script type="text/javascript">

	var verifyCode0 = new GVerify({
		id: "v_container_phone",
				canvasId: "verifyCanvas0"
	});
	var verifyCode1 = new GVerify({
		id: "v_container_email",
				canvasId: "verifyCanvas1"
	});
	var verifyCode2 = new GVerify({
		id: "v_container_code",
				canvasId: "verifyCanvas2"
	});

	var baseUrl = '${pageContext.request.contextPath }';

	$('.email-code').click(function () {
		sendTrueEmail();
		sendemail();
	});
	var countdown=60;
	function sendemail() {
		if (countdown == 0) {
			$('.email-code').text("获取邮箱验证码").css({"background":"rgba(69,190,86,1)","color":"#ffffff","cursor":"pointer","pointer-events":"auto"});
			countdown = 60;
			return;
		} else {
			$('.email-code').text("再次发送(" + countdown + ")").css({"background":"rgba(236,236,236,1)","color":"rgb(153,153,153)","cursor":"default","pointer-events":"none"});
			countdown--;
		}
		setTimeout(function() {
					sendemail()
				}
				,1000)
	};

	$('.phone-code').click(function () {
		sendTruePhone();
		sendphone();

	});
	var count=60;
	function sendphone() {


		if (count == 0) {
			$('.phone-code').text("获取短信验证码").css({"background":"rgba(69,190,86,1)","color":"#ffffff","cursor":"pointer","pointer-events":"auto"});
			count = 60;
			return;
		} else {
			$('.phone-code').text("再次发送(" + count + ")").css({"background":"rgba(236,236,236,1)","color":"rgb(153,153,153)","cursor":"default","pointer-events":"none"});
			count--;
		}
		setTimeout(function() {
					sendphone()
				}
				,1000)
	};

	function   sendTrueEmail(){
		var index = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/pc/sendEmailCode",
			async: false,
			dataType : "json",
			cache : false,
			success : function(json) {
				layer.close(index);
				if (json.statusCode == '200') {
					layer.msg("验证码获取成功,请查收邮件并进行验证！！");
					layer.close(index);
				}
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {
				layer.msg("验证码获取失败！！");

			}
		});
	}
	function sendTruePhone(){
		var index = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/pc/sendAuthCode",
			async: false,
			dataType : "json",
			cache : false,
			success : function(json) {
				layer.close(index);
				if (json.statusCode == '200') {
					layer.msg("验证码获取成功,请查收手机并进行验证！！");
					layer.close(index);
				}
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {
				layer.msg("验证码获取失败！！");

			}
		});
	}


	function phoneValidate(){
//		nextStep('real-cart','next-btn','real-phone',3);
		$("#emailSet").css('display', 'none');
		$("#phoneSet").css('display', 'block');
		nextStep('real-methods','step-list li:nth-child(2) .real-btn','phone-val',2);

	}
	function  emailValidate(){
		$('.real-methods').css('display','none');
		$("#phoneSet").css('display', 'none');
		$("#emailSet").css('display', 'block');
		$('.real-step li:nth-child(2)').addClass('active');
		nextStep('real-methods','step-list li:nth-child(2) .real-btn','email-val',2);
	}
	function   emailValidateCode(){
		var  emailNumCode=$('#realNumEmail').val();
		var  emailCode=$('#realEmail').val();
		if(emailNumCode==''){
			layer.msg("验证码不能为空！");
			return ;
		}
		if(emailCode==''){
			layer.msg("邮箱验证码不能为空！");
			return ;
		}
		var res = verifyCode1.validate(emailNumCode);
        if(res){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $.ajax({
                type : 'POST',
                url : baseUrl + "/pc/checkAuthCode",
                data:{code:emailCode},
                async: false,
                dataType : "json",
                cache : false,
                success : function(json) {
                    layer.close(index);
                    if (json.statusCode == '200') {
                        nextStep('real-cart','next-btn','real-phone',3);
                        layer.close(index);
                    }else{
                        layer.msg("邮箱验证码错误，请重新输入！");

                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg("验证码获取失败！！");

                }
            });

        }else{
            layer.msg("验证码错误，请重新输入！");
            return ;

        }

	}
	function   phoneValidateCode(){
		var  phoneCode=$("#realPhone").val();
		var  code=$("#realNumPhone").val();
		if(code==''){
			layer.msg("验证码不能为空！");
			return ;
		}
		if(phoneCode==''){
			layer.msg("短信验证码不能为空！");
			return ;
		}
		var res = verifyCode0.validate(code);
		if(res){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/pc/checkAuthCode",
				data:{code:phoneCode},
				async: false,
				dataType : "json",
				cache : false,
				success : function(json) {
					layer.close(index);
					if (json.statusCode == '200') {
						nextStep('real-cart','next-btn','real-phone',3);
						layer.close(index);
					}else{
						layer.msg("短信验证码错误，请重新输入！");

					}
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.msg("验证码获取失败！！");

				}
			});

		}else{
			layer.msg("验证码错误，请重新输入！");
			return ;

		}

	}

	function nextStep(now, btn, next, num) {
		$('.' + now).on('click', '.' + btn, function () {
			$('.' + now).css('display', 'none');
			$('.' + next).css('display', 'block');
			$('.real-step li:nth-child(' + num + ')').addClass('active');
		});
	}
	function   subForm(){
		var  code=$('#v_container').val();
		var res = verifyCode2.validate(code);
		if(res){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/pc/realNameAuthentication/saveInfo",
				data:$('#form1').serialize(),
				async: false,
				dataType : "json",
				cache : false,
				success : function(json) {
					layer.close(index);
					if (json.statusCode == '200') {
						layer.close(index);
						layer.msg("修改成功！");
						nextStep('real-phone','next-btn','real-succ',4);
					}else{
						layer.msg("信息填写不完整！");
					}
				},
				error : function(XMLHttpRequest, textStatus, errorThrown) {
					layer.msg("信息填写不完整！");

				}
			});

		}else{
			layer.msg("请输入正确的验证码");
		}
	}

</script>
<script>
	$('ul.aside-list li').removeClass('on');
	$("#myAcountInfo").addClass('on');
</script>

