<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-我的账户</title>
	</head>

	<body style="position: relative">
	<jsp:include page="../../../index/multi_h.jsp"/>
	<div class="container">
		<%--<div class="addr">
			<span>当前位置：</span>
			<span class="current">首页 > </span>
			<a class="active" href="#">我的账户</a>
		</div>--%>
		<jsp:include page="../../../index/multi_pc_l.jsp"/>

		<!--右边内容块-->
		<ul class="order-list wed-list" id="wed-list">
			<li class="active">在保人员</li>
			<li onclick="openNoResultSet()">已失效成员</li>
			<li onclick="openRecordList();">批改申请记录</li>
		</ul>
		<div class="assure-safe tab-con">
			<div class="assure-head">
				<p>关键字</p>
				<div class="assure-input">
					<input type="text" id="keyword_it" value="${keyword }" placeholder="请填写姓名/手机号/证件号">
					<span onclick="searchList()">搜索</span>
				</div>
			</div>
			<div class="assure-text">
				<ul class="clearfix">
					<li class="assure-logo">
						<c:if test="${not empty orderVo.insurance_logo && fn:contains(orderVo.insurance_logo, '?')}">
							<img src="${orderVo.insurance_logo}" style="width: 196px" />
						</c:if>
					</li>
					<li >
						<p><strong>${orderVo.product_name}</strong></p>
						<p>保单号: <i>${orderVo.external_reference}</i></p>
						<p>起保日期: <i>${orderVo.inception_date}</i></p>
					</li>
					<li class="assure-cao">
						<%--<c:if test="${fn:contains(orderVo.product_code,'TYX-HT-DQ')}">
							<span onclick="do_preservation('add');" class="s1">增员</span>
						</c:if>--%>
						<c:if test="${!fn:contains(orderVo.product_code,'TYX-QH-DQ')&&!fn:contains(orderVo.product_code,'TYX-HT-DQ')}">
							<span onclick="do_preservation('add');" class="s1">增员</span>
							<c:if test="${!fn:contains(orderVo.product_code, 'GZZRX-CA-DQ')&&orderVo.inception_type != '2'}">
							<span onclick="do_preservation('minus');" class="s2">减员</span>
							</c:if>
							<span onclick="do_preservation('replace');" class="s3">替换</span>
						</c:if>
						<c:if test="${fn:contains(orderVo.product_code,'TYX-QH-DQ')||fn:contains(orderVo.product_code,'TYX-HT-DQ')}">
							<span onclick="do_preservation('replace');" class="s3">替换</span>
						</c:if>
						<span onclick="down_result_set('${orderVo.oid}');" class="ds3" style="padding-left: 20px;">人员下载</span>
					</li>
				</ul>
			</div>
			<form id="preservationForm">
				<input type="hidden" name="policyId" id="policyId" value="${orderVo.oid}">
				<input type="hidden" name="operate" id="operate">
				<div class="assure-cont tab-order">
					<div id="resultSetsArea">
						<div class="cont-sd">
							<ul class="cont-head clearfix">
								<li class="cont-s1">
									<input type="checkbox" name="securityScopes" id="securityScope" value="1">
									<label for="securityScope" class="pull-left"></label>
									<strong>全选</strong>
								</li>
								<li class="cont-s1">
									<span>姓名</span>
								</li>
								<li class="cont-s1">
									<span>证件类型</span>
								</li>
								<li class="cont-s2">
									<span>证件号</span>
								</li>
								<li class="cont-s3">
									<span>手机号</span>
								</li>
								<li class="cont-s1">
									<span>工种</span>
								</li>
								<li class="cont-s1">
									<span>出生日期</span>
								</li>
<%--
								<li class="cont-s1">
									<span>方案</span>
								</li>
--%>
							</ul>
						</div>
						<div class="cont-wed">
							<ul>
								<c:choose>
									<c:when test="${empty resultSetList }">
										<li class="clearfix" style="text-align: center;line-height: -moz-block-height;">
											暂无记录！！
										</li>
									</c:when>
									<c:otherwise>
										<c:forEach items="${resultSetList }" var="resultSet" varStatus="i">
											<li class="clearfix">
												<div class="wed-select wed-qwe cont-s1">
													<c:if test="${empty resultSet.ins_preservation_result_set_id }">
														<input type="checkbox" name="oids" id="oids_${i.index}" value="${resultSet.belong_to_id };${resultSet.belong_to_type }" onchange="checkOnly(this,'checkSome')">
													</c:if>
													<c:if test="${not empty resultSet.ins_preservation_result_set_id }">
														<input type="checkbox" name="oids" id="oids_${i.index}" value="${resultSet.ins_preservation_result_set_id };THIS" onchange="checkOnly(this,'checkSome')">
													</c:if>
													<label for="oids_${i.index}" class="pull-left"></label>
												</div>
												<div class="wed-select cont-s1">
													<span>${resultSet.name }</span>
												</div>
												<div class="wed-select cont-s1">
													<span>
														<c:if test="${empty resultSet.id_type}">-</c:if>
														${fns:getDictLabel (resultSet.id_type,"idType","")}
													</span>
												</div>
												<div class="wed-select cont-s2">
													<span>${resultSet.id_card }</span>
												</div>
												<div class="wed-select cont-s3">
													<span>${resultSet.tel }</span>
												</div>
												<div class="wed-select cont-s1">
													<span>${resultSet.career eq '1' ? '内勤人员' : resultSet.career eq '2' ? '保安人员' : resultSet.career eq '3' ? '武装押运人员' : resultSet.career eq '4' ? '保洁人员' : '-'}</span>
												</div>
												<div class="wed-select cont-s1">
													<span>${resultSet.birthday }</span>
												</div>
											</li>
										</c:forEach>
									</c:otherwise>
								</c:choose>
							</ul>
						</div>
					</div>
					<p class="cont-number">
						共<i>${dwzPage.totalCount}</i>人，已选择<b id="checkSomeView">0</b>人
						<input type="hidden" name="check_some" id="checkSome">
					</p>
					<!--分页-->
					<div class="filter-pagination" style="padding-top:10px;">
						<div style="width: 110px;float:  left;">每页
							<select id="sPage" style="float: unset;padding: 0 5px;height: 29px;margin-right: 5px" onchange="changeSPage()">
								<option value="10" selected>10</option>
								<option value="50">50</option>
								<option value="100">100</option>
								<option value="250">250</option>
							</select>条
						</div>
						<div id="callBackPager"></div>
					</div>
					<%--<ul class="paper-num">

					</ul>--%>
				</div>
			</form>
		</div>
	</div>

	<div class="clearfix"></div>
	<form id="resultSetForm" action="<c:url value='/pc/preservation/resultSet/resultSetList?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post">
		<input type="hidden" name="policyId" value="${orderVo.oid}"/>
		<input type="hidden" id="keyword" name="keyword" value="${keyword }"/>
		<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
		<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
		<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
	</form>
	</div>


	<!--新增人员弹窗-->
	<div class="increased-styles news-increased animated" style="position: absolute!important;">
		<div class="payment-head">
			<span>新增人员</span>
			<a href="javascript:;" id="news-bi">
				<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
			</a>
		</div>
		<div id="add-increased">

		</div>
	</div>

	<!--减少人员弹窗-->
	<div class="increased-styles redues-increased animated" style="position: absolute!important;">
		<div class="payment-head">
			<span>减少人员</span>
			<a href="javascript:;" id="redues-bi">
				<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
			</a>
		</div>
		<div id="minus-increased">

		</div>
	</div>

	<!--人员替换弹窗-->
	<div class="increased-styles replaces-increased animated" style="position: absolute!important;">
		<div class="payment-head">
			<span>人员替换</span>
			<a href="javascript:;" id="replaces-bi">
				<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
			</a>
		</div>
		<div id="replace-increased">

		</div>
	</div>

	<!--方案弹窗-->
	<div class="scheme-incre animated">
		<div class="scheme-head">
			<span>方案</span>
			<a href="javascript:;" id="popo-bi">
				<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
			</a>
		</div>
		<div class="scheme-content" id="scheme_detail">

		</div>
	</div>

	<!--黑色蒙版-->
	<div class="black-mask"></div>

	<jsp:include page="../../../index/multi_f.jsp"/>

	</body>
	<%--<script type="text/javascript" src="<c:url value='/resources/versions-2.0.2/js/laydate.js' />"></script>--%>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0.2/js/assure.js' />"></script>
	<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
	<script type="text/javascript" src="<c:url value='/resources/version_new/js/FileSaver.js'/>"></script>
	<script type="text/javascript">
		var baseUrl = '${pageContext.request.contextPath }';
        $(function () {
            function mouse(even, stat, iconA, iconB) {
                $('.order-detail').on(even, '.guar', function () {
                    $(this).siblings('.guar-list').css('display',stat);
                    $(this).find('.' + iconA).removeClass(iconA).addClass(iconB);
                });
            }
            //鼠标移动到元素上显示
            mouse('mouseenter', 'block', 'down-icon', 'up-icon');
            //鼠标移出元素
            mouse('mouseleave', 'none', 'up-icon', 'down-icon');
        })
        var totalCount = Number($('#totalCount').val()) || 0;
        var showCount = $('#showCount').val() || 5;
        var limit = Number($('#numPerPage').val()) || 5;

        $('#callBackPager').extendPagination({
            totalCount: totalCount,
            showCount: showCount,
            limit: limit,
            callback: function (curr, limit, totalCount) {
                getListForPage("resultSetForm","resultSetsArea");
            }
        });

        function searchList(){
            $("#pageNum").val(1);
//            $("#numPerPage").val(5);
//            $("#totalCount").val(0);
            var keyword_it = $("#keyword_it").val();
            $("#keyword").val(keyword_it);
            $("#resultSetForm").submit();
        }

        function openNoResultSet(){
            location.href=baseUrl+'/pc/preservation/resultSet/noResultSetList?policyId=${orderVo.oid}&ACCESS_TOKEN=${ACCESS_TOKEN}';
        }

        function openRecordList(){
            location.href=baseUrl+'/pc/preservation/recordList?ACCESS_TOKEN=${ACCESS_TOKEN}';
        }

        function down_result_set(oid){
            location.href=baseUrl+'/pc/preservation/resultSet/down_result_set/'+oid+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
        }

        function do_preservation(_status){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            if("add" == _status){
                if($("#policyId").val()!=''){
                    $('.news-increased').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
                    $('.black-mask').show();
                    $("#operate").val('add');
                    $.ajax({
                        type : 'POST',
                        url : baseUrl + "/pc/preservation/resultSet/add_preservation_view?ACCESS_TOKEN=${ACCESS_TOKEN}",
                        data : $("#preservationForm").serialize(),
                        dataType : "html",
                        success : function(data) {
                            $("#add-increased").html(data);
                            layer.close(index);
                        },
                        error: function(){
                        	layer.close(index);
                        }
                    });
                }else{
                    layer.msg("未匹配到对应订单！");
				}
			}else if("minus" == _status){
                if($("#checkSome").val()!=''){
                    $('.redues-increased').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
                    $('.black-mask').show();
                    $("#operate").val('minus');
                    $.ajax({
                        type : 'POST',
                        url : baseUrl + "/pc/preservation/resultSet/minus_or_replace_view?ACCESS_TOKEN=${ACCESS_TOKEN}",
                        data : $("#preservationForm").serialize(),
                        dataType : "html",
                        success : function(data) {
                            $("#minus-increased").html(data);
                            layer.close(index);
                        },
                        error: function(){
                            layer.close(index);
                        }
                    });
                }else{
                    layer.msg("请勾选将要减员的人员！");
                    layer.close(index);
                }

            }else if("replace" == _status){
                if($("#checkSome").val()!=''){
                    $('.replaces-increased').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
                    $('.black-mask').show();
                    $("#operate").val('replace');
                    $.ajax({
                        type : 'POST',
                        url : baseUrl + "/pc/preservation/resultSet/minus_or_replace_view?ACCESS_TOKEN=${ACCESS_TOKEN}",
                        data : $("#preservationForm").serialize(),
                        dataType : "html",
                        success : function(data) {
                            $("#replace-increased").html(data);
                            layer.close(index);
                        },
                        error: function(){
                            layer.close(index);
                        }
                    });
                }else{
                    layer.msg("请勾选将要替换的人员！");
                    layer.close(index);
                }

            }
		}
        /**
		 * 减员时检索总人数与勾选减员人数，如果相减人数低于3返回0（不能减员），否则返回1（可做减员）
         * @param id
         * @returns {number}
         */
		function minusLastNum(id){
            var tol = Number($("#"+id).parent().find("i").html());
            var checkTol = Number($("#"+id).parent().find("b").html());
            if(tol === 3 || (tol-checkTol)<3){
                return 0;//不能做减员
            }else{
                return 1;//可以做减员
			}
		}

		function do_scheme(){
            $.ajax({
                type : 'POST',
                url : baseUrl + "/pc/preservation/resultSet/schemeDetail?ACCESS_TOKEN=${ACCESS_TOKEN}",
                data : {
                    policyId : '${orderVo.oid}'
				},
                dataType : "html",
                success : function(data) {
                    $("#scheme_detail").html(data);
                },
                error: function(){
                }
            });
		}

        function save_preservation(_sign){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $("#add_sign").val(_sign);
            var isT = 0;
            if(_sign == '1'){
                isT = submitFormValidator('add_detail_list_form');
            }
            if(isT == 0){
                $.ajax({
                    type : 'POST',
                    url : baseUrl + "/pc/preservation/resultSet/add_preservation_service?ACCESS_TOKEN=${ACCESS_TOKEN}",
                    data : $("#add_detail_list_form").serialize(),
                    dataType : "json",
                    success : function(data) {
                        if(data.statusCode == "200"){
							$('.news-increased').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
							$('.black-mask').hide();
							if(data.forwardUrl && data.forwardUrl != 'null'){
								window.open(data.forwardUrl);
								layer.confirm('已完成在线支付？（批改结果预计将在1分钟后更新，请注意查看“批改申请记录”状态）', {  btn: ['是', '否'] }, function () {
									location.reload();
								});
							}else{
								layer.msg(data.message,{time:3000});
								setTimeout(function(){
									location.reload();
								},2000);
							}
                        }else{
                            if(data.message.indexOf('部分证件号已在保，无法重复投保：')!=-1){
                                layer.msg("部分证件号已在保，无法重复投保!",{time:2000});
                                var reg = new RegExp(',','g');
                                var blob = new Blob(['(注：以下证件号已在保，请检查并剔除后重新提交。)\n'+data.message.split('：')[1].replace(reg,'\n')], {type: "text/plain;charset=utf-8"});
                                saveAs(blob, "人员重复投保清单.txt");
                            }else{
                                if(data.message.length>50){
                                    layer.msg(data.message,{time:5000});
								}else{
                                    layer.msg(data.message,{time:2000});
                                }
                            }
                        }
                        layer.close(index);
                    },
                    error: function(){
                        layer.close(index);
                    }
                });
			}else{
                layer.close(index);
			}
        }
        function minus_save_preservation(_sign){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $("#minus_sign").val(_sign);
            var isT = 0;
            if(_sign == '1'){
                isT = submitFormValidator('minus_detail_list_form');
            }
            if(isT == 0){
                $.ajax({
                    type : 'POST',
                    url : baseUrl + "/pc/preservation/resultSet/minus_preservation_service?ACCESS_TOKEN=${ACCESS_TOKEN}",
                    data : $("#minus_detail_list_form").serialize(),
                    dataType : "json",
                    success : function(data) {
                        layer.msg(data.message,{time:3000});
                        if(data.statusCode == "200"){
                            $('.redues-increased').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
                            $('.black-mask').hide();
                            setTimeout(function(){
                                location.reload();
							},2000);
                        }
                        layer.close(index);
                    },
                    error: function(){
                        layer.close(index);
                    }
                });
            }else{
                layer.close(index);
			}
        }
        function replace_save_preservation(_sign){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $("#replace_sign").val(_sign);
            var isT = 0;
            if(_sign == '1'){
                isT = submitFormValidator('replace_detail_list_form');
            }
            if(isT == 0){
                $.ajax({
                    type : 'POST',
                    url : baseUrl + "/pc/preservation/resultSet/replace_preservation_service?ACCESS_TOKEN=${ACCESS_TOKEN}",
                    data : $("#replace_detail_list_form").serialize(),
                    dataType : "json",
                    success : function(data) {
                        if(data.statusCode == "200"){
                            layer.msg(data.message,{time:2000});
                            $('.replaces-increased').addClass('fadeOutUpBig').removeClass('fadeInDownBig');
                            $('.black-mask').hide();
                            setTimeout(function(){
                                location.reload();
                            },2000);
                        }else{
                            if(data.message.indexOf('部分证件号已在保，无法重复投保：')!=-1){
                                layer.msg("部分证件号已在保，无法重复投保!",{time:2000});
                                var reg = new RegExp(',','g');
                                var blob = new Blob(['(注：以下证件号已在保，请检查并剔除后重新提交。)\n'+data.message.split('：')[1].replace(reg,'\n')], {type: "text/plain;charset=utf-8"});
                                saveAs(blob, "人员重复投保清单.txt");
                            }else{
                                layer.msg(data.message,{time:2000});
                            }
                        }
                        layer.close(index);
                    },
                    error: function(){
                        layer.close(index);
                    }
                });
            }else{
                layer.close(index);
			}
        }
        function uploadInsure(){

            var formData = new FormData();
            var files = document.getElementById("role_record").files[0];
            if(files == undefined){
                return;
			}
			if(files.name.split('.')[1].indexOf('xls')==-1&&files.name.split('.')[1].indexOf('xlsx')==-1){
                layer.msg('请下载模板文件，填充人员信息后上传！',{time:3000});
                return;
			}
            var index = layer.load(0, {shade: [0.3,'#808080']});
            formData.append('role_record', files);
            $('#role_record').val('');
            $.ajax({
                type: 'POST',
                url:baseUrl + '/pc/preservation/resultSet/uploadRoleFile?ACCESS_TOKEN=${ACCESS_TOKEN}',
                dataType:"json",
                data: formData,
                processData: false,
                contentType: false,
                success: function(json){
                    if(json.statusCode == '200') {
                        $.ajax({
                            type: 'POST',
                            url:baseUrl + "/pc/preservation/resultSet/add_upload_view?ACCESS_TOKEN=${ACCESS_TOKEN}",
                            data:$("#add_detail_list_form").serialize(),
                            dataType:"text",
                            success: function(data){
                                $("#add-increased-table").html(data);
                                layer.close(index);
                            },
                            error : function(XMLHttpRequest, textStatus, errorThrown) {
                                layer.msg(textStatus);
                                layer.close(index);
                            }
                        });
                    }else{
                        layer.msg("出现异常数据，请查看异常清单");
                        layer.close(index);
                        var reg = new RegExp(';','g');
                        var blob = new Blob(['(注：以下异常信息行号对应Excel自带行号。)\n'+json.message.replace(reg,'\n')], {type: "text/plain;charset=utf-8"});
                        saveAs(blob, "excel保全人员数据异常清单.txt");
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg(textStatus);
                    layer.close(index);
                }
            });
        }

        function replaceUploadInsure(){

            var formData = new FormData();
            var files = document.getElementById("replace_role_record").files[0];
            if(files == undefined){
                return;
            }
            if(files.name.split('.')[1].indexOf('xls')==-1&&files.name.split('.')[1].indexOf('xlsx')==-1){
                layer.msg('请下载模板文件，填充人员信息后上传！',{time:3000});
                return;
            }
            var index = layer.load(0, {shade: [0.3,'#808080']});
            formData.append('role_record', files);
            formData.append('replace_check_some', $('#replace_check_some').val());
            formData.append('ins_insurance_slip_id', $('#ins_insurance_slip_id').val());
            $('#replace_role_record').val('');
            $.ajax({
                type: 'POST',
                url:baseUrl + '/pc/preservation/resultSet/replaceUploadRoleFile?ACCESS_TOKEN=${ACCESS_TOKEN}',
                dataType:"json",
                data: formData,
                processData: false,
                contentType: false,
                success: function(json){
                    if(json.statusCode == '200') {
                        $.ajax({
                            type: 'POST',
                            url:baseUrl + "/pc/preservation/resultSet/replace_upload_view?ACCESS_TOKEN=${ACCESS_TOKEN}",
                            data:$("#replace_detail_list_form").serialize(),
                            dataType:"text",
                            success: function(data){
                                $("#replace-increased-table").html(data);
                                layer.close(index);
                            },
                            error : function(XMLHttpRequest, textStatus, errorThrown) {
                                layer.msg(textStatus);
                                layer.close(index);
                            }
                        });
                    }else{
                        layer.msg("出现异常数据，请查看异常清单");
                        layer.close(index);
                        var reg = new RegExp(';','g');
                        var blob = new Blob(['(注：以下异常信息行号对应Excel自带行号。)\n'+json.message.replace(reg,'\n')], {type: "text/plain;charset=utf-8"});
                        saveAs(blob, "excel保全人员数据异常清单.txt");
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg(textStatus);
                    layer.close(index);
                }
            });
        }

        function minusUploadInsure(){

            var formData = new FormData();
            var files = document.getElementById("minus_role_record").files[0];
            if(files == undefined){
                return;
            }
            if(files.name.split('.')[1].indexOf('xls')==-1&&files.name.split('.')[1].indexOf('xlsx')==-1){
                layer.msg('请下载模板文件，填充人员信息后上传！',{time:3000});
                return;
            }
            var index = layer.load(0, {shade: [0.3,'#808080']});
            formData.append('role_record', files);
            formData.append('ins_insurance_slip_id', $('#ins_insurance_slip_id').val());
            $('#minus_role_record').val('');
            $.ajax({
                type: 'POST',
                url:baseUrl + '/pc/preservation/resultSet/minusUploadRoleFile?ACCESS_TOKEN=${ACCESS_TOKEN}',
                dataType:"json",
                data: formData,
                processData: false,
                contentType: false,
                success: function(json){
                    if(json.statusCode == '200') {
                        $.ajax({
                            type: 'POST',
                            url:baseUrl + "/pc/preservation/resultSet/minus_upload_view?ACCESS_TOKEN=${ACCESS_TOKEN}",
                            data:$("#minus_detail_list_form").serialize(),
                            dataType:"text",
                            success: function(data){
                                $("#minus-increased-table").html(data);
                                layer.close(index);
                            },
                            error : function(XMLHttpRequest, textStatus, errorThrown) {
                                layer.msg(textStatus);
                                layer.close(index);
                            }
                        });
                    }else{
                        layer.msg("出现异常数据，请查看异常清单");
                        layer.close(index);
                        var reg = new RegExp(';','g');
                        var blob = new Blob(['(注：以下异常信息行号对应Excel自带行号。)\n'+json.message.replace(reg,'\n')], {type: "text/plain;charset=utf-8"});
                        saveAs(blob, "excel保全人员数据异常清单.txt");
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg(textStatus);
                    layer.close(index);
                }
            });
        }

        function changeSPage(){
            $('#numPerPage').val($('#sPage').val());
            $('#pageNum').val("1");
            getListForPage("resultSetForm","resultSetsArea");

            $('#callBackPager').extendPagination({
                totalCount: Number($('#totalCount').val()),
                limit: Number($('#numPerPage').val()),
                callback: function (curr, limit, totalCount) {
                    getListForPage("resultSetForm","resultSetsArea");
                }
            });
		}

        function loadDataAndPage(){
            totalCount = Number($('#totalCount').val()) || 0;
            $('#callBackPager').extendPagination({
                totalCount: totalCount,
                showCount: showCount,
                limit: limit,
                callback: function (curr, limit, totalCount) {
                    getListForPage("resultSetForm","resultSetsArea");
                }
            });
        };


        function getListForPage(formId,contentId){
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $.ajax({
                type : 'POST',
                url : baseUrl + "/pc/preservation/resultSet/getResultSetListForPage?ACCESS_TOKEN=${ACCESS_TOKEN}",
                data : $("#"+formId).serialize(),
                dataType : "text",
                success : function(data) {
                    layer.close(index);
                    $("#"+contentId).html(data);
                },
                error: function(){
                    layer.close(index);
                }
            });
        }

        function choisePolicyStatus(policyStatus,totalCount,obj){
            $(".order-list li").removeClass("active");
            $(obj).addClass("active");
            $("#policyStatus").val(policyStatus);
            $('#totalCount').val(totalCount);
            $('#pageNum').val("1");
            loadDataAndPage();
            getListForPage("resultSetForm","resultSetsArea");
        }

        function deleteOrder(policyId,policyStatus){
            layer.confirm('确定删除此订单？', {
                btn: ['确定','取消'] //按钮
            }, function(){
                layer.closeAll();
                var index = layer.load(0, {shade: [0.3,'#808080']});
                $.ajax({
                    type : 'POST',
                    url : baseUrl + "/pc/preservation/resultSet/deleteInsPreservationRecord?ACCESS_TOKEN=${ACCESS_TOKEN}",
                    data : {
                        "oid":policyId,
                    },
                    dataType : "json",
                    success : function(data) {
                        layer.close(index);
                        layer.msg(data.message);
                        if(data.status =="200"){
                            refreshTotal(policyStatus);
//                            getListForPage("orderForm","policysArea");
                        }
                    },
                    error: function(){
                        layer.close(index);
                    }
                });
            });
        }

        function refreshTotal(policyStatus){
            var id="";
            if(policyStatus =="1"){
                id = "INSSUM";
            }else if(policyStatus =="4"){
                id = "NOPAYSUM";
            }

            var total = Number($("#"+id).html());
            var totalCount = total -1;
            var numPerPage = Number($('#numPerPage').val());
            var pageNum = Number($("#pageNum").val());
            if(totalCount%numPerPage ==0)
                pageNum = pageNum -1;

            $("#"+id).html(totalCount);
            $('#totalCount').val(totalCount);
            $('#pageNum').val(pageNum);
            loadDataAndPage();

            $("#callBackPager li").each(function(){
                $(this).removeClass('active');
                if ($(this).find('a').html() == pageNum) {
                    $(this).addClass('active');
                }
            });

            getListForPage("resultSetForm","resultSetsArea");
        }
        function deleteUpdateDetail(_th){
            layer.confirm('确定删除此记录？', {
                btn: ['确定','取消'] //按钮
            }, function(){
                var index = layer.load(0, {shade: [0.3,'#808080']});
                var _obj = $(_th).parent().parent();
                var nps=_obj.siblings();   //获得兄弟节点
				if(nps.length>0){
                    _obj.remove();
                    layer.msg('删除成功!', {time:1000});
				}else{
                    _obj.remove();
                    $('#zeng').click();
                    layer.msg('删除成功!', {time:1000});
				}
                layer.close(index);
            });
        }
	</script>
</html>
<script>
	$('ul.aside-list li').removeClass('on');
	$("#myPreservation").addClass('on');
</script>