<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
	<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
	<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
	<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
	<title>百联保-我的账户</title>
	<style>
		.tab-query .tab-con .con-s2 li.width-s3{
			width: 133px !important;
		}
		.tab-query .tab-con .con-s2 ul.tab-body li .no-cont{
			width: 133px !important;
		}
	</style>
</head>

<body style="position: relative">
<jsp:include page="../../../index/multi_h.jsp"/>
<div class="container">
	<%--<div class="addr">
		<span>当前位置：</span>
		<span class="current">首页 > </span>
		<a class="active" href="#">我的账户</a>
	</div>--%>
	<jsp:include page="../../../index/multi_pc_l.jsp"/>
	<!--右边内容块-->
	<div class="pp-content">
		<ul class="order-list wed-list" id="wed-list">
			<li onclick="openRecordModel()">批改申请记录</li>
			<li onclick="openBillModel();">保全账单</li>
			<li class="active">保全结算单</li>
			<li onclick="openBatchModel();">批量减员</li>
			<li onclick="openPerChangeModel();">人员变更</li>
		</ul>
<%--		<p class="pp-wert">人员变更</p>--%>
	</div>
	<div class="tab-query tab-order my-order">
		<div class="tab-con" id="tab-con">
			<div class="sdf">
				<div class="con-srt con-s2" style="display: block;">
					<div class="s-head clearfix">
						<div class="head-input fl">
							<span>结算单号</span>
							<input type="text" id="keyword_it" value="${keyword}" placeholder="请填写结算单号">
						</div>
						<div class="head-time fl">
							<span>结算单生成时间</span>
							<input type="text" value="${start_time}" id="start-s2">
							<span class="sdf">至</span>
							<input type="text" value="${end_time}" id="end-s2">
						</div>
						<div class="head-button fr" onclick="searchList()">
							<p>搜索</p>
						</div>
					</div>
					<div class="s-head clearfix" style="margin-top: 10px;">
						<button type="button" class="btn btn-warning" onclick="exportExcel()" style="width: 70px;height: 30px;">
							<i class="glyphicon glyphicon-upload"></i><span> 导出</span>
						</button>
					</div>
					<div class="tab-content" id="preservationPaysArea">
						<ul class="order-num wed-num">
							<li class="width-s3">
								<span>结算单号</span>
							</li>
                            <li class="width-s3">
                                <span>保险公司</span>
                            </li>
							<li class="width-s3" style="width: 80px">
								<span>结算单数</span>
							</li>
							<li class="width-s3">
								<span>结算费用</span>
							</li>
							<li class="width-s3">
								<span>结算状态</span>
							</li>
							<li class="width-s3">
								<span>结算生成时间</span>
							</li>
							<li class="width-s3">
								<span>操作</span>
							</li>
						</ul>
						<ul class="tab-body">
							<c:choose>
								<c:when test="${empty payList }">
									<li class="clearfix" style="text-align: center;line-height: -moz-block-height;">
										暂无记录！！
									</li>
								</c:when>
								<c:otherwise>
									<c:forEach items="${payList }" var="pay">
										<li class="clearfix">
											<div class="no-cont">
												<span>${pay.external_reference }</span>
											</div>
                                            <div class="no-cont">
                                                <span>${pay.company_name }</span>
                                            </div>
											<div class="no-cont">
												<span>${pay.record_count}</span>
											</div>
											<div class="no-cont">
												<span>${empty pay.predict_total_amount ? '' : '￥'}${empty pay.predict_total_amount ? '-' : pay.predict_total_amount}</span>
											</div>
											<div class="no-cont">
												<span id="status_${pay.oid }">
													<c:if test="${pay.pay_status eq '3'}">
														已结算
													</c:if>
													<c:if test="${pay.pay_status ne '3'}">
														-
													</c:if>
												</span>
											</div>
											<div class="no-cont">
												<span>${pay.build_data}</span>
											</div>
											<div class="no-cont">
												<a href="javascript:;" onclick="openPayDetail('${pay.oid }','${pay.is_part}');">结算详情</a>
												<a href="javascript:;" onclick="uploadPay('${pay.oid }','${pay.record_count }','${pay.predict_total_amount }','${pay.pay_order_path }');" class="a-progress">缴费明细</a>
											</div>
										</li>
									</c:forEach>
								</c:otherwise>
							</c:choose>
						</ul>
					</div>
					<!--分页-->
					<ul class="paper-num" style="padding: 0;padding-top: 20px;">
						<div class="filter-pagination">
							<div id="callBackPager"></div>
						</div>
					</ul>
				</div>
			</div>
		</div>
	</div>

	<div class="clearfix"></div>
	<form id="preservationPayForm" action="<c:url value='/pc/preservation/pay/settlementList?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post">
		<input type="hidden" id="start_time" name="start_time" value="${start_time }"/>
		<input type="hidden" id="end_time" name="end_time" value="${end_time }"/>
		<input type="hidden" id="keyword" name="keyword" value="${keyword }"/>
		<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
		<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
		<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
	</form>
</div>

<!--缴费凭证弹窗-->
<div class="payment-voucher animated" style="position: absolute!important;top:30%">
	<div class="payment-head">
		<span>缴费明细</span>
		<a href="javascript:;" id="payment-bi">
			<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
		</a>
	</div>
	<form id="uploadPayForm">
		<div class="popo-title">
			<div class="title-img clearfix">
				<div class="title-wed" style="padding: 20px">
					<p style="text-align: right;"><span>总笔数: <i id="rcount"></i></span>&nbsp;&nbsp;&nbsp;&nbsp;<span>总金额: <i id="pamount"></i></span></p>
					<div class="row">
						<div class="col-sm-4 col-xs-4" style="margin: 10px 0;">
							缴费状态：
						</div>
						<div class="col-sm-8 col-xs-8" style="margin: 10px 0;">
							<span id="pay_status_j"></span>
						</div>
						<div class="clearfix"></div>
						<div class="col-sm-4 col-xs-4" style="margin: 10px 0;">
							保全结算费用：
						</div>
						<div class="col-sm-8 col-xs-8" style="margin: 10px 0;">
							<span id="pay_amount_j"></span>
						</div>
						<div class="clearfix"></div>
						<div class="col-sm-12 col-xs-12" id="imgs">
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="payment-cont" style="position: fixed;bottom: 0;width: 100%;">
			<input type="hidden" name="payId" id="payId" />
			<div class="payment-span">
				<span class="payment-ert">关闭</span>
<%--				<span class="p-upload">再次上传<input type="file" class="upload_pic" name="pay_file" id="upload" onchange="uploadFilePay('uploadPayForm')"/></span>--%>
			</div>
		</div>
	</form>
</div>

<!--人员变更提示弹窗-->
<div class="personnel-changes animated" style="position: absolute!important;top:30%">
	<div class="payment-head">
		<span>提示</span>
		<a href="javascript:;" id="personnel-bi">
			<img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
		</a>
	</div>
	<div class="personnel-cont">
		<p>
			如有企业人员变动（如，员工离职、新员工入职等）<br/>
			可在“我的订单”中查询对应的保险，<br/>
			点击“保全”进入保单中的人员增减操作！
		</p>
	</div>
	<div class="personnel-butt">
		<span class="personnel-bibi">关闭</span>
		<span class="personnel-wed" onclick="openPolicy()">进入“我的订单”</span><%--<c:url value='/pc/order/myOrder'/>--%>
	</div>
</div>

<!--黑色蒙版-->
<div class="black-mask"></div>
<!--黑色蒙版2-->
<div class="black-mask-more"></div>
<jsp:include page="../../../index/multi_f.jsp"/>
<script src="<c:url value='/resources/versions-2.0.2/js/jquery.zoom.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0.2/js/laydate.js' />"></script>
<script src="<c:url value='/resources/versions-2.0.2/js/corrections.js?1' />"></script>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    $(function () {
        function mouse(even, stat, iconA, iconB) {
            $('.order-detail').on(even, '.guar', function () {
                $(this).siblings('.guar-list').css('display',stat);
                $(this).find('.' + iconA).removeClass(iconA).addClass(iconB);
            });
        }
        //鼠标移动到元素上显示
        mouse('mouseenter', 'block', 'down-icon', 'up-icon');
        //鼠标移出元素
        mouse('mouseleave', 'none', 'up-icon', 'down-icon');
    })
    var totalCount = Number($('#totalCount').val()) || 0;
    var showCount = $('#showCount').val() || 5;
    var limit = Number($('#numPerPage').val()) || 5;

    $('#callBackPager').extendPagination({
        totalCount: totalCount,
        showCount: showCount,
        limit: limit,
        callback: function (curr, limit, totalCount) {
            getListForPage("preservationPayForm","preservationPaysArea");
        }
    });
	$('.con-s2 .tab-content .tab-body .no-cont:nth-child(1) span').each(function () {
		var s_length = $(this).text().length;
		if(s_length > 12){
			$(this).css({"line-height":"24px"});
			$(this).parent().css({"display":"flex","align-items":"center","justify-content":"center"});
		}
	});
	$('.con-s2 .tab-content .tab-body .no-cont:nth-child(2) span').each(function () {
		var s_length = $(this).text().length;
		if(s_length > 12){
			$(this).css({"line-height":"24px"});
			$(this).parent().css({"display":"flex","align-items":"center","justify-content":"center"});
		}
	});
	$('.con-s2 .tab-content .tab-body .no-cont:nth-child(6) span').each(function () {
		var s_length = $(this).text().length;
		if(s_length > 12){
			$(this).css({"line-height":"24px"});
			$(this).parent().css({"display":"flex","align-items":"center","justify-content":"center"});
		}
	});
	function openRecordModel(){
		location.href=baseUrl+'/pc/preservation/recordList?ACCESS_TOKEN=${ACCESS_TOKEN}';
	}
	function openBillModel(){
		location.href=baseUrl+'/pc/preservation/pay/payList?ACCESS_TOKEN=${ACCESS_TOKEN}';
	}
	function openSettlementModel(){
		location.href=baseUrl+'/pc/preservation/pay/settlementList?ACCESS_TOKEN=${ACCESS_TOKEN}';
	}
	function openBatchModel(){
		location.href=baseUrl+'/pc/preservation/batchMinus?ACCESS_TOKEN=${ACCESS_TOKEN}';
	}
	function openPerChangeModel(){
		$('.personnel-changes').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
		$('.black-mask').show();
	}

    function openPolicy(){
        location.href=baseUrl+'/pc/order/myOrder?policyStatus=21&ACCESS_TOKEN=${ACCESS_TOKEN}';
    }
    function uploadPay(_id,_rcount,_amount,_path){
        $("#payId").val(_id);
        $("#pay_amount_j").html(_amount+'元');
        $("#pamount").html(_amount+'元');
        $("#rcount").html(_rcount);
        var status = $("#status_"+_id).html();
		$("#pay_status_j").html(status);
		loadCanvas(_path);
    }

    function loadCanvas(_img){
		var content = document.getElementById('imgs');
		content.innerHTML = '';
		if(_img != ''){
			var imgs = _img.split("||");
			for(var i=0;i<imgs.length;i++){
				content.innerHTML += '<a href="'+imgs[i]+'" target="_blank"><img src="'+imgs[i]+'" width="100px" style="margin-right: 10px;"></a>';
			}
		}
        payUploadShow();
    }
    function payUploadShow () {
        $('.payment-voucher').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
    }

	function getFP(_id){
		$.ajax({
			type: 'POST',
			url:baseUrl + '/pc/preservation/pay/getFP/'+_id,
			dataType:"json",
			async:false,
			success: function(json){
				if(json.retType == '0') {//支付成功
					window.open(json.data);
				}else{
					layer.msg(json.msg);
				}
			},
			error : function(XMLHttpRequest, textStatus, errorThrown) {
				layer.msg(textStatus);
			}
		});
	}

    function openPayDetail(_id,_isPart){
		layer.open({
			type: 2,
			area: ['1000px', '600px'],
			title: "账单列表",
			skin:'lay-bak',
			closeBtn: 1,
			shadeClose: false,
			scrollbar: false,
			shade:0.4,
			fix: false,
			content: baseUrl + '/pc/preservation/pay/settlementBillList?parentPayId='+_id+'&ACCESS_TOKEN=${ACCESS_TOKEN}'
		});
    }

    function searchList(){
        $("#start_time").val($("#start-s2").val());
        $("#end_time").val($("#end-s2").val());
        $("#keyword").val($("#keyword_it").val());
        $("#pageNum").val(1);
        $("#numPerPage").val(5);
        $("#totalCount").val(0);
        $("#preservationPayForm").submit();
    }
    function exportExcel(){
        var start_time = $("#start-s2").val();
        var end_time = $("#end-s2").val();
        var keyword = $("#keyword_it").val();

		var index = layer.confirm('该操作将根据搜索条件导出数据，是否继续？',{btn: ['导出','取消']}, function(){
			location.href=baseUrl + '/pc/preservation/pay/downSettlementPay?keyword='+keyword+'&start_time='+start_time+'&end_time='+end_time;
			layer.close(layer.index);
		});
    }


    function loadDataAndPage(){
        totalCount = Number($('#totalCount').val()) || 0;
        $('#callBackPager').extendPagination({
            totalCount: totalCount,
            showCount: showCount,
            limit: limit,
            callback: function (curr, limit, totalCount) {
                getListForPage("preservationPayForm","preservationPaysArea");
            }
        });
    };


    function getListForPage(formId,contentId){
        var index = layer.load(0, {shade: [0.3,'#808080']});
        $.ajax({
            type : 'POST',
            url : baseUrl + "/pc/preservation/pay/getSettlementListForPage",
            data : $("#"+formId).serialize(),
            dataType : "text",
            success : function(data) {
                layer.close(index);
                $("#"+contentId).html(data);
            },
            error: function(){
                layer.close(index);
            }
        });
    }

    function choisePolicyStatus(policyStatus,totalCount,obj){
        $(".order-list li").removeClass("active");
        $(obj).addClass("active");
        $("#policyStatus").val(policyStatus);
        $('#totalCount').val(totalCount);
        $('#pageNum').val("1");
        loadDataAndPage();
        getListForPage("preservationPayForm","preservationPaysArea");
    }

    function deletePreservationRecord(preservationId){
        layer.confirm('确定删除此订单？', {
            btn: ['确定','取消'] //按钮
        }, function(){
            layer.closeAll();
            var index = layer.load(0, {shade: [0.3,'#808080']});
            $.ajax({
                type : 'POST',
                url : baseUrl + "/pc/preservation/deleteInsPreservationRecord",
                data : {
                    "oid":preservationId,
                },
                dataType : "json",
                success : function(data) {
                    layer.close(index);
                    layer.msg(data.message);
                    if(data.status =="200"){
                        getListForPage("preservationPayForm","preservationPaysArea");
                    }
                },
                error: function(){
                    layer.close(index);
                }
            });
        });
    }

    function refreshTotal(){
        var total = Number($("#"+id).html());
        var totalCount = total -1;
        var numPerPage = Number($('#numPerPage').val());
        var pageNum = Number($("#pageNum").val());
        if(totalCount%numPerPage ==0)
            pageNum = pageNum -1;

        $("#"+id).html(totalCount);
        $('#totalCount').val(totalCount);
        $('#pageNum').val(pageNum);
        loadDataAndPage();

        $("#callBackPager li").each(function(){
            $(this).removeClass('active');
            if ($(this).find('a').html() == pageNum) {
                $(this).addClass('active');
            }
        });

        getListForPage("preservationPayForm","preservationPaysArea");
    }

</script>
</body>
</html>

<script>
    $('ul.aside-list li').removeClass('on');
    $("#myPreservation").addClass('on');
</script>