<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<ul class="order-num wed-num">
	<li class="width-s3" style="width: 24px">
		<span>&nbsp;</span>
	</li>
	<li class="width-s3">
		<span>账单编号</span>
	</li>
    <li class="width-s3">
        <span>保险公司</span>
    </li>
	<li class="width-s3">
		<span>投保人</span>
	</li>
	<li class="width-s3" style="width: 80px">
		<span>保全单数</span>
	</li>
	<li class="width-s3">
		<span>保全金额</span>
	</li>
	<li class="width-s3">
		<span>起止日期</span>
	</li>
	<li class="width-s3">
		<span>生成日期</span>
	</li>
	<li class="width-s3">
		<span>缴费状态</span>
	</li>
	<li class="width-s3">
		<span>操作</span>
	</li>
</ul>
<ul class="tab-body">
	<c:choose>
		<c:when test="${empty payList }">
			<li class="clearfix" style="text-align: center;line-height: -moz-block-height;">
				暂无记录！！
			</li>
		</c:when>
		<c:otherwise>
			<c:forEach items="${payList }" var="pay">
				<li class="clearfix">
					<div class="no-cont" style="display: flex;align-items: center;justify-content: center;width: 24px;">
						<span style="line-height: 24px;">
							<c:if test="${(pay.pay_status eq '1'||pay.pay_status eq '2') && pay.is_part == 0 && row.predict_total_amount != 0 && pay.predict_total_amount ne '0.00'}"><input type="checkbox" name="billId" value="${pay.oid }"></c:if>
						</span>
					</div>
					<div class="no-cont">
						<span>${pay.external_reference }</span>
					</div>
                    <div class="no-cont">
                        <span>${pay.company_name }</span>
                    </div>
					<div class="no-cont">
						<span>${pay.app_role_name }</span>
					</div>
					<div class="no-cont" style="width: 80px">
						<span>${pay.record_count}</span>
					</div>
					<div class="no-cont">
						<span>${empty pay.predict_total_amount ? '' : '￥'}${empty pay.predict_total_amount ? '-' : pay.predict_total_amount}</span>
					</div>
					<div class="no-cont">
						<p>${pay.star_pay_time }</p>
						<i>至</i>
						<p>${pay.end_pay_time }</p>
					</div>
					<div class="no-cont">
						<span>${pay.build_data}</span>
					</div>
					<div class="no-cont">
						<span id="status_${pay.oid }">
							<c:if test="${pay.is_part_status == 0}">
								${fns:getDictLabel(pay.pay_status,"billPayStatus","")}
							</c:if>
							<c:if test="${pay.is_part_status > 0 && pay.pay_status ne '3'}">
								${fns:getDictLabel("5","billPayStatus","")}
							</c:if>
							<c:if test="${pay.is_part_status > 0 && pay.pay_status eq '3'}">
								${fns:getDictLabel(pay.pay_status,"billPayStatus","")}
							</c:if>
						</span>
					</div>
					<div class="no-cont">
						<a href="javascript:;" onclick="openPayDetail('${pay.oid }','${pay.is_part}');"<%-- class="po-details"--%>>详情</a>
						<c:if test="${(pay.pay_status eq '1'||pay.pay_status eq '2') && pay.predict_total_amount ne '0.00' }">
							<a href="javascript:;" onclick="uploadPay('${pay.oid }','${pay.record_count }','${pay.predict_total_amount }','${pay.pay_order_path }');" class="a-progress">支付</a>
						</c:if>

						<c:if test="${pay.pay_status eq '3' && pay.is_fp eq '1' && not empty pay.fp_url}">
							<a href="${pay.fp_url}" target="_blank" class="a-progress">发票下载</a>
						</c:if>
						<c:if test="${pay.pay_status eq '3' && pay.is_fp ne '1'}">
							<a href="javascript:;" onclick="getFP('${pay.oid }');" class="a-progress">申请发票</a>
						</c:if>
					</div>
				</li>
			</c:forEach>
		</c:otherwise>
	</c:choose>
</ul>
<script>
    $('.no-cont .po-details').click(function () {
        $('.details-popover').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
        var s = $('.popo-tbody').height();
        if(s <= 400){

            $('.details-popover .popo-content').css({"overflow":"hidden"})
        }
    });
    /*$('.no-cont .progress').click(function () {
        $('.payment-voucher').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
    });*/
    $('.con-s2 .tab-content .tab-body .no-cont:nth-child(2) span').each(function () {
        var s_length = $(this).text().length;
        if(s_length > 12){
			$(this).css({"line-height":"24px"});
			$(this).parent().css({"display":"flex","align-items":"center","justify-content":"center"});
        }
    });
    $('.con-s2 .tab-content .tab-body .no-cont:nth-child(3) span').each(function () {
        var s_length = $(this).text().length;
        if(s_length > 7){
			$(this).css({"line-height":"24px"});
			$(this).parent().css({"display":"flex","align-items":"center","justify-content":"center"});
        }
    });
	$('.con-s2 .tab-content .tab-body .no-cont:nth-child(4) span').each(function () {
		var s_length = $(this).text().length;
		if(s_length > 7){
			$(this).css({"line-height":"24px"});
			$(this).parent().css({"display":"flex","align-items":"center","justify-content":"center"});
		}
	});

</script>