<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1"/>
    <meta http-equiv="X-UA-Compatible" content="IE=9"/>
    <meta name="keywords"
          content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
    <meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
    <meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
    <title>百联保-我的账户</title>
</head>

<body>
<jsp:include page="../index/multi_h.jsp"/>
<div class="container">
    <jsp:include page="../index/multi_pc_l.jsp"/>

    <!--右边内容区开始-->
    <c:if test="${userdetail.terminal_type eq '1'}">
        <!--个人用户开始-->
        <div>
            <div class="user-detail">
                <div class="title">
                <span class="tit-name">
                    个人信息
                </span>
                </div>
                <ul class="detail-list">
                    <li>
                        <span class="detail-left">用户名</span>
                        <span>${userdetail.login_name}</span>
                    </li>
                    <li>
                        <span class="detail-left">出生日期</span>
                        <c:if test="${empty userdetail.birthday }">
                            <span class="no-name">未实名，暂无信息</span>
                        </c:if>
                        <c:if test="${ not empty userdetail.birthday }">
                            <span class="no-name">${userdetail.birthday }</span>
                        </c:if>
                    </li>
                    <li>
                        <span class="detail-left">姓名</span>
                        <c:if test="${empty  userdetail.real_name }">
                            <span class="no-name">未实名，暂无信息</span>
                        </c:if>
                        <c:if test="${ not empty userdetail.real_name }">
                            <span class="no-name">${userdetail.real_name }</span>
                        </c:if>
                    </li>
                    <li>
                        <span class="detail-left">性别</span>
                        <c:if test="${empty userdetail.sex || userdetail.sex eq  '0'}">
                            <span class="no-name">未实名，暂无信息</span>
                        </c:if>
                        <c:if test="${ not empty userdetail.sex && userdetail.sex ne '0' }">
                            <c:if test="${userdetail.sex eq '1'}">
                                <span class="no-name">男</span>
                            </c:if>
                            <c:if test="${userdetail.sex eq '0'}">
                                <span class="no-name">女</span>
                            </c:if>
                        </c:if>
                    </li>
                </ul>
            </div>
            <div class="account-safe">
                <div class="title">
                <span class="tit-name">
                    账户安全
                </span>
                    <div class="prev-login">
                        <c:if test="${ not empty  userdetail.last_login_time}">
                            <span>上次登录时间</span>
                            <span class="time">${userdetail.last_login_time}</span>
                        </c:if>
                    </div>
                </div>
                <ul class="account-list">
                    <c:if test="${userdetail.is_certification  eq  '1'}">
                        <li>
                            <i class="succ-name"></i>
                            <span class="account-detail">实名认证</span>
                            <span class="no-detail">已实名认证</span>
                        </li>
                    </c:if>
                    <c:if test="${userdetail.is_certification  eq  '0' }">
                        <li>
                            <i class="err-name"></i>
                            <span class="account-detail">实名认证</span>
                            <span class="no-detail">暂无实名认证，实名认证可以提升账户安全等级并能查看到更全的订单。</span>
                            <a href="<c:url value='/pc/realNameAuthentication?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="now-see">立即认证</a>

                        </li>
                    </c:if>

                    <li>
                        <c:if test="${not  empty userdetail.telephone}">
                            <i class="succ-name"></i>
                            <span class="account-detail">手机号码</span>
                            <span>${userdetail.telephone}</span>
                            <a href="<c:url value='/pc/phoneInit?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="change-info">修改</a>
                        </c:if>
                        <c:if test="${empty  userdetail.telephone}">
                            <i class="err-name"></i>
                            <span class="account-detail">手机号码</span>
                            <span class="no-detail">暂未绑定手机，账户绑定的手机可作为登录凭证</span>
                            <a href="<c:url value='/pc/phoneInit?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="change-info">绑定</a>
                        </c:if>
                    </li>
                    <li>
                        <c:if test="${ not empty  userdetail.email}">
                            <i class="succ-name"></i>
                            <span class="account-detail">邮箱地址</span>
                            <span class="no-detail">${userdetail.email}</span>
                            <a href="<c:url value='/pc/emailInit?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="change-info">修改</a>
                        </c:if>
                        <c:if test="${empty  userdetail.email}">
                            <i class="err-name"></i>
                            <span class="account-detail">邮箱地址</span>
                            <span class="no-detail">暂未绑定邮箱，账户绑定的邮箱可作为登录凭证</span>
                            <a href="<c:url value='/pc/emailInit?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="change-info">绑定</a>
                        </c:if>
                    </li>
                    <li>
                        <i class="succ-name"></i>
                        <span class="account-detail">登录密码</span>
                        <span class="no-detail">已成功设置</span>
                        <a href="<c:url value='/pc/updPwdInit?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="change-info">修改</a>
                    </li>
                </ul>
            </div>
        </div>
        <!--个人用户结束-->
    </c:if>

    <c:if test="${userdetail.terminal_type eq '2'}">
        <!--企业用户开始-->
        <div>
            <div class="account-safe">
                <div class="title">
                    <h2 class="tit-name">
                        企业登录信息
                    </h2>

                </div>
                <ul class="account-list">
                    <li>
                        <span class="account-detail user-name">用&nbsp;&nbsp;户&nbsp;名</span>
                        <span>${userdetail.login_name}</span>
                    </li>
                    <c:if test="${userdetail.c_is_certification  eq  '0'}">
                        <li>
                            <i class="err-name"></i>
                            <span class="account-detail">企业认证</span>
                            <span class="no-detail">暂无企业认证，企业认证可以提升账户安全等级并能查看到更全的订单。</span>
                        </li>
                    </c:if>
                    <c:if test="${userdetail.c_is_certification  eq  '1'}">
                        <li>
                            <i class="succ-name"></i>
                            <span class="account-detail">企业认证</span>
                            <span class="no-detail">已认证</span>
                        </li>
                    </c:if>
                    <li>
                        <c:if test="${not  empty userdetail.telephone}">
                            <i class="succ-name"></i>
                            <span class="account-detail">手机号码</span>
                            <span>${userdetail.telephone}</span>
                            <a href="<c:url value='/pc/phoneInit?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="change-info">修改</a>
                        </c:if>
                        <c:if test="${empty  userdetail.telephone}">
                            <i class="err-name"></i>
                            <span class="account-detail">手机号码</span>
                            <span class="no-detail">暂未绑定手机，账户绑定的手机可作为登录凭证</span>
                            <a href="<c:url value='/pc/phoneInit?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="change-info">绑定</a>
                        </c:if>
                    </li>
                    <li>
                        <c:if test="${ not empty  userdetail.email}">
                            <i class="succ-name"></i>
                            <span class="account-detail">邮箱地址</span>
                            <span class="no-detail">${userdetail.email}</span>
                            <a href="<c:url value='/pc/emailInit?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="change-info">修改</a>
                        </c:if>
                        <c:if test="${empty  userdetail.email}">
                            <i class="err-name"></i>
                            <span class="account-detail">邮箱地址</span>
                            <span class="no-detail">暂未绑定邮箱，账户绑定的邮箱可作为登录凭证</span>
                            <a href="<c:url value='/pc/emailInit?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="change-info">绑定</a>
                        </c:if>
                    </li>
                    <li>
                        <i class="succ-name"></i>
                        <span class="account-detail">登录密码</span>
                        <span class="no-detail">已成功设置</span>
                        <a href="<c:url value='/pc/updPwdInit?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="change-info">修改</a>
                    </li>
                </ul>
            </div>
            <form id="form1" method="post">
                <div class="enter-user-info">
                    <div class="title">
                        <h2 class="tit-name" style="float: left;">
                            企业联系人信息
                        </h2>
                        <div class="prev-login" style="float: right;">
                            <c:if test="${ not empty  userdetail.last_login_time}">
                                <span>上次登录时间</span>
                                <span class="time">${userdetail.last_login_time}</span>
                            </c:if>

                        </div>
                    </div>
                    <ul class="form-list">
                        <li>
                            <div class="list-name">
                                <label>姓名</label>
                            </div>
                            <div class="list-input">
                                <input type="text" class="inp" name="link_name" value="${userdetail.link_name}">
                            </div>
                        </li>
                        <li>
                            <div class="list-name">
                                <label>电子邮件</label>
                            </div>
                            <div class="list-input">
                                <input type="text" class="inp" name="link_email" value="${userdetail.link_email}"
                                       placeholder="请输入正确格式邮箱">
                            </div>
                        </li>
                            <%--<li>
                                <div class="list-name">
                                    <label>证件类型</label>
                                </div>
                                <div class="list-input">
                                    <input type="text" class="inp sel"   placeholder="证件类型">
                                    <i class="down-icon"></i>
                                    <select class="sel-list default" name="link_card_type">
                                        <option value="">请选择</option>
                                        <c:forEach items="${idTypeList}" var="idtype">
                                            <option value="${idtype.value}" <c:if test="${not empty userdetail.link_card_type && userdetail.link_card_type eq idtype.value}">selected="selected"</c:if>>${idtype.name}</option>
                                        </c:forEach>

                                    </select>
                                    </select>
                                </div>
                            </li>
                            <li>
                                <div class="list-name">
                                    <label>证件号码</label>
                                </div>
                                <div class="list-input">
                                    <input type="text" class="inp"  value="${userdetail.link_card}" name="link_card" value="">
                                </div>
                            </li>--%>
                        <li>
                            <div class="list-name">
                                <label>手机号</label>
                            </div>
                            <div class="list-input">
                                <input type="text" class="inp" value="${userdetail.link_phone}" name="link_phone"
                                       placeholder="请输入联系人11位手机号">
                            </div>
                        </li>
                    </ul>
                </div>
                <div class="enter-info">
                    <div class="title">
                        <h2 class="tit-name">
                            企业基本信息
                        </h2>
                    </div>
                    <ul class="form-list">
                        <li>
                            <div class="list-name">
                                <label>企业名称</label>
                            </div>
                            <div class="list-input">
                                <input type="text" class="inp myValid" name="company_name" id="company_name"
                                       value="${userdetail.company_name}">
                            </div>
                        </li>
                        <li>
                            <div class="list-name">
                                <label>企业类型</label>
                            </div>
                            <div class="list-input">
                                <i class="down-icon"></i>
                                <select class="default myValid" id="role_comNature_0"
                                        onchange="natureChange(this,'role_natureTwo_0');" name="enterprise_type" style="height: 45px;width: 150px">
                                    <option value="">请选择</option>
                                    <c:forEach items="${natureList }" var="list">
                                        <option value="${list.value}"
                                                <c:if test="${not empty userdetail.enterprise_type && userdetail.enterprise_type eq list.value}">selected="selected"</c:if>>${list.name}</option>
                                    </c:forEach>
                                </select>

                            </div>
                            <select class="default myValid" id="role_natureTwo_0" name="enterprise_type_two" style="height: 45px;width: 150px">

                                <c:forEach items="${natureTwoList }" var="list">
                                    <option value="${list.value }" <c:if
                                            test="${userdetail.enterprise_type_two eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                </c:forEach>

                            </select>
                        </li>


                        <li>
                            <div class="list-name">
                                <label>证件类型</label>
                            </div>
                            <div class="list-input">
                                <i class="down-icon"></i>
                                <select class="default myValid" id="organization_code_type"
                                        name="organization_code_type" style="width: 298px;height: 45px;">
                                    <option value="">请选择</option>
                                    <c:forEach items="${companyIdTypeList}" var="idtype">
                                        <option value="${idtype.value}"
                                                <c:if test="${not empty userdetail.organization_code_type && userdetail.organization_code_type eq idtype.value}">selected="selected"</c:if>>${idtype.name}</option>
                                    </c:forEach>
                                </select>

                            </div>
                        </li>
                        <li>
                            <div class="list-name">
                                <label>证件号码</label>
                            </div>
                            <div class="list-input">
                                <input type="text" class="inp myValid" name="organization_code" id="organization_code"
                                       value="${userdetail.organization_code}" value="">
                            </div>
                        </li>

                        <li>
                            <div class="list-name">
                                <label>企业所在地</label>
                            </div>
                            <div class="list-input picker_area_div">
                                <div class="sel-choice">
                                    <i class="down-icon"></i>
                                    <select class="default picker_province myValid" id="picker_province"
                                            name="province" style="height: 45px;width: 150px">
                                        <option value="0" selected>请选择省</option>
                                    </select>
                                </div>
                                <div class="sel-choice">
                                    <i class="down-icon"></i>
                                    <select class="default picker_city myValid" id="picker_city" name="city" style="height: 45px;width: 150px">
                                        <option value="0" selected>请选择市</option>
                                    </select>
                                </div>
                                <div class="sel-choice">
                                    <i class="down-icon"></i>
                                    <select class="default picker_district myValid" id="picker_district"
                                            name="district" style="height: 45px;width: 150px">
                                        <option value="0" selected>请选择区</option>
                                    </select>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="list-name">
                                <label>详细地址</label>
                            </div>
                            <div class="list-input">
                                <input type="text" class="inp myValid" name="registered_address" id="registered_address"
                                       value="${userdetail.registered_address}">

                            </div>
                        </li>

                    </ul>
                </div>
                <div class="relevant-data">
                    <div class="title">
                        <h2 class="tit-name">
                            补充相关资料
                        </h2>
                    </div>
                    <ul class="form-list">

                        <li>
                            <div class="file-left">
                                <span class="file-name">组织机构代码证</span>
                                <c:if test="${not empty userdetail.organization_code_img}">
                                    <img src="${userdetail.organization_code_img}" class="img-file">
                                </c:if>
                                <c:if test="${ empty userdetail.organization_code_img}">
                                    <img src="<c:url value='/resources/version_new/images/img-file.png'/>"
                                         class="img-file">
                                </c:if>
                                <div class="file-button">
                                    <input type="hidden" name="organization_code_img"
                                           value="${userdetail.organization_code_img}" id="uploadText2"
                                           style="width: 40%;" readonly="readonly"
                                           placeholder="限.doc.docx.xls.xlsx.ppt.pptx.txt.jpg.gif.png.rar.zip文件">
                                    <input type="button" class="btn  green-btn" value="点击上传"
                                           onclick="getImg('uploadText2')" disabled>
                                    <input type="file" name="reportFile" class="ac_file"/>
                                    <a href="#" class="look-img">+浏览</a>
                                    <span class="sample">| 样例</span>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="file-left">
                                <span class="file-name">营业执照</span>
                                <c:if test="${not empty userdetail.business_address_img}">
                                    <img src="${userdetail.business_address_img}" class="img-file">
                                </c:if>
                                <c:if test="${ empty userdetail.business_address_img}">
                                    <img src="<c:url value='/resources/version_new/images/img-file.png'/>"
                                         class="img-file">
                                </c:if>
                                <div class="file-button">
                                    <input type="hidden" name="business_address_img"
                                           value="${userdetail.business_address_img}" id="uploadText3"
                                           style="width: 40%;" readonly="readonly"
                                           placeholder="限.doc.docx.xls.xlsx.ppt.pptx.txt.jpg.gif.png.rar.zip文件">
                                    <input type="button" class="btn  green-btn" value="点击上传" disabled>
                                    <input type="file" name="reportFile" class="ac_file"/>
                                    <a href="#" class="look-img">+浏览</a>
                                    <span class="sample">| 样例</span>
                                </div>
                            </div>
                            <div class="file-right">
                                <p class="remind-text"><span class="red">*</span>
                                    如果贵公司已办理三证合一，请将新证件上传至此处，组织机构代码和税务登记证无需上传
                                </p>
                            </div>
                        </li>
                        <li>
                            <div class="file-left">
                                <span class="file-name">税务登记</span>
                                <c:if test="${not empty userdetail.tax_registration_img}">
                                    <img src="${userdetail.tax_registration_img}" class="img-file">
                                </c:if>
                                <c:if test="${ empty userdetail.tax_registration_img}">
                                    <img src="<c:url value='/resources/version_new/images/img-file.png'/>"
                                         class="img-file">
                                </c:if>
                                <div class="file-button">
                                    <input type="text" id="uploadText4" name="tax_registration_img"
                                           value="${userdetail.tax_registration_img}" style="width: 40%;"
                                           readonly="readonly"
                                           placeholder="限.doc.docx.xls.xlsx.ppt.pptx.txt.jpg.gif.png.rar.zip文件" hidden>
                                    <input type="button" class="btn  green-btn" value="点击上传" disabled>
                                    <input type="file" name="reportFile" class="ac_file"/>
                                    <a href="#" class="look-img">+浏览</a>
                                    <span class="sample">| 样例</span>
                                </div>
                            </div>
                        </li>
                        <li>
                            <div class="list-name"></div>
                            <div class="list-input">
                                <button class="btn save" onclick="saveCompany()" type="button">保存</button>
                                    <%--
                                                                <button class="btn back" type="button">返回</button>
                                    --%>
                            </div>
                        </li>
                    </ul>
                </div>
            </form>
        </div>
        <!--企业用户结束-->
    </c:if>
    <!--右边内容区结束-->

</div>
<jsp:include page="../index/multi_f.jsp"/>
<script src="<c:url value='/resources/version_new/js/jquery-1.8.3.min.js' />"></script>
<script src="<c:url value='/resources/version_new/js/jquery.formHelper.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script src="<c:url value='/resources/public/g.js' />"></script>
<script src="<c:url value='/resources/version_new/js/account.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>


<script>
    $(document).ready(function () {
        var province = '${userdetail.province}';
        if (province) {
            districtObj.init({
                province: '${userdetail.province}',
                city: '${userdetail.city}',
                district: '${userdetail.district}'
            });
            $(".picker_province").change();
            $(".picker_city").val('${userdetail.city}');
            $(".picker_city").change();
            $(".picker_district").val('${userdetail.district}');
        }
    });
    var allright = true;
    // 图片上传
    $(".ac_file").change(function () {
        var file_id = $(this).siblings('input').attr('id');
        var $file = $(this);
        var fileObj = $file[0];
        var files = fileObj.files[0];
        var windowURL = window.URL || window.webkitURL;
        var dataURL;
        var $img = $file.parent().siblings('img');
        if (fileObj && fileObj.files && files) {
            filesConvert(files, file_id);
            dataURL = windowURL.createObjectURL(fileObj.files[0]);
            $img.attr('src', dataURL);
        } else {
            dataURL = $file.val();
            var imgObj = $img[0];
// 两个坑:
// 1、在设置filter属性时，元素必须已经存在在DOM树中，动态创建的Node，也需要在设置属性前加入到DOM中，先设置属性在加入，无效；
// 2、src属性需要像下面的方式添加，上面的两种方式添加，无效；
            imgObj.src = ''; // 在IE9以下配置以下两句话无效，所以在此处先把imgObj的src清空，再设置。
            imgObj.style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(sizingMethod=scale)";
            if (dataURL) {
                imgObj.filters.item("DXImageTransform.Microsoft.AlphaImageLoader").src = dataURL;
            }
        }
    });

    $("#company_name").bind("blur keyup", function () {
        var r1 = isWrong($(this).val().trim() == "", this, "企业名称必填");
        if (!r1) return r1;
        var r2 = isWrong(!/^[\u4e00-\u9fa5a-zA-Z0-9\（\）]{2,60}$/.test($(this).val()), this, "企业名称必须是2-60个字符长度");
    });
    $("#role_comNature_0").bind("blur", function () {
        isWrong($(this).val().trim() == "", this, "");
    });
    $("#organization_code_type").bind("blur", function () {
        isWrong($(this).val().trim() == "", this, "");
    });
    $("#registered_address").bind("blur", function () {
        isWrong($(this).val().trim() == "", this, "");
    });
    $("#organization_code").bind("blur", function () {
        isWrong($(this).val().trim() == "", this, "");
    });

    $("#picker_province").bind("blur", function () {
        isWrong($(this).val().trim() == "", this, "");
    });
    $("#picker_city").bind("blur", function () {
        isWrong($(this).val().trim() == "", this, "");
    });
    $("#picker_district").bind("blur", function () {
        isWrong($(this).val().trim() == "", this, "");
    });


    function isWrong(el, obj, msg) {
        if (el) {
            $(obj).nextAll("span").remove();
            if (msg != "") $(obj).after("<span class='list-msg'>" + msg + "</span>");
            $(obj).addClass("err");
            allright = false;
//			$(obj).focus();
            return false;
        } else {
            $(obj).nextAll("span").remove();
            $(obj).removeClass("err");
            return true;
        }
    }





    function filesConvert(files, file_id) {
        var fileName = files.name;
        var type = fileName.split(".")[fileName.split(".").length - 1];
        ajaxFormDataLoad(files, file_id, "policy/", type);
    }

    function ajaxFormDataLoad(file, _id, directoryName, fileType) {
        var index = layer.load(0, {shade: [0.3, '#808080'], scrollbar: false});
        var _myData = new Date();
        var _times = _myData.getTime();
        var name = "/" + directoryName + _times + "." + fileType;
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', _times + "." + fileType);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoad';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType: "json",
            data: formData,
            processData: false,
            contentType: false,
            success: function (result) {
                layer.close(index);
                if (result.statusCode == '200') {
//					layer.msg(result.message);
                    $("#" + _id).val(result.message);
                } else {
                    layer.msg(result.message);
                }
            }
        });
    }


    function saveCompany() {

        allright = true;
        $(".myValid").each(function () {
            $(this).trigger("blur");
            if ($(this).hasClass("err")) $(this).focus();
        }); //校验表单

        if (allright) {
            //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
            setParamDatas($('#form1').serialize(),baseUrl + "/pc/myAccount/saveInfo",false,true,function(json){
                if (json.statusCode == '200') {
                    layer.msg('保存成功！', {time:2000});
                    setTimeout(function(){
                        window.location.reload();
                    },1000);
                } else {
                    layer.msg('保存失败！', {time:2000});

                }
            });
            /*var index = layer.load(0, {shade: [0.3, '#808080'], scrollbar: false});
            $.ajax({
                type: 'POST',
                url: baseUrl + "/pc/myAccount/saveInfo",
                data: $('#form1').serialize(),
                async: false,
                dataType: "json",
                cache: false,
                success: function (json) {
                    layer.close(index);
                    if (json.statusCode == '200') {
                        layer.close(index);
                        layer.msg('保存成功！', {time:2000});
                        setTimeout(function(){
                           window.location.reload();
						},1000);
                    } else {
                        layer.close(index);
                        layer.msg('保存失败！', {time:2000});

                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    layer.msg("保存失败");

                    layer.close(index);
                }
            });*/
        }

    }

    natureChange($("#role_comNature_0"), 'role_natureTwo_0');
    function natureChange(_this, _id) {
        var code = _this.value;
        if (code != "") {
            $.ajax({
                type: 'POST',
                url: baseUrl + '/api/gmr/natureChange',
                data: {"nID": code},
                dataType: "json",
                async: false,
                success: function (json) {
                    $("#" + _id).empty();
                    var t = 0;
                    $("#" + _id).append("<option value=''>-请选择-</option>");
                    for (var prop in json) {
                        if (json.hasOwnProperty(prop)) {
                            t++;
                            console.log("prop: " + prop + " value: " + json[prop]);
                            var appendStr = "<option value='" + prop + "' ";
                            appendStr = appendStr + ">" + json[prop] + "</option>"
                            $("#" + _id).append(appendStr);
                        }
                    }
                    if (t > 0) {
                        $("#" + _id).show();
                    } else {
                        $("#" + _id).hide();
                    }
                }
            });
        } else {

        }
    }
    $('ul.aside-list li').removeClass('on');
    $("#myAcountInfo").addClass('on');

</script>
</body>
</html>