<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>

<div class="query-criteria">
	<div class="paging-war mt-60 clearfix">
		<span>模块项</span>
		<a href="#module-add" data-toggle="modal">添加</a>
		<a href="#module-amend" data-toggle="modal">修改</a>
	</div> 
	<div class="query-result">
		<table class="table product-table">
			<thead>
				<tr>
					<th></th>
					<th>所属页</th>
					<th>模块名称</th>
					<th>模块类型</th>
					<th>产品名称</th> 
					<th>排序</th>
					<th>操作</th>
				</tr>
			</thead>
			<tbody>
				<c:choose>
					<c:when test="${empty modularityList }">
					<tr><td colspan="11" style="text-align: center;">无查询结果</td></tr>
					</c:when>
					<c:otherwise>
						<c:forEach items="${modularityList }" var="modularity">
							<tr typs="mod" rel="${modularity.oid}" onclick="selectRadio(this)">
								<td class="rad-io">
									<input type="radio" name="radio_mod" id="id_${modularity.oid}" />
									<label for="id_${modularity.oid}"></label>
								</td> 
								<td>${modularity.pageView}</td>
								<td>${modularity.name}</td>
								<td>${modularity.specModule.name}</td>
								<td title="${modularity.insuranceProduct.name}">${modularity.insuranceProduct.name}</td>
								<td>${modularity.process}</td>
								<td class="cr-7f">
									<a href="javascript:void(0);" data-vals="${modularity.oid}" onclick="getLoadSpecProperty(this,'specProperty_modal')" >查看</a>
									<span>|</span>
									<a href="javascript:void(0);" onclick="deleteRow('${modularity.oid}','deleteModularity');"><i class="glyphicon glyphicon-trash cr-7f"></i></a>
								</td>
							</tr>
						</c:forEach>
					</c:otherwise>
				</c:choose>
			</tbody>
		</table>
	</div>
</div>
