<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
<h4 class="mt-60">查询结果</h4>
<div class="query-result" id="pageResult">
<table class="table">
	<thead>
		<tr>
			<th>订单号</th>
			<th>投保人</th>
			<th>被保险人</th>
			<th>审理法院</th>
			<th>订单时间</th>
			<th>状态</th>
			<th>操作</th>
		</tr>
	</thead>
	<tbody>
		<c:choose>
			<c:when test="${empty orderList }">
				<tr>
					<td colspan="7" style="text-align: center;">暂无相关数据</td>
				</tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${orderList }" var="order">
					<tr>
						<td>${order.orderNo }</td>
						<td>${order.applicant }</td>
						<td>${order.recognizee }</td>
						<td>${order.court }</td>
						<td><fmt:formatDate pattern="yyyy-MM-dd" value="${order.createOn}" /></td>
						<td>
							<c:if test="${order.riskReadStatus eq 'UNREAD' }">
								${order.riskReadStatus.name }
							</c:if>
							<c:if test="${order.riskReadStatus eq 'READ' && order.riskStatus eq 'UNENTERING' }">
								未承接
							</c:if>
							<c:if test="${order.riskStatus eq 'GIVEUP' }">
								已放弃承接此单
							</c:if>
							<c:if test="${order.riskStatus eq 'ACCEPT' && order.riskUploadStatus eq 'UNUPLOADING' }">
								等待上传风评报告
							</c:if>
							<c:if test="${order.riskUploadStatus eq 'UPLOADING' }">
								已上传风评报告
							</c:if>
						</td>
						<td>
							<a target="_blank" href="<c:url value='/lawFirm/getOrderFirmDetail/${order.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">查看</a>
							<c:if test="${order.riskStatus eq 'ACCEPT' && order.riskUploadStatus eq 'UNUPLOADING' }">
								<a id="rateBtn" href="javascript:void(0);" onclick="showRiskReportModal('${order.oid}');" class="ns-btn">上传风评报告</a>
							</c:if>
						</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
	</tbody>
</table>
</div>
<!-- 分页 start -->
<nav class="text-center">
	<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
</nav>
<!-- 分页 end -->
<script>


	var totalCount = Number($('#totalCount').val()) || 0;
	var showCount = $('#showCount').val() || 5;
	var limit = Number($('#numPerPage').val()) || 5;
	
	$('#callBackPager').extendPagination({
		totalCount: totalCount,
		showCount: showCount,
		limit: limit,
		callback: function (curr, limit, totalCount) {
			getListForPage();
		}
	});

	function getListForPage(){
		var index = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/lawFirm/getOrderListForPage",
			data : $("#orderForm").serialize(),
			dataType : "text",
			success : function(data) {
				layer.close(index);
				$("#pageResult").html(data);			
			},
			error: function(){
				layer.close(index);
			}
		});
	}
</script>
