<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-我的账户</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
	<body>
		<form id="orderForm">
		<div class="container-fluid">
			<jsp:include page="../pcHeader.jsp"/>
			<div class="mar-content mt-80">
				<!-- 我的账户-业务查询 start -->
				<div class="container-fluid">
					<div class="tender-war">
						<div class="query-criteria">
							<h4>查询条件</h4>
								<div class="qucr-sub clearfix">
									<div class="w-98-auto"> 
										<div class="col-sm-4 col-xs-4">
											<p>订单号</p>
											<input name="orderNo" id="orderNo" type="text" class="form-control" placeholder="" />
										</div> 
										<div class="col-sm-4 col-xs-4">
											<p>项目名称</p>
											<input name="projectName" id="projectName" type="text" class="form-control" placeholder="" />
										</div> 
										<div class="col-sm-4 col-xs-4">
											<p>投保人名称</p>
											<input name="applicant" id="applicant" type="text" class="form-control" placeholder="" />
										</div> 
									</div>
									<div class="w-98-auto"> 
										<div class="col-sm-4 col-xs-4">
											<p>被保险人名称</p>
											<input name="recognizee" id="recognizee" type="text" class="form-control" placeholder="" />
										</div> 
										<div class="col-sm-4 col-xs-4">
											<p>订单生成时间</p>
											<div class="row">
												<div class="col-sm-5 col-xs-5"><input readonly="readonly" name="dateCreate_1" id="start" class="laydate-icon form-control"></div>
												<div class="col-sm-1 col-xs-1 lineation"><span></span></div>
												<div class="col-sm-5 col-xs-5"><input readonly="readonly" name="dateCreate_2" id="end" class="laydate-icon form-control"></div> 
											</div>
										</div> 
										<div class="col-sm-4 col-xs-4">
											<p>信息状态</p>
											<select name="messageStatus" id="messageStatus" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg'/>) 97% no-repeat  #fafafc;">
												<option value="">全部</option>
												<c:forEach items="${messageStatusList }" var="messageStatus">
													<option value="${messageStatus }">${messageStatus.name }</option>
												</c:forEach>
											</select> 
										</div> 
									</div>
								</div> 
								<div class="btn-bottom pull-right"> 
									<p><a href="javascript:submitOrderForm();" class="conserve pull-left">查询</a></p>
								</div>
						</div>
					</div>
					<div class="tender-war">
						<div class="query-criteria" id="queryResult">
					</div>
					</div>
				</div>
				<!-- 我的账户-业务查询 end -->
			</div><!-- mar-content 右边内容块 end -->
		</div>
		</form>
	</body>
	<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js'/>"></script>
	<script type="text/javascript">
		var baseUrl = '${pageContext.request.contextPath }';
		choiseMenu("insureInfo");
		
		//日期范围限制
		var start = {
		    elem: '#start',
		    format: 'YYYY-MM-DD',
		    max: laydate.now(), //最大日期
		    istoday: false,
		    choose: function(datas){
		        end.min = datas; //开始日选好后，重置结束日的最小日期
		        end.start = datas //将结束日的初始值设定为开始日 
		    }
		};
		var end = {
		    elem: '#end',
		    format: 'YYYY-MM-DD',
		    max: laydate.now(+1),
		    istoday: false,
		    choose: function(datas){
		        start.max = datas; //结束日选好后，充值开始日的最大日期
		    }
		};

		Date.prototype.Format = function (fmt) { //author: meizz 
		    var o = {
		        "M+": this.getMonth() + 1, //月份 
		        "d+": this.getDate(), //日 
		        "h+": this.getHours(), //小时 
		        "m+": this.getMinutes(), //分 
		        "s+": this.getSeconds(), //秒 
		        "q+": Math.floor((this.getMonth() + 3) / 3), //季度 
		        "S": this.getMilliseconds() //毫秒 
		    };
		    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
		    for (var k in o)
		    if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
		    return fmt;
		}
		laydate(start);
		laydate(end);
		
		function submitOrderForm(){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$("#pageNum").val("1");
			$.ajax({
				type : 'POST',
				url : baseUrl + "/insuranceFirm/applyForUnderwriteList",
				data : $("#orderForm").serialize(),
				dataType : "text",
				success : function(data) {
					layer.close(index);
					$("#queryResult").html(data);			
				},
				error: function(){
					layer.close(index);
				}
			});
		}
		
	</script>
</html>