<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
	<table class="table">
		<thead>
			<tr>
				<th>订单号</th>
				<th>投保人名称</th>
				<th>被保险人名称</th>
				<th>项目名称</th>
				<th>费率详情</th>
				<th>保单保函状态</th>
				<th>保单号</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:choose>
			<c:when test="${empty orderFirmList }">
				<tr><td colspan="7" style="text-align: center;">无查询结果</td></tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${orderFirmList }" var="orderFirm">
					<tr>
						<td>${orderFirm.orderNo }</td>
						<td>${orderFirm.applicant }</td>
						<td>${orderFirm.recognizee }</td>
						<td title="${orderFirm.policy.buildProject.projectName }">${orderFirm.policy.buildProject.projectName }</td>
						<td>${orderFirm.rate }%</td>
						<td>${orderFirm.backletterStatus.name }</td>
						<td>${empty orderFirm.policy.external_reference ? "未录入":orderFirm.policy.external_reference }</td>
						<td>
							<a target="_blank" href="<c:url value='/insuranceFirm/getOrderFirmDetail/${orderFirm.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">查看详情</a>
							<c:if test="${user.company.accountType ne 'HEADQUARTERS' && orderFirm.policy.policyStatus eq 'UPLOADGUARANTEE' && orderFirm.enteringStatus eq 'ENTERING' && orderFirm.backletterStatus eq 'UNUPLOADING'}">
								<a href="javascript:void(0);" onclick="showGuaranteesModal('${orderFirm.oid}');" class="ns-btn">上传保单保函</a>
							</c:if>
						</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
		</tbody>
	</table>
