<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-我的账户</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css'/>" />
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
	<body>
		<form id="orderForm">
		<div class="container-fluid">
			<jsp:include page="../pcHeader.jsp"/>
			<div class="mar-content mt-80">
				<!-- 我的账户-业务查询 start -->
				<div class="container-fluid">
					<div class="tender-war">
						<div class="query-criteria">
							<h4>查询条件</h4>
								<div class="qucr-sub clearfix">
									<div class="w-98-auto"> 
										<div class="col-sm-4 col-xs-4">
											<p>订单号</p>
											<input name="orderNo" id="orderNo" type="text" class="form-control" placeholder="" />
										</div> 
										<div class="col-sm-4 col-xs-4">
											<p>项目名称</p>
											<input name="projectName" id="projectName" type="text" class="form-control" placeholder="" />
										</div> 
										<div class="col-sm-4 col-xs-4">
											<p>投保人名称</p>
											<input name="applicant" id="applicant" type="text" class="form-control" placeholder="" />
										</div> 
									</div>
									<div class="w-98-auto"> 
										<div class="col-sm-4 col-xs-4">
											<p>被保险人名称</p>
											<input name="recognizee" id="recognizee" type="text" class="form-control" placeholder="" />
										</div> 
										<div class="col-sm-4 col-xs-4">
											<p>保单保函状态</p>
											<select name="backletterStatus" id="backletterStatus" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg'/>) 97% no-repeat  #fafafc;">
												<option value="">全部</option>
												<c:forEach items="${uploadingStatusList }" var="uploadingStatus">
													<option value="${uploadingStatus }">${uploadingStatus.name }</option>
												</c:forEach>
											</select> 
										</div> 
									</div>
								</div> 
								<div class="btn-bottom pull-right"> 
									<p><a href="javascript:submitOrderForm();" class="conserve pull-left">查询</a></p>
								</div>
						</div>
					</div>
					<div class="tender-war">
						<div class="query-criteria" id="queryResult">
					</div>
					</div>
				</div>
				<!-- 我的账户-业务查询 end -->
			</div><!-- mar-content 右边内容块 end -->
		</div>
		</form>
<!-- 上传保函 start -->
<div class="modal fade" id="revamp-guarantees" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content" style="width: 560px;">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">上传保单保函</h4>
		  </div>
		  <form id="guaranteesForm" method="post" enctype="multipart/form-data" action='<c:url value="/insuranceFirm/uploadGuarantees.json?ACCESS_TOKEN=${ACCESS_TOKEN}"/>' >
		  	<input type="hidden" id="orderId" name="orderFirmId" value="${orderFirm.oid }">
			  <div class="modal-body" style="height: 170px;">
			  	<div class="col-sm-12 col-xs-12" style="margin-bottom: 10px;"> 
			  		<div class="col-sm-3 col-xs-3" style="margin-top: 8px;">保单号：</div>
			  		<div class="col-sm-9 col-xs-9">
						<input type="text" class="form-control" style="width: 100%;" name="external_reference" id="externalReference" value="${mapPolicy['external_reference'] }">
					</div>
				</div>
				<div class="col-sm-12 col-xs-12" style="margin-bottom: 10px;">
					<div class="col-sm-3 col-xs-3" style="margin-top: 8px;">保单：</div>
					<div class="col-sm-9 col-xs-9" id="bdPath_isHidden">
						<div class="basic-file">
							<input name="bdPath_file" id="bdPath_file-5" class="file" type="file" data-drawview="${mapPolicy['bdPath'] }" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
						</div> 
					</div>
				</div>
				<div class="col-sm-12 col-xs-12">
					<div class="col-sm-3 col-xs-3" style="margin-top: 8px;">保函：</div>
					<div class="col-sm-9 col-xs-9" id="bhPath_isHidden">
						<div class="basic-file">
							<input name="bhPath_file" id="bhPath_file-5" class="file" type="file" data-drawview="${mapPolicy['bhPath'] }" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
						</div> 
					</div> 
			  	</div> 
			  </div>
			  <div class="modal-footer">
				<div class="mofo-sub">
					<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
					<button type="button" class="btn notarize-btn pull-right" onclick="uploadGuarantees('reload');">确认</button>
				</div>
			  </div> 
		  </form> 
		</div> 
  </div> 
</div>
<!-- 上传保函 end -->

</body>
<script type="text/javascript" src="<c:url value='/resources/js/insuranceFirm.js'/>"></script>
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
	choiseMenu("guarantee");
	
	function submitOrderForm(){
		var index = layer.load(0, {shade: [0.3,'#808080']});
		$("#pageNum").val("1");
		$.ajax({
			type : 'POST',
			url : baseUrl + "/insuranceFirm/guaranteeList",
			data : $("#orderForm").serialize(),
			dataType : "text",
			success : function(data) {
				layer.close(index);
				$("#queryResult").html(data);			
			},
			error: function(){
				layer.close(index);
			}
		});
	}
</script>

<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/jquery.form.js'/>"></script>
</html>