<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags"%>
<%@ page import="org.springframework.security.core.AuthenticationException"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>" />
<table class="table ">
	<tbody>
		<tr>
			<td class="col-sm-1 col-xs-1">逾期申报序号</td>
			<td class="col-sm-3 col-xs-3">买家公司名称</td>
			<td class="col-sm-1 col-xs-1">国家</td>
			<td class="col-sm-2 col-xs-2">逾期原因</td>
			<td class="col-sm-2 col-xs-2">逾期未付金额</td>
			<td class="col-sm-2 col-xs-2">申报时间</td>
			<td class="col-sm-2 col-xs-2">操作选项</td>
		</tr>

		<c:choose>
			<c:when test="${empty overDueList}">
				<tr>
					<td colspan="9" style="text-align: center;">暂无相关数据</td>
				</tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${overDueList}" var="overDue" varStatus="status">
					<tr>
						<td class="col-sm-1 col-xs-1">${overDue.oid}</td>
						<td class="col-sm-3 col-xs-3">买家公司待做</td>
						<td class="col-sm-1 col-xs-1">${overDue.shipmentDeclaration.buyersQuota.buyers_country}</td>
						<td class="col-sm-2 col-xs-2">${overDue.reason}</td>
						<td class="col-sm-2 col-xs-2">${overDue.overDueAmount}CNY</td>
						<td class="col-sm-2 col-xs-2">${overDue.applyTime}</td>
						<td class="col-sm-2 col-xs-2">操作待判断</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
	</tbody>
</table>