<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-逐单申报-新增出运申报</title>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css'/>" />
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
	<body>
		<div class="container-fluid">
			<jsp:include page="../../pcHeader.jsp"/>
			<div class="mar-content mt-80">
				<div class="container w100-mt20"><!-- container start --> 
				<div class="nav-list" >
					<div class="row">
						<div class="col-sm-4 col-sm-4">
							<p><i class="pull-left">1</i><span class=" pull-left">选择保单</span></p>
						</div>
						<div class="col-sm-4 col-sm-4">
							<p><i class="pull-left">2</i><span class="pull-left">逐单申报查询</span></p>
						</div>
						<div class="col-sm-4 col-sm-4 active">
							<p><i class="glyphicon glyphicon-ok pull-left"></i><span class="pull-left">新增/修改</span></p>
						</div> 
					</div>
				</div>
				<form id="addDeclarationForm" name="addDeclarationForm">
					<div class="message-war"><!-- message-war start --> 
						<div class="w-95-auto"><!-- w-95-auto start --> 
							<div class="clearfix">
								<div class="clearfix">
									<div class="col-sm-4 col-xs-4">
										<p>保单号</p>
										<input type="text" id="external_reference" name="external_reference" class="form-control" value="${insuredListAndBd.external_reference}" readonly="readonly">
									</div>
									<div class="col-sm-4 col-xs-4">
										<p>被保险人</p>
										<select id="insured" name="insured" class="form-control" style="background:url(images/public/select-btn.jpg) 97% no-repeat  #fafafc;">
											<option value="">-----请选择被保险人-----</option>
											<c:forEach items="${insuredListAndBd.insuredList}" var="insuredList">
			                                 <option value="${insuredList}" <c:if test="${insured eq insuredList}"> selected="selected"</c:if>>${insuredList}</option>
			                                </c:forEach>
										</select> 
									</div> 
								</div> 
								<div class="mess-title"><h3>选择买家</h3></div>
								<div class="clearfix">
									<div class="col-sm-4 col-xs-4">
										<p>买家代码</p>
										<input type="text" id="buyers_code" name="buyers_code" value="${topBuyersVo.code}" class="form-control" readonly="readonly">
										<input type="hidden" id="buyer_id_no" name="buyer_id_no">
										<input type="hidden" id="ins_top_buyers_id" name="ins_top_buyers_id" value='${ins_top_buyers_id}'>
									</div> 
									<div class="col-sm-4 col-xs-4 mt-30">
										<p><a href="javascript:void(0);" onclick="chooseBuyers()" >选择买家</a></p>
										<%-- <p><a href="${pageContext.request.contextPath}/ship/declare/findBuyers/${orderFormId}">选择买家</a></p> --%>
									</div>
								</div>
								<div class="clearfix">
									<div class="col-sm-4">
										<p>买家公司名称： </p>
										<input type="text" id="customer_name" name="customer_name" value="${topBuyersVo.customer_name}" readonly="readonly" class="form-control">
									</div>
									<div class="col-sm-4">
										<p>邮编： </p>
										<input type="text" id="" name="" value="" readonly="readonly" class="form-control">
									</div>
									<div class="col-sm-4">
										<p>注册地址：</p>
										<input type="text" id="adressTotal" name="adressTotal" readonly="readonly" value="${topBuyersVo.country}${topBuyersVo.address}" class="form-control">
									</div>
								</div>
								<div class="clearfix">
									<div class="col-sm-4">
										<p>证照类型： </p>
										<%--<input type="text" id="idType" name="id_type" value="${topBuyersVo.id_type}" readonly="readonly" class="form-control">--%>
										<input type="text" id="idType" name="id_type" value="${fns:getDictLabel (topBuyersVo.id_type,"iDType","")}" readonly="readonly" class="form-control">
									</div>
									<div class="col-sm-4">
										<p>证照号码： </p>
										<input type="text" id="idNo" name="id_no" value="${topBuyersVo.id_no}" readonly="readonly" class="form-control">
									</div>
									<div class="col-sm-4">
										<p>公司级别：</p>
										<input type="text" id="video_level" name="video_level" value="${fns:getDictLabel (topBuyersVo.video_level,"accountType","")}" disabled="disabled">
									</div>
								</div>
								<div class="clearfix">
									<div class="col-sm-4">
										<p>注册资本： </p>
										<input type="text" id="capital" name="capital" value="${topBuyersVo.capital}" readonly="readonly" class="form-control">
									</div>
									<div class="col-sm-4">
										<p>员工数： </p>
										<input type="text" id="emp_num" name="emp_num" value="${topBuyersVo.emp_num}" readonly="readonly" class="form-control">
									</div>
									<div class="col-sm-4">
										<p>行业类别：</p>
										<input type="text" id="vocation" name="vocation" value="${fns:getDictLabel (topBuyersVo.vocation,"enterpriseType","")}" disabled="disabled">
									</div>
								</div>
								<div class="clearfix">
									<div class="col-sm-4">
										<p>联系人姓名：</p>
										<input type="text" id="linkman" name="linkman" value="${topBuyersVo.linkman}" readonly="readonly" class="form-control">
									</div>
									<div class="col-sm-4">
										<p>电话号码：</p>
										<input type="text" id="phone" name="phone" value="${topBuyersVo.phone}" readonly="readonly" class="form-control">
									</div>
									<div class="col-sm-4">
										<p>当前余额：</p>
										<input type="text" id="unused_amount" name="unused_amount" readonly="readonly" value="${topBuyersVo.unused_amount}" class="form-control">
									</div>
									<%--<div class="col-sm-4">
										<p>临时限额申请方式：</p>
										<input type="text" id="" name="" value="" readonly="readonly" class="form-control">
									</div>--%>
								</div>
								<%--<div class="clearfix">
									<div class="col-sm-4">
										<p>临时限额：</p>
										<input type="text" id="" name="" value="" readonly="readonly" class="form-control">
									</div>
									<div class="col-sm-4">
										<p>永久限额申请方式：</p>
										<input type="text" id="" name="" value="" readonly="readonly" class="form-control">
									</div>
									<div class="col-sm-4">
										<p>永久信用限额：</p>
										<input type="text" id="" name="" value="" readonly="readonly" class="form-control">
									</div>
								</div>--%>
								<%--<div class="clearfix">
									<div class="col-sm-4">
										<p>当前余额：</p>
										<input type="text" id="unused_amount" name="unused_amount" readonly="readonly" value="${topBuyersVo.unused_amount}" class="form-control">
									</div>
									<div class="col-sm-4">
										<p>备注：</p>
										<input type="text" id="remark" name="remark" readonly="readonly" value="${topBuyersVo.remark}" class="form-control">
									</div> 
								</div>--%>
							</div>
							<!-- <div class="affirm-warr">
								<table class="table ">
			                        <tbody> 
										<tr>
											<td class="col-sm-3 col-xs-3">开证银行Swift</td>
											<td class="col-sm-3 col-xs-3">开证银行名称</td>
											<td class="col-sm-3 col-xs-3">金额</td>
											<td class="col-sm-3 col-xs-3">账期</td> 
										</tr>
										<tr>
											<td class="col-sm-3 col-xs-3">等需求</td>
											<td class="col-sm-3 col-xs-3">等需求</td>
											<td class="col-sm-3 col-xs-3">等需求</td>
											<td class="col-sm-3 col-xs-3">等需求</td> 
										</tr>
			                    	</tbody>
								</table>
							</div>  -->
							<div class="mess-title"><h3>出运信息</h3></div>
							<div class="clearfix">
								<div class="col-sm-4 col-xs-4">
									<p>发票号</p>
									<input type="text" id="invoice_no" name="invoice_no" class="form-control">
								</div> 
								<div class="col-sm-4 col-xs-4">
									<p>发票金额</p>
									<input type="text" id="invoice_amount" name="invoice_amount" class="form-control">
								</div>
								<div class="col-sm-4 col-xs-4">
									<p>投保金额USD</p>
									<input type="text" id="coverage" name="coverage" class="form-control">
								</div>
							</div>
							<div class="clearfix">
								<div class="col-sm-4 col-xs-4">
									<p>商品名称</p>
									<input type="text" id="trade_name" name="trade_name" class="form-control">
								</div> 
								<div class="col-sm-4 col-xs-4">
									<p>海关商品代码</p>
									<input type="text" id="ship_trade_no" name="ship_trade_no" class="form-control">
								</div>
								<div class="col-sm-4 col-xs-4">
									<p>海关商品名称</p>
									<input type="text" id="ship_trade_name" name="ship_trade_name" class="form-control">
								</div>
							</div>
							<div class="clearfix">
								<div class="col-sm-4 col-xs-4">
									<p>数量／包装</p>
									<input type="text" id="pack_num" name="pack_num" class="form-control">
								</div> 
								<div class="col-sm-4 col-xs-4">
									<p>结算方式</p>
									<select class="form-control" id="paymentTerms" name="payment_terms" style="background:url(images/public/select-btn.jpg) 97% no-repeat  #fafafc;">
										<c:forEach items="${paymentTermsList}" var="paymentTerms">
											<option value="${paymentTerms.value}">${paymentTerms.label}</option>
										</c:forEach>
									</select> 
								</div>
								<div class="col-sm-4 col-xs-4">
									<p>开证银行Swift</p>
									<select class="form-control" id="issuing_swift" name="issuing_swift" style="background:url(images/public/select-btn.jpg) 97% no-repeat  #fafafc;">
										<!-- <option value="test">请选择</option>  -->
										<option value="test">此处下拉框暂不处理</option>
									</select>
								</div>
							</div>
							<div class="clearfix">
								<div class="col-sm-4 col-xs-4">
									<p>合同账期(天)</p>
									<input type="text" id="contract_days" name="contract_days" class="form-control">
								</div> 
								<div class="col-sm-4 col-xs-4">
									<p>运输方式</p>
									<select class="form-control" id="transport_type" name="transport_type" style="background:url(images/public/select-btn.jpg) 97% no-repeat  #fafafc;">
										<c:forEach items="${transportTypeList}" var="transportType">
											<option value="${transportType.value}">${transportType.label}</option>
										</c:forEach>
									</select> 
								</div>
								<div class="col-sm-4 col-xs-4">
									<p>出运日期</p>
									<input id="delivery_time" name="delivery_time" class="laydate-icon form-control">
								</div>
							</div>
							<div class="clearfix">
								<div class="col-sm-4 col-xs-4">
									<p>报关单号</p>
									<input type="text" id="declaration_no" name="declaration_no" class="form-control">
								</div> 
								<div class="col-sm-4 col-xs-4">
									<p>付款到期日</p>
									<input id="pay_expire_time" name="pay_expire_time" class="laydate-icon form-control">
								</div>
								<input type="hidden" id="declare_type" name="declare_type" value="0">
							</div>
						</div><!-- w-95-auto end -->
					</div><!-- message-war end -->
				</form>
				<div class="row next-step"> 
					<div class="col-sm-6 col-xs-6">
						<p> 
							<!-- <a href="javascript:void(0);" onclick="submitForm()" class="ns-btn">申请</a> -->
							<a href="javascript:void(0);" onclick="addDeclaration()" class="ns-btn">新增出运</a> 
							<a href="javascript:void(0);" onclick="goBack('${orderFormId}')" class="ns-btn">上一步</a> 
						</p> 
					</div>
				</div>
				
				
			</div> <!-- container end --> 
			</div> <!-- mar-content 右边内容块 end -->
		</div>
	</body>
	
</html>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/extendPagination.js'/>" ></script>
<script type="text/javascript">
		choiseMenu("declare");
		var baseUrl = '${pageContext.request.contextPath}';

		function addDeclaration(){
			layer.confirm('确定新增此出运订单？', {
				  skin: 'confirmTip',
				  btn: ['确定','取消'] //按钮
				}, function(){
					layer.closeAll();
					var index = layer.load(0, {shade: [0.3,'#808080']});
					$.ajax({
						type : 'POST',
						url:baseUrl + "/ship/declare/addShipDeclare/"+'${orderFormId}',
						data: $("#addDeclarationForm").serialize(),
						dataType : "json",
						success : function(data) {
							if(data.statusCode == "200"){
								layer.msg(data.message);
								window.location = baseUrl + "/ship/declare/choise_new/${orderFormId}?ACCESS_TOKEN=${ACCESS_TOKEN}";
							}else{
								layer.msg(data.message);
								layer.close(index);
							}
						},
						error: function(){
							layer.msg("数据不完整，请重新填写并重试！");
							layer.close(index);
						}
					});
				});
		}
		
		function goBack(orderFormId){
			window.location = baseUrl + "/ship/declare/choise/" + orderFormId +"?ACCESS_TOKEN=${ACCESS_TOKEN}";
		}
		
		function chooseBuyers(){
			var insured = $("#insured").val();
			var bathUrl = '${pageContext.request.contextPath}';
			var orderFormId = '${orderFormId}';
			if(insured != null && insured != ""){
				window.location = bathUrl + "/ship/declare/findBuyers2/" + orderFormId + "?insured=" + insured+"&ACCESS_TOKEN=${ACCESS_TOKEN}";
			}else{ 
				window.location = bathUrl + "/ship/declare/findBuyers/" + orderFormId+"?ACCESS_TOKEN=${ACCESS_TOKEN}";
			}
		}
		
		
		//日期范围限制
		var pay_expire_time = {
		    elem: '#pay_expire_time',
		    format: 'YYYY-MM-DD hh:mm:ss',
		    min: '2015-01-01', //设定最小日期为当前日期
		    max: '2099-06-16', //最大日期
		    istime: true,
		    istoday: false,
		};
		//日期范围限制
		var delivery_time = {
		    elem: '#delivery_time',
		    format: 'YYYY-MM-DD hh:mm:ss',
		    min: '2015-01-01', //设定最小日期为当前日期
		    max: '2099-06-16', //最大日期
		    istime: true,
		    istoday: false,
		};
		Date.prototype.Format = function (fmt) { //author: meizz 
		    var o = {
		        "M+": this.getMonth() + 1, //月份 
		        "d+": this.getDate(), //日 
		        "h+": this.getHours(), //小时 
		        "m+": this.getMinutes(), //分 
		        "s+": this.getSeconds(), //秒 
		        "q+": Math.floor((this.getMonth() + 3) / 3), //季度 
		        "S": this.getMilliseconds() //毫秒 
		    };
		    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
		    for (var k in o)
		    if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
		    return fmt;
		}
		laydate(pay_expire_time);
		laydate(delivery_time);
</script>
