<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-我的账户</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css'/>"/> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css'/>"/>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/account/my-account.css'/>" />
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
	<body>
		<div class="container-fluid">
			<jsp:include page="pcHeader.jsp"/>
			<div class="mar-content mt-80">
				<div class="listing-war" id="claimArea"><!-- listing-war start -->
					<div class="list-title h-0"></div>
					<table class="table claims-query"> 
						<thead>
							<tr>
							  <th>报案号</th>
							  <th>保险产品</th>
							  <th>报案时间</th>
							  <th>状态</th>
							  <th>操作</th> 
							</tr>
						</thead>
						<tbody>
						<c:choose>
							<c:when test="${empty claimsList }">
								<tr>
									<td colspan="6" style="text-align: center;">暂无相关数据</td>
								</tr>
							</c:when>
							<c:otherwise>
								<c:forEach items="${claimsList }" var="claim">
									<tr>
										<td>${claim.claimNumber}</td>
										<td>${claim.policy.agreementSpec.name}</td>
										<td><fmt:formatDate pattern="yyyy-MM-dd HH:mm" value="${claim.caseTime}" /></td>
										<td>${claim.status.name}</td>
										<td><a href="#claim-detail" data-toggle="modal" onclick = "claimDetails('${claim.oid}');"><i class="glyphicon glyphicon-eye-open"></i>查看</a></td> 
									</tr>
								</c:forEach>
							</c:otherwise>
						</c:choose>
						</tbody>
					</table> 
				</div>
				<nav class="text-center">
					<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
				</nav>
				 <form id="claimForm">
	            	<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
	            	<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
	            	<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
	            </form>
			</div><!-- mar-content 右边内容块 end -->
			<!-- 修改账户信息 start -->
			<div class="modal fade" id="claim-detail" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
			   	<div class="modal-dialog" role="document">
					<div class="modal-content">
						<div class="modal-header bg-1f96ef">
							<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
							<h4 class="modal-title">理赔信息</h4>
						</div>
						<div class="modal-body" id="claim-dl">
						  	
						</div>
						<div class="modal-footer">
							<div class="mofo-sub">
								<button type="button" class="btn notarize-btn pull-right" data-dismiss="modal">确认</button>
							</div>
						</div> 
					</div>
			  </div> 
			</div> 
			<!-- 修改账户信息 end -->
		</div>
	</body>
	<form id="dow-now" action="<c:url value='/synopsis/sodownload'/>" method="post">
		<input name="path" id="path-dow" type="hidden">
		<input name="name" id="name-dow" type="hidden">
	</form>
	<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
	<script type="text/javascript">
		var baseUrl = '${pageContext.request.contextPath }';
		choiseMenu("claimQuery");
		
		var totalCount = Number($('#totalCount').val()) || 0;
		var showCount = $('#showCount').val() || 5;
		var limit = Number($('#numPerPage').val()) || 5;
		
		$('#callBackPager').extendPagination({
		totalCount: totalCount,
		showCount: showCount,
		limit: limit,
		callback: function (curr, limit, totalCount) {
			getListForPage("claimForm","claimArea");
		}
		});

		function getListForPage(formId,contentId){
			var index = layer.load(0, {shade: [0.3,'#808080']});
			$.ajax({
				type : 'POST',
				url : baseUrl + "/pc/claimList",
				data : $("#"+formId).serialize(),
				dataType : "text",
				success : function(data) {
					layer.close(index);
					$("#"+contentId).html(data);			
				},
				error: function(){
					layer.close(index);
				}
			});
		}
		
		
		function deletePolicy(policyId,policyStatus){
			layer.confirm('确定删除此订单？', {
			  skin: 'confirmTip',
			  btn: ['确定','取消'] //按钮
			}, function(){
				layer.closeAll();
				var index = layer.load(0, {shade: [0.3,'#808080']});
				$.ajax({
					type : 'POST',
					url : baseUrl + "/order/deletePolicy.json",
					data : {"policyId":policyId},
					dataType : "json",
					success : function(data) {
						layer.close(index);
						layer.msg(data.message);
						if(data.status =="200"){
							refreshTotal(policyStatus);
							getListForPage("orderForm","policysArea");
						}
					},
					error: function(){
						layer.close(index);
					}
				});
			});
		}
		
		function claimDetails(_id){
			$.ajax({
				type : 'POST',
				url : baseUrl + "/pc/claimDetails/"+_id,
				dataType : "html",
				success : function(data) {
					$("#claim-dl").html(data);
				},
				error: function(){
					layer.close(index);
				}
			});
		}
		
		function sodownload(path,name){
			path = path.split(".com/")[1];
			$("#path-dow").val(path);
			$("#name-dow").val(name);
			$("#dow-now").submit();
		}
	</script>
</html>

