<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="sec" uri="http://www.springframework.org/security/tags" %>
<%@ page import="org.springframework.security.core.AuthenticationException" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
<input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
<input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
<h4 class="mt-60">查询结果</h4>
<div class="query-result" id="pageResult">
	<table class="table">
		<thead>
			<tr>
				<th>订单号</th>
				<th>承保公司</th>
				<th>律师事务所</th>
				<th>审理法院</th>
				<th>订单时间</th>
				<th>结算状态</th>
				<th>结算日期</th>
				<th>投保人</th>
				<th>被保人</th>
				<th>咨询费</th>
				<th>操作</th>
			</tr>
		</thead>
		<tbody>
		<c:choose>
			<c:when test="${empty orderRecordList }">
				<tr><td colspan="11" style="text-align: center;">无查询结果</td></tr>
			</c:when>
			<c:otherwise>
				<c:forEach items="${orderRecordList }" var="orderRecord">
					<tr>
						<td>${orderRecord.orderNo }</td>
						<td>${orderRecord.policy.insurerUser.company.fullName }</td>
						<td>${orderRecord.userdetail.company.fullName }</td>
						<td>${orderRecord.court }</td>
						<td><fmt:formatDate pattern='yyyy-MM-dd HH:mm' value='${orderRecord.createOn }'/></td>
						<td>${orderRecord.status.name }</td>
						<td><fmt:formatDate pattern='yyyy-MM-dd HH:mm' value='${orderRecord.accountDate }'/></td>
						<td>${orderRecord.applicant }</td>
						<td>${orderRecord.recognizee }</td>
						<td>${orderRecord.coverCharge  }</td>
						<td>
							<a target="_blank" href="<c:url value='/order/policyDetail/${orderRecord.policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">详情</a>
						</td>
					</tr>
				</c:forEach>
			</c:otherwise>
		</c:choose>
		</tbody>
	</table>
</div>
<!-- 分页 start -->
<nav class="text-center">
	<div id="callBackPager" style="margin: 0 auto;text-align: center;"></div>
</nav>
<!-- 分页 end -->
<script>


	var totalCount = Number($('#totalCount').val()) || 0;
	var showCount = $('#showCount').val() || 5;
	var limit = Number($('#numPerPage').val()) || 5;
	
	$('#callBackPager').extendPagination({
		totalCount: totalCount,
		showCount: showCount,
		limit: limit,
		callback: function (curr, limit, totalCount) {
			getListForPage();
		}
	});

	function getListForPage(){
		var index = layer.load(0, {shade: [0.3,'#808080']});
		$.ajax({
			type : 'POST',
			url : baseUrl + "/order/findBusinessListByBox",
			data : $("#orderForm").serialize(),
			dataType : "text",
			success : function(data) {
				layer.close(index);
				$("#pageResult").html(data);			
			},
			error: function(){
				layer.close(index);
			}
		});
	}
</script>