<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>

<!DOCTYPE html>
<html>
<head>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/public.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/idangerous.swiper2.7.6.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/reset.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/applicantsd.css' />" />

    <meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
    <meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
    <meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
    <meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
    <title>百联保-我的账户</title>
</head>

<body>

<div class="container">
   <%-- <div class="addr">
        <span>当前位置：</span>
        <span class="current">首页 > </span>
        <a class="active" href="#">我的账户</a>
    </div>--%>
    <ul class="order-list">
        <li ${ policyStatus eq '25'?'class="active"':'' } onclick="choisePolicyStatus('25','${policyTotals['ALL'] }',this);">全部订单（${empty policyTotals['ALL'] ? '0' : policyTotals['ALL'] }）</li>
        <li ${ policyStatus eq '1'?'class="active"':'' } onclick="choisePolicyStatus('1','${policyTotals['INSSUM'] }',this);">投保中（${empty policyTotals['INSSUM'] ? '0' : policyTotals['INSSUM'] }）</li>
        <li ${ policyStatus eq '2'?'class="active"':'' } onclick="choisePolicyStatus('2','${policyTotals['AUDITSUM'] }',this);">待核保（${empty policyTotals['AUDITSUM'] ? '0' : policyTotals['AUDITSUM'] }）</li>
        <li ${ policyStatus eq '22'?'class="active"':'' } onclick="choisePolicyStatus('22','${policyTotals['NOPAYSUM'] }',this);">待支付（${empty policyTotals['NOPAYSUM'] ? '0' : policyTotals['NOPAYSUM'] }）</li>
        <li ${ policyStatus eq '5'?'class="active"':'' } onclick="choisePolicyStatus('5','${policyTotals['TOBEINSURED'] }',this);">待承保（${empty policyTotals['TOBEINSURED'] ? '0' : policyTotals['TOBEINSURED'] }）</li>
        <li ${ policyStatus eq '23'?'class="active"':'' } onclick="choisePolicyStatus('23','${policyTotals['DOPAY'] }',this);">已购买（${empty policyTotals['DOPAY'] ? '0' : policyTotals['DOPAY'] }）</li>
        <li ${ policyStatus eq '21'?'class="active"':'' } onclick="choisePolicyStatus('21','${policyTotals['UNDERWRITESUM'] }',this);">保障中（${empty policyTotals['UNDERWRITESUM'] ? '0' : policyTotals['UNDERWRITESUM'] }）</li>
        <li ${ policyStatus eq '24'?'class="active"':'' } onclick="choisePolicyStatus('24','${policyTotals['TORENEW'] }',this);">待续保（${empty policyTotals['TORENEW'] ? '0' : policyTotals['TORENEW'] }）</li>
        <%--<li class="look"><a href="#" class="look-all">查看全部>></a></li>--%>
    </ul>
    <div class="tab-query tab-order my-order">
        <div id="policysArea">
            <ul class="tab-title">
                <li class="wid-220">基本信息</li>
                <li>被保险人</li>
                <li>保障时间</li>
                <li>份数</li>
                <li>保费（元）</li>
                <li>状态</li>
                <li>操作</li>
            </ul>
            <div class="tab-content">
                <c:choose>
                    <c:when test="${empty orderList }">
                        <div class="order-detail">
                            <ul class="order-num">
                                <li style="float: none">
                                    <p style="text-align: center">暂无订单！！</p>
                                </li>
                            </ul>
                        </div>
                    </c:when>
                    <c:otherwise>
                        <c:forEach items="${orderList }" var="policy">
                            <div class="order-detail">
                                <ul class="order-num">
                                    <li>
                                        <span  class="num-name">订单号：</span>
                                        <span>${policy.trade_serial_number}</span>
                                    </li>
                                    <li>
                                        <span  class="num-name">保单号：</span>
                                        <span>${policy.external_reference}</span>
                                    </li>
                                    <li class="order-time">
                                        创建时间：${policy.start_time}
                                    </li>
                                </ul>
                                <ul class="tab-body">
                                    <li class="wid-220 two">
                                        <a href="<c:url value='/insurance/product/productInfo/${policy.product_oid }' />" class="insu">${policy.product_name }</a>
                                            <%--<c:if test="${ not empty policy.responsibilityVoList }">--%>
                                            <%--<div class="guar">--%>
                                            <%--保障权益--%>
                                            <%--<i class="down-icon"></i>--%>
                                            <%--</div>--%>
                                            <%--<ul class="guar-list">--%>
                                            <%--<c:forEach items="${policy.responsibilityVoList }" var="irp">--%>
                                            <%--<li>--%>
                                            <%--<span class="guar-name">${irp.name}</span>--%>
                                            <%--<span class="guar-money">${irp.fcy}${empty irp.compensation_days ? '元' : '元/天'}</span>--%>
                                            <%--</li>--%>
                                            <%--</c:forEach>--%>
                                            <%--</ul>--%>
                                            <%--</c:if>--%>
                                    </li>
                                    <li>
                                            ${policy.insured_role}
                                    </li>
                                    <li class="three">
                                        <div class="qoi">${fn:replace(policy.inception_date,' 00:00:00', '')}</div>
                                        <div>至</div>
                                        <div>${fn:replace(policy.planned_end_date,' 23:59:59', '')}</div>
                                    </li>
                                    <li>
                                        1份
                                    </li>
                                    <li>
                                        ￥${policy.gross_premium}
                                    </li>
                                    <li class="pay">
                                        <c:choose>
                                            <c:when test="${policy.policy_status eq '4' || policy.policy_status eq '16' }">
                                                ${fns:getDictLabel (policy.policy_status,"order_status","")}
                                            </c:when>
                                            <c:otherwise>
                                                ${fns:getDictLabel (policy.policy_status,"order_status","")}
                                            </c:otherwise>
                                        </c:choose>
                                    </li>
                                    <li class="pay-delete">
                                        <c:if test="${policy.policy_status != '1' }">
                                            <a target="_blank" href="<c:url value='/pc/order/exportDetailByOrderID/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">查看${ empty policy.external_reference ? '投保单':'保单'}</a>
                                        </c:if>
                                        <c:if test="${policy.policy_status eq '1' }">
                                            <c:if test="${policy.product_code eq 'BZX-TB-GCTB' }"><a target="_blank" href="<c:url value='/insurance/build/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
                                            <c:if test="${policy.product_code eq 'BZX-YG-GCTB' }"><a target="_blank" href="<c:url value='/insurance/build/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
                                            <c:if test="${policy.product_code eq 'BZX-GCLY' }"><a target="_blank" href="<c:url value='/insurance/build/policy/pg_policy/${policy.oid }/1?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
                                            <c:if test="${policy.product_code eq 'BZX-SSBQ' }"><a target="_blank" href="<c:url value='/insurance/lawsuit/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
                                            <c:if test="${policy.product_code eq 'XYX-XWCK' }"><a target="_blank" href="<c:url value='/insurance/customs/policy/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
                                            <c:if test="${policy.product_code eq 'XYX-DQCK' }"><a target="_blank" href="<c:url value='/insurance/customs/policy/qy_policy/${policy.oid }/1?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
                                            <c:if test="${fn:contains(policy.product_code, 'GZX') }"><a target="_blank" href="<c:url value='/insurance/afr/policy/policy_iframe/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
                                            <c:if test="${fn:contains(policy.product_code, 'TYX') }"><a target="_blank" href="<c:url value='/insurance/gmr/policy/policy_iframe/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">继续投保</a></c:if>
                                        </c:if>
                                        <c:if test="${policy.policy_status eq '3'}">
                                            <c:choose>
                                                <c:when test="${fn:contains(policy.product_code, 'TYX-PAC') }">
                                                    <a href="<c:url value='/insurance/gmr/policy/payment_iframe/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">缴费单</a>
                                                </c:when>
                                                <c:when test="${fn:contains(policy.product_code, 'GZZRX-ZH') }">
                                                    <a href="<c:url value='/insurance/gzzrx/policy/payment_iframe/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">缴费单</a>
                                                </c:when>
                                                <c:otherwise>
                                                    <a target="_blank" href="<c:url value='/insurance/customs/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="again-pay">确认报价</a>
                                                </c:otherwise>
                                            </c:choose>
                                        </c:if>
                                        <c:if test="${policy.policy_status eq '4'}">
                                            <c:if test="${policy.product_code eq 'BZX-TB-GCTB'}">
                                                <c:if test="${ empty policy.policy_serial_number}"><a target="_blank" href="<c:url value='/insurance/build/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="btn paying">立即支付</a></c:if>
                                                <c:if test="${not empty policy.policy_serial_number && not empty policy.show_url}"><a target="_blank" href="${policy.show_url}" class="btn paying">立即支付</a></c:if>
                                            </c:if>
                                            <c:if test="${ policy.product_code eq 'BZX-GCLY'}"><a target="_blank" href="<c:url value='/insurance/build/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="btn paying">立即支付</a></c:if>
                                            <c:if test="${policy.product_code eq 'BZX-SSBQ'}"><a target="_blank" href="<c:url value='/insurance/lawsuit/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="btn paying">立即支付</a></c:if>
                                            <c:if test="${fn:contains(policy.product_code, 'GZX') }"><a target="_blank" href="<c:url value='/insurance/afr/policy/payment_iframe/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="btn paying">立即支付</a></c:if>
                                            <c:if test="${fn:contains(policy.product_code, 'TYX') }"><a target="_blank" href="<c:url value='/insurance/gmr/policy/payment_iframe/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="btn paying">立即支付</a></c:if>
                                        </c:if>
                                        <c:if test="${ policy.policy_status eq '16'}">
                                            <a target="_blank" href="<c:url value='/insurance/customs/policy/policyPayment/${policy.oid }?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" class="btn paying">立即支付</a>
                                        </c:if>
                                        <c:if test="${policy.policy_status eq '1' || policy.policy_status eq '2' || policy.policy_status eq '4' }">
                                            <div class="delete" onclick="deleteExportOrder('${policy.oid }','${policy.policy_status }');">删除</div>
                                        </c:if>
                                    </li>
                                </ul>
                            </div>
                        </c:forEach>
                    </c:otherwise>
                </c:choose>
            </div>
        </div>
        <div class="filter-pagination">
            <div id="callBackPager"></div>
        </div>
    </div>		<!--右边部分介绍-->

    <div class="clearfix"></div>
    <form id="orderForm">
        <input type="hidden" id="policyStatus" name="policyStatus" value="${policyStatus }"/>
        <input type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
        <input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
        <input type="hidden" name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
    </form>
</div>

</body>
<script src="<c:url value='/resources/version_new/js/jquery-1.8.3.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/exportOrder.js'/>"></script>
<script src="<c:url value='/resources/js/extendPagination.js'/>" type="text/javascript"></script>
<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    $(function () {
        function mouse(even, stat, iconA, iconB) {
            $('.order-detail').on(even, '.guar', function () {
                $(this).siblings('.guar-list').css('display',stat);
                $(this).find('.' + iconA).removeClass(iconA).addClass(iconB);
            });
        }
        //鼠标移动到元素上显示
        mouse('mouseenter', 'block', 'down-icon', 'up-icon');
        //鼠标移出元素
        mouse('mouseleave', 'none', 'up-icon', 'down-icon');
    })
    var totalCount = Number($('#totalCount').val()) || 0;
    var showCount = $('#showCount').val() || 5;
    var limit = Number($('#numPerPage').val()) || 5;

    $('#callBackPager').extendPagination({
        totalCount: totalCount,
        showCount: showCount,
        limit: limit,
        callback: function (curr, limit, totalCount) {
            getListForPage("orderForm","policysArea");
        }
    });

    window.onload = function(){
        var l_length = $('.pagination').width();
        var l = parseInt((l_length)/2)
        $('.pagination').css({"right":"0"});
    }

    $('ul.order-list li').click(function () {
        var l_length = $('.pagination').width();
        var l = parseInt((l_length)/2)
        $('.pagination').css({"right":"0"});
    })
</script>
</html>
<script>
    $('ul.aside-list li').removeClass('on');
    $("#myOrder").addClass('on');
</script>