<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ include file="/WEB-INF/include/taglib.jsp"%>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1"/>
    <meta http-equiv="X-UA-Compatible" content="IE=9"/>
    <meta name="keywords"
          content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
    <meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
    <meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
    <title>百联保-新闻资讯</title>

    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />"/>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />"/>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/serve.css' />"/>
    <link type="text/css" rel="stylesheet"
          href="<c:url value='/resources/versions-2.0/dist/css/product/product-details.css' />"/>
    <link type="text/css" rel="stylesheet"
          href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />"/>
    <link type="text/css" rel="stylesheet"
          href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />"/>
    <!--[if lt IE 9]>
    <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
    <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
    <![endif]-->
    <link type="text/css" rel="stylesheet"
          href="<c:url value='/resources/versions-2.0/dist/css/news/public.css' />"/>
    <link type="text/css" rel="stylesheet"
          href="<c:url value='/resources/versions-2.0/dist/css/news/style.css' />"/>
</head>
<body>
<%--<jsp:include page="../header.jsp" />--%>
<jsp:include page="../index/multi_h.jsp" />
<div id="box">
    <div class="news-banner">
        <div class="banner"></div>
        <div class="banner-tab">
            <ul class="clearfix">
                <li>
                    <a href="javascript:;" class="ert">懂产品</a>
                    <div class="tab-cont">
                        <c:forEach items="${fns:getDictList('info_news_know_product')}" var="type">
                            <a href="javascript:;">
                                <option value="${type.value}" >${type.label}</option>
                            </a>
                        </c:forEach>
                    </div>
                </li>
                <li>
                    <a href="javascript:;" class="ert">学知识</a>
                    <div class="tab-cont">
                        <c:forEach items="${fns:getDictList('info_news_learn_knowledge')}" var="type">
                            <a href="javascript:;" >
                                <option value="${type.value}">${type.label}</option>
                            </a>
                        </c:forEach>
                    </div>
                </li>
                <li>
                    <a href="javascript:;" class="ert">读新闻</a>
                    <div class="tab-cont">
                        <c:forEach items="${fns:getDictList('info_news_read_news')}" var="type">
                        <a href="javascript:;" >
                            <option value="${type.value}" >${type.label}</option>
                        </a>
                        </c:forEach>
                </li>
                <li hidden>
                    <a href="javascript:;" class="ert">看热点</a>
                    <div class="tab-cont">
                        <c:forEach items="${fns:getDictList('info_news_see_hot')}" var="type">
                            <a href="javascript:;" >
                                <option value="${type.value}" >${type.label}</option>
                            </a>
                        </c:forEach>
                    </div>
                </li>
            </ul>
        </div>
    </div>
    <div class="news-content clearfix" id="productsArea">
        <div class="news-left">
            <div class="search">
                <form id="newsForm">
                    <input type="hidden"  id="condition" name="condition" />
                    <input  type="hidden" name="pageNum" id="pageNum" value="${dwzPage.pageNum}">
                    <input type="hidden" name="numPerPage" id="numPerPage" value="${dwzPage.numPerPage}">
                    <input type="hidden"  name="totalCount" id="totalCount" value="${dwzPage.totalCount}">
                    <input type="hidden"  name="info_news_type" id="info_news_type" value="${info_news_type}"/>
                    <input type="hidden"  name="keyword" id="keyword">
                    <input type="hidden"  name="rendering" id="rendering">
                </form>
                <input  id="keyname" name="keyname" type="text" placeholder="搜索文章标题及内容的关键字">
                <a href="javascript:void(0);" onclick="searchForm()">搜索</a>
            </div>
            <div >
                      <div class="news-tabs">
                        <ul class="clearfix">
                            <li>
                                <a href="javascript:void(0);" DT-VAL="1"  onclick="choiseProductCondition(this);">
                                    <span>阅读量</span>
                                    <img src="<c:url value='/resources/version_new/images/top-icon.png' />">
                                </a>
                            </li>
                            <li>
                                <a href="javascript:void(0);" DT-VAL="2" onclick="choiseProductCondition(this);">
                                    <span>发布时间</span>
                                    <img src="<c:url value='/resources/version_new/images/top-icon.png' />">
                                </a>
                            </li>
                        </ul>
                    </div>
                      <div class="news-details" id="infoNewsList">
                        <ul >
                            <c:forEach items="${infoNews.rows}" var="list">
                                <li>
                                    <a  target="_blank"  href="<c:url value='/infoNews/infoNewsInfo/${list.info_news_id}?ACCESS_TOKEN=${ACCESS_TOKEN}'/>"  class="clearfix">
                                        <div class="details-left left-s1">
                                            <img src="${list.photo_url}" style=" height: 156px;width: 260px;">
                                        </div>
                                        <div class="details-right">
                                            <h2>${list.title }</h2>
                                            <p>导读：${list.abstrct}</p>
                                            <div class="right-text">
                                                <span>阅读：${list.number}</span>
                                                <label>发布时间:<fmt:formatDate value="${list.update_time}" pattern="yyyy-MM-dd HH:mm:ss" /></label>
                                            </div>
                                        </div>
                                    </a>
                                </li>
                            </c:forEach>
                        </ul>
                    </div>
                   <c:if test="${empty infoNews.rows }">
                       <p id="l-wed">暂无相关专题资讯</p>
                   </c:if>
            </div>
            <div class="filter-pagination">
                <div id="callBackPager" class="wer-ert"></div>
            </div>

        </div>
        <div class="news-right" id="recommendList">
            <h2 style="margin-top: 0">资讯推荐</h2>
                <ul >
                    <c:forEach items="${infoNews.recommendList}" var="list">
                        <li>
                            <a target="_blank" href="<c:url value='/infoNews/infoNewsInfo/${list.info_news_id}?ACCESS_TOKEN=${ACCESS_TOKEN}'/>">
                                <p><span>${list.title }</span></p>
                            </a>
                            <div class="ert"></div>
                        </li>
                    </c:forEach>
                    <c:if test="${empty infoNews.recommendList }">
                        <p id="wed-l">暂无相关专题资讯推荐</p>
                    </c:if>
                </ul>
        </div>
    </div>
    <jsp:include page="../index/multi_f.jsp" />
</div>
</body>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery-2.1.1.min.js' />"></script>
<%--<script src="${ctxsta}/admin/main/js/bcxin.js"></script>--%>
<script type="text/javascript" src="<c:url value='/resources/js/infoNewsExtendPagination.js'/>" ></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/infoNews_g.js' />"></script>
<script>
    $(function () {
//        $('.banner-tab ul li:first').find('.tab-cont a:first').addClass('on');
        $('.banner-tab ul li').mouseover(function () {
            $(this).find('.tab-cont').show();
        }).mouseout(function () {
            $(this).find('.tab-cont').hide();
        });
        $('.banner-tab ul li .tab-cont a').click(function () {
            $('.banner-tab ul li .tab-cont a').removeClass('on');
            sdf = ($(this).find('option').val());
            $('#info_news_type').val(sdf);
            $('#pageNum').val("1");
            $("#keyword").val("");
            $("#rendering").val("");
            getListForPage();
            $(this).addClass('on');
        })
    });

//    var p = { limit: 8,
//        offset: 0,
////        info_news_type: $("#info_news_type"),
////        condition: $("#condition"),
////        keyword: $("#keyword")
//    };

    function fenye() {
        var totalCount = Number($('#totalCount').val()) || 0;
        var limit = Number($('#numPerPage').val()) || 8;
//        alert(totalCount);
//        alert(limit);
        $('#callBackPager').extendPagination({
            totalCount: totalCount,
            limit: limit,
            callback: function (curr, limit, totalCount) {
//                alert(totalCount);
//                alert(limit);
                getListForPage();
            },
        });
    }

    //初始化渲染分页
    $(document).ready(function(){
        fenye();
    });

    function wert(){
        $("#rendering").val("ture");
    }
    function searchForm(){
        var keyword= $('#keyname').val()
        $('#pageNum').val("1");
        $('#keyword').val(keyword);
        $("#rendering").val("");
        getListForPage();
    }

    function getListForPage() {
        var index = layer.load(0, {shade: [0.3, '#808080']});
        $.ajax({
            type: 'POST',
            url: "/infoNews/query",
            data: $("#newsForm").serialize(),
            dataType: "json",
            success: function (json) {
                layer.close(index);
                var html = "";
                var html2 = "";
                var rows = json.infoNewsPageResult.rows;
                var recommendList = json.infoNewsPageResult.recommendList;
                var page =json.page;
                $('#pageNum').val(page.pageNum);
                $('#numPerPage').val(page.numPerPage);
                $('#totalCount').val(page.totalCount);
                if (rows.length>0){
                    html = html+ '<ul >'
                    for (var i = 0; i < rows.length; i++) {
                        html = html + ' <li>'
                        html = html + '<a target="_blank" href="/infoNews/infoNewsInfo/' + rows[i].info_news_id + '?ACCESS_TOKEN=${ACCESS_TOKEN}"' + 'class="clearfix"' + '>'
                        html = html + '<div class="details-left left-s1">'
                        html = html + '<img src=' + rows[i].photo_url + ' style=" height: 156px;width: 260px;"></img>'
                        html = html + '</div>'
                        html = html + '<div class="details-right">'
                        html = html + '<h2>' + rows[i].title + '</h2>'
                        html = html + '<p>导读:' + rows[i].abstrct + '</p>'
                        html = html + '<div class="right-text">'
                        html = html + '<span>阅读：' + rows[i].number + '</span>'
                        html = html + '<label>发布时间：' + rows[i].update_time + '</label>'
                        html = html + '</div>'
                        html = html + '</div>'
                        html = html + '</a>'
                        html = html + '</li>'
                    }
                    html = html+ '</ul>'
//                    html = html+ '<div class="filter-pagination">'
//                    html = html+ '<div id="callBackPager" class="wer-ert"></div>'
//                    html = html+ '</div>'
                    $("#infoNewsList").html(html);
                }else {
                    html = html + ' <p id="l-wed">暂无相关专题资讯</p>'
                    html = html + '<div class="filter-pagination">'
                    html = html + '<div id="callBackPager" class="wer-ert"></div>'
                    html = html + '</div>'
                    $("#infoNewsList").html(html);
                }
                if(recommendList.length>0){
                    html2 = html2+ '<h2>资讯推荐</h2>     '
                    html2 = html2+ '<ul >'
                    for (var i in recommendList) {
                        html2 = html2 + '<li>'
                        html2 = html2 + '<a target="_blank" href="/infoNews/infoNewsInfo/' + recommendList[i].info_news_id + '?ACCESS_TOKEN=${ACCESS_TOKEN}">'
                        html2 = html2 + '<p>'
                        html2 = html2 + '<span>' + recommendList[i].title + '</span>'
                        html2 = html2 + '</p>'
                        html2 = html2 + '</a>'
                        html2 = html2 +  '<div class="ert"></div>'
                        html2 = html2 + '</li>'
                    }
                    html2 = html2+ '</ul> '
                    $("#recommendList").html(html2);
                }else {
                    html2 = html2 + '<h2>资讯推荐</h2>'
                    html2 = html2 + '<p id="wed-l">暂无相关专题资讯推荐</p>'
                    $("#recommendList").html(html2);
                }
                if (!json.rendering){

                    fenye();
                }
            },
            error: function () {
                layer.close(index);
            }


        });
    }

    function choiseProductCondition(obj){
        setDT(obj);
        $("#condition").val($(obj).attr('DT-VAL'));
        $('#pageNum').val("1");
        $("#rendering").val("");
        loadDataAndPage();
        getListForPage()
    }

    function loadDataAndPage(){
        totalCount = Number($('#totalCount').val()) || 0;
        limit = Number($('#numPerPage').val()) || 8;
        $('#callBackPager').extendPagination({
            totalCount: totalCount,
            limit: limit,
            callback: function (curr, limit, totalCount) {
                getListForPage("productForm","productsArea");
            }
        });
    };

    function setDT(obj){
        var dtv = $(obj).attr('DT-VAL');
        if(dtv == '1'){
            $(obj).attr('DT-VAL','-1');
            $(obj).find('img').attr('src','<c:url value='/resources/version_new/images/top-icon.png' />');
        }else if(dtv == '-1'){
            $(obj).attr('DT-VAL','1');
            $(obj).find('img').attr('src','<c:url value='/resources/version_new/images/bottom-icon.png' />');
        }else if(dtv == '2'){
            $(obj).attr('DT-VAL','-2');
            $(obj).find('img').attr('src','<c:url value='/resources/version_new/images/top-icon.png' />');
        }else if(dtv == '-2'){
            $(obj).attr('DT-VAL','2');
            $(obj).find('img').attr('src','<c:url value='/resources/version_new/images/bottom-icon.png' />');
        }
    }
    $('.news-tabs ul li a').click(function () {
        $('.news-tabs ul li a').find('span').css("color",'#333333');
        $(this).find('span').css("color",'#ff6600');
    })
</script>
</html>
