<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
	<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
	<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
	<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
	<title>百联保-填写投保单</title>

	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" />
</head>
<body style="background: rgba(244,245,246,1);">
<jsp:include page="../../../index/multi_h.jsp"/>

<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<%--<ol class="breadcrumb">
		<li><a href="<c:url value='/'/>">首页</a></li>
		<li><a href="<c:url value='/synopsis/product/productAllView'/>">产品列表</a></li>
		<li><a href="<c:url value='/insurance/product/productInfo/${dto.product_oid}'/>">产品详情</a></li>
		<li class="active">投保</li>
	</ol>--%>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<form class="form-horizontal form-create-item"  action="<c:url value='/insurance/lawsuit/policy/confirm?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post" id="policyInfoForm">
		<input type="hidden" name="oid" id="policyOid" value="${dto.oid}"/>
		<input type="hidden" name="product_id" id="productOid" value="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}"/>
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>提交资料</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-12 col-xs-12 reminder">
					<label>温馨提示：保险公司是否审核通过，受以下材料影响，请认真填写。</label>
				</div>
				<div class="col-sm-12 col-xs-12 h4-tiltle">
					<h4>一、起诉：</h4>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>*《起诉状》原件（盖公章）</p>
					<input type="hidden" name="qs_subfile_original" id="qs_subfile_original" value="${vo.qs_subfile_original}">
					<div>
						<input name="qs_subfile_original_file" id="qs_subfile_original_file-5" class="file" data-drawview="${vo.qs_subfile_original}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>*证据目录及证据（证据须标明来源、有无原件）</p>
					<input type="hidden" name="qs_subfile_proof" id="qs_subfile_proof" value="${vo.qs_subfile_proof}">
					<div>
						<input name="qs_subfile_proof_file" id="qs_subfile_proof_file-5" class="file" data-drawview="${vo.qs_subfile_proof}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-12 col-xs-12 h4-tiltle">
					<h4>二、保全：</h4>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>*《保全申请书》</p>
					<input type="hidden" name="bq_subfile_apply" id="bq_subfile_apply" value="${vo.bq_subfile_apply}">
					<div>
						<input name="bq_subfile_apply_file" id="bq_subfile_apply_file-5" class="file" data-drawview="${vo.bq_subfile_apply}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>*财产线索</p>
					<input type="hidden" name="bq_subfile_clew" id="bq_subfile_clew" value="${vo.bq_subfile_clew}">
					<div>
						<input name="bq_subfile_clew_file" id="bq_subfile_clew_file-5" class="file" data-drawview="${vo.bq_subfile_clew}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-12 col-xs-12 h4-tiltle">
					<h4>三、法院受理：</h4>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>受理案件通知书</p>
					<input type="hidden" name="sl_subfile_accepted" id="sl_subfile_accepted" value="${vo.sl_subfile_accepted}">
					<div>
						<input name="sl_subfile_accepted_file" id="sl_subfile_accepted_file-5" class="file" data-drawview="${vo.sl_subfile_accepted}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>诉讼须知、举证通知书</p>
					<input type="hidden" name="sl_subfile_notice" id="sl_subfile_notice" value="${vo.sl_subfile_notice}">
					<div>
						<input name="sl_subfile_notice_file" id="sl_subfile_notice_file-5" class="file" data-drawview="${vo.sl_subfile_notice}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>告知审判庭组成人员通知书</p>
					<input type="hidden" name="sl_subfile_tell" id="sl_subfile_tell" value="${vo.sl_subfile_tell}">
					<div>
						<input name="sl_subfile_tell_file" id="sl_subfile_tell_file-5" class="file" data-drawview="${vo.sl_subfile_tell}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="clear"></div>
				<div class="col-sm-12 col-xs-12 h4-tiltle">
					<h4>四、补充资料：</h4>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>资料一</p>
					<input type="hidden" name="supplement_a" id="supplement_a" value="${vo.supplement_a}">
					<div>
						<input name="supplement_a_file" id="supplement_a_file-5" class="file" data-drawview="${vo.supplement_a}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>资料二</p>
					<input type="hidden" name="supplement_b" id="supplement_b" value="${vo.supplement_b}">
					<div>
						<input name="supplement_b_file" id="supplement_b_file-5" class="file" data-drawview="${vo.supplement_b}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>资料三</p>
					<input type="hidden" name="supplement_c" id="supplement_c" value="${vo.supplement_c}">
					<div>
						<input name="supplement_c_file" id="supplement_c_file-5" class="file" data-drawview="${vo.supplement_c}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>资料四</p>
					<input type="hidden" name="supplement_d" id="supplement_d" value="${vo.supplement_d}">
					<div>
						<input name="supplement_d_file" id="supplement_d_file-5" class="file" data-drawview="${vo.supplement_d}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>

			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->

	</form>
	<div class="row next-step">
		<div class="col-sm-12 col-xs-12 text-right pull-right">
			<p>
				<a href="javascript:void(0);" onclick="saveSLInfo('3');" id="pendingInfo" dataWait="0" class="save">暂存本页</a>
				<a href="javascript:void(0);" id="next_policy" onclick="save_policy_sl('3');" class="ns-btn">下一步</a>
				<a href="javascript:void(0);" onclick="save_policy_sl_pre('2');" class="ns-btn">上一步</a>
			</p>
		</div>
	</div>
</div><!-- container end -->

<jsp:include page="../../../index/multi_f.jsp" />
</body>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script src="<c:url value='/resources/commonJS/con-common.js'/>" type="text/javascript"></script>
<script type="text/javascript" src="<c:url value='/resources/script/html2canvas.min.js' />"></script>
<%--<script type="text/javascript" src="<c:url value='/resources/commonJS/canvasFileUpload.js' />"></script>--%>

<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb.min.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb-save.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/watermark.js?7' />"></script>
<script>
	window.onload = function () {
		//以后优化 频繁变更水印
		watermark.load({ watermark_txt: "${fns:getWatermark(dto.trade_serial_number)}" });
	}
    var baseUrl = '${pageContext.request.contextPath }';

    var count = 2;
    $(function(){
        if($("#need_insur_bill").is(':checked')){
            $("#mod_1").fadeIn(1000);
        }else{
            $("#mod_1").fadeOut(1000);
        }
        if($("#need_receipt").is(':checked')){
            var _invoice_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
            $("#mod_2").fadeIn(1000);
            if(_invoice_val == "0"){//普通发票
                $("#mod_2_1").fadeIn(1000);
            }else{//专用发票,VATINVOICE
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
            }
        }else{
            $("#mod_2").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2_2").fadeOut(1000);
            $("#mod_2_3").fadeOut(1000);
        }
		document.onmousedown = function(ev){
			ev = ev || window.event;
			var nr = '已阅读并同意 roleSubjectList[0].reg_address appOrganizingPath_file roleSubjectList[1].reg_address appOrganizingPath1_file 【批量上传】 inception_date roleSubjectList[0].bank_account mailPolicyVo.taxpayer_number_invoice 暂存本页 下一步 ';
			var x=ev.clientX;
			var y=ev.clientY;
			if((ev.target.childNodes[0]!=undefined && nr.indexOf(ev.target.childNodes[0].data)!=-1) || nr.indexOf(ev.target.name)!=-1 ){
				if(ev.target.name=='inception_date'){
					//到这里需要整个页面都截图一次
					<%--insOperation('${dto.oid}','${sigId}','投保信息提交');--%>
				}
				insOperation('${dto.oid}','${dto.trade_serial_number}','投保信息提交');
			}
		}

    });
    function save_policy_sl_pre(_page){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        window.location.href = baseUrl + '/insurance/lawsuit/policy/lt_policy/${dto.oid}/'+_page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
    }
    function save_policy_sl(_page){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        $.ajax({
            type: 'POST',
            url:baseUrl + '/insurance/lawsuit/policy/pendingSpecialLitigation_3VoPolicy',
            data:$("#policyInfoForm").serialize(),
            dataType:"json",
            success: function(json){
                if(json.statusCode == '200') {
					insOperation('${dto.oid}','','投保信息提交');
					layer.close(index);
					window.location.href = baseUrl + '/insurance/lawsuit/policy/confirmPage/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
					/*var _t = setInterval(function () {
						if(_tong==1){
							clearInterval(_t);
							layer.close(index);
							window.location.href = baseUrl + '/insurance/lawsuit/policy/confirmPage/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
						}
					},300);*/
                }else{
					layer.close(index);
                    layer.msg(json.message);
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.close(index);
                layer.msg(textStatus);
            }
        });
    }
    function saveSLInfo(page){
        var doIDs = ['qs_subfile_original','qs_subfile_proof','bq_subfile_apply','bq_subfile_clew'];
        var cod = 0;
        for(var i=0;i<doIDs.length;i++){
            if($("#"+doIDs[i]).val() == ''){
                cod = 1;
			}
		}
		if(cod == 0){
            var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            $.ajax({
                type: 'POST',
                url:baseUrl + '/insurance/lawsuit/policy/pendingSpecialLitigation_'+page+'VoPolicy',
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    layer.close(index);
                    layer.msg(json.message);
                    if(json.statusCode == '200') {
                        window.location.href = baseUrl + '/insurance/lawsuit/policy/lt_policy/'+json.navTabId+'/'+page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.close(index);
                    layer.msg(textStatus);
                }
            });
        }else{
            layer.msg("请上传必填项（*）！");
		}
    }
    function isAllNull(){
        var values, index;
        values = $("#policyInfoForm").serializeArray();
        for (index = 0; index < values.length; ++index){
            var controls=document.getElementsByName(values[index].name);
            for(var i=0;i<controls.length;i++){
                if (!$("#"+controls[i].id).is(":hidden")&&values[index].value !=''){
                    return 1;//可见输入框存在至少一个框有填数据，暂存校验通过
                }
            }
        }
        return 0;//可见输入框不存在至少一个已填数据的框，暂存校验不通过
    }
    $(function(){
        $("input[id=need_insur_bill]").on("click",function(){
            if($(this).is(':checked')){
                $("#mod_1").fadeIn(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
            }else{
                $("#mod_1").fadeOut(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                    $(this).val('');
                });
            }
        });
        $("input[id=need_receipt]").on("click",function(){
            if($(this).is(':checked')){
                $("#mod_2").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
            }else{
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_2").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2").fadeOut(1000);
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
            }
        });
        $("input[name='mailPolicyVo.invoice_type']").on("click",function(){
            if($(this).val() == "1"){
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","");
                });
            }else{
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
            }
        });

        $("#recommend_code").on("blur",function(){
            var rCode = $(this).val();
            var pID = $(this).attr("data-relate");
            if(rCode != '' && pID != ''){
                if( pID != ''){
                    $.ajax({
                        type: 'POST',
                        url:baseUrl + '/insurance/build/policy/isFeeByrecommend_codeAndProductID.json',
                        data:{
                            'productID':pID,
                            'recommend_code':rCode
                        },
                        dataType:"json",
                        success: function(json){
                            layer.msg(json.message);
                            if(json.statusCode != '200') {
                                $(this).val('');
                            }
                        },
                        error : function(XMLHttpRequest, textStatus, errorThrown) {
                            layer.msg(textStatus);
                        }
                    });
                }else{
                    layer.msg("数据丢失，请刷新页面重试！");
                }

            }

        });
    });
    function changeDistrict(districtID, areaID, level, obj) {
        $("#" + districtID).empty();
        if(areaID != '') {
            $("#" + areaID).empty();
            $("#" + areaID).append("<option value=''>--请选择区县--</option>");
        }
        var code = obj.value;
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findCity.json',
            data:{"codeLevel":level,"parentCode":code},
            dataType:"json",
            async: false,
            success: function(json) {
                if(level == '2') {
                    $("#" + districtID).append("<option value=''>请选择市</option>");
                } else if(level == '3') {
                    $("#" + districtID).append("<option value=''>请选择区／县</option>");
                } else {
                    $("#" + districtID).append("<option value=''>--请选择--</option>");
                }
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + districtID).append(appendStr);
                }
            }
        });
    }
    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/policy/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"policy/",type);
        flag = true;
        return flag;
    }

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        var _myData = new Date();
        var _times = _myData.getTime();
        var name = "/"+directoryName+_times+"."+fileType;
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', _times+"."+fileType);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoad';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                layer.close(index);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                }else{
                    layer.msg(result.message);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }
</script>

<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
</html>