<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
	<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
	<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
	<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
	<title>百联保-填写投保单</title>

	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
	<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" />
</head>
<body style="background: rgba(244,245,246,1);">
<jsp:include page="../../../index/multi_h.jsp"/>

<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<%--<ol class="breadcrumb">
		<li><a href="<c:url value='/'/>">首页</a></li>
		<li><a href="<c:url value='/synopsis/product/productAllView'/>">产品列表</a></li>
		<li><a href="<c:url value='/insurance/product/productInfo/${dto.product_oid}'/>">产品详情</a></li>
		<li class="active">投保</li>
	</ol>--%>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<form class="form-horizontal form-create-item"  action="<c:url value='/insurance/lawsuit/policy/confirm?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post" id="policyInfoForm">
		<input type="hidden" name="oid" id="policyOid" value="${dto.oid}"/>
		<input type="hidden" name="product_id" id="productOid" value="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}"/>
		<div class="message-war pagemodel_2 " style="/* display: none; */"><!-- message-war start -->
			<div class="title-war"><h3>保险信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-3 col-xs-3" id="insuredAmount_isHidden">
					<p>*赔偿限额</p>
					<input Data-Val="Point Required" type="text" id="insured_amount" name="insured_amount" value="${vo.insured_amount}" class="form-control" />
					<span class="glyphicon form-control-feedback" aria-hidden="true"></span>
				</div>
				<div class="col-sm-3 col-xs-3">
					<p>保费</p>
					<div class="wait-price"><span>等待保险公司给出报价</span></div>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-12 col-xs-12" id="policyInterval_text_isHidden">
					<p>保险期间</p>
					<div><span>自保险人签发本保险单时起，至保险单载明的案件调解、裁定或判决生效，或解除财产保全时止。</span></div>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-12 col-xs-12" id="sifa_text_1_isHidden">
					<p>司法管辖</p>
					<div><span>中华人民共和国司法管辖（港澳台除外）</span></div>
				</div>
				<div class="clear"></div>
				<div class="bb-mt-e7"></div>
				<div class="col-sm-12 col-xs-12" id="zy_text_1_isHidden">
					<p>争议处理</p>
					<div><span>诉讼</span></div>
				</div>
			</div><!-- w-95-auto end -->
		</div>
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>单证信息</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-3 col-xs-3 mt-20">
                    <span class="pull-left check-box">
                        <input type="checkbox" value="1" name="mailPolicyVo.need_insur_bill" id="need_insur_bill" <c:if test="${not empty vo.mailPolicyVo.need_insur_bill && vo.mailPolicyVo.need_insur_bill eq '1'}"> checked="checked"</c:if>/>
                        <label for="need_insur_bill"></label>
                    </span>
					<span class="pull-left lhml5">需要纸质保单和保函</span>
				</div>
				<div class="clear"></div>
				<div id="mod_1" <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> style="display: none;"</c:if>>
					<div class="col-sm-3 col-xs-3">
						<p>*收件人名称</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.receiver_name" id="receiverName" value="${ vo.mailPolicyVo.receiver_name}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill ? true : vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*收件人手机</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.receiver_mobile" id="receiverMobile" value="${ vo.mailPolicyVo.receiver_mobile}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-6 col-xs-6">
						<p>*收件人地址</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.receiver_address_detail" id="receiverAddressDetail" value="${ vo.mailPolicyVo.receiver_address_detail}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="clear"></div>
					<div class="bb-mt-e7"></div>
				</div>
				<div class="col-sm-3 col-xs-3 mt-20">
                    <span class="pull-left check-box">
                        <input type="checkbox" value="1" name="mailPolicyVo.need_receipt" id="need_receipt" <c:if test="${not empty vo.mailPolicyVo.need_receipt && vo.mailPolicyVo.need_receipt eq '1'}"> checked="checked"</c:if> />
                        <label for="need_receipt"></label>
                    </span>
					<span class="pull-left lhml5">需要纸质发票</span>
				</div>
				<div class="clear"></div>
				<div id="mod_2" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> style="display: none;"</c:if>>
					<div class="col-sm-12 col-xs-12">
						<p>发票种类</p>
						<div class="row">
							<div class="col-sm-12 col-xs-12">
								<div class="row">
									<div class="col-sm-2 col-xs-2 rad-io">
										<span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_1" value="0" <c:if test="${empty vo.mailPolicyVo.invoice_type}"> checked="checked"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> checked="checked"</c:if>><label for="invoice_type_1" class="pull-left"></label><strong  class="pull-left">增值税普通发票</strong></span>
									</div>
									<div class="col-sm-2 col-xs-2 rad-io">
										<span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_2" value="1" <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '1' }"> checked="checked"</c:if>><label for="invoice_type_2" class="pull-left"></label><strong  class="pull-left">增值税专用发票</strong></span>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="col-sm-12 col-xs-12 reminder" id="mod_2_1" <c:if test="${empty vo.mailPolicyVo.invoice_type}"> style="display: none;"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> style="display: none;"</c:if>>
					<label>温馨提示：请认真填写下述信息，确保信息真实准确，以免因开票信息错误给贵司带来损失。提交信息后，我司将在1-2个工作日完成审核，请及时关注审核结果。</label>
				</div>
				<div id="mod_2_2" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> style="display: none;"</c:if>>
					<div class="col-sm-3 col-xs-3">
						<p>*单位名称</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.receipt_head" id="receipt_head" value="${ vo.mailPolicyVo.receipt_head}" class="form-control" placeholder="" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*收票人姓名</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.taker_name" id="takerName" value="${ vo.mailPolicyVo.taker_name}" class="form-control" placeholder="" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*收票人手机</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.taker_mobile" id="takerMobile" value="${ vo.mailPolicyVo.taker_mobile}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*收票人地址</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.taker_address_detail" id="takerAddressDetail" value="${ vo.mailPolicyVo.taker_address_detail}" class="form-control" placeholder="企业营业执照上的全称"  <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0'}"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3" <c:if test="${vo.mailPolicyVo.invoice_type eq '1'}"> style="display: none;"</c:if>>
						<p>*纳税人识别号</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice_1" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号"  <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0' || vo.mailPolicyVo.invoice_type eq '1'}"> data-status="hidden"</c:if>>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="clear"></div>
					<div class="bb-mt-e7"></div>
				</div>
				<div id="mod_2_3" <c:if test="${empty mailPolicyVo.invoice_type}"> style="display: none;"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> style="display: none;"</c:if>>
					<div class="col-sm-3 col-xs-3">
						<p>*纳税人识别号</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号" <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*注册地址</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.register_address_invoice" id="registerAddressInvoice" value="${ vo.mailPolicyVo.register_address_invoice}" class="form-control" placeholder="企业营业执照上的注册地址"  <c:if test="${empty mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*电话</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.receipt_phone" id="receiptPhone" value="${ vo.mailPolicyVo.receipt_phone}" class="form-control" placeholder="企业联系电话"  <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*开户银行省</p>
						<select Data-Val="Required" title="省" name="mailPolicyVo.bank_province" id="bankProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('bankCity', '', '2', this);" <c:if test="${empty mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
							<option value="">请选择省</option>
							<c:forEach items="${provinceList }" var="list">
								<option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_province }"> selected</c:if>>${list.named }</option>
							</c:forEach>
						</select>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*开户银行市</p>
						<select title="市" name="mailPolicyVo.bank_city" id="bankCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" <c:if test="${empty mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
							<option value="">请选择市</option>
							<c:forEach items="${bankCityList }" var="list">
								<option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_city}"> selected</c:if>>${list.named }</option>
							</c:forEach>
						</select>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*开户银行</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.bank_invoice" id="bankInvoice" value="${ vo.mailPolicyVo.bank_invoice}" class="form-control" placeholder="企业银行开户许可证上的开户银行"  <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="col-sm-3 col-xs-3">
						<p>*银行账号</p>
						<input Data-Val="Required" type="text" name="mailPolicyVo.bank_account_invoice" id="bankAccountInvoice" value="${ vo.mailPolicyVo.bank_account_invoice}" class="form-control" placeholder="企业开户许可证上的银行账号"  <c:if test="${empty vo.mailPolicyVo.invoice_type}"> data-status="hidden"</c:if> <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
						<span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
					</div>
					<div class="clear"></div>
					<div class="bb-mt-e7"></div>
					<div class="col-sm-4 col-xs-4">
						<p>税务登记证<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/tax.jpg')">（样例）</a></p>
						<input type="hidden" title="" name="mailPolicyVo.tax_cert" id="tax_cert" value="${vo.mailPolicyVo.tax_cert }">
						<div>
							<input title="" value="${vo.mailPolicyVo.tax_cert }" name="tax_cert_file" id="tax_cert_file-5" data-drawview="${vo.mailPolicyVo.tax_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4">
						<p>一般纳税人证明</p>
						<input type="hidden" title="" name="mailPolicyVo.tax_prove" id="tax_prove" value="${vo.mailPolicyVo.tax_prove }">
						<div>
							<input title="" value="${vo.mailPolicyVo.tax_prove }" name="tax_prove_file" id="tax_prove_file-5" data-drawview="${vo.mailPolicyVo.tax_prove }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4">
						<p>银行开户许可证</p>
						<input type="hidden" title="" name="mailPolicyVo.bank_licence" id="bank_licence" value="${vo.mailPolicyVo.bank_licence }">
						<div>
							<input title="" value="${vo.mailPolicyVo.bank_licence }" name="bank_licence_file" id="bank_licence_file-5" data-drawview="${vo.mailPolicyVo.bank_licence}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4">
						<p>营业执照副本<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/open.jpg')">（样例）</a></p>
						<input type="hidden" title="" name="mailPolicyVo.business_license" id="business_license" value="${vo.mailPolicyVo.business_license }">
						<div>
							<input title="" value="${vo.mailPolicyVo.business_license }" name="business_license_file" id="business_license_file-5" data-drawview="${vo.mailPolicyVo.business_license}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
					</div>
					<div class="col-sm-4 col-xs-4">
						<p>增票授权委托书（个人支付时需提供此委托书<a href="<c:url value='/resources/files/增票授权委托书.doc' />" target="_blank">下载</a>）</p>
						<input type="hidden" title="" name="mailPolicyVo.auth_cert" id="auth_cert" value="${vo.mailPolicyVo.auth_cert}">
						<div>
							<input title="" value="${vo.mailPolicyVo.auth_cert }" name="auth_cert_file" id="auth_cert_file-5" data-drawview="${vo.mailPolicyVo.auth_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
						</div>
						<span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
					</div>
				</div>
			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->
	</form>
	<div class="row next-step">
		<div class="col-sm-12 col-xs-12 text-right pull-right">
			<p>
				<a href="javascript:void(0);" onclick="saveSLInfo('2');" id="pendingInfo" dataWait="0" class="save">暂存本页</a>
				<a href="javascript:void(0);" id="next_policy" onclick="save_policy_sl('3');" class="ns-btn">下一步</a>
				<a href="javascript:void(0);" onclick="save_policy_sl_pre('1');" class="ns-btn">上一步</a>
			</p>
		</div>
	</div>
</div><!-- container end -->

<jsp:include page="../../../index/multi_f.jsp" />
</body>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/script/html2canvas.min.js' />"></script>
<%--<script type="text/javascript" src="<c:url value='/resources/commonJS/canvasFileUpload.js' />"></script>--%>

<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb.min.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb-save.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/watermark.js?7' />"></script>
<script>
	window.onload = function () {
		//以后优化 频繁变更水印
		watermark.load({ watermark_txt: "${fns:getWatermark(dto.trade_serial_number)}" });
	}
    $(function () {

        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas('','/pc/tb-mail-address/${userdetail.oid}',false,false,function(json){
            if(json != undefined && json != null){
                if(!$('#need_insur_bill').is(":checked")) {
                    $('#need_insur_bill').on('click', function () {//纸质发票
                        if ($(this).is(":checked")) {
                            $("#receiverName").val(json.user_name);
                            $("#receiverMobile").val(json.telephone);
                            $("#receiverAddressDetail").val(json.address);
                        }
                    });
                }
                if(!$('#need_receipt').is(":checked")) {
                    $('#need_receipt').on('click',function(){//电子发票
                        if($(this).is(":checked")){
                            $("#takerName").val(json.user_name);
                            $("#takerMobile").val(json.telephone);
                            $("#takerAddressDetail").val(json.address);
                        }
                    });
                }
            }

        });
		document.onmousedown = function(ev){
			ev = ev || window.event;
			var nr = '已阅读并同意 roleSubjectList[0].reg_address appOrganizingPath_file roleSubjectList[1].reg_address appOrganizingPath1_file 【批量上传】 inception_date roleSubjectList[0].bank_account mailPolicyVo.taxpayer_number_invoice 暂存本页 下一步 ';
			var x=ev.clientX;
			var y=ev.clientY;
			if((ev.target.childNodes[0]!=undefined && nr.indexOf(ev.target.childNodes[0].data)!=-1) || nr.indexOf(ev.target.name)!=-1 ){
				if(ev.target.name=='inception_date'){
					//到这里需要整个页面都截图一次
					<%--insOperation('${dto.oid}','${sigId}','投保信息提交');--%>
				}
				insOperation('${dto.oid}','${dto.trade_serial_number}','投保信息提交');
			}
		}
    })

</script>
<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    function openImgView(img_url){
        top.layer.open({
            type: 1,
            skin: 'layui-layer-rim', //加上边框
            area: ['420px', '350px'], //宽高
            content: '<div><img src='+baseUrl+img_url+' width="100%" /></div>'
        });
    }
    var count = 2;
    $(function(){
        if($("#need_insur_bill").is(':checked')){
            $("#mod_1").fadeIn(1000);
        }else{
            $("#mod_1").fadeOut(1000);
        }
        if($("#need_receipt").is(':checked')){
            var _invoice_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
            $("#mod_2").fadeIn(1000);
            if(_invoice_val == "0"){//普通发票
                $("#mod_2_1").fadeIn(1000);
            }else{//专用发票,VATINVOICE
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
            }
        }else{
            $("#mod_2").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2_2").fadeOut(1000);
            $("#mod_2_3").fadeOut(1000);
        }

    });
    function save_policy_sl_pre(_page){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        window.location.href = baseUrl + '/insurance/lawsuit/policy/lt_policy/${dto.oid}/'+_page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
    }
    function save_policy_sl(_page){
        if(customsVerify()){
            var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            $.ajax({
                type: 'POST',
                url:baseUrl + '/insurance/lawsuit/policy/pendingSpecialLitigation_2VoPolicy',
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    if(json.statusCode == '200') {
						insOperation('${dto.oid}','','投保信息提交');
						layer.close(index);
						window.location.href = baseUrl + '/insurance/lawsuit/policy/lt_policy/'+json.navTabId+'/'+_page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
						/*var _t = setInterval(function () {
							if(_tong==1){
								clearInterval(_t);
								layer.close(index);
								window.location.href = baseUrl + '/insurance/lawsuit/policy/lt_policy/'+json.navTabId+'/'+_page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
							}
						},300);*/
                    }else{
						layer.close(index);
                        layer.msg(json.message);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.close(index);
                    layer.msg(textStatus);
                }
            });
        }
    }
    function saveSLInfo(page){
        mailSet();
        if(isAllNull() == 1){
            var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            $.ajax({
                type: 'POST',
                url:baseUrl + '/insurance/lawsuit/policy/pendingSpecialLitigation_'+page+'VoPolicy',
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    layer.close(index);
                    layer.msg(json.message);
                    if(json.statusCode == '200') {
                        window.location.href = baseUrl + '/insurance/lawsuit/policy/lt_policy/'+json.navTabId+'/'+page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.close(index);
                    layer.msg(textStatus);
                }
            });
        }else{
            layer.msg("表单未检索到数据，请完善信息后暂存！");
        }
    }
    function mailSet(){
        var invoice_type_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
        if(invoice_type_val == "0"){
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
            $("#mod_2_3").find("select").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_insur_bill").is(':checked')){
            $("#mod_1").find("input").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_receipt").is(':checked')){
            $("#mod_2_2").find("input").each(function(){
                $(this).val('');
            });
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
        }
    }
    function isAllNull(){
        var values, index;
        values = $("#policyInfoForm").serializeArray();
        for (index = 0; index < values.length; ++index){
            var controls=document.getElementsByName(values[index].name);
            for(var i=0;i<controls.length;i++){
                if (!$("#"+controls[i].id).is(":hidden")&&values[index].value !=''){
                    return 1;//可见输入框存在至少一个框有填数据，暂存校验通过
                }
            }
        }
        return 0;//可见输入框不存在至少一个已填数据的框，暂存校验不通过
    }
    function customsVerify(){
        var flag = true;
        $("input[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){

                    if($(this).val() == ''){
                        document.getElementById(this.id).scrollIntoView();
                        layer.msg("必填项不能为空！");
                        $(this).focus();
                        flag = false;
                        return true;
                    }else{
                        if(dataVal == "Point Required"){
                            var regm = /^[0-9]+.?[0-9]*$/;
                            if(!regm.test($(this).val())){
                                layer.msg("请输入正确的数量格式！");
                                $(this).focus();
                                flag = false;
                                return true;
                            }
						}
                        if($(this).val().length>40){
                            document.getElementById(this.id).scrollIntoView();
                            layer.msg("长度超出限制！");
                            $(this).focus();
                            flag = false;
                            return true;
                        }
                    }

                }
            }
        });
        if(flag){
            $("select[Data-Val]").each(function(){
                var dataVal = $(this).attr("Data-Val");
                if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                    if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            layer.msg("必填项不能为空！");
                            $(this).focus();
                            flag = false;
                            return true;
                        }

                    }
                }
            });
            if(flag){
                $("textarea[Data-Val]").each(function(){
                    var dataVal = $(this).attr("Data-Val");
                    if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                        if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                            if($(this).val() == ''){
                                document.getElementById(this.id).scrollIntoView();
                                layer.msg("必填项不能为空！");
                                $(this).focus();
                                flag = false;
                                return true;
                            }else{
                                if($(this).val().length>100){
                                    document.getElementById(this.id).scrollIntoView();
                                    layer.msg("长度超出限制(100字符)！");
                                    $(this).focus();
                                    flag = false;
                                    return true;
                                }
                            }

                        }
                    }
                });

            }
        }
        mailSet();
        return flag;
    }
    $(function(){
        $("input[id=need_insur_bill]").on("click",function(){
            if($(this).is(':checked')){
                $("#mod_1").fadeIn(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
            }else{
                $("#mod_1").fadeOut(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                    $(this).val('');
                });
            }
        });
        $("input[id=need_receipt]").on("click",function(){
            if($(this).is(':checked')){
                $("#mod_2").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
            }else{
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_2").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2").fadeOut(1000);
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
            }
        });
        $("input[name='mailPolicyVo.invoice_type']").on("click",function(){
            if($(this).val() == "1"){
                $("#taxpayerNumberInvoice_1").parent().hide();
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#taxpayerNumberInvoice_1").attr("data-status","hidden");
            }else{
                $("#taxpayerNumberInvoice_1").parent().show();
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#taxpayerNumberInvoice_1").attr("data-status","");
            }
        });

        $("#recommend_code").on("blur",function(){
            var rCode = $(this).val();
            var pID = $(this).attr("data-relate");
            if(rCode != '' && pID != ''){
                if( pID != ''){
                    $.ajax({
                        type: 'POST',
                        url:baseUrl + '/insurance/build/policy/isFeeByrecommend_codeAndProductID.json',
                        data:{
                            'productID':pID,
                            'recommend_code':rCode
                        },
                        dataType:"json",
                        success: function(json){
                            layer.msg(json.message);
                            if(json.statusCode != '200') {
                                $(this).val('');
                            }
                        },
                        error : function(XMLHttpRequest, textStatus, errorThrown) {
                            layer.msg(textStatus);
                        }
                    });
                }else{
                    layer.msg("数据丢失，请刷新页面重试！");
                }

            }

        });
    });
    function changeDistrict(districtID, areaID, level, obj) {
        $("#" + districtID).empty();
        if(areaID != '') {
            $("#" + areaID).empty();
            $("#" + areaID).append("<option value=''>--请选择区县--</option>");
        }
        var code = obj.value;
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findCity.json',
            data:{"codeLevel":level,"parentCode":code},
            dataType:"json",
            async: false,
            success: function(json) {
                if(level == '2') {
                    $("#" + districtID).append("<option value=''>请选择市</option>");
                } else if(level == '3') {
                    $("#" + districtID).append("<option value=''>请选择区／县</option>");
                } else {
                    $("#" + districtID).append("<option value=''>--请选择--</option>");
                }
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + districtID).append(appendStr);
                }
            }
        });
    }
    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/policy/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"policy/",type);
        flag = true;
        return flag;
    }

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        var _myData = new Date();
        var _times = _myData.getTime();
        var name = "/"+directoryName+_times+"."+fileType;
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', _times+"."+fileType);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoad';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                layer.close(index);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                }else{
                    layer.msg(result.message);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }
</script>

<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
</html>