<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>

    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/rrweb/css/rrweb.min.css?001' />" />
<%--    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/rrweb@latest/dist/rrweb.min.css"/>--%>
    <style>
        .laydate-icon {
            padding-left: 40px;
        }
    </style>
</head>
<body>
<jsp:include page="../../../index/multi_h.jsp"/>
<div class="container"><!-- container start -->
    <ol class="breadcrumb" id="bread_crumbs">
    </ol>
    <div class="nav-list">
        <div class="row w-80-auto">
            <div class="col-sm-3 col-sm-4 active">
                <p><i class="pull-left">1</i><span class=" pull-left">填写保险信息</span></p>
            </div>
            <div class="col-sm-3 col-sm-4">
                <p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
            </div>
            <div class="col-sm-3 col-sm-3">
                <p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
            </div>
            <div class="col-sm-3 col-sm-3 pull-right">
                <p><i class="pull-left">4</i><span class="pull-left"> 完成投保</span></p>
            </div>
        </div>
    </div>
    <form class="form-horizontal form-create-item" method="post" id="policyInfoForm">
        <input type="hidden" name="oid" id="policyOid" value="${dto.oid}"/>
        <input type="hidden" name="product_id" id="productOid" value="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}"/>
        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>推荐人信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-4 col-xs-4">
                    <p>推荐人的手机号或编号</p>
                    <input type="text" name="recommend_code" id="recommend_code" data-relate="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}" value="${empty vo.recommend_code ? recommend_code : vo.recommend_code}" class="form-control" placeholder="请输入推荐人的手机号或编号" maxlength="20"/>
                    <input type="hidden" name="sigId" value="${dto.trade_serial_number}"/>
                </div>
                <div class="col-sm-4 col-xs-4">
                </div>
                <div class="col-sm-4 col-xs-4">
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <input type="hidden" name="roleSubjectList[0].oid" id="role_appRoleID_0" value="${vo.roleSubjectList[0].oid}"/>
            <input type="hidden" name="roleSubjectList[0].kind" id="role_kind_0" value="1"/>
            <input type="hidden" name="roleSubjectList[0].roleType" id="role_roleType_0" value="1"/>
            <div class="title-war"><h3 id="cy_lxr">投保人信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <c:if test="${fn:contains(pd.product_code,'GZZRX-QH')}">
                <div class="col-sm-12 col-xs-12 reminder" style="line-height: 25px;">
                    <label>
                        温馨提示：<br/>
                        1.本保险产品仅限保安行业及物业行业企业投保，仅承保16周岁（含16周岁）至60周岁且职业为内勤人员、保安人员、保洁人员的雇员。<span style="color:red;">当被保险人所属行业或雇员的年龄职业不符合前述要求时，保险人有权解除合同，保险合同自始无效，且不承担保险责任。本保险产品同一雇员累计最高有效承保份数为1份，多投无效。 </span> <br/>
<%--                        <span style="color:red;">2.本保单承保区域仅限“北京、陕西、湖南、广西、宁夏、山东、天津、江苏”，对于被保险人雇员工作地址超出承保区域的投保或出险不承担任何赔偿或给付责任。</span>--%>
                    </label>
                </div>
                </c:if>
                <div class="col-sm-3 col-xs-3">
                    <p>*投保单位<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="请填写与营业执照相一致的单位名称，个人不能作为投保单位"></i></p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].name_cn" id="role_namecn_0" value="${vo.roleSubjectList[0].name_cn}" class="form-control" data-toggle="tooltip" data-placement="top" title="请填写与营业执照相一致的单位名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*所属行业</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[0].industry" id="role_industry_0" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="保安服务业" <c:if test="${empty vo.roleSubjectList[0].industry || vo.roleSubjectList[0].industry eq '保安服务业' }"> selected="selected"</c:if>>保安服务业</option>
                        <c:if test="${fn:contains(pd.product_code,'GZZRX-PAC')||fn:contains(pd.product_code,'GZZRX-CA')}"><option value="家政服务业" <c:if test="${vo.roleSubjectList[0].industry eq '家政服务业' }"> selected="selected"</c:if>>家政服务业</option></c:if>
                    </select>
                </div>
                <div class="col-sm-6 col-xs-6">
                    <p>*营业性质</p>
                    <div class="row">
                        <div class="col-sm-6 col-xs-6">
                            <select data-val="Required" name="roleSubjectList[0].com_nature" id="role_comNature_0" class="form-control" onchange="natureChange(this,'role_natureTwo_0');" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">-请选择-</option>
                                <c:forEach items="${natureList }" var="list">
                                    <option value="${list.value }" <c:if test="${vo.roleSubjectList[0].com_nature eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6" <c:if test="${empty vo.roleSubjectList[0].nature_two }"> hidden</c:if>>
                            <select name="roleSubjectList[0].nature_two" id="role_natureTwo_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">-请选择-</option>
                                <c:forEach items="${natureTwoList }" var="list">
                                    <option value="${list.value }" <c:if test="${vo.roleSubjectList[0].nature_two eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                </c:forEach>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件类型</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[0].id_type" id="role_idType_0" value="${vo.roleSubjectList[0].id_type}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">-请选择-</option>
                        <c:if test="${fn:contains(pd.product_code,'GZZRX-CA')}">
                            <option value="2" <c:if test="${vo.roleSubjectList[0].id_type eq '2' }"> selected="selected"</c:if>>三证合一统一信用代码</option>
                        </c:if>
                        <c:if test="${!fn:contains(pd.product_code,'GZZRX-CA')}">
                            <c:forEach items="${comTypeList }" var="list">
                                <option value="${list.value }" <c:if test="${vo.roleSubjectList[0].id_type eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                            </c:forEach>
                        </c:if>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件号码</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].organization_code" id="role_organizationCode_0" GIST-ID="role_idType_0" value="${vo.roleSubjectList[0].organization_code}" class="form-control" data-toggle="tooltip" data-placement="top" title="组织机构代码：只能包含数字或英文大写字母，必须用连字符“-”隔开；营业执照：只能为15位数字；税务登记证：只能为15位数字，或20位数字，或19位数字与字母X组合；三证合一统一信用代码：由数字或大写英文字母组成，共18位"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件有效期起始</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[0].id_option" id="role_idOption_0" value="${vo.roleSubjectList[0].id_option}" onchange="isNeedDate(this,'role_idStarDate_0','role_idEndDate_0')" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">-请选择-</option>
                        <c:forEach items="${idOptionList }" var="list">
                            <option value="${list.value }" <c:if test="${vo.roleSubjectList[0].id_option eq list.value }"> selected="selected"</c:if>>${list.label }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3" hidden>
                    <p>*证件有效期始期</p>
                    <input Data-Val="Required" <c:if test="${empty vo.roleSubjectList[0].id_star_date}"> data-status="hidden"</c:if> type="text" name="roleSubjectList[0].id_star_date" id="role_idStarDate_0" value="${vo.roleSubjectList[0].id_star_date}" class="laydate-icon form-control" onclick="laydate({elem: '#role_idStarDate_0',format: 'YYYY-MM-DD'});"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3" hidden>
                    <p>*证件有效期止期</p>
                    <input Data-Val="Required" <c:if test="${empty vo.roleSubjectList[0].id_end_date}"> data-status="hidden"</c:if> type="text" name="roleSubjectList[0].id_end_date" id="role_idEndDate_0" value="${vo.roleSubjectList[0].id_end_date}" class="laydate-icon form-control" onclick="laydate({elem: '#role_idEndDate_0',format: 'YYYY-MM-DD'});"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*雇员人数（人）</p>
                    <input Data-Val="Num Required" type="text" name="roleSubjectList[0].total_emp" id="role_totalEmp_0" value="${vo.roleSubjectList[0].total_emp}" class="form-control" placeholder="请输入企业总在职人数数值" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <%--<div class="clearfix"></div>--%>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人姓名</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_name" id="role_linkName_0" value="${vo.roleSubjectList[0].link_name}" class="form-control" placeholder="请填写联系人名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人手机</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_tel" id="role_linkTel_0" value="${vo.roleSubjectList[0].link_tel}" class="form-control" placeholder="请填写联系人手机号" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人email</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_email" id="role_linkEmail_0" value="${vo.roleSubjectList[0].link_email}" class="form-control" placeholder="请填写联系人邮箱" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-9 col-xs-9">
                    <p>*注册地址</p>
                    <div class="row">
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="省" name="roleSubjectList[0].reg_province" id="regProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regCity', '', '2', this);">
                                <option value="">请选择省</option>
                                <c:if test="${fn:contains(pd.product_code,'GZZRX-TB')}">
                                    <option value="110000" <c:if test="${'110000' eq vo.roleSubjectList[0].reg_province }"> selected="selected"</c:if>>北京市</option>
                                </c:if>
                                <c:if test="${!fn:contains(pd.product_code,'GZZRX-TB')}">
                                    <c:forEach items="${provinceList }" var="list">
                                        <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_province }"> selected="selected"</c:if>>${list.named }</option>
                                    </c:forEach>
                                </c:if>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="市" name="roleSubjectList[0].reg_city" id="regCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regDistrict', '', '3', this);">
                                <option value="">请选择市</option>
                                <c:forEach items="${cityList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_city}"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="县" name="roleSubjectList[0].reg_district" id="regDistrict" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">请选择县</option>
                                <c:forEach items="${areaList }" var="list">
                                    <option value="${list.codes }" <c:if test="${vo.roleSubjectList[0].reg_district eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <input Data-Val="Required" type="text" name="roleSubjectList[0].reg_address" id="role_regAddress_0" value="${vo.roleSubjectList[0].reg_address}" class="form-control" placeholder="请填写详细地址" />
                            <span class="glyphicon form-control-feedback t-icon-l" style="top:0;" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <p style="margin: 10px 0 0;color: red;font-size: 14px;padding-left: 15px;">若三证合一，可上传统一社会信用代码</p>
                <div class="col-sm-4 col-xs-4">
                    <p>*营业执照<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/open.jpg')">（样例）</a></p>
                    <input Data-Val="FILE Required" type="hidden" name="roleSubjectList[0].app_organizing_path" id="appOrganizingPath" value="${vo.roleSubjectList[0].app_organizing_path}">
                    <div>
                        <input name="appOrganizingPath_file" id="appOrganizingPath_file-5" data-drawview="${vo.roleSubjectList[0].app_organizing_path}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon=""/>
                    </div>
                    <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <input type="hidden" name="roleSubjectList[1].oid" id="role_appRoleID_1" value="${vo.roleSubjectList[1].oid}"/>
            <input type="hidden" name="roleSubjectList[1].kind" id="role_kind_1" value="2"/>
            <input type="hidden" name="roleSubjectList[1].roleType" id="role_roleType_1" value="1"/>
            <div class="title-war"><h3>被保险人信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-3 col-xs-3">
                    <p>*被保险人名称<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="请填写与营业执照相一致的单位名称（总公司或子公司），个人不能作为投保单位"></i></p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].name_cn" id="role_namecn_1" value="${vo.roleSubjectList[1].name_cn}" class="form-control" data-toggle="tooltip" data-placement="top" title="请填写与营业执照相一致的单位名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*所属行业</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[1].industry" id="role_industry_1" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="保安服务业" <c:if test="${empty vo.roleSubjectList[1].industry || vo.roleSubjectList[1].industry eq '保安服务业' }"> selected="selected"</c:if>>保安服务业</option>
                        <c:if test="${fn:contains(pd.product_code,'GZZRX-PAC')||fn:contains(pd.product_code,'GZZRX-CA')}"><option value="家政服务业" <c:if test="${vo.roleSubjectList[1].industry eq '家政服务业' }"> selected="selected"</c:if>>家政服务业</option></c:if>
                    </select>
                </div>
                <div class="col-sm-6 col-xs-6">
                    <p>*营业性质</p>
                    <div class="row">
                        <div class="col-sm-6 col-xs-6">
                            <select data-val="Required" name="roleSubjectList[1].com_nature" id="role_comNature_1" class="form-control" onchange="natureChange(this,'role_natureTwo_1');" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">-请选择-</option>
                                <c:forEach items="${natureList }" var="list">
                                    <option value="${list.value }" <c:if test="${vo.roleSubjectList[1].com_nature eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6" <c:if test="${empty vo.roleSubjectList[1].nature_two }"> hidden</c:if>>
                            <select name="roleSubjectList[1].nature_two" id="role_natureTwo_1" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">-请选择-</option>
                                <c:forEach items="${natureTwoList1 }" var="list">
                                    <option value="${list.value }" <c:if test="${vo.roleSubjectList[1].nature_two eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                </c:forEach>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件类型</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[1].id_type" id="role_idType_1" value="${vo.roleSubjectList[1].id_type}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">-请选择-</option>
                        <c:if test="${fn:contains(pd.product_code,'GZZRX-CA')}">
                            <option value="2" <c:if test="${vo.roleSubjectList[1].id_type eq '2' }"> selected="selected"</c:if>>三证合一统一信用代码</option>
                        </c:if>
                        <c:if test="${!fn:contains(pd.product_code,'GZZRX-CA')}">
                            <c:forEach items="${comTypeList }" var="list">
                                <option value="${list.value }" <c:if test="${vo.roleSubjectList[1].id_type eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                            </c:forEach>
                        </c:if>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件号码</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].organization_code" id="role_organizationCode_1" GIST-ID="role_idType_1" value="${vo.roleSubjectList[1].organization_code}" class="form-control" data-toggle="tooltip" data-placement="top" title="组织机构代码：只能包含数字或英文大写字母，必须用连字符“-”隔开；营业执照：只能为15位数字；税务登记证：只能为15位数字，或20位数字，或19位数字与字母X组合；三证合一统一信用代码：由数字或大写英文字母组成，共18位"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件有效期起始</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[1].id_option" id="role_idOption_1" value="${vo.roleSubjectList[1].id_option}" onchange="isNeedDate(this,'role_idStarDate_1','role_idEndDate_1')" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">-请选择-</option>
                        <c:forEach items="${idOptionList }" var="list">
                            <option value="${list.value }" <c:if test="${vo.roleSubjectList[1].id_option eq list.value }"> selected="selected"</c:if>>${list.label }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3" hidden>
                    <p>*证件有效期始期</p>
                    <input Data-Val="Required" <c:if test="${empty vo.roleSubjectList[1].id_star_date}"> data-status="hidden"</c:if> type="text" name="roleSubjectList[1].id_star_date" id="role_idStarDate_1" value="${vo.roleSubjectList[1].id_star_date}" class="laydate-icon form-control" onclick="laydate({elem: '#role_idStarDate_1',format: 'YYYY-MM-DD'});"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3" hidden>
                    <p>*证件有效期止期</p>
                    <input Data-Val="Required" <c:if test="${empty vo.roleSubjectList[1].id_end_date}"> data-status="hidden"</c:if> type="text" name="roleSubjectList[1].id_end_date" id="role_idEndDate_1" value="${vo.roleSubjectList[1].id_end_date}" class="laydate-icon form-control" onclick="laydate({elem: '#role_idEndDate_1',format: 'YYYY-MM-DD'});"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*雇员人数（人）</p>
                    <input Data-Val="Num Required" type="text" name="roleSubjectList[1].total_emp" id="role_totalEmp_1" value="${vo.roleSubjectList[1].total_emp}" class="form-control" placeholder="请输入企业总在职人数数值" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <%--<div class="clearfix"></div>--%>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人姓名</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].link_name" id="role_linkName_1" value="${vo.roleSubjectList[1].link_name}" class="form-control" placeholder="请填写联系人名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人手机</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].link_tel" id="role_linkTel_1" value="${vo.roleSubjectList[1].link_tel}" class="form-control" placeholder="请填写联系人手机号" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人email</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].link_email" id="role_linkEmail_1" value="${vo.roleSubjectList[1].link_email}" class="form-control" placeholder="请填写联系人邮箱" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-9 col-xs-9">
                    <p>*注册地址</p>
                    <div class="row">
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="省" name="roleSubjectList[1].reg_province" id="regProvince1" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regCity1', '', '2', this);">
                                <option value="">请选择省</option>
                                <c:if test="${fn:contains(pd.product_code,'GZZRX-TB')}">
                                    <option value="110000" <c:if test="${'110000' eq vo.roleSubjectList[1].reg_province }"> selected="selected"</c:if>>北京市</option>
                                </c:if>
                                <c:if test="${!fn:contains(pd.product_code,'GZZRX-TB')}">
                                    <c:forEach items="${provinceList }" var="list">
                                        <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[1].reg_province }"> selected="selected"</c:if>>${list.named }</option>
                                    </c:forEach>
                                </c:if>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="市" name="roleSubjectList[1].reg_city" id="regCity1" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regDistrict1', '', '3', this);">
                                <option value="">请选择市</option>
                                <c:forEach items="${reg_city_1_List }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[1].reg_city}"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="县" name="roleSubjectList[1].reg_district" id="regDistrict1" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">请选择县</option>
                                <c:forEach items="${reg_area_1_List }" var="list">
                                    <option value="${list.codes }" <c:if test="${vo.roleSubjectList[1].reg_district eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <input Data-Val="Required" type="text" name="roleSubjectList[1].reg_address" id="role_regAddress_1" value="${vo.roleSubjectList[1].reg_address}" class="form-control" placeholder="请填写详细地址" />
                            <span class="glyphicon form-control-feedback t-icon-l" style="top:0;" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <p style="margin: 10px 0 0;color: red;font-size: 14px;padding-left: 15px;">若三证合一，可上传统一社会信用代码</p>
                <div class="col-sm-4 col-xs-4">
                    <p>*营业执照<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/open.jpg')">（样例）</a></p>
                    <input Data-Val="FILE Required" type="hidden" name="roleSubjectList[1].app_organizing_path" id="appOrganizingPath1" value="${vo.roleSubjectList[1].app_organizing_path}">
                    <div>
                        <input name="appOrganizingPath1_file" id="appOrganizingPath1_file-5" data-drawview="${vo.roleSubjectList[1].app_organizing_path}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon=""/>
                    </div>
                    <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <div class="title-war">
                <h3>
                    雇员信息（您可以选择逐条添加雇员信息或点击此处下载<a href="<c:url value='/resources/files/雇主批量导入范本.xls' />">【雇员清单模板】</a>进行<a href="javascript:void(0);" id="wed_wed">【批量上传】</a>注意：投保总人数不得低于3人）
                    <input name="hire_emp" id="hire_emp" type="file" onchange="uploadInsure();" style="display: none;">
                </h3>
            </div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="affirm-warr">
                    <%--<div class="tableu mSign" id="add-increased-table">
                        <div class="table-header-group">
                            <ul class="table-row">
                                <li class="table-cell">序号</li>
                                <li class="table-cell-1">*姓名</li>
                                <li class="table-cell-1">*证件类型</li>
                                <li class="table-cell-3">*证件号码</li>
                                <li class="table-cell-2">*出生日期</li>
                                <li class="table-cell-1">*性别</li>
                                <li class="table-cell-2">*职业</li>
                                <li class="table-cell-2">*手机</li>
                                <li class="table-cell">操作</li>
                            </ul>
                        </div>
                        <div class="table-row-group">
                            <c:if test="${empty vo.hirelingVoList}">
                            <c:forEach begin="0" end="2" varStatus="index">
                                <c:set var="doIndex" value="${index.index}"/>
                                <ul class="table-row hire_num_${doIndex}">
                                    <input type="hidden" name="hirelingVoList[${doIndex}].oid" id="hire_oid_${doIndex}" value="">
                                    <li class="table-cell signIndex">${doIndex+1}</li>
                                    <li class="table-cell"><input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].name" id="hire_name_${doIndex}" class="form-control" placeholder="" /></li>
                                    <li class="table-cell"><select Data-Val="Required" class="form-control" name="hirelingVoList[${doIndex}].id_type" id="hire_id_type_${doIndex}" value="" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                        <option value="">请选择</option>
                                        <c:forEach items="${personTypeList }" var="list">
                                            <option value="${list.value }">${list.name }</option>
                                        </c:forEach>
                                    </select></li>
                                    <li class="table-cell"><input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].id_card" GIST-ID="hire_id_type_${doIndex}" id="hire_id_card_${doIndex}" class="form-control" placeholder="" /></li>
                                    <li class="table-cell"><input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].birth_date" id="hire_birth_date_${doIndex}" GIST-ID="hire_id_card_${doIndex}" class="laydate-icon form-control" onclick="laydate({elem: '#hire_birth_date_${doIndex}',format: 'YYYY-MM-DD'});" /></li>
                                    <li class="table-cell"><select Data-Val="Required" class="form-control" name="hirelingVoList[${doIndex}].sex" id="hire_sex_${doIndex}" GIST-ID="hire_id_card_${doIndex}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                        <option value="">请选择</option>
                                        <option value="1" >男</option>
                                        <option value="2" >女</option>
                                    </select></li>
                                    <li class="table-cell"><select Data-Val="Required" class="form-control" name="hirelingVoList[${doIndex}].career" id="hire_career_${doIndex}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                        <option value="1">内勤人员</option>
                                        <option value="2">保安人员</option>
                                        <c:if test="${fn:contains(pd.product_code,'GZZRX-CA')||fn:contains(pd.product_code,'TYX-CA')}">
                                            <option value="3">武装押运人员</option>
                                        </c:if>
                                        <c:if test="${fn:contains(pd.product_code,'GZZRX-PAC')||fn:contains(pd.product_code,'GZZRX-CA')||fn:contains(pd.product_code,'TYX-CA')}">
                                            <option value="4">保洁人员</option>
                                        </c:if>
                                    </select></li>
                                    <li class="table-cell"><input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].mobile" id="hire_mobile_${doIndex}" class="form-control" placeholder="" /></li>
                                    <li class="table-cell"><label><a href="javascript:;" onclick="deleteThisRow('hire_num_${doIndex}','2000','add-a-line')">删除</a></label></li>
                                </ul>
                            </c:forEach>
                            </c:if>
                            <c:if test="${ vo.hirelingVoList!=null}">
                                <input type="hidden" name="hire_num" id="hire_num" value="${vo.hirelingVoList.size()}">
                                <c:forEach items="${ vo.hirelingVoList }" var="hvo" varStatus="index">
                                    <c:set var="doIndex" value="${index.index}"/>
                                    <ul class="table-row hire_num_${doIndex}">
                                        <input type="hidden" name="hirelingVoList[${doIndex}].oid" id="hire_oid_${doIndex}" value="${ hvo.oid}">
                                        <li class="table-cell signIndex">${doIndex+1}</li>
                                        <li class="table-cell">
                                            <input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].name" id="hire_name_${doIndex}" value="${ hvo.name}" class="form-control" placeholder="" />
                                        </li>
                                        <li class="table-cell">
                                            <select Data-Val="Required" class="form-control" name="hirelingVoList[${doIndex}].id_type" id="hire_id_type_${doIndex}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                                <option value="">-请选择-</option>
                                                <c:forEach items="${personTypeList }" var="list">
                                                    <option value="${list.value }" <c:if test="${hvo.id_type eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                                </c:forEach>
                                            </select>
                                        </li>
                                        <li class="table-cell">
                                            <input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].id_card" GIST-ID="hire_id_type_${doIndex}" id="hire_id_card_${doIndex}" value="${ hvo.id_card}" class="form-control" placeholder="" />
                                        </li>
                                        <li class="table-cell">
                                            <input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].birth_date" GIST-ID="hire_id_card_${doIndex}" id="hire_birth_date_${doIndex}" value="${ hvo.birth_date}" class="laydate-icon form-control" onclick="laydate({elem: '#hire_birth_date_${doIndex}',format: 'YYYY-MM-DD'});" />
                                        </li>
                                        <li class="table-cell">
                                            <select Data-Val="Required" class="form-control" name="hirelingVoList[${doIndex}].sex" GIST-ID="hire_id_card_${doIndex}" id="hire_sex_${doIndex}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                                <option value="">-请选择-</option>
                                                <option value="1" <c:if test="${hvo.sex eq '1' }"> selected="selected"</c:if> >男</option>
                                                <option value="2" <c:if test="${hvo.sex eq '2' }"> selected="selected"</c:if> >女</option>
                                            </select>
                                        </li>
                                        <li class="table-cell">
                                            <select Data-Val="Required" class="form-control" name="hirelingVoList[${doIndex}].career" id="hire_career_${doIndex}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                                <option value="1" <c:if test="${hvo.career eq '1' }"> selected="selected"</c:if> >内勤人员</option>
                                                <option value="2" <c:if test="${hvo.career eq '2' }"> selected="selected"</c:if> >保安人员</option>
                                                <c:if test="${fn:contains(pd.product_code,'GZZRX-CA')||fn:contains(pd.product_code,'TYX-CA')}">
                                                    <option value="3" <c:if test="${hvo.career eq '3' }"> selected="selected"</c:if> >武装押运人员</option>
                                                </c:if>
                                                <c:if test="${fn:contains(pd.product_code,'GZZRX-PAC')||fn:contains(pd.product_code,'GZZRX-CA')||fn:contains(pd.product_code,'TYX-CA')}">
                                                    <option value="4" <c:if test="${hvo.career eq '4' }"> selected="selected"</c:if> >保洁人员</option>
                                                </c:if>
                                            </select>
                                        </li>
                                        <li class="table-cell">
                                            <input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].mobile" id="hire_mobile_${doIndex}" value="${ hvo.mobile}" class="form-control" placeholder="" />
                                        </li>
                                        <li class="table-cell">
                                            <label><a href="javascript:;" onclick="deleteThisRow('hire_num_${doIndex}','2000','add-a-line')">删除</a></label>
                                        </li>
                                    </ul>
                                </c:forEach>
                            </c:if>
                        </div>
                    </div>--%>
                    <table class="table mSign" id="add-increased-table">
                        <tbody>
                        <tr>
                            <td class="col-sm-1 col-xs-1">序号</td>
                            <td class="col-sm-1 col-xs-1">*姓名</td>
                            <td class="col-sm-1 col-xs-1">*证件类型</td>
                            <td class="col-sm-2 col-xs-2">*证件号码</td>
                            <td class="col-sm-2 col-xs-2">*出生日期</td>
                            <td class="col-sm-1 col-xs-1">*性别</td>
                            <td class="col-sm-2 col-xs-2">*职业</td>
                            <td class="col-sm-1 col-xs-1">*手机</td>
                            <td class="col-sm-1 col-xs-1">操作</td>
                        </tr>
                        <c:if test="${empty vo.hirelingVoList}">
                            <input type="hidden" name="hire_num" id="hire_num" value="3">
                            <c:forEach begin="0" end="2" varStatus="index">
                                <c:set var="doIndex" value="${index.index}"/>
                                <tr class="hire_num_${doIndex}">
                                    <input type="hidden" name="hirelingVoList[${doIndex}].oid" id="hire_oid_${doIndex}" value="">
                                    <td class="col-sm-1 col-xs-1 signIndex">${doIndex+1}</td>
                                    <td class="col-sm-1 col-xs-1">
                                        <input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].name" id="hire_name_${doIndex}" class="form-control" placeholder="" />
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <select Data-Val="Required" class="form-control" name="hirelingVoList[${doIndex}].id_type" id="hire_id_type_${doIndex}" value="" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                            <option value="">请选择</option>
                                            <c:forEach items="${personTypeList }" var="list">
                                                <option value="${list.value }">${list.name }</option>
                                            </c:forEach>
                                        </select>
                                    </td>
                                    <td class="col-sm-2 col-xs-2">
                                        <input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].id_card" GIST-ID="hire_id_type_${doIndex}" id="hire_id_card_${doIndex}" class="form-control" placeholder="" />
                                    </td>
                                    <td class="col-sm-2 col-xs-2">
                                        <input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].birth_date" id="hire_birth_date_${doIndex}" GIST-ID="hire_id_card_${doIndex}" class="laydate-icon form-control" onclick="laydate({elem: '#hire_birth_date_${doIndex}',format: 'YYYY-MM-DD'});" />
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <select Data-Val="Required" class="form-control" name="hirelingVoList[${doIndex}].sex" id="hire_sex_${doIndex}" GIST-ID="hire_id_card_${doIndex}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                            <option value="">请选择</option>
                                            <option value="1" >男</option>
                                            <option value="2" >女</option>
                                        </select>
                                    </td>
                                    <td class="col-sm-2 col-xs-2">
                                        <select Data-Val="Required" class="form-control" name="hirelingVoList[${doIndex}].career" id="hire_career_${doIndex}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                            <option value="1">内勤人员</option>
                                            <option value="2">保安人员</option>
                                            <c:if test="${fn:contains(pd.product_code,'GZZRX-CA')||fn:contains(pd.product_code,'TYX-CA')}">
                                                <option value="3">武装押运人员</option>
                                            </c:if>
                                            <c:if test="${fn:contains(pd.product_code,'GZZRX-TB')||fn:contains(pd.product_code,'GZZRX-PAC')||fn:contains(pd.product_code,'GZZRX-CA')||fn:contains(pd.product_code,'TYX-CA')||fn:contains(pd.product_code,'GZZRX-QH')}">
                                                <option value="4">保洁人员</option>
                                            </c:if>
                                        </select>
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].mobile" id="hire_mobile_${doIndex}" class="form-control" placeholder="" />
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <label><a href="javascript:;" onclick="deleteThisRow('hire_num_${doIndex}','2000','add-a-line')">删除</a></label>
                                    </td>
                                </tr>
                            </c:forEach>
                        </c:if>
                        <c:if test="${ vo.hirelingVoList!=null}">
                            <input type="hidden" name="hire_num" id="hire_num" value="${vo.hirelingVoList.size()}">
                            <c:forEach items="${ vo.hirelingVoList }" var="hvo" varStatus="index">
                                <c:set var="doIndex" value="${index.index}"/>
                                <tr class="hire_num_${doIndex}">
                                    <input type="hidden" name="hirelingVoList[${doIndex}].oid" id="hire_oid_${doIndex}" value="${ hvo.oid}">
                                    <td class="col-sm-1 col-xs-1 signIndex">${doIndex+1}</td>
                                    <td class="col-sm-1 col-xs-1">
                                        <input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].name" id="hire_name_${doIndex}" value="${ hvo.name}" class="form-control" placeholder="" />
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <select Data-Val="Required" class="form-control" name="hirelingVoList[${doIndex}].id_type" id="hire_id_type_${doIndex}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                            <option value="">-请选择-</option>
                                            <c:forEach items="${personTypeList }" var="list">
                                                <option value="${list.value }" <c:if test="${hvo.id_type eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                            </c:forEach>
                                        </select>
                                    </td>
                                    <td class="col-sm-2 col-xs-2">
                                        <input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].id_card" GIST-ID="hire_id_type_${doIndex}" id="hire_id_card_${doIndex}" value="${ hvo.id_card}" class="form-control" placeholder="" />
                                    </td>
                                    <td class="col-sm-2 col-xs-2">
                                        <input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].birth_date" GIST-ID="hire_id_card_${doIndex}" id="hire_birth_date_${doIndex}" value="${ hvo.birth_date}" class="laydate-icon form-control" onclick="laydate({elem: '#hire_birth_date_${doIndex}',format: 'YYYY-MM-DD'});" />
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <select Data-Val="Required" class="form-control" name="hirelingVoList[${doIndex}].sex" GIST-ID="hire_id_card_${doIndex}" id="hire_sex_${doIndex}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                            <option value="">-请选择-</option>
                                            <option value="1" <c:if test="${hvo.sex eq '1' }"> selected="selected"</c:if> >男</option>
                                            <option value="2" <c:if test="${hvo.sex eq '2' }"> selected="selected"</c:if> >女</option>
                                        </select>
                                    </td>
                                    <td class="col-sm-2 col-xs-2">
                                        <select Data-Val="Required" class="form-control" name="hirelingVoList[${doIndex}].career" id="hire_career_${doIndex}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                            <option value="1" <c:if test="${hvo.career eq '1' }"> selected="selected"</c:if> >内勤人员</option>
                                            <option value="2" <c:if test="${hvo.career eq '2' }"> selected="selected"</c:if> >保安人员</option>
                                            <c:if test="${fn:contains(pd.product_code,'GZZRX-CA')||fn:contains(pd.product_code,'TYX-CA')}">
                                                <option value="3" <c:if test="${hvo.career eq '3' }"> selected="selected"</c:if> >武装押运人员</option>
                                            </c:if>
                                            <c:if test="${fn:contains(pd.product_code,'GZZRX-TB')||fn:contains(pd.product_code,'GZZRX-PAC')||fn:contains(pd.product_code,'GZZRX-CA')||fn:contains(pd.product_code,'TYX-CA')||fn:contains(pd.product_code,'GZZRX-QH')}">
                                                <option value="4" <c:if test="${hvo.career eq '4' }"> selected="selected"</c:if> >保洁人员</option>
                                            </c:if>
                                        </select>
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <input Data-Val="Required" type="text" name="hirelingVoList[${doIndex}].mobile" id="hire_mobile_${doIndex}" value="${ hvo.mobile}" class="form-control" placeholder="" />
                                    </td>
                                    <td class="col-sm-1 col-xs-1">
                                        <label><a href="javascript:;" onclick="deleteThisRow('hire_num_${doIndex}','2000','add-a-line')">删除</a></label>
                                    </td>
                                </tr>
                            </c:forEach>
                        </c:if>
                        </tbody>
                    </table>
                </div>
                <c:if test="${empty vo.hirelingVoList}">
                    <div class="col-sm-12 col-xs-12 text-center add-a-line" onclick="doDIVMOD(this, 'hire','add','2000');"><span><i class="glyphicon glyphicon-plus"></i> 添加</span></div>
                </c:if>
                <c:if test="${not empty vo.hirelingVoList}">
                    <div class="col-sm-12 col-xs-12 text-center add-a-line" <c:if test="${(vo.hirelingVoList.size()) == 2000}"> hidden</c:if> onclick="doDIVMOD(this, 'hire','add','2000');"><span><i class="glyphicon glyphicon-plus"></i> 添加</span></div>
                </c:if>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>投保计划信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-12 col-xs-12 reminder">
                    <label>温馨提示：起保日0点生效，如夜间投保，无人工协助承保，建议起保日期至少延后一日。</label>
                </div>
                <c:if test="${fn:contains(pd.product_code,'GZZRX-QH')}">
                <div class="col-sm-3 col-xs-3">
                    <p>保障类型</p>
                    <select Data-Val="Required" class="form-control" name="inception_type" id="inception_type" onchange="computationalCosts()" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="1" <c:if test="${vo.inception_type eq '1' }"> selected="selected"</c:if> >年度</option>
                        <option value="2" <c:if test="${vo.inception_type eq '2' }"> selected="selected"</c:if> >月度</option>
                    </select>
                    <input type="hidden" name="inception_long" id="inception_long" value="1">
                </div>
                <%--<div class="col-sm-3 col-xs-3" id="inception_long_dev"<c:if test="${empty vo.inception_type || vo.inception_type eq '1' }"> hidden</c:if>>
                    <p>保障月度</p>
                    <select class="form-control" name="inception_long" id="inception_long" onchange="computationalCosts()" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="1" <c:if test="${vo.inception_long eq '1' }"> selected="selected"</c:if> >1个月</option>
                        <option value="2" <c:if test="${vo.inception_long eq '2' }"> selected="selected"</c:if> >2个月</option>
                        <option value="3" <c:if test="${vo.inception_long eq '3' }"> selected="selected"</c:if> >3个月</option>
                        <option value="4" <c:if test="${vo.inception_long eq '4' }"> selected="selected"</c:if> >4个月</option>
                        <option value="5" <c:if test="${vo.inception_long eq '5' }"> selected="selected"</c:if> >5个月</option>
                        <option value="6" <c:if test="${vo.inception_long eq '6' }"> selected="selected"</c:if> >6个月</option>
                        <option value="7" <c:if test="${vo.inception_long eq '7' }"> selected="selected"</c:if> >7个月</option>
                        <option value="8" <c:if test="${vo.inception_long eq '8' }"> selected="selected"</c:if> >8个月</option>
                        <option value="9" <c:if test="${vo.inception_long eq '9' }"> selected="selected"</c:if> >9个月</option>
                        <option value="10" <c:if test="${vo.inception_long eq '10' }"> selected="selected"</c:if> >10个月</option>
                        <option value="11" <c:if test="${vo.inception_long eq '11' }"> selected="selected"</c:if> >11个月</option>
                    </select>
                </div>--%>
                </c:if>
                <div class="col-sm-5 col-xs-5">
                    <p>*起保日期选择</p>
                    <input Data-Val="Date Required" type="text" name="inception_date" id="inceptionDate" autocomplete="off" value="${ vo.inception_date}" class="laydate-icon form-control" onclick="laydate({elem: '#inceptionDate',min: laydate.now(+1),max: laydate.now(+90), format: 'YYYY-MM-DD'});computationalCosts();" data-toggle="tooltip" data-placement="top" title="建议您起保日期尽量往后选，若您选择的起保日期是明天，请确保在今天17：00 前（工作日）完成支付，否则保单可能无法及时生效。">
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    <%--<span class="f-c-12">注意：若需线下转账进行支付，请在起保日期之前完成转账，以免影响保单效力</span>--%>
                </div>
                <div class="clearfix"></div>
                <div class="col-sm-12 col-xs-12">
                    <p>保障方案确认</p>
                    <div class="affirm-warr">
                        <c:if test="${fn:contains(pd.product_code,'GZZRX-RB')}">
                            <table class="table ">
                                <tbody>
                                <tr>
                                    <td class="col-sm-3 col-xs-3"></td>
                                    <td class="col-sm-3 col-xs-3">保费</td>
                                    <td class="col-sm-3 col-xs-3">保障责任</td>
                                    <td class="col-sm-3 col-xs-3">保障金额</td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" rowspan="4">已含保障</td>
                                    <td class="col-sm-3 col-xs-3" rowspan="4">保安人员综合责任保险<br/><strong style="color:#ff8b00;">${pd.premium_min} 元/人</strong></td>
                                    <td class="col-sm-3 col-xs-3">每次事故责任</td>
                                    <td class="col-sm-3 col-xs-3">${pd.product_code eq 'GZZRX-RB-1' ? 300 : pd.product_code eq 'GZZRX-RB-2' ? 400 : pd.product_code eq 'GZZRX-RB-3' ? 500 : pd.product_code eq 'GZZRX-RB-4' ? 600 : 0 } 万元</td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人死亡、伤残责任</td>
                                    <td class="col-sm-3 col-xs-3">${pd.product_code eq 'GZZRX-RB-1' ? 30 : pd.product_code eq 'GZZRX-RB-2' ? 40 : pd.product_code eq 'GZZRX-RB-3' ? 50 : pd.product_code eq 'GZZRX-RB-4' ? 60 : 0 } 万元（牺牲被评为烈士${pd.product_code eq 'GZZRX-RB-1' ? 60 : pd.product_code eq 'GZZRX-RB-2' ? 80 : pd.product_code eq 'GZZRX-RB-3' ? 100 : pd.product_code eq 'GZZRX-RB-4' ? 120 : 0 }万元）</td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人医疗费用责任</td>
                                    <td class="col-sm-3 col-xs-3">${pd.product_code eq 'GZZRX-RB-1' ? 3 : pd.product_code eq 'GZZRX-RB-2' ? 4 : pd.product_code eq 'GZZRX-RB-3' ? 5 : pd.product_code eq 'GZZRX-RB-4' ? 6 : 0 } 万元</td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">累计法律费用责任</td>
                                    <td class="col-sm-3 col-xs-3">${pd.product_code eq 'GZZRX-RB-1' ? 30 : pd.product_code eq 'GZZRX-RB-2' ? 40 : pd.product_code eq 'GZZRX-RB-3' ? 50 : pd.product_code eq 'GZZRX-RB-4' ? 60 : 0 } 万元</td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" rowspan="2">可选保障</td>
                                    <td class="col-sm-3 col-xs-3" rowspan="2">附加三者责任险<br/><strong style="color:#ff8b00;">${pd.product_code eq 'GZZRX-RB-1' ? 25 : pd.product_code eq 'GZZRX-RB-2' ? 35 : pd.product_code eq 'GZZRX-RB-3' ? 45 : pd.product_code eq 'GZZRX-RB-4' ? 55 : 0 } 元/人</strong></td>
                                    <td class="col-sm-3 col-xs-3">每次事故责任</td>
                                    <td class="col-sm-3 col-xs-3">${pd.product_code eq 'GZZRX-RB-1' ? 10 : pd.product_code eq 'GZZRX-RB-2' ? 14 : pd.product_code eq 'GZZRX-RB-3' ? 20 : pd.product_code eq 'GZZRX-RB-4' ? 25 : 0 } 万元</td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">累计责任</td>
                                    <td class="col-sm-3 col-xs-3">${pd.product_code eq 'GZZRX-RB-1' ? 100 : pd.product_code eq 'GZZRX-RB-2' ? 150 : pd.product_code eq 'GZZRX-RB-3' ? 200 : pd.product_code eq 'GZZRX-RB-4' ? 250 : 0 } 万元</td>
                                </tr>
                                </tbody>
                            </table>
                        </c:if>

                        <c:if test="${fn:contains(pd.product_code,'GZZRX-ZH')}">
                            <table class="table ">
                                <tbody>
                                <tr>
                                    <td class="col-sm-3 col-xs-3"></td>
                                    <td class="col-sm-3 col-xs-3">保费</td>
                                    <td class="col-sm-3 col-xs-3">保障责任</td>
                                    <td class="col-sm-3 col-xs-3">保障金额</td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" rowspan="10">基本保障</td>
                                    <td class="col-sm-3 col-xs-3" rowspan="10">保安人员综合责任保险<br/><strong style="color:#ff8b00;">${pd.premium_min} 元/人</strong></td>
                                    <td class="col-sm-3 col-xs-3">每次事故责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-ZH-1' ? 300 : pd.product_code eq 'GZZRX-ZH-2' ? 400 : pd.product_code eq 'GZZRX-ZH-3' ? 500 : pd.product_code eq 'GZZRX-ZH-4' ? 600 : pd.product_code eq 'GZZRX-ZH-5' ? 700 : pd.product_code eq 'GZZRX-ZH-6' ? 800 : pd.product_code eq 'GZZRX-ZH-7' ? 900 : pd.product_code eq 'GZZRX-ZH-8' ? 1000 : pd.product_code eq 'GZZRX-ZH-9' ? 1200 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人意外身故/伤残责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-ZH-1' ? 30 : pd.product_code eq 'GZZRX-ZH-2' ? 40 : pd.product_code eq 'GZZRX-ZH-3' ? 50 : pd.product_code eq 'GZZRX-ZH-4' ? 60 : pd.product_code eq 'GZZRX-ZH-5' ? 70 : pd.product_code eq 'GZZRX-ZH-6' ? 80 : pd.product_code eq 'GZZRX-ZH-7' ? 90 : pd.product_code eq 'GZZRX-ZH-8' ? 100 : pd.product_code eq 'GZZRX-ZH-9' ? 120 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">烈士褒扬责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-ZH-1' ? 60 : pd.product_code eq 'GZZRX-ZH-2' ? 80 : pd.product_code eq 'GZZRX-ZH-3' ? 100 : pd.product_code eq 'GZZRX-ZH-4' ? 120 : pd.product_code eq 'GZZRX-ZH-5' ? 140 : pd.product_code eq 'GZZRX-ZH-6' ? 160 : pd.product_code eq 'GZZRX-ZH-7' ? 180 : pd.product_code eq 'GZZRX-ZH-8' ? 200 : pd.product_code eq 'GZZRX-ZH-9' ? 240 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人生活意外身故/伤残责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-ZH-1' ? 10 : pd.product_code eq 'GZZRX-ZH-2' ? 12 : pd.product_code eq 'GZZRX-ZH-3' ? 15 : pd.product_code eq 'GZZRX-ZH-4' ? 18 : pd.product_code eq 'GZZRX-ZH-5' ? 21 : pd.product_code eq 'GZZRX-ZH-6' ? 24 : pd.product_code eq 'GZZRX-ZH-7' ? 27 : pd.product_code eq 'GZZRX-ZH-8' ? 30 : pd.product_code eq 'GZZRX-ZH-9' ? 36 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">突发急性病身故责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-ZH-1' ? 30 : pd.product_code eq 'GZZRX-ZH-2' ? 40 : pd.product_code eq 'GZZRX-ZH-3' ? 50 : pd.product_code eq 'GZZRX-ZH-4' ? 60 : pd.product_code eq 'GZZRX-ZH-5' ? 70 : pd.product_code eq 'GZZRX-ZH-6' ? 80 : pd.product_code eq 'GZZRX-ZH-7' ? 90 : pd.product_code eq 'GZZRX-ZH-8' ? 100 : pd.product_code eq 'GZZRX-ZH-9' ? 120 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">突发急性病身故责任限额（非工）</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-ZH-1' ? 10 : pd.product_code eq 'GZZRX-ZH-2' ? 12 : pd.product_code eq 'GZZRX-ZH-3' ? 15 : pd.product_code eq 'GZZRX-ZH-4' ? 18 : pd.product_code eq 'GZZRX-ZH-5' ? 21 : pd.product_code eq 'GZZRX-ZH-6' ? 24 : pd.product_code eq 'GZZRX-ZH-7' ? 27 : pd.product_code eq 'GZZRX-ZH-8' ? 30 : pd.product_code eq 'GZZRX-ZH-9' ? 36 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人意外医疗费用责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-ZH-1' ? 3 : pd.product_code eq 'GZZRX-ZH-2' ? 4 : pd.product_code eq 'GZZRX-ZH-3' ? 5 : pd.product_code eq 'GZZRX-ZH-4' ? 6 : pd.product_code eq 'GZZRX-ZH-5' ? 7 : pd.product_code eq 'GZZRX-ZH-6' ? 8 : pd.product_code eq 'GZZRX-ZH-7' ? 9 : pd.product_code eq 'GZZRX-ZH-8' ? 10 : pd.product_code eq 'GZZRX-ZH-9' ? 12 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人生活意外医疗费用责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-ZH-1' ? 1 : pd.product_code eq 'GZZRX-ZH-2' ? 1.2 : pd.product_code eq 'GZZRX-ZH-3' ? 1.5 : pd.product_code eq 'GZZRX-ZH-4' ? 1.8 : pd.product_code eq 'GZZRX-ZH-5' ? 2.1 : pd.product_code eq 'GZZRX-ZH-6' ? 2.4 : pd.product_code eq 'GZZRX-ZH-7' ? 2.7 : pd.product_code eq 'GZZRX-ZH-8' ? 3 : pd.product_code eq 'GZZRX-ZH-9' ? 3.6 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">误工费</td>
                                    <td class="col-sm-3 col-xs-3">
                                            100 元/天
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">累计法律费用责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-ZH-1' ? 30 : pd.product_code eq 'GZZRX-ZH-2' ? 40 : pd.product_code eq 'GZZRX-ZH-3' ? 50 : pd.product_code eq 'GZZRX-ZH-4' ? 60 : pd.product_code eq 'GZZRX-ZH-5' ? 70 : pd.product_code eq 'GZZRX-ZH-6' ? 80 : pd.product_code eq 'GZZRX-ZH-7' ? 90 : pd.product_code eq 'GZZRX-ZH-8' ? 100 : pd.product_code eq 'GZZRX-ZH-9' ? 120 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" rowspan="2">可选保障</td>
                                    <td class="col-sm-3 col-xs-3" rowspan="2">附加三者责任险<br/><strong style="color:#ff8b00;">
                                            ${pd.product_code eq 'GZZRX-ZH-1' ? 15 : pd.product_code eq 'GZZRX-ZH-2' ? 20 : pd.product_code eq 'GZZRX-ZH-3' ? 25 : pd.product_code eq 'GZZRX-ZH-4' ? 30 : pd.product_code eq 'GZZRX-ZH-5' ? 35 : pd.product_code eq 'GZZRX-ZH-6' ? 40 : pd.product_code eq 'GZZRX-ZH-7' ? 40 : pd.product_code eq 'GZZRX-ZH-8' ? 50 : pd.product_code eq 'GZZRX-ZH-9' ? 55 : 0 } 元/人</strong></td>
                                    <td class="col-sm-3 col-xs-3" rowspan="2">每次事故责任限额</td>
                                    <td class="col-sm-3 col-xs-3" rowspan="2">
                                            ${pd.product_code eq 'GZZRX-ZH-1' ? 30 : pd.product_code eq 'GZZRX-ZH-2' ? 40 : pd.product_code eq 'GZZRX-ZH-3' ? 50 : pd.product_code eq 'GZZRX-ZH-4' ? 60 : pd.product_code eq 'GZZRX-ZH-5' ? 70 : pd.product_code eq 'GZZRX-ZH-6' ? 80 : pd.product_code eq 'GZZRX-ZH-7' ? 90 : pd.product_code eq 'GZZRX-ZH-8' ? 100 : pd.product_code eq 'GZZRX-ZH-9' ? 120 : 0 } 万元
                                    </td>
                                </tr>
                                </tbody>
                            </table>
                        </c:if>
                        <c:if test="${fn:contains(pd.product_code,'GZZRX-CA') && !fn:contains(pd.product_code,'GZZRX-CA-DQ')}">
                            <table class="table ">
                                <tbody>
                                <tr>
                                    <td class="col-sm-3 col-xs-3"></td>
                                    <td class="col-sm-3 col-xs-3">保费</td>
                                    <td class="col-sm-3 col-xs-3">保障责任</td>
                                    <td class="col-sm-3 col-xs-3">保障金额</td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" rowspan="9">基本保障</td>
                                    <td class="col-sm-3 col-xs-3" rowspan="9">长安雇主责任险<br/><strong style="color:#ff8b00;">${pd.premium_min} 元/人</strong></td>
                                    <td class="col-sm-3 col-xs-3">每次事故责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-1' ? 300 : pd.product_code eq 'GZZRX-CA-2' ? 400 : pd.product_code eq 'GZZRX-CA-3' ? 500 : pd.product_code eq 'GZZRX-CA-4' ? 600 : pd.product_code eq 'GZZRX-CA-5' ? 700 : pd.product_code eq 'GZZRX-CA-6' ? 800 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">工作期间每人意外身故、伤残限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-1' ? 30 : pd.product_code eq 'GZZRX-CA-2' ? 40 : pd.product_code eq 'GZZRX-CA-3' ? 50 : pd.product_code eq 'GZZRX-CA-4' ? 60 : pd.product_code eq 'GZZRX-CA-5' ? 70 : pd.product_code eq 'GZZRX-CA-6' ? 80 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人生活意外身故、伤残限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-1' ? 10 : pd.product_code eq 'GZZRX-CA-2' ? 12 : pd.product_code eq 'GZZRX-CA-3' ? 15 : pd.product_code eq 'GZZRX-CA-4' ? 18 : pd.product_code eq 'GZZRX-CA-5' ? 21 : pd.product_code eq 'GZZRX-CA-6' ? 24 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">工作期间每人意外医疗费用责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-1' ? 3 : pd.product_code eq 'GZZRX-CA-2' ? 4 : pd.product_code eq 'GZZRX-CA-3' ? 5 : pd.product_code eq 'GZZRX-CA-4' ? 6 : pd.product_code eq 'GZZRX-CA-5' ? 7 : pd.product_code eq 'GZZRX-CA-6' ? 8 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人生活意外医疗费用责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-1' ? 1 : pd.product_code eq 'GZZRX-CA-2' ? 1.2 : pd.product_code eq 'GZZRX-CA-3' ? 1.5 : pd.product_code eq 'GZZRX-CA-4' ? 1.8 : pd.product_code eq 'GZZRX-CA-5' ? 2.1 : pd.product_code eq 'GZZRX-CA-6' ? 2.4 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">突发急性病身故限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            20 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">误工费用赔偿限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                        100 元/天
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">住院津贴标准</td>
                                    <td class="col-sm-3 col-xs-3">
                                        100 元/天
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">法律费用限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-1' ? 30 : pd.product_code eq 'GZZRX-CA-2' ? 40 : pd.product_code eq 'GZZRX-CA-3' ? 50 : pd.product_code eq 'GZZRX-CA-4' ? 60 : pd.product_code eq 'GZZRX-CA-5' ? 70 : pd.product_code eq 'GZZRX-CA-6' ? 80 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" rowspan="4">附加保障</td>
                                    <td class="col-sm-3 col-xs-3" rowspan="4">附加第三者责任险</td>
                                    <td class="col-sm-3 col-xs-3">每年事故累计限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-1' ? 50 : pd.product_code eq 'GZZRX-CA-2' ? 70 : pd.product_code eq 'GZZRX-CA-3' ? 80 : pd.product_code eq 'GZZRX-CA-4' ? 100 : pd.product_code eq 'GZZRX-CA-5' ? 200 : pd.product_code eq 'GZZRX-CA-6' ? 300 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每次财产损失赔偿限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-1' ? 25 : pd.product_code eq 'GZZRX-CA-2' ? 35 : pd.product_code eq 'GZZRX-CA-3' ? 40 : pd.product_code eq 'GZZRX-CA-4' ? 50 : pd.product_code eq 'GZZRX-CA-5' ? 100 : pd.product_code eq 'GZZRX-CA-6' ? 150 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每次人身伤亡、医疗、误工赔偿限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-1' ? 25 : pd.product_code eq 'GZZRX-CA-2' ? 35 : pd.product_code eq 'GZZRX-CA-3' ? 40 : pd.product_code eq 'GZZRX-CA-4' ? 50 : pd.product_code eq 'GZZRX-CA-5' ? 100 : pd.product_code eq 'GZZRX-CA-6' ? 150 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" colspan="2">（每人每次人身伤亡、医疗、误工限额不超过基本险每人限额）</td>
                                </tr>
                                </tbody>
                            </table>
                        </c:if>
                        <c:if test="${fn:contains(pd.product_code,'GZZRX-CA-DQ')}">
                            <table class="table ">
                                <tbody>
                                <tr>
                                    <td class="col-sm-3 col-xs-3"></td>
                                    <td class="col-sm-3 col-xs-3">保费</td>
                                    <td class="col-sm-3 col-xs-3">保障责任</td>
                                    <td class="col-sm-3 col-xs-3">保障金额</td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" rowspan="9">基本保障</td>
                                    <td class="col-sm-3 col-xs-3" rowspan="9">百川信短期雇主责任险<br/><strong style="color:#ff8b00;">${pd.premium_min} 元/人</strong></td>
                                    <td class="col-sm-3 col-xs-3">每次事故责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-DQ-1' ? 300 : pd.product_code eq 'GZZRX-CA-DQ-2' ? 400 : pd.product_code eq 'GZZRX-CA-DQ-3' ? 500 : pd.product_code eq 'GZZRX-CA-DQ-4' ? 600 : pd.product_code eq 'GZZRX-CA-DQ-5' ? 700 : pd.product_code eq 'GZZRX-CA-DQ-6' ? 800 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">工作期间每人意外身故、伤残限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-DQ-1' ? 30 : pd.product_code eq 'GZZRX-CA-DQ-2' ? 40 : pd.product_code eq 'GZZRX-CA-DQ-3' ? 50 : pd.product_code eq 'GZZRX-CA-DQ-4' ? 60 : pd.product_code eq 'GZZRX-CA-DQ-5' ? 70 : pd.product_code eq 'GZZRX-CA-DQ-6' ? 80 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人生活意外身故、伤残限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-DQ-1' ? 10 : pd.product_code eq 'GZZRX-CA-DQ-2' ? 12 : pd.product_code eq 'GZZRX-CA-DQ-3' ? 15 : pd.product_code eq 'GZZRX-CA-DQ-4' ? 18 : pd.product_code eq 'GZZRX-CA-DQ-5' ? 21 : pd.product_code eq 'GZZRX-CA-DQ-6' ? 24 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">工作期间每人意外医疗费用责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-DQ-1' ? 3 : pd.product_code eq 'GZZRX-CA-DQ-2' ? 4 : pd.product_code eq 'GZZRX-CA-DQ-3' ? 5 : pd.product_code eq 'GZZRX-CA-DQ-4' ? 6 : pd.product_code eq 'GZZRX-CA-DQ-5' ? 7 : pd.product_code eq 'GZZRX-CA-DQ-6' ? 8 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人生活意外医疗费用责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-DQ-1' ? 1 : pd.product_code eq 'GZZRX-CA-DQ-2' ? 1.2 : pd.product_code eq 'GZZRX-CA-DQ-3' ? 1.5 : pd.product_code eq 'GZZRX-CA-DQ-4' ? 1.8 : pd.product_code eq 'GZZRX-CA-DQ-5' ? 2.1 : pd.product_code eq 'GZZRX-CA-DQ-6' ? 2.4 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">突发急性病身故限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                        20 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">误工费用赔偿限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                        100 元/天
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">住院津贴标准</td>
                                    <td class="col-sm-3 col-xs-3">
                                        100 元/天
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">法律费用限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-DQ-1' ? 30 : pd.product_code eq 'GZZRX-CA-DQ-2' ? 40 : pd.product_code eq 'GZZRX-CA-DQ-3' ? 50 : pd.product_code eq 'GZZRX-CA-DQ-4' ? 60 : pd.product_code eq 'GZZRX-CA-DQ-5' ? 70 : pd.product_code eq 'GZZRX-CA-DQ-6' ? 80 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" rowspan="4">附加保障</td>
                                    <td class="col-sm-3 col-xs-3" rowspan="4">附加第三者责任险</td>
                                    <td class="col-sm-3 col-xs-3">每年事故累计限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-DQ-1' ? 50 : pd.product_code eq 'GZZRX-CA-DQ-2' ? 70 : pd.product_code eq 'GZZRX-CA-DQ-3' ? 80 : pd.product_code eq 'GZZRX-CA-DQ-4' ? 100 : pd.product_code eq 'GZZRX-CA-DQ-5' ? 200 : pd.product_code eq 'GZZRX-CA-DQ-6' ? 300 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每次财产损失赔偿限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-DQ-1' ? 25 : pd.product_code eq 'GZZRX-CA-DQ-2' ? 35 : pd.product_code eq 'GZZRX-CA-DQ-3' ? 40 : pd.product_code eq 'GZZRX-CA-DQ-4' ? 50 : pd.product_code eq 'GZZRX-CA-DQ-5' ? 100 : pd.product_code eq 'GZZRX-CA-DQ-6' ? 150 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每次人身伤亡、医疗、误工赔偿限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-CA-DQ-1' ? 25 : pd.product_code eq 'GZZRX-CA-DQ-2' ? 35 : pd.product_code eq 'GZZRX-CA-DQ-3' ? 40 : pd.product_code eq 'GZZRX-CA-DQ-4' ? 50 : pd.product_code eq 'GZZRX-CA-DQ-5' ? 100 : pd.product_code eq 'GZZRX-CA-DQ-6' ? 150 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" colspan="2">（每人每次人身伤亡、医疗、误工限额不超过基本险每人限额）</td>
                                </tr>
                                </tbody>
                            </table>
                        </c:if>
                        <c:if test="${fn:contains(pd.product_code,'GZZRX-PAC')}">
                            <table class="table ">
                                <tbody>
                                <tr>
                                    <td class="col-sm-3 col-xs-3"></td>
                                    <td class="col-sm-3 col-xs-3">保费</td>
                                    <td class="col-sm-3 col-xs-3">保障责任</td>
                                    <td class="col-sm-3 col-xs-3">保障金额</td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" rowspan="8">基本保障</td>
                                    <td class="col-sm-3 col-xs-3" rowspan="8">保安人员综合责任保险<br/><strong style="color:#ff8b00;">${pd.premium_min} 元/人</strong></td>
                                    <td class="col-sm-3 col-xs-3">每次事故责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-PAC-1' ? 300 : pd.product_code eq 'GZZRX-PAC-2' ? 400 : pd.product_code eq 'GZZRX-PAC-3' ? 500 : pd.product_code eq 'GZZRX-PAC-4' ? 600 : pd.product_code eq 'GZZRX-PAC-5' ? 700 : pd.product_code eq 'GZZRX-PAC-6' ? 800 : pd.product_code eq 'GZZRX-PAC-7' ? 900 : pd.product_code eq 'GZZRX-PAC-8' ? 1000 : pd.product_code eq 'GZZRX-PAC-9' ? 1200 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人意外身故、伤残限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-PAC-1' ? 30 : pd.product_code eq 'GZZRX-PAC-2' ? 40 : pd.product_code eq 'GZZRX-PAC-3' ? 50 : pd.product_code eq 'GZZRX-PAC-4' ? 60 : pd.product_code eq 'GZZRX-PAC-5' ? 70 : pd.product_code eq 'GZZRX-PAC-6' ? 80 : pd.product_code eq 'GZZRX-PAC-7' ? 90 : pd.product_code eq 'GZZRX-PAC-8' ? 100 : pd.product_code eq 'GZZRX-PAC-9' ? 120 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人生活意外身故、伤残限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-PAC-1' ? 5 : pd.product_code eq 'GZZRX-PAC-2' ? 5 : pd.product_code eq 'GZZRX-PAC-3' ? 5 : pd.product_code eq 'GZZRX-PAC-4' ? 8 : pd.product_code eq 'GZZRX-PAC-5' ? 8 : pd.product_code eq 'GZZRX-PAC-6' ? 8 : pd.product_code eq 'GZZRX-PAC-7' ? 10 : pd.product_code eq 'GZZRX-PAC-8' ? 10 : pd.product_code eq 'GZZRX-PAC-9' ? 10 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人意外医疗费用责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-PAC-1' ? 3 : pd.product_code eq 'GZZRX-PAC-2' ? 4 : pd.product_code eq 'GZZRX-PAC-3' ? 5 : pd.product_code eq 'GZZRX-PAC-4' ? 6 : pd.product_code eq 'GZZRX-PAC-5' ? 7 : pd.product_code eq 'GZZRX-PAC-6' ? 8 : pd.product_code eq 'GZZRX-PAC-7' ? 9 : pd.product_code eq 'GZZRX-PAC-8' ? 10 : pd.product_code eq 'GZZRX-PAC-9' ? 12 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人生活意外医疗费用责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                        1 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">突发急性病身故限额（工伤范围）</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-PAC-1' ? 30 : pd.product_code eq 'GZZRX-PAC-2' ? 40 : pd.product_code eq 'GZZRX-PAC-3' ? 50 : pd.product_code eq 'GZZRX-PAC-4' ? 60 : pd.product_code eq 'GZZRX-PAC-5' ? 70 : pd.product_code eq 'GZZRX-PAC-6' ? 80 : pd.product_code eq 'GZZRX-PAC-7' ? 90 : pd.product_code eq 'GZZRX-PAC-8' ? 100 : pd.product_code eq 'GZZRX-PAC-9' ? 120 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">住院津贴标准</td>
                                    <td class="col-sm-3 col-xs-3">
                                        100 元/天
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">法律费用限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-PAC-1' ? 30 : pd.product_code eq 'GZZRX-PAC-2' ? 40 : pd.product_code eq 'GZZRX-PAC-3' ? 50 : pd.product_code eq 'GZZRX-PAC-4' ? 60 : pd.product_code eq 'GZZRX-PAC-5' ? 70 : pd.product_code eq 'GZZRX-PAC-6' ? 80 : pd.product_code eq 'GZZRX-PAC-7' ? 90 : pd.product_code eq 'GZZRX-PAC-8' ? 100 : pd.product_code eq 'GZZRX-PAC-9' ? 120 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" rowspan="1">可选保障一</td>
                                    <td class="col-sm-3 col-xs-3" rowspan="1">附加非工伤突发急性病身故责任限额<br/><strong style="color:#ff8b00;">100 元/人</strong></td>
                                    <td class="col-sm-3 col-xs-3">非工伤突发急性病身故责任限额</td>
                                    <td class="col-sm-3 col-xs-3">10 万元</td>
                                </tr>

                                </tbody>
                            </table>
                        </c:if>
                        <c:if test="${fn:contains(pd.product_code,'GZZRX-TB')}">
                            <table class="table ">
                                <tbody>
                                <tr>
                                    <td class="col-sm-3 col-xs-3"></td>
                                    <td class="col-sm-3 col-xs-3">保费</td>
                                    <td class="col-sm-3 col-xs-3">保障责任</td>
                                    <td class="col-sm-3 col-xs-3">保障金额</td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" rowspan="8">基本保障</td>
                                    <td class="col-sm-3 col-xs-3" rowspan="8">保安责任保险<br/><strong style="color:#ff8b00;">${pd.premium_min} 元/人</strong></td>
                                    <td class="col-sm-3 col-xs-3">每次事故责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-TB-1' ? 400 : pd.product_code eq 'GZZRX-TB-2' ? 500 : pd.product_code eq 'GZZRX-TB-3' ? 600 : pd.product_code eq 'GZZRX-TB-4' ? 700 : pd.product_code eq 'GZZRX-TB-5' ? 800 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每次事故每人死亡伤残责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-TB-1' ? 40 : pd.product_code eq 'GZZRX-TB-2' ? 50 : pd.product_code eq 'GZZRX-TB-3' ? 60 : pd.product_code eq 'GZZRX-TB-4' ? 70 : pd.product_code eq 'GZZRX-TB-5' ? 80 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每次事故每人突发疾病身故责任限额（工作期间）</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-TB-1' ? 20 : pd.product_code eq 'GZZRX-TB-2' ? 25 : pd.product_code eq 'GZZRX-TB-3' ? 30 : pd.product_code eq 'GZZRX-TB-4' ? 35 : pd.product_code eq 'GZZRX-TB-5' ? 40 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每次事故每人医疗费用责任限额（含紧急抢救费用）</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-TB-1' ? 4 : pd.product_code eq 'GZZRX-TB-2' ? 5 : pd.product_code eq 'GZZRX-TB-3' ? 6 : pd.product_code eq 'GZZRX-TB-4' ? 7 : pd.product_code eq 'GZZRX-TB-5' ? 8 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每次事故及累计法律费用责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-TB-1' ? 40 : pd.product_code eq 'GZZRX-TB-2' ? 50 : pd.product_code eq 'GZZRX-TB-3' ? 60 : pd.product_code eq 'GZZRX-TB-4' ? 70 : pd.product_code eq 'GZZRX-TB-5' ? 80 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">附加24小时意外保险（适用：24小时个人意外事故条款、24小时个人意外事故医疗费用条款） 每次事故每人死亡伤残责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-TB-1' ? 12 : pd.product_code eq 'GZZRX-TB-2' ? 15 : pd.product_code eq 'GZZRX-TB-3' ? 18 : pd.product_code eq 'GZZRX-TB-4' ? 21 : pd.product_code eq 'GZZRX-TB-5' ? 24 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">附加24小时意外保险（适用：24小时个人意外事故条款、24小时个人意外事故医疗费用条款） 每次事故每人医疗费用责任限额（含紧急抢救费用）</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-TB-1' ? 1.2 : pd.product_code eq 'GZZRX-TB-2' ? 1.5 : pd.product_code eq 'GZZRX-TB-3' ? 1.8 : pd.product_code eq 'GZZRX-TB-4' ? 2.1 : pd.product_code eq 'GZZRX-TB-5' ? 2.4 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">意外住院补贴</td>
                                    <td class="col-sm-3 col-xs-3">
                                        100 元/天
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" rowspan="1">可选保障一</td>
                                    <td class="col-sm-3 col-xs-3" rowspan="1">附加非工作期间突发急性病 死亡保险（适用：24小时个人事故条款）<br/><strong style="color:#ff8b00;">25 元/人</strong></td>
                                    <td class="col-sm-3 col-xs-3">每次事故每人死亡责任限额</td>
                                    <td class="col-sm-3 col-xs-3">10 万元</td>
                                </tr>

                                </tbody>
                            </table>
                        </c:if>

                        <c:if test="${fn:contains(pd.product_code,'GZZRX-QH')}">
                            <table class="table ">
                                <tbody>
                                <tr>
                                    <td class="col-sm-3 col-xs-3"></td>
                                    <td class="col-sm-3 col-xs-3">保费</td>
                                    <td class="col-sm-3 col-xs-3">保障责任</td>
                                    <td class="col-sm-3 col-xs-3">保障金额</td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" rowspan="9">基本保障</td>
                                    <td class="col-sm-3 col-xs-3" rowspan="9">前海保安雇主责任险<br/><strong style="color:#ff8b00;" id="qhPremiumC">${pd.premium_min} 元/人</strong></td>
                                    <td class="col-sm-3 col-xs-3">每次事故责任限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-QH-1' ? 300 : pd.product_code eq 'GZZRX-QH-2' ? 400 : pd.product_code eq 'GZZRX-QH-3' ? 500 : pd.product_code eq 'GZZRX-QH-4' ? 600 : pd.product_code eq 'GZZRX-QH-5' ? 700 : pd.product_code eq 'GZZRX-QH-6' ? 800 : pd.product_code eq 'GZZRX-QH-7' ? 900 : pd.product_code eq 'GZZRX-QH-8' ? 1000 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">工作期间每人意外身故、伤残限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-QH-1' ? 30 : pd.product_code eq 'GZZRX-QH-2' ? 40 : pd.product_code eq 'GZZRX-QH-3' ? 50 : pd.product_code eq 'GZZRX-QH-4' ? 60 : pd.product_code eq 'GZZRX-QH-5' ? 70 : pd.product_code eq 'GZZRX-QH-6' ? 80 : pd.product_code eq 'GZZRX-QH-7' ? 90 : pd.product_code eq 'GZZRX-QH-8' ? 100 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人生活意外身故、伤残限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-QH-1' ? 10 : pd.product_code eq 'GZZRX-QH-2' ? 12 : pd.product_code eq 'GZZRX-QH-3' ? 15 : pd.product_code eq 'GZZRX-QH-4' ? 18 : pd.product_code eq 'GZZRX-QH-5' ? 21 : pd.product_code eq 'GZZRX-QH-6' ? 24 : pd.product_code eq 'GZZRX-QH-7' ? 27 : pd.product_code eq 'GZZRX-QH-8' ? 30 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">工作期间每人意外医疗费用限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-QH-1' ? 3 : pd.product_code eq 'GZZRX-QH-2' ? 4 : pd.product_code eq 'GZZRX-QH-3' ? 5 : pd.product_code eq 'GZZRX-QH-4' ? 6 : pd.product_code eq 'GZZRX-QH-5' ? 7 : pd.product_code eq 'GZZRX-QH-6' ? 8 : pd.product_code eq 'GZZRX-QH-7' ? 9 : pd.product_code eq 'GZZRX-QH-8' ? 10 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">每人生活意外医疗费用限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-QH-1' ? 1 : pd.product_code eq 'GZZRX-QH-2' ? 1.2 : pd.product_code eq 'GZZRX-QH-3' ? 1.5 : pd.product_code eq 'GZZRX-QH-4' ? 1.8 : pd.product_code eq 'GZZRX-QH-5' ? 2.1 : pd.product_code eq 'GZZRX-QH-6' ? 2.4 : pd.product_code eq 'GZZRX-QH-7' ? 2.7 : pd.product_code eq 'GZZRX-QH-8' ? 3 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">误工费用标准（每天）</td>
                                    <td class="col-sm-3 col-xs-3">
                                        100 元/天
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">住院津贴标准（每天）</td>
                                    <td class="col-sm-3 col-xs-3">
                                        100 元/天
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">突发急性病身故限额（工作期间）</td>
                                    <td class="col-sm-3 col-xs-3">
                                        30 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3">法律费用限额</td>
                                    <td class="col-sm-3 col-xs-3">
                                            ${pd.product_code eq 'GZZRX-QH-1' ? 30 : pd.product_code eq 'GZZRX-QH-2' ? 40 : pd.product_code eq 'GZZRX-QH-3' ? 50 : pd.product_code eq 'GZZRX-QH-4' ? 60 : pd.product_code eq 'GZZRX-QH-5' ? 70 : pd.product_code eq 'GZZRX-QH-6' ? 80 : pd.product_code eq 'GZZRX-QH-7' ? 90 : pd.product_code eq 'GZZRX-QH-8' ? 100 : 0 } 万元
                                    </td>
                                </tr>
                                <tr>
                                    <td class="col-sm-3 col-xs-3" rowspan="1">可选保障一</td>
                                    <td class="col-sm-3 col-xs-3" rowspan="1">附加每人非工作期间猝死赔偿限额<br/><strong style="color:#ff8b00;" id="qhPremiumF">${pd.product_code eq 'GZZRX-QH-1' ? 36 : pd.product_code eq 'GZZRX-QH-2' ? 36 : pd.product_code eq 'GZZRX-QH-3' ? 48 : pd.product_code eq 'GZZRX-QH-4' ? 48 : pd.product_code eq 'GZZRX-QH-5' ? 60 : pd.product_code eq 'GZZRX-QH-6' ? 72 : pd.product_code eq 'GZZRX-QH-7' ? 84 : pd.product_code eq 'GZZRX-QH-8' ? 96 : 0 } 元/人</strong></td>
                                    <td class="col-sm-3 col-xs-3">突发急性病身故限额（非工作期间）</td>
                                    <td class="col-sm-3 col-xs-3">20 万元</td>
                                </tr>

                                </tbody>
                            </table>
                        </c:if>
                    </div>
                    <c:if test="${!fn:contains(pd.product_code,'GZZRX-PAC') && !fn:contains(pd.product_code,'GZZRX-CA') && !fn:contains(pd.product_code,'GZZRX-QH')&&!fn:contains(pd.product_code,'GZZRX-TB')}">
                        <div class="optional_guarantee">
                            <span class="${empty vo.is_contain_repo ? 'active' : vo.is_contain_repo eq '1' ? 'active' : ''}" data-val="1">含可选保障</span>
                            <span class="${vo.is_contain_repo eq '0' ? 'active' : ''}" data-val="0">不含可选保障</span>
                        </div>
                        <input type="hidden" name="is_contain_repo" id="is_contain_repo" value="${empty vo.is_contain_repo ? '1' : vo.is_contain_repo}"><%--初始化默认包含附加条件--%>
                    </c:if>
                    <c:if test="${fn:contains(pd.product_code,'GZZRX-PAC')||fn:contains(pd.product_code,'GZZRX-QH')||fn:contains(pd.product_code,'GZZRX-TB')}">
                        <div class="optional_guarantee">
                            <span style="margin-right:0;" class="${vo.is_contain_repo eq '1' ? 'active' : ''}" data-val="1">含可选保障一</span>
                            <span class="${empty vo.is_contain_repo ? 'active' : vo.is_contain_repo eq '0' ? 'active' : ''}" data-val="0">不含可选保障</span>
                        </div>
                        <input type="hidden" name="is_contain_repo" id="is_contain_repo" value="${empty vo.is_contain_repo ? '0' : vo.is_contain_repo}"><%--初始化默认包含附加条件--%>
                    </c:if>
                    <c:if test="${fn:contains(pd.product_code,'GZZRX-CA')}">
                        <input type="hidden" name="is_contain_repo" id="is_contain_repo" value="${empty vo.is_contain_repo ? '0' : vo.is_contain_repo}"><%--初始化默认包含附加条件--%>
                    </c:if>
                </div>
                <div class="col-sm-12 col-xs-12">
                    <div class="row">
                        <div class="col-sm-6 col-sm-6 mt-20">
                            <div class="insure-check">
                                    <span class="check-box pull-left" id="check_span">
                                        <input type="checkbox" id="check_007" class="form-control" Data-Val="Required" />
                                        <label for="check_007" id="check_007_for"></label>
                                    </span>
                                <span class="pull-left" style="line-height: 13px;font-weight: bold;color: red">本企业理解并接受上述已选保障方案</span><br />
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-xs-12">
                    <p>争议处理</p>
                    <div><span>若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：</span></div>
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-sm-2 col-xs-2 rad-io mt-20">
                                    <span><input type="radio" value="0" name="dispute" id="dispute_radio1" checked="checked"><label for="dispute_radio1" class="pull-left"></label><strong  class="pull-left">诉讼</strong></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>保费</p>
                    <input type="hidden" name="premium" id="g_premium" value="${vo.premium}">
                    <input type="hidden" name="insured_amount" id="g_insured_amount" value="${vo.insured_amount}">
                    <c:set var="initPM" value="${pd.product_code eq 'GZZRX-RB-1' ? 25 : pd.product_code eq 'GZZRX-RB-2' ? 35 : pd.product_code eq 'GZZRX-RB-3' ? 45 : pd.product_code eq 'GZZRX-ZH-1' ? 15 : pd.product_code eq 'GZZRX-ZH-2' ? 20 : pd.product_code eq 'GZZRX-ZH-3' ? 25 : pd.product_code eq 'GZZRX-ZH-4' ? 30 : pd.product_code eq 'GZZRX-ZH-5' ? 35 : pd.product_code eq 'GZZRX-ZH-6' ? 40 : pd.product_code eq 'GZZRX-ZH-7' ? 40 : pd.product_code eq 'GZZRX-ZH-8' ? 50 : pd.product_code eq 'GZZRX-ZH-9' ? 55 : 0 }"/>
                    <strong class="d-l-36" id="mPremium">${not empty vo.premium ? vo.premium : (pd.premium_min+initPM)*3}元</strong>
                </div>

            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>退保账户信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-12 col-xs-12 reminder">
                    <label>温馨提示：团意险/雇主险每期结算保费时，若有需要退回保费的情况，将往以下账户进行转账。</label>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户行省</p>
                    <select Data-Val="Required" title="省" name="roleSubjectList[0].bank_province" id="tkbankProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('bank_city_0', '', '2', this);">
                        <option value="">请选择省</option>
                        <c:forEach items="${provinceList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_province }"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户行市</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_city" id="bank_city_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeBankType('bank_type_0', this);">
                        <option value="">请选择市</option>
                        <c:forEach items="${bankCityList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_city}"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户银行</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_type" id="bank_type_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeBankAddr('bank_addr_0', 'bank_city_0', this);">
                        <option value="">请选择名称</option>
                        <c:forEach items="${bankTypeList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_type}"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户行地址</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_addr" id="bank_addr_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeBankName('bank_name_0', this);">
                        <option value="">请选择地址</option>
                        <c:forEach items="${bankAddrList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_addr}"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                    <input Data-Val="Required" type="hidden" name="roleSubjectList[0].bank_name" id="bank_name_0" value="${vo.roleSubjectList[0].bank_name}" class="form-control" />
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*账户开户类型</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_pub_pri" id="bank_pub_pri_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">请选择类型</option>
                        <option value="1" <c:if test="${'1' eq vo.roleSubjectList[0].bank_pub_pri}"> selected="selected"</c:if>>对公</option>
                        <option value="2" <c:if test="${'2' eq vo.roleSubjectList[0].bank_pub_pri}"> selected="selected"</c:if>>对私</option>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户名</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].account_name" id="account_name_0" value="${vo.roleSubjectList[0].account_name}" class="form-control" placeholder="请填写开户名" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <%--<div class="col-sm-3 col-xs-3">
                    <p>*账户开户行</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].bank_name" id="bank_name_0" value="${vo.roleSubjectList[0].bank_name}" class="form-control" placeholder="请填写账户开户行" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>--%>
                <div class="col-sm-3 col-xs-3">
                    <p>*银行账号</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].bank_account" id="bank_account_0" value="${vo.roleSubjectList[0].bank_account}" class="form-control" placeholder="请填写银行账号" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
        <div class="title-war"><h3>单证信息</h3></div>
        <div class="row w-95-auto"><!-- w-95-auto start -->
            <div class="col-sm-12 col-xs-12 reminder" style="line-height: 25px;">
                <label>
                    温馨提示：<br/>
                    1.本产品采取电子保单/电子发票形式，投保成功后，电子保单及电子发票会实时发送到您填写的投保人邮箱中；<br/>
                    2.根据《中华人民共和国合同法》第十一条规定，数据电文是合法的合同表现形式，<span style="color:red;">电子保单与纸质保单具有同等法律效力</span>；您可以登录保险公司官网自助查询对电子保单的真实性进行验证；<br/>
                    <span style="color:red;">3.电子发票是以电子方式存储的收付款凭证，其法律效力、基本用途、基本使用规定等与税务机关监制的纸质发票相同。</span>
                </label>
            </div>
            <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;">
                    <span class="pull-left check-box">
                        <input type="checkbox" checked="checked" id="need_insur_dz" disabled/>
                        <label for="need_insur_dz"></label>
                    </span>
                <span class="pull-left lhml5">开具电子保单<span class="label label-primary" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">系统默认</span>（实时出单、安全保密、易存易查、不影响理赔）</span>
            </div>
            <div class="clear"></div>
            <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;">
                    <span class="pull-left check-box">
                        <c:set var="is_send_einvoice_1" value="${(not empty vo.mailPolicyVo.is_send_einvoice && vo.mailPolicyVo.is_send_einvoice eq '1')?'1':'0'}"></c:set>
                        <input type="checkbox" value="1" id="is_send_einvoice"<c:if test="${is_send_einvoice_1 eq '1'}"> checked="checked"</c:if>/>
                        <label for="is_send_einvoice"></label>
                        <input type="hidden" name="mailPolicyVo.is_send_einvoice" value="${vo.mailPolicyVo.is_send_einvoice}" />
                    </span>
                <span class="pull-left lhml5">开具电子发票<span class="label label-success" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">推荐使用</span>（实时开具、加密防伪、长期保存、随打随用）</span>
            </div>
            <div class="clear"></div>
            <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;">
                    <span class="pull-left check-box">
                        <c:set var="is_need_insur_bill" value="${(not empty vo.mailPolicyVo.need_insur_bill && vo.mailPolicyVo.need_insur_bill eq '1')?'1':'0'}"></c:set>
                        <input disabled type="checkbox" value="1" name="mailPolicyVo.need_insur_bill" id="need_insur_bill"<c:if test="${is_need_insur_bill eq '1'}"> checked="checked"</c:if>/>
                        <label for="need_insur_bill"></label>
                    </span>
                <span class="pull-left lhml5">开具纸质保单<span class="label label-danger" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">不推荐</span>（不便于管理、开具时效 3-5 个工作日）</span>
            </div>
            <div class="clear"></div>
            <div id="mod_1" <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> style="display: none;"</c:if>>
                <div class="col-sm-3 col-xs-3">
                    <p>*收件人名称</p>
                    <input Data-Val="Required" type="text" name="mailPolicyVo.receiver_name" id="receiverName" value="${ vo.mailPolicyVo.receiver_name}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill ? true : vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*收件人手机</p>
                    <input Data-Val="Required" type="text" name="mailPolicyVo.receiver_mobile" id="receiverMobile" value="${ vo.mailPolicyVo.receiver_mobile}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-6 col-xs-6">
                    <p>*收件人地址</p>
                    <input Data-Val="Required" type="text" name="mailPolicyVo.receiver_address_detail" id="receiverAddressDetail" value="${ vo.mailPolicyVo.receiver_address_detail}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
            </div>
            <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;">
                    <span class="pull-left check-box">
                        <c:set var="is_need_receipt" value="${(not empty vo.mailPolicyVo.need_receipt && vo.mailPolicyVo.need_receipt eq '1')?'1':'0'}"></c:set>
                        <input disabled type="checkbox" value="1" id="need_receipt"<c:if test="${is_need_receipt eq '1'}"> checked="checked"</c:if>/>
                        <label for="need_receipt"></label>
                        <input type="hidden" name="mailPolicyVo.need_receipt" value="${vo.mailPolicyVo.need_receipt}" />
                    </span>
                <span class="pull-left lhml5">开具纸质发票<span class="label label-danger" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">不推荐</span>（不便于管理、开具时效 3-5 个工作日）</span>
            </div>
            <div class="clear"></div>
            <div id="mod_2" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0' || vo.mailPolicyVo.is_send_einvoice eq '0'}"> style="display: none;"</c:if>>
                <div class="col-sm-12 col-xs-12">
                    <p>发票种类</p>
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-sm-2 col-xs-2 rad-io">
                                    <c:set var="is_invoice_type_1" value="${(empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' || vo.mailPolicyVo.is_send_einvoice eq '1')?'1':'0'}"></c:set>
                                    <span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_1" value="0"<c:if test="${is_invoice_type_1 eq '1'}"> checked="checked"</c:if>><label for="invoice_type_1" class="pull-left"></label><strong  class="pull-left">增值税普通发票</strong></span>
                                </div>
                                <div class="col-sm-2 col-xs-2 rad-io"><%--选电子发票就隐藏该项 <c:if test="${vo.mailPolicyVo.is_send_einvoice eq '1'}"> style="display: none;"</c:if> --%>
                                    <c:set var="is_invoice_type_2" value="${(not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '1')?'1':'0'}"></c:set>
                                    <span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_2" value="1"<c:if test="${is_invoice_type_2 eq '1'}"> checked="checked"</c:if>><label for="invoice_type_2" class="pull-left"></label><strong  class="pull-left">增值税专用发票</strong></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-sm-12 col-xs-12 reminder" id="mod_2_1" <c:if test="${(not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0') || vo.mailPolicyVo.is_send_einvoice eq '0' }"> style="display: none;"</c:if>>
                <label>温馨提示：请认真填写下述信息，确保信息真实准确，以免因开票信息错误给贵司带来损失。提交信息后，我司将在1-2个工作日完成审核，请及时关注审核结果。</label>
            </div>
            <div id="mod_2_2" <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> style="display: none;"</c:if>>
                <div class="col-sm-3 col-xs-3">
                    <p>*单位名称</p>
                    <input Data-Val="Required" type="text" name="mailPolicyVo.receipt_head" id="receipt_head" value="${ vo.mailPolicyVo.receipt_head}" class="form-control" placeholder="" <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*收票人姓名</p>
                    <input Data-Val="Required" type="text" name="mailPolicyVo.taker_name" id="takerName" value="${ vo.mailPolicyVo.taker_name}" class="form-control" placeholder="" <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*收票人手机</p>
                    <input Data-Val="Required" type="text" name="mailPolicyVo.taker_mobile" id="takerMobile" value="${ vo.mailPolicyVo.taker_mobile}" class="form-control" placeholder=""  <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*收票人地址</p>
                    <input Data-Val="Required" type="text" name="mailPolicyVo.taker_address_detail" id="takerAddressDetail" value="${ vo.mailPolicyVo.taker_address_detail}" class="form-control" placeholder="企业营业执照上的全称"  <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3" <c:if test="${vo.mailPolicyVo.invoice_type eq '1'}"> style="display: none;"</c:if>>
                    <p>*纳税人识别号</p>
                    <input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice_1" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号"  <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0' || vo.mailPolicyVo.invoice_type eq '1') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
            </div>
            <div id="mod_2_3" <c:if test="${empty mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> style="display: none;"</c:if>>
                <div class="col-sm-3 col-xs-3">
                    <p>*纳税人识别号</p>
                    <input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号"<c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*注册地址</p>
                    <input Data-Val="Required" type="text" name="mailPolicyVo.register_address_invoice" id="registerAddressInvoice" value="${ vo.mailPolicyVo.register_address_invoice}" class="form-control" placeholder="企业营业执照上的注册地址" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*电话</p>
                    <input Data-Val="Required" type="text" name="mailPolicyVo.receipt_phone" id="receiptPhone" value="${ vo.mailPolicyVo.receipt_phone}" class="form-control" placeholder="企业联系电话" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户银行省</p>
                    <select Data-Val="Required" title="省" name="mailPolicyVo.bank_province" id="bankProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('bankCity', '', '2', this);" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
                        <option value="">请选择省</option>
                        <c:forEach items="${provinceList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_province }"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户银行市</p>
                    <select title="市" name="mailPolicyVo.bank_city" id="bankCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
                        <option value="">请选择市</option>
                        <c:forEach items="${bankCityList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_city}"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户银行</p>
                    <input Data-Val="Required" type="text" name="mailPolicyVo.bank_invoice" id="bankInvoice" value="${ vo.mailPolicyVo.bank_invoice}" class="form-control" placeholder="企业银行开户许可证上的开户银行" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*银行账号</p>
                    <input Data-Val="Required" type="text" name="mailPolicyVo.bank_account_invoice" id="bankAccountInvoice" value="${ vo.mailPolicyVo.bank_account_invoice}" class="form-control" placeholder="企业开户许可证上的银行账号" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-4 col-xs-4">
                    <p>税务登记证<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/tax.jpg')">（样例）</a></p>
                    <input type="hidden" title="" name="mailPolicyVo.tax_cert" id="tax_cert" value="${vo.mailPolicyVo.tax_cert }">
                    <div>
                        <input title="" value="${vo.mailPolicyVo.tax_cert }" name="tax_cert_file" id="tax_cert_file-5" data-drawview="${vo.mailPolicyVo.tax_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                    </div>
                    <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                </div>
                <div class="col-sm-4 col-xs-4">
                    <p>一般纳税人证明</p>
                    <input type="hidden" title="" name="mailPolicyVo.tax_prove" id="tax_prove" value="${vo.mailPolicyVo.tax_prove }">
                    <div>
                        <input title="" value="${vo.mailPolicyVo.tax_prove }" name="tax_prove_file" id="tax_prove_file-5" data-drawview="${vo.mailPolicyVo.tax_prove }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                    </div>
                    <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                </div>
                <div class="col-sm-4 col-xs-4">
                    <p>银行开户许可证</p>
                    <input type="hidden" title="" name="mailPolicyVo.bank_licence" id="bank_licence" value="${vo.mailPolicyVo.bank_licence }">
                    <div>
                        <input title="" value="${vo.mailPolicyVo.bank_licence }" name="bank_licence_file" id="bank_licence_file-5" data-drawview="${vo.mailPolicyVo.bank_licence}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                    </div>
                    <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                </div>
                <div class="col-sm-4 col-xs-4">
                    <p>营业执照副本<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/open.jpg')">（样例）</a></p>
                    <input type="hidden" title="" name="mailPolicyVo.business_license" id="business_license" value="${vo.mailPolicyVo.business_license }">
                    <div>
                        <input title="" value="${vo.mailPolicyVo.business_license }" name="business_license_file" id="business_license_file-5" data-drawview="${vo.mailPolicyVo.business_license}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                    </div>
                    <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                </div>
                <div class="col-sm-4 col-xs-4">
                    <p>增票授权委托书（个人支付时需提供此委托书<a href="<c:url value='/resources/files/增票授权委托书.doc' />" target="_blank">下载</a>）</p>
                    <input type="hidden" title="" name="mailPolicyVo.auth_cert" id="auth_cert" value="${vo.mailPolicyVo.auth_cert}">
                    <div>
                        <input title="" value="${vo.mailPolicyVo.auth_cert }" name="auth_cert_file" id="auth_cert_file-5" data-drawview="${vo.mailPolicyVo.auth_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                    </div>
                    <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                </div>
            </div>
        </div><!-- w-95-auto end -->
    </div><!-- message-war end -->
    </form>
    <div class="row next-step">
        <div class="col-sm-12 col-xs-12 text-right pull-right">
            <p>
                <a href="javascript:void(0);" onclick="saveGZZRXInfo();" id="pendingInfo" class="save">暂存本页</a>
                <c:if test="${fn:contains(pd.product_code, 'RB')||fn:contains(pd.product_code, 'ZH')||fn:contains(pd.product_code, 'PAC')||fn:contains(pd.product_code, 'CA')||fn:contains(pd.product_code, 'QH')||fn:contains(pd.product_code, 'TB')}">
                    <a href="javascript:void(0);" onclick="save_policy_gzzrx();" class="ns-btn">下一步</a>
                </c:if>
            </p>
            <%--<p>
                <a href="javascript:void(0);" onclick="saveGMRInfo();" id="pendingInfo" class="save">暂存本页</a>
                <a href="javascript:void(0);" onclick="save_policy_gmr();" class="ns-btn">下一步</a>
            </p>--%>
        </div>
    </div>
</div><!-- container end -->
<input id="fileKeyName" type="hidden" value=""><!-- 上传文件的key，重要！ -->
<!-- 营业执照 start -->
<div class="modal fade" id="open" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">营业执照</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/open.jpg' />" class="img-responsive ml-14">
            </div>
        </div>
    </div>
</div>
<!-- 营业执照 end -->
<!-- 组织机构代码证 start -->
<div class="modal fade" id="org" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">组织机构代码证</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/org.jpg' />" class="img-responsive">
            </div>
        </div>
    </div>
</div>
<!-- 组织机构代码证 end -->
<!-- 税务登记证 start -->
<div class="modal fade" id="tax" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">税务登记证</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/tax.jpg' />" class="img-responsive">
            </div>
        </div>
    </div>
</div>
<jsp:include page="../../../index/multi_f.jsp" />
<%--<button id="stopButton" onclick="fun()">Stop Recording</button>--%>
</body>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/checkInputChangeStyle.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/FileSaver.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/script/html2canvas.min.js' />"></script>
<%--<script type="text/javascript" src="<c:url value='/resources/commonJS/canvasFileUpload.js' />"></script>--%>
<%--<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb.min.js' />"></script>--%>
<%--<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb-record.min.js' />"></script>--%>
<%--<script src="https://cdn.jsdelivr.net/npm/rrweb@latest/dist/rrweb.min.js"></script>--%>
<script src="/static/weChat/js/weixin_g.js"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb.min.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb-save.js?1005' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/watermark.js?7' />"></script>
<script>
    window.onload = function () {
        //以后优化 频繁变更水印
        watermark.load({ watermark_txt: "${fns:getWatermark(dto.trade_serial_number)}" });
    }
    function closeUMsg(){
        var _height = 0;
        <c:if test="${fn:contains(pd.product_code,'GZZRX-QH')}">
        _height = 2400;
        </c:if>
        <c:if test="${fn:contains(pd.product_code,'GZZRX-TB')}">
        _height = 6200;
        </c:if>
        var _bContentHeight = $('#_bContent').scrollTop();
        console.log(_bContentHeight);
        if(_bContentHeight<_height){
            laySomenType(1,null,"“责任免除”内容请阅读到底部",0);
            return;
        }
        $('.contacts_modal_oth').hide();
        $('.black-mask-oth').hide();
    }
    function closeUMsg1(){
        var _text = $('#closeUMsg').text();
        if(_text.indexOf('(')>0){
            return;
        }
        var khgzsHeight = $('#khgzs').scrollTop();
        if(khgzsHeight<620){
            laySomenType(1,null,"“客户告知书”内容请阅读到底部",0);
            return;
        }
        var starP='<p class="MsoNormal" align="center" style="text-align:center;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:14.0000pt;mso-font-kerning:1.0000pt;">保险条款</span><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:14.0000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-bottom:7.8500pt;mso-para-margin-bottom:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;">_pcs<b><span style="font-family: 宋体; font-size: 10pt;"><o:p></o:p></span></b></p>';
        var starA='';
        <c:if test="${not empty pd.pro_clauses}">
        <c:forEach items="${fn:split(pd.pro_clauses, '#')}" var="pcs">
        starA += '<b><span style="font-family: 宋体; font-size: 12pt;">${fn:split(pcs, "::")[1]}</span></b><iframe id="frame3d" name="frame3d" frameborder="0" width="100%" height="400px" scrolling="auto" title="${fn:split(pcs, "::")[1]}" src="<c:url value='/weixin/product/clause/${fn:split(pcs, "::")[0]}' />" ></iframe>';
        </c:forEach>
        </c:if>
        starP = starP.replace('_pcs',starA);
        <c:if test="${fn:contains(pd.product_code,'GZZRX-QH')}">
        <%--$('#_bContent').html('<p class="MsoNormal" align="center" style="text-align:center;"><b><span style="font-family: 宋体; font-size: 16pt;">责任免除特别提示</span></b><b><span style="font-family: 宋体; font-size: 16pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="center" style="text-align:center;"><b><span style="font-family: 宋体; font-size: 16pt;">&nbsp;</span></b></p><p class="MsoNormal" style="text-indent: 21.1pt;"><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;">责任免除是免除保险人责任，即保险人不承担保险金给付责任的内容。本保险产品责任免除包含适用主险和附加险条款中的责任免除条款及保单的特别约定等内容，请投保人认真阅读本责任免除的全部内容以及对部分内容（已用蓝色文字标记）的解释说明。对责任免除内容有任何不理解或不接受之处，请勿投保。购买本保险产品即表示投保人接受本责任免除的全部内容。</span></b><b><span style="font-family: 宋体; color: rgb(255, 0, 0); font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="center" style="margin-top:15.6500pt;margin-bottom:15.6500pt;mso-para-margin-top:1.0000gd;mso-para-margin-bottom:1.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;text-align:center;"><b><span style="font-family: 宋体; font-size: 16pt;">第一部分</span></b><b><span style="font-family: 宋体; font-size: 16pt;">&nbsp;</span></b><b><span style="font-family: 宋体; font-size: 16pt;">条款中的责任免除</span></b><b><span style="font-family: 宋体; font-size: 16pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:16.0500pt;mso-char-indent-count:1.0000;text-align:justify;text-justify:inter-ideograph;"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 16pt;">一、</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);mso-ansi-font-weight:bold;font-size:14.0000pt;mso-font-kerning:1.0000pt;">雇主责任保险条款的</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);mso-ansi-font-weight:bold;font-size:14.0000pt;mso-font-kerning:1.0000pt;">责任免除</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 16pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">第</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">一</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">条</font> </span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">下列原因造成的损失、费用和责任，保险人不负责赔偿：</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（一）投保人、被保险人及其代表的故意行为、重大过失行为；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（二）战争、敌对行动、军事行为、武装冲突、罢工、骚乱、暴动、恐怖活动；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（三）核辐射、核爆炸、核污染及其他放射性污染；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（四）大气污染、土地污染、水污染及其他各种污染；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（五）行政行为或司法行为</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（六）</span></b><b><u><span style="font-family: 宋体; line-height: 150%; color: rgb(0, 0, 255); font-size: 10.5pt;">雇员</span></u></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">的故意行为、犯罪行为或违法行为；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（七）雇员因</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">职业病</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">以外的疾病、传染病、分娩、流产以及因上述原因接受医疗、诊治；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（八）雇员自残、自伤、自杀、打架、斗殴及无合法有效驾驶证照驾驶各种机动车辆；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（九）雇员</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">因非职业原因而受酒精或药剂的影响</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">。</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">第</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">二</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">条</font> <font face="宋体">下列损失、费用和责任，保险人不负责赔偿：</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">（一）被保险人应该承担的合同责任，但无合同存在时仍然应由被保险人承担的经济赔偿责任不在此限；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">（二）罚款、罚金及惩罚性赔偿；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">（三）精神损害赔偿；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">（四）间接损失；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（五）</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">除</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">另有约</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">定外，在中华人民共和国境外所发生的</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">雇员</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">的伤残或死亡；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（六）超出雇员所在地工伤保险诊疗项目目录、工伤保险药品目录、工伤保险住院服务标准的医疗费用；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（七）工伤保险已经支付的费用；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（八）雇员在中华人民共和国境外（包括港、澳、台地区）发生的人身伤亡；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（九）被保险人对其承包商的雇员的赔偿责任；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（十）陪护费、伙食费、营养费、交通费、取暖费、空调费及安装假肢、假牙、假眼和残疾用具等费用；</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">（十一）本保险合同中载明的免赔额</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">。</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:widow-orphan;line-height:150%;"><b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;color:rgb(0,0,0);mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">&nbsp;</span></b></p><p class="MsoNormal" align="justify" style="text-indent:0.0000pt;mso-char-indent-count:0.0000;text-autospace:ideograph-numeric;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;"><b><span style="font-family: 宋体; line-height: 150%; color: rgb(0, 0, 0); font-size: 14pt;">二、</span></b><b><span style="font-family: 宋体; line-height: 150%; color: rgb(0, 0, 0); font-size: 14pt;">附加非工伤意外事故补偿保险条款</span></b><b><span style="font-family: 宋体; line-height: 150%; color: rgb(0, 0, 0); font-size: 14pt;">的责任免除</span></b><b><span style="font-family: 宋体; line-height: 150%; color: rgb(0, 0, 0); font-size: 14pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;"><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（一</font><font face="宋体">)被保险人的雇员因整容手术或其他内、外科手术导致医疗事故或手术意外；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;"><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">（二）被保险人的雇员进行潜水、滑雪、滑板、滑翔、冲浪、蹦极、热气球、跳伞、攀岩、漂流、探险活动、特技表演、赛马、赛车等高风险运动，或进行摔跤、柔道、拳击、武术、散打、空手道、跆拳道等搏击运动；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;"><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">（三）主险条款第五条、第六条、第七条所列的责任免除条款。</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;"><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></b></p><p class="MsoNormal" style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;"><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></b></p><p class="MsoNormal" align="center" style="margin-top:15.6500pt;margin-bottom:15.6500pt;mso-para-margin-top:1.0000gd;mso-para-margin-bottom:1.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;text-align:center;"><b><span style="font-family: 宋体; font-size: 16pt;">第二部分</span></b><b><span style="font-family: 宋体; font-size: 16pt;">&nbsp;</span></b><b><span style="font-family: 宋体; font-size: 16pt;">特别约定中的责任免除</span></b><b><span style="font-family: 宋体; font-size: 16pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="line-height: 150%;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">1.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">本保险产品仅限保安行业及物业行业企业投保，仅承保</font><font face="宋体">16周岁（含16周岁）至65周岁且职业为保安、清洁工、水电工、行政人员、一般外勤的雇员。</font></span><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">当被保险人所属行业或雇员的年龄职业不符合前述要求时，保险人有权解除合同，保险合同自始无效，且不承担保险责任。本保险产品同一雇员累计最高有效承保份数为</font><font face="宋体">1份，多投无效。 &nbsp;</font></span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="line-height: 150%;"><!--[if !supportLists]--><span style="font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">2.&nbsp;</span><!--[endif]--><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">本保单承保区域仅限</font><font face="宋体">“北京、陕西、湖南、广西、宁夏、山东、天津、江苏”，对于被保险人雇员工作地址超出承保区域的投保或出险不承担任何赔偿或给付责任。</font></span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="line-height: 150%;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">3.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; font-size: 10.5pt;">在保险期间内，被保险人的雇员在受雇过程中从事被保险人的业务工作而遭受意外伤害所致伤残或死亡且符合《工伤保险条例》规定可认定为工伤的，依照中华人民共和国法律（不包括港澳台地区）应由被保险人承担的经济赔偿责任，保险人按照如下约定负责赔偿：</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 150%;"><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">（</font><font face="宋体">1）死亡保险金：赔偿限额不超过保单约定的每人伤亡赔偿限额。</font></span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 150%;"><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">（</font><font face="宋体">2）伤残保险金：伤残赔偿评定标准按《劳动能力鉴定职工工伤与职业病致残等级》（GB/T 16180-2014）执行，并按照以下比例在每人伤亡赔偿限额内计算伤残赔偿金：一级100%，二级80%，三级70%，四级60%，五级50%，六级40%，七级30%，八级20%，九级10%，十级5%。</font></span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">（</font><font face="宋体">3）意外医疗保险金：被保险人对其雇员因本保险合同列明的原因所产生保险事故依法应承担且属于当地基本医疗保险主管部门规定可报销的医疗费用，保险人在扣除每次事故绝对免赔额100元后在每人医疗费用赔偿限额内进行赔偿。</font></span></b><span style="font-family: 宋体; font-size: 10.5pt;">医疗费用包括挂号费、治疗费、手术费、床位费、检查费、非自费药费部分，</span><b><span style="font-family: 宋体; font-size: 10.5pt;">但不包括陪护费、伙食费、营养费、交通费、取暖费、空调费及安装假肢、假牙、假眼和残疾用具等费用。该项责任赔偿限额在每人伤亡赔偿限额内进行计算，而非独立保额。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="line-height: 150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">（</font><font face="宋体">4）误工费用：</font></span></b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">被保险人的雇员因本保险合同列明的原因导致其暂时丧失工作能力的，经医院诊断证明，保险人对其住院期间的误工损失按保单约定的每日</font><font face="宋体">100元的赔偿限额标准进行补偿，</font></span><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">保单年度内每人每次事故赔偿不超</font><font face="宋体">90天，累计赔偿不超180天。其中：每次事故每人门诊治疗赔偿不超15天，住院治疗以实际住院天数计算赔偿，出院后休息天数赔偿不超30天。该项责任赔偿限额在每人伤亡赔偿限额内进行计算，而非独立保额。</font></span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="line-height: 150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">（</font><font face="宋体">5）猝死保险金：</font></span></b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">在工作时间和工作岗位，被保险人的雇员突发疾病死亡或者在</font><font face="宋体">48小时之内经抢救无效死亡，保险人按保险合同约定的工作期间猝死赔偿限额负责赔偿。</font></span><b><span style="font-family: 宋体; font-size: 10.5pt;">该项责任赔偿限额在每人伤亡赔偿限额内进行计算，而非独立保额。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="line-height: 150%;"><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">（</font><font face="宋体">6）诉讼费用：赔偿限额不超过保单约定的每人诉讼费用赔偿限额。</font></span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 150%;"><!--[if !supportLists]--><span style="font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">4.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">本保险合同附加非工伤意外事故补偿保险，被保险人的雇员在其雇佣期间非因从事保险单所载明的被保险人的工作而遭受意外事故，被保险人依法需承担的补偿责任，保险人按照主险条款的规定，在保险单约定的本附加险赔偿限额内负责赔偿。</span><b><span style="font-family: 宋体; font-size: 10.5pt;">该附加险项下的每人死亡伤残赔偿限额及每人医疗费赔偿限额均在主险每人对应赔偿限额内进行计算，而非独立保额。</span></b><span style="font-family: 宋体; font-size: 10.5pt;">非</span><span style="font-family: 宋体; font-size: 10.5pt;">工伤</span><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">意外事故伤残评定标准及赔付比例按照《人身保险伤残评定标准及代码》（保监发〔</font><font face="宋体">2014〕6号，标准编号为JR/T 0083-2013）进行评定及给付。赔偿比例为：一级100%、二级90%、三级80%、四级70%、五级60%、六级50%、七级40%、八级30%、九级20%、十级10%。</font></span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 150%;"><!--[if !supportLists]--><span style="font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">5.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">本保险合同扩展附加住院津贴</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">责任</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">保险条款，被保险人的雇员发生保险责任范围内的保险事故需住院治疗的，就被保险人对雇员应承担的住院津贴责任，保险人按照每人每次事故住院日数计算赔偿日数，在赔偿日数乘以每人每日住院津贴责任限额的数额内进行赔偿</span><span style="font-family: 宋体; font-size: 10.5pt;">，</span><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">每次最高赔偿</font><font face="宋体">90天，累计总赔偿天数以180天为限。</font></span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="line-height: 150%;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">6.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">本保险合同扩展承保非工作时间和工作岗位，被保险人的雇员突发疾病死亡或者在</font><font face="宋体">48小时之内经抢救无效死亡的赔偿责任，赔偿限额不超过保单约定的每人非工作期间猝死赔偿限额。</font></span><b><span style="font-family: 宋体; font-size: 10.5pt;">该项责任赔偿限额在每人伤亡赔偿限额内进行计算，而非独立保额。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="line-height: 150%;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">7.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; font-size: 10.5pt;">本保险产品可选择按年投保和按月投保，期间如涉及人员变更按以下约定执行：</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 150%;"><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">（</font><font face="宋体">1）保险期间可以替换人员（但已经出险的雇员不得变更），请提前1天在系统中批改换人名单，新换人员第二天零时保险生效。</font></span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 150%;"><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">（</font><font face="宋体">2）保险期间可以批增人员，年度保单按日比例计收保险责任开始之日起至合同解除之日止期间的保险费，月度保单按月保费标准计收保险费。请提前1天在系统中增加新人名单，第二天零时保险生效，加人保费月底统一结算。</font></span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal" style="line-height: 150%;"><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">（</font><font face="宋体">3）年度保单可在保险期间内进行人员批减并按保单约定退还未满期保险费，未满期保险费=保险费×（1-保险单已经过天数/保险期间天数），经过天数不足一天的按一天计算；月度保单批减人员不退还保费。减人保费月底统一结算。</font></span><b><span style="font-family: 宋体; font-size: 10.5pt;">在保险期限内发生事故时投保清单内人员可正常理赔，不在清单范围内的人员则视为未投保，不予以理赔。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="line-height: 150%;"><!--[if !supportLists]--><span style="font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">8.&nbsp;</span><!--[endif]--><b><span style="font-family: 宋体; font-size: 10.5pt;">被保险人的雇员从事道路清洁、</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">下水道清洁、</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">道路绿化作业、</font><font face="宋体">2米或2米以上的高空作业时发生的意外事故，保险公司不承担给付保险金责任。</font></span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="line-height: 150%;"><b><span style="font-family: 宋体; font-size: 10.5pt;">&nbsp;</span></b></p><p class="MsoNormal" align="center" style="margin-top:15.6500pt;margin-bottom:15.6500pt;mso-para-margin-top:1.0000gd;mso-para-margin-bottom:1.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;text-align:center;"><b><span style="font-family: 宋体; font-size: 16pt;">第三部分</span></b><b><span style="font-family: 宋体; font-size: 16pt;">&nbsp;</span></b><b><span style="font-family: 宋体; font-size: 16pt;">责任免除的解释说明</span></b><b><span style="font-family: 宋体; font-size: 16pt;"><o:p></o:p></span></b></p><p class="MsoNormal" align="justify" style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l1 level1 lfo2;"><!--[if !supportLists]--><span style="font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">1．</span><!--[endif]--><b><span style="font-family: 宋体; line-height: 150%; color: rgb(0, 0, 0); font-size: 10.5pt;">雇员</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;color:rgb(0,0,0);font-size:10.5000pt;mso-font-kerning:1.0000pt;">：是指与被保险人签订有劳动合同或存在事实劳动合同关系，接受被保险人给付薪金、工资，年满十六周岁的人员及其他按国家规定审批的未满十六周岁的特殊人员</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;color:rgb(0,0,0);font-size:10.5000pt;mso-font-kerning:1.0000pt;">, </span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;color:rgb(0,0,0);font-size:10.5000pt;mso-font-kerning:1.0000pt;">包括正式在册职工、短期工、临时工、季节工和徒工等。</span><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;color:rgb(0,0,0);mso-ansi-font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;">但因委托代理、行纪、居间等其他合同为被保险人提供服务或工作的人员不属于本保险合同所称雇员。</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="p" align="center" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;text-align:center;line-height:24.0000pt;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:16.0000pt;mso-font-kerning:0.0000pt;">&nbsp;</span></p><p class="p" align="center" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;text-align:center;line-height:24.0000pt;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:16.0000pt;mso-font-kerning:0.0000pt;">投保须知</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:16.0000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">1.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><font face="宋体">本保险产品名为前海保安物业雇主险，由新疆前海联合财产保险股份有限公司（以下简称</font><font face="宋体">“前海财险”）承保，通过百联保平台在中华人民共和国境内（香港、澳门、台湾地区除外）销售。目前前海财险在广东、深圳、新疆、四川、湖北有分支机构。</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">2.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><font face="宋体">本保险产品适用条款为《新疆前海联合财产保险股份有限公司前海财险雇主责任保险》（注册号：</font><font face="宋体">C00020830912019031230902）、</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;color:rgb(255,0,0);font-size:10.5000pt;mso-font-kerning:0.0000pt;"><font face="宋体">《新疆前海联合财产保险股份有限公司雇主责任保险附加非工伤意外事故补偿保险</font><font face="宋体">-(前海财险)(备-责任保险)【2016】(附) 325号》（注册号：H00020830922016120908691）、《新疆前海联合财产保险股份有限公司前海财险雇主责任保险附加住院津贴责任保险》（注册号：C00020830922023083140681）</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">、《</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">新疆前海联合财产保险股份有限公司前海财险雇主责任保险附加非工伤突发急性病身故责任保险条款</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">》（注册号：</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">C00020830922022121392291</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">）。</span><b><span style="font-family: 宋体; font-size: 10.5pt;">请投保人了解、同意并确认上述条款内容，特别是保险责任及责任免除的部分。购买本保险产品即表示投保人同意接受本产品条款及投保须知的全部内容。</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">3.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><font face="宋体">投保人</font><font face="宋体">/被保险人：仅限保安行业与物业行业企业。</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">4.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><font face="宋体">本保险产品承保雇员限年满</font><font face="宋体">16周岁（含16周岁）至65周岁且职业为保安、清洁工、水电工、行政人员、一般外勤，身体健康、能正常工作或正常生活的自然人。</font></span><b><span style="font-family: 宋体; font-size: 10.5pt;">当被保险人雇员的年龄或职业不符合前述要求时，保险人有权解除合同，保险合同自始无效，且不承担保险责任。</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">5.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><font face="宋体">承保份数限制：本保险产品下，同一雇员累计最高有效承保份数为</font><font face="宋体">1份，</font></span><b><span style="font-family: 宋体; font-size: 10.5pt;">多投无效</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">6.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">本保单采用记名承保，可承保人员包括正式在册职工、短期工、临时工、季节工和徒工等，投保时须提交被保险人雇员名单信息，包括姓名、身份证号、工种名称、工作省份。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">7.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">在保险期间内，被保险人的雇员在受雇过程中从事被保险人的业务工作而遭受意外伤害所致伤残或死亡且符合《工伤保险条例》规定可认定为工伤的，依照中华人民共和国法律（不包括港澳台地区）应由被保险人承担的经济赔偿责任，保险人按照如下约定负责赔偿：</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="MsoNormalIndent" style="line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font><font face="宋体">1）死亡保险金：赔偿限额不超过保单约定的每人伤亡赔偿限额。</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormalIndent" style="line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font><font face="宋体">2）伤残保险金：伤残赔偿评定标准按《劳动能力鉴定职工工伤与职业病致残等级》（GB/T 16180-2014）执行，并按照以下比例在每人伤亡赔偿限额内计算伤残赔偿金：一级100%，二级80%，三级70%，四级60%，五级50%，六级40%，七级30%，八级20%，九级10%，十级5%。</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormalIndent" style="line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font><font face="宋体">3）意外医疗保险金：</font></span><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">被保险人对其雇员因本保险合同列明的原因所产生保险事故依法应承担且属于当地基本医疗保险主管部门规定可报销的医疗费用，保险人在扣除每次事故绝对免赔额</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">100元</span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">后在每人医疗费用赔偿限额内进行赔偿。</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;">医疗费用包括挂号费、治疗费、手术费、床位费、检查费、非自费药费部分，</span><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">但不包括陪护费、伙食费、营养费、交通费、取暖费、空调费及安装假肢、假牙、假眼和残疾用具等费用。该项责任赔偿限额在每人伤亡赔偿限额内进行计算，而非独立保额。</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormalIndent" style="line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font><font face="宋体">4）误工费用：被保险人的雇员因本保险合同列明的原因导致其暂时丧失工作能力的，经医院诊断证明，保险人对其住院期间的误工损失按保单约定的每日100元的赔偿限额标准进行补偿，</font></span><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><font face="宋体">保单年度内每人每次事故赔偿不超</font><font face="宋体">90天，累计赔偿不超180天。其中：每次事故每人门诊治疗赔偿不超15天，住院治疗以实际住院天数计算赔偿，出院后休息天数赔偿不超30天。该项责任赔偿限额在每人伤亡赔偿限额内进行计算，而非独立保额。</font></span></b><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormalIndent" style="line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font><font face="宋体">5）猝死保险金：在工作时间和工作岗位，被保险人的雇员突发疾病死亡或者在48小时之内经抢救无效死亡，保险人按保险合同约定的工作期间猝死赔偿限额负责赔偿。</font></span><b><span style="font-family: 宋体; line-height: 150%; font-size: 10.5pt;">该项责任赔偿限额在每人伤亡赔偿限额内进行计算，而非独立保额。</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormalIndent" style="line-height:150%;"><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font><font face="宋体">6）诉讼费用：赔偿限额不超过保单约定的每人诉讼费用赔偿限额。</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">8.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">本保险合同附加非工伤意外事故补偿保险，被保险人的雇员在其雇佣期间非因从事保险单所载明的被保险人的工作而遭受意外事故，被保险人依法需承担的补偿责任，保险人按照主险条款的规定，在保险单约定的本附加险赔偿限额内负责赔偿。</span><b><span style="font-family: 宋体; font-size: 10.5pt;">该附加险项下的每人死亡伤残赔偿限额及每人医疗费赔偿限额均在主险每人对应赔偿限额内进行计算，而非独立保额。</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><font face="宋体">非工伤意外事故伤残评定标准及赔付比例按照《人身保险伤残评定标准及代码》（保监发〔</font><font face="宋体">2014〕6号，标准编号为JR/T 0083-2013）进行评定及给付。赔偿比例为：一级100%、二级90%、三级80%、四级70%、五级60%、六级50%、七级40%、八级30%、九级20%、十级10%。</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">9.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">本保险合同扩展附加住院津贴</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">责任</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">保险条款，被保险人的雇员发生保险责任范围内的保险事故需住院治疗的，就被保险人对雇员应承担的住院津贴责任，保险人按照每人每次事故住院日数计算赔偿日数，在赔偿日数乘以每人每日住院津贴责任限额的数额内进行赔偿</span><span style="font-family: 宋体; font-size: 10.5pt;">，</span><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">每次最高赔偿</font><font face="宋体">90天，累计总赔偿天数以180天为限</font></span></b><span style="font-family: 宋体; font-size: 10.5pt;">。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">10.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><font face="宋体">本保险合同可选择扩展承保非工作时间和工作岗位，被保险人的雇员突发疾病死亡或者在</font><font face="宋体">48小时之内经抢救无效死亡的赔偿责任，赔偿限额不超过保单约定的每人非工作期间猝死赔偿限额。</font></span><b><span style="font-family: 宋体; font-size: 10.5pt;">该项责任赔偿限额在每人伤亡赔偿限额内进行计算，而非独立保额。</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">11.&nbsp;</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">本保险产品可选择按年投保和按月投保，期间如涉及人员变更按以下约定执行：</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;text-indent:21.0000pt;mso-char-indent-count:2.0000;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l3 level1 lfo4;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">（1）</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><font face="宋体">保险期间可以替换人员（但已经出险的雇员不得变更），请提前</font><font face="宋体">1天在系统中批改换人名单，新换人员第二天零时保险生效。</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l3 level1 lfo4;"><!--[if !supportLists]--><span style="font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">（2）</span><!--[endif]--><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><font face="宋体">保险期间可以批增人员，年度保单按日比例计收保险责任开始之日起至合同解除之日止期间的保险费，月度保单按月保费标准计收保险费。请提前</font><font face="宋体">1天在系统中增加新人名单，第二天零时保险生效，加人保费月底统一结算。</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;text-indent:21.0000pt;mso-char-indent-count:2.0000;mso-pagination:widow-orphan;line-height:24.0000pt;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><font face="宋体">（</font><font face="宋体">3）年度保单可在保险期间内进行人员批减并按保单约定退还未满期保险费，未满期保险费=保险费×（1-保险单已经过天数/保险期间天数），经过天数不足一天的按一天计算；月度保单批减人员不退还保费。减人保费月底统一结算。</font></span><b><span style="font-family: 宋体; font-size: 10.5pt;">在保险期限内发生事故时投保清单内人员可正常理赔，不在清单范围内的人员则视为未投保，不予以理赔。</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">12.&nbsp;</span><!--[endif]--><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">本保单承保区域仅限</font><font face="宋体">“北京、陕西、湖南、广西、宁夏、山东、天津、江苏”，对于被保险人雇员工作地址超出承保区域的投保或出险不承担任何赔偿或给付责任。</font></span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family:宋体;font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;">13.&nbsp;</span><!--[endif]--><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">被保险人的雇员从事道路清洁、下水道清洁、道路绿化作业、</font><font face="宋体">2米或2米以上的高空作业时发生的意外事故，保险公司不承担给付保险金责任。</font></span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">14.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">投保人、被保险人或受益人应在出险后</font><font face="宋体">24小时内及时报案，积极履行出险后的通知义务。</font></span><b><span style="font-family: 宋体; font-size: 10.5pt;">否则，因投保人、被保险人或受益人拖延报案致使保险事故的性质、原因、损失程度难以确定的，保险人对无法确定的部分，不承担赔偿或者给付保险金的责任。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">15.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">退保</font><font face="宋体">/批改： 1）年度保单：保单生效前或生效后未超过48小时的，投保人要求解除本合同，自保险人接到投保人申请后，本合同的效力终止，并全额退还保费。保单生效后超过48小时的，投保人要求解除本合同，自保险人接到保险合同解除申请书之日次日零时起，本合同的效力终止，保险人收到证明文件和资料之日起30日内退还未满期净保险费。未满期净保险费=保险费×（1-保险单已经过天数/保险期间天数），经过天数不足一天的按一天计算。2）月度保单：在保单生效后申请退保或批减在保雇员的，可退保费为0</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:0.0000pt;">。</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">16.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">本保险产品采用电子保单形式承保，法律效力等同于纸质保单。投保人可登陆前海财险官网</font><font face="宋体">https://www.qhins.com/，进行保单查询、验真及电子保单下载等操作。如需要纸质保单及发票，请拨打前海财险全国客服专线4008110110，我们提供顺丰快递到付服务。</font></span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">17.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; font-size: 10.5pt;">在投保本保险产品前您应履行相应的如实告知义务，具体如下：投保人或被保险人应如实填写投保信息，并就保险公司提出的询问据实告知，</span><b><span style="font-family: 宋体; font-size: 10.5pt;">否则保险公司有权根据《中华人民共和国保险法》第十六条的规定解除保险合同且不承担赔偿责任</span></b><span style="font-family: 宋体; font-size: 10.5pt;">；订立保险合同时，保险公司就保险标的或者被保险人的有关情况提出询问的，投保人应当如实告知。</span><b><span style="font-family: 宋体; font-size: 10.5pt;">投保人故意或者因重大过失未履行前款规定的如实告知义务，足以影响保险公司决定是否同意承保或者提高保险费率的，保险公司有权解除合同。投保人故意不履行如实告知义务的，保险公司对于合同解除前发生的保险事故，不承担赔偿责任，并不退还保险费。投保人因重大过失未履行如实告知义务，对保险事故的发生有严重影响的，保险公司对于合同解除前发生的保险事故，不承担赔偿责任，但退还保险费。</span></b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">18.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; font-size: 10.5pt;">保险人在提供承保、理赔等保险服务时可能需要通过知悉被保险人信息的机构查询被保险人的个人信息，包括但不限于投保、承保、理赔、医疗等。保险人保证严格遵守现行的关于个人信息、数据及隐私保护的法律法规，采取充分的技术手段和制度管理，保护由被保险人提供或由保险人获取的被保险人的个人信息、数据和隐私不受到非法的泄露或披露给未经许可的第三方。在必要情形下第三方可能接触并使用被保险人的个人信息，包括得到授权的保险人的员工、以及不时执行与保险人的业务、营销活动和数据整理有关工作的其他公司或人员。所有此类人员及公司均需遵守相关保密协议，同时也需要遵守国家关于个人信息保护有关的法律法规，以确保被保险人的个人信息随时得到保护。除上述用途外，保险人不会将被保险人的个人信息用于任何未经被保险人同意的用途。除了保险人的业务合作伙伴、法律顾问、外部审计机构或按照法律规定、监管规定或法庭裁决之外，保险人不会将所接受的任何个人信息泄露、篡改、毁损、出售或者提供给任何第三方。</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">19.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">偿付能力告知：新疆前海联合财产保险股份有限公司达到监管要求的风险综合评级，偿付能力及风险综合评级（分类监管）结果可登录保险公司网站</font><font face="宋体">https://www.qhins.com/cms/statics/solvencyInfos.html查询。</font></span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="p" style="margin-bottom:7.5000pt;mso-pagination:widow-orphan;line-height:24.0000pt;mso-list:l0 level1 lfo3;"><!--[if !supportLists]--><span style="font-family: 宋体; font-size: 10.5pt;">20.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">本保险产品详细保险条款内容可登录保险公司官方网站</font><font face="宋体">https://www.qhins.com/cms/statics/notCarInsuranceProduct.html查询。</font></span><span style="font-family: 宋体; font-size: 11pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p>'+starP);--%>
        $('#_bContent').html('<p class=MsoNormal  align=center  style="text-align:center;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:16.0000pt;mso-font-kerning:1.0000pt;" ><o:p>&nbsp;</o:p></span></b></p><p class=MsoNormal  style="mso-para-margin-top:0.0000gd;mso-para-margin-bottom:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;text-align:left;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(255,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >责任免除是免除保险人责任，即保险人不承担保险金给付责任的内容。本保险产品责任免除包含适用主险和附加险条款中的责任免除条款及保单的特别约定等内容，请投保人认真阅读本责任免除的全部内容以及对部分内容（已用蓝色文字标记）的解释说明。对责任免除内容有任何不理解或不接受之处，请勿投保。购买本保险产品即表示投保人接受本责任免除的全部内容。</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(255,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=center  style="margin-top:15.6500pt;margin-bottom:15.6500pt;mso-para-margin-top:1.0000gd;mso-para-margin-bottom:1.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;text-align:center;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:16.0000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >第一部分</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:16.0000pt;mso-font-kerning:1.0000pt;" >&nbsp;</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:16.0000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >条款中的责任免除</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:16.0000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:16.0500pt;mso-char-indent-count:1.0000;text-align:justify;text-justify:inter-ideograph;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:16.0000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >一、</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:14.0000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >雇主责任保险条款的</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:14.0000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >责任免除</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:16.0000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >第</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >一</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >条</font> </span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >下列原因造成的损失、费用和责任，保险人不负责赔偿：</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（一）投保人、被保险人及其代表的故意行为、重大过失行为；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（二）战争、敌对行动、军事行为、武装冲突、罢工、骚乱、暴动、恐怖活动；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（三）核辐射、核爆炸、核污染及其他放射性污染；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（四）大气污染、土地污染、水污染及其他各种污染；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（五）行政行为或司法行为</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（六）</font></span></b><b><u><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;color:rgb(0,0,255);font-weight:bold;text-decoration:underline;text-underline:single;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >雇员</font></span></u></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >的故意行为、犯罪行为或违法行为；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（七）雇员因</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >职业病</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >以外的疾病、传染病、分娩、流产以及因上述原因接受医疗、诊治；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（八）雇员自残、自伤、自杀、打架、斗殴及无合法有效驾驶证照驾驶各种机动车辆；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（九）雇员</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >因非职业原因而受酒精或药剂的影响</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >。</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >第</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >二</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >条</font> <font face="宋体" >下列损失、费用和责任，保险人不负责赔偿：</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（一）被保险人应该承担的合同责任，但无合同存在时仍然应由被保险人承担的经济赔偿责任不在此限；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（二）罚款、罚金及惩罚性赔偿；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（三）精神损害赔偿；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（四）间接损失；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（五）</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >除</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >另有约</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >定外，在中华人民共和国境外所发生的</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >雇员</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >的伤残或死亡；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（六）超出雇员所在地工伤保险诊疗项目目录、工伤保险药品目录、工伤保险住院服务标准的医疗费用；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（七）工伤保险已经支付的费用；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（八）雇员在中华人民共和国境外（包括港、澳、台地区）发生的人身伤亡；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（九）被保险人对其承包商的雇员的赔偿责任；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（十）陪护费、伙食费、营养费、交通费、取暖费、空调费及安装假肢、假牙、假眼和残疾用具等费用；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（十一）本保险合同中载明的免赔额</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >。</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="mso-layout-grid-align:none;layout-grid-mode:char;mso-pagination:widow-orphan;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;line-height:150%;color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:0.0000pt;" ><o:p>&nbsp;</o:p></span></b></p><p class=MsoNormal  align=justify  style="text-indent:14.0500pt;mso-char-indent-count:1.0000;text-align:justify;text-justify:inter-ideograph;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:14.0000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >二、附加</font>24<font face="宋体" >小时意外险特别扩展条款（</font><font face="Calibri" >B</font><font face="宋体" >）的责任免除</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:14.0000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >本保单对以下原因直接或间接导致被保险人之雇员死亡或人身伤害不负赔偿责任：</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（</font>1）</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >战争、战乱、反叛、罢工、暴乱、动乱以及核辐射等；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（</font>2）</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >疾病、传染病、生育、怀孕、医疗以及手术等；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（</font>3）</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >故意自残、自杀以及因药物或酒精导致的犯罪或失常行为；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（</font>4）</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >打架、酗酒、吸毒、精神错乱以及高危险运动；</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >高风险运动包括但不仅限于：</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" >-航空飞行，乘坐民航飞机除外；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" >-使用呼吸器具的潜水活动；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" >-足球，以业余身份参加除外；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" >-滑翔运动；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" >-冰上曲棍球；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" >-摩托车竞赛；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" >-驾驶或乘坐50cc以上摩托车；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" >-登山、攀岩、攀崖；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" >-跳伞；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" >-地穴探险；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" >-汽车竞赛；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" >-以运动为职业；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" >-出于商业目的使用木制家具机器；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" >-滑水、跳水及水上竞技；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" >-冬季运动，冰上溜石活动和溜冰除外；</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="margin-top:7.8000pt;margin-bottom:7.8000pt;mso-para-margin-top:0.5000gd;mso-para-margin-bottom:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p>&nbsp;</o:p></span></b></p><p class=MsoNormal  align=center  style="margin-top:15.6500pt;margin-bottom:15.6500pt;mso-para-margin-top:1.0000gd;mso-para-margin-bottom:1.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;text-align:center;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:16.0000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >第二部分</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:16.0000pt;mso-font-kerning:1.0000pt;" >&nbsp;</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:16.0000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >特别约定中的责任免除</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:16.0000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="text-align:left;line-height:150%;mso-list:l1 level1 lfo1;" ><![if !supportLists]><span style="font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><span style=\'mso-list:Ignore;\' >1.<span>&nbsp;</span></span></span><![endif]><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >本保险产品仅限保安行业及物业行业企业投保，仅承保</font>16周岁（含16周岁）至60周岁且职业为保安、清洁工、水电工、行政人员、一般外勤的雇员。</span><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >当被保险人所属行业或雇员的年龄职业不符合前述要求时，保险人有权解除合同，保险合同自始无效，且不承担保险责任。本保险产品同一雇员累计最高有效承保份数为</font>1份，多投无效。 &nbsp;</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="text-align:left;line-height:150%;mso-list:l1 level1 lfo1;" ><![if !supportLists]><span style="font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><span style=\'mso-list:Ignore;\' >2.<span>&nbsp;</span></span></span><![endif]><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >在保险期间内，被保险人的雇员在受雇过程中从事被保险人的业务工作而遭受意外伤害所致伤残或死亡且符合《工伤保险条例》规定可认定为工伤的，依照中华人民共和国法律（不包括港澳台地区）应由被保险人承担的经济赔偿责任，保险人按照如下约定负责赔偿：</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></p><p class=MsoNormal  style="text-align:left;line-height:150%;" ><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（</font>1）死亡保险金：赔偿限额不超过保单约定的每人伤亡赔偿限额。</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></p><p class=MsoNormal  style="text-align:left;line-height:150%;" ><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（</font>2）伤残保险金：伤残赔偿评定标准按《劳动能力鉴定职工工伤与职业病致残等级》（GB/T 16180-2014）执行，并按照以下比例在每人伤亡赔偿限额内计算伤残赔偿金：一级100%，二级80%，三级70%，四级60%，五级50%，六级40%，七级30%，八级20%，九级10%，十级5%。</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></p><p class=MsoNormal  style="text-align:left;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（</font>3）意外医疗保险金：被保险人对其雇员因本保险合同列明的原因所产生保险事故依法应承担且属于当地基本医疗保险主管部门规定可报销的医疗费用，保险人在扣除每次事故绝对免赔额100元后在每人医疗费用赔偿限额内进行赔偿。</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >医疗费用包括挂号费、治疗费、手术费、床位费、检查费、非自费药费部分，</font></span><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >但不包括陪护费、伙食费、营养费、交通费、取暖费、空调费及安装假肢、假牙、假眼和残疾用具等费用。该项责任赔偿限额在每人伤亡赔偿限额内进行计算，而非独立保额。</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="text-align:left;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（</font>4）误工费用：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >被保险人的雇员因本保险合同列明的原因导致其暂时丧失工作能力的，经医院诊断证明，保险人对其住院期间的误工损失按保单约定的每日</font>100元的赔偿限额标准进行补偿，</span><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >保单年度内每人每次事故赔偿不超</font>90天，累计赔偿不超180天。其中：每次事故每人门诊治疗赔偿不超15天，住院治疗以实际住院天数计算赔偿，出院后休息天数赔偿不超30天。该项责任赔偿限额在每人伤亡赔偿限额内进行计算，而非独立保额。</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="text-align:left;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（</font>5）猝死保险金：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >在工作时间和工作岗位，被保险人的雇员突发疾病死亡或者在</font>48小时之内经抢救无效死亡，保险人按保险合同约定的工作期间猝死赔偿限额负责赔偿。</span><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >该项责任赔偿限额在每人伤亡赔偿限额内进行计算，而非独立保额。</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="text-align:left;line-height:150%;" ><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（</font>6）诉讼费用：赔偿限额不超过保单约定的每人诉讼费用赔偿限额。</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></p><p class=MsoNormal  style="text-align:left;line-height:150%;mso-list:l1 level1 lfo1;" ><![if !supportLists]><span style="font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><span style=\'mso-list:Ignore;\' >3.<span>&nbsp;</span></span></span><![endif]><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >本保险合同扩展</font>24小时意外险特别扩展条款（B），非工作期间意外死亡、伤残（包括非工作原因导致）赔偿限额以本附加险所列限额为准。</span><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >该附加险项下的每人死亡伤残赔偿限额及每人医疗费赔偿限额均在主险每人对应赔偿限额内进行计算，而非独立保额。</font></span></b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >非工作期间意外事故伤残评定标准及赔付比例按照《人身保险伤残评定标准及代码》（保监发〔</font>2014〕6号，标准编号为JR/T 0083-2013）进行评定及给付。赔偿比例为：一级100%、二级90%、三级80%、四级70%、五级60%、六级50%、七级40%、八级30%、九级20%、十级10%。</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></p><p class=MsoNormal  style="text-align:left;line-height:150%;mso-list:l1 level1 lfo1;" ><![if !supportLists]><span style="font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><span style=\'mso-list:Ignore;\' >4.<span>&nbsp;</span></span></span><![endif]><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >本保险合同扩展附加住院津贴保险条款，被保险人的雇员发生主险保险责任范围内的保险事故需住院治疗的，保险人按照保险单约定的每人每日住院津贴额</font>100元乘以其实际住院天数负责赔偿，</span><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >每次最高赔偿</font>90天，累计总赔偿天数以180天为限。</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="text-align:left;line-height:150%;mso-list:l1 level1 lfo1;" ><![if !supportLists]><span style="font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><span style=\'mso-list:Ignore;\' >5.<span>&nbsp;</span></span></span><![endif]><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >本保险合同扩展承保非工作时间和工作岗位，被保险人的雇员突发疾病死亡或者在</font>48小时之内经抢救无效死亡的赔偿责任，赔偿限额不超过保单约定的每人非工作期间猝死赔偿限额。</span><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >该项责任赔偿限额在每人伤亡赔偿限额内进行计算，而非独立保额。</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="text-align:left;line-height:150%;mso-list:l1 level1 lfo1;" ><![if !supportLists]><span style="font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><span style=\'mso-list:Ignore;\' >6.<span>&nbsp;</span></span></span><![endif]><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >本保险产品可选择按年投保和按月投保，期间如涉及人员变更按以下约定执行：</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></p><p class=MsoNormal  style="text-align:left;line-height:150%;" ><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（</font>1）保险期间可以替换人员（但已经出险的雇员不得变更），请提前1天在系统中批改换人名单，新换人员第二天零时保险生效。</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></p><p class=MsoNormal  style="text-align:left;line-height:150%;" ><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（</font>2）保险期间可以批增人员，年度保单按日比例计收保险责任开始之日起至合同解除之日止期间的保险费，月度保单按月保费标准计收保险费。请提前1天在系统中增加新人名单，第二天零时保险生效，加人保费月底统一结算。</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></p><p class=MsoNormal  style="text-align:left;line-height:150%;" ><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:normal;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >（</font>3）年度保单可在保险期间内进行人员批减并按保单约定退还未满期保险费，未满期保险费=保险费&#215;（1-保险单已经过天数/保险期间天数），经过天数不足一天的按一天计算；月度保单批减人员不退还保费。减人保费月底统一结算。</span><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >在保险期限内发生事故时投保清单内人员可正常理赔，不在清单范围内的人员则视为未投保，不予以理赔。</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="text-align:left;line-height:150%;mso-list:l1 level1 lfo1;" ><![if !supportLists]><span style="font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><span style=\'mso-list:Ignore;\' >7.<span>&nbsp;</span></span></span><![endif]><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >被保险人的雇员从事道路清洁、</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >下水道清洁、</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >道路绿化作业、</font>2米或2米以上的高空作业时发生的意外事故，保险公司不承担给付保险金责任。</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  style="text-align:left;line-height:150%;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p>&nbsp;</o:p></span></b></p><p class=MsoNormal  align=center  style="margin-top:15.6500pt;margin-bottom:15.6500pt;mso-para-margin-top:1.0000gd;mso-para-margin-bottom:1.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;text-align:center;" ><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:16.0000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >第三部分</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:16.0000pt;mso-font-kerning:1.0000pt;" >&nbsp;</span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:16.0000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >责任免除的解释说明</font></span></b><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-weight:bold;font-size:16.0000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></b></p><p class=MsoNormal  align=justify  style="margin-left:0.0000pt;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;mso-layout-grid-align:none;layout-grid-mode:char;text-autospace:none;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;line-height:150%;mso-list:l0 level1 lfo2;" ><![if !supportLists]><span style="font-family:宋体;mso-bidi-font-family:\'Times New Roman\';color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><span style=\'mso-list:Ignore;\' >1．</span></span><![endif]><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >雇员</font></span></b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;color:rgb(0,0,0);font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >：是指与被保险人签订有劳动合同或存在事实劳动合同关系，接受被保险人给付薪金、工资，年满十六周岁的人员及其他按国家规定审批的未满十六周岁的特殊人员</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;color:rgb(0,0,0);font-size:10.5000pt;mso-font-kerning:1.0000pt;" >, </span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;color:rgb(0,0,0);font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >包括正式在册职工、短期工、临时工、季节工和徒工等。</font></span><b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-bidi-font-family:\'Times New Roman\';line-height:150%;color:rgb(0,0,0);font-weight:bold;font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><font face="宋体" >但因委托代理、行纪、居间等其他合同为被保险人提供服务或工作的人员不属于本保险合同所称雇员。</font></span></b><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;" ><o:p></o:p></span></p>'+starP);
        </c:if>
        <c:if test="${fn:contains(pd.product_code,'GZZRX-TB')}">
        $('#_bContent').html('<div class="col-sm-12 col-xs-12 reminder" style="line-height: 20px;margin-bottom: 20px;"><label>温馨提示：太保保安雇主责任险由于保险公司升级，升级后增员规则调整为“见费出单”，即每次增员需实时支付相应保费方可生效。<br/> 如未及时完成支付，将首先影响当前增员人员的投保状态，同时您也将无法继续办理新的增员或减员操作。具体操作方式如下：<br/> 1.增员时支付：在提交增员信息后，系统将自动弹出支付页面，请您根据页面提示完成支付；<br/> 2.补缴操作：如不慎关闭支付页面，可进入“我的订单”，进入左侧“人员管理”查看待审核批单点击“支付”进行支付。）<br/> 感谢您的理解与配合，如有任何疑问，欢迎随时联系我们。</label></div> <p class="MsoNormal" align="center" style="text-align:center;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:14.0000pt;mso-font-kerning:1.0000pt;">投保须知</span><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:14.0000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:24.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 12pt;">一、条款适用</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">本产品适用条款为：</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">1、必选条款：</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《</font>(太保财险)(备-责任保险)【2016】(主)063号-雇主责任保险（2016版）条款-C00001430912016110806772》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《太保（备案）</font>[2009]N381号-罢工、暴动、民众骚乱条款-H00001430922017052483551》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《太保（备案）</font>[2009]N381号-运动会和社交活动条款-H00001430922017052483511》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《太保（备案）</font>[2009]N381号-就餐时间条款-H00001430922017052483441》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《太保（备案）</font>[2009]N381号-特殊天气条款-H00001430922017052483521》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《太保（备案）</font>[2009]N381号-短期海外公干条款-H00001430922017052483491》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《</font>(太保财险)(备-责任保险)【2020】(附) 538号-雇主责任保险附加24小时个人意外事故医疗费用条款-C00001430922019062115842》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《</font>(太保财险)(备-责任保险)【2016】(附) 098号-雇主责任保险（2016版）附加住院津贴保险条款-C00001430922016110806812》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《</font>(太保财险)(备-责任保险)【2017】(附) 038号-雇主责任保险附加伤残赔偿金赔偿限额比例调整条款-C00001430922017060703711》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《（太保财险）（备</font>-其他）[2013]（附）380号-24小时个人意外事故条款-H00001431922017052435331》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《雇主责任保险附加突发疾病身故条款-C00001430922024042502051》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">2、可选条款：</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《</font>(太保财险)(备-责任保险)【2020】(附) 521号-雇主责任保险附加24小时个人事故条款-C00001430922019062115812》</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:24.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 12pt;">二、基本信息</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">1、保险公司分支机构：北京市、上海市、天津市、重庆市、黑龙江省、吉林省、辽宁省、河北省、山西省、山东省、安徽省、江苏省、浙江省、福建省、江西省、广东省、海南省、广西壮族自治区、湖南省、湖北省、河南省、云南省、贵州省、四川省、陕西省、甘肃省、新疆维吾尔自治区、宁夏回族自治区、内蒙古自治区、青海省、西藏自治区。如您在我司未设分公司的地区购买的，不影响您的理赔，但后续需亲临柜面办理的相关服务可能会受到影响。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">2、保单形式:网上投保为您提供电子保单，根据《中华人民共和国民法典》第四百六十九条规定，数据电文是合法的合同表现形式，电子保单与纸质保单具有同等法律效力。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">3、发票形式:本产品仅提供电子发票，电子发票效力等同于纸质发票，报销时可将电子发票打印后使用。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">4、偿付能力告知:太平洋产险最近季度偿付能力符合监管要求，详情请参见我司官网（http://property.cpic.com.cn/）公开信息披露。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">5、风险综合评级:太平洋产险风险管理能力评级结果位居行业前列，详情请参见我司官网（http://property.cpic.com.cn/）公开信息披露。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">6、客户服务及投诉方式：本产品保险服务申请及投诉均可拨打太平洋产险全国统一客服电话95500，并根据语音提示操作；在线客服可关注“太平洋产险”微信公众号&gt;“优享汇”&gt;菜单&gt;“随身客服”栏目&gt;根据提示回复。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:24.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 12pt;">三、产品说明</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">1、投保人：</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">注册地在北京地区的</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">企业</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">2、被保险人：</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">注册地在北京地区的</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">企业</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">3、购买份数：</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">1份</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">4</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">、保险期限：</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">1年</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">5</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">、犹豫期：无</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">6</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">、特别约定：</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>1）赔偿限额</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">1）每次事故责任限额：以保单约定为准</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">2）每次事故每人死亡伤残责任限额：以保单约定为准</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">3）每次事故每人医疗费用责任限额（含紧急抢救费用）：以保单约定为准</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">4）每次事故及累计法律费用责任限额：以保单约定为准</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">5）24小时意外保险：每次事故每人死亡伤残责任限额：以保单约定为准，每次事故每人医疗费用责任限额（含紧急抢救费用）：以保单约定为准</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">6）住院津贴保险条款：以保单约定为准</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">7）24小时个人事故条款：每次事故每人死亡责任限额：以保单约定为准</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoBodyText"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>2）关于医疗费用免赔的特别约定</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">每人每次事故绝对免赔额为</font>RMB200元；24小时意外的医疗费用赔付比例为90%。如雇员因保险事故就诊发生的医疗费用从互助保险、除本保险外的其他商业保险、公益慈善机构、第三方责任人等途径获得了相关的医疗费用补偿，保险人同意对于其剩余的属于本保险合同约定范围内的必要合理的医疗费用不再设置免赔额，在相应责任限额内据实根据约定赔偿。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>3）关于第三方侵权赔偿的特别约定</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">兹经合同双方约定，在保险期间内，若雇员因履行工作职责受到暴力等意外伤害且应由相关责任方负责赔偿的，被保险人申请通过本保险合同赔偿的，保险人应按照本保险合同约定负责赔偿。涉及追偿的，保险合同双方参考基本险条款第三十</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">五</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">条执行。</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>4）关于法律费用赔偿的特别约定</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">兹经合同双方约定，发生可能引起本保险合同项下赔偿的情形时，被保险人被提起诉讼或仲裁时，对应由被保险人支付的法律费用包含诉讼费、鉴定费、评估费、律师费、仲裁费等相关合理费用。</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">被保险人支付法律费用前应告知保险人，需征得保险人同意。告知形式包括但不限于书面、邮件、微信、</font>QQ<font face="宋体">告知等。</font></span><b><span style="font-family: 宋体; font-size: 10.5pt;">被保险人支付的各项法律费用不得超出诉讼地政府主管部门或行业协会规定的收费标准或指导价格，如某项法律费用无政府主管部门或行业协会规定的收费标准或指导价格、或生效裁判中未确定应由被保险人承担的数额，则须事先经保险人同意。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><b><span style="font-family: 宋体; font-size: 10.5pt;">法律费用合计金额不得超过生效裁判中应由被保险人承担的金额，其中律师费不得超过诉讼所在地律师行业协会规定的收费标准。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoBodyText" style="margin-top:7.8500pt;margin-bottom:0.0000pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>5）关于雇员人数变动的特别约定</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">本保险合同仅对被保险人提供的投保雇员清单上的雇员承担赔偿责任。</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">在保险期间内，投保人可随时申报新增或减少雇员的名单。新增的雇员自投保人提交新增人员清单并按照日比例交纳对应保险费后次日予以承保；减少的雇员自离职之日开始取消承保，保险人按日比例退还对应保费，但已出险的雇员不退还保费。</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">（</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">6</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">）关于雇员的约定</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">本保险合同所称雇员是指与被保险人签订劳动合同或存在劳动关系（包括事实劳务关系）的各种用工形式、各种用工期限、各种工作岗位，接受被保险人给付的劳动报酬，且符合国家劳动法规定的合法劳动者，也包括退休返聘的人员或兼职人员、短期工、临时工、季节工和徒工、实习生。</span><b><span style="font-family: 宋体; font-size: 10.5pt;">人员工种风险不得高于保安。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">（</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">7</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">）关于明确工伤赔偿逻辑的约定</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">兹经双方约定，在保险期间内，雇员在中华人民共和国境内（为</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">本协议之目的，</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">不包括港澳台湾地区），因发生《工伤保险条例》中应当属于或者视同工伤的情形而导致人身损害，对于本保单项下的保险事故，被保险人有权选择向本保单或者工伤保险进行索赔；</span><b><span style="font-family: 宋体; font-size: 10.5pt;">若被保险人选择先向工伤保险索赔，不影响被保险人从本保险获得赔偿（医疗费用除外）。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">（</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">8</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">）附加宿舍责任条款</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">兹经双方同意并约定，本保险扩展承保被保险人的任何雇员在被保险人提供的宿舍内遭受意外伤害造成人身伤亡，被保险人依法应承担的赔偿责任。</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">本保险所载其他条件不变。</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">（</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">9</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">）附加</font>24<font face="宋体">小时个人意外事故条款</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">兹经双方同意并约定，本保险扩展承保被保险人的雇员在</font>24<font face="宋体">小时内遭受意外事故造成的永久性伤残和死亡。</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><b><span style="font-family: 宋体; font-size: 10.5pt;">对由于被保险人直接承担的因为被保险人的雇员从事的下列活动引起的责任，本保险不负责赔偿：打猎、登山、任何形式的竞赛、滑雪、酗酒、服用药物或狂欢。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">本保险单所载其他条件不变。</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">10</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">）本保险方案承保雇员年龄为</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">16-</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">60</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">周</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">岁，超出则不在赔偿范围。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoBodyText" style="margin-top:7.8500pt;margin-bottom:0.0000pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><b><span style="font-family: 宋体; font-size: 10.5pt;">（</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">11</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;">）如投保人在我司存在重复投保情况，我司仅以单张保单的赔偿限额为赔付上限，不累加赔付。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">（</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">12</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">）附加突发疾病身故条款（每人限额${pd.product_code eq "GZZRX-TB-1" ? 20 : pd.product_code eq "GZZRX-TB-2" ? 25 : pd.product_code eq "GZZRX-TB-3" ? 30 : pd.product_code eq "GZZRX-TB-4" ? 35 : 40 }万）</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">兹经双方同意并约定，主险合同中“在工作时间和工作岗位，突发疾病死亡或者在48小时之内经抢救无效死亡的”所导致的保险事故，保险人在保险单约定的每人突发疾病身故赔偿限额内赔偿。</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">本保险所载其他条件不变。</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoBodyText" style="margin-top:7.8500pt;margin-bottom:0.0000pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">（</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">13</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">）关于附加</font>24<font face="宋体">小时个人事故保险的约定</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">（可选）</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">兹经合同双方约定，本保险条款包含</font>24<font face="宋体">小时意外死亡和残疾以及突发急性病死亡保险一项保险责任，投保人只有投保了相应的附加险，保险人才承担对应的保险责任。其中：</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">24<font face="宋体">小时意外死亡和残疾保险指在保险期间内全天</font><font face="Calibri">24</font><font face="宋体">小时，而不论是否在工作期间，被保险人的雇员因意外事故而导致的死亡、残疾，保险人按照约定保险金额承担赔偿责任；</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">突发急性病死亡保险指在本合同保险期间内，被保险人的雇员因突发急性病，并自发作之时起</font>72<font face="宋体">小时内因该急性病导致其死亡的，保险人按照约定保险金额承担赔偿责任。</font></span><b><span style="font-family: 宋体; font-size: 10.5pt;">但雇员因既往疾病发作导致死亡的，不在保险责任范围内。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">【</span><b><span style="font-family: 宋体; font-size: 10.5pt;">急性病】是指雇员在保险生效之前未曾接受治疗或诊断、突然发生的、并且必须立即接受治疗方能避免身体或生命伤害的疾病，不包括既往疾病、慢性病、精神病、性传播疾病、遗传性疾病、先天性畸形、变形和染色体异常、怀孕、分娩、流产、药物过敏或其他医疗行为导致的伤害、因服用酒精饮料、毒品、镇静剂、安眠药或其他麻醉性物品所导致的精神疾病或意识不清所引发的疾病、牙齿治疗（但因意外伤害事故导致的必须进行的牙科门诊治疗不在此限）、预防性手术等非必须紧急治疗的手术、器官移植。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.1000pt;mso-char-indent-count:2.0000;layout-grid-mode:char;punctuation-trim:leading;text-autospace:ideograph-numeric;mso-pagination:widow-orphan;"><b><span style="font-family: 宋体; font-size: 10.5pt;"><font face="宋体">【既往疾病】指保险生效日前雇员已罹患的，已接受治疗、诊断、会诊或服用处方药物的疾病，或在保险生效日前经主治医生诊断或被医生推荐接受医药治疗或医疗意见的疾病。雇员发生</font>“高血压危象、高血压脑病、脑血管意外”时判断是否属于既往疾病除外责任的标准：若保险事故发生前<font face="Calibri">2</font><font face="宋体">年内无上述三种疾病发病就诊记录（含门诊和住院），即使雇员有高血压病史或就诊记录的均不属于患既往疾病，保险人对保险事故承担保险责任。</font></span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">7</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">、本产品所有页面文字描述为展示作用，具体保障方案等信息以投保后生成的保单为准，保险公司保留在法律规定范围内的解释权利。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:24.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 12pt;">四、服务流程</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">1、投保流程：在线投保——填写投保信息——核保通过并支付——查收保单。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">2、保费支付方式：本产品保费可通过微信、支付宝、银行卡、太保钱包支付。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">3、线上服务：本产品已实现在线投保、承保的线上服务。其他保险服务申请请拨打太平洋产险全国统一客服电话95500或至线下门店柜面办理。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">4、投保咨询：您可以拨打太平洋产险全国统一客服电话95500进行咨询或通过在线客服咨询。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">5、保单查询：投保完成30分钟后，您可拨打太平洋产险全国统一客服电话95500进行保单查询，也可以关注太平洋产险微信公众号或登录http://property.cpic.com.cn自助查询并验证。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">6、变更：若您需要批改保单，请投保人（仅限投保人）提供个人身份证件（身份证、护照等）/企业营业执照的扫描/拍照件，并填写太平洋产险客服发送的申请材料（需要投保人填写信息、签字确认后发送扫描/拍照件）后，我们在3个工作日内为您办理批改申请。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">7、退保：</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>1）请拨打太平洋产险全国统一客服电话：95500，转人工客服，或线下柜面进行办理。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>2）需要提供投保人身份证正反面照片/企业营业执照、银行卡照片，并填写太平洋产险客服发送的申请材料。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>3）保费退回方式：投保人银行卡（需要提供银行卡号、开户行信息）。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>4）保费退回时间：保费将于办理成功后30个工作日内，退还到投保人提供的本人银行账户。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">（</font>5）退保损失：保单载明保险期间的起始时间前申请退保，保险公司全额退还保险费；保单载明保险期间的起始时间后申请退保，按照所购买保险产品的保险合同条款规定办理，也许会造成您的一定损失。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">8、理赔流程：出险报案（太平洋产险全国统一客服电话：95500）——专业理赔指引——递交索赔材料——案件审核处理——赔款到账。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">9、争议处理：因履行本保险合同发生的争议，由当事人协商解决，协商不成的，提交保险单载明的仲裁机构仲裁；保险单未载明仲裁机构或争议发生后未达成仲裁协议的，依法向中华人民共和国（不含港、澳、台地区）法院起诉。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">10、司法管辖：与本保险合同有关的以及履行本保险合同产生的一切争议处理适用中华人民共和国（不含港、澳、台地区）法律。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">11、保单及发票送达：互联网途径销售的保险默认提供电子保单和电子发票，投保成功后我们将通过您预留的电子邮箱地址为您发送电子保单和电子发票。如需提供纸质电子保单打印件和电子发票打印件，请您联系太平洋产险全国统一客服电话95500，保险公司将核对一致后开具，发票抬头类型仅支持个人且默认为投保人。保险公司可另行提供快递服务，该项服务所产生的快递费，在签收邮件时由您自行承担。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:24.1000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 12pt;">五、重要事项</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">如您投保本产品，在投保本产品前您应履行相应的如实告知义务，具体如下：投保人或被保险人应如实填写投保信息，并就保险公司提出的询问据实告知，否则保险公司有权根据《中华人民共和国保险法》第十六条的规定处理：订立保险合同时，保险公司就保险标的或者被保险人的有关情况提出询问的，投保人应当如实告知。投保人故意或者因重大过失未履行前款规定的如实告知义务，足以影响保险公司决定是否同意承保或者提高保险费率的，保险公司有权解除合同。投保人故意不履行如实告知义务的，保险公司对于合同解除前发生的保险事故，不承担赔偿责任，并不退还保险费。投保人因重大过失未履行如实告知义务，对保险事故的发生有严重影响的，保险公司对于合同解除前发生的保险事故，不承担赔偿责任，但退还保险费。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">如您投保本产品，基于提供保险服务、提高服务质量的需要，您授权：本公司及本公司的合作机构在承保前后核实投保信息的真实性、调查获取被保险人与保险有关的相关信息</font>(包括但不限于健康情况、诊疗情况、既往病史等)，如本公司经前述核查发现您存在未如实告知情况的，本公司将依法解除保险合同；本公司向与具有必要合作关系的机构提供您的信息（包括但不限于投保、承保、理赔、医疗等）；本公司及本公司的合作机构可对您的信息进行合理使用，可通过知悉您信息的机构查询与您有关的全部信息。为确保信息安全，本公司及其本公司的合作机构应采取有效措施，并承担保密义务。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">在必要情形下第三方可能接触并使用您的个人信息，包括得到授权的太保产险员工、以及执行与我们的业务、营销活动和数据整理有关工作的其他公司或人员。所有此类人员及公司均需遵守相关保密协议，同时也需遵守国家关于个人信息保护有关法律法规，以确保您的个人信息随时得到保护。除上述用途外，太保产险不会将您的个人信息用于任何未经您同意的用途。除了我们的业务合作伙伴、我们的法律顾问、外部审计机构或按照法律规定、监管规定或法庭裁决之外，我们不会将所接受的任何个人信息泄露、篡改、毁损、出售或者提供给任何第三方。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><br clear="all" style="page-break-before:always"></span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="center" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:0.0000pt;mso-char-indent-count:0.0000;text-autospace:ideograph-numeric;mso-pagination:none;text-align:center;"><b><span style="font-family: 宋体; font-size: 14pt;">投保声明</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">1、本人已完整阅读并了解以上投保须知及投保险种的保险条款，尤其是对其中免除保险人责任的条款或约定（包括但不限于责任免除、免赔额、特别约定、投保人被保险人义务、保险金申请与给付、以粗体标注的内容等），本人已充分理解并接受上述内容，同意以此作为订立保险合同的依据。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">2、投保时，本投保人已就该产品的保障内容以及保险金额等向被保险人进行了明确说明，并征得其同意。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" align="center" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:0.0000pt;mso-char-indent-count:0.0000;text-autospace:ideograph-numeric;mso-pagination:none;text-align:center;"><b><span style="font-family: 宋体; font-size: 14pt;">投保提示</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">在确认投保本保险产品之前，请您务必审慎、仔细阅读并充分了解以上投保须知及理解本保险条款的全部内容，尤其是对其中免除保险人责任的条款或约定（包括但不限于责任免除、免赔额、特别约定、投保人被保险人义务、保险金申请与给付、以粗体标注的内容等），如果您不同意上述任何内容，或者无法准确理解本保险产品任何条款的含义，请不要进行确认及后续操作。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-indent:21.0000pt;mso-char-indent-count:2.0000;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span></p><p class="MsoNormal" align="center" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;text-align:center;"><b><span style="font-family: 宋体; font-size: 14pt;">理赔流程</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">出险报案（太平洋产险全国统一客服电话：</font>95500）——专业理赔指引——递交索赔材料——案件审核处理——赔款到账。</span><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p>'+starP);
        </c:if>
        $('#closeUMsg').text('已阅读、理解并完全接受');
        $('.contacts-bottom-oth span.sureoth').removeClass('sureoth_color');
        dingshi1(10);
    }
    function goBack(){
        history.go(-1);
    }
    function dingshi(isDo){
        if(isDo > 0){
            setTimeout(function() {
                isDo --;
                $('#closeUMsg').text('已阅读并同意('+isDo+')');
                dingshi(isDo);
            },1000);
        }else{
            $('#closeUMsg').text('已阅读并同意');
            $('.contacts-bottom-oth span.sureoth').addClass('sureoth_color');
            <c:if test="${fn:contains(pd.product_code,'GZZRX-QH')||fn:contains(pd.product_code,'GZZRX-TB')}">
            $('#closeUMsg').attr('onclick','closeUMsg1();');
            </c:if>
            <c:if test="${!fn:contains(pd.product_code,'GZZRX-QH')&&!fn:contains(pd.product_code,'GZZRX-TB')}">
            $('#closeUMsg').attr('onclick','closeUMsg();');
            </c:if>
        }
    }
    function dingshi1(isDo){
        if(isDo > 0){
            setTimeout(function() {
                isDo --;
                $('#closeUMsg').text('已阅读、理解并完全接受('+isDo+')');
                dingshi1(isDo);
            },1000);
        }else{
            $('#closeUMsg').text('已阅读、理解并完全接受');
            $('.contacts-bottom-oth span.sureoth').addClass('sureoth_color');
            $('#closeUMsg').attr('onclick','closeUMsg();');
        }
    }
    $(function () {
        // startRecording();
        //TODO 3记得还原为0
        if('${empty dto.oid ? '0' : '1'}' == '0'){
            <c:if test="${fn:contains(pd.source,'YT')}">
            var khgzs = '<div class="contacts_modal_oth" style="width: 820px;top: 120px;"><h2 class="contacts-title">确认进入投保流程</h2><div id="_bContent" style="margin: 20px;height: 450px;overflow: auto;"><p style="margin-top: 0;margin-bottom: 10px;">尊敬的客户:</p><p style="margin-top: 0;margin-bottom: 10px;">&nbsp;&nbsp;&nbsp;您即将进入投保流程，请仔细阅读保险条款。本保险产品由【${pd.insurance_name}】承保，由上海亚太保险经纪有限公司提供销售和协助理赔等保险服务。</p><p style="margin-top: 0;margin-bottom: 10px;">投保前请您阅读名户告知书</p><p style="margin-top: 0;margin-bottom: 10px;">点击“已阅读并同意”，您在销售页面的操作将被依法记录和候存。</p><div style="width: 780px;height: 250px;overflow-y: scroll;" id="khgzs"><img style="width: 775px" src="/resources/images/客户告知书-亚太保险经纪（盖章件）.png"> </div></div><div class="contacts-bottom-oth"><span id="closeUMsg" class="sureoth">已阅读并同意(10)</span>&nbsp;<span onclick="history.go(-1)">返回</span></div></div><div class="black-mask-oth"></div>';
            </c:if>
            <c:if test="${fn:contains(pd.source,'ZJ')}">
            var khgzs = '<div class="contacts_modal_oth" style="width: 820px;top: 120px;"><h2 class="contacts-title">确认进入投保流程</h2><div id="_bContent" style="margin: 20px;height: 450px;overflow: auto;"><p style="margin-top: 0;margin-bottom: 10px;">尊敬的客户:</p><p style="margin-top: 0;margin-bottom: 10px;">&nbsp;&nbsp;&nbsp;您即将进入投保流程，请仔细阅读保险条款。本保险产品由【${pd.insurance_name}】承保，由中佳保险代理有限公司提供销售和协助理赔等保险服务。</p><p style="margin-top: 0;margin-bottom: 10px;">投保前请您阅读名户告知书</p><p style="margin-top: 0;margin-bottom: 10px;">点击“已阅读并同意”，您在销售页面的操作将被依法记录和候存。</p><div style="width: 780px;height: 250px;overflow-y: scroll;" id="khgzs"><img style="width: 775px" src="/resources/images/客户告知书-中佳保险代理（盖章件）.png"> </div></div><div class="contacts-bottom-oth"><span id="closeUMsg" class="sureoth">已阅读并同意(10)</span>&nbsp;<span onclick="history.go(-1)">返回</span></div></div><div class="black-mask-oth"></div>';
            </c:if>
            $('body').append(khgzs);
            $('.contacts_modal_oth').show();
            $('.black-mask-oth').show();
            dingshi(10);
        }
        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas({sys_client_user_id: '${userdetail.oid}'},'/pc/commonApplicant/company/query',false,false,function(json){
            var str = "";
            if (json.length > 0){
                for (var i = 0; i < json.length; i++) {
                    str += '<li><p data-text="' + JSON.stringify(json[i]).replace(/"/ig,'\'') + '">' + json[i].company_name + '</p></li>';
                }
            }
            if(str != ""){
                var lxr_html = '<div class="contacts_modal"><h2 class="contacts-title">选择常用投保人<span class="title-cancel"><i class="glyphicon glyphicon-remove"></i></span></h2><ul id="userList"></ul><div class="contacts-bottom"><span class="sure">填入</span>&nbsp;<span class="cancel">取消</span></div></div><div class="black-mask"></div>';
                $('body').append(lxr_html);
                $("#userList").html(str);
                addCylxr();
            }
        });

        function addCylxr(){
            //点击联系人
            $('.contacts_modal ul li').click(function () {
                $('.contacts_modal ul li').removeClass('active');
                $(this).addClass('active');
                if(!$('.contacts-bottom .sure').hasClass('sure_color')){
                    $('.contacts-bottom span.sure').addClass('sure_color');
                }
            });
            //点击取消
            $('.contacts-bottom .cancel').click(function () {
                $('.contacts_modal').hide();
                $('.black-mask').hide();
                $('.contacts_modal ul li').removeClass('active');
            });
            $('.contacts_modal .title-cancel').click(function () {
                $('.contacts_modal').hide();
                $('.black-mask').hide();
                $('.contacts_modal ul li').removeClass('active');
            });
            //点击填入
            $('.contacts-bottom .sure').click(function () {
                if($(this).hasClass('sure_color')){
                    setTBR($('.contacts_modal ul li.active').find('p').attr('data-text'));
                    $('.contacts_modal').hide();
                    $('.black-mask').hide();
                    $('.contacts_modal ul li').removeClass('active');
                }else{
                    //没有点击选择联系人
                    // alert('请选择一个联系人！');
                }
            })
            var _html = '投保人信息<a href="javascript:;" style="float: right;margin-right: 16px" onclick="showContractsModals()">选择常用投保人</a>';
            $("#cy_lxr").html(_html);
        }
        function setTBR(_json){
            var json = eval("(" + _json + ")");
            $("#role_namecn_0").val(json.company_name);//企业名称
            $("#role_idType_0").val(json.certificate_type);//证件类型
            if(json.certificate_code != ''){
                var cccode = json.certificate_code;
                if(json.certificate_type == '1'){
                    cccode = json.certificate_code.substring(0,json.certificate_code.length-1)+'-'+json.certificate_code.substring(json.certificate_code.length-1,json.certificate_code.length);
                }
                $("#role_organizationCode_0").val(cccode);//证件号码
            }
            $("#role_comNature_0").val(json.enterprise_type_one);//营业性质
            $("#role_comNature_0").change();
            $("#role_natureTwo_0").val(json.enterprise_type_two);//
            $("#role_linkName_0").val(json.user_name);//联系人
            $("#role_linkTel_0").val(json.telephone);//手机
            $("#role_linkEmail_0").val(json.email);//邮箱
            //TODO 可能会报错的点
            var boo = ${fn:contains(pd.product_code,'GZZRX-CA')};
            if(boo && '430000' != json.province){
                return ;
            }
            $("#role_regAddress_0").val(json.address);//详细地址
            $("#regProvince").val(json.province);//省
            $("#regProvince").change();
            setTimeout(function(){
                $("#regCity").val(json.city);//市
                $("#regCity").change();
                setTimeout(function(){
                    $("#regDistrict").val(json.district);//区
                },1000);
            },1000);
        }

        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas('','/pc/tb-mail-address/${userdetail.oid}',false,false,function(json){
            if(json != undefined && json != null){
                if('${dto.oid}' == ''){
                    $('#need_insur_bill').on('click',function(){//纸质保单
                        if($(this).is(":checked")){
                            $("#receiverName").val(json.user_name);
                            $("#receiverMobile").val(json.telephone);
                            $("#receiverAddressDetail").val(json.address);
                        }
                    });
                    $('#need_receipt').on('click',function(){//发票
                        if($(this).is(":checked")){
                            $("#takerName").val(json.user_name);
                            $("#takerMobile").val(json.telephone);
                            $("#takerAddressDetail").val(json.address);
                        }
                    });
                    $('#is_send_einvoice').on('click',function(){//电子发票
                        if($(this).is(":checked")){
                            $("#takerName").val(json.user_name);
                            $("#takerMobile").val(json.telephone);
                            $("#takerAddressDetail").val(json.address);
                        }
                    });
                }
            }

        });
        document.onmousedown = function(ev){
            ev = ev || window.event;
            var nr = '已阅读并同意 已阅读、理解并完全接受 roleSubjectList[0].reg_address roleSubjectList[1].reg_address inception_date check_007_for roleSubjectList[0].bank_account mailPolicyVo.taxpayer_number_invoice 暂存本页 下一步 ';
            var x=ev.clientX;
            var y=ev.clientY;
            if((ev.target.childNodes.length > 0 && ev.target.childNodes[0]!=undefined && nr.indexOf(ev.target.childNodes[0].data)!=-1) || (ev.target.name != '' && nr.indexOf(ev.target.name)!=-1) || (ev.target.id != '' && ev.target.id!=undefined && nr.indexOf(ev.target.id)!=-1 )){
                insOperation('${dto.oid}','${dto.trade_serial_number}','投保信息提交');
            }
        }
    })

    //点击弹窗出现
    function showContractsModals() {
        $('.contacts_modal').show();
        $('.black-mask').show();
    }
    //点击可选保障
    $('.optional_guarantee span').click(function () {
        $('#is_contain_repo').val($(this).attr('data-val'));
        $('.optional_guarantee span').removeClass('active');
        $(this).addClass('active');
        computationalCosts();
    })

</script>

<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';
    function openImgView(img_url){
        top.layer.open({
            type: 1,
            skin: 'layui-layer-rim', //加上边框
            area: ['420px', '350px'], //宽高
            content: '<div><img src='+baseUrl+img_url+' width="100%" /></div>'
        });
    }
    var count = 2;
    $(function(){
        changeFrameSet(0,'');
        if($("#need_insur_bill").is(':checked')){
            $("#mod_1").fadeIn(1000);
        }else{
            $("#mod_1").fadeOut(1000);
        }//
        if($("#need_receipt").is(':checked')){
            var _invoice_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
            $("#mod_2").fadeIn(1000);
            if(_invoice_val == "0"){//普通发票
                $("#mod_2_1").fadeOut(1000);
            }else{//专用发票,VATINVOICE
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
            }
        }else if($("#is_send_einvoice").is(':checked')){
            // $('#invoice_type_2').parent().parent().hide();//隐藏增值税选项
            $("#mod_2").fadeIn(1000);
            $("#mod_2_1").fadeOut(1000);
        }else{
            $("#mod_2").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2_2").fadeOut(1000);
            $("#mod_2_3").fadeOut(1000);
        }
        computationalCosts();
    });
    var countdown=5;
    function submitMsg(num){
        if(!customsVerify()){
            return;
        }
        var _htm = '<div>针对本产品从事武装押运保安人员（如：金融守押员，保镖）的保障方案为：</div><br/>';
        var _num = Number(num);
        if(_num == 1){
            _htm = _htm + '<div><span>意外身故/残疾</span><span>7万</span></div><br/>' +
                '<div><span>意外医疗</span><span>7000</span></div><br/>';
        }else if(_num == 2){
            _htm = _htm + '<div><span>意外身故/残疾</span><span>15万</span></div><br/>' +
                '<div><span>意外医疗</span><span>1.5万</span></div><br/>' +
                '<div><span>意外住院津贴</span><span>50元/天</span></div>';
        }else if(_num == 3){
            _htm = _htm + '<div><span>意外身故/残疾</span><span>20万</span></div><br/>' +
                '<div><span>意外医疗</span><span>2万</span></div><br/>' +
                '<div><span>意外住院津贴</span><span>50元/天</span></div>';
        }else if(_num == 4){
            _htm = _htm + '<div><span>意外身故/残疾</span><span>30万</span></div><br/>' +
                '<div><span>意外医疗</span><span>3万</span></div><br/>' +
                '<div><span>意外住院津贴</span><span>50元/天</span></div>';
        }else if(_num == 5){
            _htm = _htm + '<div><span>意外身故/残疾</span><span>35万</span></div><br/>' +
                '<div><span>意外医疗</span><span>3.5万</span></div><br/>' +
                '<div><span>意外住院津贴</span><span>100元/天</span></div>';
        }else if(_num == 6){
            _htm = _htm + '<div><span>意外身故/残疾</span><span>40万</span></div><br/>' +
                '<div><span>意外医疗</span><span>4万</span></div><br/>' +
                '<div><span>意外住院津贴</span><span>150元/天</span></div>';
        }
        if(win_sign == 0) {//本站内嵌
            parent.layer.confirm(_htm, {
                btn: ['已知悉（5）','再看看'], //按钮
                title:'特别提示'
            }, function(){
                parent.layer.closeAll();
                save_policy_gzzrx();
            }, function(){

            });
            parent.$('.layui-layer-btn0').attr('style','border-color: #dedede;background-color: #f1f1f1;color: #333;');
            parent.$('.layui-layer-btn').css("position",'relative');
            parent.$('.layui-layer-btn0').before("<div id='layui-layer-btn0' style='width: 110.22px;height: 32px;position: absolute;left: 148px;z-index: 9;opacity: 0;'></div>");
            sendemail_p();
        }else{
            layer.confirm(_htm, {
                btn: ['已知悉（5）','再看看'], //按钮
                title:'特别提示'
            }, function(){
                save_policy_gzzrx();
            }, function(){

            });
            $('.layui-layer-btn0').attr('style','border-color: #dedede;background-color: #f1f1f1;color: #333;');
            $('.layui-layer-btn').css("position",'relative');
            $('.layui-layer-btn0').before("<div id='layui-layer-btn0' style='width: 110.22px;height: 32px;position: absolute;left: 148px;z-index: 9;opacity: 0;'></div>");
            sendemail_c();
        }

    }

    function sendemail_p() {
        if (countdown == 0) {
            parent.$('#layui-layer-btn0').remove();
            parent.$('.layui-layer-btn0').attr('style','border-color: #4898d5;background-color: #2e8ded;color: #fff;');
            countdown = 5;
            return;
        } else {
            countdown--;
            if(countdown == 0){
                parent.$('.layui-layer-btn0').html('已知悉');
            }else{
                parent.$('.layui-layer-btn0').html('已知悉（'+countdown+'）');
            }
        }
        setTimeout(function() {
                sendemail_p()
            }
            ,1000)
    };
    function sendemail_c() {
        if (countdown == 0) {
            $('#layui-layer-btn0').remove();
            $('.layui-layer-btn0').attr('style','border-color: #4898d5;background-color: #2e8ded;color: #fff;');
            countdown = 5;
            return;
        } else {
            countdown--;
            if(countdown == 0){
                $('.layui-layer-btn0').html('已知悉');
            }else{
                $('.layui-layer-btn0').html('已知悉（'+countdown+'）');
            }
        }
        setTimeout(function() {
                sendemail_c()
            }
            ,1000)
    };
    var win_sign = 0;//0本站内嵌，1它站内嵌
    <c:if test="${fn:contains(userdetail.web_type, 'ARS')||fn:contains(userdetail.web_type, 'SAAS')||fn:contains(userdetail.web_type, 'PASP')}">
    win_sign = 1;
    </c:if>
    function save_policy_gzzrx(){
        computationalCosts();
        //index是遮罩层，layer.load弹出层
        var index = laySomenType(0,null,'',0);
        if(!mailVerify()){//判断投保人与发票信息一致
            //关闭遮罩
            laySomenType(2,index,'',0);
            return ;
        }
        //如果校验没问题
        if(customsVerify()){
            $.ajax({
                type: 'POST',
                //ajax动态调用pendingGMRPolicyVoPolicy方法，都会保存订单
                url:baseUrl + '/insurance/gzzrx/policy/pendingSpecialHirelingVoPolicy?ACCESS_TOKEN=${ACCESS_TOKEN}',
                //表单所有信息
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    //保存订单信息成功状态码
                    if(json.statusCode == '200') {
                        insOperation(json.navTabId,'${dto.trade_serial_number}','投保信息提交');
                        //关闭遮罩
                        laySomenType(2,index,'',0);
                        window.location.href = baseUrl + '/insurance/gzzrx/policy/confirmPage/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                        /*var _t = setInterval(function () {
                            if(_tong==1){
                                clearInterval(_t);
                                //关闭遮罩
                                laySomenType(2,index,'',0);
                                window.location.href = baseUrl + '/insurance/gzzrx/policy/confirmPage/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                            }
                        },300);*/
                    }else{
                        if(json.message.indexOf('部分证件号已在保，无法重复投保：')!=-1){
                            laySomenType(1,null,"部分证件号已在保，无法重复投保!",0);
                            var reg = new RegExp(',','g');
                            var blob = new Blob(['(注：以下证件号已在保，请检查并剔除后重新提交。)\n'+json.message.split('：')[1].replace(reg,'\n')], {type: "text/plain;charset=utf-8"});
                            saveAs(blob, "人员重复投保清单.txt");
                        }else{
                            laySomenType(1,null,json.message,0);
                        }
                        //关闭遮罩
                        laySomenType(2,index,'',0);
                    }
                },
                //返回错误
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    //关闭遮罩
                    laySomenType(2,index,'',0);
                    //返回错误信息在遮罩层上
                    laySomenType(1,null,textStatus,0);
                }
            });
        }else{
            //关闭遮罩
            laySomenType(2,index,'',0);
        }
    }

    function mailVerify(){
        var taxpayerNumberInvoice = $('#taxpayerNumberInvoice').val();
        if(taxpayerNumberInvoice == ''){
            taxpayerNumberInvoice = $('#taxpayerNumberInvoice_1').val();
        }
        if(taxpayerNumberInvoice == ''){
            laySomenType(1,null,"请完善发票信息！",0);
            return false;
        }
        <c:if test="${fn:contains(pd.product_code,'GZZRX-CA')}">
        var role_namecn_0 = $('#role_namecn_0').val();
        var role_organizationCode_0 = $('#role_organizationCode_0').val();
        var receipt_head = $('#receipt_head').val();
        if(receipt_head != ''){
            if(receipt_head!=role_namecn_0||taxpayerNumberInvoice!=role_organizationCode_0){
                laySomenType(1,null,"发票信息必须与投保人信息一致！",0);
                return false;
            }
        }
        </c:if>
        return true;
    }

    function customsVerify(){
        var flag = true;
        $("input[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Date Required"){
                    if(this.id.indexOf( 'check_00' ) > -1 &&!$(this).is(':checked')){
                        document.getElementById(this.id+'_for').scrollIntoView();
                        laySomenType(1,null,"有确认项未完成确认！",0);
                        $(this).focus();
                        flag = false;
                        return true;
                    }
                    if($(this).val() == ''){
                        document.getElementById(this.id).scrollIntoView();
                        laySomenType(1,null,"必填项不能为空！",0);
                        $(this).focus();
                        flag = false;
                        return true;
                    }else{
                        if($(this).val().length>40){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"长度超出限制！",0);
                            $(this).focus();
                            flag = false;
                            return true;
                        }else{
                            var _val = $(this).val();
                            var _id = this.id;
                            if(_id == 'role_doBusinessAddress_0'||_id == 'role_regAddress_0'||_id == 'role_doBusinessAddress_1'||_id == 'role_regAddress_1'){
                                if(_val.length<8||_val.length>60){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"内容长度不能少于8位！",0);
                                    $(this).focus();
                                    flag = false;
                                    return true;
                                }
                            }
                            if(_id.indexOf('hire_birth_date')!=-1){
                                var _idVal = $(this).attr("GIST-ID");
                                var _gistVal = $("#"+_idVal).val();
                                if(_gistVal == ""){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"证件号码不能为空！",0);
                                    $(this).focus();
                                    flag = false;
                                    return true;
                                }else{
                                    var _idTy = $("#"+_idVal).attr("GIST-ID");
                                    var _gistTy = $("#"+_idTy).val();
                                    if(_gistTy == "0"){
                                        if(_val != getBirthdayFromIDNo(_gistVal)){
                                            document.getElementById(this.id).scrollIntoView();
                                            laySomenType(1,null,"该日期与身份证不匹配！",0);
                                            $(this).val('');
                                            $(this).focus();
                                            flag = false;
                                            return true;
                                        }
                                    }
                                    var age_b = Number(getbirthDayByAge(_val));
                                    if(age_b<16||age_b>65){
                                        document.getElementById(this.id).scrollIntoView();
                                        laySomenType(1,null,"被保险人年龄(16-60周岁)超出限制！",0);
                                        $(this).val('');
                                        $(this).focus();
                                        flag = false;
                                        return true;
                                    }
                                }
                            }
                        }
                    }

                }
            }
            if(dataVal == "FILE Required"){//FILE Required
                if($(this).val() == ''){
                    document.getElementById(this.id+'_file-5').scrollIntoView();
                    laySomenType(1,null,"上传文件不能为空！",0);
                    $(this).focus();
                    flag = false;
                    return true;
                }
            }
        });
        if(flag){
            $("input[Data-Val]").each(function() {
                var dataVal = $(this).attr("Data-Val");
                if ($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden") {
                    if (dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Date Required") {
                        $(this).blur();
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"请正确填写相关信息！",0);
                            flag = false;
                            return true;
                        }else{
                            if(this.id == 'inceptionDate'){
                                if(Gdate.getDaysDiff($(this).val(), Gdate.curtime())<=0){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"起保日期必须大于今天！",0);
                                    flag = false;
                                    return true;
                                }
                            }
                        }
                    }
                }
            });
            /*if(!flag){
                laySomenType(1,null,"请正确填写相关信息！",0);
            }*/
        }
        if(flag){
            $("select[Data-Val]").each(function(){
                var dataVal = $(this).attr("Data-Val");
                if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                    if(dataVal == "Required"){
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"必填项不能为空！",0);
                            $(this).focus();
                            flag = false;
                            return true;
                        }else{
                            var _val = $(this).val();
                            var _id = this.id;
                            if(_id.indexOf('hire_sex')!=-1){
                                var _idVal = $(this).attr("GIST-ID");
                                var _gistVal = $("#"+_idVal).val();
                                if(_gistVal == ""){
                                    document.getElementById(_id).scrollIntoView();
                                    laySomenType(1,null,"请先完善证件号码！",0);
                                    $(this).val('');
                                    $(this).focus();
                                    flag = false;
                                    return true;
                                }else{
                                    var _idTy = $("#"+_idVal).attr("GIST-ID");
                                    var _gistTy = $("#"+_idTy).val();
                                    if(_gistTy == "0"){
                                        var _sex = "M";
                                        if($(this).val() == "2"){
                                            _sex = "F";
                                        }
                                        if( _sex != getSexFromIDNo(_gistVal)){
                                            document.getElementById(_id).scrollIntoView();
                                            laySomenType(1,null,"该性别与身份证不匹配！",0);
                                            $(this).val('');
                                            $(this).focus();
                                            flag = false;
                                            return true;
                                        }
                                    }
                                }
                            }
                        }

                    }
                }
            });
            if(flag){
                $("textarea[Data-Val]").each(function(){
                    var dataVal = $(this).attr("Data-Val");
                    if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                        if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                            if($(this).val() == ''){
                                document.getElementById(this.id).scrollIntoView();
                                laySomenType(1,null,"必填项不能为空！",0);
                                $(this).focus();
                                flag = false;
                                return true;
                            }else{
                                if($(this).val().length>100){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"长度超出限制(100字符)！",0);
                                    $(this).focus();
                                    flag = false;
                                    return true;
                                }
                            }

                        }
                    }
                });

            }
        }
        //TODO 设置选择开具发票必填？
        //...
        mailSet();
        return flag;
    }
    function createSH(_val,_id){
        if(_val == '7'){
            $("#"+_id).show();
        }else{
            $("#"+_id).hide();
        }
    }

    //职业可选的时候的方法
    function doDIVMOD(obj, sign, status, vals){
        /*.replace('table-row ','')*/
        var num = Number($(".mSign tr").last().attr("class").split("_")[2]);
        var vls = Number(vals);
        var g = 0;
        $("tr").each(function(){
            var _cla = $(this).attr("class");
            if(_cla != undefined){
                if(_cla.indexOf("hire_num_")!= -1){
                    g++;
                }
            }
        });
        if("add" == status){
            var ns = num+1;
            var nodes = $("."+sign+"_num_"+num).clone(true);
            nodes.attr("class",nodes.attr("class").replace("_"+num, "_"+ns));
            nodes.find("td").each(function(){
                var _class = $(this).attr("class");
                if(_class.indexOf("signIndex") !=-1){
                    $(this).html(Number($(this).html())+1);
                }
                _class = _class.replace("has-success", "");
                _class = _class.replace("has-loser", "");
                $(this).attr("class",_class);
            });
            nodes.find("input").each(function(){
                var _id = $(this).attr("id");
                var _name = $(this).attr("name");
                var _gistID = $(this).attr("GIST-ID");
                if(_gistID != undefined && _gistID != ''){
                    $(this).attr("GIST-ID",_gistID.replace("_"+num, "_"+ns));
                }
                if(_id.indexOf("hire_career") == -1){
                    $(this).val('');
                }
                $(this).attr("id",_id.replace("_"+num, "_"+ns));
                $(this).attr("name",_name.replace("["+num+"]", "["+ns+"]"));
                var _onclick = $(this).attr("onclick");
                if(_onclick != ''&&_onclick != undefined){
                    $(this).attr("onclick",_onclick.replace("_"+num, "_"+ns));
                }
            });
            nodes.find("select").each(function(){
                var _id = $(this).attr("id");
                var _name = $(this).attr("name");
                $(this).find('option').first().prop("selected", 'selected');
                $(this).attr("id",_id.replace("_"+num, "_"+ns));
                $(this).attr("name",_name.replace("["+num+"]", "["+ns+"]"));
                var _gistID = $(this).attr("GIST-ID");
                if(_gistID != undefined && _gistID != ''){
                    $(this).attr("GIST-ID",_gistID.replace("_"+num, "_"+ns));
                }
            });
            nodes.find("a").each(function(){
                $(this).attr("onclick","deleteThisRow('hire_num_"+ns+"','"+vls+"','add-a-line')");
            });
            $("."+sign+"_num_"+num).after(nodes);
            if((g+1) == vls){
                $(obj).fadeOut(1000);
            }else if(g>1){
                $(obj).next().fadeIn(1000);
            }
            var doNum = Number($("#"+sign+"_num").val())+1;
            $("#"+sign+"_num").val(doNum);
            computationalCosts();
        }
        changeFrameSet(0,'');//加载当前内容高度并重置iframe
    }
    function saveGZZRXInfo(){
        computationalCosts();
        mailSet();
        if(isAllNull() == 1){
            var index = laySomenType(0,null,'',0);
            $.ajax({
                type: 'POST',
                url:baseUrl + '/insurance/gzzrx/policy/pendingSpecialHirelingVoPolicy',
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    laySomenType(1,null,json.message,2000);
                    if(json.statusCode == '200') {
                        insOperation(json.navTabId,'${dto.trade_serial_number}','投保信息提交');
                        laySomenType(2,index,'',0);
                        window.location.href = baseUrl + '/insurance/gzzrx/policy/policy/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                        /*var _t = setInterval(function () {
                            if(_tong==1){
                                clearInterval(_t);
                                laySomenType(2,index,'',0);
                                window.location.href = baseUrl + '/insurance/gzzrx/policy/policy/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                            }
                        },300);*/
                    }else{
                        laySomenType(2,index,'',0);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    laySomenType(2,index,'',0);
                    laySomenType(1,null,textStatus,0);
                }
            });
        }else{
            laySomenType(1,null,"表单未检索到数据，请完善信息后暂存！",0);
        }
    }
    function mailSet(){
        var invoice_type_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
        if(invoice_type_val == "0"){
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
            $("#mod_2_3").find("select").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_insur_bill").is(':checked')){
            $("#mod_1").find("input").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_receipt").is(':checked')&&!$("#is_send_einvoice").is(':checked')){
            $("#mod_2_2").find("input").each(function(){
                $(this).val('');
            });
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
        }
    }
    function isAllNull(){
        var values, index;
        values = $("#policyInfoForm").serializeArray();
        for (index = 0; index < values.length; ++index){
            var controls=document.getElementsByName(values[index].name);
            for(var i=0;i<controls.length;i++){
                if (!$("#"+controls[i].id).is(":hidden")&&values[index].value !=''){
                    return 1;//可见输入框存在至少一个框有填数据，暂存校验通过
                }
            }
        }
        return 0;//可见输入框不存在至少一个已填数据的框，暂存校验不通过
    }
    function isNeedDate(_this,starID,endID){
        if($(_this).val() == "1"){
            $("#"+starID).parent().show();
            $("#"+endID).parent().show();
            $("#"+starID).attr('data-status','');
            $("#"+endID).attr('data-status','');
        }else{
            $("#"+starID).parent().hide();
            $("#"+endID).parent().hide();
            $("#"+starID).attr("value"," ");
            $("#"+endID).attr("value"," ");
            $("#"+starID).attr('data-status','hidden');
            $("#"+endID).attr('data-status','hidden');
        }
    }
    function initID_Date(){
        var idOption = '${vo.roleSubjectList[0].id_option}';
        if(idOption == "1"){
            $("#role_idStarDate_0").parent().show();
            $("#role_idEndDate_0").parent().show();
        }
        var idOption1 = '${vo.roleSubjectList[1].id_option}';
        if(idOption1 == "1"){
            $("#role_idStarDate_1").parent().show();
            $("#role_idEndDate_1").parent().show();
        }
    }
    $(function(){
       initID_Date();
        $('[data-toggle="tooltip"]').tooltip();
        $("input[id=need_insur_bill]").on("click",function(){
            if($(this).is(':checked')){
                $("#mod_1").fadeIn(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
            }else{
                $("#mod_1").fadeOut(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                    $(this).val('');
                });
            }
            setTimeout(changeFrameSet(0,''),1050);//加载当前内容高度并重置iframe
        });
        $("input[id=need_receipt]").on("click",function(){
            $('#invoice_type_2').parent().parent().show();//显示增值税选项
            $("#is_send_einvoice").attr("checked",false);
            $("input[name='mailPolicyVo.is_send_einvoice']").val('0');
            if($(this).is(':checked')){
                $("#mod_2").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("input[name='mailPolicyVo.need_receipt']").val('1');
            }else{
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_2").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2").fadeOut(1000);
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("input[name='mailPolicyVo.need_receipt']").val('');
            }
            setTimeout(changeFrameSet(0,''),1050);//加载当前内容高度并重置iframe
        });

        $("input[id=is_send_einvoice]").on("click",function(){
            $("#need_receipt").attr("checked",false);//纸质发票不选中
            $("input[name='mailPolicyVo.need_receipt']").val('');
            if($(this).is(':checked')){
                $('#invoice_type_1').click();
                // $('#invoice_type_2').parent().parent().hide();//隐藏增值税选项
                $("#mod_2").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                mailSet();
                $("input[name='mailPolicyVo.is_send_einvoice']").val('1');
            }else{

                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_2").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2").fadeOut(1000);
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $('#invoice_type_2').parent().parent().show();//显示增值税选项
                $("input[name='mailPolicyVo.is_send_einvoice']").val('0');
            }
            setTimeout(changeFrameSet(0,''),1050);//加载当前内容高度并重置iframe
        });

        $("input[name='mailPolicyVo.invoice_type']").on("click",function(){
            if($(this).val() == "1"){
                $("#taxpayerNumberInvoice_1").parent().hide();
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#taxpayerNumberInvoice_1").attr("data-status","hidden");
            }else{
                $("#taxpayerNumberInvoice_1").parent().show();
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#taxpayerNumberInvoice_1").attr("data-status","");
            }
            setTimeout(changeFrameSet(0,''),1050);//加载当前内容高度并重置iframe
        });
        initCheck();
    });

    function initCheck(){
        $("input[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if(dataVal == "Required"){
                var _class = $(this).attr("class");
                if(_class.indexOf('laydate-icon')!=-1){
                    $(this).on("change",function(){
                        var _val = $(this).val();
                        var _id = this.id;
                        if(_id.indexOf('hire_birth_date')!=-1){
                            var _idVal = $(this).attr("GIST-ID");
                            var _gistVal = $("#"+_idVal).val();
                            if(_gistVal == ""){
                                laySomenType(1,null,"请先完善证件号码！",0);
                                loser_has_ins(this);
                                $(this).val('');
                            }else{
                                var _idTy = $("#"+_idVal).attr("GIST-ID");
                                var _gistTy = $("#"+_idTy).val();
                                if(_gistTy == "0"){
                                    if(_val != getBirthdayFromIDNo(_gistVal)){
                                        laySomenType(1,null,"该日期与身份证不匹配！",0);
                                        loser_has_ins(this);
                                        $(this).val('');
                                    }else{
                                        success_has_ins(this);
                                    }
                                }else{
                                    var age_b = Number(getbirthDayByAge(_idVal));
                                    if(age_b<16||age_b>65){
                                        laySomenType(1,null,"被保险人年龄(16-60周岁)超出限制！",0);
                                        loser_has_ins(this);
                                        $(this).val('');
                                    }else{
                                        success_has_ins(this);
                                    }
                                }
                            }
                        }
                    });
                }else{
                    $(this).on("blur",function(){
                        var _val = $(this).val();
                        var _id = this.id;
                        if(_val == ''){
//                        被保险人信息的6个输入框匹配id字段
                            var patt1 = new RegExp("hire_name_");
                            var patt3 = new RegExp("hire_id_card_");
                            var patt6 = new RegExp("hire_mobile_");
                            if(_id == 'role_namecn_0'){
                                laySomenType(1,null," 投保单位名称不能为空！",0);
                            } else if(_id == 'role_organizationCode_0'){
                                laySomenType(1,null," 证件号码不能为空！",0);
                            } else if(_id == 'role_totalEmp_0'){
                                laySomenType(1,null," 企业总人数不能为空！",0);
                            } else if(_id == 'role_doBusinessAddress_0'){
                                laySomenType(1,null," 办公地址不能为空！",0);
                            } else if(_id == 'role_phone_0'){
                                laySomenType(1,null," 办公电话不能为空！",0);
                            } else if(_id == 'role_linkName_0'){
                                laySomenType(1,null," 联系人姓名不能为空！",0);
                            } else if(_id == 'role_linkTel_0'){
                                laySomenType(1,null," 联系人手机不能为空！",0);
                            } else if(_id == 'role_linkEmail_0'){
                                laySomenType(1,null," 联系人email不能为空！",0);
                            } else if(_id == 'role_zipCode_0'){
                                laySomenType(1,null," 邮政编码不能为空！",0);
                            } else if(_id == 'role_regAddress_0'){
                                laySomenType(1,null," 注册详细地址不能为空！",0);
                            } else if(_id == 'role_namecn_1'){
                                laySomenType(1,null," 投保单位名称不能为空！",0);
                            } else if(_id == 'role_organizationCode_1'){
                                laySomenType(1,null," 证件号码不能为空！",0);
                            } else if(_id == 'role_totalEmp_1'){
                                laySomenType(1,null," 企业总人数不能为空！",0);
                            } else if(_id == 'role_doBusinessAddress_1'){
                                laySomenType(1,null," 办公地址不能为空！",0);
                            } else if(_id == 'role_phone_1'){
                                laySomenType(1,null," 办公电话不能为空！",0);
                            } else if(_id == 'role_linkName_1'){
                                laySomenType(1,null," 联系人姓名不能为空！",0);
                            } else if(_id == 'role_linkTel_1'){
                                laySomenType(1,null," 联系人手机不能为空！",0);
                            } else if(_id == 'role_linkEmail_1'){
                                laySomenType(1,null," 联系人email不能为空！",0);
                            } else if(_id == 'role_zipCode_1'){
                                laySomenType(1,null," 邮政编码不能为空！",0);
                            } else if(_id == 'role_regAddress_1'){
                                laySomenType(1,null," 注册详细地址不能为空！",0);
                            } else if(_id == 'receiptHead'){
                                laySomenType(1,null," 单位名称不能为空！",0);
                            } else if(_id == 'takerName'){
                                laySomenType(1,null," 收票人姓名不能为空！",0);
                            } else if(_id == 'takerMobile'){
                                laySomenType(1,null," 收票人手机不能为空！",0);
                            } else if(_id == 'takerAddressDetail'){
                                laySomenType(1,null," 收票人地址不能为空！",0);
                            } else if(_id == 'receiverName'){
                                laySomenType(1,null," 收件人名称不能为空！",0);
                            } else if(_id == 'receiverMobile'){
                                laySomenType(1,null," 收件人手机不能为空！",0);
                            } else if(_id == 'receiverAddressDetail'){
                                laySomenType(1,null," 收件人地址不能为空！",0);
                            } else if(_id == 'taxpayerNumberInvoice_1'){
                                laySomenType(1,null," 纳税人识别号不能为空！",0);
                            } else if(_id == 'taxpayerNumberInvoice'){
                                laySomenType(1,null," 纳税人识别号不能为空！",0);
                            } else if(_id == 'registerAddressInvoice'){
                                laySomenType(1,null," 注册地址不能为空！",0);
                            } else if(_id == 'receiptPhone'){
                                laySomenType(1,null," 企业电话不能为空！",0);
                            } else if(_id == 'bankProvince'){
                                laySomenType(1,null," 开户银行省不能为空！",0);
                            } else if(_id == 'bankCity'){
                                laySomenType(1,null," 开户银行市不能为空！",0);
                            } else if(_id == 'bankInvoice'){
                                laySomenType(1,null," 开户银行不能为空！",0);
                            } else if(_id == 'bankAccountInvoice'){
                                laySomenType(1,null," 企业银行账号不能为空！",0);
                            } else if(patt1.test(_id)){
                                laySomenType(1,null," 被保险人姓名不能为空！",0);
                            } else if(patt3.test(_id)){
                                laySomenType(1,null," 被保险人证件号不能为空！",0);
                            } else if(patt6.test(_id)){
                                laySomenType(1,null," 被保险人手机不能为空！",0);
                            } else {
                                laySomenType(1,null," 该项为必填字段,不能为空！",0);
                            }
                            if(_id.indexOf('_0')!=-1||_id.indexOf('_1')!=-1||_id.indexOf('role_')<0){
                                loser_has(this);
                            }else{
                                loser_has_ins(this);
                            }
                            if(patt6.test(_id)||patt1.test(_id)||patt3.test(_id)){
                                $(this).attr('style','padding-right:12px;');
                            }
                        }else{
                            if(_val.length>45){
                                laySomenType(1,null,"超过最长限制长度！",0);
                                loser_has(this);
                                $(this).val('');
                            }else{
                                if(_id == 'role_namecn_0'){
                                    // var isCN = new RegExp("[\\u4E00-\\u9FFF]+","g");
                                    // if(isCN.test(_val)){//中文
                                    //     if(_val.indexOf('(') > -1 || _val.indexOf(')') > -1){
                                    //         laySomenType(1,null,"中文企业名称中的括号必须使用中文！",0);
                                    //         loser_has(this);
                                    //         $(this).val('');
                                    //     }else{
                                    //         success_has(this);
                                    //     }
                                    // }else{
                                    //     if(_val.indexOf('（') > -1 || _val.indexOf('）') > -1){
                                    //         laySomenType(1,null,"英文企业名称中的括号必须使用英文！",0);
                                    //         loser_has(this);
                                    //         $(this).val('');
                                    //     }else{
                                    //         success_has(this);
                                    //     }
                                    // }
                                    success_has(this);
                                }else if(_id == 'role_namecn_1'){
                                    <c:if test="${fn:contains(pd.product_code,'GZZRX-QH')}">
                                        var name1 = $('#role_namecn_0').val();
                                        if(_val!=name1){
                                            laySomenType(1,null,"当前产品投/被保险人必须一致！",1000);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    </c:if>
                                    <c:if test="${!fn:contains(pd.product_code,'GZZRX-QH')}">
                                        success_has(this);
                                    </c:if>
                                    // var isCN = new RegExp("[\\u4E00-\\u9FFF]+","g");
                                    // if(isCN.test(_val)){//中文
                                    //     if(_val.indexOf('(') > -1 || _val.indexOf(')') > -1){
                                    //         laySomenType(1,null,"中文企业名称中的括号必须使用中文！",0);
                                    //         loser_has(this);
                                    //         $(this).val('');
                                    //     }else{
                                    //         success_has(this);
                                    //     }
                                    // }else{
                                    //     if(_val.indexOf('（') > -1 || _val.indexOf('）') > -1){
                                    //         laySomenType(1,null,"英文企业名称中的括号必须使用英文！",0);
                                    //         loser_has(this);
                                    //         $(this).val('');
                                    //     }else{
                                    //         success_has(this);
                                    //     }
                                    // }

                                }else if(_id == 'role_linkName_0'){
                                    var isName=/[\u4E00-\u9FA5]{2,5}(?:·[\u4E00-\u9FA5]{2,8})*/;
                                    if(!isName.test(_val)||_val.length>13){
                                        laySomenType(1,null,"请输入正确联系人姓名！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_linkName_1'){
                                    var isName=/[\u4E00-\u9FA5]{2,5}(?:·[\u4E00-\u9FA5]{2,8})*/;
                                    if(!isName.test(_val)||_val.length>13){
                                        laySomenType(1,null,"请输入正确联系人姓名！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id.indexOf("hire_name_")!=-1){
                                    var isName=/[\u4E00-\u9FA5]{2,5}(?:·[\u4E00-\u9FA5]{2,8})*/;
                                    if(!isName.test(_val)||_val.length>13){
                                        laySomenType(1,null,"请输入正确姓名！",0);
                                        loser_has_ins(this);
                                        $(this).val('');
                                        return;
                                    }else if(_val.length!=_val.trim().length){
                                        laySomenType(1,null,"请输入正确姓名！",0);
                                        loser_has_ins(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has_ins(this);
                                        return;
                                    }
                                }else if(_id == 'receiptPhone'){
                                    var isPhone=/^((0\d{2,3})-)?(\d{7,8})?(-(\d{1,4}))?$/;
                                    if(!isPhone.test(_val)){
                                        laySomenType(1,null,"格式错误，请输入格式如0592-1234567",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_phone_0'){
                                    var isPhone=/^((0\d{2,3})-)?(\d{7,8})?(-(\d{1,4}))?$/;
                                    if(!isPhone.test(_val)){
                                        laySomenType(1,null,"格式错误，请输入格式如0592-1234567",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_linkTel_0'){
                                    if(checkMobile(_val) == false){
                                        laySomenType(1,null,"手机号格式不正确，格式参考13800138000",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_doBusinessAddress_0'){
                                    if(_val.length<8||_val.length>60){
                                        laySomenType(1,null,"请输入8位以上的办公详细地址！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_regAddress_0'||_id == 'role_doBusinessAddress_0'){
                                    if(_val.length<8||_val.length>60){
                                        laySomenType(1,null,"请输入8位以上的注册地址！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_zipCode_0'){
                                    if(checkZipCode(_val) == false){
                                        laySomenType(1,null,"请输入正确的邮政编码！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_phone_1'){
                                    var isPhone=/^((0\d{2,3})-)?(\d{7,8})?(-(\d{1,4}))?$/;
                                    if(!isPhone.test(_val)){
                                        laySomenType(1,null,"格式错误，请输入格式如0592-1234567",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_linkTel_1'){
                                    if(checkMobile(_val) == false){
                                        laySomenType(1,null,"手机号格式不正确，格式参考13800138000",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_doBusinessAddress_1'){
                                    if(_val.length<8||_val.length>60){
                                        laySomenType(1,null,"请输入8位以上的办公详细地址！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_regAddress_1'||_id == 'role_doBusinessAddress_1'){
                                    if(_val.length<8||_val.length>60){
                                        laySomenType(1,null,"请输入8位以上的注册地址！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_zipCode_1'){
                                    if(checkZipCode(_val) == false){
                                        laySomenType(1,null,"请输入正确的邮政编码！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id.indexOf('hire_mobile')!=-1){
                                    if(checkMobile(_val) == false){
                                        laySomenType(1,null,"手机号格式不正确，格式参考13800138000",0);
                                        loser_has_ins(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has_ins(this);
                                        return;
                                    }
                                }else if(_id == 'role_linkEmail_0'){
                                    if(checkEmail(_val) == false){
                                        laySomenType(1,null,"电子邮箱格式不正确，格式参考：blbservice@baichuanxin.com",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_linkEmail_1'){
                                    if(checkEmail(_val) == false){
                                        laySomenType(1,null,"电子邮箱格式不正确，格式参考：blbservice@baichuanxin.com",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'taxpayerNumberInvoice_1'){
                                    if(_val.length < 21 && _val.length > 9){
                                        success_has(this);
                                    }else{
                                        laySomenType(1,null,"纳税人识别号格式有误！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }
                                }else if(_id == 'taxpayerNumberInvoice'){
                                    if(_val.length < 21 && _val.length > 9){
                                        success_has(this);
                                    }else{
                                        laySomenType(1,null,"纳税人识别号格式有误！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }
                                }else if(_id == 'role_organizationCode_0'||_id == 'role_organizationCode_1'){
                                    var _idVal = $(this).attr("GIST-ID");
                                    var _gistVal = $("#"+_idVal).val();
                                    if(_gistVal == '1'){//组织机构代码证校验
                                        if(checkOrganizingCode(_val) == 0){
                                            laySomenType(1,null,"只能包含数字或英文大写字母，必须用连字符“-”隔开！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    }else if(_gistVal == '2'){//三证合一信用代码证校验
                                        if(doValidCreditCode(_val) == 0){
                                            laySomenType(1,null,"由数字或大写英文字母组成，共18位",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    }else if(_gistVal == '6'){//税务登记证校验
                                        var flass = false;
                                        var reg= /^[A-Za-z]+$/;
                                        if(_val.length == 15&&checkInt1(_val)){
                                            flass = true;
                                        }else if(_val.length == 20&&(checkInt1(_val)||(checkInt1(_val.substring(0,_val.length-1))&&reg.test(_val.substring(_val.length-1,_val.length))))){
                                            flass = true;
                                        }else{
                                            if(doValidCreditCode(_val) == 0){

                                            }else{
                                                flass = true;
                                            }
                                        }
                                        if(flass){
                                            success_has(this);
                                        }else{
                                            laySomenType(1,null,"请输入正确的税务登记证或信用代码证代码！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }
                                    }else if(_gistVal == '7'){//营业执照校验
                                        var reg= /^\d{15}$/;
                                        if(!reg.test(_val)){
                                            laySomenType(1,null,"只能为15位数字！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    }else{
                                        laySomenType(1,null,"请先选择证件类型！",0);
                                        loser_has(this);
                                        $(this).val('');
                                    }
                                }else if(_id.indexOf('hire_id_card')!=-1){//被保险人证件号校验
                                    var nums = Number($("#hire_num").val());
                                    var _doI = 0;
                                    for(var t=0;t<=nums;t++){
                                        var this_id = "hire_id_card_"+t;
                                        if(_id != this_id){
                                            var _idCo = $("#"+this_id).val();
                                            if(_val == _idCo){
                                                _doI = 1;
                                            }
                                        }
                                    }
                                    if(_doI == 1){
                                        laySomenType(1,null,"该证件号已在本清单中，请勿重复录入人员！",0);
                                        loser_has_ins(this);
                                        $(this).val('');
                                    }else{
                                        var _idVal = $(this).attr("GIST-ID");
                                        var _gistVal = $("#"+_idVal).val();
                                        if(_gistVal == '0'){//身份证校验
                                            var age_c = Number(getAgeByAge(_val));
                                            // if(!checkIDNo(_val)){
                                            if(!validateIdent.IdentityCodeValid(_val)){
                                                laySomenType(1,null,"请输入正确证件号！",0);
                                                loser_has_ins(this);
                                                $(this).val('');
                                            }else if(age_c<16||age_c>65){
                                                laySomenType(1,null,"被保险人年龄(16-60周岁)超出限制！",0);
                                                loser_has_ins(this);
                                                $(this).val('');
                                            }else{
                                                var _thr = _id.split("_")[_id.split("_").length-1];
                                                $("#hire_birth_date_"+_thr).val(getBirthdayFromIDNo(_val));
                                                $("#hire_sex_"+_thr).val(getSexFromIDNo(_val) == 'M'?'1':'2');
                                                success_has_ins(this);
                                            }
                                        }else if(_gistVal == '3'){//护照校验
                                            if(!checkProtection(_val)){
                                                laySomenType(1,null,"请输入正确护照号！",0);
                                                loser_has_ins(this);
                                                $(this).val('');
                                            }else{
                                                success_has_ins(this);
                                            }
                                        }else if(_gistVal == '4'){//台胞证校验
                                            if(!checkCompatriotsCard(_val)){
                                                laySomenType(1,null,"请输入正确台胞证号！",0);
                                                loser_has_ins(this);
                                                $(this).val('');
                                            }else{
                                                success_has_ins(this);
                                            }
                                        }else if(_gistVal == '5'){//回乡证校验
                                            if(!checkHomeCard(_val)){
                                                laySomenType(1,null,"请输入正确回乡证号！",0);
                                                loser_has_ins(this);
                                                $(this).val('');
                                            }else{
                                                success_has_ins(this);
                                            }
                                        }else{
                                            laySomenType(1,null,"请先选择证件类型！",0);
                                            loser_has_ins(this);
                                            $(this).val('');
                                        }
                                    }
                                    $(this).attr('style','padding-right:12px;');
                                }else{
                                    if(_id.indexOf('_0')!=-1||_id.indexOf('_1')!=-1||_id.indexOf('role_')<0){
                                        success_has(this);
                                    }else{
                                        success_has_ins(this);
                                    }
                                }
                            }
                        }
                    });
                }
            }
            if(dataVal == "Date Required"){
                $(this).on("change",function(){
                    if($(this).val() == ''){
                        laySomenType(1,null,"请选择起保日期！",0);
                        loser_has(this);
                        $(this).val('');
                    }else{
                        success_has(this);
                    }
                });
            }
            if(dataVal == "Point"||dataVal == "Point Required"){
                $(this).on("keyup",function(){
                    var regm = /^[0-9]+.?[0-9]*$/;
                    if(isNaN($(this).val())){
                        laySomenType(1,null,"请输入正确的数字格式！",0);
                        $(this).val('');
                    }
                });
            }
            if(dataVal == "Num"||dataVal == "Num Required"){
                $(this).on("blur",function(){
                    var regm = /^[0-9]*[0-9][0-9]*$/;
                    if(!regm.test($(this).val())){
                        laySomenType(1,null,"请输入正确的数量格式！",0);
                        loser_has(this);
                        $(this).val('');
                    }else{
                        success_has(this);
                    }
                });
            }
        });
        $("#role_idType_0").change(function(){
            if($(this).val() == 1) {
                $("#role_organizationCode_0").attr("data-original-title","只能包含数字或英文大写字母，必须用连字符“-”隔开!")
            } else if($(this).val() == 7) {
                $("#role_organizationCode_0").attr("data-original-title","只能为15位数字!")
            } else if($(this).val() == 6) {
                $("#role_organizationCode_0").attr("data-original-title","只能为15位数字，或20位数字，或19位数字与字母X组合!")
            } else if($(this).val() == 2) {
                $("#role_organizationCode_0").attr("data-original-title","由数字或大写英文字母组成，共18位!")
            }
        })
        $("#role_idType_1").change(function(){
            if($(this).val() == 1) {
                $("#role_organizationCode_1").attr("data-original-title","只能包含数字或英文大写字母，必须用连字符“-”隔开!")
            } else if($(this).val() == 7) {
                $("#role_organizationCode_1").attr("data-original-title","只能为15位数字!")
            } else if($(this).val() == 6) {
                $("#role_organizationCode_1").attr("data-original-title","只能为15位数字，或20位数字，或19位数字与字母X组合!")
            } else if($(this).val() == 2) {
                $("#role_organizationCode_1").attr("data-original-title","由数字或大写英文字母组成，共18位!")
            }
        })
        $("select[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if(dataVal == "Required") {
                $(this).on("change", function () {
                    var _val = $(this).val();
                    var _id = this.id;
                    if (_val == '') {
                        var patt2 = new RegExp("hire_id_type_");
                        var patt4 = new RegExp("hire_birth_date_");
                        var patt5 = new RegExp("hire_sex_");
                        if(_id == 'role_comNature_0'){
                            laySomenType(1,null," 请选择营业性质！",0);
                        } else if(_id == 'role_idType_0'){
                            laySomenType(1,null," 请选择证件类型！",0);
                        } else if(_id == 'role_comNature_1'){
                            laySomenType(1,null," 请选择营业性质！",0);
                        } else if(_id == 'role_idType_1'){
                            laySomenType(1,null," 请选择证件类型！",0);
                        }  else if(_id == 'inceptionDate'){
                            laySomenType(1,null," 起保日期不能为空！",0);
                        } else if(_id == 'regProvince' || _id == 'regCity' || _id == 'regDistrict'){
                            laySomenType(1,null," 注册地址不能为空！",0);
                        } else if(patt2.test(_id)){
                            laySomenType(1,null," 被保险人证件类型不能为空！",0);
                        } else if(patt4.test(_id)){
                            laySomenType(1,null," 被保险人出生日期不能为空！",0);
                        } else if(patt5.test(_id)){
                            laySomenType(1,null," 被保险人性别不能为空！",0);
                        } else {
                            laySomenType(1,null," 该项为必填项，不能为空！",0);
                        }
                        if (_id.indexOf('_0') != -1&&_id.indexOf('_1') != -1) {
                            loser_has(this);
                        } else {
                            loser_has_ins(this);
                        }
                        $(this).val('');
                    } else {
                        success_has_ins(this);
                        if (_id.indexOf('hire_sex') != -1) {
                            var _idVal = $(this).attr("GIST-ID");
                            var _gistVal = $("#" + _idVal).val();
                            if (_gistVal == "") {
                                laySomenType(1,null,"请先完善证件号码！",0);
                                loser_has_ins(this);
                                $(this).val('');
                            } else {

                                var _idTy = $("#"+_idVal).attr("GIST-ID");
                                var _gistTy = $("#"+_idTy).val();
                                if(_gistTy == "0"){
                                    var _sex = "M";
                                    if (_val == "2") {
                                        _sex = "F";
                                    }
                                    if (_sex != getSexFromIDNo(_gistVal)) {
                                        laySomenType(1,null,"该性别与身份证不匹配！",0);
                                        loser_has_ins(this);
                                        $(this).val('');
                                    } else {
                                        success_has_ins(this);
                                    }
                                }else{
                                    success_has_ins(this);
                                }
                            }
                        }
                    }
                });
            }
        });
    }
    function natureChange(_this,_id){
        var code = _this.value;
        if(code != ""){
            $.ajax({
                type: 'POST',
                url: baseUrl + '/insurance/gzzrx/policy/natureChange.json',
                data:{"nID":code},
                dataType:"json",
                async: false,
                success: function(json) {
                    $("#" + _id).empty();
                    var t = 0;
                    $("#" + _id).append("<option value=''>-请选择-</option>");
                    for (var prop in json) {
                        if (json.hasOwnProperty(prop)) {
                            t ++;
                            var appendStr = "<option value='" + prop + "' ";
                            appendStr = appendStr + ">" + json[prop] + "</option>"
                            $("#" + _id).append(appendStr);
                        }
                    }
                    if(t > 0){
                        $("#"+_id).parent().show();
                    }else{
                        $("#"+_id).parent().hide();
                    }

                }
            });
        }else{
            $("#"+_id).parent().hide();
        }
    }
    // function changeInceptionType(typeID, longID) {
    //     var type = $("#" + typeID).val();
    //     if(type == '2') {
    //         $("#" + longID).show();
    //     }else{
    //         $("#" + longID).hide();
    //     }
    //     computationalCosts();
    // }
    function changeDistrict(districtID, areaID, level, obj) {
        $("#" + districtID).empty();
        if(areaID != '') {
            $("#" + areaID).empty();
            $("#" + areaID).append("<option value=''>--请选择区县--</option>");
        }
        var code = obj.value;
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findCity.json',
            data:{"codeLevel":level,"parentCode":code},
            dataType:"json",
            async: false,
            success: function(json) {
                if(level == '2') {
                    $("#" + districtID).append("<option value=''>请选择市</option>");
                } else if(level == '3') {
                    $("#" + districtID).append("<option value=''>请选择区／县</option>");
                } else {
                    $("#" + districtID).append("<option value=''>--请选择--</option>");
                }
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + districtID).append(appendStr);
                }
            }
        });
    }
    function changeBankType(districtID, obj) {
        $("#" + districtID).empty();
        var code = obj.value;
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findBankType.json',
            data:{"area":code},
            dataType:"json",
            async: false,
            success: function(json) {
                $("#" + districtID).append("<option value=''>请选择名称</option>");
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + districtID).append(appendStr);
                }
            }
        });
    }
    function changeBankAddr(addrID, areaID, obj) {
        $("#" + addrID).empty();
        var code = obj.options[obj.selectedIndex].text;
        var url = '/synopsis/findBankAddr.json';
        <c:if test="${fn:contains(pd.product_code,'GZZRX-TB')}">
        url = '/synopsis/findTBBankAddr.json';
        </c:if>
        $.ajax({
            type: 'POST',
            url: baseUrl + url,
            data:{"area":$("#" + areaID).val(),"bankName":code},
            dataType:"json",
            async: false,
            success: function(json) {
                $("#" + addrID).append("<option value=''>请选择地址</option>");
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + addrID).append(appendStr);
                }
            }
        });
    }
    function changeBankName(bankNameID, obj) {
        $("#" + bankNameID).val(obj.options[obj.selectedIndex].text);
    }
    function deleteThisRow(_class,_num,_cla){
        var cla = _class.split("_")[0]+"_"+_class.split("_")[1];
        var g = 0;
        $("tr").each(function(){
            var _cla = $(this).attr("class");
            if(_cla != undefined){
                if(_cla.indexOf(cla)!= -1){
                    g++;
                }
            }
        });

        if(g>3){//
            var _hire = "hire_oid_" + Number(_class.split("_")[2]);
            var _hire_id = $("#"+ _hire).val();
            if(_hire_id == '' || _hire_id == undefined || _hire_id == 'null'){
                $("."+_class).remove();
                var doNum = Number($("#"+cla).val())-1;
                $("#"+cla).val(doNum);
                var count = $(".signIndex").length;
                var i = 0;
                $(".signIndex").each(function(){
                    i++;
                    $(this).html(i);
                });
                computationalCosts();
            }else{
                var index = laySomenType(0,null,'',0);
                $.ajax({
                    type: 'POST',
                    url:baseUrl + '/insurance/gzzrx/policy/deleteHirelingByOid.json',
                    data:{
                        'hire_id':_hire_id
                    },
                    dataType:"json",
                    success: function(json){
                        laySomenType(1,null,json.message,0);
                        if(json.statusCode == '200') {
                            $("."+_class).remove();
                            var doNum = Number($("#"+cla).val())-1;
                            $("#"+cla).val(doNum);
                            var count = $(".signIndex").length;
                            var i = 0;
                            $(".signIndex").each(function(){
                                i++;
                                $(this).html(i);
                            });
                            computationalCosts();
                        }
                        laySomenType(2,index,'',0);
                    },
                    error : function(XMLHttpRequest, textStatus, errorThrown) {
                        laySomenType(2,index,'',0);
                        laySomenType(1,null,textStatus,0);
                    }
                });
            }
            if((g-1)<_num){
                $("."+_cla).fadeIn(1000);
            }

        }else{
            laySomenType(1,null,"雇员必须大于三人，删除失败！",0);
        }
        changeFrameSet(0,'');//加载当前内容高度并重置iframe
    }

    function checkToradio(_id, type){
        var o = $("#"+_id);
        if(type=="radio"){
            o.prop('checked',true);
            if(o.val() == "1"){
                $("#arbitralInstitution").parent().show();
            }else if(o.val() == "0"){
                $("#arbitralInstitution").val('');
                $("#arbitralInstitution").parent().hide();
            }else{
                o.click();
            }
        }else if(type=="checkbox"){

            if($("#"+_id).attr('checked')) {
                o.attr('checked', false);
            } else {
                o.attr('checked', true);
            }
            o.click();
        }
    }

    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/policy/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"policy/",type);
        flag = true;
        return flag;
    }

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = laySomenType(0,null,'',0);
        var _myData = new Date();
        var _times = _myData.getTime();
        var name = "/"+directoryName+_times+"."+fileType;
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', _times+"."+fileType);
//        formData.append('fileId', _times+"4354534534");
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoad';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                laySomenType(2,index,'',0);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                }else{
                    laySomenType(1,null,result.message,0);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }


    function uploadInsure(){
        var formData = new FormData();
        var files = document.getElementById("hire_emp").files[0];
        if(files == undefined){
            return;
        }
        if(files.name.split('.')[1].indexOf('xls')==-1&&files.name.split('.')[1].indexOf('xlsx')==-1){
            layer.msg('请下载模板文件，填充人员信息后上传！',{time:3000});
            return;
        }
        var index = laySomenType(0,null,'',0);
        formData.append('hire_emp', files);
        $('#hire_emp').val('');
        $.ajax({
            type: 'POST',
            url:baseUrl + '/insurance/gzzrx/policy/gzxUploadHirelingFile?ACCESS_TOKEN=${ACCESS_TOKEN}',
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(json){
                laySomenType(1,null,json.message,3000);
                if(json.statusCode == '200') {
                    var oid = '${dto.oid}';
                    if(oid != ''){//如果存在订单，先删除所有被保险人
                        $.ajax({
                            type: 'POST',
                            url:baseUrl + '/insurance/gzzrx/policy/delectAllHireling',
                            data:{
                                'order_id':oid
                            },
                            dataType:"json",
                            success: function(json){
                                if(json.statusCode == '200') {
                                    setUploadHireling(index);
                                }else{
                                    laySomenType(1,null,json.message,0);
                                    laySomenType(2,index,'',0);
                                }
                            }
                        });
                    }else{
                        setUploadHireling(index);
                    }
                }else{
                    var reg = new RegExp(';','g');
                    var blob = new Blob(['(注：以下异常信息行号对应Excel自带行号。)\n'+json.message.replace(reg,'\n')], {type: "text/plain;charset=utf-8"});
                    saveAs(blob, "excel人员数据异常清单.txt");
                    laySomenType(2,index,'',0);
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                laySomenType(2,index,'',0);
                laySomenType(1,null,textStatus,0);
            }
        });

    }

    //根据数据，请求后台计算保费保额
    function computationalCosts(){
        var product_code = '${pd.product_code}';
        var is_contain_repo = $("#is_contain_repo").val();
        var inception_type = $("#inception_type").val();
        var inception_long = $("#inception_long").val();
        var person_num = $("#hire_num").val();
        var premium = '${pd.premium_min}';
        if(product_code != ''&&is_contain_repo != ''&&person_num != ''&&premium != ''){
            $.ajax({
                type: 'POST',
                url:baseUrl + '/insurance/gzzrx/policy/computational-costs',
                data:{
                    'product_code':product_code,
                    'is_contain_repo':is_contain_repo,
                    'inception_type':inception_type,
                    'inception_long':inception_long,
                    'person_num':person_num,
                    'premium':premium
                },
                dataType:"json",
                success: function(json){
                    if(json.statusCode == '200') {
                        var arr = json.message.split('#');
                        $('#mPremium').html(arr[0]+'元');
                        $('#g_premium').val(arr[0]);
                        $('#g_insured_amount').val(arr[1]);
                    }
                }
            });
        }
        <c:if test="${fn:contains(pd.product_code,'GZZRX-QH')}">
        var qhPremiumC = $("#qhPremiumC").html().replace(' 元/人','').trim();
        var qhPremiumF = $("#qhPremiumF").html().replace(' 元/人','').trim();
        if(inception_type == '2'){
            if(qhPremiumC >= 216){
                $("#qhPremiumC").html((qhPremiumC/12)+' 元/人');
                $("#qhPremiumF").html((qhPremiumF/12)+' 元/人');
            }
        }else{
            if(qhPremiumC < 100){
                $("#qhPremiumC").html((qhPremiumC*12)+' 元/人');
                $("#qhPremiumF").html((qhPremiumF*12)+' 元/人');
            }
        }

        </c:if>
    }

    function setUploadHireling(_index){//设置上传的人员到页面展示
        $.ajax({
            type: 'POST',
            url:baseUrl + "/insurance/gzzrx/policy/hire_upload_list/${pd.product_code}?ACCESS_TOKEN=${ACCESS_TOKEN}",
            dataType:"text",
            success: function(data){
                $("#add-increased-table").html(data);
                computationalCosts();
                initCheck();
                changeFrameSet(0,'');//加载当前内容高度并重置iframe
                laySomenType(2,_index,'',0);
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                laySomenType(2,_index,'',0);
                laySomenType(1,null,textStatus,0);
            }
        });
    }
    $('#wed_wed').click(function () {
        resetFileInput($('#hire_emp'));
        $('#hire_emp').click();
    })
    function resetFileInput(file){
        file.after(file.clone().val(""));
        file.remove();
    }
</script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
</html>