<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-填写投保单</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
<body>

<jsp:include page="../../../index/multi_h.jsp"/>
<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<%--<ol class="breadcrumb">
	  <li><a href="<c:url value='/'/>">首页</a></li>
		<li><a href="<c:url value='/synopsis/product/productAllView'/>">产品列表</a></li>
		<li><a href="<c:url value='/insurance/product/productInfo/${dto.product_oid}'/>">产品详情</a></li>
	  <li class="active">投保确认</li>
	</ol>--%>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<div class="message-war"><!-- message-war start -->
		<h2>${ dto.product_name}</h2>
		<div class="w-95-auto"><!-- w-95-auto start -->
			<h5>订单号码：${ dto.trade_serial_number}</h5>
			<div class="mess-title"><h3>推荐人信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">推荐人的手机号或编号</td>
						<td class="col-sm-4 col-xs-4">${empty vo1.recommend_code ? '无' : vo1.recommend_code}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
						<td class="col-sm-4 col-xs-4"></td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>投保人基本信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody>
					   <tr>
						   <td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">投保人名称</td>
						   <td colspan="3" class="col-sm-10 col-xs-10">${ vo2.roleSubjectList[0].name_cn}</td>
					   </tr>
					   <tr>
						   <td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">投保人地址</td>
						   <td colspan="3" class="col-sm-9 col-xs-9">${ reg_role}${ vo2.roleSubjectList[0].reg_address}</td>
					   </tr>
					   <tr>
						   <td class="tablebg_f5f8fa col-sm-2 col-xs-2">${vo.roleSubjectList[0].id_type eq '1' ? '组织机构代码' : vo.roleSubjectList[0].id_type eq '2' ? '统一社会信用代码' : '证件号码' }</td>
						   <td class="col-sm-4 col-xs-4">${ vo2.roleSubjectList[0].organization_code}</td>
						   <td class="tablebg_f5f8fa col-sm-2 col-xs-2">邮政编码</td>
						   <td class="col-sm-4 col-xs-4">${ vo2.roleSubjectList[0].zip_code}</td>
					   </tr>
					   <tr>
						   <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人</td>
						   <td class="col-sm-4 col-xs-4">${ vo2.roleSubjectList[0].link_name}</td>
						   <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系电话</td>
						   <td class="col-sm-4 col-xs-4">${ vo2.roleSubjectList[0].phone}</td>
					   </tr>
					   <tr>
						   <td class="tablebg_f5f8fa col-sm-2 col-xs-2">邮箱</td>
						   <td class="col-sm-4 col-xs-4">${ vo2.roleSubjectList[0].link_email}</td>
						   <td class="tablebg_f5f8fa col-sm-2 col-xs-2">手机号码</td>
						   <td class="col-sm-4 col-xs-4">${ vo2.roleSubjectList[0].link_tel}</td>
					   </tr>
					   </tbody>
				</table>
			</div>
			<div class="mess-title"><h3>被保险人基本信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody>
					   <tr>
						   <td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">被保险人名称</td>
						   <td colspan="3" class="col-sm-10 col-xs-10">${ vo2.roleSubjectList[1].name_cn}</td>
					   </tr>
					   <tr>
						   <td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">被保险人地址</td>
						   <td colspan="3" class="col-sm-9 col-xs-9">${ vo2.roleSubjectList[1].address}</td>
					   </tr>
					   <tr>
						   <td class="tablebg_f5f8fa col-sm-2 col-xs-2">${vo.roleSubjectList[1].id_type eq '1' ? '组织机构代码' : vo.roleSubjectList[1].id_type eq '2' ? '统一社会信用代码' : '证件号码' }</td>
						   <td class="col-sm-4 col-xs-4">${ vo2.roleSubjectList[1].organization_code}</td>
						   <td class="tablebg_f5f8fa col-sm-2 col-xs-2">邮政编码</td>
						   <td class="col-sm-4 col-xs-4">${ vo2.roleSubjectList[1].zip_code}</td>
					   </tr>
					   <tr>
						   <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人</td>
						   <td class="col-sm-4 col-xs-4">${ vo2.roleSubjectList[1].link_name}</td>
						   <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系电话</td>
						   <td class="col-sm-4 col-xs-4">${ vo2.roleSubjectList[1].phone}</td>
					   </tr>
					   <tr>
						   <td class="tablebg_f5f8fa col-sm-2 col-xs-2">手机号码</td>
						   <td class="col-sm-4 col-xs-4">${ vo2.roleSubjectList[1].link_tel}</td>
						   <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
						   <td class="col-sm-4 col-xs-4"></td>
					   </tr>
					   </tbody>
				</table>
			</div>
			<div class="mess-title"><h3>投保基本信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
                       <tbody> 
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">项目名称及标段</td>
                            <td class="col-sm-4 col-xs-4">${ vo2.project_name}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">招标文件编号</td>
                            <td class="col-sm-4 col-xs-4">${ vo2.invitation_code}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">工程造价（元）</td>
                            <td class="col-sm-4 col-xs-4">${ vo2.predict_cost}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">工程建设地点</td>
                            <td class="col-sm-4 col-xs-4">${ vo2.project_address}</td>
                        </tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">计划工期</td>
							<td colspan="3" class="col-sm-10 col-xs-10">${vo2.project_time}</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保险金额(元)</td>
							<td colspan="3" class="col-sm-9 col-xs-9">${ vo2.insured_amount}</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保险期间</td>
							<td colspan="3" class="col-sm-10 col-xs-10">自&nbsp;${ vo2.inception_date}&nbsp;零时起&nbsp;&nbsp;至&nbsp;${ vo2.planned_end_date}&nbsp;二十四时止</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">司法管辖</td>
							<td colspan="3" class="col-sm-9 col-xs-9">中华人民共和国司法管辖（港澳台除外）</td>
						</tr>
						<tr>
							<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">争议处理</td>
							<td colspan="3" class="col-sm-9 col-xs-9">若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：${ vo2.dispute eq '0' ? '诉讼' : '仲裁，仲裁机构' }&nbsp;&nbsp;${vo2.dispute eq '0' ? '' : vo2.arbitral_institution}</td>
						</tr>
                   	</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>保险公司提示</h3></div>
			<div class="affirm-warr">
				<p class="mt30">1、本投保单为保险合同的组成部分。请投保人在填写投保单之前仔细阅读保险条款（包括主险和附加险），尤其是加黑突出标注的、免除保险人责任的条款内容，并听取保险公司业务人员对条款的说明以及对免除保险人责任条款的明确说明，如有不明白或有疑义的，请及时询问保险公司业务人员。</p>
				<p class="mb30">2、中国太保（是指中国太平洋保险（集团）股份有限公司及其直接或间接控股的子公司，以及中国太平洋保险（集团）股份有限公司直接或间接作为其单一最大股东的公司）对您提供的资料承担保密义务，中国太保将采取恰当的物理、电子、管理技术手段保护投保人提供的资料，同时，采取适当的安全措施保护投保人提供的资料免于未经授权的访问、使用或泄露。</p>
			</div>
			<div class="mess-title"><h3>投保人声明</h3></div>
			<div class="affirm-warr">
				<p class="mt30"><strong>1、本投保人已经收悉并仔细阅读保险条款，尤其是加黑突出标注的、免除保险人责任的条款内容。保险公司业务人员已就本合同所涉及的所有免除保险人责任条款的概念、内容及其法律后果向本投保人做出了通俗的、本投保人能够理解的解释和明确说明，本投保人对其真实含义和法律后果完全理解，没有异议，特签字、盖章予以确认并申请投保。</strong></p>
				<p>2、基于为本投保人及被保险人提供更优质服务和产品的目的，除法律另有规定外，本投保人授权中国太保可以从相关单位、组织和个人就有关保险事宜查询、索取与本投保人及被保险人有关的资料和证明。</p>
				<p>3、除法律另有规定外，本投保人同意中国太保及其认为业务必要而委托的第三方将本投保人提供的全部资料、享受中国太保服务产生的信息，以及从相关单位、组织和个人就有关保险事宜查询、索取的资料和证明，用于为本投保人及被保险人提供服务、推荐产品、开展市场调查与信息数据分析。</p>
				<p class="mb30">4、本投保人及被保险人兹声明所填上述内容（包括投保单及投保附件）属实。</p>
			</div>
		</div><!-- w-95-auto end -->
	</div><!-- message-war end -->
	<div class="row next-step">
		<div class="col-sm-3 col-sm-3">
			<div class="insure-check">
				<span class="check-box pull-left">
					<input type="checkbox" id="checkbox10" />
					<label for="checkbox10"></label>
				</span>
				<span class="pull-left">我同意以上告知和声明</span><br /> 
			</div>
			<p class="fs-20-cl">保费 等待保险公司报价</p>
		</div>
	</div>
	<div class="row next-step">
		<div class="col-lg-6 col-sm-6">
			<p>您需要打印投保单将其盖上贵公司公章并到此上传。</p>
		</div>
		<div class="col-sm-6 col-xs-6 text-right pull-right">
			<p>
				<a href="<c:url value="/insurance/build/policy/pg_policy/${dto.oid}/1?ACCESS_TOKEN=${ACCESS_TOKEN}" />" class="save">返回修改</a>
				<a href="javascript:validateMsg();" id="validatePost" class="ns-btn">确认申请</a>
				<a href="javascript:void(0);" onclick="showInsureModal();" class="ns-btn" style="margin-left: 10px;">上传投保单</a>
				<a href="javascript:void(0);" onclick="showPrintPolicyModal('${dto.oid}');" class="gray-btn" style="margin-left: 10px;">打印投保单</a>
			</p>
		</div>
	</div>
</div><!-- container end --> 
<div class="modal fade" id="insureModal" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">上传投保单</h4>
		  </div>
		  <form id="insureForm" method="post" enctype="multipart/form-data" action='<c:url value="/insurance/transaction/uploadInsureFile.json?ACCESS_TOKEN=${ACCESS_TOKEN}"/>' >
		  	<input name="ins_insurance_slip_id" id="policyId" value="${dto.oid}" type="hidden"/>
			  <div class="modal-body">
			  	<div class="col-sm-12 col-xs-12" style="margin-top: 8px;">
					<div class="col-sm-12 col-xs-12" id="insurePath_isHidden">
						<input type="hidden" name="user_insure_path" id="user_insure_path" value="">
						<div class="basic-file">
							<input name="user_insure_path_file" id="user_insure_path_file-5" class="file" data-drawview="" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
						</div>
					</div> 
			  	</div> 
			  </div>
			  <div class="modal-footer">
				<div class="mofo-sub">
					<button type="button" class="btn pull-left cancel-btn" data-dismiss="modal">取消</button>
					<button type="button" class="btn notarize-btn pull-right" onclick="uploadInsure();">确认</button>
				</div>
			  </div> 
		  </form> 
		</div> 
  </div> 
</div>


<!-- 内容部分  注册  结束 -->
<jsp:include page="../../../index/multi_f.jsp" />

<!-- script -->
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
	/* $(function(){
		var type = '';
		if(type == 'Y'){
			finsh_block();
		}
	}); */
    $(function(){
        $("td").each(function(){
            var _class = $(this).attr("class");
            if(_class != undefined){
                if(_class.indexOf("tablebg_f5f8fa") == -1 && _class.indexOf("col-sm") != -1){
                    console.log($(this).prev());
                    if($(this).prev().length==1){
                        var preClass = $(this).prev().attr("class");
                        if(preClass.indexOf("tablebg_f5f8fa") != -1){
                            var preVal = $(this).prev().html();
                            if(preVal != ''){
                                var _val = $(this).html();
                                if(_val == ''){
                                    $(this).html('-');
                                }
                            }
                        }else{
                            var _val = $(this).html();
                            if(_val == ''){
                                $(this).html('-');
                            }
                        }
                    }else{
                        var _val = $(this).html();
                        if(_val == ''){
                            $(this).html('-');
                        }
                    }


                }
            }
        });

    });
	function validateMsg(){
		layer.msg("请先打印投保单将其盖上贵公司公章并通过“上传投保单”按钮上传盖公章后的投保单方可申请！");
	}
	function validateChecked(_id){
		if($("#checkbox10").is(':checked')){
			layer.load(0, {shade: [0.3,'#808080']});
            var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            $.ajax({
                type: 'POST',
                url:baseUrl + '/insurance/build/policy/updateOrderFormStatus',
                data:{
                    'order_id':_id,
                    'status':'2'
                },
                dataType:"json",
                success: function(json){
                    layer.close(index);
                    if(json.statusCode == '200') {
                        window.location.href = baseUrl + '/insurance/build/policy/policyPayment/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                    }else{
                        layer.msg(json.message);
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.close(index);
                    layer.msg(textStatus);
                }
            });
		}else{
			layer.msg("请勾选“我同意以上告知和声明”！");
		}
	}
	function affirmMothen(){
		$(".stat_hint").show();
	}
	function showInsureModal(){
		$("#insureModal").modal("show");
	}
	
	function showPrintPolicyModal(policyId){
		layer.open({
			  type: 2,
			  title:'投保单预览',
			  scrollbar: false,
			  area : [ '70%', '90%' ],
			  shade : 0.8,
			  skin: 'agreementModal',
			  btn: ['打印','取消'],
			  content: baseUrl +'/insurance/transaction/printPolicy/'+policyId+'?ACCESS_TOKEN=${ACCESS_TOKEN}', //iframe的url
			  yes:function(indexIframe, layero){
			    var iframeWin = window[layero.find('iframe')[0]['name']]; //得到iframe页的窗口对象，执行iframe页的方法：iframeWin.method();
			    iframeWin.printPage();
			  }
		});
	}
	function uploadInsure(){
		var policyId = $("#policyId").val();
		var insurePath = $("#user_insure_path").val();
		if(insurePath ==""){
			layer.msg("请选择投保单");
		}
		else{
			var index = layer.load(0, {shade: [0.3,'#808080']});
            $.ajax({
                type: 'POST',
                url:baseUrl + '/insurance/transaction/uploadInsureFile_user.json',
                data:$("#insureForm").serialize(),
                dataType:"json",
                success: function(json){
                    layer.close(index);
                    layer.msg(json.message);
                    if(json.statusCode == '200') {
                        $("#insureModal").modal("hide");
                        $("#validatePost").attr("href","javascript:validateChecked('"+policyId+"');");
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    layer.close(index);
                    layer.msg(textStatus);
                }
            });
		}
	}
    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/policy/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"policy/",type);
        flag = true;
        return flag;
    }

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        var _myData = new Date();
        var _times = _myData.getTime();
        var name = "/"+directoryName+_times+"."+fileType;
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', _times+"."+fileType);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoad';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                layer.close(index);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                }else{
                    layer.msg(result.message);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }
</script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/jquery.form.js'/>"></script>
</body>
</html>