<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-填写投保单</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
	</head>
<body>
<jsp:include page="../../../index/multi_h.jsp"/>

<div class="container" style="padding-bottom: 50px; padding-top: 20px;"><!-- container start -->
	<%--<ol class="breadcrumb">
	  <li><a href="<c:url value='/'/>">首页</a></li>
	  <li><a href="<c:url value='/synopsis/product/productAllView'/>">产品列表</a></li>
	  <li><a href="<c:url value='/insurance/product/productInfo/${dto.product_oid}'/>">产品详情</a></li>
	  <li class="active">投保</li>
	</ol>  --%>
	<div class="nav-list">
		<div class="row w-80-auto">
			<div class="col-sm-3 col-sm-4 active">
				<p><i class="glyphicon glyphicon-ok pull-left"></i><span class=" pull-left">填写保险信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
			</div>
			<div class="col-sm-3 col-sm-4">
				<p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
			</div>
			<div class="col-sm-3 col-sm-4 pull-right">
				<p><i class="pull-left">4</i><span class="pull-left">完成投保</span></p>
			</div>
		</div>
	</div>
	<form class="form-horizontal form-create-item"  action="<c:url value='/insurance/build/policy/confirm?ACCESS_TOKEN=${ACCESS_TOKEN}'/>" method="post" id="policyInfoForm">
		<input type="hidden" name="oid" id="policyOid" value="${dto.oid}"/>
		<input type="hidden" name="product_id" id="productOid" value="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}"/>
		<div class="message-war"><!-- message-war start -->
			<div class="title-war"><h3>提交资料</h3></div>
			<div class="row w-95-auto"><!-- w-95-auto start -->
				<div class="col-sm-6 col-xs-6 file-none">
					<p>*企业营业执照、组织机构代码证及税务登记证</p>
					<input Data-Val="Required" type="hidden" name="subfile_dm" id="subfile_dm" value="${vo.subfile_dm}">
					<div>
						<input name="subfile_dm_file" id="subfile_dm_file-5" class="file" data-drawview="${vo.subfile_dm}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>*资质证书（说明：指特级、一级、二级、三级等）</p>
					<input Data-Val="Required" type="hidden" name="subfile_zz" id="subfile_zz" value="${vo.subfile_zz}">
					<div>
						<input name="subfile_zz_file" id="subfile_zz_file-5" class="file" data-drawview="${vo.subfile_zz}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>*安全生产许可证</p>
					<input Data-Val="Required" type="hidden" name="subfile_aq" id="subfile_aq" value="${vo.subfile_aq}">
					<div>
						<input name="subfile_aq_file" id="subfile_aq_file-5" class="file" data-drawview="${vo.subfile_aq}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>*企业章程原件扫描件</p>
					<input Data-Val="Required" type="hidden" name="subfile_zc" id="subfile_zc" value="${vo.subfile_zc}">
					<div>
						<input name="subfile_zc_file" id="subfile_zc_file-5" class="file" data-drawview="${vo.subfile_zc}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>经审计部门审计的近2年财务报表扫描件</p>
					<input type="hidden" name="subfile_cw" id="subfile_cw" value="${vo.subfile_cw}">
					<div>
						<input name="subfile_cw_file" id="subfile_cw_file-5" class="file" data-drawview="${vo.subfile_cw}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>企业银行开户许可证扫描件</p>
					<input type="hidden" name="subfile_kh" id="subfile_kh" value="${vo.subfile_kh}">
					<div>
						<input name="subfile_kh_file" id="subfile_kh_file-5" class="file" data-drawview="${vo.subfile_kh}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>企业贷款卡扫描件</p>
					<input type="hidden" name="subfile_hk" id="subfile_hk" value="${vo.subfile_hk}">
					<div>
						<input name="subfile_hk_file" id="subfile_hk_file-5" class="file" data-drawview="${vo.subfile_hk}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>企业近3年纳税证明</p>
					<input type="hidden" name="subfile_ns" id="subfile_ns" value="${vo.subfile_ns}">
					<div>
						<input name="subfile_ns_file" id="subfile_ns_file-5" class="file" data-drawview="${vo.subfile_ns}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>企业近三个月银行对账单</p>
					<input type="hidden" name="subfile_dz" id="subfile_dz" value="${vo.subfile_dz}">
					<div>
						<input name="subfile_dz_file" id="subfile_dz_file-5" class="file" data-drawview="${vo.subfile_dz}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>企业近3年工程业绩（包括中标通知书、合同、竣工备案表）</p>
					<input type="hidden" name="subfile_yj" id="subfile_yj" value="${vo.subfile_yj}">
					<div>
						<input name="subfile_yj_file" id="subfile_yj_file-5" class="file" data-drawview="${vo.subfile_yj}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>企业在建工程业绩清单（中标通知书、合同）</p>
					<input type="hidden" name="subfile_qd" id="subfile_qd" value="${vo.subfile_qd}">
					<div>
						<input name="subfile_qd_file" id="subfile_qd_file-5" class="file" data-drawview="${vo.subfile_qd}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>本投保项目的项目经理个人简历、过往项目施工经验介绍</p>
					<input type="hidden" name="subfile_js" id="subfile_js" value="${vo.subfile_js}">
					<div>
						<input name="subfile_js_file" id="subfile_js_file-5" class="file" data-drawview="${vo.subfile_js}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>本投保项目的招标文件、中标通知书、建筑工程施工合同副本</p>
					<input type="hidden" name="subfile_ht" id="subfile_ht" value="${vo.subfile_ht}">
					<div>
						<input name="subfile_ht_file" id="subfile_ht_file-5" class="file" data-drawview="${vo.subfile_ht}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>
				<div class="col-sm-6 col-xs-6 file-none">
					<p>其它认为需要提供的材料（如企业获得的荣誉等）</p>
					<input type="hidden" name="subfile_cl" id="subfile_cl" value="${vo.subfile_cl}">
					<div>
						<input name="subfile_cl_file" id="subfile_cl_file-5" class="file" data-drawview="${vo.subfile_cl}" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
					</div>
				</div>

			</div><!-- w-95-auto end -->
		</div><!-- message-war end -->

		</form>
		<div class="row next-step">
			<div class="col-sm-12 col-xs-12 text-right pull-right">
				<p>
					<a href="javascript:void(0);" onclick="saveSPFInfo('3');" id="pendingInfo" dataWait="0" class="save">暂存本页</a>
					<a href="javascript:void(0);" id="next_policy" onclick="save_policy_spf('3');" class="ns-btn">下一步</a>
					<a href="javascript:void(0);" onclick="save_policy_spf_pre('2');" class="ns-btn">上一步</a>
				</p>
			</div>
		</div>
	</div><!-- container end -->
<!-- 营业执照 start -->
<div class="modal fade" id="open" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">营业执照</h4>
		  </div> 
		  <div class="modal-body">
		  	<img src="<c:url value='/resources/versions-2.0/images/product/open.jpg' />" class="img-responsive ml-14">
		  </div> 
		</div> 
  </div> 
</div> 
<!-- 营业执照 end -->
<!-- 组织机构代码证 start -->
<div class="modal fade" id="org" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">组织机构代码证</h4>
		  </div> 
		  <div class="modal-body">
		  	<img src="<c:url value='/resources/versions-2.0/images/product/org.jpg' />" class="img-responsive">
		  </div> 
		</div> 
  </div> 
</div> 
<!-- 组织机构代码证 end -->
<!-- 税务登记证 start -->
<div class="modal fade" id="tax" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
   <div class="modal-dialog" role="document">
		<div class="modal-content">
		  <div class="modal-header bg-1f96ef">
			<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
			<h4 class="modal-title">税务登记证</h4>
		  </div> 
		  <div class="modal-body">
		  	<img src="<c:url value='/resources/versions-2.0/images/product/tax.jpg' />" class="img-responsive">
		  </div> 
		</div> 
  </div> 
</div> 
<!-- 税务登记证 end --> 
<jsp:include page="../../../index/multi_f.jsp" />
</body>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script src="<c:url value='/resources/commonJS/con-common.js'/>" type="text/javascript"></script>

<script type="text/javascript">
var baseUrl = '${pageContext.request.contextPath }';

var count = 2;
$(function(){
    if($("#need_insur_bill").is(':checked')){
        $("#mod_1").fadeIn(1000);
    }else{
        $("#mod_1").fadeOut(1000);
    }
    if($("#need_receipt").is(':checked')){
        var _invoice_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
        $("#mod_2").fadeIn(1000);
        if(_invoice_val == "0"){//普通发票
            $("#mod_2_1").fadeIn(1000);
        }else{//专用发票,VATINVOICE
            $("#mod_2_1").fadeIn(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2_3").fadeIn(1000);
        }
    }else{
        $("#mod_2").fadeOut(1000);
        $("#mod_2_1").fadeOut(1000);
        $("#mod_2_2").fadeOut(1000);
        $("#mod_2_3").fadeOut(1000);
    }

});
function save_policy_spf(_page){
    if(customsVerify()){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        $.ajax({
            type: 'POST',
            url:baseUrl + '/insurance/build/policy/pendingSpecialPerformance_3VoPolicy',
            data:$("#policyInfoForm").serialize(),
            dataType:"json",
            success: function(json){
                layer.close(index);
                if(json.statusCode == '200') {
                    if(_page == '2'){
                        window.location.href = baseUrl + '/insurance/build/policy/pg_policy/'+json.navTabId+'/'+_page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                    }else{
                        window.location.href = baseUrl + '/insurance/build/policy/confirmPage/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                    }
                }else{
                    layer.msg(json.message);
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.close(index);
                layer.msg(textStatus);
            }
        });
    }
}
function customsVerify(){
    var flag = true;
    $("input[Data-Val]").each(function(){
        var dataVal = $(this).attr("Data-Val");
        if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
            if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                if($(this).val() == ''){
                    document.getElementById(this.id).scrollIntoView();
                    layer.msg("必填项不能为空！");
                    $(this).focus();
                    flag = false;
                    return true;
                }else{
                    if($(this).val().length>40){
                        document.getElementById(this.id).scrollIntoView();
                        layer.msg("长度超出限制！");
                        $(this).focus();
                        flag = false;
                        return true;
                    }
                }

            }
        }
        if(dataVal == "Required"){
            if(this.id == 'subfile_dm'){
                if($(this).val() == ''){
                    document.getElementById(this.id).scrollIntoView();
                    layer.msg("请上传企业营业执照、组织机构代码证及税务登记证！");
                    $(this).focus();
                    flag = false;
                    return true;
                }
            }
            if(this.id == 'subfile_zz'){
                if($(this).val() == ''){
                    document.getElementById(this.id).scrollIntoView();
                    layer.msg("请上传资质证书（说明：指特级、一级、二级、三级等）！");
                    $(this).focus();
                    flag = false;
                    return true;
                }
            }
            if(this.id == 'subfile_aq'){
                if($(this).val() == ''){
                    document.getElementById(this.id).scrollIntoView();
                    layer.msg("请上传安全生产许可证！");
                    $(this).focus();
                    flag = false;
                    return true;
                }
            }
            if(this.id == 'subfile_zc'){
                if($(this).val() == ''){
                    document.getElementById(this.id).scrollIntoView();
                    layer.msg("请上传企业章程原件扫描件！");
                    $(this).focus();
                    flag = false;
                    return true;
                }
            }
        }
    });
    if(flag){
        $("select[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                    if($(this).val() == ''){
                        document.getElementById(this.id).scrollIntoView();
                        layer.msg("必填项不能为空！");
                        $(this).focus();
                        flag = false;
                        return true;
                    }

                }
            }
        });
        if(flag){
            $("textarea[Data-Val]").each(function(){
                var dataVal = $(this).attr("Data-Val");
                if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                    if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            layer.msg("必填项不能为空！");
                            $(this).focus();
                            flag = false;
                            return true;
                        }else{
                            if($(this).val().length>100){
                                document.getElementById(this.id).scrollIntoView();
                                layer.msg("长度超出限制(100字符)！");
                                $(this).focus();
                                flag = false;
                                return true;
                            }
                        }

                    }
                }
            });

        }
    }
    return flag;
}
function save_policy_spf_pre(_page){
    var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
    window.location.href = baseUrl + '/insurance/build/policy/pg_policy/${dto.oid}/'+_page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
}
function saveSPFInfo(page){
    var doIDs = ['subfile_dm','subfile_zz','subfile_aq','subfile_zc'];
    var cod = 0;
    for(var i=0;i<doIDs.length;i++){
        if($("#"+doIDs[i]).val() == ''){
            cod = 1;
        }
    }
    if(cod == 0){
        var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        $.ajax({
            type: 'POST',
            url:baseUrl + '/insurance/build/policy/pendingSpecialPerformance_'+page+'VoPolicy',
            data:$("#policyInfoForm").serialize(),
            dataType:"json",
            success: function(json){
                layer.close(index);
                layer.msg(json.message);
                if(json.statusCode == '200') {
                    window.location.href = baseUrl + '/insurance/build/policy/pg_policy/'+json.navTabId+'/'+page+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                }
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                layer.close(index);
                layer.msg(textStatus);
            }
        });
    }else{
        layer.msg("请上传必填项（*）！");
    }
}
function isAllNull(){
    var values, index;
    values = $("#policyInfoForm").serializeArray();
    for (index = 0; index < values.length; ++index){
        var controls=document.getElementsByName(values[index].name);
        for(var i=0;i<controls.length;i++){
            if (!$("#"+controls[i].id).is(":hidden")&&values[index].value !=''){
                return 1;//可见输入框存在至少一个框有填数据，暂存校验通过
            }
        }
    }
    return 0;//可见输入框不存在至少一个已填数据的框，暂存校验不通过
}
$(function(){
    $("input[id=need_insur_bill]").on("click",function(){
        if($(this).is(':checked')){
            $("#mod_1").fadeIn(1000);
            $("#mod_1").find("input").each(function(){
                $(this).attr("data-status","");
            });
        }else{
            $("#mod_1").fadeOut(1000);
            $("#mod_1").find("input").each(function(){
                $(this).attr("data-status","hidden");
                $(this).val('');
            });
        }
    });
    $("input[id=need_receipt]").on("click",function(){
        if($(this).is(':checked')){
            $("#mod_2").fadeIn(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
        }else{
            $("#mod_2_3").fadeOut(1000);
            $("#mod_2_2").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2").fadeOut(1000);
            $("#mod_2_3").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2_1").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
        }
    });
    $("input[name='mailPolicyVo.invoice_type']").on("click",function(){
        if($(this).val() == "1"){
            $("#mod_2_1").fadeIn(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2_3").fadeIn(1000);
            $("#mod_2_1").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_3").find("input").each(function(){
                $(this).attr("data-status","");
            });
        }else{
            $("#mod_2_3").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_3").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2_1").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
        }
    });

    $("#recommend_code").on("blur",function(){
        var rCode = $(this).val();
        var pID = $(this).attr("data-relate");
        if(rCode != '' && pID != ''){
            if( pID != ''){
                $.ajax({
                    type: 'POST',
                    url:baseUrl + '/insurance/build/policy/isFeeByrecommend_codeAndProductID.json',
                    data:{
                        'productID':pID,
                        'recommend_code':rCode
                    },
                    dataType:"json",
                    success: function(json){
                        layer.msg(json.message);
                        if(json.statusCode != '200') {
                            $(this).val('');
                        }
                    },
                    error : function(XMLHttpRequest, textStatus, errorThrown) {
                        layer.msg(textStatus);
                    }
                });
            }else{
                layer.msg("数据丢失，请刷新页面重试！");
            }

        }

    });
});
function changeDistrict(districtID, areaID, level, obj) {
    $("#" + districtID).empty();
    if(areaID != '') {
        $("#" + areaID).empty();
        $("#" + areaID).append("<option value=''>--请选择区县--</option>");
    }
    var code = obj.value;
    $.ajax({
        type: 'POST',
        url: baseUrl + '/synopsis/findCity.json',
        data:{"codeLevel":level,"parentCode":code},
        dataType:"json",
        async: false,
        success: function(json) {
            if(level == '2') {
                $("#" + districtID).append("<option value=''>请选择市</option>");
            } else if(level == '3') {
                $("#" + districtID).append("<option value=''>请选择区／县</option>");
            } else {
                $("#" + districtID).append("<option value=''>--请选择--</option>");
            }
            for(var i = 0; i < json.length; i++) {
                var obj = json[i];
                var appendStr = "<option value='" + obj.codes + "' ";
                appendStr = appendStr + ">" + obj.named + "</option>"
                $("#" + districtID).append(appendStr);
            }
        }
    });
}
function clearBase64Byinput(_el){
    var _file_id = _el.id;
    _file_id = _file_id.substring(0,_file_id.length-7);
    if($("#"+_file_id).val() != ''){
        ajaxFormDataDelete(_file_id);
    }
    $("#"+_file_id).val('');
}
function base64convert(_el,_file){
    var flag = false;
    var fileName = _file.name;
    var type = fileName.split(".")[fileName.split(".").length-1];

    var fileKeyName = "/policy/"+fileName;
    var _file_id = _el.attr("name").replace("_file","").trim();
    if($("#"+_file_id).val() != ''){
        ajaxFormDataDelete(_file_id);
    }
    ajaxFormDataLoad(_file,_file_id,"policy/",type);
    flag = true;
    return flag;
}

function ajaxFormDataLoad(file,_id,directoryName,fileType){
    var index = layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
    var _myData = new Date();
    var _times = _myData.getTime();
    var name = "/"+directoryName+_times+"."+fileType;
    var formData = new FormData();
    formData.append('file', file);
    formData.append('fileName', _times+"."+fileType);
    formData.append('directoryName', directoryName);
    var uul = baseUrl + '/file/ajaxFormDataLoad';
    $.ajax({
        type: 'POST',
        url: uul,
        dataType:"json",
        data: formData,
        processData: false,
        contentType: false,
        success: function(result){
            layer.close(index);
            if(result.statusCode == '200'){
                $("#"+_id).val(result.message);
            }else{
                layer.msg(result.message);
            }
        }
    });
}

function ajaxFormDataDelete(_id){
    var formData = new FormData();
    formData.append('url', $("#"+_id).val());
    var uul = baseUrl + '/file/ajaxFormDataDelete';
    $.ajax({
        url: uul,
        type: 'POST',
        cache: false,
        data: formData,
        processData: false,
        contentType: false
    }).done(function(res) {
        $("#"+_id).val('');
    }).fail(function(res) {

    });
}
</script>

<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
</html>