<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <title>保障服务－填写投保单</title>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/application-mod.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/bootstrap.min.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/font-awesome.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/common.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/product.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/newslist.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/fileinput.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/select2.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/jquery.datetimepicker.css' />" />
    <!--[if lt IE 9]>
    <script src="//cdn.bootcss.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="//cdn.bootcss.com/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->
    <style>
        .form-control {
            color: black;
        }
    </style>
</head>
<body style="overflow-y: hidden;">
<jsp:include page="../../../index/multi_h.jsp"/>
<div class="wert" style="position: relative;">
<div class="wer">
<div class="main product-we">

    <div class="row ensure-list mb20">
        <ul>
            <li class="first-Npassbg" style="margin-left:0"><b><label>1</label>填写保险信息</b></li>
            <li class="two-Npassbg" style="margin-left:0"><b><label>2</label>确认投保信息</b></li>
            <li class="three-Npassbg" style="margin-left:0"><b><label>3</label>保费支付</b></li>
            <li class="last-Npassbg" style="margin-left:0"><b><label>4</label>完成投保</b></li>
        </ul>
    </div>
    <div class="row main-title clearfix">
    </div>
    <form class="form-horizontal form-create-item" id="policyInfoForm" action="#" enctype="multipart/form-data" method="post">
        <input name="way" id="way" type="hidden"/>
        <input name="min_limit" id="min_limit" type="hidden" value="500"/>
        <input name="max_limit" id="max_limit" type="hidden" value="3500"/>
        <input name="product_id" id="product_id" value="${product.pro_primary_id}" type="hidden" />

        <div class="row bgf">
            <div class="pd15">
                <div  class="col-sm-10 col-xs-10 col-sm-offset-1 h-title">
                    <h4 id="cy_lxr">
                        <span style="display: inline-block">投保人信息</span>
                    </h4>
                </div>
                <div class="form-group " style="position: static">
                    <label class="col-sm-4 control-label"><strong>*</strong>投保人名称</label>
                    <div class="col-sm-5">
                        <input type="hidden"  name="oid"  id="order_id" value="${vo.oid}">
                        <input type="hidden"  name="roleSubjectList[0].kind"  value="1">
                        <input type="hidden"  name="roleSubjectList[0].oid"  value="${vo.roleSubjectList[0].oid}">
                        <input type="text" id="applicantFullName" name="roleSubjectList[0].name_cn" class="form-control" placeholder="公司名称" value="${vo.roleSubjectList[0].name_cn}" maxlength="100">
                    </div>

                </div>
                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>投保人地址</label>
                    <div class="col-sm-5 div-sel-fapiao">
                        <select Data-Val="Required" title="省" name="roleSubjectList[0].reg_province" id="regProvince" class="sel_ssq" style="width: 120px;float: left;" onchange="javascript:changeDistrict('regCity', '', '2', this);">
                            <option value="">请选择省</option>
                            <c:forEach items="${provinceList }" var="list">
                                <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_province }"> selected="selected"</c:if>>${list.named }</option>
                            </c:forEach>
                        </select>
                        <select Data-Val="Required" title="市" name="roleSubjectList[0].reg_city" id="regCity" class="sel_ssq" style="width: 120px;float: left;margin-left: 17px;" onchange="javascript:changeDistrict('regDistrict', '', '3', this);">
                            <option value="">请选择市</option>
                            <c:forEach items="${cityList }" var="list">
                                <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_city}"> selected="selected"</c:if>>${list.named }</option>
                            </c:forEach>
                        </select>
                        <select Data-Val="Required" title="县" name="roleSubjectList[0].reg_district" id="regDistrict" class="sel_ssq" style="width: 120px;float: right;">
                            <option value="">请选择县</option>
                            <c:forEach items="${areaList }" var="list">
                                <option value="${list.codes }" <c:if test="${vo.roleSubjectList[0].reg_district eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
                            </c:forEach>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-4 control-label"></label>
                    <div class="col-sm-5">
                        <input type="text" id="applicantAddressLines" name="roleSubjectList[0].reg_address" class="form-control" placeholder="请填写具体地址（包含：镇、乡或街道）" value="${vo.roleSubjectList[0].reg_address}" maxlength="200">

                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>联系人</label>
                    <div class="col-sm-5">
                        <input type="text" id="applicantContactName" name="roleSubjectList[0].link_name" class="form-control" placeholder="投保联系人" value="${vo.roleSubjectList[0].link_name}" maxlength="100">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>联系电话</label>
                    <div class="col-sm-5">
                        <input type="text" id="applicantContactPhone" name="roleSubjectList[0].link_phone" class="form-control" placeholder="联系人电话,格式如:15300000000或0592-8888888" value="${vo.roleSubjectList[0].link_phone}" maxlength="20">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>投保人证件类型</label>
                    <div class="help-inline div-sel-fapiao col-sm-8">
                        <select name="roleSubjectList[0].id_type" id="app_id_type" class="sel_fapiao">
                            <option value="7"<c:if test="${vo.roleSubjectList[0].id_type eq '7'}">selected="selected"</c:if> >营业执照</option>
                            <option value="8"<c:if test="${vo.roleSubjectList[0].id_type eq '8'}">selected="selected"</c:if> >税务登记证</option>
                            <option value="9" <c:if test="${vo.roleSubjectList[0].id_type eq '9'}">selected="selected"</c:if>>组织机构代码证</option>
                        </select>
                    </div>

                </div>
                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>投保人证件号码</label>
                    <div class="col-sm-5">
                        <input type="text" name="roleSubjectList[0].organization_code" id="applicantIdNumber" class="form-control" placeholder="请填写证件类型相应证件号码"  value="${vo.roleSubjectList[0].organization_code}" maxlength="50">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>投保人证件扫描件</label>
                    <div class="col-sm-4">
                        <input id="applicantBusinessLicense"  name="roleSubjectList[0].app_business_path"  type="hidden" value="${vo.roleSubjectList[0].app_business_path}"/>
                        <input data-drawview="${vo.roleSubjectList[0].app_business_path}"  placeholder="投保人证件扫描件"   name="applicantBusinessLicense_file"  id="applicantBusinessLicense_file-5" class="file"  type="file" data-allowedFileExtensions="jpg,png,bmp" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
                    </div>
                </div>

                <div  class="col-sm-10 col-xs-10 col-sm-offset-1 h-title">
                    <h4 id="cy_lxr_bb">
                        <span>被保险人信息</span>
                    </h4>
                </div>
                <div class="form-group" style="position: static">
                    <label class="col-sm-4 control-label"><strong>*</strong>被保险人名称</label>
                    <div class="col-sm-5">
                        <input type="hidden"  name="roleSubjectList[1].kind"  value="2">
                        <input type="hidden"  name="roleSubjectList[1].oid"  value="${vo.roleSubjectList[1].oid}">
                        <input type="text" id="insuredFullName" name="roleSubjectList[1].name_cn" class="form-control" placeholder="公司名称" value="${vo.roleSubjectList[1].name_cn}" maxlength="100">
                </div>
            </div>

                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>详细地址</label>
                    <div class="col-sm-5 div-sel-fapiao">
                        <select Data-Val="Required" title="省" name="roleSubjectList[1].reg_province" id="regProvince_1" class="sel_ssq" style="width: 120px;float: left;" onchange="javascript:changeDistrict('regCity_1', '', '2', this);">
                            <option value="">请选择省</option>
                            <c:forEach items="${provinceList }" var="list">
                                <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[1].reg_province }"> selected="selected"</c:if>>${list.named }</option>
                            </c:forEach>
                        </select>
                        <select Data-Val="Required" title="市" name="roleSubjectList[1].reg_city" id="regCity_1" class="sel_ssq" style="width: 120px;float: left;margin-left: 16px;" onchange="javascript:changeDistrict('regDistrict_1', '', '3', this);">
                            <option value="">请选择市</option>
                            <c:forEach items="${reg_city_1_List }" var="list">
                                <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[1].reg_city}"> selected="selected"</c:if>>${list.named }</option>
                            </c:forEach>
                        </select>
                        <select Data-Val="Required" title="县" name="roleSubjectList[1].reg_district" id="regDistrict_1" class="sel_ssq" style="width: 120px;float: left;margin-left: 16px;">
                            <option value="">请选择县</option>
                            <c:forEach items="${reg_area_1_List }" var="list">
                                <option value="${list.codes }" <c:if test="${vo.roleSubjectList[1].reg_district eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
                            </c:forEach>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-4 control-label"></label>
                    <div class="col-sm-5">
                        <input type="text" id="insuredAddressLines" name="roleSubjectList[1].reg_address" class="form-control" placeholder="请填写具体地址（包含：镇、乡或街道）" value="${vo.roleSubjectList[1].reg_address}" maxlength="200">
                    </div>
                </div>

            <%--<div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>被保险人地址</label>
                    <div class="col-sm-5">
                        <input type="text" id="insuredAddressLines" name="roleSubjectList[1].address" class="form-control" placeholder="公司地址" value="${vo.roleSubjectList[1].address}" maxlength="200">
                    </div>
                </div>--%>
                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>联系人</label>
                    <div class="col-sm-5">
                        <input type="text" id="insuredContactName" name="roleSubjectList[1].link_name" class="form-control" placeholder="公司联系人" value="${vo.roleSubjectList[1].link_name}" maxlength="100">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>联系电话</label>
                    <div class="col-sm-5">
                        <input type="text" id="insuredContactPhone" name="roleSubjectList[1].link_phone" class="form-control" placeholder="联系人电话,格式如:15300000000或0592-8888888" value="${vo.roleSubjectList[1].link_phone}" maxlength="20">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>被保人营业性质</label>
                    <div class="col-sm-5">
                        <input type="text" id="businessNature" name="roleSubjectList[1].com_type" class="form-control" placeholder="被保人营业性质" value="${vo.roleSubjectList[1].com_type}">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>被保险人证件类型</label>
                    <div class="help-inline div-sel-fapiao col-sm-8">
                        <select name="roleSubjectList[1].id_type" id="ins_id_type" class="sel_fapiao" >
                            <option value="7" <c:if test="${vo.roleSubjectList[1].id_type eq '7'}">selected="selected"</c:if> >营业执照</option>
                            <option value="8" <c:if test="${vo.roleSubjectList[1].id_type eq '8'}">selected="selected"</c:if>>税务登记证</option>
                            <option value="9"<c:if test="${vo.roleSubjectList[1].id_type eq '9'}">selected="selected"</c:if> >组织机构代码证</option>
                        </select>
                    </div>

                </div>

                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>被保险人证件号码</label>
                    <div class="col-sm-5">
                        <input type="text" name="roleSubjectList[1].organization_code"  id="insuredIdNumber" class="form-control"  value="${vo.roleSubjectList[1].organization_code}" placeholder="请填写证件类型相应证件号码" maxlength="50">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>被保险人证件扫描件</label>
                    <div class="col-sm-4">
                        <input name="roleSubjectList[1].app_business_path" id="insuredBusinessLicense" type="hidden" value="${vo.roleSubjectList[1].app_business_path}"/>
                        <input data-drawview="${vo.roleSubjectList[1].app_business_path}" placeholder="被保险人证件扫描件" name="insuredBusinessLicense_file"  id="insuredBusinessLicense_file-5" class="file" type="file" data-preview-file-type="any" data-upload-url="#" data-preview-file-icon="">
                    </div>
                </div>
                <div  class="col-sm-10 col-xs-10 col-sm-offset-1 h-title">
                    <h4>
                        <span>活动信息</span>
                    </h4>
                </div>






                <div class="clearfix">
                    <label class="col-sm-4 control-label" style="padding-right: 5px;"><strong>*</strong>活动名称：</label>
                    <div class="col-sm-5">
                        <c:if test="${acts.size()<1 || acts == null}">
                            <input type="text" id="policyExtrareportName" name="report_name" class="form-control" placeholder="请输入活动名称" value="${vo.report_name}" maxlength="50">
                        </c:if>
                        <c:if test="${acts.size()>0}">
                            <select id="report_name_help" class="sel_fapiao" onchange="getActivityByPss(this);">
                                <option value="">--请选择--</option>
                                <c:forEach var="act" items="${acts}">
                                    <option value="${act.activity_id}" <c:if test="${act.activity_id eq vo.thr_order_id}">selected="selected"</c:if> >${act.name}</option>
                                </c:forEach>
                            </select>
                            <input type="hidden" id="policyExtrareportName" name="report_name" value="${vo.report_name}">
                            <input type="hidden" id="thr_order_id" name="thr_order_id" value="${vo.thr_order_id}">
                        </c:if>
                    </div>
                </div>


                <div class="clearfix">
                    <label class="col-sm-4 control-label"><strong>*</strong>活动类型 :</label>
                    <input  type="hidden"  id="policyExtraReportActive" name="report_active" value="${fn:split(product.product_code, '-')[2]}">
                    <c:if test="${not empty  product.product_code && fn:split(product.product_code, '-')[2] eq 'ZL'}">
                        <div class="col-sm-5 lh-40">展览展销类活动</div>
                    </c:if>
                    <c:if test="${not empty  product.product_code && fn:split(product.product_code, '-')[2] eq 'WY'}">
                        <div class="col-sm-5 lh-40">文艺演出类活动</div>
                    </c:if>
                    <c:if test="${not empty  product.product_code && fn:split(product.product_code, '-')[2] eq 'TY'}">
                        <div class="col-sm-5 lh-40">体育赛事类活动</div>
                    </c:if>
                    <c:if test="${not empty  product.product_code && fn:split(product.product_code, '-')[2] eq 'QT'}">
                        <div class="col-sm-5 lh-40">其他</div>
                    </c:if>

                </div>

                <div class="clearfix">
                    <label class="col-sm-4 control-label"><strong>*</strong>活动期间 :</label>
                    <div class="col-sm-8 hd-datetime lh-40">
                        <div class="help-block col-sm-3" style="padding-left: 0;">
                            <input type='text'  value="${vo.report_begin_date}" class="date form-control" name="report_begin_date"   id='reportBeginDate'
                                   placeholder="" onblur=" sumDate()"  />
                        </div>
                        <div class="col-sm-1">起</div>
                        <div class="help-block col-sm-3" style="padding-left: 0;">
                            <input type='text'  value="${vo.report_end_date}" class="date form-control" name="report_end_date" id='reportEndDate'
                                   placeholder="" onblur=" sumDate()"  />
                        </div>
                        <div class="col-sm-1">止</div>
                    </div>
                </div>

                <div class="clearfix">
                    <label class="col-sm-4 control-label"><strong>*</strong>承保区域 :</label>
                    <div class="col-sm-5 lh-40">
                        <input type="text" id="policyExtrareportLocal" value="${vo.report_local}" name="report_local" class="form-control" placeholder="请输入承保区域" value="" maxlength="100">
                    </div>
                </div>


                <div class="clearfix">
                    <label class="col-sm-4 control-label"><strong>*</strong>活动地点 :</label>
                    <div class="col-sm-5 lh-40">
                        <ul class="describe-list " style="margin-left:0">
                            <li class="radios">
                                <input type="radio" id="radio-11" style="height:auto" name="activity_local" onclick="premiumCalc()" value="INDOOR"<c:if test="${empty vo.activity_local }">checked="checked"</c:if>  <c:if test="${vo.activity_local eq 'INDOOR'}">checked="checked"</c:if>   />
                                <label for="radio-11">室内场馆</label>
                            </li>
                            <li class="radios">
                                <input type="radio" id="radio-12" style="height:auto" name="activity_local" onclick="premiumCalc()" value="OPEN"  <c:if test="${vo.activity_local eq 'OPEN'}">checked="checked"</c:if>/>
                                <label for="radio-12">露天场馆</label>
                            </li>
                            <li class="radios">
                                <input type="radio" id="radio-13" style="height:auto" name="activity_local" onclick="premiumCalc()" value="OUTDOOR" <c:if test="${vo.activity_local eq 'OUTDOOR'}">checked="checked"</c:if> />
                                <label for="radio-13">户外场馆</label>
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="clearfix">
                    <label class="col-sm-4 control-label"><strong>*</strong>消防情况 :</label>
                    <div class="col-sm-5 lh-40">
                        <ul class="describe-list " style="margin-left:0">
                            <li class="radios">
                                <input type="radio" id="radio-5" style="height:auto" name="activity_fire_fight" value="ACCEPTANCE"  <c:if test="${empty vo.activity_fire_fight }">checked="checked"</c:if> <c:if test="${vo.activity_fire_fight eq 'ACCEPTANCE'}">checked="checked"</c:if>    onclick="premiumCalc();"/>
                                <label for="radio-5"></label>有消防验收
                            </li>
                            <li class="radios">
                                <input type="radio" id="radio-6" style="height:auto" name="activity_fire_fight" value="EXTINGUISHER"   <c:if test="${vo.activity_fire_fight eq 'EXTINGUISHER'}">checked="checked"</c:if> onclick="premiumCalc();"/>
                                <label for="radio-6"></label>无消防验收但配备灭火器
                            </li>

                        </ul>
                    </div>
                </div>

                <div class="clearfix">
                    <label class="col-sm-4 control-label"><strong>*</strong>有无危险环节（如烟花） :</label>
                    <div class="col-sm-5 lh-40">
                        <ul class="describe-list " style="margin-left:0">
                            <li class="radios">
                                <input type="radio" id="radio-3" style="height:auto" name="danger" value="HAVE"  <c:if test="${empty vo.danger }">checked="checked"</c:if>  <c:if test="${vo.danger eq 'HAVE'}">checked="checked"</c:if>  onclick="premiumCalc();"/>
                                <label for="radio-3"></label>有
                            </li>
                            <li class="radios">
                                <input type="radio" id="radio-4" style="height:auto" name="danger" value="WITHOUT"   <c:if test="${vo.danger eq 'WITHOUT'}">checked="checked"</c:if>  onclick="premiumCalc();"/>
                                <label for="radio-4"></label>无
                            </li>
                        </ul>
                    </div>
                </div>

                <div class="clearfix">
                    <label class="col-sm-4 control-label" style="padding-right: 5px;"><strong>*</strong>预计活动参与总人数：</label>
                    <div class="col-sm-5">
                        <input type="number" style="margin-bottom: 10px;" id="policyExtrapeopleNum" name="people_num" value="${vo.people_num}" class="form-control" oninput="limitAmountCalc()" onpropertychange="limitAmountCalc()" placeholder="预计活动参与总人数"  onkeyup='this.value=this.value.replace(/^[0]+[0-9]*$/gi,"")' maxlength="10000000" onmousewheel="return false;">
                    </div>
                </div>

                <div class="clearfix">
                    <label class="col-sm-4 control-label" style="padding-right: 5px;"><strong>*</strong>预计天数：</label>
                    <div class="col-sm-5">
                        <input type="number" readonly="true" id="policyExtraactivityDays" value="${vo.activity_days}" name="activity_days" class="form-control" placeholder="预计天数" value="" maxlength="10000">
                    </div>
                </div>



                <div  class="col-sm-10 col-xs-10 col-sm-offset-1 h-title">
                    <h4>
                        <span>保险方案</span>
                    </h4>
                </div>
                <div class="clearfix">
                    <label class="col-sm-4 control-label">每人每次事故赔偿限额:</label>
                    <div class="col-sm-5">25万元</div>
                </div>
                <div class="clearfix">
                    <label class="col-sm-4 control-label"><strong>*</strong>每次事故及累计赔偿限额:</label>
                    <div class="input-group col-sm-5" style="padding-left: 15px;">
                        <input type="text" class="form-control hintitle" id="policyAmount" value="${vo.insured_amount/10000}" name="insured_amount" placeholder="最小限额为500万元，最大限额为3500万元" onchange="premiumCalc()" onblur="limitAmount(this);" maxlength="1000"/>
                        <div class="input-group-addon">万元</div>
                    </div>
                    <div class="hintmess" id="amountTips" style="bottom: 45px;">“根据预计活动参与总人数，请填写500万（含）至3500万（含）之间的数值”</div>
                </div>

                <div class="clearfix">
                    <label class="col-sm-4 control-label">免赔设定 :</label>
                    <div class="col-sm-5 lh-40">财产损失500元，人身伤害无免赔</div>
                </div>

                <div class="clearfix">
                    <label class="col-sm-4 control-label"><strong>*</strong>保险期间 :</label>
                    <div class="col-sm-8 hd-datetime lh-40">
                        <div class="help-block col-sm-3" style="padding-left: 0;">
                            <input type='text'  class="date form-control" name="inception_date" id='start_datetime'  onblur="premiumCalc()"
                                   placeholder="" value="${vo.inception_date}"  />
                        </div>
                        <div class="col-sm-2">零时起至 </div>
                        <div class="help-block col-sm-3" style="padding-left: 0;">
                            <input type='text' class="date form-control" name="planned_end_date" id='end_datetime'  onblur="premiumCalc()"
                                   placeholder="" value="${vo.planned_end_date}" />
                        </div>
                        <div class="col-sm-2">二十四时止</div>
                    </div>
                </div>

                <div class="clearfix">
                    <label class="col-sm-4 control-label">总保险费 :</label>
                    <div class="col-sm-5 lh-40 c-fc6d04" id="premiumDiv"></div>
                    <input type="hidden" name="premium"  id="premium" value="${vo.premium}">
                </div>
                <div  class="col-sm-10 col-xs-10 col-sm-offset-1 h-title clearfix">
                    <h4>
                        <span>附加条款</span>
                    </h4>
                </div>
                <div class="col-sm-8 col-xs-8 col-sm-offset-2 clause-text">
                    <p><span>【赔偿限额同主条款】</span></p>
                    <p>下列附加条款适用于本保险单的各个部分，若其与本保险单的其他规定相冲突，则以下列附加条款为准。</p>
                    <ul style="margin-left: 20px;">
                        <li style="list-style: inside;">交叉责任条款</li>
                        <li style="list-style: inside;">罢工、暴乱、民众骚动及恶意破坏条款</li>
                        <li style="list-style: inside;">火灾和爆炸责任条款</li>
                        <li style="list-style: inside;">急救费用条款</li>
                        <li style="list-style: inside;">广告及装饰装置责任条款</li>
                    </ul>
                </div>
                <div  class="col-sm-10 col-xs-10 col-sm-offset-1 h-title clearfix">
                    <h4>
                        <span>争议处理</span>
                    </h4>
                </div>
                <div class="col-sm-8 col-xs-8 col-sm-offset-2 clause-text">
                    <p>若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：
                    <div class="ct-sub">
                        <ul class="describe-list " style="margin-left: 0;">
                            <li class="radios">
                                <input type="radio" id="dradio-5" name="dispute" <c:if test="${empty vo.dispute || vo.dispute eq '0'}">checked="checked"</c:if>   value="0"  />
                                <label for="dradio-5"></label>诉讼
                            </li>
                            <li class="radios">
                                <input type="radio" id="dradio-6" name="dispute" <c:if test="${vo.dispute eq '1'}">checked="checked"</c:if>   value="1"/>
                                <label for="dradio-6"></label>仲裁
                            </li>
                            <li  <c:if test="${empty vo.policy_extra_dispute}">style="display: none;" </c:if>>
                                <span class="pull-left  mt10">仲裁机构</span>
                                <span class="pull-left"><input type="text" name="policy_extra_dispute" value="${vo.policy_extra_dispute}" class="form-control" placeholder=""></span>
                            </li>
                        </ul>

                    </div>
                </div>
            </div>
        </div>

        <%--<div class="row main-title clearfix mt20">
            <div class="main-title-name pull-left">寄送信息<span class="fs12">( 输入保单、发票的收件地址信息)</span></div>
        </div>--%>
        <div class="row bgf mb20">
            <div class="pd15">
                <div  class="col-sm-10 col-xs-10 col-sm-offset-1 h-title clearfix">
                    <h4>
                        <span>寄送信息<%--( 输入保单、发票的收件地址信息)--%></span>
                    </h4>
                </div>
                <div class="form-group">
                    <label class="col-sm-4 control-label">寄送信息</label>
                    <div class=" col-sm-5">
                        <div class="checkbox-group">
                            <label class="mt10">
                                <input type="checkbox" name="mailPolicyVo.need_insur_bill"  value="1" checked="checked" disabled="disabled"> 纸质保单
                            </label>
                        </div>
                        <div class="checkbox-group">
                            <label class="mt10">
                                <input type="checkbox" name="mailPolicyVo.need_receipt"  id="invoice" <c:if test="${ empty vo.mailPolicyVo.need_receipt ||vo.mailPolicyVo.need_receipt eq '0'}"> value="0"</c:if> <c:if test="${not empty vo.mailPolicyVo.need_receipt &&vo.mailPolicyVo.need_receipt eq '1'}">checked="checked" value="1"</c:if>  onclick="showinvoice();" > 发票
                            </label>
                            <div class="help-inline div-sel-fapiao hidden" id="fapiaoDiv">
                                <select name="mailPolicyVo.invoice_type" id="invoiceInfo" class="sel_fapiao" onchange="showInvoiceInfo(this.value)">
                                    <option value="0" <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0'}">checked="checked"</c:if>>增值税普通发票</option>
                                    <option value="1" <c:if test="${not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '1'}">checked="checked"</c:if>>增值税专用发票</option>
                                </select>
                            </div>
                        </div>
                        <div class="help-block">
                            <div class="bg-success bg-success2 pd10">
                                <strong><i class="icon-minus-sign"></i> 温馨提示</strong>
                                <p class="fs12">
                                    注：以下信息为您创建项目提交的信息，请仔细核对信息是否有误，以免因开票信息错误给贵司带来损失！
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>收件人姓名</label>
                    <div class="col-sm-5">
                        <input type="text" id="mailPolicyTicketName" name="mailPolicyVo.receiver_name" class="form-control" placeholder="" value="${vo.mailPolicyVo.receiver_name}" maxlength="100">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>收件人电话</label>
                    <div class="col-sm-5">
                        <input type="text" id="mailPolicyTicketPhone" name="mailPolicyVo.receiver_mobile" class="form-control" placeholder="电话格式如:15300000000或0592-8888888" value="${vo.mailPolicyVo.receiver_mobile}" maxlength="20">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>收件地址</label>
                    <div class="col-sm-5">
                        <input type="text" id="mailPolicyTicketAddress" name="mailPolicyVo.receiver_address_detail" class="form-control" placeholder="" value="${vo.mailPolicyVo.receiver_address_detail}" maxlength="200">
                    </div>
                </div>

                <div class="form-group">
                    <label class="col-sm-4 control-label"><strong>*</strong>纳税人识别号</label>
                    <div class="col-sm-5">
                        <input type="text" id="mailPolicyTaxpayerNumberInvoice" name="mailPolicyVo.taxpayer_number_invoice" class="form-control" placeholder="企业《税务登记证》编号" value="${vo.mailPolicyVo.taxpayer_number_invoice}" maxlength="50">
                    </div>
                </div>

                <div  id="vatInvoice" style="display:none;" >
                    <div class="form-group">
                        <label class="col-sm-4 control-label"><strong>*</strong>单位名称</label>
                        <div class="col-sm-5">
                            <input type="text" id="mailPolicyCompanyNameInvoice" name="mailPolicyVo.receipt_head" class="form-control" placeholder="必须是您公司营业执照上的全称" value="${vo.mailPolicyVo.receipt_head}" maxlength="100">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-4 control-label"><strong>*</strong>注册地址</label>
                        <div class="col-sm-5">
                            <input type="text" id="mailPolicyRegisterAddressInvoice" name="mailPolicyVo.register_address_invoice" class="form-control" placeholder="" value="${vo.mailPolicyVo.register_address_invoice}" maxlength="200">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 control-label"><strong>*</strong>电话</label>
                        <div class="col-sm-5">
                            <input type="text" id="mailPolicyContactPhoneInvoice" name="mailPolicyVo.receipt_phone" class="form-control" placeholder="请提供能与您公司保持联系的有效电话" value="${vo.mailPolicyVo.receipt_phone}" maxlength="20">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 control-label"><strong>*</strong>开户银行</label>
                        <div class="col-sm-5">
                            <input type="text" id="mailPolicyBankInvoice" name="mailPolicyVo.bank_invoice" class="form-control" placeholder="必须是您公司银行开户许可证上的开户银行" value="${vo.mailPolicyVo.bank_invoice}" maxlength="100">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 control-label"><strong>*</strong>银行账号</label>
                        <div class="col-sm-5">
                            <input type="text" id="mailPolicyBankAccountInvoice" name="mailPolicyVo.bank_account_invoice" class="form-control" placeholder="必须是您公司银行开户许可证上的银行账号" value="${vo.mailPolicyVo.bank_account_invoice}" maxlength="100">
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="col-sm-4 control-label"><strong>*</strong>税务登记证</label>
                        <div class="col-sm-4">

                            <input type="hidden" title="" name="mailPolicyVo.tax_cert" id="tax_cert" value="${vo.mailPolicyVo.tax_cert }">
                            <input title="" value="${vo.mailPolicyVo.tax_cert }" name="tax_cert_file" id="tax_cert_file-5" data-drawview="${vo.mailPolicyVo.tax_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 control-label"><strong>*</strong>一般纳税人证明</label>
                        <div class="col-sm-4">
                            <input type="hidden" title="" name="mailPolicyVo.tax_prove" id="tax_prove" value="${vo.mailPolicyVo.tax_prove }">
                            <input title="" value="${vo.mailPolicyVo.tax_prove }" name="tax_prove_file" id="tax_prove_file-5" data-drawview="${vo.mailPolicyVo.tax_prove }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 control-label"><strong>*</strong>银行开户许可证</label>
                        <div class="col-sm-4">
                            <input type="hidden" title="" name="mailPolicyVo.bank_licence" id="bank_licence" value="${vo.mailPolicyVo.bank_licence }">
                            <input title="" value="${vo.mailPolicyVo.bank_licence }" name="bank_licence_file" id="bank_licence_file-5" data-drawview="${vo.mailPolicyVo.bank_licence}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 control-label"><strong>*</strong>营业执照副本</label>
                        <div class="col-sm-4" >
                            <input type="hidden" title="" name="mailPolicyVo.business_license" id="business_license" value="${vo.mailPolicyVo.business_license }">
                            <input title="" value="${vo.mailPolicyVo.business_license }" name="business_license_file" id="business_license_file-5" data-drawview="${vo.mailPolicyVo.business_license}"  class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-sm-4 control-label">增票授权委托书</label>
                        <div class="col-sm-4">
                            <input type="hidden" title="" name="mailPolicyVo.auth_cert" id="auth_cert" value="${vo.mailPolicyVo.auth_cert}">
                            <input title="" value="${vo.mailPolicyVo.auth_cert }" name="auth_cert_file" id="auth_cert_file-5" data-drawview="${vo.mailPolicyVo.auth_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">

                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-sm-4 fs12 col-sm-offset-4 c-2e9fe3">
                            <p>注:付款人与受票人不一致时，需提供此委托书<a target="_blank" href="<c:url value='/resources/files/增票授权委托书.doc' />">委托书模板下载</a></p>
                        </div>
                    </div>
                </div>

                <div class="form-group col-sm-9">

                    <div class="col-sm-4 col-sm-offset-4">
                        <a href="javascript:void(0);" onclick="savePolicyAfrPedding();" id="pendingInfo" class="btn btn-lightblue btn-block">暂存</a>
                    </div>
                    <div class="col-sm-4">
                       <%-- <a href="javascript:void(0);" onclick="saveGMRInfo();" id="pendingInfo" class="save">暂存本页</a>
                        <a href="javascript:void(0);" onclick="save_policy_gmr();" class="ns-btn">下一步</a>--%>
                        <a class="btn btn-lightblue btn-block" id="btn_policy" onclick="save_policy_afr();">下一步</a>
                    </div>
                </div>
            </div>
        </div>
    </form>
</div>
</div>
</div>
<jsp:include page="../../../index/multi_f.jsp"/>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.form.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/layer.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/enter.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/select2.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/jquery.datetimepicker.full.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/footerwarp.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/version_new/js/popup-bottom.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>

<script>
    $(function () {
        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas({sys_client_user_id: '${userdetail.oid}'},'/pc/commonApplicant/company/query',false,false,function(json){
            var str = "";
            if (json.length > 0){
                for (var i = 0; i < json.length; i++) {
                    str += '<li><p data-text="' + JSON.stringify(json[i]).replace(/"/ig,'\'') + '">' + json[i].company_name + '</p></li>';
                }
            }
            if(str != ""){
                var lxr_html = '<div class="contacts_modal"><h2 class="contacts-title">选择常用投保人<span class="title-cancel"><i class="glyphicon glyphicon-remove"></i></span></h2><ul id="userList"></ul><div class="contacts-bottom"><span class="sure">填入</span>&nbsp;<span class="cancel">取消</span></div></div><div class="black-mask"></div>';
                $('body').append(lxr_html);
                $("#userList").html(str);
                addCylxr();
            }
        });
        function addCylxr(){
            //点击联系人
            $('.contacts_modal ul li').click(function () {
                $('.contacts_modal ul li').removeClass('active');
                $(this).addClass('active');
                if(!$('.contacts-bottom .sure').hasClass('sure_color')){
                    $('.contacts-bottom span.sure').addClass('sure_color');
                }
            });
            //点击取消
            $('.contacts-bottom .cancel').click(function () {
                $('.contacts_modal').hide();
                $('.black-mask').hide();
                $('.contacts_modal ul li').removeClass('active');
            });
            $('.contacts_modal .title-cancel').click(function () {
                $('.contacts_modal').hide();
                $('.black-mask').hide();
                $('.contacts_modal ul li').removeClass('active');
            });
            //点击填入
            $('.contacts-bottom .sure').click(function () {
                if($(this).hasClass('sure_color')){
                    setTBR($('.contacts_modal ul li.active').find('p').attr('data-text'));
                    $('.contacts_modal').hide();
                    $('.black-mask').hide();
                    $('.contacts_modal ul li').removeClass('active');
                }else{
                    //没有点击选择联系人
                    // alert('请选择一个联系人！');
                }
            })
            var _html = '<span style="display: inline-block">投保人信息</span><a href="javascript:;" style="float: right;margin-right: 16px;font-size: 14px;" onclick="showContractsModals(\'1\')">选择常用投保人</a>';
            var _html_bb = '<span style="display: inline-block">被保险人信息</span><a href="javascript:;" style="float: right;margin-right: 16px;font-size: 14px;" onclick="showContractsModals(\'2\')">选择常用投保人</a>';
            $("#cy_lxr").html(_html);
            $("#cy_lxr_bb").html(_html_bb);
        }
        function setTBR(_json){
            var _sg = $('.contacts-bottom .sure').attr('data-sg');
            var json = eval("(" + _json + ")");
            if(_sg == '1'){//设置投保人
                $("#applicantFullName").val(json.company_name);//企业名称
                $("#app_id_type").val(json.certificate_type == '7' ? '7' : json.certificate_type == '1' ? '9' : json.certificate_type == '6' ? '8' : '');//证件类型
                $("#app_id_type").change();
                if(json.certificate_code != ''){
                    var cccode = json.certificate_code;
                    if(json.certificate_type == '1'){
                        cccode = json.certificate_code.substring(0,json.certificate_code.length-1)+'-'+json.certificate_code.substring(json.certificate_code.length-1,json.certificate_code.length);
                    }
                    $("#applicantIdNumber").val(cccode);//证件号码
                }
                $("#applicantAddressLines").val(json.address);//详细地址
                $("#regProvince").val(json.province);//省
                $("#regProvince").change();
                setTimeout(function(){
                    $("#regCity").val(json.city);//市
                    $("#regCity").change();
                    setTimeout(function(){
                        $("#regDistrict").val(json.district);//区
                        $("#regDistrict").change();
                    },1000);
                },1000);
                $("#applicantContactName").val(json.user_name);//联系人
            }else if(_sg == '2'){//设置被保险人
                $("#insuredFullName").val(json.company_name);//企业名称
                $("#ins_id_type").val(json.certificate_type == '7' ? '7' : json.certificate_type == '1' ? '9' : json.certificate_type == '6' ? '8' : '');//证件类型
                $("#ins_id_type").change();
                if(json.certificate_code != ''){
                    var cccode = json.certificate_code;
                    if(json.certificate_type == '1'){
                        cccode = json.certificate_code.substring(0,json.certificate_code.length-1)+'-'+json.certificate_code.substring(json.certificate_code.length-1,json.certificate_code.length);
                    }
                    $("#insuredIdNumber").val(cccode);//证件号码
                }
                $("#insuredAddressLines").val(json.address);//详细地址
                $("#regProvince_1").val(json.province);//省
                $("#regProvince_1").change();
                setTimeout(function(){
                    $("#regCity_1").val(json.city);//市
                    $("#regCity_1").change();
                    setTimeout(function(){
                        $("#regDistrict_1").val(json.district);//区
                        $("#regDistrict_1").change();
                    },1000);
                },1000);
                $("#insuredContactName").val(json.user_name);//联系人
            }

        }

        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas('','/pc/tb-mail-address/${userdetail.oid}',false,false,function(json){
            if(json != undefined && json != null){
                if('${dto.oid}' == ''){
                    $('#need_insur_bill').on('click',function(){//纸质发票
                        if($(this).is(":checked")){
                            $("#receiverName").val(json.user_name);
                            $("#receiverMobile").val(json.telephone);
                            $("#receiverAddressDetail").val(json.address);
                        }
                    });
                    $('#need_receipt').on('click',function(){//电子发票
                        if($(this).is(":checked")){
                            $("#takerName").val(json.user_name);
                            $("#takerMobile").val(json.telephone);
                            $("#takerAddressDetail").val(json.address);
                        }
                    });
                }
            }

        });
    })
    //点击弹窗出现
    function showContractsModals(_sg) {
        console.log(12312321);
        $('.contacts_modal').show();
        $('.black-mask').show();
        $('.contacts-bottom .sure').attr('data-sg',_sg);
    }

</script>
<script type="text/javascript">

    var baseUrl = '${pageContext.request.contextPath }';
    premiumCalc();

    $('#invoice').click(function () {
        if($("input[type='checkbox']#invoice").is(':checked')){
            $(this).val('1');
        }else{
            $(this).val('0');
        }
    })

    $(function(){
        $(".hintitle").hover(function(){
            $(".hintmess").toggle();
        })
    });

    $(function (){
        if(self==top){//不存在iframe
            $("body").attr("style","");
        }
        var minlimit = "500";
        var rate = 2000*100/minlimit;
        $("rateDiv").html(rate);

        $('.sel_fapiao').select2({width: "180",minimumResultsForSearch: -1});
        $('.sel_ssq').select2({width: "150",minimumResultsForSearch: -1});
        $('.sel_activity').select2({width: "180",minimumResultsForSearch: -1});
    });

    $.datetimepicker.setLocale('ch');
    $('#start_datetime').datetimepicker({
        lang:'ch',
        format : "Y-m-d",//日期格式
        timepicker:false,
        scrollMonth:false,
        scrollTime:false,
        scrollInput:false,
        onShow:function( ct ){
            this.setOptions({
                maxDate:jQuery('#end_datetime').val()?jQuery('#end_datetime').val():false
            });
        }
    });
    $('#end_datetime').datetimepicker({
        lang:'ch',
        format:'Y-m-d',
        timepicker:false,
        scrollMonth:false,
        scrollTime:false,
        scrollInput:false,
        onShow:function( ct ){
            this.setOptions({
                minDate:jQuery('#start_datetime').val()?jQuery('#start_datetime').val():false
            })
        }
    });


    $('#reportBeginDate').datetimepicker({
        lang:'ch',
        format:'Y-m-d H:i',
        step:30,
        startDate:new Date(),
        scrollMonth:false,
        scrollTime:false,
        scrollInput:false,
        onShow:function( ct ){
            this.setOptions({
                maxDate:jQuery('#reportEndDate').val()?jQuery('#reportEndDate').val():false
            });
        }
    });
    $('#reportEndDate').datetimepicker({
        lang:'ch',
        format:'Y-m-d H:i',
        step:30,
        scrollMonth:false,
        scrollTime:false,
        scrollInput:false,
        onShow:function( ct ){
            this.setOptions({
                minDate:jQuery('#reportBeginDate').val()?jQuery('#reportBeginDate').val():false
            })
        }
    });


    function  savePolicyAfrPedding(){
//        var result = formcheck('1');
//        if(result){
            var index = parent.layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            $.ajax({
                type: 'POST',
                url:baseUrl + '/insurance/afr/policy/pendingAFRPolicyVoPolicy',
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    parent.layer.msg(json.message);
                    parent.layer.close(index);
                    var productId=$("#product_id").val();
                    window.location =baseUrl+"insurance/afr/policy/policyUpdInit/"+productId+"/"+json.navTabId+"?ACCESS_TOKEN=${ACCESS_TOKEN}";

                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    parent.layer.close(index);
                }
            });
       // }
    }
    function  save_policy_afr(){
        var result = doformcheck('1');
        if(result == 1){
            var index = parent.layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});

            $.ajax({
                type: 'POST',
                url:baseUrl + 'insurance/afr/policy/pendingAFRPolicyVoPolicy',
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    parent.layer.close(index);
                    //parent.layer.msg(json.message);
                    if(json.statusCode == '200') {
                        window.location.href = baseUrl + 'insurance/afr/policy/policy/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    parent.layer.close(index);
                    //parent.layer.msg(textStatus);
                }
            });
        }
    }


    function showInvoiceInfo(selectValue) {
        if(selectValue=='0') {
            $("#vatInvoice").hide();
            $('#frame3d',parent.document).css("height",3115+'px');
        } else if(selectValue=='1') {
            $('#frame3d',parent.document).css("height",4750+'px');

            $("#vatInvoice").show();
        }
    }

    $("#policyExtrapeopleNum")[0].addEventListener('DOMMouseScroll', MouseWheel, false);
    function MouseWheel(event) {
        event = event || window.event;
        event.preventDefault();
    }

    $("#policyAmount").keyup(function () {
        var reg = $(this).val().match(/\d+\.?\d{0,2}/);
        var txt = '';
        if (reg != null) {
            txt = reg[0];
        }
        $(this).val(txt);
    }).change(function () {
        $(this).keypress();
        var v = $(this).val();
        if (/\.$/.test(v))
        {
            $(this).val(v.substr(0, v.length - 1));
        }
    });

    $('#invoice').click(function(){
        if($('#invoiceInfo').prop("checked"))
        {

        }
        else{
            $("#vatInvoice").hide();
            $('#frame3d',parent.document).css("height",3165+'px');
        }

    });

    window.onload = function () {
        $('#frame3d',parent.document).css("height",3165+'px');
        var  invoice='${vo.mailPolicyVo.need_receipt}';

        if(invoice){
            if(invoice=='1'){
                var  invoiceInfo= '${vo.mailPolicyVo.invoice_type}';
                if(invoiceInfo){
                    $('#fapiaoDiv').removeClass('hidden');
                    if(invoiceInfo == '1') {

                        $("#invoiceInfo option:last").prop("selected", 'selected');
                        $('#select2-chosen-5').text('增值税专用发票（纸质发票）');
                        showInvoiceInfo(invoiceInfo);
                    }
                }
            }
        }

    }
//    window.onbeforeunload=function(){
//        $('#frame3d',parent.document).css("height",2676+'px');
//    }
    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/policy/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"policy/",type);
        flag = true;
        return flag;
    }

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = layer.load(0, {shade: [0.3,'#808080']});
        var _myData = new Date();
        var _times = _myData.getTime();
        var name = "/"+directoryName+_times+"."+fileType;
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', _times+"."+fileType);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoad';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                layer.close(index);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                }else{
                    layer.msg(result.message);
                }
            }
        });
    }
    function changeDistrict(districtID, areaID, level, obj) {
        $("#" + districtID).empty();
        if(areaID != '') {
            $("#" + areaID).empty();
            $("#" + areaID).append("<option value=''>--请选择区县--</option>");
        }
        var code = obj.value;
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findCity.json',
            data:{"codeLevel":level,"parentCode":code},
            dataType:"json",
            async: false,
            success: function(json) {
                if(level == '2') {
                    $("#" + districtID).append("<option value=''>请选择市</option>");
                } else if(level == '3') {
                    $("#" + districtID).append("<option value=''>请选择区／县</option>");
                } else {
                    $("#" + districtID).append("<option value=''>--请选择--</option>");
                }
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + districtID).append(appendStr);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }

    function getActivityByPss(obj){
        var thr_order_id = obj.value;
        if(thr_order_id != ''){
            $.ajax({
                type: 'POST',
                url: baseUrl + '/insurance/afr/policy/getActivityByPss/'+thr_order_id,
                dataType:"json",
                success: function(json) {
                    if(json != undefined && json != '' && json != null){
                        $("#policyExtrareportName").val(json.name);
                        $("#thr_order_id").val(json.activity_id);
                        $("#reportBeginDate").val(json.startDate);
                        $("#reportEndDate").val(json.endDate);
                        $("#policyExtrareportLocal").val(json.address);
                        $("#policyExtrapeopleNum").val(json.peakNum);
                        $("input:radio[name='activity_local']").each(function(){
                            if(this.value == json.addressType){
                                $(this).attr("checked",true);
                            }
                        });
                        sumDate();
                        if(json.invoiceExpressMode != '0'){
                            if(!$('#invoice').is(':checked')) {//没选中
                                $('#invoice').attr("checked",true);
                                showinvoice();
                            }
                            var _invoice = '0';
                            if(json.invoiceExpressMode == '1'){//普票
                                _invoice = '0';
                            }
                            $("#mailPolicyTicketName").val(json.ticketName);
                            $("#mailPolicyTicketPhone").val(json.ticketPhone);
                            $("#mailPolicyTicketAddress").val(json.ticketAddress);
                            $("#mailPolicyTaxpayerNumberInvoice").val(json.taxpayerNumberInvoice);
                            if(json.invoiceExpressMode == '2'){//专票票
                                _invoice = '1';
                                $("#mailPolicyCompanyNameInvoice").val(json.companyNameInvoice);
                                $("#mailPolicyRegisterAddressInvoice").val(json.registerAddressInvoice);
                                $("#mailPolicyContactPhoneInvoice").val(json.contactPhoneInvoice);
                                $("#mailPolicyBankInvoice").val(json.bankInvoice);
                                $("#mailPolicyBankAccountInvoice").val(json.bankAccountInvoice);
                            }
                            $("#invoiceInfo option[value='"+_invoice+"']").attr("selected", true);
                            $('#fapiaoDiv').removeClass('hidden');
                            if(_invoice == '1') {
                                $('#select2-chosen-6').text('增值税专用发票');
                            }else{
                                $('#select2-chosen-6').text('增值税普通发票');
                            }

                            showInvoiceInfo(_invoice);

                        }else{
                            if($('#invoice').is(':checked')) {
                                $('#invoice').attr("checked",false);
                                showinvoice();
                            }
                        }
                    }else{

                    }
                }
            });
        }else{
            $("#policyExtrareportName").val('');
            $("#thr_order_id").val('');
        }
    }

</script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
</body>

</html>
