<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<meta name="keywords" content="百联保、保险、保函、履约保函、投标保函、工程保函、诉讼保全、诉讼保全保险、财产保全、担保、保安意外险、员工保险、公众责任险、展会责任险">
	<meta name="description" content="百联保是专业的企业保险、垂直领域定制保险平台，为建设工程、公共安全、法律诉讼、贸易信用、金融创新、企业管理等领域提供互联网金融保险综合解决方案，有竞争力的价格、可信赖的保险品牌、便捷的操作流程、一站式管家服务 ">
	<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
	<title>百联保保险平台-企业保险、垂直领域定制保险平台</title>
	<style>
		.layer_notice {
			float: left;
			min-height: 180px;
			width: 350px;
			overflow: hidden;
			/*background: #ff6600;*/
			padding: 10px;
			/*color: #ffffff;*/
		}

	</style>
</head>
<body>
<jsp:include page="multi_h.jsp"/>
<!--轮播图-->
<div class="bigPic swiper-container">
	<div class="swiper-wrapper bigPic-con">
		<div class="swiper-slide">
			<a href="javascript:;">
				<img src="<c:url value='/resources/version_new/images/icon-s1.png' />"/>
			</a>
		</div>
		<div class="swiper-slide">
			<a href="javascript:;">
				<img src="<c:url value='/resources/version_new/images/icon-s2.png' />"/>
			</a>
		</div>
		<div class="swiper-slide">
			<a href="javascript:;">
				<img src="<c:url value='/resources/version_new/images/icon-s3.png' />"/>
			</a>
		</div>
		<%--<div class="swiper-slide">--%>
			<%--<a href="javascript:;">--%>
				<%--<img src="<c:url value='/resources/version_new/images/icon-s4.png' />"/>--%>
			<%--</a>--%>
		<%--</div>--%>
	</div>
	<!-- 如果需要分页器 -->
	<div class="pagination"></div>
	<!--<div class="swiper-pagination"></div>-->
	<!-- 如果需要导航按钮 -->
	<div class="swiper-button-prev"></div>
	<div class="swiper-button-next"></div>
	<div class="shuffling">
		<div class="shuffling-content clearfix">
			<div class="shuffling-left fl">
				<ul>
					<li>
						<span class="on">建筑工程</span>
					</li>
					<li>
						<span>法律诉讼</span>
					</li>
					<li>
						<span>贸易信用</span>
					</li>
					<li>
						<span>公众安全</span>
					</li>
					<li>
						<span>企业保险</span>
					</li>
					<%--<li>
						<span>融资借贷</span>
					</li>--%>
					<%--<li>
						<span>海关关税</span>
					</li>--%>
					<li class="line-none">
						<span>个人保险</span>
					</li>
				</ul>
			</div>
			<%-- 1 --%>
			<div class="shuffling-right fr">
				<div class="right-content">
					<div class="contents">
						<a href="javascript:;">
							<h3><a href="<c:url value='/insurance/product/productInfo/1001013?ACCESS_TOKEN=${ACCESS_TOKEN}' />">太平洋投标保证保险保函</a></h3>
							<div class="content-s1 clearfix">
								<div class="s1-describe fl">
									<p>新型工程投标担保 <br>降低投标成本<br> 自动核保<br> 即刻生效<br>在线出单<br> 电子保函</p>
								</div>
								<div class="s1-pic fr"></div>
							</div>
						</a>
						<a href="javascript:;" >
							<h3 hidden="hidden"><a href="<c:url value='/insurance/product/productInfo/1001014?ACCESS_TOKEN=${ACCESS_TOKEN}' />">工程履约保证保险</a></h3>
							<div class="content-s1 clearfix" hidden="hidden">
								<div class="s1-describe fl">
									<p>保险担保形式  <br>缓解企业资金负担  <br>线上投保  <br>简单便捷  <br>定价合理  <br>性价比高</p>
								</div>
								<div class="s2-pic fr"></div>
							</div>
						</a>
<%--
						<a href="javascript:;" class="wed clearfix">查看更多保险类型<i></i></a>
--%>
					</div>
				</div>
				<%-- 2 --%>
				<div class="right-content s-none">
					<div class="contents">
						<a href="javascript:;">
							<h3><a href="<c:url value='/insurance/product/productInfo/1001015?ACCESS_TOKEN=${ACCESS_TOKEN}' />">诉讼财产保全责任保险</a></h3>
							<div class="content-s1 clearfix">
								<div class="s1-describe fl">
									<p>创新担保形式<br> 减轻担保压力<br> 在线办理 <br>当日可出保函 <br>法院认可 <br>提高诉讼时效</p>
								</div>
								<div class="s3-pic fr"></div>
							</div>
						</a>

					</div>
				</div>
				<%-- 3 --%>
				<div class="right-content s-none">
					<div class="contents">
						<h3>产品开发中...</h3>
						<%--<h3><a href="<c:url value='/insurance/product/productInfo/1001012' />">小微企业出口信用保险</a></h3>--%>
						<%--<div class="content-s1 clearfix">--%>
							<%--<div class="s1-describe fl">--%>
								<%--<p>防范出口信用风险 <br>助力企业开拓新市场 <br>小微企业零费用先承保 <br>政策扶持<br> 企业受惠</p>--%>
							<%--</div>--%>
							<%--<div class="s4-pic fr"></div>--%>
						<%--</div>--%>
						<%--<h3><a href="<c:url value='/insurance/product/productInfo/1001011' />">短期出口信用保险</a></h3>--%>
						<%--<div class="content-s1 clearfix">--%>
							<%--<div class="s1-describe fl">--%>
								<%--<p>方案活<br> 保障足 <br>适合各类出口企业 <br>全程信用及收账管理服务<br> 安全可靠<br> 快速理赔 <br>全球追偿</p>--%>
							<%--</div>--%>
							<%--<div class="s5-pic fr"></div>--%>
						<%--</div>--%>
<%--
						<a href="javascript:;" class="clearfix">查看更多保险类型<i></i></a>
--%>
					</div>
				</div>
				<%-- 4 --%>
				<div class="right-content s-none">
					<div class="contents">
						<h3>产品开发中...</h3>
						<%--<a href="<c:url value='/synopsis/product/productAllView?pro_type=GZX' />">
							<h3>大型活动公众责任保险</h3>
							<div class="content-s1 clearfix">
								<div class="s1-describe fl">
									<p>管控承办方风险 <br>人员财产保障充足<br> 方案多样 <br>保费低廉 <br>轻松线上投保 <br>安心活动举办</p>
								</div>
								<div class="s6-pic fr"></div>
							</div>
						</a>--%>
						<%--<a href="javascript:;">--%>
							<%--<h3>工程履约保证保险</h3>--%>
							<%--<div class="content-s1 clearfix">--%>
								<%--<div class="s1-describe fl">--%>
									<%--<p>建设合同履约保证保险，指保险公--%>
										<%--司向建设工程发包人提供的保证承--%>
										<%--包人履行建设合同义务的保险。</p>--%>
								<%--</div>--%>
								<%--<div class="s2-pic fr"></div>--%>
							<%--</div>--%>
						<%--</a>--%>
						<%--<a href="javascript:;" class="wed clearfix">查看更多保险类型<i></i></a>--%>
					</div>
				</div>
				<%-- 5 --%>
				<div class="right-content s-none">
					<div class="contents">
						<a href="<c:url value='/synopsis/product/productAllView?pro_type=TYX&ACCESS_TOKEN=${ACCESS_TOKEN}' />">
							<h3>团体意外保险</h3>
							<div class="content-s1 clearfix">
								<div class="s1-describe fl">
									<p>平台定制<br> 保费低廉<br>保障额度 <br>按需选择<br> 在线投保 <br>快捷省心 <br>	人员变更 <br>	一键搞定 </p>
								</div>
								<div class="s7-pic fr"></div>
							</div>
						</a>
						<%--<a href="javascript:;">--%>
							<%--<h3>工程履约保证保险</h3>--%>
							<%--<div class="content-s1 clearfix">--%>
								<%--<div class="s1-describe fl">--%>
									<%--<p>建设合同履约保证保险，指保险公--%>
										<%--司向建设工程发包人提供的保证承--%>
										<%--包人履行建设合同义务的保险。</p>--%>
								<%--</div>--%>
								<%--<div class="s2-pic fr"></div>--%>
							<%--</div>--%>
						<%--</a>--%>
						<%--<a href="javascript:;" class="wed clearfix">查看更多保险类型<i></i></a>--%>
					</div>
				</div>
				<%-- 6 --%>
				<div class="right-content s-none">
					<div class="contents">
						<a href="javascript:;">
							<h3>产品开发中...</h3>
						</a>
					</div>
				</div>
				<%-- 7 --%>
				<div class="right-content s-none">
					<div class="contents">
						<a href="javascript:;">
							<h3>产品开发中...</h3>
						</a>
					<%--	<a href="javascript:;">
							<h3>工程履约保证保险</h3>
							<div class="content-s1 clearfix">
								<div class="s1-describe fl">
									<p>建设合同履约保证保险，指保险公
										司向建设工程发包人提供的保证承
										包人履行建设合同义务的保险。</p>
								</div>
								<div class="s2-pic fr"></div>
							</div>
						</a>
						<a href="javascript:;" class="wed clearfix">查看更多保险类型<i></i></a>--%>
					</div>
				</div>
				<%-- 8 --%>
				<div class="right-content s-none">
					<div class="contents">
						<a href="javascript:;">
							<h3>产品开发中...</h3>
							<%--<div class="content-s1 clearfix">--%>
							<%--<div class="s1-describe fl">--%>
							<%--<p>投标保证保险，指保险公司向工程--%>
							<%--项目招标人提供的保证工程项目投--%>
							<%--标人履行投标义务的保险。</p>--%>
							<%--</div>--%>
							<%--<div class="s1-pic fr"></div>--%>
							<%--</div>--%>
						</a>
						<%--<a href="javascript:;">--%>
							<%--<h3>工程履约保证保险</h3>--%>
							<%--<div class="content-s1 clearfix">--%>
								<%--<div class="s1-describe fl">--%>
									<%--<p>建设合同履约保证保险，指保险公--%>
										<%--司向建设工程发包人提供的保证承--%>
										<%--包人履行建设合同义务的保险。</p>--%>
								<%--</div>--%>
								<%--<div class="s2-pic fr"></div>--%>
							<%--</div>--%>
						<%--</a>--%>
						<%--<a href="javascript:;" class="wed clearfix">查看更多保险类型<i></i></a>--%>
					</div>
				</div>
			</div>
		</div>
	</div>
	<%--<div class="view-details clearfix">--%>
		<%--<h2 class="fr"></h2>--%>
		<%--<p class="fr"></p>--%>
		<%--<a href="javascript:;"></a>--%>
	<%--</div>--%>
</div>

<div class="image-information">
	<div class="images-content">
		<ul class="clearfix">
			<li class="pic-s1">
				<a href="<c:url value='/synopsis/product/productAllView?pro_type=GCTB&ACCESS_TOKEN=${ACCESS_TOKEN}' />">
					<h1>建筑工程</h1>
					<div class="pic-text">
						<h4>建筑工程</h4>
						<p style="text-align: center;">工程担保无忧<br>为建筑企业减负提效</p>
					</div>
				</a>
			</li>
			<li class="pic-s2">
				<a href="<c:url value='/synopsis/product/productAllView?pro_type=SSBQ&ACCESS_TOKEN=${ACCESS_TOKEN}' />">
					<h1>法律诉讼 </h1>
					<div class="pic-text">
						<h4>法律诉讼</h4>
						<p style="text-align: center;">创新诉讼保全担保<br>轻松转移经济责任</p>
					</div>
				</a>
			</li>
			<li class="pic-s3">
				<a href="<c:url value='/synopsis/product/productAllView?pro_type=XYX&ACCESS_TOKEN=${ACCESS_TOKEN}' />">
					<h1>贸易信用</h1>
					<div class="pic-text">
						<h4>贸易信用</h4>
						<p style="text-align: center;">避免“裸奔”贸易<br>用保险降低收账风险</p>
					</div>
				</a>
			</li>
			<%--<li class="mr-0 pic-s4">
				<a href="javascript:;">
					<h1>融资借贷</h1>
					<div class="pic-text">
						<h4>融资借贷</h4>
						<p style="text-align: center;">借贷有保证<br>融资不用愁</p>
					</div>
				</a>
			</li>
			<li class="mt-13 pic-s5">
				<a href="javascript:;">
					<h1>海关关税</h1>
					<div class="pic-text">
						<h4>海关关税</h4>
						<p style="text-align: center;">新型关税担保形式<br>为贸易企业减压增速</p>
					</div>
				</a>
			</li>--%>
			<li class="mr-0 pic-s4<%--mt-13 pic-s6--%>">
				<a href="<c:url value='/synopsis/product/productAllView?pro_type=GZX&ACCESS_TOKEN=${ACCESS_TOKEN}' />">
					<h1>公众安全</h1>
					<div class="pic-text">
						<h4>公众安全</h4>
						<p style="text-align: center;">为经营场所/单位<br>提供公众赔偿责任保障</p>
					</div>
				</a>
			</li>
			<li class="mt-13 pic-s7">
				<a href="<c:url value='/synopsis/product/productAllView?pro_type=TYX&ACCESS_TOKEN=${ACCESS_TOKEN}' />">
					<h1>企业保险</h1>
					<div class="pic-text" >
						<h4>企业保险</h4>
						<p style="text-align: center;">关怀员工人身保障<br>转嫁企业风险</p>
					</div>
				</a>
			</li>
			<li class="mr-0 mt-13 pic-s8">
				<a href="javascript:;">
					<h1>个人保险</h1>
					<div class="pic-text">
						<h4>个人保险</h4>
						<p style="text-align: center;">小投入大规划<br>意外、健康、养老全保障</p>
					</div>
				</a>
			</li>
		</ul>
	</div>
	<div class="information-scroll">
		<ul>
			<li>
				<p>
					<span class="fl">快讯 :&nbsp; &nbsp;&nbsp;</span>
					<a href="<c:url value='/policies_1?ACCESS_TOKEN=${ACCESS_TOKEN}' />">《国务院办公厅关于全面治理拖欠农民工工资问题的意见》</a>
				</p>
				<a href="<c:url value='/synopsis/us/init/policy?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="scroll-right"><i>more>></i></a>
			</li>
			<li>
				<p>
					<span class="fl">快讯 :&nbsp; &nbsp;&nbsp;</span>
					<a href="<c:url value='/policies_2?ACCESS_TOKEN=${ACCESS_TOKEN}' />">《关于鼓励建筑业企业采取多形式履约保证的通知》</a>

				</p>
				<a href="<c:url value='/synopsis/us/init/policy?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="scroll-right"><i>more>></i></a>
			</li>
			<li>
				<p>
					<span class="fl">快讯 :&nbsp; &nbsp;&nbsp;</span>
					<a href="<c:url value='/policies_3?ACCESS_TOKEN=${ACCESS_TOKEN}' />">《国务院关于加快发展现代保险服务业的若干意见》</a>

				</p>
				<a href="<c:url value='/synopsis/us/init/policy?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="scroll-right"><i>more>></i></a>
			</li>
			<li>
				<p>
					<span class="fl">快讯 :&nbsp; &nbsp;&nbsp;</span>
					<a href="<c:url value='/policies_4?ACCESS_TOKEN=${ACCESS_TOKEN}' />">《住房城乡建设部关于推进建筑业发展和改革的若干意见》</a>
				</p>
				<a href="<c:url value='/synopsis/us/init/policy?ACCESS_TOKEN=${ACCESS_TOKEN}' />" class="scroll-right"><i>more>></i></a>
			</li>
		</ul>
	</div>
</div>
<!--特色产品-->
<div class="bai-product">
	<h2>
		<p>特色产品</p>
		<span>Featured Products</span>
	</h2>
	<ul class="clearfix">
		<li>
			<div class="product-pic">
				<img src="<c:url value='/resources/version_new/images/product-s1.png' />">
			</div>
			<div class="product-title">
				<p>场景化保险</p>
				<div class="product-line line-a"></div>
			</div>
			<div class="product-text">
				<p>自有公共安全领域垂直平台，需求强烈、应用清晰的责任险、意外险等产品，精准嵌入业务流程，实现一体化风险管理。</p>
			</div>
		</li>
		<li>
			<div class="product-pic">
				<img src="<c:url value='/resources/version_new/images/product-s2.png' />">
			</div>
			<div class="product-title">
				<p>政策性保险</p>
				<div class="product-line line-b"></div>
			</div>
			<div class="product-text">
				<p>将政府扶持、政策要求的保险产品，引入满足各方需求的统一平台，提供专业便捷的一站式服务。</p>
			</div>
		</li>
		<li>
			<div class="product-pic">
				<img src="<c:url value='/resources/version_new/images/product-s3.png' />">
			</div>
			<div class="product-title">
				<p>金融创新保险</p>
				<div class="product-line line-c"></div>
			</div>
			<div class="product-text">
				<p>互联网+保险+统一平台，替代高成本金融担保方式，在实现企业/个人减负、提高资金利用效率的同时，提升风险管理水平</p>
			</div>
		</li>
		<li>
			<div class="product-pic">
				<img src="<c:url value='/resources/version_new/images/product-s4.png' />">
			</div>
			<div class="product-title">
				<p>员工福利保险</p>
				<div class="product-line line-d"></div>
			</div>
			<div class="product-text">
				<p>全方位员工福利保障采购及管理平台，降低企业采购成本，解决售后服务痛点，节省HR工作时间，满足多样化弹性福利需求。</p>
			</div>
		</li>
	</ul>
</div>
<!--平台功能-->
<div class="bai-platform">
	<div class="platform-content">
		<h2>
			<p>平台功能</p>
			<span>Platform Functions</span>
		</h2>
		<ul class="clearfix">
			<li class="mr-10">
				<div class="platform">
					<div class="platform-pic pic-s1">
					</div>
					<div class="platform-text">
						<p>产品管理</p>
						<span>领先的标准化产品管理系统，与各大保险公司集成对接，可协助保险中介方等快速上线产品，配置产品销售范围、面向渠道、销售政策等。</span>
					</div>
					<div class="pic-line"></div>
					<div class="text-line"></div>
				</div>
			</li>
			<li class="mr-10">
				<div class="platform">
					<div class="platform-pic pic-s2">
					</div>
					<div class="platform-text">
						<p>在线交易</p>
						<span>询价、对比、投保、核保、承保、出单、保全、理赔全流程在线交易，为终端客户提供极致体验的同时，也为渠道商带来产品和服务竞争力。</span>
					</div>
					<div class="pic-line"></div>
					<div class="text-line"></div>
				</div>
			</li>
			<li class="mr-10">
				<div class="platform">
					<div class="platform-pic pic-s3">
					</div>
					<div class="platform-text">
						<p>分销推广</p>
						<span>强大的分销推广功能，可供渠道实现各级分销商的分层管理、营销数据的即时获取、对账结算的全程自动化、产品快速传播和销量倍增。</span>
					</div>
					<div class="pic-line"></div>
					<div class="text-line"></div>
				</div>
			</li>
			<li>
				<div class="platform">
					<div class="platform-pic pic-s4">
					</div>
					<div class="platform-text">
						<p>运营支撑</p>
						<span>集中的品牌推广运作，10多年资深保险团队，24小时在线专业服务，完善的售后服务协调，解除保险销售的障碍和后顾之忧。</span>
					</div>
					<div class="pic-line"></div>
					<div class="text-line"></div>
				</div>
			</li>
		</ul>
	</div>
</div>
<!--合作伙伴-->
<div class="bai-partner">
	<div class="partner-content">
		<h2>
			<p>合作伙伴</p>
			<span>Cooperative Partner</span>
		</h2>
		<div class="partner-pic">
			<ul class="clearfix">
				<li class="mr-30 pic-s">
					<a href="<c:url value='/synopsis/partners/init/13729792?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
					<span></span><img src="<c:url value='/resources/version_new/images/partner-s1.png' />">
					<div class="border-left"></div>
					<div class="border-bottom"></div>
					<div class="border-top"></div>
					<div class="border-right"></div>
					</a>
				</li>
				<li class="mr-30 pic-s">
					<a href="<c:url value='/synopsis/partners/init/4?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
					<span></span><img src="<c:url value='/resources/version_new/images/partner-pac.png' />">
					<div class="border-left"></div>
					<div class="border-bottom"></div>
					<div class="border-top"></div>
					<div class="border-right"></div>
					</a>
				</li>
				<li class="mr-30 pic-s">
					<a href="<c:url value='/synopsis/partners/init/6?ACCESS_TOKEN=${ACCESS_TOKEN}' />">
					<span></span><img src="<c:url value='/resources/version_new/images/partner-ca.png' />">
					<div class="border-left"></div>
					<div class="border-bottom"></div>
					<div class="border-top"></div>
					<div class="border-right"></div>
						</a>
				</li>
				<%--<li class="mr-30 pic-s">
					<a href="<c:url value='/synopsis/partners/init/5' />">
					<span></span><img src="<c:url value='/resources/version_new/images/partner-s3-rb.png' />">
					<div class="border-left"></div>
					<div class="border-bottom"></div>
					<div class="border-top"></div>
					<div class="border-right"></div>
						</a>
				</li>
				<li class="pic-s">
					<a href="<c:url value='/synopsis/partners/init/2' />">
					<span></span><img src="<c:url value='/resources/version_new/images/partner-s4-ht.png' />">
					<div class="border-left"></div>
					<div class="border-bottom"></div>
					<div class="border-top"></div>
					<div class="border-right"></div>
						</a>
				</li>
				<li class="mr-30 mt-30 pic-s">
					<a href="<c:url value='/synopsis/partners/init/22020097' />">
					<span></span><img src="<c:url value='/resources/version_new/images/partner-zhc.png' />" width="196px">
					<div class="border-left"></div>
					<div class="border-bottom"></div>
					<div class="border-top"></div>
					<div class="border-right"></div>
						</a>
				</li>
				<li class="mr-30 mt-30 pic-s">
					<a href="<c:url value='/synopsis/partners/init/13729793' />">
					<span></span><img src="<c:url value='/resources/version_new/images/partner-s6.png' />">
					<div class="border-left"></div>
					<div class="border-bottom"></div>
					<div class="border-top"></div>
					<div class="border-right"></div>
						</a>
				</li>
				<li class="mr-30 mt-30 pic-s">
					<a href="<c:url value='/synopsis/partners/init/1' />">
					<span></span><img src="<c:url value='/resources/version_new/images/partner-s7.png' />">
					<div class="border-left"></div>
					<div class="border-bottom"></div>
					<div class="border-top"></div>
					<div class="border-right"></div>
				</a>
				</li>
				<li class="mt-30 pic-s pic-s-wed">
					<a href="<c:url value='/synopsis/partners/init/22020096' />">
					<span></span><img src="<c:url value='/resources/version_new/images/partner-s8.png' />">
					<div class="border-left"></div>
					<div class="border-bottom"></div>
					<div class="border-top"></div>
					<div class="border-right"></div></a></li>--%>
			</ul>
		</div>
		<a href="<c:url value='/synopsis/us/init/partners?ACCESS_TOKEN=${ACCESS_TOKEN}' />">查看更多合作伙伴</a>
	</div>
</div>
<!--四个图标-->
<div class="l-si">
	<div class="si-content">
		<ul class="clearfix">
			<li>
				<span></span>
				<img src="<c:url value='/resources/version_new/images/si-s1.png' />">
			</li>
			<li>
				<span></span>
				<img src="<c:url value='/resources/version_new/images/si-s2.png' />">
			</li>
			<li>
				<span></span>
				<img src="<c:url value='/resources/version_new/images/si-s3.png' />">
			</li>
			<li>
				<span></span>
				<img src="<c:url value='/resources/version_new/images/si-s4.png' />">
			</li>
		</ul>
	</div>
</div>
<jsp:include page="multi_f.jsp"/>
<div class="layer_notice" style="display: none">
	<p style="text-indent: 2em;margin-bottom: 0">尊敬的客户，您好！</p>
	<p style="text-indent: 2em;" id="ln_content"></p>
</div>

<script>
	$('.sd .wty').click(function () {
		$('.sd .wty').removeClass('active');
		$(this).addClass('active');
	});
	$('.shuffling .shuffling-content .shuffling-left ul li span').hover(function () {
		$('.shuffling .shuffling-content .shuffling-left ul li').css({"padding":"0 20px"});
		$('.shuffling .shuffling-content .shuffling-left ul li span').removeClass('on');
		$(this).addClass('on').parents('li').css({"padding":"0"});
		$('.shuffling .shuffling-content .shuffling-left ul li.line-none span').css({"border-bottom":"none"});
		var s_index = $(this).parents('li').index();
		$('.shuffling-right .right-content').hide();
		$('.shuffling .shuffling-content .shuffling-right').css({"display":"block"});
		$('.shuffling-right .right-content').eq(s_index).show();
	});
	$('.shuffling').mouseleave(function () {
		$('.shuffling .shuffling-content .shuffling-right').css({"display":"none"});
	});
	$('.shuffling .shuffling-content .shuffling-left ul li span.on').parents('li').css({"padding":"0"});
	$('.shuffling .shuffling-content .shuffling-left ul li.line-none span').css({"border-bottom":"none"});

	//首页大图轮播功能
	var mySwiper = new Swiper ('.swiper-container', {
		autoplay: 3000,//可选选项，自动滑动
		loop: true,
		//pagination: '.swiper-pagination',
		// 如果需要前进后退按钮
		autoplayDisableOnInteraction : false,  //用户操作后仍然自动切换
		paginationClickable :true, //点击小圆点切换
		// 如果需要分页器
		pagination : '.pagination',
		direction: 'horizontal',  //横向切换图片
		nextButton: '.swiper-button-next',
		prevButton: '.swiper-button-prev'
	});
</script>
<script>
	(function($){
		$.fn.textSlider = function(options){
			var defaults = { //初始化参数
				scrollHeight:100,
				line:1,
				speed:800,
				timer:3000
			};
			var opts = $.extend(defaults,options);
			this.each(function(){
				var timerID;
				var obj = $(this);
				var $ul = obj.children("ul");
				var $height = $ul.find("li").height();
				var $Upheight = 0-opts.line*$height;
				obj.hover(function(){
					clearInterval(timerID);
				},function(){
					timerID = setInterval(moveUp,opts.timer);
				});
				function moveUp(){
					$ul.animate({"margin-top":$Upheight},opts.speed,function(){
						for(i=0;i<opts.line;i++){ //只有for循环了才可以设置一次滚动的行数
							$ul.find("li:first").appendTo($ul);
						}
						$ul.css("margin-top",0);
					});
				};
				timerID = setInterval(moveUp,opts.timer);
			});
		};
	})(jQuery)
</script>
<script>
    var baseUrl = '${pageContext.request.contextPath }';
	$(function(){
        $(".information-scroll").textSlider({
            line:1
        });
		var lanren_width = $('.pic-s').width();
		var lanren_height = $('.pic-s').height();
		$('.pic-s').each(function(){
			$(this).hover(function(){
				$(this).find('.border-left,.border-right').stop().animate({height:lanren_height+'px'},400);
				$(this).find('.border-top,.border-bottom').stop().animate({width:lanren_width+'px'},400);
			},function(){
				$(this).find('.border-left,.border-right').stop().animate({height:'0'},400);
				$(this).find('.border-top,.border-bottom').stop().animate({width:'0'},400);
			});
		});
        if (window!=top)
            top.location.href = window.location.href;
        bhOpen();
	})

	function bhOpen(){
        $.ajax({
            type: 'POST',
            url:'/inform/query',
            success: function(json){
                if(json.success == true) {
					for(var i=0;i< json.data.length;i++){
					    $("#ln_content").html(json.data[i].content);
                        //捕获页
                        layer.open({
                            type: 1,
                            closeBtn:0,
                            offset: 'rb',
                            anim: 2,
                            time: 15000,
                            shade: false,
                            title: json.data[i].title, //不显示标题
                            content: $('.layer_notice'), //捕获的元素，注意：最好该指定的元素要存放在body最外层，否则可能被其它的相对元素所影响
                            cancel: function(){

                            }
                        });
					}
                }
            }
        });
	}
</script>
</body>

</html>