<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1"/>
    <meta http-equiv="X-UA-Compatible" content="IE=9"/>
    <meta name="keywords"
          content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
    <meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
    <meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
    <title>理赔申请</title>
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" />

    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/idangerous.swiper2.7.6.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />
    <link rel="stylesheet" href="<c:url value='/resources/versions-2.0.2/css/applicant.css' />">
</head>

<body>
<style>
    .rightLabel {
        margin-left: 15px;
        position: relative;
        top: -16px;
    }
    .input-group .btn{
        width:auto;
    }
    .container .contacts {
        height: auto;
    }
    .laydate_body .laydate_box {
        width: auto !important;
    }
    .laydate_body .laydate_bottom{
        width: auto !important;
        height: 30px !important;
    }
    .popo-tbody p{
        margin-bottom: 0;
    }
    .user-detail{
        height: auto !important;
    }
    .user-detail .detail-left{
        width: 100px !important;
    }
</style>
<div class="container">

    <div style="height: auto;width: 980px;float: left;">
        <div class="nav-list">
            <div class="row w-80-auto">
                <div class="col-sm-3 col-sm-4 active">
                    <p><i class="pull-left" id="i_1">1</i><span class=" pull-left">报案申请</span></p>
                </div>
                <div class="col-sm-3 col-sm-4">
                    <p><i class="pull-left" id="i_2">2</i><span class="pull-left">审核中</span></p>
                </div>
                <div class="col-sm-3 col-sm-3">
                    <p><i class="pull-left" id="i_3">3</i><span class="pull-left">赔款支付</span></p>
                </div>
                <div class="col-sm-3 col-sm-3 pull-right">
                    <p><i class="pull-left" id="i_4">4</i><span class="pull-left">已结案</span></p>
                </div>
            </div>
        </div>
        <div class="user-detail">
            <div class="title">
                <span class="tit-name">
                    基础信息
                </span>
            </div>
            <ul class="detail-list">
                <li>
                    <span class="detail-left">保单号</span>
                    <span class="no-name" id="policy_no"></span>
                </li>
                <li>
                    <span class="detail-left"></span>
                    <span class="no-name"></span>
                </li>
                <li>
                    <span class="detail-left">报案号</span>
                    <span class="no-name" id="report_no"></span>
                </li>
                <li>
                    <span class="detail-left">报案人姓名</span>
                    <span class="no-name" id="reporter_name"></span>
                </li>
                <li>
                    <span class="detail-left">报案时间</span>
                    <span class="no-name" id="report_date"></span>
                </li>
                <li>
                    <span class="detail-left">报案人手机</span>
                    <span class="no-name" id="reporter_tel"></span>
                </li>

            </ul>
        </div>
        <div class="user-detail">
            <div class="title">
                <span class="tit-name">
                    事故情况
                </span>
            </div>
            <ul class="detail-list">
                <li>
                    <span class="detail-left">事故时间</span>
                    <span class="no-name" id="accident_date"></span>
                </li>
                <li>
                    <span class="detail-left"></span>
                    <span class="no-name"></span>
                </li>
                <li style="width: 100%;min-height: 30px;height: auto;">
                    <span class="detail-left">人伤类型</span>
                    <span class="no-name" id="injured_detail_content"></span>
                </li>
                <li style="width: 100%;">
                    <span class="detail-left">事故原因</span>
                    <span class="no-name" id="accident_cause_level"></span>
                </li>
                <li style="width: 100%">
                    <span class="detail-left">事故地点</span>
                    <span class="no-name" id="accident_address"></span>
                </li>
                <li style="width: 100%;height: auto">
                    <span class="detail-left" style="float: left;">事故经过</span>
                    <div class="no-name" id="accident_process" style="float: left;width: 80%;"></div>
                </li>

            </ul>
        </div>
        <div class="user-detail">
            <div class="title">
                <span class="tit-name">
                    领款信息
                </span>
            </div>
            <ul class="detail-list">
                <li>
                    <span class="detail-left">账户类型</span>
                    <span class="no-name" id="bank_account_attribute_name"></span>
                </li>
                <li>
                    <span class="detail-left"></span>
                    <span class="no-name"></span>
                </li>
                <li>
                    <span class="detail-left">开户银行</span>
                    <span class="no-name" id="client_bank_name"></span>
                </li>
                <li>
                    <span class="detail-left">开户地点</span>
                    <span class="no-name" id="bank_address"></span>
                </li>
                <li>
                    <span class="detail-left">银行账户</span>
                    <span class="no-name" id="client_bank_account"></span>
                </li>
                <li>
                    <span class="detail-left">开户名</span>
                    <span class="no-name" id="client_name"></span>
                </li>
                <li>
                    <span class="detail-left">证件类型</span>
                    <span class="no-name" id="client_certificate_type_name"></span>
                </li>
                <li>
                    <span class="detail-left">证件号码</span>
                    <span class="no-name" id="client_certificate_no"></span>
                </li>
            </ul>
            <ul class="form-list">
                <li>
                    <div class="list-name" style="width: 400px;"></div>
                    <div class="list-input">
                        <button class="btn an_back back" type="button">返回</button>
                    </div>
                </li>
            </ul>
        </div>
    </div>
    <!--右边编辑结束-->

</div>

<!--黑色蒙版-->
<div class="black-mask"></div>
<!--黑色蒙版2-->
<div class="black-mask-more"></div>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js'/>"></script>
<script src="<c:url value='/resources/version_new/js/jquery.form.js' />"></script>
<script src="<c:url value='/resources/version_new/js/jquery.formHelper.js' />"></script>
<script src="<c:url value='/resources/version_new/js/laydate/laydate.js' />"></script>
<script src="<c:url value='/resources/version_new/js/layer/layer.js' />"></script>
<script src="<c:url value='/resources/public/g.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<jsp:include page="../../index/multi_init_param.jsp"/>
</body>
<script type="text/javascript">
    var allright = true;
    var baseUrl = '${pageContext.request.contextPath }';
    function isWrong(el, obj, msg) {
        if (el) {
            $(obj).nextAll("span").remove();
            if (msg != "") $(obj).after("<span class='list-msg'>" + msg + "</span>");
            $(obj).addClass("err");
            allright = false;
            return false;
        } else {
            $(obj).nextAll("span").remove();
            $(obj).removeClass("err");
            return true;
        }
    }

    //只做标记不提示
    function isWrong2(el, obj) {
        if (el) {
            $(obj).addClass("err");
            allright = false;
            return false;
        } else {
            $(obj).removeClass("err");
            return true;
        }
    }

    function clearErr(obj) {
        $(obj).nextAll("span").remove();
        $(obj).removeClass("err");
    }

    // 详情弹窗的出现与消失
    $('.po-details').click(function () {
        $('.details-popover').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
        var s = $('.popo-tbody').height();
        if(s <= 400){
            $('.details-popover .popo-content').css({"overflow":"hidden"})
        }
    });
    $('#popo-bi').click(function () {
        $('.details-popover').hide().addClass('fadeOutUpBig').removeClass('fadeInDownBig');
        $('.black-mask').hide();
    });
    function setCode(type){
        var data = [];
        if(type==1){
            data = [
                {id:'1',text:"组织机构代码证"},
                {id:'6',text:"税务登记证"},
                {id:'7',text:"营业执照"},
                {id:'2',text:"三证合一统一信用代码"}
            ];
        }else{
            data = [
                {id:'0',text:"身份证"},
                {id:'3',text:"护照"},
                {id:'4',text:"台胞证"},
                {id:'5',text:"回乡证"}
            ];
        }
        var str = "<option value=''>请选择证件类型</option>";
        for(var i in data){
            if (data[i].id != undefined) str += "<option value='"+data[i].id+"'>"+data[i].text+"</option>";
        }
        $('#client_certificate_type').html(str);
    }

    function codeToName(_sign,_code){
        var _name = '';
        if(_sign!=''){
            if('10' == _sign){
                _name = '索赔申请书（加盖公章）';
            }else if('11' == _sign){
                _name = '赔付协议及权益转让书（加盖公章）';
            }else if('12' == _sign){
                _name = '事故经过说明';
            }else if('13' == _sign){
                _name = '劳动合同（复印件）';
            }else if('14' == _sign){
                _name = '首诊病历、住院病历、医疗费发票、用药清单、诊断证明等医院病历材料';
            }else if('15' == _sign){
                _name = '医生提供的病假条';
            }else if('16' == _sign){
                _name = '单位休假记录，需公司由人事部门盖章';
            }else if('17' == _sign){
                _name = '事故认定书';
            }else if('18' == _sign){
                _name = '公司营业执照、法人身份证复印件。经办人身份证复印件';
            }else if('19' == _sign){
                _name = '被保险人员工有无工伤保险证明（加盖公章）';
            }else if('20' == _sign){
                _name = '工伤认定书';
            }else if('21' == _sign){
                _name = '判决书原件及提交法院材料的复印件';
            }else if('22' == _sign){
                _name = '事故员工身份证复印件';
            }else if('01' == _sign){
                _name = '身份证';
            }else if('02' == _sign){
                _name = '劳动合同';
            }else if('03' == _sign){
                _name = '事故经过';
            }else if('04' == _sign){
                _name = '门诊病历';
            }else if('05' == _sign){
                _name = '医疗费发票';
            }else if('06' == _sign){
                _name = '用药清单';
            }else if('07' == _sign){
                _name = '误工费资';
            }else if('08' == _sign){
                _name = '其他证明资料';
            }
        }else{
            if('001000' == _code){
                _name = '索赔申请书（加盖公章）';
            }else if('007003' == _code){
                _name = '赔付协议及权益转让书（加盖公章）';
            }else if('003019' == _code){
                _name = '事故经过说明';
            }else if('003007' == _code){
                _name = '劳动合同（复印件）';
            }else if('004005' == _code){
                _name = '首诊病历、住院病历、医疗费发票、用药清单、诊断证明等医院病历材料';
            }else if('004006' == _code){
                _name = '医生提供的病假条';
            }else if('004006' == _code){
                _name = '单位休假记录，需公司由人事部门盖章';
            }else if('003012' == _code){
                _name = '事故认定书';
            }else if('006004' == _code){
                _name = '公司营业执照、法人身份证复印件。经办人身份证复印件';
            }else if('003001' == _code){
                _name = '被保险人员工有无工伤保险证明（加盖公章）';
            }else if('003007' == _code){
                _name = '工伤认定书';
            }else if('005000' == _code){
                _name = '判决书原件及提交法院材料的复印件';
            }else if('006005' == _code){
                _name = '事故员工身份证复印件';
            }
        }
        return _name;
    }

    $("input[name=bank_account_attribute]").on("change", function () {
        var val = $(this).val();
        console.log(val);
        if (val == '0') {
            setCode(1);
        } else {
            setCode(0);
        }
    });

    $(document).ready(function () {

        //点击下拉选择
        $(".list-input").on("change", '.sel-list', function () {
            var val = $(this).val();
            if (val === 0) {
                $(this).addClass('default');
            } else {
                $(this).removeClass('default');
            }
        });
        setCode(0);
        if('${report_id}' != ''){
            $.ajax({
                type : 'POST',
                url : baseUrl + "/api/report/queryByID/${report_id}?ACCESS_TOKEN=${ACCESS_TOKEN}",
                data : {},
                dataType : "json",
                success : function(json) {
                    var _pay = json.insPaymentInfoVo;
                    var _k = Object.keys(json);
                    var _p = Object.keys(_pay);
                    var _sta = json.status;
                    if(_sta != undefined && _sta != ''){
                        var _pdate = _pay.pay_date;
                        if(_sta == '1'){//审核中
                            $('#i_1').addClass('glyphicon glyphicon-ok').html('');
                            if(_pdate != undefined && _pdate != ''){
                                $('#last-show').show();//显示返回按钮
                                $('#i_2').addClass('glyphicon glyphicon-ok').html('');
                                $('#i_2').parent().parent().addClass('active');
                                $('#i_3').addClass('glyphicon glyphicon-ok').html('');
                                $('#i_3').parent().parent().addClass('active');
                                $('#i_4').parent().parent().addClass('active');
                            }else{
                                $('#upload-model').show();//显示上传组件模块
                                $('#i_2').parent().parent().addClass('active');
                            }
                        }else if(_sta == '2'){//结案
                            $('#last-show').show();//显示返回按钮
                            $('#i_1').addClass('glyphicon glyphicon-ok').html('');
                            $('#i_2').addClass('glyphicon glyphicon-ok').html('');
                            $('#i_2').parent().parent().addClass('active');
                            if(_pdate != undefined && _pdate != ''){
                                $('#i_3').addClass('glyphicon glyphicon-ok').html('');
                                $('#i_3').parent().parent().addClass('active');
                            }else{
                                $('#i_3').addClass('glyphicon glyphicon-remove').html('');
                                $('#i_3').parent().parent().addClass('active-fail');
                            }
                            $('#i_4').addClass('glyphicon glyphicon-ok').html('');
                            $('#i_4').parent().parent().addClass('active');
                        }
                    }
                    $.each(_k, function (i, key) {
                        if($('#'+key)){
                            if(key == 'ins_common_report_id'||key == 'register_user_id'){
                                $('#'+key).val(json[key]);
                            }else{
                                $('#'+key).html(json[key]);
                            }
                        }
                    });
                    $.each(_p, function (i, key) {
                        if($('#'+key)){
                            $('#'+key).html(_pay[key]);
                        }
                    });
                    if(json.claimInformationVoList && json.claimInformationVoList.length>0) {
                        var _div = '';
                        $.each(json.claimInformationVoList, function (i, obj) {
                            var _sign = obj.file_key.substring(2,3)=='-'?obj.file_key.substring(0,2):'';
                            _div += setUploads(codeToName(_sign,obj.short_group_code),obj.file_path);
                        });
                        $('#uploads').html(_div);
                    }
                }
            });
        }
        contacts();
    });

    function setUploads(_title,_url){
        var _t = _title.length>7?(_title.substring(0,7)+'...'):_title;
        return _div = '<div class="col-sm-2 col-xs-2">'+
        '<img src="'+_url+'" width="100%" height="50px">'+
        '<span class="mt-db-7f" title="'+_title+'">'+_t+'</span>'+
        '</div>';
    }
    function contacts() {

        // 报案保存
        $('.an_save').click(function () {
            allright = true;
            var _file_html = $('#some_upload_bl').html();
            if(_file_html.trim() == ''){
                layer.alert('请点击“+”号添加理赔资料附件信息', {
                    icon: 3, closeBtn: 0, yes: function () {
                        layer.closeAll();
                    }
                });
                return;
            }
            $(".myValid").each(function () {
                $(this).trigger("blur");
                if ($(this).hasClass("err")) $(this).focus();
            }); //校验表单
            if (allright) {
                var data = $("#defaultForm").serializeJson();
                $.ajax({
                    type : 'POST',
                    url : baseUrl + "/api/report/saveUploadFile?ACCESS_TOKEN=${ACCESS_TOKEN}",
                    data : data,
                    dataType : "json",
                    success : function(json) {
                        if(json.statusCode == '200') {
                            layer.alert(json.message, {
                                icon: 1, closeBtn: 0, yes: function () {
                                    layer.closeAll();
                                    window.location.reload();
                                }
                            });
                        }else{
                            layer.alert(json.message, {
                                icon: 2, closeBtn: 0, yes: function () {
                                    layer.closeAll();
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    //点击返回按钮
    $(".list-input").on("click", '.an_back', function () {
        window.location.href = baseUrl + '/api/report/reportList?ACCESS_TOKEN=${ACCESS_TOKEN}';
    });

    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/report/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"report/",type);
        flag = true;
        return flag;
    }
    function random4() {
        return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
    };
    function createUUID() {
        return (random4() + random4() + "-" + random4() + "-" + random4() + "-" + random4() + random4());
    };

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = laySomenType(0,null,'',0);
        var _times = (new Date()).getTime();
        var fileName = _times+"."+fileType;
        var _sign = $('#'+_id+'_file-5').attr('data-sign');
        var fileId = _sign + '-' + createUUID();
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', fileName);
        formData.append('fileId', fileId);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoadPA';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                laySomenType(2,index,'',0);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                    $("#"+_id.replace('file_path','file_name')).val(fileName);
                    $("#"+_id.replace('file_path','file_key')).val(fileId);
                }else{
                    laySomenType(1,null,result.message,0);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }

    function setOneUploadInput(_short_code,_cl_title,_sign,_key,_name,_url){
        var _t = _cl_title.length>21?(_cl_title.substring(0,20)+'...'):_cl_title;
        var _input = '<input type="hidden" name="claimInformationVoList[0].short_group_code" id="short_group_code_0" value="'+_short_code+'">'+
            '<input type="hidden" name="claimInformationVoList[0].file_key" id="file_key_0" value="'+_key+'">'+
            '<input type="hidden" name="claimInformationVoList[0].file_name" id="file_name_0" value="'+_name+'">'+
            '<input class="myValid" type="hidden" name="claimInformationVoList[0].file_path" id="file_path_0" value="'+_url+'">'+
            '<div>'+
            '<input name="file_path_0_file" id="file_path_0_file-5" data-sign="'+_sign+'" data-drawview="'+_url+'" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon=""/>'+
            '</div>'+
            '<span class="mt-db-7f" title="'+_cl_title+'">'+_t+'</span>';
        $('#one_upload_input').html(_input);
        initDoFile();
    }

    function addUploadInput(_short_code,_cl_title,_sign,_key,_name,_url){
        _key = _key==undefined?'':_key;
        _name = _name==undefined?'':_name;
        _url = _url==undefined?'':_url;
        var _num = 0,_fileNum = 1;
        if($('#uploadInputNum').val() != ''){
            _num = Number($('#uploadInputNum').val())+1;
        }
        if($('#fileNum').val() != ''){
            _fileNum = Number($('#fileNum').val())+1;
        }
        if(_fileNum>9){
            return;
        }else if(_fileNum<4){
            $('#uploadInputNum').parent().attr('style','height:320px;');
        }else if(_fileNum>3&&_fileNum<7){
            $('#uploadInputNum').parent().attr('style','height:613px;');
        }else if(_fileNum>6&&_fileNum<10){
            $('#uploadInputNum').parent().attr('style','height:860px;');
        }
        var _t = _cl_title.length>21?(_cl_title.substring(0,20)+'...'):_cl_title;
        var _input = '<div class="col-sm-4 col-xs-4">'+
            '<input type="hidden" name="claimInformationVoList['+_num+'].short_group_code" id="short_group_code_'+_num+'" value="'+_short_code+'">'+
            '<input type="hidden" name="claimInformationVoList['+_num+'].file_key" id="file_key_'+_num+'" value="'+_key+'">'+
            '<input type="hidden" name="claimInformationVoList['+_num+'].file_name" id="file_name_'+_num+'" value="'+_name+'">'+
            '<input class="myValid" type="hidden" name="claimInformationVoList['+_num+'].file_path" id="file_path_'+_num+'" value="'+_url+'">'+
            '<div>'+
            '<input name="file_path_'+_num+'_file" id="file_path_'+_num+'_file-5" data-sign="'+_sign+'" data-drawview="'+_url+'" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon=""/>'+
            '</div>'+
            '<span class="mt-db-7f" title="'+_cl_title+'">'+_t+'</span>'+
            '</div>';
        $('#some_upload_bl').append(_input);
        $('#uploadInputNum').val(_num);
        $('#fileNum').val(_fileNum);
        //激活组件
        initDoFile();
        //绑定必填校验
        zjjy();
    }

    function initDoFile(){
        var $input = $('input.file[type=file]'), count = $input.attr('type') ? $input.length : 0;
        if (count > 0) {
            $input.each(function(a,b){
                var type_img = ['.jpg','.jpeg','.gif','.png','.psd','.tiff','bmp'];
                var type_wj = ['.txt','.pdf','.doc','.docx','.ppt','.rar','.zip','.tar'];

                var maxFileSize = 20480;//文件限制20M(20480KB)
                var paths = $(b).attr('data-drawview');
                var name = paths;
                var allowedFiles = $(b).attr('data-allowedFileExtensions');
                var fileType = $(b).attr("data-preview-file-type");
                var allowedFileArr = new Array();//创建一个数组
                if(allowedFiles == undefined || allowedFiles == ""){
                    if(fileType == undefined || fileType == ""){
                        allowedFileArr = ["jpg","png","gif","jpeg","bmp","BMP","JPG","PNG","GIF","JPEG","doc","docx","xml","txt","pdf","ppt","xls","xlsx","rar","zip"];
                    }else if(fileType == "image"){
                        allowedFileArr =["jpg","png","gif","jpeg","bmp","BMP","JPG","PNG","GIF","JPEG"];
                        maxFileSize = 8192; //图片限制2M(2048KB)
                    }else{
//        				allowedFileArr =["doc","docx","xml","txt","pdf","ppt","xls","xlsx","rar","zip"];
                        allowedFileArr = ["jpg","png","gif","jpeg","bmp","BMP","JPG","PNG","GIF","JPEG","doc","docx","xml","txt","pdf","ppt","xls","xlsx","rar","zip"];
                    }
                }else{
                    allowedFileArr = allowedFiles.replace("[","").replace("]","").split(",");
                }
                if(paths != undefined && paths != '' && paths.length>1){
                    var code = "";
                    for(var i=0;i<type_img.length;i++){
                        if(code != "1"){
                            if(paths.replace(type_img[i])){
                                code = "1";
                                paths = '<img src="'+paths+'" class="file-preview-image" title="'+name+'" alt="'+name+'" style="width:200px;height:154px;">';
                            }
                        }
                    }
                    if(code == ""){
                        for(var i=0;i<type_wj.length;i++){
                            if(code != "2"){
                                if(paths.replace(type_wj[i])){
                                    code = "2";
                                }
                            }
                        }
                    }
                    if(code == "1"){
                        name = name.split("/")[name.split("/").length-1];
                        $(b).fileinput({
                            allowedFileExtensions: allowedFileArr,//接收的文件后缀
                            maxFileSize:maxFileSize,
                            initialPreview: [
                                paths
                            ],
                            initialPreviewAsData: true,
                            initialPreviewFileType: 'image',
                            deleteUrl: "/site/file-delete",
                            overwriteInitial: true,
                            initialPreviewConfig: [
                                {caption: name, size: 576237, width: "210px", url: "/site/file-delete", key: 1},
                            ]
                        });
                    }else if(code == "2"){
                        $(b).fileinput({
                            allowedFileExtensions: allowedFileArr,//接收的文件后缀
                            maxFileSize:maxFileSize,
                            initialPreview: [
                                paths
                            ]
                        });
                    }
                }else
                    $(b).fileinput({
                        allowedFileExtensions: allowedFileArr,//接收的文件后缀
                        maxFileSize:maxFileSize
                    });


            });
            //绑定双击删除
            deleteUploadDiv();
        }
    }
    function deleteUploadDiv(){
        //先清除已绑定的双击事件，避免之前已绑定第二遍重复绑定
        $('.file-drop-zone').unbind('dblclick');
        //重新绑定双击事件
        $('.file-drop-zone').dblclick(function(){
            var _div = $(this).parent().parent().parent().parent();
            _div.remove();
            var _fileNum = Number($('#fileNum').val())-1;
            if(_fileNum == 0){
                $('#fileNum').val('');
                $('#uploadInputNum').val('');
                $('#uploadInputNum').parent().attr('style','');
            }else{
                $('#fileNum').val(_fileNum);
                if(_fileNum>9){
                    return;
                }else if(_fileNum<4){
                    $('#uploadInputNum').parent().attr('style','height:320px;');
                }else if(_fileNum>3&&_fileNum<7){
                    $('#uploadInputNum').parent().attr('style','height:613px;');
                }else if(_fileNum>6&&_fileNum<10){
                    $('#uploadInputNum').parent().attr('style','height:860px;');
                }
            }
        });
    }

    //组件校验
    function zjjy() {
        //解绑
        $("input[name*='].file_path']").unbind('blur keyup.pev');
        //绑定
        $("input[name*='].file_path']").bind("blur keyup.pev", function () {
            var r1 = isWrong2($(this).val().trim() == "", this);
            if(!r1){
                layer.alert('存在已添加的上传组件未上传附件信息', {
                    icon: 2, closeBtn: 0, yes: function () {
                        layer.closeAll();
                    }
                });
            }
        });
    }
</script>

</html>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>