<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1"/>
    <meta http-equiv="X-UA-Compatible" content="IE=9"/>
    <meta name="keywords"
          content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
    <meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
    <meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
    <title>理赔申请</title>

    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" />

    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/idangerous.swiper2.7.6.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/version_new/css/basic.css' />" />
    <link rel="stylesheet" href="<c:url value='/resources/versions-2.0.2/css/applicant.css' />">
</head>

<body>
<style>
    .rightLabel {
        margin-left: 15px;
        position: relative;
        top: -16px;
    }
    .input-group .btn{
        width:auto;
    }
    .container .contacts {
        height: auto;
    }
    .laydate_body .laydate_box {
        width: auto !important;
    }
    .laydate_body .laydate_bottom{
        width: auto !important;
        height: 30px !important;
    }
    .popo-tbody p{
        margin-bottom: 0;
    }
    .laydate_body .laydate_top{
        width: auto !important;
        padding: inherit;
    }
</style>
<div class="container">

    <div class="right enter" style="display: block">
        <div class="title">
                <span class="tit-name">
                    理赔申请
                </span>
        </div>
        <!--表单内容开始-->
        <form id="defaultForm">
            <h2 class="person-info" style="font-size: 16px;">
                基础信息
            </h2>
            <ul class="form-list">
                <li>
                    <div class="list-name">
                        <span class="red">*</span>
                        <label>保单号</label>
                    </div>
                    <div class="list-input">
                        <input type="text" class="inp myValid" id="policy_no" name="policy_no" value="${policy_no}" readonly>
                        <input type="hidden" id="ins_insurance_slip_id" name="ins_insurance_slip_id" value="${order_id}">
                        <input type="hidden" id="ins_common_report_id" name="ins_common_report_id">
                    </div>
                </li>
                <li>
                    <div class="list-name">
                        <span class="red">*</span>
                        <label>报案人姓名</label>
                    </div>
                    <div class="list-input">
                        <input type="text" class="inp myValid" id="reporter_name" name="reporter_name">
                    </div>
                </li>
                <li>
                    <div class="list-name">
                        <span class="red">*</span>
                        <label>报案人手机</label>
                    </div>
                    <div class="list-input">
                        <input type="text" class="inp myValid" placeholder="请输入手机号" id="reporter_tel" name="reporter_tel">
                    </div>
                </li>
            </ul>
            <h2 class="person-info" style="font-size: 16px;">
                事故情况
            </h2>
            <ul class="form-list">
                <li>
                    <div class="list-name">
                        <span class="red">*</span>
                        <label>事故时间</label>
                    </div>
                    <div class="list-input">
                        <input class="laydate-icon inp myValid" id="accident_date" name="accident_date">
                        <span class="list-msg"></span>
                    </div>
                </li>
                <li style="height: 150px;">
                    <div class="list-name">
                        <span class="red">*</span>
                        <label>人伤类型</label>
                    </div>
                    <div class="list-input">
                        <div class="input-group" style="width: 300px;height: 45px;padding-bottom: 5px;">
                            <span class="input-group-addon">
                                <input type="checkbox" id="injured_detail_1" name="injured_detail" value="01" style="height: auto"><span>门诊</span>
                            </span>
                            <input type="text" class="form-control" id="outpatient_list" name="outpatient_list" placeholder="门诊人员姓名，多个“,”隔开" style="height: 45px">
                        </div>
                        <div class="input-group" style="width: 300px;height: 45px;padding-bottom: 5px;">
                            <span class="input-group-addon">
                                <input type="checkbox" id="injured_detail_2" name="injured_detail" value="02" style="height: auto"><span>住院、伤残</span>
                            </span>
                            <input type="text" class="form-control" id="maim_list" name="maim_list" placeholder="住院、残人员姓名，多个“,”隔开" style="height: 45px">
                        </div>
                        <div class="input-group" style="width: 300px;height: 45px;padding-bottom: 5px;">
                            <span class="input-group-addon">
                                <input type="checkbox" id="injured_detail_3" name="injured_detail" value="03" style="height: auto"><span>死亡</span>
                            </span>
                            <input type="text" class="form-control" id="demise_list" name="demise_list" placeholder="死亡人员姓名，多个“,”隔开" style="height: 45px">
                        </div>
                    </div>
                </li>
                <li>
                    <div class="list-name">
                        <span class="red">*</span>
                        <label>事故地点</label>
                    </div>
                    <div class="list-input picker_area_div">
                        <div class="sel-choice">
                            <i class="down-icon"></i>
                            <select class="default picker_province myValid" id="picker_province_p"
                                    name="accident_province_code" style="height: 45px;width: 145px">
                                <option value="0" selected>请选择省</option>
                            </select>
                        </div>
                        <div class="sel-choice">
                            <i class="down-icon"></i>
                            <select class="default picker_city myValid" id="picker_city_p" name="accident_city_code"
                                    style="height: 45px;width: 145px">
                                <option value="0" selected>请选择市</option>
                            </select>
                        </div>
                        <div class="sel-choice">
                            <i class="down-icon"></i>
                            <select class="default picker_district myValid" id="picker_district_p"
                                    name="accident_county_code" style="height: 45px;width: 145px">
                                <option value="0" selected>请选择区</option>
                            </select>
                        </div>
                    </div>
                </li>
                <li>
                    <div class="list-name">
                        <span class="red">*</span>
                        <label>详细地址</label>
                    </div>
                    <div class="list-input">
                        <input type="text" class="inp myValid" id="accident_place" placeholder="请输入详细地址" name="accident_place">
                    </div>
                </li>
                <li>
                    <div class="list-name">
                        <span class="red">*</span>
                        <label>事故原因</label>
                    </div>
                    <c:if test="${!fn:contains(product_code, 'GZZRX-CA')}">
                        <div class="list-input accident_cause_level_div">
                            <div class="sel-choice">
                                <i class="down-icon"></i>
                                <select class=" default accident_cause_level_1 myValid" name="accident_cause_level_1" style="height: 45px;width: 145px">
                                    <option value="" selected>请选择</option>
                                </select>
                            </div>
                            <div class="sel-choice accident_cause_level_2_div">
                                <i class="down-icon"></i>
                                <select class=" default accident_cause_level_2 myValid" name="accident_cause_level_2" style="height: 45px;width: 145px">
                                    <option value="" selected>请选择</option>
                                </select>
                            </div>
                        </div>
                    </c:if>
                    <c:if test="${fn:contains(product_code, 'GZZRX-CA')}">
                        <div class="list-input damageCode_div">
                            <div class="sel-choice">
                                <i class="down-icon"></i>
                                <select class=" default damageCode myValid" name="accident_cause_level_1" style="height: 45px;width: 300px">
                                    <option value="" selected>请选择</option>
                                </select>
                            </div>
                        </div>
                    </c:if>
                </li>
                <li style="height: 80px">
                    <div class="list-name">
                        <span class="red">*</span>
                        <label>事故经过</label>
                    </div>
                    <div class="list-input">
                        <textarea class="inp myValid" name="accident_process" id="accident_process" placeholder="请详细描述事故经过"
                                  style="border-radius:4px;height: 80px;width: 300px"></textarea>
                    </div>
                </li>
            </ul>
            <c:if test="${fn:contains(product_code, 'GZZRX-PAC') }">
            <h2 class="person-info" style="font-size: 16px;">
                资料上传（点击此处查看<a href="javascript:void(0);" class="po-details">理赔所需材料说明及模板下载</a>）
                <div class="btn-group">
                    <button type="button" class="btn btn-success dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" style="width: auto;height: auto">
                        <span>+</span>
                    </button>
                    <ul class="dropdown-menu">
                        <li><a href="javascript:void(0);" onclick="addUploadInput('001000','索赔申请书（加盖公章）','10')">索赔申请书（加盖公章）</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('007003','赔付协议及权益转让书（加盖公章）','11')">赔付协议及权益转让书（加盖公章）</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('003019','事故经过说明','12')">事故经过说明</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('003007','劳动合同（复印件）','13')">劳动合同（复印件）</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('004005','首诊病历、住院病历、医疗费发票、用药清单、诊断证明等医院病历材料','14')">首诊病历、住院病历、医疗费发票、用药清单、诊断证明等医院病历材料</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('004006','医生提供的病假条','15')">医生提供的病假条</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('004006','单位休假记录，需公司由人事部门盖章','16')">单位提供的休假记录，需公司由人事部门盖章</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('003012','事故认定书','17')">涉及交通及安监等事故：需提供相关部门出据的事故认定书</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('006004','公司营业执照、法人身份证复印件。经办人身份证复印件','18')">公司营业执照、法人身份证复印件。经办人身份证复印件</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('003001','被保险人员工有无工伤保险证明（加盖公章）','19')">被保险人员工有无工伤保险证明（加盖公章）</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('003007','工伤认定书','20')">如员工上有工伤保险，需提供工伤认定书（非必备，有工伤的提供）</a></li>
                        <li><a href="javascript:void(0);" onclick="addUploadInput('005000','判决书原件及提交法院材料的复印件','21')">涉及诉讼案件：需提供判决书原件及提交法院材料的复印件</a></li>
                    </ul>
                </div>
            </h2>
            <ul class="form-list" style="height: 320px">
                <input type="hidden" id="uploadInputNum" value="0">
                <input type="hidden" id="fileNum" value="1">
                <li>
                    <div class="list-input" id="some_upload_bl">
                        <div class="col-sm-4 col-xs-4" id="one_upload_input">
                            <input type="hidden" name="claimInformationVoList[0].short_group_code" id="short_group_code_0" value="006005">
                            <input type="hidden" name="claimInformationVoList[0].file_key" id="file_key_0">
                            <input type="hidden" name="claimInformationVoList[0].file_name" id="file_name_0">
                            <input class="myValid" type="hidden" name="claimInformationVoList[0].file_path" id="file_path_0">
                            <div>
                                <input name="file_path_0_file" id="file_path_0_file-5" data-sign="22" data-drawview="" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon=""/>
                            </div>
                            <span class="mt-db-7f" title="事故员工身份证复印件">
                        <span class="red">*</span>事故员工身份证复印件</span>
                        </div>
                    </div>
                </li>
            </ul>
            <ul class="form-list" style="padding-top: 0;height: 120px;">
                <li>
                    <div class="list-input">
                        <div class="col-sm-12 col-xs-12 reminder" style="margin: 16px;width: 97%;line-height: 20px;">
                            <label style="margin-top: 10px;width: 500px">温馨提示：                                                        </label>
                            <label style="text-indent: 18px;">1.支持材料补充上传，若材料未准备齐全也可先行提交，后续可到【我的理赔】-【理赔记录】补充上传；</label>
                            <label style="text-indent: 18px;">2.点击“+”按钮会出现可选资料类型的下拉列表，点击条目可生成该类型的上传组件，双击组件框可删除该组件；</label>
                            <label style="margin-bottom: 10px;text-indent: 18px;">3.支持8M以内扩展名jpg、gif、png、jpeg、bmp图片格式，为了更快完成申请，请确保材料清晰、完整。</label>
                        </div>
                    </div>
                </li>
            </ul>
            </c:if>
            <h2 class="person-info" style="font-size: 16px;">
                领款信息
            </h2>
            <ul class="form-list">
                <li>
                    <div class="list-name">
                        <span class="red">*</span>
                        <strong>账户类型</strong>
                        <input type="hidden" name="insPaymentInfoVo.ins_payment_info_id" id="ins_payment_info_id"/>
                    </div>
                    <div class="list-input">
                        <div class="man rad-io">
                            <input type="radio" class="myValid" name="insPaymentInfoVo.bank_account_attribute" value="1" id="accountP" checked>
                            <label for="accountP"><strong class="rightLabel" style="width: 100px;display: inline-block;">个人</strong></label>
                        </div>
                        <div class="women rad-io">
                            <input type="radio" class="myValid" name="insPaymentInfoVo.bank_account_attribute" value="0" id="accountC">
                            <label for="accountC"><strong class="rightLabel" style="width: 100px;display: inline-block;">企业</strong></label>
                        </div>
                    </div>
                </li>
                <li>
                    <div class="list-name">
                        <span class="red">*</span>
                        <label>开户姓名</label>
                    </div>
                    <div class="list-input">
                        <input type="text" class="inp myValid" id="client_name" name="insPaymentInfoVo.client_name">
                    </div>
                </li>
                <li>
                    <div class="list-name">
                        <span class="red">*</span>
                        <label>证件类型</label>
                    </div>
                    <div class="list-input">
                        <i class="down-icon" style="left: 279px"></i>
                        <select class="default myValid" id="client_certificate_type" name="insPaymentInfoVo.client_certificate_type"
                                style="width: 300px;height: 45px;">
                            <option value="" selected>请选择证件类型</option>
                        </select>
                    </div>
                </li>
                <li>
                    <div class="list-name">
                        <span class="red">*</span>
                        <label>证件号码</label>
                    </div>
                    <div class="list-input">
                        <input type="text" class="inp myValid" id="client_certificate_no" name="insPaymentInfoVo.client_certificate_no">
                    </div>
                </li>
                <li>
                    <div class="list-name">
                        <span class="red">*</span>
                        <label>开户银行</label>
                    </div>
                    <div class="list-input real-input client_bank_code_div">
                        <i class="down-icon"></i>
                        <input type="hidden" id="client_bank_name" name="insPaymentInfoVo.client_bank_name">
                        <select class="default client_bank_code myValid" name="insPaymentInfoVo.client_bank_code" id="client_bank_code"
                                style="height: 45px;width: 300px">
                            <option value="">请选择银行</option>
                        </select>
                    </div>
                </li>
                <li>
                    <div class="list-name">
                        <span class="red">*</span>
                        <label>开户银行地点</label>
                    </div>
                    <div class="list-input picker_area_div">
                        <div class="sel-choice">
                            <i class="down-icon"></i>
                            <input type="hidden" id="province_name" name="insPaymentInfoVo.province_name">
                            <select class="default picker_province_code myValid" id="picker_province_code_p"
                                    name="insPaymentInfoVo.province_code" style="height: 45px;width: 145px">
                                <option value="0" selected>请选择省</option>
                            </select>
                        </div>
                        <div class="sel-choice">
                            <i class="down-icon"></i>
                            <input type="hidden" id="city_name" name="insPaymentInfoVo.city_name">
                            <select class="default picker_region_code myValid" id="picker_region_code_p" name="insPaymentInfoVo.region_code"
                                    style="height: 45px;width: 145px">
                                <option value="0" selected>请选择市</option>
                            </select>
                        </div>
                    </div>
                </li>
                <li>
                    <div class="list-name">
                        <span class="red">*</span>
                        <label>银行账号</label>
                    </div>
                    <div class="list-input">
                        <input type="text" class="inp myValid" id="client_bank_account" name="insPaymentInfoVo.client_bank_account">
                    </div>
                </li>
                <li>
                    <div class="list-name" style="width: 300px;"></div>
                    <div class="list-input">
                        <button class="btn an_save save" DATA-STA="1" type="button">提交</button>
                        <button class="btn an_save back" style="margin-right: 16px;" DATA-STA="0" type="button">暂存</button>
                        <button class="btn an_back back" type="button" >返回</button>
                    </div>
                </li>
            </ul>
        </form>
        <!--表单内容结束-->
    </div>
    <!--右边编辑常用联系人结束  个人用户-->

</div>
<!--附件信息弹窗-->
<div class="details-popover animated" style="position: absolute!important;width: 770px;margin-left:-350px;top:550px">
    <div class="popover-cont">
        <div class="popo-head">
            <span>理赔所需材料说明（点击下载模板）</span>
            <a href="javascript:;" id="popo-bi">
                <img src="<c:url value='/resources/versions-2.0.2/images/popo-bi.png'/>">
            </a>
        </div>
        <div id="loadRecordDetail">
            <div class="popo-content" style="height: auto">
                <ul class="popo-header clearfix">
                    <li style="width: 100%;text-align: inherit;">
                        <span style="padding: 5px">一、单证类资料（填写后盖章拍照上传）</span>
                    </li>
                </ul>
                <ul class="popo-tbody">
                    <li style="float: none;padding-left: 35px;height:auto;border-bottom:none">
                        <p style="line-height: 25px;margin-top: 10px;">1、<a href="<c:url value='/resources/files/平安索赔申请书0602.doc' />">索赔申请书</a>（加盖公章）；</p>
                        <p style="line-height: 35px;">2、<a href="<c:url value='/resources/files/赔付意向及权益转让书.doc' />">赔付协议及权益转让书</a>（加盖公章）；</p>
                    </li>
                </ul>
                <ul class="popo-header clearfix">
                    <li style="width: 100%;text-align: inherit;">
                        <span style="padding: 5px">二、常规必备材料类（准备完毕后拍照上传）</span>
                    </li>
                </ul>
                <ul class="popo-tbody">
                    <li style="float: none;padding-left: 35px;height:auto;border-bottom:none">
                        <p style="line-height: 25px;margin-top: 10px;">1、手写一份<a href="<c:url value='/resources/files/事故经过说明.doc' />">事故经过说明</a>，写明事故发生时间、地点、就医等情况；</p>
                        <p style="line-height: 35px;">2、事故员工身份证复印件；</p>
                        <p style="line-height: 35px;">3、劳动合同（复印件）；</p>
                        <p style="line-height: 35px;">4、医院就诊材料：首诊病历、住院病历（如有住院）、医疗费发票、用药清单、诊断证明等医院病历材料；</p>
                    </li>
                </ul>
                <ul class="popo-header clearfix">
                    <li style="width: 100%;text-align: inherit;">
                        <span style="padding: 5px">三、误工费资料（需准备完毕后拍照上传，误工时间不足5天的，无需准备）</span>
                    </li>
                </ul>
                <ul class="popo-tbody">
                    <li style="float: none;padding-left: 35px;height:auto;border-bottom:none">
                        <p style="line-height: 25px;margin-top: 10px;">1、医生提供的病假条；</p>
                        <p style="line-height: 35px;">2、单位提供的休假记录，需公司由人事部门盖章；</p>
                    </li>
                </ul>
                <ul class="popo-header clearfix">
                    <li style="width: 100%;text-align: inherit;">
                        <span style="padding: 5px">四、其他特定情形案件材料，根据需要提供</span>
                    </li>
                </ul>
                <ul class="popo-tbody">
                    <li style="float: none;padding-left: 35px;height:auto;border-bottom:none">
                        <p style="line-height: 25px;margin-top: 10px;">1、如涉及交通及安监等事故：需提供相关部门出据的事故认定书；</p>
                        <p style="line-height: 35px;">2、如赔款超过1万元，需提供：</p>
                        <p style="line-height: 35px;">（1）公司营业执照、法人身份证复印件。经办人身份证复印件；</p>
                        <p style="line-height: 35px;">（2）被保险人员工有无工伤保险证明（加盖公章）；</p>
                        <p style="line-height: 35px;">（3）如员工上有工伤保险，需提供工伤认定书（非必备，有工伤的提供）；</p>
                        <p style="line-height: 35px;">3、涉及诉讼案件：需提供判决书原件及提交法院材料的复印件；</p>
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
<!--黑色蒙版-->
<div class="black-mask"></div>
<!--黑色蒙版2-->
<div class="black-mask-more"></div>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js'/>"></script>
<script src="<c:url value='/resources/version_new/js/jquery.form.js' />"></script>
<script src="<c:url value='/resources/version_new/js/jquery.formHelper.js' />"></script>
<script src="<c:url value='/resources/version_new/js/laydate/laydate.js' />"></script>
<script src="<c:url value='/resources/version_new/js/layer/layer.js' />"></script>
<script src="<c:url value='/resources/public/g.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<jsp:include page="../../index/multi_init_param.jsp"/>
</body>
<script type="text/javascript">
    var allright = true;
    var baseUrl = '${pageContext.request.contextPath }';
    function isWrong(el, obj, msg) {
        if (el) {
            $(obj).nextAll("span").remove();
            if (msg != "") $(obj).after("<span class='list-msg'>" + msg + "</span>");
            $(obj).addClass("err");
            allright = false;
            return false;
        } else {
            $(obj).nextAll("span").remove();
            $(obj).removeClass("err");
            return true;
        }
    }

    //只做标记不提示
    function isWrong2(el, obj) {
        if (el) {
            $(obj).addClass("err");
            allright = false;
            return false;
        } else {
            $(obj).removeClass("err");
            return true;
        }
    }

    function clearErr(obj) {
        $(obj).nextAll("span").remove();
        $(obj).removeClass("err");
    }

    // 详情弹窗的出现与消失
    $('.po-details').click(function () {
        $('.details-popover').show().addClass('fadeInDownBig').removeClass('fadeOutUpBig');
        $('.black-mask').show();
        var s = $('.popo-tbody').height();
        if(s <= 400){

            $('.details-popover .popo-content').css({"overflow":"hidden"})
        }
    });
    $('#popo-bi').click(function () {
        $('.details-popover').hide().addClass('fadeOutUpBig').removeClass('fadeInDownBig');
        $('.black-mask').hide();
    });
    function setCode(type){
        var data = [];
        if(type==1){
            data = [
                {id:'1',text:"组织机构代码证"},
                {id:'6',text:"税务登记证"},
                {id:'7',text:"营业执照"},
                {id:'2',text:"三证合一统一信用代码"}
            ];
        }else{
            data = [
                {id:'0',text:"身份证"},
                {id:'3',text:"护照"},
                {id:'4',text:"台胞证"},
                {id:'5',text:"回乡证"}
            ];
        }
        var str = "<option value=''>请选择证件类型</option>";
        for(var i in data){
            if (data[i].id != undefined) str += "<option value='"+data[i].id+"'>"+data[i].text+"</option>";
        }
        $('#client_certificate_type').html(str);
    }

    function codeToName(_sign,_code){
        var _name = '';
        if(_sign!=''){
            if('10' == _sign){
                _name = '索赔申请书（加盖公章）';
            }else if('11' == _sign){
                _name = '赔付协议及权益转让书（加盖公章）';
            }else if('12' == _sign){
                _name = '事故经过说明';
            }else if('13' == _sign){
                _name = '劳动合同（复印件）';
            }else if('14' == _sign){
                _name = '首诊病历、住院病历、医疗费发票、用药清单、诊断证明等医院病历材料';
            }else if('15' == _sign){
                _name = '医生提供的病假条';
            }else if('16' == _sign){
                _name = '单位休假记录，需公司由人事部门盖章';
            }else if('17' == _sign){
                _name = '事故认定书';
            }else if('18' == _sign){
                _name = '公司营业执照、法人身份证复印件。经办人身份证复印件';
            }else if('19' == _sign){
                _name = '被保险人员工有无工伤保险证明（加盖公章）';
            }else if('20' == _sign){
                _name = '工伤认定书';
            }else if('21' == _sign){
                _name = '判决书原件及提交法院材料的复印件';
            }else if('22' == _sign){
                _name = '事故员工身份证复印件';
            }else if('01' == _sign){
                _name = '身份证';
            }else if('02' == _sign){
                _name = '劳动合同';
            }else if('03' == _sign){
                _name = '事故经过';
            }else if('04' == _sign){
                _name = '门诊病历';
            }else if('05' == _sign){
                _name = '医疗费发票';
            }else if('06' == _sign){
                _name = '用药清单';
            }else if('07' == _sign){
                _name = '误工费资';
            }else if('08' == _sign){
                _name = '其他证明资料';
            }
        }else{
            if('001000' == _code){
                _name = '索赔申请书（加盖公章）';
            }else if('007003' == _code){
                _name = '赔付协议及权益转让书（加盖公章）';
            }else if('003019' == _code){
                _name = '事故经过说明';
            }else if('003007' == _code){
                _name = '劳动合同（复印件）';
            }else if('004005' == _code){
                _name = '首诊病历、住院病历、医疗费发票、用药清单、诊断证明等医院病历材料';
            }else if('004006' == _code){
                _name = '医生提供的病假条';
            }else if('004006' == _code){
                _name = '单位休假记录，需公司由人事部门盖章';
            }else if('003012' == _code){
                _name = '事故认定书';
            }else if('006004' == _code){
                _name = '公司营业执照、法人身份证复印件。经办人身份证复印件';
            }else if('003001' == _code){
                _name = '被保险人员工有无工伤保险证明（加盖公章）';
            }else if('003007' == _code){
                _name = '工伤认定书';
            }else if('005000' == _code){
                _name = '判决书原件及提交法院材料的复印件';
            }else if('006005' == _code){
                _name = '事故员工身份证复印件';
            }
        }
        return _name;
    }

    $("input[name='insPaymentInfoVo.bank_account_attribute']").on("change", function () {
        var val = $(this).val();
        if (val == '0') {
            setCode(1);
        } else {
            setCode(0);
        }
    });
    $(document).ready(function () {
        $('.an_back').hide();
        // JavaScript Document
        !function(){
            laydate.skin('molv');//切换皮肤，请查看skins下面皮肤库
            if($("#accident_date")){
                laydate({
                    elem: '#accident_date',
                    istime: true,
                    format: 'YYYY-MM-DD hh:mm:ss',
                    choose: function(){
                        $("#accident_date").blur();
                    }
                });//绑定元素
            }
        }();


        //点击下拉选择
        $(".list-input").on("change", '.sel-list', function () {
            var val = $(this).val();
            if (val === 0) {
                $(this).addClass('default');
            } else {
                $(this).removeClass('default');
            }
        });
        setCode(0);
        if('${report_id}' != ''){
            $.ajax({
                type : 'POST',
                url : baseUrl + "/api/report/queryByID/${report_id}?ACCESS_TOKEN=${ACCESS_TOKEN}",
                data : {},
                dataType : "json",
                success : function(json) {
                    $("#defaultForm").setForm(json);
                    if(json.insPaymentInfoVo){
                        var _pay = json.insPaymentInfoVo;
                        var _pay2 = {};
                        Object.keys(_pay).forEach(key => _pay2['"insPaymentInfoVo.'+key+'"'] = _pay[key]);
                        $("#defaultForm").setForm(_pay2);
                        if (_pay.region_code != undefined) {
                            $("#picker_province_code_p").change();
                            $("#picker_region_code_p").val(_pay.region_code);
                        }
                    }
                    if (json.injured_detail != undefined && json.injured_detail != '') {
                        var _inj = json.injured_detail;
                        _inj.indexOf('01')>-1?$('#injured_detail_1').prop('checked','checked'):'';
                        _inj.indexOf('02')>-1?$('#injured_detail_2').prop('checked','checked'):'';
                        _inj.indexOf('03')>-1?$('#injured_detail_3').prop('checked','checked'):'';
                    }
                    if (json.accident_county_code != undefined) {
                        $("#picker_province_p").change();
                        $("#picker_city_p").val(json.accident_city_code);
                        $("#picker_city_p").change();
                        $("#picker_district_p").val(json.accident_county_code);
                    }
                    if (json.accident_cause_level_1 != undefined) {
                        $(".accident_cause_level_1").change();
                        $(".accident_cause_level_2").val(json.accident_cause_level_2);
                    }
                    if(json.claimInformationVoList && json.claimInformationVoList.length>0){
                        $.each(json.claimInformationVoList, function(i, obj){
                            if(obj.status == '0'){
                                var _sign = obj.file_key.substring(2,3)=='-'?obj.file_key.substring(0,2):'';
                                if('006005' == obj.short_group_code){
                                    setOneUploadInput(obj.short_group_code,codeToName(_sign,obj.short_group_code),_sign,obj.file_key,obj.file_name,obj.file_path);
                                }else {
                                    addUploadInput(obj.short_group_code,codeToName(_sign,obj.short_group_code),_sign,obj.file_key,obj.file_name,obj.file_path);
                                }
                            }
                        });
                    }
                }
            });
        }
        contacts();
    });
    var _tn = 0;
    function contacts() {

        $("#reporter_name").bind("blur keyup.pev", function () {
            var r1 = isWrong($(this).val().trim() == "", this, "报案人姓名必填");
            if (!r1) return r1;
            var r2 = isWrong(!/^[\u4e00-\u9fa5a-zA-Z0-9]{2,30}$/.test($(this).val()), this, "报案人姓名为2-30个中英文字母");
        });
        $("#accident_date").bind("blur keyup.pev", function () {
            var r1 = isWrong($(this).val().trim() == "", this, "事故时间不能为空");
            if (!r1) return r1;
        });
        $("input[name='injured_detail']").bind("blur keyup.pev", function () {
            var _id = $(this).attr('id');
            if($('#'+_id).attr('checked') == undefined){
                if(_id == 'injured_detail_1'){
                    $("#outpatient_list").removeClass('myValid');
                    $("#outpatient_list").removeClass('err');
                    $("#outpatient_list").unbind("blur keyup.pev");
                }else if(_id == 'injured_detail_2'){
                    $("#maim_list").removeClass('myValid');
                    $("#maim_list").removeClass('err');
                    $("#maim_list").unbind("blur keyup.pev");
                }else if(_id == 'injured_detail_3'){
                    $("#demise_list").removeClass('myValid');
                    $("#demise_list").removeClass('err');
                    $("#demise_list").unbind("blur keyup.pev");
                }
            }
            var r1 = isWrong2(!$("input[type='checkbox']").is(':checked'), this);
            if (!r1){
                _tn++;
                if(_tn==6){
                    _tn = 0;
                    return;
                }
                if(_tn == 1){
                    layer.alert('人伤类型不能为空', {
                        icon: 2, closeBtn: 0, yes: function () {
                            layer.closeAll();
                        }
                    });
                }
                return r1;
            }
            var rs = $(this).val();
            if(rs.indexOf('01')>-1&&$('#'+_id).attr('checked') == 'checked'){
                $("#outpatient_list").addClass('myValid');
                $("#outpatient_list").bind("blur keyup.pev", function () {
                    var r2 = isWrong2($('#outpatient_list').val().trim() == "", this);
                    if (!r2){
                        layer.alert('门诊人员姓名不能为空', {
                            icon: 2, closeBtn: 0, yes: function () {
                                layer.closeAll();
                            }
                        });
                        return r2;
                    }
                });
            }else if(rs.indexOf('02')>-1&&$('#'+_id).attr('checked') == 'checked'){
                $("#maim_list").addClass('myValid');
                $("#maim_list").bind("blur keyup.pev", function () {
                    var r2 = isWrong2($('#maim_list').val().trim() == "", this);
                    if (!r2){
                        layer.alert('住院、伤残人员姓名不能为空', {
                            icon: 2, closeBtn: 0, yes: function () {
                                layer.closeAll();
                            }
                        });
                        return r2;
                    }
                });
            }else if(rs.indexOf('03')>-1&&$('#'+_id).attr('checked') == 'checked'){
                $("#demise_list").addClass('myValid');
                $("#demise_list").bind("blur keyup.pev", function () {
                    var r2 = isWrong2($('#demise_list').val().trim() == "", this);
                    if (!r2){
                        layer.alert('死亡人员姓名不能为空', {
                            icon: 2, closeBtn: 0, yes: function () {
                                layer.closeAll();
                            }
                        });
                        return r2;
                    }
                });
            }
        });
        $("#client_bank_account").bind("blur keyup.pev", function () {
            var r1 = isWrong($(this).val().trim() == "", this, "银行账号必填");
            if (!r1) return r1;
            var r2 = isWrong(!/^\d{8,30}$/.test($(this).val()), this, "银行账号错误");
        });
        $("#client_name").bind("blur keyup.pev", function () {
            var r1 = isWrong($(this).val().trim() == "", this, "开户姓名必填");
            if (!r1) return r1;
            var r2 = isWrong(!/^[\u4e00-\u9fa5a-zA-Z0-9\（\）]{2,40}$/.test($(this).val()), this, "开户姓名为2-40个中英文字母");
        });
        $("#file_path_0").bind("blur keyup.pev", function () {
            var r1 = isWrong2($(this).val().trim() == "", this); //事故员工身份证复印件附件必传 TODO 下拉框bug，不提示，否则css混乱
            if (!r1){
                layer.alert('事故员工身份证复印件附件必传', {
                    icon: 2, closeBtn: 0, yes: function () {
                        layer.closeAll();
                    }
                });
            }
        });
        $("#client_certificate_type").bind("blur keyup.pev", function () {
            var r1 = isWrong($(this).val().trim() == "", this, "证件类型必填"); //证件类型必填 TODO 下拉框bug，不提示，否则css混乱
        });
        $("#client_bank_code").bind("blur keyup.pev", function () {
            var r1 = isWrong($(this).val().trim() == "", this, "开户银行必填"); //开户银行必填 TODO 下拉框bug，不提示，否则css混乱
        });
        $("#picker_district_p").bind("blur keyup.pev", function () {
            var r1 = isWrong($(this).val().trim() == "", this, "事故地点必填"); //事故地点必填 TODO 下拉框bug，不提示，否则css混乱
        });
        $("#picker_region_code_p").bind("blur keyup.pev", function () {
            var r1 = isWrong($(this).val().trim() == "", this, "开户银行市必填"); //开户银行市必填 TODO 下拉框bug，不提示，否则css混乱
        });
        $("#accident_cause_level_2").bind("blur keyup.pev", function () {
            var r1 = isWrong($(this).val().trim() == "", this, "事故原因必填"); //事故原因必填 TODO 下拉框bug，不提示，否则css混乱
        });
        $("#client_certificate_no").bind("blur keyup.pev", function () {
            var r1 = isWrong($(this).val().trim() == "", this, "证件号码必填");
            if (!r1) return r1;
            var r2 = isWrong(!/^[a-zA-Z0-9]{5,40}$/.test($(this).val()), this, "证件号码为5-40个数字英文");
        });
        $("#reporter_tel").bind("blur keyup.pev", function () {
            var r1 = isWrong($(this).val().trim() == "", this, "手机号码必填");
            if (!r1) return r1;
            var r2 = isWrong(!/^1[2|3|4|5|6|7|8|9]\d{9}$/.test($(this).val()), this, "请输入正确手机号码");
        });
        $("#accident_place").bind("blur keyup.pev", function () {
            var r1 = isWrong($(this).val().trim() == "", this, "详细地址必填");
            if (!r1) return r1;
            var r2 = isWrong(!/^[\u4e00-\u9fa5_a-zA-Z0-9_\-\（\）]{1,100}$/.test($(this).val()), this, "请输入详细地址");
        });
        $("#accident_process").bind("blur keyup.pev", function () {
            var r1 = isWrong($(this).val().trim() == "", this, "事故经过必填");
            if (!r1) return r1;
            var r2 = isWrong($(this).val().trim().length>500, this, "请输入不超过500字符的描述");
        });

        // 报案保存
        $('.an_save').click(function () {
            allright = true;
            var _status = $(this).attr('DATA-STA');
            if(_status!='0'){//暂存不校验
                _tn = 0;
                $(".myValid").each(function () {
                    $(this).trigger("blur");
                    if ($(this).hasClass("err")) $(this).focus();
                }); //校验表单
                if(allright){
                    if($("#injured_detail_1").is(':checked')){
                        var r2 = isWrong2($('#outpatient_list').val().trim() == "", this);
                        if (!r2){
                            layer.alert('门诊人员姓名不能为空', {
                                icon: 2, closeBtn: 0, yes: function () {
                                    layer.closeAll();
                                }
                            });
                            return r2;
                        }
                    }
                    if($("#injured_detail_2").is(':checked')){
                        var r2 = isWrong2($('#maim_list').val().trim() == "", this);
                        if (!r2){
                            layer.alert('住院、伤残人员姓名不能为空', {
                                icon: 2, closeBtn: 0, yes: function () {
                                    layer.closeAll();
                                }
                            });
                            return r2;
                        }
                    }
                    if($("#injured_detail_3").is(':checked')){
                        var r2 = isWrong2($('#demise_list').val().trim() == "", this);
                        if (!r2){
                            layer.alert('死亡人员姓名不能为空', {
                                icon: 2, closeBtn: 0, yes: function () {
                                    layer.closeAll();
                                }
                            });
                            return r2;
                        }
                    }
                }
                if(allright) {
                    $.ajaxSettings.async = false;
                    $.get('/pc/report/isValidTime?order_id=' + $('#ins_insurance_slip_id').val() + '&time=' + $('#accident_date').val()+'&ACCESS_TOKEN=${ACCESS_TOKEN}', function (data) {
                        if (data.statusCode != '200') {
                            layer.alert('事故时间必须在生效日期内并且不能大于当前时间', {
                                icon: 2, closeBtn: 0, yes: function () {
                                    layer.closeAll();
                                    $('#accident_date').focus();
                                }
                            });
                            allright = false;
                        }
                    });
                    $.ajaxSettings.async = true;
                }
            }
            if (allright) {
                var _out = $('#outpatient_list').val();_out != '' ? $('#outpatient_list').val(_out.replace('，',',')) : '';
                var _maim = $('#maim_list').val();_maim != '' ? $('#maim_list').val(_maim.replace('，',',')) : '';
                var _demise = $('#demise_list').val();_demise != '' ? $('#demise_list').val(_demise.replace('，',',')) : '';
                var data = $("#defaultForm").serializeJson();
                data.status = _status;
                data.policy_no = $('#policy_no').val();
                $.ajax({
                    type : 'POST',
                    url : baseUrl + "/api/report/saveReport?ACCESS_TOKEN=${ACCESS_TOKEN}",
                    data : data,
                    dataType : "json",
                    success : function(json) {
                        if(json.statusCode == "200"){
                            layer.alert(json.message, {
                                icon: 1, closeBtn: 0, yes: function () {
                                    layer.closeAll();
                                    $(".an_back").trigger("click");
                                }
                            });
                        }else{
                            layer.alert(json.message, {
                                icon: 2, closeBtn: 0, yes: function () {
                                    layer.closeAll();
                                }
                            });
                        }
                    }
                });
            }
        });
    }

    //点击返回按钮
    $(".list-input").on("click", '.an_back', function () {
        window.location.href = baseUrl + '/api/report/reportList?ACCESS_TOKEN=${ACCESS_TOKEN}';
    });

    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/report/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"report/",type);
        flag = true;
        return flag;
    }
    function random4() {
        return (((1 + Math.random()) * 0x10000) | 0).toString(16).substring(1);
    };
    function createUUID() {
        return (random4() + random4() + "-" + random4() + "-" + random4() + "-" + random4() + random4());
    };

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = laySomenType(0,null,'',0);
        var _times = (new Date()).getTime();
        var fileName = _times+"."+fileType;
        var _sign = $('#'+_id+'_file-5').attr('data-sign');
        var fileId = _sign + '-' + createUUID();
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', fileName);
        formData.append('fileId', fileId);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoadPA';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                laySomenType(2,index,'',0);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                    $("#"+_id.replace('file_path','file_name')).val(fileName);
                    $("#"+_id.replace('file_path','file_key')).val(fileId);
                }else{
                    laySomenType(1,null,result.message,0);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }

    function setOneUploadInput(_short_code,_cl_title,_sign,_key,_name,_url){
        var _t = _cl_title.length>21?(_cl_title.substring(0,20)+'...'):_cl_title;
        var _input = '<input type="hidden" name="claimInformationVoList[0].short_group_code" id="short_group_code_0" value="'+_short_code+'">'+
            '<input type="hidden" name="claimInformationVoList[0].file_key" id="file_key_0" value="'+_key+'">'+
            '<input type="hidden" name="claimInformationVoList[0].file_name" id="file_name_0" value="'+_name+'">'+
            '<input class="myValid" type="hidden" name="claimInformationVoList[0].file_path" id="file_path_0" value="'+_url+'">'+
            '<div>'+
            '<input name="file_path_0_file" id="file_path_0_file-5" data-sign="'+_sign+'" data-drawview="'+_url+'" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon=""/>'+
            '</div>'+
            '<span class="mt-db-7f" title="'+_cl_title+'">'+_t+'</span>';
        $('#one_upload_input').html(_input);
        initDoFile();
    }

    function addUploadInput(_short_code,_cl_title,_sign,_key,_name,_url){
        _key = _key==undefined?'':_key;
        _name = _name==undefined?'':_name;
        _url = _url==undefined?'':_url;
        var _num = Number($('#uploadInputNum').val())+1;
        var _fileNum = Number($('#fileNum').val())+1;
        if(_fileNum>9){
            return;
        }else if(_fileNum<4){
            $('#uploadInputNum').parent().attr('style','height:320px;');
        }else if(_fileNum>3&&_fileNum<7){
            $('#uploadInputNum').parent().attr('style','height:613px;');
        }else if(_fileNum>6&&_fileNum<10){
            $('#uploadInputNum').parent().attr('style','height:860px;');
        }
        var _t = _cl_title.length>21?(_cl_title.substring(0,20)+'...'):_cl_title;
        var _input = '<div class="col-sm-4 col-xs-4">'+
            '<input type="hidden" name="claimInformationVoList['+_num+'].short_group_code" id="short_group_code_'+_num+'" value="'+_short_code+'">'+
            '<input type="hidden" name="claimInformationVoList['+_num+'].file_key" id="file_key_'+_num+'" value="'+_key+'">'+
            '<input type="hidden" name="claimInformationVoList['+_num+'].file_name" id="file_name_'+_num+'" value="'+_name+'">'+
            '<input class="myValid" type="hidden" name="claimInformationVoList['+_num+'].file_path" id="file_path_'+_num+'" value="'+_url+'">'+
            '<div>'+
            '<input name="file_path_'+_num+'_file" id="file_path_'+_num+'_file-5" data-sign="'+_sign+'" data-drawview="'+_url+'" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon=""/>'+
            '</div>'+
            '<span class="mt-db-7f" title="'+_cl_title+'">'+_t+'</span>'+
            '</div>';
        $('#some_upload_bl').append(_input);
        $('#uploadInputNum').val(_num);
        $('#fileNum').val(_fileNum);
        initDoFile();
    }

    function initDoFile(){
        var $input = $('input.file[type=file]'), count = $input.attr('type') ? $input.length : 0;
        if (count > 0) {
            $input.each(function(a,b){
                var type_img = ['.jpg','.jpeg','.gif','.png','.psd','.tiff','bmp'];
                var type_wj = ['.txt','.pdf','.doc','.docx','.ppt','.rar','.zip','.tar'];

                var maxFileSize = 20480;//文件限制20M(20480KB)
                var paths = $(b).attr('data-drawview');
                var name = paths;
                var allowedFiles = $(b).attr('data-allowedFileExtensions');
                var fileType = $(b).attr("data-preview-file-type");
                var allowedFileArr = new Array();//创建一个数组
                if(allowedFiles == undefined || allowedFiles == ""){
                    if(fileType == undefined || fileType == ""){
                        allowedFileArr = ["jpg","png","gif","jpeg","bmp","BMP","JPG","PNG","GIF","JPEG","doc","docx","xml","txt","pdf","ppt","xls","xlsx","rar","zip"];
                    }else if(fileType == "image"){
                        allowedFileArr =["jpg","png","gif","jpeg","bmp","BMP","JPG","PNG","GIF","JPEG"];
                        maxFileSize = 8192; //图片限制2M(2048KB)
                    }else{
//        				allowedFileArr =["doc","docx","xml","txt","pdf","ppt","xls","xlsx","rar","zip"];
                        allowedFileArr = ["jpg","png","gif","jpeg","bmp","BMP","JPG","PNG","GIF","JPEG","doc","docx","xml","txt","pdf","ppt","xls","xlsx","rar","zip"];
                    }
                }else{
                    allowedFileArr = allowedFiles.replace("[","").replace("]","").split(",");
                }
                if(paths != undefined && paths != '' && paths.length>1){
                    var code = "";
                    for(var i=0;i<type_img.length;i++){
                        if(code != "1"){
                            if(paths.replace(type_img[i])){
                                code = "1";
                                paths = '<img src="'+paths+'" class="file-preview-image" title="'+name+'" alt="'+name+'" style="width:200px;height:154px;">';
                            }
                        }
                    }
                    if(code == ""){
                        for(var i=0;i<type_wj.length;i++){
                            if(code != "2"){
                                if(paths.replace(type_wj[i])){
                                    code = "2";
                                }
                            }
                        }
                    }
                    if(code == "1"){
                        name = name.split("/")[name.split("/").length-1];
                        $(b).fileinput({
                            allowedFileExtensions: allowedFileArr,//接收的文件后缀
                            maxFileSize:maxFileSize,
                            initialPreview: [
                                paths
                            ],
                            initialPreviewAsData: true,
                            initialPreviewFileType: 'image',
                            deleteUrl: "/site/file-delete",
                            overwriteInitial: true,
                            initialPreviewConfig: [
                                {caption: name, size: 576237, width: "210px", url: "/site/file-delete", key: 1},
                            ]
                        });
                    }else if(code == "2"){
                        $(b).fileinput({
                            allowedFileExtensions: allowedFileArr,//接收的文件后缀
                            maxFileSize:maxFileSize,
                            initialPreview: [
                                paths
                            ]
                        });
                    }
                }else
                    $(b).fileinput({
                        allowedFileExtensions: allowedFileArr,//接收的文件后缀
                        maxFileSize:maxFileSize
                    });


            });
            deleteUploadDiv();
        }
    }
    function deleteUploadDiv(){
        //先清除已绑定的双击事件，避免之前已绑定第二遍重复绑定
        $('.file-drop-zone').unbind('dblclick');
        //重新绑定双击事件
        $('.file-drop-zone').dblclick(function(){
            var _div = $(this).parent().parent().parent().parent();
            if(_div.prev().length>0){
                _div.remove();
                var _fileNum = Number($('#fileNum').val())-1;
                $('#fileNum').val(_fileNum);
                if(_fileNum>9){
                    return;
                }else if(_fileNum<4){
                    $('#uploadInputNum').parent().attr('style','height:320px;');
                }else if(_fileNum>3&&_fileNum<7){
                    $('#uploadInputNum').parent().attr('style','height:613px;');
                }else if(_fileNum>6&&_fileNum<10){
                    $('#uploadInputNum').parent().attr('style','height:860px;');
                }
            }
        });
    }
</script>

</html>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>