<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<div class="cont-sd">
	<ul class="cont-head clearfix">
		<li class="cont-s1">
			<input type="checkbox" name="securityScopes" id="securityScope" value="1">
			<label for="securityScope" class="pull-left"></label>
			<strong<%-- class="pull-left"--%>>全选</strong>
		</li>
		<li class="cont-s1">
			<span>姓名</span>
		</li>
		<li class="cont-s1">
			<span>证件类型</span>
		</li>
		<li class="cont-s2">
			<span>证件号</span>
		</li>
		<li class="cont-s3">
			<span>手机号</span>
		</li>
		<li class="cont-s1">
			<span>工种</span>
		</li>
		<li class="cont-s1">
			<span>出生日期</span>
		</li>
	</ul>
</div>
<div class="cont-wed">
	<ul>
		<c:choose>
			<c:when test="${empty resultSetList }">
				<li class="clearfix" style="text-align: center;line-height: -moz-block-height;">
					暂无记录！！
				</li>
			</c:when>
			<c:otherwise>
				<c:forEach items="${resultSetList }" var="resultSet" varStatus="i">
					<li class="clearfix">
						<div class="wed-select wed-qwe cont-s1">
							<c:if test="${empty resultSet.ins_preservation_result_set_id }">
								<input type="checkbox" name="oids" id="oids_${i.index}" value="${resultSet.belong_to_id };${resultSet.belong_to_type }" onchange="checkOnly(this,'checkSome')">
							</c:if>
							<c:if test="${not empty resultSet.ins_preservation_result_set_id }">
								<input type="checkbox" name="oids" id="oids_${i.index}" value="${resultSet.ins_preservation_result_set_id };THIS" onchange="checkOnly(this,'checkSome')">
							</c:if>
							<label for="oids_${i.index}" class="pull-left"></label>
						</div>
						<div class="wed-select cont-s1">
							<span>${resultSet.name }</span>
						</div>
						<div class="wed-select cont-s1">
							<span>
								<c:if test="${empty resultSet.id_type}">-</c:if>
								${fns:getDictLabel (resultSet.id_type,"idType","")}
							</span>
						</div>
						<div class="wed-select cont-s2">
							<span>${resultSet.id_card }</span>
						</div>
						<div class="wed-select cont-s3">
							<span>${resultSet.tel }</span>
						</div>
						<div class="wed-select cont-s1">
							<span>${resultSet.career eq '1' ? '内勤人员' : resultSet.career eq '2' ? '保安人员' : resultSet.career eq '3' ? '武装押运人员' : resultSet.career eq '4' ? '保洁人员' : '-'}</span>
						</div>
						<div class="wed-select cont-s1">
							<span>${resultSet.birthday }</span>
						</div>
					</li>
				</c:forEach>
			</c:otherwise>
		</c:choose>
	</ul>
</div>
<%--
<p class="cont-number">
	共<i>20</i>人，已选择<b>1</b>人
</p>--%>
<script>
    // 全选
    $('input#securityScope').click(function () {
        var s = $(this).is(':checked');
        $(".wed-qwe input[type='checkbox']").each(function () {
            this.checked = s;
            checkOnly(this,'checkSome');
        })
    });
    $(function(){
        $(".wed-qwe input[type='checkbox']").each(function () {
			var _checkSome = $("#checkSome").val();
            if(_checkSome.indexOf($(this).val()) != -1){
                this.checked = true;
			}
        })
	});
</script>