<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
	<head>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
<body>
<div class="container"><!-- container start -->
    <ol class="breadcrumb" id="bread_crumbs">
    </ol>
    <div class="message-war"><!-- message-war start -->
        <h2>${ dto.product_name}</h2>
        <div class="w-95-auto"><!-- w-95-auto start -->
            <h5><c:if test="${ not empty dto.external_reference }">保单号码：${ dto.external_reference}</c:if><c:if test="${ empty dto.external_reference }">订单号码：${ dto.trade_serial_number}</c:if></h5>
            <div class="mess-title"><h3>推荐人信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">推荐人的手机号或编号</td>
                        <td class="col-sm-4 col-xs-4">${empty vo.recommend_code ? '无' : vo.recommend_code}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                        <td class="col-sm-4 col-xs-4"></td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>投保单位信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">投保单位</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].name_cn}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">所属行业</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].industry}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">营业性质</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:forEach items="${natureList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[0].com_nature}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                            <c:forEach items="${natureList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[0].nature_two}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                        </td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:forEach items="${typeList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[0].id_type}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                        </td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号码</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].organization_code}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">企业总人数</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].total_emp}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件有效期类型</td>
                        <td class="col-sm-4 col-xs-4">${fns:getDictLabel (vo.roleSubjectList[0].id_option,"idOption","")}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">有效期起止</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].id_star_date} ~ ${vo.roleSubjectList[0].id_end_date}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">注册地址</td>
                        <td class="col-sm-4 col-xs-4">
                            ${reg_role}
                            ${vo.roleSubjectList[0].reg_address}
                        </td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">办公地址</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].do_business_address}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">办公电话</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].phone}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人姓名</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_name}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人手机</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_tel}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人email</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_email}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系部门</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_section}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">邮政编码</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].zip_code}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>被保险人信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-1 col-xs-1">序号</td>
                        <td class="tablebg_f5f8fa col-sm-1 col-xs-1">被保险人姓名</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">被保险人证件类型</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">被保险人证件号码</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">被保险人出生日期</td>
                        <td class="tablebg_f5f8fa col-sm-1 col-xs-1">被保险人性别</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">被保险人职业</td>
                        <td class="tablebg_f5f8fa col-sm-1 col-xs-1">被保险人手机</td>
                    </tr>
                    <c:if test="${vo.roleSubjectList!=null}">
                        <c:forEach begin="2" end="${ vo.roleSubjectList.size() }" varStatus="index">
                            <c:set var="doIndex" value="${index.index-1}"/>
                            <tr>
                                <td class="col-sm-1 col-xs-1">${doIndex}</td>
                                <td class="col-sm-1 col-xs-1">${ vo.roleSubjectList[doIndex].name_cn}</td>
                                <td class="col-sm-2 col-xs-2">
                                    <c:forEach items="${typeList }" var="list">
                                        <c:if test="${list.value eq vo.roleSubjectList[doIndex].id_type}">
                                            ${list.name}
                                        </c:if>
                                    </c:forEach>
                                </td>
                                <td class="col-sm-2 col-xs-2">${ vo.roleSubjectList[doIndex].organization_code}</td>
                                <td class="col-sm-2 col-xs-2">${ vo.roleSubjectList[doIndex].birth_date}</td>
                                <td class="col-sm-1 col-xs-1">${empty vo.roleSubjectList[doIndex].sex ? '':vo.roleSubjectList[doIndex].sex eq '1'?'男':'女'}</td>
                                <td class="col-sm-2 col-xs-2">
                                        ${ vo.roleSubjectList[doIndex].major_group eq '1' ? '内勤人员' : vo.roleSubjectList[doIndex].major_group eq '2' ? '保安人员' : '武装押运人员'}
                                </td>
                                <td class="col-sm-1 col-xs-1">${ vo.roleSubjectList[doIndex].mobile}</td>
                            </tr>
                        </c:forEach>
                    </c:if>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>身故受益人信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">受益人</td>
                        <td colspan="3" class="col-sm-10 col-xs-10">法定继承人</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <c:if test="${fn:contains(dto.product_code, 'TYX-QH-DQ')||fn:contains(dto.product_code, 'TYX-HT-DQ')}">
                <div class="mess-title"><h3>投保基本信息</h3></div>
                <div class="affirm-warr">
                    <table class="table ">
                        <tbody>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">活动名称</td>
                            <td class="col-sm-4 col-xs-4">${vo.specialExhibitionVo.name}</td>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">活动时间</td>
                            <td class="col-sm-4 col-xs-4">${vo.specialExhibitionVo.star_time} ~ ${vo.specialExhibitionVo.end_time}</td>
                        </tr>
                        <tr>
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">活动举办地址</td>
                            <td class="col-sm-10 col-xs-10" colspan="3">${ex_pca}${vo.specialExhibitionVo.ex_address}</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </c:if>
            <div class="mess-title"><h3>投保计划信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <c:if test="${!fn:contains(dto.product_code, 'TYX-QH-DQ')&&!fn:contains(dto.product_code, 'TYX-HT-DQ')}">
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">起保日期</td>
                            <td class="col-sm-4 col-xs-4">${ vo.inception_date }</td>
                        </c:if>
                        <c:if test="${fn:contains(dto.product_code, 'TYX-QH-DQ')||fn:contains(dto.product_code, 'TYX-HT-DQ')}">
                            <td class="tablebg_f5f8fa col-sm-2 col-xs-2">保障日期</td>
                            <td class="col-sm-4 col-xs-4">自${ vo.inception_date }零时起 至${vo.planned_end_date}二十四时止</td>
                        </c:if>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">保费</td>
                        <td class="col-sm-4 col-xs-4">${dto.gross_premium}</td>
                    </tr>
                    <c:if test="${fn:contains(dto.product_code, 'TYX-PAS')}">
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">客户识别授权书</td>
                        <td class="col-sm-4 col-xs-4"><a href="${ vo.accredit_path }" target="_blank">查看</a></td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                        <td class="col-sm-4 col-xs-4"></td>
                    </tr>
                    </c:if>
                    <%--<c:choose>
                        <c:when test="${'TYX-RB-3' eq dto.product_code||'TYX-RB-4' eq dto.product_code||'TYX-RB-5' eq dto.product_code||'TYX-RB-6' eq dto.product_code}">
                            <tr>
                                <td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保障方案确认</td>
                                <td colspan="3" class="col-sm-10 col-xs-10">
                                    <table class="table ">
                                        <tbody>
                                        <tr>
                                            <td class="col-sm-4 col-xs-4"></td>
                                            <td class="col-sm-4 col-xs-4">保障责任</td>
                                            <td class="col-sm-4 col-xs-4">保障金额</td>
                                        </tr>
                                        <tr>
                                            <td class="col-sm-4 col-xs-4" rowspan="5">固定保障</td>
                                            <td class="col-sm-4 col-xs-4">意外身故/残疾</td>
                                            <td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 30 : dto.product_code eq 'TYX-RB-4' ? 40 : dto.product_code eq 'TYX-RB-5' ? 50 : dto.product_code eq 'TYX-RB-6' ? 60 : 0 } 万元</td>
                                        </tr>
                                        <tr>
                                            <td class="col-sm-4 col-xs-4">意外医疗</td>
                                            <td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 3 : dto.product_code eq 'TYX-RB-4' ? 4 : dto.product_code eq 'TYX-RB-5' ? 5 : dto.product_code eq 'TYX-RB-6' ? 6 : 0 } 万元</td>
                                        </tr>
                                        <tr>
                                            <td class="col-sm-4 col-xs-4">意外住院津贴</td>
                                            <td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 100 : dto.product_code eq 'TYX-RB-4' ? 100 : dto.product_code eq 'TYX-RB-5' ? 150 : dto.product_code eq 'TYX-RB-6' ? 200 : 0 } 元/天</td>
                                        </tr>
                                        <tr>
                                            <td class="col-sm-4 col-xs-4">猝死（身故）</td>
                                            <td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 10 : dto.product_code eq 'TYX-RB-4' ? 20 : dto.product_code eq 'TYX-RB-5' ? 20 : dto.product_code eq 'TYX-RB-6' ? 20 : 0 } 万元</td>
                                        </tr>
                                        <tr>
                                            <td class="col-sm-4 col-xs-4">救护车费用</td>
                                            <td class="col-sm-4 col-xs-4">1000 元</td>
                                        </tr>
                                        <c:if test="${vo.is_contain_repo eq '1'||vo.is_contain_repo eq '3'}">
                                            <tr>
                                                <td class="col-sm-4 col-xs-4" rowspan="1">可选保障一</td>
                                                <td class="col-sm-4 col-xs-4">疾病身故/全残</td>
                                                <td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 15 : dto.product_code eq 'TYX-RB-4' ? 20 : dto.product_code eq 'TYX-RB-5' ? 25 : dto.product_code eq 'TYX-RB-6' ? 30 : 0 } 万元</td>
                                            </tr>
                                        </c:if>
                                        <c:if test="${vo.is_contain_repo eq '2'||vo.is_contain_repo eq '3'}">
                                            <tr>
                                                <td class="col-sm-4 col-xs-4" rowspan="1">可选保障二</td>
                                                <td class="col-sm-4 col-xs-4">重大疾病</td>
                                                <td class="col-sm-4 col-xs-4">${dto.product_code eq 'TYX-RB-3' ? 15 : dto.product_code eq 'TYX-RB-4' ? 20 : dto.product_code eq 'TYX-RB-5' ? 25 : dto.product_code eq 'TYX-RB-6' ? 30 : 0 } 万元</td>
                                            </tr>
                                        </c:if>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                        </c:when>
                        <c:otherwise>
                            <tr>
                                <td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保障方案确认</td>
                                <td colspan="3" class="col-sm-10 col-xs-10">
                                    <table class="table ">
                                        <tbody>
                                        <tr>
                                            <td class="col-sm-6 col-xs-6">保障责任</td>
                                            <td class="col-sm-6 col-xs-6">保障金额</td>
                                        </tr>
                                        <c:forEach items="${ dto.responsibilityVoList }" var="irp">
                                            <tr>
                                                <td class="col-sm-6 col-xs-6" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>${irp.name}</td>
                                                <td class="col-sm-6 col-xs-6" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>${irp.fcy}${empty irp.compensation_days ? '元' : '元/天'}</td>
                                            </tr>
                                        </c:forEach>
                                        </tbody>
                                    </table>
                                </td>
                            </tr>
                        </c:otherwise>
                    </c:choose>--%>
                    <tr>
                        <td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保障方案</td>
                        <td colspan="3" class="col-sm-10 col-xs-10">
                            <table class="table ">
                                <tbody>
                                <tr>
                                    <td class="col-sm-4 col-xs-4">保障责任</td>
                                    <td class="col-sm-2 col-xs-2">
                                        <c:set var="irp_1" value="${ vo.responsibilityVoList[0] }"></c:set>
                                        <c:choose>
                                            <c:when test="${empty irp_1.insurance_amount_max && not empty irp_1.fcy}">
                                                保险金额
                                            </c:when>
                                            <c:when test="${empty irp_1.fcy && not empty irp_1.insurance_amount_max}">
                                                赔偿限额
                                            </c:when>
                                            <c:otherwise>
                                                保险金额
                                            </c:otherwise>
                                        </c:choose>
                                    </td>
                                    <td class="col-sm-2 col-xs-2">免赔额</td>
                                    <td class="col-sm-2 col-xs-2">赔付比例</td>
                                    <td class="col-sm-2 col-xs-2">免赔天数</td>
                                </tr>
                                <c:forEach items="${ vo.responsibilityVoList }" var="irp">
                                    <tr <c:choose>
                                        <c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '0' && irp.is_optional eq '2'}">
                                            hidden
                                        </c:when>
                                        <c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '1' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障一')}">
                                            hidden
                                        </c:when>
                                        <c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '2' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障二')}">
                                            hidden
                                        </c:when>
                                        <c:when test="${empty vo.is_contain_repo && irp.is_optional eq '2'}">
                                            hidden
                                        </c:when>
                                        <c:otherwise>

                                        </c:otherwise>
                                    </c:choose>>
                                        <td class="col-sm-4 col-xs-4" style="text-align:left; <c:if test="${irp.name eq '烈士褒扬金'}">color: red;</c:if>">${irp.name}<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="${irp.explain_product}"/></td>
                                        <td class="col-sm-2 col-xs-2" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>
                                            <c:choose>
                                                <c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
                                                    -
                                                </c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
                                                    <c:if test="${irp.fcy/10000 >= 1}">
                                                        ${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
                                                        万元
                                                    </c:if>
                                                    <c:if test="${irp.fcy/10000 < 1}">
                                                        ${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
                                                        元
                                                    </c:if>
                                                </c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
                                                    <c:if test="${irp.fcy/10000 >= 1}">
                                                        ${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
                                                        万元/天
                                                    </c:if>
                                                    <c:if test="${irp.fcy/10000 < 1}">
                                                        ${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
                                                        元/天
                                                    </c:if>
                                                </c:if>
											</span>
                                                </c:when>
                                                <c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
                                                    -
                                                </c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
                                                    <c:if test="${irp.insurance_amount_max/10000 >= 1}">
                                                        ${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
                                                        万元
                                                    </c:if>
                                                    <c:if test="${irp.insurance_amount_max/10000 < 1}">
                                                        ${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
                                                        元
                                                    </c:if>
                                                </c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
                                                    <c:if test="${irp.insurance_amount_max/10000 >= 1}">
                                                        ${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
                                                        万元/天
                                                    </c:if>
                                                    <c:if test="${irp.insurance_amount_max/10000 < 1}">
                                                        ${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
                                                        元/天
                                                    </c:if>
                                                </c:if>
											</span>
                                                </c:when>
                                                <c:otherwise>
                                                    <span>-</span>
                                                </c:otherwise>
                                            </c:choose>
                                        </td>
                                        <td class="col-sm-2 col-xs-2" >${empty irp.cumulative_deductibles ? '-' : irp.cumulative_deductibles}</td>
                                        <td class="col-sm-2 col-xs-2" >${empty irp.compensation_ratio ? '-' : irp.compensation_ratio}${not empty irp.compensation_ratio ? '%' : ''}</td>
                                        <td class="col-sm-2 col-xs-2" >${empty irp.deductible_days ? '-' : irp.deductible_days}</td>
                                    </tr>
                                </c:forEach>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>退保账户信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">开户名</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">${vo.roleSubjectList[0].account_name}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">账户开户行</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].bank_name}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">银行账号</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].bank_account}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>投保声明</h3></div>
            <div class="affirm-warr">
                <p class="mt30">1、投保人通过合法途径获得团体授权，向保险人投保本险种，所有投保操作和内容已获得认可，所有被保险人均为与投保单位有劳动关系的劳动者，该产品的保障内容以及保险金额已向被保险人进行了明确说明，并征得其同意。</p>
                <p>2、投保人已就保险事宜与全部被保险人进行了宣导和沟通，凡参与该保险的全部被保险人均符合险种条款所约定（包括但不限于责任免除、投保人被保险人义务、保险金申请与给付等）的投保条件，并了解保障内容且同意由投保人统一办理投保事项，投保人已认真阅读并正确理解条款和投保须知的所有内容，并接受上述内容，同意以此作为订立保险合同的依据。</p>
                <p class="mb30">3、本产品投保填写以及所附的被保险人清单中的各项事实均属实，并作为本保险合同的组成部分，如有隐瞒或不实告知，投保人愿承担由此带来的法律后果，保险人有权解除保险合同，对于合同解除前发生的任何事故，保险人可不承担任何责任。</p>
            </div>
        </div><!-- w-95-auto end -->
    </div><!-- message-war end -->
    <c:if test="${ not empty dto.external_reference }">
        <div class="row next-step">
            <div class="col-sm-6 col-xs-6 text-right pull-right">
                <p>
                    <c:if test="${ not empty dto.insure_path }">
                        <a href="${dto.insure_path}" class="ns-btn">保单下载</a>
                    </c:if>
                    <c:if test="${ empty dto.insure_path }">
                        <a href="javascript:void(0);" onclick="requestEPolicy('${ dto.oid }',this);" class="ns-btn">保单下载</a>
                    </c:if>
                    <c:if test="${fn:contains(dto.product_code,'TYX-PAC')||fn:contains(dto.product_code,'TYX-CA')||fn:contains(dto.product_code,'TYX-QH')||fn:contains(dto.product_code,'TYX-HT')}">
                        <c:if test="${ empty vo.mailPolicyVo.e_invoice_url }">
                            <a href="javascript:void(0);" onclick="requestInvoice('${ dto.product_code }','${ dto.oid }',this);" class="ns-btn">申请电子发票</a>
                        </c:if>
                        <c:if test="${ not empty vo.mailPolicyVo.e_invoice_url }">
                            <a href="${vo.mailPolicyVo.e_invoice_url}" class="ns-btn">发票下载</a>
                        </c:if>
                    </c:if>
                </p>
            </div>
        </div>
    </c:if>
</div><!-- container end --> 

<form id="dow-now" action="<c:url value='/synopsis/sodownload'/>" method="post">
	<input name="path" id="path-dow" type="hidden">
	<input name="name" id="name-dow" type="hidden">
</form>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<jsp:include page="../../index/multi_init_param.jsp"/>
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
    function requestEPolicy(_oid,_obj){
        var index = laySomenType(0,null,'',0);
        $.ajax({
            type: 'POST',
            url:baseUrl + '/api/gmr/policy/requestEPolicy/'+_oid+'?ACCESS_TOKEN=${ACCESS_TOKEN}',
            dataType:"json",
            async:false,
            success: function(json){
                if(json.statusCode == '200') {
                    $(_obj).attr("href",json.navTabId);
                    $(_obj).attr("onclick","");
                    $(_obj).attr("target","_top");
                    /*window.open(json.navTabId);*/
                    $(_obj).click();
                }else{
                    laySomenType(1,null,json.message,0);
                }
                laySomenType(2,index,'',0);
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                laySomenType(2,index,'',0);
                laySomenType(1,null,textStatus,0);
            }
        });
    }
    function requestInvoice(_code,_oid,_obj){
        layer.confirm('完成电子发票申请后将无法开具纸质发票，是否继续申请？', {
            btn: ['确定','取消'] //按钮
        }, function(){
            layer.closeAll();
            var index = laySomenType(0,null,'',0);
            var _url = '/PAC-API/TYX/PRINT_INVOICE/'+_oid;
            if(_code){
                if('CA' == _code.split('-')[1]){
                    _url = '/CA-API/TYX/PRINT_INVOICE/'+_oid;
                }
                if('QH' == _code.split('-')[1]){
                    _url = '/QH-API/TYX/PRINT_INVOICE/'+_oid;
                }
                if('HT' == _code.split('-')[1]){
                    _url = '/HT-API/TYX/PRINT_INVOICE/'+_oid;
                }
            }
            $.ajax({
                type: 'POST',
                url:baseUrl + _url,
                dataType:"json",
                async:false,
                success: function(json){
                    if(json.statusCode == '200') {
                        $(_obj).attr("href",json.navTabId);
                        $(_obj).attr("onclick","");
                        $(_obj).attr("target","_top");
                        $(_obj).click();
                    }else{
                        laySomenType(1,null,json.message,0);
                    }
                    laySomenType(2,index,'',0);
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    laySomenType(2,index,'',0);
                    laySomenType(1,null,textStatus,0);
                }
            });
        });
    }
    $(function(){
        changeFrameSet(0,'');
        $("td").each(function(){
            var _class = $(this).attr("class");
            if(_class != undefined){
                if(_class.indexOf("tablebg_f5f8fa") == -1 && _class.indexOf("col-sm") != -1){
                    if($(this).prev().length==1){
                        var preClass = $(this).prev().attr("class");
                        if(preClass.indexOf("tablebg_f5f8fa") != -1){
                            var preVal = $(this).prev().html();
                            if(preVal != ''){
                                var _val = $(this).html();
                                if(_val == ''){
                                    $(this).html('-');
                                }
                            }
                        }else{
                            var _val = $(this).html();
                            if(_val == ''){
                                $(this).html('-');
                            }
                        }
                    }else{
                        var _val = $(this).html();
                        if(_val == ''){
                            $(this).html('-');
                        }
                    }


                }
            }
        });

    });
</script>
</body>
</html>