<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
	<head>
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" /> 
		<!--[if lt IE 9]> 
	      <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
	      <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
<body>
<div class="container"><!-- container start -->
    <ol class="breadcrumb" id="bread_crumbs">
    </ol>
    <div class="message-war"><!-- message-war start -->
        <h2>${ dto.product_name}</h2>
        <div class="w-95-auto"><!-- w-95-auto start -->
            <h5><c:if test="${ not empty dto.external_reference }">保单号码：${ dto.external_reference}</c:if><c:if test="${ empty dto.external_reference }">订单号码：${ dto.trade_serial_number}</c:if></h5>
            <div class="mess-title"><h3>推荐人信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">推荐人的手机号或编号</td>
                        <td class="col-sm-4 col-xs-4">${empty vo.recommend_code ? '无' : vo.recommend_code}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
                        <td class="col-sm-4 col-xs-4"></td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>投保人信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">投保人类型</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">${vo.roleSubjectList[0].role_type eq '1' ? '参展商' : '搭建商'}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">投保人名称</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].name_cn}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">营业性质</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:forEach items="${natureList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[0].com_nature}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                            <c:forEach items="${natureList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[0].nature_two}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                        </td>
                    </tr>

                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:forEach items="${comTypeList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[0].id_type}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                        </td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号码</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].organization_code}</td>
                    </tr>

                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人姓名</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_name}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人手机</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_tel}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人email</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_email}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">注册地址</td>
                        <td class="col-sm-4 col-xs-4">
                            ${reg_role}
                            ${vo.roleSubjectList[0].reg_address}
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>被保险人信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">被保险人名称</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].name_cn}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">营业性质</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:forEach items="${natureList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[1].com_nature}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                            <c:forEach items="${natureList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[1].nature_two}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                        </td>
                    </tr>

                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2" id="p_p_2">证件类型</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:forEach items="${comTypeList }" var="list">
                                <c:if test="${list.value eq vo.roleSubjectList[1].id_type}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                        </td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2" id="p_p_3">证件号码</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].organization_code}</td>
                    </tr>

                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人姓名</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].link_name}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人手机</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].link_tel}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人email</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].link_email}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">详细地址</td>
                        <td class="col-sm-4 col-xs-4">
                            ${reg_role_1}
                            ${vo.roleSubjectList[1].reg_address}
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>

            <div class="mess-title"><h3>投保基本信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">展会名称</td>
                        <td class="col-sm-4 col-xs-4">${vo.specialExhibitionVo.name}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">展位号</td>
                        <td class="col-sm-4 col-xs-4">${vo.specialExhibitionVo.ex_no}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">展会举办地址</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">${ex_pca}${vo.specialExhibitionVo.ex_address}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">是否包含拆搭建</td>
                        <td class="col-sm-4 col-xs-4">${vo.specialExhibitionVo.contains eq '0'? '否' : '是'}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">保障时间</td>
                        <td class="col-sm-4 col-xs-4">${vo.specialExhibitionVo.star_time} ~ ${vo.specialExhibitionVo.end_time}</td>
                    </tr>
                    <tr style="${vo.specialExhibitionVo.contains != '1'? 'display: none;' : ''}">
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">搭建公司</td>
                        <td class="col-sm-4 col-xs-4">${vo.specialExhibitionVo.build_com_name.trim()}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">转包单位</td>
                        <td class="col-sm-4 col-xs-4">${vo.specialExhibitionVo.subcontracting_units.trim()}</td>
                    </tr>
                    <tr id="special_exhibitor_name" style="display: none;">
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">参展商名称</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">${vo.specialExhibitionVo.exhibitor_name.trim()}</td>
                    </tr>
                    <tr id="special_exhibitor_tc" style="display: none;">
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
                        <td class="col-sm-4 col-xs-4">
                            <c:forEach items="${comTypeList }" var="list">
                                <c:if test="${list.value eq vo.specialExhibitionVo.exhibitor_type.trim()}">
                                    ${list.name}
                                </c:if>
                            </c:forEach>
                        </td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号码</td>
                        <td class="col-sm-4 col-xs-4">${vo.specialExhibitionVo.exhibitor_code.trim()}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">展位总面积（平米）</td>
                        <td class="col-sm-4 col-xs-4">${vo.specialExhibitionVo.ex_acreage}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">雇员总人数</td>
                        <td class="col-sm-4 col-xs-4">${vo.specialExhibitionVo.ex_emp_num}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">司法管辖</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">中华人民共和国司法管辖（港澳台除外）</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">争议处理</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：${ vo.specialExhibitionVo.dispute eq '0' ? '商议或诉讼' : '仲裁，仲裁机构' }&nbsp;&nbsp;${vo.specialExhibitionVo.dispute eq '0' ? '': vo.specialExhibitionVo.arbitral_institution}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>投保计划信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <%--<tr>
                        <td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保障方案</td>
                        <td colspan="3" class="col-sm-10 col-xs-10" style="padding: 0">
                            <table class="table">
                                <tbody>
                                <tr style="border-bottom: 1px solid #e6eaee;">
                                    <td class="col-sm-6 col-xs-6">保障责任</td>
                                    <td class="col-sm-6 col-xs-6">保障金额</td>
                                </tr>
                                <c:forEach items="${ dto.responsibilityVoList }" var="irp" varStatus="index">
                                    <tr ${(index.index+1) != dto.responsibilityVoList.size()? 'style="border-bottom: 1px solid #e6eaee;"' : ''} >
                                        <td class="col-sm-6 col-xs-6" >${irp.name}</td>
                                        <td class="col-sm-6 col-xs-6" >
                                            <c:choose>
                                                <c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
                                                    -
                                                </c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
                                                    <c:if test="${irp.fcy/10000 >= 1}">
                                                        ${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
                                                        万元
                                                    </c:if>
                                                    <c:if test="${irp.fcy/10000 < 1}">
                                                        ${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
                                                        元
                                                    </c:if>
                                                </c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
                                                    <c:if test="${irp.fcy/10000 >= 1}">
                                                        ${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
                                                        万元/天
                                                    </c:if>
                                                    <c:if test="${irp.fcy/10000 < 1}">
                                                        ${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
                                                        元/天
                                                    </c:if>
                                                </c:if>
											</span>
                                                </c:when>
                                                <c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
                                                    -
                                                </c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
                                                    <c:if test="${irp.insurance_amount_max/10000 >= 1}">
                                                        ${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
                                                        万元
                                                    </c:if>
                                                    <c:if test="${irp.insurance_amount_max/10000 < 1}">
                                                        ${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
                                                        元
                                                    </c:if>
                                                </c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
                                                    <c:if test="${irp.insurance_amount_max/10000 >= 1}">
                                                        ${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
                                                        万元/天
                                                    </c:if>
                                                    <c:if test="${irp.insurance_amount_max/10000 < 1}">
                                                        ${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
                                                        元/天
                                                    </c:if>
                                                </c:if>
											</span>
                                                </c:when>
                                                <c:otherwise>
                                                    <span>-</span>
                                                </c:otherwise>
                                            </c:choose>
                                        </td>
                                    </tr>
                                </c:forEach>
                                </tbody>
                            </table>
                        </td>
                    </tr>--%>
                    <tr>
                        <td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保障方案</td>
                        <td colspan="3" class="col-sm-10 col-xs-10">
                            <table class="table ">
                                <tbody>
                                <tr>
                                    <td class="col-sm-4 col-xs-4">保障责任</td>
                                    <td class="col-sm-2 col-xs-2">
                                        <c:set var="irp_1" value="${ vo.responsibilityVoList[0] }"></c:set>
                                        <c:choose>
                                            <c:when test="${empty irp_1.insurance_amount_max && not empty irp_1.fcy}">
                                                保险金额
                                            </c:when>
                                            <c:when test="${empty irp_1.fcy && not empty irp_1.insurance_amount_max}">
                                                赔偿限额
                                            </c:when>
                                            <c:otherwise>
                                                保险金额
                                            </c:otherwise>
                                        </c:choose>
                                    </td>
                                    <td class="col-sm-2 col-xs-2">免赔额</td>
                                    <td class="col-sm-2 col-xs-2">赔付比例</td>
                                    <td class="col-sm-2 col-xs-2">免赔天数</td>
                                </tr>
                                <c:forEach items="${ vo.responsibilityVoList }" var="irp">
                                    <tr <c:choose>
                                        <c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '0' && irp.is_optional eq '2'}">
                                            hidden
                                        </c:when>
                                        <c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '1' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障一')}">
                                            hidden
                                        </c:when>
                                        <c:when test="${not empty vo.is_contain_repo && vo.is_contain_repo eq '2' && irp.is_optional eq '2' && !fn:contains(irp.remark,'可选保障二')}">
                                            hidden
                                        </c:when>
                                        <c:when test="${empty vo.is_contain_repo && irp.is_optional eq '2'}">
                                            hidden
                                        </c:when>
                                        <c:otherwise>

                                        </c:otherwise>
                                    </c:choose>>
                                        <td class="col-sm-4 col-xs-4" style="text-align:left; <c:if test="${irp.name eq '烈士褒扬金'}">color: red;</c:if>">${irp.name}<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="${irp.explain_product}"/></td>
                                        <td class="col-sm-2 col-xs-2" <c:if test="${irp.name eq '烈士褒扬金'}">style="color: red"</c:if>>
                                            <c:choose>
                                                <c:when test="${empty irp.insurance_amount_max && not empty irp.fcy}">
											<span>
												<c:if test="${ empty irp.fcy}">
                                                    -
                                                </c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.fcy}">
                                                    <c:if test="${irp.fcy/10000 >= 1}">
                                                        ${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
                                                        万元
                                                    </c:if>
                                                    <c:if test="${irp.fcy/10000 < 1}">
                                                        ${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
                                                        元
                                                    </c:if>
                                                </c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.fcy}">
                                                    <c:if test="${irp.fcy/10000 >= 1}">
                                                        ${(fn:split((irp.fcy/10000),'.')[1] eq '0' || fn:split((irp.fcy/10000),'.')[1] eq '00') ? fn:split((irp.fcy/10000),'.')[0] : (irp.fcy/10000)}
                                                        万元/天
                                                    </c:if>
                                                    <c:if test="${irp.fcy/10000 < 1}">
                                                        ${(fn:split(irp.fcy,'.')[1] eq '0' || fn:split(irp.fcy,'.')[1] eq '00') ? fn:split(irp.fcy,'.')[0] : irp.fcy}
                                                        元/天
                                                    </c:if>
                                                </c:if>
											</span>
                                                </c:when>
                                                <c:when test="${empty irp.fcy && not empty irp.insurance_amount_max}">
											<span>
												<c:if test="${ empty irp.insurance_amount_max}">
                                                    -
                                                </c:if>
												<c:if test="${empty irp.compensation_days && not empty irp.insurance_amount_max}">
                                                    <c:if test="${irp.insurance_amount_max/10000 >= 1}">
                                                        ${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
                                                        万元
                                                    </c:if>
                                                    <c:if test="${irp.insurance_amount_max/10000 < 1}">
                                                        ${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
                                                        元
                                                    </c:if>
                                                </c:if>
												<c:if test="${not empty irp.compensation_days && not empty irp.insurance_amount_max}">
                                                    <c:if test="${irp.insurance_amount_max/10000 >= 1}">
                                                        ${(fn:split((irp.insurance_amount_max/10000),'.')[1] eq '0' || fn:split((irp.insurance_amount_max/10000),'.')[1] eq '00') ? fn:split((irp.insurance_amount_max/10000),'.')[0] : (irp.insurance_amount_max/10000)}
                                                        万元/天
                                                    </c:if>
                                                    <c:if test="${irp.insurance_amount_max/10000 < 1}">
                                                        ${(fn:split(irp.insurance_amount_max,'.')[1] eq '0' || fn:split(irp.insurance_amount_max,'.')[1] eq '00') ? fn:split(irp.insurance_amount_max,'.')[0] : irp.insurance_amount_max}
                                                        元/天
                                                    </c:if>
                                                </c:if>
											</span>
                                                </c:when>
                                                <c:otherwise>
                                                    <span>-</span>
                                                </c:otherwise>
                                            </c:choose>
                                        </td>
                                        <td class="col-sm-2 col-xs-2" >${empty irp.cumulative_deductibles ? '-' : irp.cumulative_deductibles}</td>
                                        <td class="col-sm-2 col-xs-2" >${empty irp.compensation_ratio ? '-' : irp.compensation_ratio}${not empty irp.compensation_ratio ? '%' : ''}</td>
                                        <td class="col-sm-2 col-xs-2" >${empty irp.deductible_days ? '-' : irp.deductible_days}</td>
                                    </tr>
                                </c:forEach>
                                </tbody>
                            </table>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>退保账户信息</h3></div>
            <div class="affirm-warr">
                <table class="table ">
                    <tbody>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">开户名</td>
                        <td class="col-sm-10 col-xs-10" colspan="3">${vo.roleSubjectList[0].account_name}</td>
                    </tr>
                    <tr>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">账户开户行</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].bank_name}</td>
                        <td class="tablebg_f5f8fa col-sm-2 col-xs-2">银行账号</td>
                        <td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].bank_account}</td>
                    </tr>
                    </tbody>
                </table>
            </div>
            <div class="mess-title"><h3>投保声明</h3></div>
            <div class="affirm-warr">
                <p class="mt30">1、投保人通过合法途径获得团体授权，向保险人投保本险种，所有投保操作和内容已获得认可，所有被保险人均为与投保单位有劳动关系的劳动者，该产品的保障内容以及保险金额已向被保险人进行了明确说明，并征得其同意。</p>
                <p>2、投保人已就保险事宜与全部被保险人进行了宣导和沟通，凡参与该保险的全部被保险人均符合险种条款所约定（包括但不限于责任免除、投保人被保险人义务、保险金申请与给付等）的投保条件，并了解保障内容且同意由投保人统一办理投保事项，投保人已认真阅读并正确理解条款和投保须知的所有内容，并接受上述内容，同意以此作为订立保险合同的依据。</p>
                <p class="mb30">3、本产品投保填写以及所附的被保险人清单中的各项事实均属实，并作为本保险合同的组成部分，如有隐瞒或不实告知，投保人愿承担由此带来的法律后果，保险人有权解除保险合同，对于合同解除前发生的任何事故，保险人可不承担任何责任。</p>
            </div>
        </div><!-- w-95-auto end -->
    </div><!-- message-war end -->
    <c:if test="${ not empty dto.external_reference }">
        <div class="row next-step">
            <div class="col-sm-6 col-xs-6 text-right pull-right">
                <p>
                    <c:if test="${ not empty dto.insure_path }">
                        <a target="_blank" href="${dto.insure_path}" class="ns-btn">保单下载</a>
                    </c:if>
                    <c:if test="${ empty dto.insure_path }">
                        <a href="javascript:void(0);" onclick="requestEPolicy('${ dto.oid }',this);" class="ns-btn">保单下载<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="如果首次点击按钮未正常下载，请再次点击按钮尝试下载，如还无法正常下载请联系客服人员。"></i></a>
                    </c:if>
                    <c:if test="${ empty vo.mailPolicyVo.e_invoice_url }">
                        <a href="javascript:void(0);" onclick="requestInvoice('${ dto.product_code }','${ dto.oid }',this);" class="ns-btn">申请电子发票</a>
                    </c:if>
                    <c:if test="${ not empty vo.mailPolicyVo.e_invoice_url }">
                        <a target="_blank" href="${vo.mailPolicyVo.e_invoice_url}" class="ns-btn">发票下载</a>
                    </c:if>
                </p>
            </div>
        </div>
    </c:if>
</div><!-- container end --> 

<form id="dow-now" action="<c:url value='/synopsis/sodownload'/>" method="post">
	<input name="path" id="path-dow" type="hidden">
	<input name="name" id="name-dow" type="hidden">
</form>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<jsp:include page="../../../index/multi_init_param.jsp"/>
<script type="text/javascript">
	var baseUrl = '${pageContext.request.contextPath }';
	function sodownload(path,name){
		path = path.split(".com/")[1];
		$("#path-dow").val(path);
		$("#name-dow").val(name);
		$("#dow-now").submit();
	}
    function requestEPolicy(_oid,_obj){
        var index = parent.layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
        $.ajax({
            type: 'POST',
            url:baseUrl + '/api/lote/policy/requestEPolicy/${dto.product_code}/'+_oid,
            dataType:"json",
            success: function(json){
                if(json.statusCode == '200') {
                    $(_obj).attr("href",json.navTabId);
                    $(_obj).attr("onclick","");
                    window.open(json.navTabId);
                }else{
                    parent.layer.msg(json.message);
                }
                parent.layer.close(index);
            },
            error : function(XMLHttpRequest, textStatus, errorThrown) {
                parent.layer.close(index);
                parent.layer.msg(textStatus);
            }
        });
    }

    function requestInvoice(_code,_oid,_obj){
        layer.confirm('是否申请开具电子发票？', {
            btn: ['确定','取消'] //按钮
        }, function(){
            layer.closeAll();
            var index = laySomenType(0,null,'',0);
            var _url = '/HT-API/ZZX/PRINT_INVOICE/'+_oid;
            $.ajax({
                type: 'POST',
                url:baseUrl + _url,
                dataType:"json",
                success: function(json){
                    if(json.statusCode == '200') {
                        $(_obj).attr("href",json.message);
                        $(_obj).attr("onclick","");
                        window.open(json.message);
                    }else{
                        laySomenType(1,null,json.message,0);
                    }
                    laySomenType(2,index,'',0);
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    laySomenType(2,index,'',0);
                    laySomenType(1,null,textStatus,0);
                }
            });
        });
    }

    $(function(){
        changeFrameSet(0,'');
        $("td").each(function(){
            var _class = $(this).attr("class");
            if(_class != undefined){
                if(_class.indexOf("tablebg_f5f8fa") == -1 && _class.indexOf("col-sm") != -1){
                    if($(this).prev().length==1){
                        var preClass = $(this).prev().attr("class");
                        if(preClass.indexOf("tablebg_f5f8fa") != -1){
                            var preVal = $(this).prev().html();
                            if(preVal != ''){
                                var _val = $(this).html();
                                if(_val == ''){
                                    $(this).html('-');
                                }
                            }
                        }else{
                            var _val = $(this).html();
                            if(_val == ''){
                                $(this).html('-');
                            }
                        }
                    }else{
                        var _val = $(this).html();
                        if(_val == ''){
                            $(this).html('-');
                        }
                    }


                }
            }
        });
        //投保人为搭建商时，设置
        if('${vo.roleSubjectList[0].role_type}'=='2'){
            //判断是否是平安产品，如果是，显示参展商
            if('${dto.product_code}'.indexOf('ZZX-PAC')>-1||'${dto.product_code}'.indexOf('ZZX-YA')>-1){
                $('#special_exhibitor_name').show();
                $('#special_exhibitor_tc').show();
            }else if('${dto.product_code}'.indexOf('ZZX-ZA')>-1){
                $('#p_p_1').html('参展商名称');
                $('#p_p_2').html('参展商证件类型');
                $('#p_p_3').html('参展商证件号码');
            }
        }

    });
</script>
</body>
</html>