<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8"><meta http-equiv="X-UA-Compatible" content="IE=edge,Chrome=1" /><meta http-equiv="X-UA-Compatible" content="IE=9" />
		<meta name="keywords" content="保险保函、电子保函、保证保险、保函开具、工程投标保证保险、建设合同履约保证保险、业主合同款支付保证保险、建设工程质量保证保险、建筑业企业人工工资支付保证保险、海关税保险、诉讼财产保全责任保险">
		<meta name="description" content="百联保是百川信（厦门）网络信息服务有限公司基于金融创新并响应“互联网＋”计划搭建的第三方金融服务平台。 ">
		<meta name="viewport" content="width=device-width, initial-scale=1,maximum-scale=1, user-scalable=no">
		<title>百联保-打印投保单</title>
		
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" /> 
		<link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" /> 
		<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery-2.1.1.min.js' />"></script>
		<script type="text/javascript">
			function printPage(){
				window.print();
			}
		</script>
		<style type="text/css" media=print>
			.noprint{display : none}
		</style>
		<!--[if lt IE 9]> 
		  <script src="<c:url value='/resources/versions-2.0/js/html5shiv/3.7.2/html5shiv.min.js' />"></script>
		  <script src="<c:url value='/resources/versions-2.0/js/respond.js/1.4.2/respond.min.js' />"></script>
	   	<![endif]-->
	</head>
	<OBJECT classid="CLSID:8856F961-340A-11D0-A96B-00C04FD705A2" height="0" id="printWB" name="printWB" width="0"></OBJECT>
<body>

<div class="container" style="width: 90%;margin-top: 5px;"><!-- container start -->
	<div class="message-war"><!-- message-war start -->
		<h2>${ dto.product_name}</h2>
		<div class="w-95-auto"><!-- w-95-auto start -->
			<h5>订单号码：${ dto.trade_serial_number}</h5>
			<div class="mess-title"><h3>推荐人信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">推荐人的手机号或编号</td>
						<td class="col-sm-4 col-xs-4">${empty vo.recommend_code ? '无' : vo.recommend_code}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2"></td>
						<td class="col-sm-4 col-xs-4"></td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>投保人信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">投保单位</td>
						<td class="col-sm-10 col-xs-10" colspan="3">${vo.roleSubjectList[0].name_cn}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">注册地址</td>
						<td class="col-sm-10 col-xs-10" colspan="3">
							${reg_role}
							${vo.roleSubjectList[0].reg_address}
						</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">所属行业</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].industry}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">营业性质</td>
						<td class="col-sm-4 col-xs-4">
							<c:forEach items="${natureList }" var="list">
								<c:if test="${list.value eq vo.roleSubjectList[0].com_nature}">
									${list.name}
								</c:if>
							</c:forEach>
							<c:forEach items="${natureList }" var="list">
								<c:if test="${list.value eq vo.roleSubjectList[0].nature_two}">
									${list.name}
								</c:if>
							</c:forEach>
						</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
						<td class="col-sm-4 col-xs-4">
							<c:forEach items="${typeList }" var="list">
								<c:if test="${list.value eq vo.roleSubjectList[0].id_type}">
									${list.name}
								</c:if>
							</c:forEach>
						</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号码</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].organization_code}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件有效期类型</td>
						<td class="col-sm-4 col-xs-4">${fns:getDictLabel (vo.roleSubjectList[0].id_option,"idOption","")}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">有效期起止</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].id_star_date} ~ ${vo.roleSubjectList[0].id_end_date}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">雇员人数</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].total_emp}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人姓名</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_name}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人手机</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_tel}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人email</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].link_email}</td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>被保险人信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">投保单位</td>
						<td class="col-sm-10 col-xs-10" colspan="3">${vo.roleSubjectList[1].name_cn}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">注册地址</td>
						<td class="col-sm-10 col-xs-10" colspan="3">
							${reg_role_1}
							${vo.roleSubjectList[1].reg_address}
						</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">所属行业</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].industry}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">营业性质</td>
						<td class="col-sm-4 col-xs-4">
							<c:forEach items="${natureList }" var="list">
								<c:if test="${list.value eq vo.roleSubjectList[1].com_nature}">
									${list.name}
								</c:if>
							</c:forEach>
							<c:forEach items="${natureList }" var="list">
								<c:if test="${list.value eq vo.roleSubjectList[1].nature_two}">
									${list.name}
								</c:if>
							</c:forEach>
						</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
						<td class="col-sm-4 col-xs-4">
							<c:forEach items="${typeList }" var="list">
								<c:if test="${list.value eq vo.roleSubjectList[1].id_type}">
									${list.name}
								</c:if>
							</c:forEach>
						</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号码</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].organization_code}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件有效期类型</td>
						<td class="col-sm-4 col-xs-4">${fns:getDictLabel (vo.roleSubjectList[1].id_option,"idOption","")}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">有效期起止</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].id_star_date} ~ ${vo.roleSubjectList[1].id_end_date}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">雇员人数</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].total_emp}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人姓名</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].link_name}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人手机</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].link_tel}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">联系人email</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[1].link_email}</td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>雇员信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-1 col-xs-1">序号</td>
						<td class="tablebg_f5f8fa col-sm-1 col-xs-1">姓名</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件类型</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">证件号码</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">出生日期</td>
						<td class="tablebg_f5f8fa col-sm-1 col-xs-1">性别</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">职业</td>
						<td class="tablebg_f5f8fa col-sm-1 col-xs-1">手机</td>
					</tr>
					<c:if test="${vo.hirelingVoList!=null}">
						<c:forEach items="${ vo.hirelingVoList }" var="hvo" varStatus="index">
							<tr>
								<td class="col-sm-1 col-xs-1">${index.index+1}</td>
								<td class="col-sm-1 col-xs-1">${ hvo.name}</td>
								<td class="col-sm-2 col-xs-2">
									<c:forEach items="${typeList }" var="list">
										<c:if test="${list.value eq hvo.id_type}">
											${list.name}
										</c:if>
									</c:forEach>
								</td>
								<td class="col-sm-2 col-xs-2">${ hvo.id_card}</td>
								<td class="col-sm-2 col-xs-2">${ hvo.birth_date}</td>
								<td class="col-sm-1 col-xs-1">${empty hvo.sex ? '':hvo.sex eq '1'?'男':'女'}</td>
								<td class="col-sm-2 col-xs-2">
										${ hvo.career eq '1' ? '内勤人员' : hvo.career eq '2' ? '保安人员' : hvo.career eq '4' ? '保洁人员' : '-'}
								</td>
								<td class="col-sm-1 col-xs-1">${ hvo.mobile}</td>
							</tr>
						</c:forEach>
					</c:if>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>投保计划信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">起保日期</td>
						<td class="col-sm-4 col-xs-4">${ vo.inception_date }</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">保费</td>
						<td class="col-sm-4 col-xs-4">${dto.gross_premium}</td>
					</tr>
					<tr>
						<td colspan="1" class="tablebg_f5f8fa col-sm-2 col-xs-2">保障方案确认</td>
						<td colspan="3" class="col-sm-10 col-xs-10" style="padding: 0;">
							<c:if test="${fn:contains(dto.product_code,'GZZRX-RB')}">
								<table class="table ">
									<tbody>
									<tr>
										<td class="col-sm-4 col-xs-4"></td>
										<td class="col-sm-4 col-xs-4">保障责任</td>
										<td class="col-sm-4 col-xs-4">保障金额</td>
									</tr>
									<tr>
										<td class="col-sm-4 col-xs-4" rowspan="4">固定保障</td>
										<td class="col-sm-4 col-xs-4">每次事故责任</td>
										<td class="col-sm-4 col-xs-4">${dto.product_code eq 'GZZRX-RB-1' ? 300 : dto.product_code eq 'GZZRX-RB-2' ? 400 : dto.product_code eq 'GZZRX-RB-3' ? 500 : dto.product_code eq 'GZZRX-RB-4' ? 600 : 0 } 万元</td>
									</tr>
									<tr>
										<td class="col-sm-4 col-xs-4">每人死亡、伤残责任</td>
										<td class="col-sm-4 col-xs-4">${dto.product_code eq 'GZZRX-RB-1' ? 30 : dto.product_code eq 'GZZRX-RB-2' ? 40 : dto.product_code eq 'GZZRX-RB-3' ? 50 : dto.product_code eq 'GZZRX-RB-4' ? 60 : 0 } 万元（牺牲被评为烈士${dto.product_code eq 'GZZRX-RB-1' ? 60 : dto.product_code eq 'GZZRX-RB-2' ? 80 : dto.product_code eq 'GZZRX-RB-3' ? 100 : dto.product_code eq 'GZZRX-RB-4' ? 120 : 0 }万元）</td>
									</tr>
									<tr>
										<td class="col-sm-4 col-xs-4">每人医疗费用责任</td>
										<td class="col-sm-4 col-xs-4">${dto.product_code eq 'GZZRX-RB-1' ? 3 : dto.product_code eq 'GZZRX-RB-2' ? 4 : dto.product_code eq 'GZZRX-RB-3' ? 5 : dto.product_code eq 'GZZRX-RB-4' ? 6 : 0 } 万元</td>
									</tr>
									<tr>
										<td class="col-sm-4 col-xs-4">累计法律费用责任</td>
										<td class="col-sm-4 col-xs-4">${dto.product_code eq 'GZZRX-RB-1' ? 30 : dto.product_code eq 'GZZRX-RB-2' ? 40 : dto.product_code eq 'GZZRX-RB-3' ? 50 : dto.product_code eq 'GZZRX-RB-4' ? 60 : 0 } 万元</td>
									</tr>
									<c:if test="${vo.is_contain_repo eq '1'}">
										<tr>
											<td class="col-sm-4 col-xs-4" rowspan="2">可选保障</td>
											<td class="col-sm-4 col-xs-4">每次事故责任</td>
											<td class="col-sm-4 col-xs-4">${dto.product_code eq 'GZZRX-RB-1' ? 10 : dto.product_code eq 'GZZRX-RB-2' ? 14 : dto.product_code eq 'GZZRX-RB-3' ? 20 : dto.product_code eq 'GZZRX-RB-4' ? 25 : 0 } 万元</td>
										</tr>
										<tr>
											<td class="col-sm-4 col-xs-4">累计责任</td>
											<td class="col-sm-4 col-xs-4">${dto.product_code eq 'GZZRX-RB-1' ? 100 : dto.product_code eq 'GZZRX-RB-2' ? 150 : dto.product_code eq 'GZZRX-RB-3' ? 200 : dto.product_code eq 'GZZRX-RB-4' ? 250 : 0 } 万元</td>
										</tr>
									</c:if>
									</tbody>
								</table>
							</c:if>
							<c:if test="${fn:contains(dto.product_code,'GZZRX-ZH')}">
								<table class="table ">
									<tbody>
									<tr>
										<td class="col-sm-4 col-xs-4"></td>
										<td class="col-sm-4 col-xs-4">保障责任</td>
										<td class="col-sm-4 col-xs-4">保障金额</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3" rowspan="10">基本保障</td>
										<td class="col-sm-3 col-xs-3">每次事故责任限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-ZH-1' ? 300 : dto.product_code eq 'GZZRX-ZH-2' ? 400 : dto.product_code eq 'GZZRX-ZH-3' ? 500 : dto.product_code eq 'GZZRX-ZH-4' ? 600 : dto.product_code eq 'GZZRX-ZH-5' ? 700 : dto.product_code eq 'GZZRX-ZH-6' ? 800 : dto.product_code eq 'GZZRX-ZH-7' ? 900 : dto.product_code eq 'GZZRX-ZH-8' ? 1000 : dto.product_code eq 'GZZRX-ZH-9' ? 1200 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">每人意外身故/伤残责任</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-ZH-1' ? 30 : dto.product_code eq 'GZZRX-ZH-2' ? 40 : dto.product_code eq 'GZZRX-ZH-3' ? 50 : dto.product_code eq 'GZZRX-ZH-4' ? 60 : dto.product_code eq 'GZZRX-ZH-5' ? 70 : dto.product_code eq 'GZZRX-ZH-6' ? 80 : dto.product_code eq 'GZZRX-ZH-7' ? 90 : dto.product_code eq 'GZZRX-ZH-8' ? 100 : dto.product_code eq 'GZZRX-ZH-9' ? 120 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">烈士褒扬责任</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-ZH-1' ? 60 : dto.product_code eq 'GZZRX-ZH-2' ? 80 : dto.product_code eq 'GZZRX-ZH-3' ? 100 : dto.product_code eq 'GZZRX-ZH-4' ? 120 : dto.product_code eq 'GZZRX-ZH-5' ? 140 : dto.product_code eq 'GZZRX-ZH-6' ? 160 : dto.product_code eq 'GZZRX-ZH-7' ? 180 : dto.product_code eq 'GZZRX-ZH-8' ? 200 : dto.product_code eq 'GZZRX-ZH-9' ? 240 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">每人生活意外身故/伤残责任</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-ZH-1' ? 10 : dto.product_code eq 'GZZRX-ZH-2' ? 12 : dto.product_code eq 'GZZRX-ZH-3' ? 15 : dto.product_code eq 'GZZRX-ZH-4' ? 18 : dto.product_code eq 'GZZRX-ZH-5' ? 21 : dto.product_code eq 'GZZRX-ZH-6' ? 24 : dto.product_code eq 'GZZRX-ZH-7' ? 27 : dto.product_code eq 'GZZRX-ZH-8' ? 30 : dto.product_code eq 'GZZRX-ZH-9' ? 36 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">突发急性病身故责任限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-ZH-1' ? 30 : dto.product_code eq 'GZZRX-ZH-2' ? 40 : dto.product_code eq 'GZZRX-ZH-3' ? 50 : dto.product_code eq 'GZZRX-ZH-4' ? 60 : dto.product_code eq 'GZZRX-ZH-5' ? 70 : dto.product_code eq 'GZZRX-ZH-6' ? 80 : dto.product_code eq 'GZZRX-ZH-7' ? 90 : dto.product_code eq 'GZZRX-ZH-8' ? 100 : dto.product_code eq 'GZZRX-ZH-9' ? 120 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">突发急性病身故责任限额（非工）</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-ZH-1' ? 10 : dto.product_code eq 'GZZRX-ZH-2' ? 12 : dto.product_code eq 'GZZRX-ZH-3' ? 15 : dto.product_code eq 'GZZRX-ZH-4' ? 18 : dto.product_code eq 'GZZRX-ZH-5' ? 21 : dto.product_code eq 'GZZRX-ZH-6' ? 24 : dto.product_code eq 'GZZRX-ZH-7' ? 27 : dto.product_code eq 'GZZRX-ZH-8' ? 30 : dto.product_code eq 'GZZRX-ZH-9' ? 36 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">每人意外医疗费用责任</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-ZH-1' ? 3 : dto.product_code eq 'GZZRX-ZH-2' ? 4 : dto.product_code eq 'GZZRX-ZH-3' ? 5 : dto.product_code eq 'GZZRX-ZH-4' ? 6 : dto.product_code eq 'GZZRX-ZH-5' ? 7 : dto.product_code eq 'GZZRX-ZH-6' ? 8 : dto.product_code eq 'GZZRX-ZH-7' ? 9 : dto.product_code eq 'GZZRX-ZH-8' ? 10 : dto.product_code eq 'GZZRX-ZH-9' ? 12 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">每人生活意外医疗费用责任</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-ZH-1' ? 1 : dto.product_code eq 'GZZRX-ZH-2' ? 1.2 : dto.product_code eq 'GZZRX-ZH-3' ? 1.5 : dto.product_code eq 'GZZRX-ZH-4' ? 1.8 : dto.product_code eq 'GZZRX-ZH-5' ? 2.1 : dto.product_code eq 'GZZRX-ZH-6' ? 2.4 : dto.product_code eq 'GZZRX-ZH-7' ? 2.7 : dto.product_code eq 'GZZRX-ZH-8' ? 3 : dto.product_code eq 'GZZRX-ZH-9' ? 3.6 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">误工费</td>
										<td class="col-sm-3 col-xs-3">
											100 元/天
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">累计法律费用责任限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-ZH-1' ? 30 : dto.product_code eq 'GZZRX-ZH-2' ? 40 : dto.product_code eq 'GZZRX-ZH-3' ? 50 : dto.product_code eq 'GZZRX-ZH-4' ? 60 : dto.product_code eq 'GZZRX-ZH-5' ? 70 : dto.product_code eq 'GZZRX-ZH-6' ? 80 : dto.product_code eq 'GZZRX-ZH-7' ? 90 : dto.product_code eq 'GZZRX-ZH-8' ? 100 : dto.product_code eq 'GZZRX-ZH-9' ? 120 : 0 } 万元
										</td>
									</tr>
									<c:if test="${vo.is_contain_repo eq '1'}">
										<tr>
											<td class="col-sm-3 col-xs-3">可选保障</td>
											<td class="col-sm-3 col-xs-3">每次事故责任限额</td>
											<td class="col-sm-3 col-xs-3">
													${dto.product_code eq 'GZZRX-ZH-1' ? 30 : dto.product_code eq 'GZZRX-ZH-2' ? 40 : dto.product_code eq 'GZZRX-ZH-3' ? 50 : dto.product_code eq 'GZZRX-ZH-4' ? 60 : dto.product_code eq 'GZZRX-ZH-5' ? 70 : dto.product_code eq 'GZZRX-ZH-6' ? 80 : dto.product_code eq 'GZZRX-ZH-7' ? 90 : dto.product_code eq 'GZZRX-ZH-8' ? 100 : dto.product_code eq 'GZZRX-ZH-9' ? 120 : 0 } 万元
											</td>
										</tr>
									</c:if>
									</tbody>
								</table>
							</c:if>
							<c:if test="${fn:contains(dto.product_code,'GZZRX-CA')}">
								<table class="table ">
									<tbody>
									<tr>
										<td class="col-sm-4 col-xs-4"></td>
										<td class="col-sm-4 col-xs-4">保障责任</td>
										<td class="col-sm-4 col-xs-4">保障金额</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3" rowspan="9">基本保障</td>
										<td class="col-sm-3 col-xs-3">每次事故责任限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-CA-1' ? 300 : dto.product_code eq 'GZZRX-CA-2' ? 400 : dto.product_code eq 'GZZRX-CA-3' ? 500 : dto.product_code eq 'GZZRX-CA-4' ? 600 : dto.product_code eq 'GZZRX-CA-5' ? 700 : dto.product_code eq 'GZZRX-CA-6' ? 800 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">工作期间每人意外身故、伤残限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-CA-1' ? 30 : dto.product_code eq 'GZZRX-CA-2' ? 40 : dto.product_code eq 'GZZRX-CA-3' ? 50 : dto.product_code eq 'GZZRX-CA-4' ? 60 : dto.product_code eq 'GZZRX-CA-5' ? 70 : dto.product_code eq 'GZZRX-CA-6' ? 80 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">每人生活意外身故、伤残限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-CA-1' ? 10 : dto.product_code eq 'GZZRX-CA-2' ? 12 : dto.product_code eq 'GZZRX-CA-3' ? 15 : dto.product_code eq 'GZZRX-CA-4' ? 18 : dto.product_code eq 'GZZRX-CA-5' ? 21 : dto.product_code eq 'GZZRX-CA-6' ? 24 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">工作期间每人意外医疗费用责任限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-CA-1' ? 3 : dto.product_code eq 'GZZRX-CA-2' ? 4 : dto.product_code eq 'GZZRX-CA-3' ? 5 : dto.product_code eq 'GZZRX-CA-4' ? 6 : dto.product_code eq 'GZZRX-CA-5' ? 7 : dto.product_code eq 'GZZRX-CA-6' ? 8 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">每人生活意外医疗费用责任限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-CA-1' ? 1 : dto.product_code eq 'GZZRX-CA-2' ? 1.2 : dto.product_code eq 'GZZRX-CA-3' ? 1.5 : dto.product_code eq 'GZZRX-CA-4' ? 1.8 : dto.product_code eq 'GZZRX-CA-5' ? 2.1 : dto.product_code eq 'GZZRX-CA-6' ? 2.4 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">突发急性病身故限额</td>
										<td class="col-sm-3 col-xs-3">
											20 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">误工费用赔偿限额</td>
										<td class="col-sm-3 col-xs-3">
											100 元/天
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">住院津贴标准</td>
										<td class="col-sm-3 col-xs-3">
											100 元/天
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">法律费用限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-CA-1' ? 30 : dto.product_code eq 'GZZRX-CA-2' ? 40 : dto.product_code eq 'GZZRX-CA-3' ? 50 : dto.product_code eq 'GZZRX-CA-4' ? 60 : dto.product_code eq 'GZZRX-CA-5' ? 70 : dto.product_code eq 'GZZRX-CA-6' ? 80 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3" rowspan="4">附加保障</td>
										<td class="col-sm-3 col-xs-3">每年事故累计限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-CA-1' ? 50 : dto.product_code eq 'GZZRX-CA-2' ? 70 : dto.product_code eq 'GZZRX-CA-3' ? 80 : dto.product_code eq 'GZZRX-CA-4' ? 100 : dto.product_code eq 'GZZRX-CA-5' ? 200 : dto.product_code eq 'GZZRX-CA-6' ? 300 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">每次财产损失赔偿限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-CA-1' ? 25 : dto.product_code eq 'GZZRX-CA-2' ? 35 : dto.product_code eq 'GZZRX-CA-3' ? 40 : dto.product_code eq 'GZZRX-CA-4' ? 50 : dto.product_code eq 'GZZRX-CA-5' ? 100 : dto.product_code eq 'GZZRX-CA-6' ? 150 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">每次人身伤亡、医疗、误工赔偿限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-CA-1' ? 25 : dto.product_code eq 'GZZRX-CA-2' ? 35 : dto.product_code eq 'GZZRX-CA-3' ? 40 : dto.product_code eq 'GZZRX-CA-4' ? 50 : dto.product_code eq 'GZZRX-CA-5' ? 100 : dto.product_code eq 'GZZRX-CA-6' ? 150 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3" colspan="2">（每人每次人身伤亡、医疗、误工限额不超过基本险每人限额）</td>
									</tr>
									</tbody>
								</table>
							</c:if>
							<c:if test="${fn:contains(dto.product_code,'GZZRX-PAC')}">
								<table class="table ">
									<tbody>
									<tr>
										<td class="col-sm-4 col-xs-4"></td>
										<td class="col-sm-4 col-xs-4">保障责任</td>
										<td class="col-sm-4 col-xs-4">保障金额</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3" rowspan="8">基本保障</td>
										<td class="col-sm-3 col-xs-3">每次事故责任限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-PAC-1' ? 300 : dto.product_code eq 'GZZRX-PAC-2' ? 400 : dto.product_code eq 'GZZRX-PAC-3' ? 500 : dto.product_code eq 'GZZRX-PAC-4' ? 600 : dto.product_code eq 'GZZRX-PAC-5' ? 700 : dto.product_code eq 'GZZRX-PAC-6' ? 800 : dto.product_code eq 'GZZRX-PAC-7' ? 900 : dto.product_code eq 'GZZRX-PAC-8' ? 1000 : dto.product_code eq 'GZZRX-PAC-9' ? 1200 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">每人意外身故、伤残限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-PAC-1' ? 30 : dto.product_code eq 'GZZRX-PAC-2' ? 40 : dto.product_code eq 'GZZRX-PAC-3' ? 50 : dto.product_code eq 'GZZRX-PAC-4' ? 60 : dto.product_code eq 'GZZRX-PAC-5' ? 70 : dto.product_code eq 'GZZRX-PAC-6' ? 80 : dto.product_code eq 'GZZRX-PAC-7' ? 90 : dto.product_code eq 'GZZRX-PAC-8' ? 100 : dto.product_code eq 'GZZRX-PAC-9' ? 120 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">每人生活意外身故、伤残限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-PAC-1' ? 5 : dto.product_code eq 'GZZRX-PAC-2' ? 5 : dto.product_code eq 'GZZRX-PAC-3' ? 5 : dto.product_code eq 'GZZRX-PAC-4' ? 8 : dto.product_code eq 'GZZRX-PAC-5' ? 8 : dto.product_code eq 'GZZRX-PAC-6' ? 8 : dto.product_code eq 'GZZRX-PAC-7' ? 10 : dto.product_code eq 'GZZRX-PAC-8' ? 10 : dto.product_code eq 'GZZRX-PAC-9' ? 10 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">每人意外医疗费用责任限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-PAC-1' ? 3 : dto.product_code eq 'GZZRX-PAC-2' ? 4 : dto.product_code eq 'GZZRX-PAC-3' ? 5 : dto.product_code eq 'GZZRX-PAC-4' ? 6 : dto.product_code eq 'GZZRX-PAC-5' ? 7 : dto.product_code eq 'GZZRX-PAC-6' ? 8 : dto.product_code eq 'GZZRX-PAC-7' ? 9 : dto.product_code eq 'GZZRX-PAC-8' ? 10 : dto.product_code eq 'GZZRX-PAC-9' ? 12 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">每人生活意外医疗费用责任限额</td>
										<td class="col-sm-3 col-xs-3">
											1 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">突发急性病身故限额（工伤范围）</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-PAC-1' ? 30 : dto.product_code eq 'GZZRX-PAC-2' ? 40 : dto.product_code eq 'GZZRX-PAC-3' ? 50 : dto.product_code eq 'GZZRX-PAC-4' ? 60 : dto.product_code eq 'GZZRX-PAC-5' ? 70 : dto.product_code eq 'GZZRX-PAC-6' ? 80 : dto.product_code eq 'GZZRX-PAC-7' ? 90 : dto.product_code eq 'GZZRX-PAC-8' ? 100 : dto.product_code eq 'GZZRX-PAC-9' ? 120 : 0 } 万元
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">住院津贴标准</td>
										<td class="col-sm-3 col-xs-3">
											100 元/天
										</td>
									</tr>
									<tr>
										<td class="col-sm-3 col-xs-3">法律费用限额</td>
										<td class="col-sm-3 col-xs-3">
												${dto.product_code eq 'GZZRX-PAC-1' ? 30 : dto.product_code eq 'GZZRX-PAC-2' ? 40 : dto.product_code eq 'GZZRX-PAC-3' ? 50 : dto.product_code eq 'GZZRX-PAC-4' ? 60 : dto.product_code eq 'GZZRX-PAC-5' ? 70 : dto.product_code eq 'GZZRX-PAC-6' ? 80 : dto.product_code eq 'GZZRX-PAC-7' ? 90 : dto.product_code eq 'GZZRX-PAC-8' ? 100 : dto.product_code eq 'GZZRX-PAC-9' ? 120 : 0 } 万元
										</td>
									</tr>
									<c:if test="${vo.is_contain_repo eq '1'}">
										<tr>
											<td class="col-sm-3 col-xs-3" rowspan="1">可选保障一</td>
											<td class="col-sm-3 col-xs-3">非工伤突发急性病身故责任限额</td>
											<td class="col-sm-3 col-xs-3">10 万元</td>
										</tr>
									</c:if>
									</tbody>
								</table>
							</c:if>
						</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">争议处理</td>
						<td class="col-sm-10 col-xs-10" colspan="3">若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：${ vo.dispute eq '0' ? '诉讼' : '仲裁，仲裁机构' }&nbsp;&nbsp;${vo.dispute eq '0' ? '': vo.arbitral_institution}</td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>退保账户信息</h3></div>
			<div class="affirm-warr">
				<table class="table ">
					<tbody>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">开户名</td>
						<td class="col-sm-10 col-xs-10" colspan="3">${vo.roleSubjectList[0].account_name}</td>
					</tr>
					<tr>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">账户开户行</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].bank_name}</td>
						<td class="tablebg_f5f8fa col-sm-2 col-xs-2">银行账号</td>
						<td class="col-sm-4 col-xs-4">${vo.roleSubjectList[0].bank_account}</td>
					</tr>
					</tbody>
				</table>
			</div>
			<div class="mess-title"><h3>投保声明</h3></div>
			<div class="affirm-warr">
				<p class="mt30" style="font-weight: bold">1、投保人通过合法途径获得团体授权，向保险人投保本险种，所有投保操作和内容已获得认可，所有被保险人均为与投保单位有劳动关系的劳动者，该产品的保障内容以及保险金额已向被保险人进行了明确说明，并征得其同意。</p>
				<p style="font-weight: bold">2、投保人已就保险事宜与全部被保险人进行了宣导和沟通，凡参与该保险的全部被保险人均符合险种条款所约定（包括但不限于责任免除、投保人被保险人义务、保险金申请与给付等）的投保条件，并了解保障内容且同意由投保人统一办理投保事项，投保人已认真阅读并正确理解条款和投保须知的所有内容，并接受上述内容，同意以此作为订立保险合同的依据。</p>
				<p style="font-weight: bold">3、本产品投保填写以及所附的被保险人清单中的各项事实均属实，并作为本保险合同的组成部分，如有隐瞒或不实告知，投保人愿承担由此带来的法律后果，保险人有权解除保险合同，对于合同解除前发生的任何事故，保险人可不承担任何责任。</p>
				<p class="mb30" style="font-weight: bold">4、保险事故发生后，保险人需核实被保险人雇员与投保人单位之间的雇佣关系，确定保险责任。</p>
			</div>
		</div><!-- w-95-auto end -->
	</div><!-- message-war end -->
</div><!-- container end --> 
</body>
</html>