<%@ page language="java" contentType="text/html;charset=UTF-8"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn" %>
<%@ taglib uri="/WEB-INF/tld/fns.tld" prefix="fns" %>
<!DOCTYPE html>
<html>
<head>

    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/bootstrap.min.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/public.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/write-application.css' />" />
    <link type="text/css" rel="stylesheet" href="<c:url value='/resources/versions-2.0/dist/css/insure/fileinput.css' />" />
</head>
<body>

<div class="container"><!-- container start -->
    <c:if test="${fn:contains(userdetail.web_type, 'PSS')}">
        <ol class="breadcrumb" id="bread_crumbs" style="padding-top: 20px">
            <%--<span>当前位置：</span>
            <a href="javascript:void(0);">保障服务 > </a>
            <a href="<c:url value='/insurance/product/gzx-product-all?ACCESS_TOKEN=${ACCESS_TOKEN}' />">产品列表 > </a>
            <a href="<c:url value='/insurance/gzx/product/productInfo/${dto.product_oid}?ACCESS_TOKEN=${ACCESS_TOKEN}' />">产品详情 > </a>
            <a href="javascript:void(0);">投保页面</a>--%>
        </ol>
    </c:if>
    <c:if test="${!fn:contains(userdetail.web_type, 'PSS')}">
        <ol class="breadcrumb" id="bread_crumbs">
        </ol>
    </c:if>
    <div class="nav-list">
        <div class="row w-80-auto">
            <div class="col-sm-3 col-sm-4 active">
                <p><i class="pull-left">1</i><span class=" pull-left">填写保险信息</span></p>
            </div>
            <div class="col-sm-3 col-sm-4">
                <p><i class="pull-left">2</i><span class="pull-left">确认投保信息</span></p>
            </div>
            <div class="col-sm-3 col-sm-3">
                <p><i class="pull-left">3</i><span class="pull-left">支付保费</span></p>
            </div>
            <div class="col-sm-3 col-sm-3 pull-right">
                <p><i class="pull-left">4</i><span class="pull-left"> 完成投保</span></p>
            </div>
        </div>
    </div>
    <form class="form-horizontal form-create-item" method="post" id="policyInfoForm">
        <input type="hidden" name="oid" id="policyOid" value="${dto.oid}"/>
        <input type="hidden" name="product_id" id="productOid" value="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}"/>
        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>推荐人信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-4 col-xs-4">
                    <p>推荐人的手机号或编号</p>
                    <input type="text" name="recommend_code" id="recommend_code" data-relate="${not empty dto.product_oid ? dto.product_oid : not empty pd.oid ? pd.oid : ''}" value="${empty vo.recommend_code ? recommend_code : vo.recommend_code}" class="form-control" placeholder="请输入推荐人的手机号或编号" maxlength="20"/>
                    <input type="hidden" name="sigId" value="${dto.trade_serial_number}"/>
                </div>
                <div class="col-sm-4 col-xs-4">
                </div>
                <div class="col-sm-4 col-xs-4">
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
        <div class="message-war"><!-- message-war start -->
            <input type="hidden" name="roleSubjectList[0].oid" id="role_appRoleID_0" value="${vo.roleSubjectList[0].oid}"/>
            <input type="hidden" name="roleSubjectList[0].kind" id="role_kind_0" value="1"/>
            <input type="hidden" name="roleSubjectList[0].roleType" id="role_roleType_0" value="1"/>
            <div class="title-war"><h3 id="cy_lxr">投保单位信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-6 col-xs-6">
                    <p>*投保人名称<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="请填写与营业执照相一致的单位名称，个人不能作为投保单位"></i></p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].name_cn" id="role_namecn_0" value="${vo.roleSubjectList[0].name_cn}" class="form-control" placeholder="请填写与营业执照相一致的单位名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-6 col-xs-6">
                    <p>*营业性质</p>
                    <div class="row">
                        <div class="col-sm-6 col-xs-6">
                            <select data-val="Required" name="roleSubjectList[0].com_nature" id="role_comNature_0" class="form-control" onchange="natureChange(this,'role_natureTwo_0');" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">-请选择-</option>
                                <c:forEach items="${natureList }" var="list">
                                    <option value="${list.value }" <c:if test="${vo.roleSubjectList[0].com_nature eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6" <c:if test="${empty vo.roleSubjectList[0].nature_two }"> hidden</c:if>>
                            <select name="roleSubjectList[0].nature_two" id="role_natureTwo_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">-请选择-</option>
                                <c:forEach items="${natureTwoList }" var="list">
                                    <option value="${list.value }" <c:if test="${vo.roleSubjectList[0].nature_two eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                </c:forEach>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件类型</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[0].id_type" id="role_idType_0" value="${vo.roleSubjectList[0].id_type}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">-请选择-</option>
                        <c:forEach items="${comTypeList }" var="list">
                            <option value="${list.value }" <c:if test="${vo.roleSubjectList[0].id_type eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件号码<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="组织机构代码：只能包含数字或英文大写字母，必须用连字符“-”隔开；营业执照：只能为15位数字；税务登记证：只能为15位数字，或20位数字，或19位数字与字母X组合；三证合一统一信用代码：由数字或大写英文字母组成，共18位"></i></p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].organization_code" id="role_organizationCode_0" GIST-ID="role_idType_0" value="${vo.roleSubjectList[0].organization_code}" class="form-control"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-9 col-xs-9">
                    <p>*注册地址</p>
                    <div class="row">
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="省" name="roleSubjectList[0].reg_province" id="regProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regCity', '', '2', this);">
                                <option value="">请选择省</option>
                                <c:forEach items="${provinceList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_province }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="市" name="roleSubjectList[0].reg_city" id="regCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regDistrict', '', '3', this);">
                                <option value="">请选择市</option>
                                <c:forEach items="${cityList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].reg_city}"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="县" name="roleSubjectList[0].reg_district" id="regDistrict" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">请选择县</option>
                                <c:forEach items="${areaList }" var="list">
                                    <option value="${list.codes }" <c:if test="${vo.roleSubjectList[0].reg_district eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <input Data-Val="Required" type="text" name="roleSubjectList[0].reg_address" id="role_regAddress_0" value="${vo.roleSubjectList[0].reg_address}" class="form-control" placeholder="请填写具体地址（包含：镇、乡或街道）" />
                            <span class="glyphicon form-control-feedback t-icon-l" style="top:0;" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人姓名</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_name" id="role_linkName_0" value="${vo.roleSubjectList[0].link_name}" class="form-control" placeholder="请填写联系人名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人手机</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_tel" id="role_linkTel_0" value="${vo.roleSubjectList[0].link_tel}" class="form-control" placeholder="请填写联系人手机号" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人email</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].link_email" id="role_linkEmail_0" value="${vo.roleSubjectList[0].link_email}" class="form-control" placeholder="请填写联系人邮箱" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clear"></div>
                <div class="col-sm-4 col-xs-4">
                    <p>*上传证件扫描件<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top"  title="请上传营业执照三证合一证件的扫描件。附件不能大于20M。"></i> <i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top"  title="没有营业执照如何上传？
                    以下单位需提供的资料附件：
                    ● 机关：组织机构代码证；
                    ● 事业单位：事业单位法人证书、组织机构代码证；
                    ● 社会团体：社会团体法人登记证书、组织机构代码证；
                    ● 其他：批准设立或者核准登记的文件、组织机构代码证。"></i></p>
                    <input Data-Val="FILE Required" type="hidden" name="roleSubjectList[0].app_organizing_path" id="appOrganizingPath" value="${vo.roleSubjectList[0].app_organizing_path}">
                    <div>
                        <input name="appOrganizingPath_file" id="appOrganizingPath_file-5" data-drawview="${vo.roleSubjectList[0].app_organizing_path}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon=""/>
                    </div>
                    <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->

        <div class="message-war"><!-- message-war start -->
            <input type="hidden" name="roleSubjectList[1].oid" id="role_oid_1" value="${vo.roleSubjectList[1].oid}"/>
            <input type="hidden" name="roleSubjectList[1].kind" id="role_kind_1" value="2"/>
            <div class="title-war"><h3 id="cy_lxr_bb">被保险人信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-6 col-xs-6">
                    <p>*被保险人名称</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].name_cn" id="role_namecn_1" value="${vo.roleSubjectList[1].name_cn}" class="form-control" placeholder="请填写与营业执照相一致的单位名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-6 col-xs-6">
                    <p>*营业性质</p>
                    <div class="row">
                        <div class="col-sm-6 col-xs-6">
                            <select data-val="Required" name="roleSubjectList[1].com_nature" id="role_comNature_1" class="form-control" onchange="natureChange(this,'role_natureTwo_1');" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">-请选择-</option>
                                <c:forEach items="${natureList }" var="list">
                                    <option value="${list.value }" <c:if test="${vo.roleSubjectList[1].com_nature eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6" <c:if test="${empty vo.roleSubjectList[1].nature_two }"> hidden</c:if>>
                            <select name="roleSubjectList[1].nature_two" id="role_natureTwo_1" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">-请选择-</option>
                                <c:forEach items="${natureTwoList1 }" var="list">
                                    <option value="${list.value }" <c:if test="${vo.roleSubjectList[1].nature_two eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                                </c:forEach>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件类型</p>
                    <select Data-Val="Required" class="form-control" name="roleSubjectList[1].id_type" id="role_idType_1" value="${vo.roleSubjectList[1].id_type}" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">-请选择-</option>
                        <c:forEach items="${comTypeList }" var="list">
                            <option value="${list.value }" <c:if test="${vo.roleSubjectList[1].id_type eq list.value }"> selected="selected"</c:if>>${list.name }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*证件号码<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" title="组织机构代码：只能包含数字或英文大写字母，必须用连字符“-”隔开；营业执照：只能为15位数字；税务登记证：只能为15位数字，或20位数字，或19位数字与字母X组合；三证合一统一信用代码：由数字或大写英文字母组成，共18位"></i></p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].organization_code" id="role_organizationCode_1" GIST-ID="role_idType_1" value="${vo.roleSubjectList[1].organization_code}" class="form-control"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-9 col-xs-9">
                    <p>*详细地址</p>
                    <div class="row">
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="省" name="roleSubjectList[1].reg_province" id="regProvince_1" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regCity_1', '', '2', this);">
                                <option value="">请选择省</option>
                                <c:forEach items="${provinceList }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[1].reg_province }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="市" name="roleSubjectList[1].reg_city" id="regCity_1" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('regDistrict_1', '', '3', this);">
                                <option value="">请选择市</option>
                                <c:forEach items="${reg_city_1_List }" var="list">
                                    <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[1].reg_city}"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-2 col-xs-2">
                            <select Data-Val="Required" title="县" name="roleSubjectList[1].reg_district" id="regDistrict_1" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                                <option value="">请选择县</option>
                                <c:forEach items="${reg_area_1_List }" var="list">
                                    <option value="${list.codes }" <c:if test="${vo.roleSubjectList[1].reg_district eq list.codes }"> selected="selected"</c:if>>${list.named }</option>
                                </c:forEach>
                            </select>
                        </div>
                        <div class="col-sm-6 col-xs-6">
                            <input Data-Val="Required" type="text" name="roleSubjectList[1].reg_address" id="regAddress_1" value="${vo.roleSubjectList[1].reg_address}" class="form-control" placeholder="请填写具体地址（包含：镇、乡或街道）" />
                            <span class="glyphicon form-control-feedback t-icon-l" style="top:0;" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>
                <%--<div class="col-sm-3 col-xs-3">
                    <p>*被保人营业性质</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].com_type" id="role_comType_1" value="${vo.roleSubjectList[1].com_type}" class="form-control" placeholder="请填写被保人营业性质" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>--%>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人姓名</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].link_name" id="role_linkName_1" value="${vo.roleSubjectList[1].link_name}" class="form-control" placeholder="请填写联系人名称" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人手机</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].link_tel" id="role_linkTel_1" value="${vo.roleSubjectList[1].link_tel}" class="form-control" placeholder="请填写联系人手机号" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*联系人email</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].link_email" id="role_linkEmail_1" value="${vo.roleSubjectList[1].link_email}" class="form-control" placeholder="请填写联系人邮箱" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <%--<div class="col-sm-6 col-xs-6">
                    <p>*详细地址</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].reg_address" id="role_regAddress_1" value="${vo.roleSubjectList[1].reg_address}" class="form-control" placeholder="请填写详细地址" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>--%>
                <%--<div class="col-sm-3 col-xs-3">
                    <p>*被保人营业性质</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[1].com_type" id="role_comType_1" value="${vo.roleSubjectList[1].com_type}" class="form-control" placeholder="请填写被保人营业性质" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>--%>
                <div class="clear"></div>
                <div class="col-sm-4 col-xs-4">
                    <p>*上传证件扫描件<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top"  title="请上传营业执照三证合一证件的扫描件。附件不能大于20M。"></i> <i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top"  title="没有营业执照如何上传？
                    以下单位需提供的资料附件：
                    ● 机关：组织机构代码证；
                    ● 事业单位：事业单位法人证书、组织机构代码证；
                    ● 社会团体：社会团体法人登记证书、组织机构代码证；
                    ● 其他：批准设立或者核准登记的文件、组织机构代码证。"></i></p>
                    <input Data-Val="FILE Required" type="hidden" name="roleSubjectList[1].app_organizing_path" id="insOrganizingPath" value="${vo.roleSubjectList[1].app_organizing_path}">
                    <div>
                        <input name="insOrganizingPath_file" id="insOrganizingPath_file-5" data-drawview="${vo.roleSubjectList[1].app_organizing_path}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon=""/>
                    </div>
                    <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，2M以内</span>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->

        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>活动信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-3 col-xs-3">
                    <p>*活动名称</p>
                    <c:if test="${acts.size()<1 || acts == null}">
                        <input Data-Val="Required" type="text" name="report_name" id="report_name" value="${vo.report_name}" class="form-control" placeholder="请填写展会活动的具体名称" />
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </c:if>
                    <c:if test="${acts.size()>0}">
                        <select id="report_name_help" class="form-control" onchange="getActivityByPss(this);" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                            <option value="">--请选择--</option>
                            <c:forEach var="act" items="${acts}">
                                <option value="${act.activity_id}" <c:if test="${act.activity_id eq vo.thr_order_id}">selected="selected"</c:if> >${act.name}</option>
                            </c:forEach>
                        </select>
                        <input type="hidden" id="policyExtrareportName" name="report_name" value="${vo.report_name}">
                        <input type="hidden" id="thr_order_id" name="thr_order_id" value="${vo.thr_order_id}">
                    </c:if>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*活动类型:</p>
                    <input  type="hidden"  id="policyExtraReportActive" name="report_active" value="${fn:split(pd.product_code, '-')[2]}">
                    <c:if test="${not empty  pd.product_code && fn:split(pd.product_code, '-')[2] eq 'ZL'}">
                        <div><span>展览展销类活动</span></div>
                    </c:if>
                    <c:if test="${not empty  pd.product_code && fn:split(pd.product_code, '-')[2] eq 'WY'}">
                        <div><span>文艺演出类活动</span></div>
                    </c:if>
                    <c:if test="${not empty  pd.product_code && fn:split(pd.product_code, '-')[2] eq 'TY'}">
                        <div><span>体育赛事类活动</span></div>
                    </c:if>
                    <c:if test="${not empty  pd.product_code && fn:split(pd.product_code, '-')[2] eq 'QT'}">
                        <div><span>其他</span></div>
                    </c:if>
                </div>
                <div class="col-sm-6 col-xs-6">
                    <p>*承保区域</p>
                    <input Data-Val="Required" type="text" name="report_local" id="report_local" value="${vo.report_local}" class="form-control" placeholder="请填写详细地址" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <%--<div class="col-sm-8 col-xs-8">
                    <p>*活动期间</p>
                    <div class="row">
                        <div class="col-sm-4 col-xs-4">
                            <input Data-Val="Date Required" type="text" name="report_begin_date" id="report_begin_date" value="${ vo.report_begin_date}" class="laydate-icon form-control">
                            <span class="glyphicon form-control-feedback" style="top:0;" aria-hidden="true" ></span>
                        </div>
                        <div class="col-sm-1 col-xs-1">至</div>
                        <div class="col-sm-4 col-xs-4">
                            <input Data-Val="Date Required" type="text" name="report_end_date" id="report_end_date" value="${ vo.report_end_date}" class="laydate-icon form-control">
                            <span class="glyphicon form-control-feedback" style="top:0;" aria-hidden="true" ></span>
                        </div>
                    </div>
                </div>--%>
                <div class="clear"></div>
                <div class="col-sm-12 col-xs-12 reminder">
                    <label>温馨提示：若拆活动临建设施搭建时间在活动起止日期前后，可根据实际活动临建设施拆搭建天数累计投保。</label>
                    <%--<label>温馨提示：若活动时间选择期间已包含拆搭建时间，那么“活动临建设施搭建天数”和“活动临建设施拆除天数”两项可不填写。</label>--%>
                </div>
                <div class="clear"></div>
                <div class="col-sm-3 col-xs-3">
                    <p>活动临建设施搭建天数</p>
                    <input Data-Val="Num" type="text" name="buss_days" id="buss_days" onblur="premiumCalc()" value="${vo.buss_days}" class="form-control" placeholder="活动开始前的搭建天数，选填" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>活动临建设施拆除天数</p>
                    <input Data-Val="Num" type="text" name="tear_days" id="tear_days" onblur="premiumCalc()" value="${vo.tear_days}" class="form-control" placeholder="活动结束后的拆除天数，选填" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*活动开始日期</p>
                    <input Data-Val="Date Required" type="text" name="report_begin_date" id="report_begin_date" value="${ vo.report_begin_date}" class="laydate-icon form-control" onchange="premiumCalc()">
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*活动结束日期</p>
                    <input Data-Val="Date Required" type="text" name="report_end_date" id="report_end_date" value="${ vo.report_end_date}" class="laydate-icon form-control">
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="clear"></div>
                <div class="col-sm-4 col-xs-4">
                    <p>活动地点</p>
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-sm-4 col-xs-4 rad-io">
                                    <span>
                                        <input type="radio" value="INDOOR" name="activity_local" id="radio-11" onclick="premiumCalc()" <c:if test="${ empty vo.activity_local || vo.activity_local eq 'INDOOR' }"> checked="checked" </c:if>><label for="radio-11" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('radio-11','radio');">室内场馆</strong>
                                    </span>
                                </div>
                                <div class="col-sm-4 col-xs-4 rad-io">
                                    <span><input type="radio" value="OPEN" name="activity_local" id="radio-12" onclick="premiumCalc()"  <c:if test="${vo.activity_local eq 'OPEN' }"> checked="checked" </c:if>><label for="radio-12" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('radio-12','radio');">露天场馆</strong></span>
                                </div>
                                <div class="col-sm-4 col-xs-4 rad-io">
                                    <span><input type="radio" value="OUTDOOR" name="activity_local" id="radio-13" onclick="premiumCalc()"  <c:if test="${vo.activity_local eq 'OUTDOOR' }"> checked="checked" </c:if>><label for="radio-13" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('radio-13','radio');">户外场馆</strong></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-5 col-xs-5">
                    <p>消防情况</p>
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-sm-4 col-xs-4 rad-io">
                                    <span>
                                        <input type="radio" value="ACCEPTANCE" name="activity_fire_fight" id="radio-5" onclick="premiumCalc()" <c:if test="${ empty vo.activity_fire_fight || vo.activity_fire_fight eq 'ACCEPTANCE' }"> checked="checked" </c:if>><label for="radio-5" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('radio-5','radio');">有消防验收</strong>
                                    </span>
                                </div>
                                <div class="col-sm-8 col-xs-8 rad-io">
                                    <span><input type="radio" value="EXTINGUISHER" name="activity_fire_fight" id="radio-6" onclick="premiumCalc()"  <c:if test="${vo.activity_fire_fight eq 'EXTINGUISHER' }"> checked="checked" </c:if>><label for="radio-6" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('radio-6','radio');">无消防验收但配备灭火器</strong></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>有无危险环节（如烟花） </p>
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-sm-4 col-xs-4 rad-io">
                                    <span>
                                        <input type="radio" value="HAVE" name="danger" id="radio-3" onclick="premiumCalc()" <c:if test="${ empty vo.danger || vo.danger eq 'HAVE' }"> checked="checked" </c:if>><label for="radio-3" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('radio-3','radio');">有</strong>
                                    </span>
                                </div>
                                <div class="col-sm-4 col-xs-4 rad-io">
                                    <span><input type="radio" value="WITHOUT" name="danger" id="radio-4" onclick="premiumCalc()"  <c:if test="${vo.danger eq 'WITHOUT' }"> checked="checked" </c:if>><label for="radio-4" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('radio-4','radio');">无</strong></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="clear"></div>
                <div class="col-sm-3 col-xs-3">
                    <p>*预计活动参与总人数</p>
                    <input Data-Val="Num Required" type="text" name="people_num" id="policyExtrapeopleNum" value="${vo.people_num}" onblur="limitAmountCalc()" class="form-control" placeholder="请填写活动参与人数"  onkeyup='this.value=this.value.replace(/^[0]+[0-9]*$/gi,"")' maxlength="10000000" onmousewheel="return false;"/>
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*展览会场所面积（平米）</p>
                    <input Data-Val="Num Required" type="text" name="ex_acreage" id="ex_acreage" value="${vo.ex_acreage}" onblur="premiumCalc()" class="form-control" placeholder="请填写展览会场所面积" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>预计天数：</p>
                    <div><span id="activity_days_html">${vo.activity_days}</span></div>
                    <input type="hidden" name="activity_days" id="activity_days" value="${vo.activity_days}" />
                </div>

            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->

        <div class="message-war">
            <div class="title-war"><h3>保险方案基本信息</h3></div>
            <div class="row w-95-auto">
                <%--<div class="col-sm-12 col-xs-12">
                    <p>选择方案</p>
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-sm-2 col-xs-2 rad-io mt-20">
                                    <span>
                                        <input type="radio" value="1" name="activity_scheme" id="radio-15" onclick="gzx_premiumCalc()" <c:if test="${ empty vo.activity_scheme || vo.activity_scheme eq '1' }"> checked="checked" </c:if>><label for="radio-15" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('radio-15','radio');">方案一</strong>
                                    </span>
                                </div>
                                <div class="col-sm-2 col-xs-2 rad-io mt-20">
                                    <span>
                                        <input type="radio" value="2" name="activity_scheme" id="radio-16" onclick="gzx_premiumCalc()"  <c:if test="${vo.activity_scheme eq '2' }"> checked="checked" </c:if>><label for="radio-16" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('radio-16','radio');">方案二</strong>
                                    </span>
                                </div>
                                <div class="col-sm-2 col-xs-2 rad-io mt-20">
                                    <span>
                                        <input type="radio" value="3" name="activity_scheme" id="radio-17" onclick="gzx_premiumCalc()"  <c:if test="${vo.activity_scheme eq '3' }"> checked="checked" </c:if>><label for="radio-17" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('radio-17','radio');">方案三</strong>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>--%>
                <div class="col-sm-3 col-xs-3">
                    <p>*每人每次事故赔偿限额</p>
                    <div id="person-amount">
                        <span>25万</span>
                    </div>
                </div>
                <div class="col-sm-6 col-xs-6">
                    <input name="min_limit" id="min_limit" type="hidden" value="500"/>
                    <input name="max_limit" id="max_limit" type="hidden" value="3500"/>
                    <p>*每次事故及累计赔偿限额（万元）<i class="glyphicon glyphicon-info-sign ic-f3aa84" data-toggle="tooltip" data-placement="top" id="amountTips" title="根据预计活动参与总人数，请填写500万（含）至3500万（含）之间的数值。"></i> </p>
                    <div id="sg-amount">
                        <input Data-Val="Num Required" type="number" name="insured_amount" id="policyAmount" value="${vo.insured_amount/10000}" class="form-control" placeholder="最小限额为500万元，最大限额为3500万元" onblur="limitAmount(this);"/>
                    </div>
                    <%--                    <input type="hidden" name="insured_amount" id="insured_amount" value="${vo.insured_amount}" />--%>
                </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="row">
                            <div class="col-sm-6 col-sm-6 mt-20">
                                <div class="insure-check">
                                    <span class="check-box pull-left" id="check_span">
                                        <input type="checkbox" id="check_007" class="form-control" Data-Val="Required" />
                                        <label for="check_007" id="check_007_for"></label>
                                    </span>
                                    <span class="pull-left" style="line-height: 13px;font-weight: bold;color: red">本企业理解并接受上述保障方案</span><br />
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
        </div>

        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>投保基本信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-9 col-xs-9">
                    <p>*保险期间</p>
                    <div class="row fs-lh34">
                        <div class="col-sm-1 col-xs-1">自</div>
                        <div class="col-sm-3 col-xs-3">
                            <input Data-Val="Date Required" name="inception_date" id="start_datetime" value="${vo.inception_date}" class="laydate-icon form-control" autocomplete="off">
                            <%--<span class="glyphicon form-control-feedback" style="top:0;" aria-hidden="true" ></span>--%>
                        </div>
                        <div class="col-sm-2 col-xs-2">零时起  至</div>
                        <div class="col-sm-3 col-xs-3">
                            <input Data-Val="Date Required" name="planned_end_date" id="end_datetime" value="${vo.planned_end_date}" class="laydate-icon form-control" autocomplete="off">
                            <%--<span class="glyphicon form-control-feedback" style="top:0;" aria-hidden="true" ></span>--%>
                        </div>
                        <div class="col-sm-2 col-xs-2">二十四时止</div>
                    </div>
                </div>
                <div class="col-sm-12 col-xs-12" id="sifa_text_1_isHidden">
                    <p>司法管辖</p>
                    <div><span>中华人民共和国司法管辖（港澳台除外）</span></div>
                </div>
                <div class="clear"></div>
                <div class="bb-mt-e7"></div>
                <div class="col-sm-12 col-xs-12">
                    <p>争议处理</p>
                    <div><span>若投保人/被保险人与保险人发生争执，不能达成协议，被保险人自愿采取的解决方式：</span></div>
                    <div class="row">
                        <div class="col-sm-12 col-xs-12">
                            <div class="row">
                                <div class="col-sm-2 col-xs-2 rad-io mt-20">
                                    <span><input type="radio" value="0" name="dispute" id="dispute_radio1" onclick="checkToradio('dispute_radio1','radio');" <c:if test="${ empty vo.dispute || vo.dispute eq '0' }"> checked="checked" </c:if>><label for="dispute_radio1" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('dispute_radio1','radio');">商议或诉讼</strong></span>
                                </div>
                                <%--<div class="col-sm-2 col-xs-2 rad-io mt-20">
                                    <span><input type="radio" value="1" name="dispute" id="dispute_radio2" onclick="checkToradio('dispute_radio2','radio');"  <c:if test="${vo.dispute eq '1' }"> checked="checked" </c:if>><label for="dispute_radio2" class="pull-left"></label><strong  class="pull-left" onclick="checkToradio('dispute_radio2','radio');">仲裁，仲裁机构</strong></span>
                                </div>
                                <div class="col-sm-3 col-xs-3" <c:if test="${empty vo.dispute ? true : vo.dispute eq '0' }"> style="display: none;" </c:if>>
                                    <input type="text" name="policy_extra_dispute" id="arbitralInstitution" value="${vo.policy_extra_dispute }" class="form-control su-lo">
                                    <span class="glyphicon form-control-feedback pa-27" aria-hidden="true"></span>
                                </div>--%>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>保费</p>
                        <strong class="d-l-36" id="premiumDiv">${empty vo.premium ? pd.premium_min : fn:split(vo.premium, '.')[0] }.00元</strong>
                        <input type="hidden" name="premium" id="premium" value="${empty vo.premium ? pd.premium_min : vo.premium }"/>
                    </div>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->

        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>退保账户信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-12 col-xs-12 reminder">
                    <label>温馨提示：团意险/雇主险每期结算保费时，若有需要退回保费的情况，将往以下账户进行转账。</label>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户行省</p>
                    <select Data-Val="Required" title="省" name="roleSubjectList[0].bank_province" id="tkbankProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('bank_city_0', '', '2', this);">
                        <option value="">请选择省</option>
                        <c:forEach items="${provinceList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_province }"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户行市</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_city" id="bank_city_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeBankType('bank_type_0', this);">
                        <option value="">请选择市</option>
                        <c:forEach items="${bankCityList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_city}"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户银行</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_type" id="bank_type_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeBankAddr('bank_addr_0', 'bank_city_0', this);">
                        <option value="">请选择名称</option>
                        <c:forEach items="${bankTypeList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_type}"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户行地址</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_addr" id="bank_addr_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeBankName('bank_name_0', this);">
                        <option value="">请选择地址</option>
                        <c:forEach items="${bankAddrList }" var="list">
                            <option value="${list.codes }" <c:if test="${list.codes eq vo.roleSubjectList[0].bank_addr}"> selected="selected"</c:if>>${list.named }</option>
                        </c:forEach>
                    </select>
                    <input Data-Val="Required" type="hidden" name="roleSubjectList[0].bank_name" id="bank_name_0" value="${vo.roleSubjectList[0].bank_name}" class="form-control" />
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*账户开户类型</p>
                    <select Data-Val="Required" title="市" name="roleSubjectList[0].bank_pub_pri" id="bank_pub_pri_0" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;">
                        <option value="">请选择类型</option>
                        <option value="1" <c:if test="${'1' eq vo.roleSubjectList[0].bank_pub_pri}"> selected="selected"</c:if>>对公</option>
                        <option value="2" <c:if test="${'2' eq vo.roleSubjectList[0].bank_pub_pri}"> selected="selected"</c:if>>对私</option>
                    </select>
                </div>
                <div class="col-sm-3 col-xs-3">
                    <p>*开户名</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].account_name" id="account_name_0" value="${vo.roleSubjectList[0].account_name}" class="form-control" placeholder="请填写开户名" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
                <%--<div class="col-sm-3 col-xs-3">
                    <p>*账户开户行</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].bank_name" id="bank_name_0" value="${vo.roleSubjectList[0].bank_name}" class="form-control" placeholder="请填写账户开户行" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>--%>
                <div class="col-sm-3 col-xs-3">
                    <p>*银行账号</p>
                    <input Data-Val="Required" type="text" name="roleSubjectList[0].bank_account" id="bank_account_0" value="${vo.roleSubjectList[0].bank_account}" class="form-control" placeholder="请填写银行账号" />
                    <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->

        <div class="message-war"><!-- message-war start -->
            <div class="title-war"><h3>单证信息</h3></div>
            <div class="row w-95-auto"><!-- w-95-auto start -->
                <div class="col-sm-12 col-xs-12 reminder" style="line-height: 25px;">
                    <label>
                        温馨提示：<br/>
                        1.本产品采取电子保单/电子发票形式，投保成功后，电子保单及电子发票会实时发送到您填写的投保人邮箱中；<br/>
                        2.根据《中华人民共和国合同法》第十一条规定，数据电文是合法的合同表现形式，<span style="color:red;">电子保单与纸质保单具有同等法律效力</span>；您可以登录保险公司官网自助查询对电子保单的真实性进行验证；<br/>
                        <span style="color:red;">3.电子发票是以电子方式存储的收付款凭证，其法律效力、基本用途、基本使用规定等与税务机关监制的纸质发票相同。</span>
                    </label>
                </div>
                <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;">
                    <span class="pull-left check-box">
                        <input type="checkbox" checked="checked" id="need_insur_dz" disabled/>
                        <label for="need_insur_dz"></label>
                    </span>
                    <span class="pull-left lhml5">开具电子保单<span class="label label-primary" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">系统默认</span>（实时出单、安全保密、易存易查、不影响理赔）</span>
                </div>
                <div class="clear"></div>
                <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;">
                    <span class="pull-left check-box">
                        <c:set var="is_send_einvoice_1" value="${(not empty vo.mailPolicyVo.is_send_einvoice && vo.mailPolicyVo.is_send_einvoice eq '1')?'1':'0'}"></c:set>
                        <input type="checkbox" value="1" id="is_send_einvoice"<c:if test="${is_send_einvoice_1 eq '1'}"> checked="checked"</c:if>/>
                        <label for="is_send_einvoice"></label>
                        <input type="hidden" name="mailPolicyVo.is_send_einvoice" value="${vo.mailPolicyVo.is_send_einvoice}" />
                    </span>
                    <span class="pull-left lhml5">开具电子发票<span class="label label-success" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">推荐使用</span>（实时开具、加密防伪、长期保存、随打随用）</span>
                </div>
                <div class="clear"></div>
                <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;">
                    <span class="pull-left check-box">
                        <c:set var="is_need_insur_bill" value="${(not empty vo.mailPolicyVo.need_insur_bill && vo.mailPolicyVo.need_insur_bill eq '1')?'1':'0'}"></c:set>
                        <input disabled type="checkbox" value="1" name="mailPolicyVo.need_insur_bill" id="need_insur_bill"<c:if test="${is_need_insur_bill eq '1'}"> checked="checked"</c:if>/>
                        <label for="need_insur_bill"></label>
                    </span>
                    <span class="pull-left lhml5">开具纸质保单<span class="label label-danger" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">不推荐</span>（不便于管理、开具时效 3-5 个工作日）</span>
                </div>
                <div class="clear"></div>
                <div id="mod_1" <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> style="display: none;"</c:if>>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收件人名称</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receiver_name" id="receiverName" value="${ vo.mailPolicyVo.receiver_name}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill ? true : vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收件人手机</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receiver_mobile" id="receiverMobile" value="${ vo.mailPolicyVo.receiver_mobile}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-6 col-xs-6">
                        <p>*收件人地址</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receiver_address_detail" id="receiverAddressDetail" value="${ vo.mailPolicyVo.receiver_address_detail}" class="form-control" placeholder=""  <c:if test="${empty vo.mailPolicyVo.need_insur_bill || vo.mailPolicyVo.need_insur_bill eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="clear"></div>
                    <div class="bb-mt-e7"></div>
                </div>
                <div class="col-sm-6 col-xs-6 mt-20" style="margin-top: 10px;">
                    <span class="pull-left check-box">
                        <c:set var="is_need_receipt" value="${(not empty vo.mailPolicyVo.need_receipt && vo.mailPolicyVo.need_receipt eq '1')?'1':'0'}"></c:set>
                        <input type="checkbox" value="1" id="need_receipt"<c:if test="${is_need_receipt eq '1'}"> checked="checked"</c:if>/>
                        <label for="need_receipt"></label>
                        <input type="hidden" name="mailPolicyVo.need_receipt" value="${vo.mailPolicyVo.need_receipt}" />
                    </span>
                    <span class="pull-left lhml5">开具纸质发票<span class="label label-danger" style="margin-left: 5px;border-radius: 0;padding: .1em .3em .2em;">不推荐</span>（不便于管理、开具时效 3-5 个工作日）</span>
                </div>
                <div class="clear"></div>
                <div id="mod_2" <c:if test="${empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0' || vo.mailPolicyVo.is_send_einvoice eq '0'}"> style="display: none;"</c:if>>
                    <div class="col-sm-12 col-xs-12">
                        <p>发票种类</p>
                        <div class="row">
                            <div class="col-sm-12 col-xs-12">
                                <div class="row">
                                    <div class="col-sm-2 col-xs-2 rad-io">
                                        <c:set var="is_invoice_type_1" value="${(empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' || vo.mailPolicyVo.is_send_einvoice eq '1')?'1':'0'}"></c:set>
                                        <span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_1" value="0"<c:if test="${is_invoice_type_1 eq '1'}"> checked="checked"</c:if>><label for="invoice_type_1" class="pull-left"></label><strong  class="pull-left">增值税普通发票</strong></span>
                                    </div>
                                    <div class="col-sm-2 col-xs-2 rad-io"<c:if test="${vo.mailPolicyVo.is_send_einvoice eq '1'}"> style="display: none;"</c:if>><%--选电子发票就隐藏该项--%>
                                        <c:set var="is_invoice_type_2" value="${(not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '1')?'1':'0'}"></c:set>
                                        <span><input type="radio" name="mailPolicyVo.invoice_type" id="invoice_type_2" value="1"<c:if test="${is_invoice_type_2 eq '1'}"> checked="checked"</c:if>><label for="invoice_type_2" class="pull-left"></label><strong  class="pull-left">增值税专用发票</strong></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-xs-12 reminder" id="mod_2_1" <c:if test="${(not empty vo.mailPolicyVo.invoice_type && vo.mailPolicyVo.invoice_type eq '0') || vo.mailPolicyVo.is_send_einvoice eq '0' }"> style="display: none;"</c:if>>
                    <label>温馨提示：请认真填写下述信息，确保信息真实准确，以免因开票信息错误给贵司带来损失。提交信息后，我司将在1-2个工作日完成审核，请及时关注审核结果。</label>
                </div>
                <div id="mod_2_2" <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> style="display: none;"</c:if>>
                    <div class="col-sm-3 col-xs-3">
                        <p>*单位名称</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receipt_head" id="receipt_head" value="${ vo.mailPolicyVo.receipt_head}" class="form-control" placeholder="" <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收票人姓名</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taker_name" id="takerName" value="${ vo.mailPolicyVo.taker_name}" class="form-control" placeholder="" <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收票人手机</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taker_mobile" id="takerMobile" value="${ vo.mailPolicyVo.taker_mobile}" class="form-control" placeholder=""  <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*收票人地址</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taker_address_detail" id="takerAddressDetail" value="${ vo.mailPolicyVo.taker_address_detail}" class="form-control" placeholder="企业营业执照上的全称"  <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3" <c:if test="${vo.mailPolicyVo.invoice_type eq '1'}"> style="display: none;"</c:if>>
                        <p>*纳税人识别号</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice_1" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号"  <c:if test="${(empty vo.mailPolicyVo.need_receipt || vo.mailPolicyVo.need_receipt eq '0' || vo.mailPolicyVo.invoice_type eq '1') && vo.mailPolicyVo.is_send_einvoice eq '0'}"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="clear"></div>
                    <div class="bb-mt-e7"></div>
                </div>
                <div id="mod_2_3" <c:if test="${empty mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> style="display: none;"</c:if>>
                    <div class="col-sm-3 col-xs-3">
                        <p>*纳税人识别号</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.taxpayer_number_invoice" id="taxpayerNumberInvoice" value="${ vo.mailPolicyVo.taxpayer_number_invoice}" class="form-control" placeholder="企业《税务登记证》编号"<c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*注册地址</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.register_address_invoice" id="registerAddressInvoice" value="${ vo.mailPolicyVo.register_address_invoice}" class="form-control" placeholder="企业营业执照上的注册地址" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*电话</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.receipt_phone" id="receiptPhone" value="${ vo.mailPolicyVo.receipt_phone}" class="form-control" placeholder="企业联系电话" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*开户银行省</p>
                        <select Data-Val="Required" title="省" name="mailPolicyVo.bank_province" id="bankProvince" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" onchange="javascript:changeDistrict('bankCity', '', '2', this);" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
                            <option value="">请选择省</option>
                            <c:forEach items="${provinceList }" var="list">
                                <option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_province }"> selected="selected"</c:if>>${list.named }</option>
                            </c:forEach>
                        </select>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*开户银行市</p>
                        <select title="市" name="mailPolicyVo.bank_city" id="bankCity" class="form-control" style="background:url(<c:url value='/resources/versions-2.0/images/public/select-btn.jpg' />) 97% no-repeat  #fafafc;" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>>
                            <option value="">请选择市</option>
                            <c:forEach items="${bankCityList }" var="list">
                                <option value="${list.codes }" <c:if test="${list.codes eq vo.mailPolicyVo.bank_city}"> selected="selected"</c:if>>${list.named }</option>
                            </c:forEach>
                        </select>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*开户银行</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.bank_invoice" id="bankInvoice" value="${ vo.mailPolicyVo.bank_invoice}" class="form-control" placeholder="企业银行开户许可证上的开户银行" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="col-sm-3 col-xs-3">
                        <p>*银行账号</p>
                        <input Data-Val="Required" type="text" name="mailPolicyVo.bank_account_invoice" id="bankAccountInvoice" value="${ vo.mailPolicyVo.bank_account_invoice}" class="form-control" placeholder="企业开户许可证上的银行账号" <c:if test="${empty vo.mailPolicyVo.invoice_type || vo.mailPolicyVo.invoice_type eq '0' }"> data-status="hidden"</c:if>/>
                        <span class="glyphicon form-control-feedback" aria-hidden="true" ></span>
                    </div>
                    <div class="clear"></div>
                    <div class="bb-mt-e7"></div>
                    <div class="col-sm-4 col-xs-4">
                        <p>税务登记证<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/tax.jpg')">（样例）</a></p>
                        <input type="hidden" title="" name="mailPolicyVo.tax_cert" id="tax_cert" value="${vo.mailPolicyVo.tax_cert }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.tax_cert }" name="tax_cert_file" id="tax_cert_file-5" data-drawview="${vo.mailPolicyVo.tax_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>一般纳税人证明</p>
                        <input type="hidden" title="" name="mailPolicyVo.tax_prove" id="tax_prove" value="${vo.mailPolicyVo.tax_prove }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.tax_prove }" name="tax_prove_file" id="tax_prove_file-5" data-drawview="${vo.mailPolicyVo.tax_prove }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>银行开户许可证</p>
                        <input type="hidden" title="" name="mailPolicyVo.bank_licence" id="bank_licence" value="${vo.mailPolicyVo.bank_licence }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.bank_licence }" name="bank_licence_file" id="bank_licence_file-5" data-drawview="${vo.mailPolicyVo.bank_licence}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>营业执照副本<a href="javascript:;" onclick="openImgView('/resources/versions-2.0/images/product/open.jpg')">（样例）</a></p>
                        <input type="hidden" title="" name="mailPolicyVo.business_license" id="business_license" value="${vo.mailPolicyVo.business_license }">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.business_license }" name="business_license_file" id="business_license_file-5" data-drawview="${vo.mailPolicyVo.business_license}" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                    <div class="col-sm-4 col-xs-4">
                        <p>增票授权委托书（个人支付时需提供此委托书<a href="<c:url value='/resources/files/增票授权委托书.doc' />" target="_blank">下载</a>）</p>
                        <input type="hidden" title="" name="mailPolicyVo.auth_cert" id="auth_cert" value="${vo.mailPolicyVo.auth_cert}">
                        <div>
                            <input title="" value="${vo.mailPolicyVo.auth_cert }" name="auth_cert_file" id="auth_cert_file-5" data-drawview="${vo.mailPolicyVo.auth_cert }" class="file" type="file" data-preview-file-type="image" data-upload-url="#" data-preview-file-icon="">
                        </div>
                        <span class="mt-db-7f"><i class="glyphicon glyphicon-info-sign"></i> jpg、gif、png、jpeg、bmp图片格式，8M以内</span>
                    </div>
                </div>
            </div><!-- w-95-auto end -->
        </div><!-- message-war end -->
    </form>
    <div class="row next-step">
        <div class="col-sm-12 col-xs-12 text-right pull-right">
            <p>
                <a href="javascript:void(0);" onclick="saveGZXInfo();" id="pendingInfo" class="save">暂存本页</a>
                <a href="javascript:void(0);" onclick="save_policy_gzx();" class="ns-btn">下一步</a>
            </p>
        </div>
    </div>
</div><!-- container end -->
<input id="fileKeyName" type="hidden" value=""><!-- 上传文件的key，重要！ -->
<!-- 营业执照 start -->
<div class="modal fade" id="open" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">营业执照</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/open.jpg' />" class="img-responsive ml-14">
            </div>
        </div>
    </div>
</div>
<!-- 营业执照 end -->
<!-- 组织机构代码证 start -->
<div class="modal fade" id="org" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">组织机构代码证</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/org.jpg' />" class="img-responsive">
            </div>
        </div>
    </div>
</div>
<!-- 组织机构代码证 end -->
<!-- 税务登记证 start -->
<div class="modal fade" id="tax" tabindex="-1" role="dialog" aria-labelledby="mySmallModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header bg-1f96ef">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title">税务登记证</h4>
            </div>
            <div class="modal-body">
                <img src="<c:url value='/resources/versions-2.0/images/product/tax.jpg' />" class="img-responsive">
            </div>
        </div>
    </div>
</div>
</body>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/jquery.min.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/bootstrap.min.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/normalCheck.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/validateIdent.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/js/layer/layer.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/js/checkInputChangeStyle.js'/>"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/date/laydate.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/commonJS/con-common.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/script/html2canvas.min.js' />"></script>
<%--<script type="text/javascript" src="<c:url value='/resources/commonJS/canvasFileUpload.js' />"></script>--%>
<script src="/static/weChat/js/weixin_g.js"></script>
<jsp:include page="../../../index/multi_init_param.jsp"/>

<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb.min.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/rrweb-save.js?1003' />"></script>
<script type="text/javascript" src="<c:url value='/resources/rrweb/js/watermark.js?7' />"></script>
<script>
    window.onload = function () {
        //以后优化 频繁变更水印
        watermark.load({ watermark_txt: "${fns:getWatermark(dto.trade_serial_number)}" });
    }
    function closeUMsg(){
        var _bContentHeight = $('#_bContent').scrollTop();
        console.log(_bContentHeight);
        if(_bContentHeight<2800){
            laySomenType(1,null,"“责任免除”内容请阅读到底部",0);
            return;
        }
        $('.contacts_modal_oth').hide();
        $('.black-mask-oth').hide();
    }
    function closeUMsg1(){
        var _text = $('#closeUMsg').text();
        if(_text.indexOf('(')>0){
            return;
        }
        var khgzsHeight = $('#khgzs').scrollTop();
        if(khgzsHeight<620){
            laySomenType(1,null,"“客户告知书”内容请阅读到底部",0);
            return;
        }
        var starP='<p class="MsoNormal" align="center" style="text-align:center;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:14.0000pt;mso-font-kerning:1.0000pt;">保险条款</span><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:14.0000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-bottom:7.8500pt;mso-para-margin-bottom:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;">_pcs<b><span style="font-family: 宋体; font-size: 10pt;"><o:p></o:p></span></b></p>';
        var starA='';
        <c:if test="${not empty pd.pro_clauses}">
        <c:forEach items="${fn:split(pd.pro_clauses, '#')}" var="pcs">
        starA += '<b><span style="font-family: 宋体; font-size: 12pt;">${fn:split(pcs, "::")[1]}</span></b><iframe id="frame3d" name="frame3d" frameborder="0" width="100%" height="400px" scrolling="auto" src="<c:url value='/weixin/product/clause/${fn:split(pcs, "::")[0]}' />" ></iframe>';
        </c:forEach>
        </c:if>
        starP = starP.replace('_pcs',starA);
        var procode = '${pd.product_code}';
        var zlzx = procode.indexOf('-ZL') > 0 ? '' : 'hidden';
        var wyyc = procode.indexOf('-WY') > 0 ? '' : 'hidden';
        var tyss = procode.indexOf('-TY') > 0 ? '' : 'hidden';
        var qtl = procode.indexOf('-QT') > 0 ? '' : 'hidden';
        $('#_bContent').html('<p class="MsoNormal" align="center" style="text-align:center;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:14.0000pt;mso-font-kerning:1.0000pt;">投保须知</span><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:14.0000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><span '+zlzx+'><p class="MsoNormal" align="center" style="margin-bottom:7.8500pt;mso-para-margin-bottom:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;text-align:center;"><b><span style="font-family: 宋体; font-size: 12pt;">（展览展销类）</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">1.本产品条款备案号：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《公众责任保险（</font>2010版）-华泰财险（备-责任）[2010]主27号-注册号：H00015430912017051924441》 、 《华泰财险公众责任保险附加交叉责任条款B-注册号:C00015430922018050709711》、 《华泰财险公众责任保险附加罢工、暴乱、民众骚动及恶意破坏条款-注册号:C00015430922018050710001》、 《华泰财险公众责任保险附加火灾和爆炸责任条款(注册号:C00015430922018050709741)》、 《华泰财险公众责任保险附加急救费用条款(注册号:C00015430922018050709781)》、 《华泰财险公众责任保险附加广告招牌及装饰物责任条款(注册号:C00015430922018050709501)》。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="16" align="justify" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">2.本产品由华泰财产保险有限公司承保(以下简称“华泰财”),目前该公司在北京、上海、天津、重庆、江苏、广东、陕西、四川、云南、辽宁、浙江、河北、湖南、湖北、 安徽、山西、福建、山东、广西、河南、江西、深圳、青岛、大连、宁波、贵州、内蒙古、厦门、黑龙江、新疆设有分支机构。本保险产品的销售区域为全国（不含港澳台）。若您处于华泰财险无分支机构的地区，不影响您的理赔，客户从本平台购买,后续理赔等相关事务均可由我们协助您办理。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="16" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">3.本产品网上投保、网上支付、网上即时核保并出具保险凭证，您可拨打华泰保险公司客户服务热线：4006095509查询、验真，如对本保险产品有任何咨询、报案或投诉问题，也可拨打上述客户服务热线，我们将竭诚为您服务。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="16" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">4.本保险产品为互联网销售保险产品，为您提供电子保单，根据《中华人民共和国民法典》第四百六十九条规定，数据电文是合法的合同表现形式，</span><b><span style="font-family: 宋体; font-size: 10.5pt;">电子保单与纸质保单具有同等法律效力。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">5.本产品在网上投保申请后，最早次日零时生效。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">6.造成受害人人身伤害的，应提供</span><b><span style="font-family: 宋体; font-size: 10.5pt;">二级以上（含二级）医疗机构</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">出具的受害人的病历、诊断证明、医疗费等医疗单据。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">7.本产品项下免赔额为：财产损失500元，人身伤害无免赔。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">8.本保单不负责赔偿由于第三者自身原因(包括但不限于自身疾病、自身运动损伤、自身体质等)导致的人身伤亡或财产损失事故，被保险人所承担的经济赔偿责任。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">9.用于展出的展品遭受的任何损失，不在本保单承保范围内。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">10. 展览展销类活动一般指展出某类物品或集中展出并销售某类商品的活动， 包括博览会、</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;&nbsp;&nbsp;<font face="宋体">展览会、展览、展销会、博览展销会、看样定货会、展览交流会、交易会、贸易洽谈会</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;&nbsp;&nbsp;<font face="宋体">等。</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">11.请您如实填写投保信息</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">，根据《中华人民共和国保险法》第十六条规定：投保人故意或因重大过失未履行如实告知义务的，足以影响保险公司决定是否同意承保或者提高保险费率的，保险公司有权解除合同。投保人故意不履行如实告知义务的，保险公司对于合同解除前发生的保险事故，不承担赔偿或者给付保险金的责任，并不退还保险费。投保人因重大过失未履行如实告知义务，对保险事故的发生有严重影响的，保险公司对于合同解除前发生的保险事故，不承担赔偿或者给付保险金的责任，但应当退还保险费。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">12.</span><b><span style="font-family: 宋体; font-size: 10.5pt;">客户信息收集条款：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">本人授权华泰保险，除法律另有规定外，将本人提供给华泰保险的信息、享受华泰保险服务产生的信息（包括本保单签署之前提供和产生的信息）以及华泰保险根据本条约定查询、收集的信息，用于华泰保险及其因服务必须委托的合作伙伴为本人提供服务、推荐产品、开展市场调查与信息数据分析。本人授权华泰保险，除法律另有规定外，基于为本人提供更优质服务和产品的目的，向华泰保险因服务必要开展合作的伙伴提供、查询、收集本人的信息。为确保本人信息的安全，华泰保险及其合作伙伴对上述信息负有保密义务，并采取各种措施保证信息安全。本条款自本单证签署时生效，具有独立法律效力，不受合同成立与否及效力状态变化的影响。本条所称</font>“华泰保险”是指华泰保险集团股份有限公司及其直接或间接控股的公司，以及华泰保险集团股份有限公司直接或间接作为其单一最大股东的公司。如您不同意上述授权条款的部分或全部，可致电客服热线 4006095509 取消或变更授权。</span></p><p class="MsoNormal"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p></span><span '+wyyc+'><p class="MsoNormal" align="center" style="text-align:center;"><b><span style="font-family: 宋体; font-size: 12pt;">（文艺演出类）</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">1.本产品条款备案号：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《公众责任保险（</font>2010版）-华泰财险（备-责任）[2010]主27号-注册号：H00015430912017051924441》 、 《华泰财险公众责任保险附加交叉责任条款B-注册号:C00015430922018050709711》、 《华泰财险公众责任保险附加罢工、暴乱、民众骚动及恶意破坏条款-注册号:C00015430922018050710001》、 《华泰财险公众责任保险附加火灾和爆炸责任条款(注册号:C00015430922018050709741)》、 《华泰财险公众责任保险附加急救费用条款(注册号:C00015430922018050709781)》、 《华泰财险公众责任保险附加广告招牌及装饰物责任条款(注册号:C00015430922018050709501)》。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="16" align="justify" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">2.本产品由华泰财产保险有限公司承保(以下简称“华泰财”),目前该公司在北京、上海、天津、重庆、江苏、广东、陕西、四川、云南、辽宁、浙江、河北、湖南、湖北、 安徽、山西、福建、山东、广西、河南、江西、深圳、青岛、大连、宁波、贵州、内蒙古、厦门、黑龙江、新疆设有分支机构。本保险产品的销售区域为全国（不含港澳台）。若您处于华泰财险无分支机构的地区，不影响您的理赔，客户从本平台购买,后续理赔等相关事务均可由我们协助您办理。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="16" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">3.本产品网上投保、网上支付、网上即时核保并出具保险凭证，您可拨打华泰保险公司客户服务热线：4006095509查询、验真，如对本保险产品有任何咨询、报案或投诉问题，也可拨打上述客户服务热线，我们将竭诚为您服务。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="16" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">4.本保险产品为互联网销售保险产品，为您提供电子保单，根据《中华人民共和国民法典》第四百六十九条规定，数据电文是合法的合同表现形式，</span><b><span style="font-family: 宋体; font-size: 10.5pt;">电子保单与纸质保单具有同等法律效力。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">5.本产品在网上投保申请后，最早次日零时生效。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">6.造成受害人人身伤害的，应提供</span><b><span style="font-family: 宋体; font-size: 10.5pt;">二级以上（含二级）医疗机构</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">出具的受害人的病历、诊断证明、医疗费等医疗单据。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">7.本产品项下免赔额为：财产损失500元，人身伤害无免赔。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">8.本保单不负责赔偿由于第三者自身原因(包括但不限于自身疾病、自身运动损伤、自身体质等)导致的人身伤亡或财产损失事故，被保险人所承担的经济赔偿责任。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">9.用于展出的展品遭受的任何损失，不在本保单承保范围内。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">10.参与文艺演出的演员不在本保单承保范围内。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">11. 文艺演出类活动一般指面对观众的现场表演活动，通常是音乐、演唱、舞蹈的表演，包括演唱会、巡回音乐会、新年音乐会等。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">12.请您如实填写投保信息</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">，根据《中华人民共和国保险法》第十六条规定：投保人故意或因重大过失未履行如实告知义务的，足以影响保险公司决定是否同意承保或者提高保险费率的，保险公司有权解除合同。投保人故意不履行如实告知义务的，保险公司对于合同解除前发生的保险事故，不承担赔偿或者给付保险金的责任，并不退还保险费。投保人因重大过失未履行如实告知义务，对保险事故的发生有严重影响的，保险公司对于合同解除前发生的保险事故，不承担赔偿或者给付保险金的责任，但应当退还保险费</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">13.</span><b><span style="font-family: 宋体; font-size: 10.5pt;">客户信息收集条款：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">本人授权华泰保险，除法律另有规定外，将本人提供给华泰保险的信息、享受华泰保险服务产生的信息（包括本保单签署之前提供和产生的信息）以及华泰保险根据本条约定查询、收集的信息，用于华泰保险及其因服务必须委托的合作伙伴为本人提供服务、推荐产品、开展市场调查与信息数据分析。本人授权华泰保险，除法律另有规定外，基于为本人提供更优质服务和产品的目的，向华泰保险因服务必要开展合作的伙伴提供、查询、收集本人的信息。为确保本人信息的安全，华泰保险及其合作伙伴对上述信息负有保密义务，并采取各种措施保证信息安全。本条款自本单证签署时生效，具有独立法律效力，不受合同成立与否及效力状态变化的影响。本条所称</font>“华泰保险”是指华泰保险集团股份有限公司及其直接或间接控股的公司，以及华泰保险集团股份有限公司直接或间接作为其单一最大股东的公司。如您不同意上述授权条款的部分或全部，可致电客服热线 4006095509 取消或变更授权。</span></p><p class="MsoNormal"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><br clear="all" style="page-break-before:always"></span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p></span><span '+tyss+'><p class="MsoNormal" align="center" style="text-align:center;"><b><span style="font-family: 宋体; font-size: 12pt;">（体育赛事类）</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">1.本产品条款备案号：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《公众责任保险（</font>2010版）-华泰财险（备-责任）[2010]主27号-注册号：H00015430912017051924441》 、 《华泰财险公众责任保险附加交叉责任条款B-注册号:C00015430922018050709711》、 《华泰财险公众责任保险附加罢工、暴乱、民众骚动及恶意破坏条款-注册号:C00015430922018050710001》、 《华泰财险公众责任保险附加火灾和爆炸责任条款(注册号:C00015430922018050709741)》、 《华泰财险公众责任保险附加急救费用条款(注册号:C00015430922018050709781)》、 《华泰财险公众责任保险附加广告招牌及装饰物责任条款(注册号:C00015430922018050709501)》。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="16" align="justify" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">2.本产品由华泰财产保险有限公司承保(以下简称“华泰财”),目前该公司在北京、上海、天津、重庆、江苏、广东、陕西、四川、云南、辽宁、浙江、河北、湖南、湖北、 安徽、山西、福建、山东、广西、河南、江西、深圳、青岛、大连、宁波、贵州、内蒙古、厦门、黑龙江、新疆设有分支机构。本保险产品的销售区域为全国（不含港澳台）。若您处于华泰财险无分支机构的地区，不影响您的理赔，客户从本平台购买,后续理赔等相关事务均可由我们协助您办理。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="16" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">3.本产品网上投保、网上支付、网上即时核保并出具保险凭证，您可拨打华泰保险公司客户服务热线：4006095509查询、验真，如对本保险产品有任何咨询、报案或投诉问题，也可拨打上述客户服务热线，我们将竭诚为您服务。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="16" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">4.本保险产品为互联网销售保险产品，为您提供电子保单，根据《中华人民共和国民法典》第四百六十九条规定，数据电文是合法的合同表现形式，</span><b><span style="font-family: 宋体; font-size: 10.5pt;">电子保单与纸质保单具有同等法律效力。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">5.本产品在网上投保申请后，最早次日零时生效。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">6.造成受害人人身伤害的，应提供</span><b><span style="font-family: 宋体; font-size: 10.5pt;">二级以上（含二级）医疗机构</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">出具的受害人的病历、诊断证明、医疗费等医疗单据。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">7.本产品项下免赔额为：财产损失500元，人身伤害无免赔。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">8.本保单不负责赔偿由于第三者自身原因(包括但不限于自身疾病、自身运动损伤、自身体质等)导致的人身伤亡或财产损失事故，被保险人所承担的经济赔偿责任。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">9.用于展出的展品遭受的任何损失，不在本保单承保范围内。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">10.参与体育赛事的运动员不在本保单承保范围内。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">11. 体育赛事类活动一般指一定规模和级别的正规体育项目比赛，包括田径、乒乓球赛、</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;&nbsp;&nbsp;<font face="宋体">足球赛、篮球赛、羽毛球赛、网球赛、自行车赛、跆拳道赛等。</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">12.请您如实填写投保信息</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">，根据《中华人民共和国保险法》第十六条规定：投保人故意或因重大过失未履行如实告知义务的，足以影响保险公司决定是否同意承保或者提高保险费率的，保险公司有权解除合同。投保人故意不履行如实告知义务的，保险公司对于合同解除前发生的保险事故，不承担赔偿或者给付保险金的责任，并不退还保险费。投保人因重大过失未履行如实告知义务，对保险事故的发生有严重影响的，保险公司对于合同解除前发生的保险事故，不承担赔偿或者给付保险金的责任，但应当退还保险费</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">13.</span><b><span style="font-family: 宋体; font-size: 10.5pt;">客户信息收集条款：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">本人授权华泰保险，除法律另有规定外，将本人提供给华泰保险的信息、享受华泰保险服务产生的信息（包括本保单签署之前提供和产生的信息）以及华泰保险根据本条约定查询、收集的信息，用于华泰保险及其因服务必须委托的合作伙伴为本人提供服务、推荐产品、开展市场调查与信息数据分析。本人授权华泰保险，除法律另有规定外，基于为本人提供更优质服务和产品的目的，向华泰保险因服务必要开展合作的伙伴提供、查询、收集本人的信息。为确保本人信息的安全，华泰保险及其合作伙伴对上述信息负有保密义务，并采取各种措施保证信息安全。本条款自本单证签署时生效，具有独立法律效力，不受合同成立与否及效力状态变化的影响。本条所称</font>“华泰保险”是指华泰保险集团股份有限公司及其直接或间接控股的公司，以及华泰保险集团股份有限公司直接或间接作为其单一最大股东的公司。如您不同意上述授权条款的部分或全部，可致电客服热线 4006095509 取消或变更授权。</span><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal"><b><span style="font-family: 宋体; font-size: 12pt;"><br clear="all" style="page-break-before:always"></span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p></span><span '+qtl+'><p class="MsoNormal" align="center" style="text-align:center;"><b><span style="font-family: 宋体; font-size: 12pt;">（其他类）</span></b><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">1.本产品条款备案号：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">《公众责任保险（</font>2010版）-华泰财险（备-责任）[2010]主27号-注册号：H00015430912017051924441》 、 《华泰财险公众责任保险附加交叉责任条款B-注册号:C00015430922018050709711》、 《华泰财险公众责任保险附加罢工、暴乱、民众骚动及恶意破坏条款-注册号:C00015430922018050710001》、 《华泰财险公众责任保险附加火灾和爆炸责任条款(注册号:C00015430922018050709741)》、 《华泰财险公众责任保险附加急救费用条款(注册号:C00015430922018050709781)》、 《华泰财险公众责任保险附加广告招牌及装饰物责任条款(注册号:C00015430922018050709501)》。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="16" align="justify" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;text-align:justify;text-justify:inter-ideograph;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">2.本产品由华泰财产保险有限公司承保(以下简称“华泰财”),目前该公司在北京、上海、天津、重庆、江苏、广东、陕西、四川、云南、辽宁、浙江、河北、湖南、湖北、 安徽、山西、福建、山东、广西、河南、江西、深圳、青岛、大连、宁波、贵州、内蒙古、厦门、黑龙江、新疆设有分支机构。本保险产品的销售区域为全国（不含港澳台）。若您处于华泰财险无分支机构的地区，不影响您的理赔，客户从本平台购买,后续理赔等相关事务均可由我们协助您办理。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="16" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">3.本产品网上投保、网上支付、网上即时核保并出具保险凭证，您可拨打华泰保险公司客户服务热线：4006095509查询、验真，如对本保险产品有任何咨询、报案或投诉问题，也可拨打上述客户服务热线，我们将竭诚为您服务。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="16" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">4.本保险产品为互联网销售保险产品，为您提供电子保单，根据《中华人民共和国民法典》第四百六十九条规定，数据电文是合法的合同表现形式，</span><b><span style="font-family: 宋体; font-size: 10.5pt;">电子保单与纸质保单具有同等法律效力。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">5.本产品在网上投保申请后，最早次日零时生效。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">6.造成受害人人身伤害的，应提供</span><b><span style="font-family: 宋体; font-size: 10.5pt;">二级以上（含二级）医疗机构</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">出具的受害人的病历、诊断证明、医疗费等医疗单据。</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">7.本产品项下免赔额为：财产损失500元，人身伤害无免赔。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">8.本保单不负责赔偿由于第三者自身原因(包括但不限于自身疾病、自身运动损伤、自身体质等)导致的人身伤亡或财产损失事故，被保险人所承担的经济赔偿责任。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">9.用于展出的展品遭受的任何损失，不在本保单承保范围内。</span></b><b><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></b></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">10.其他类活动一般指除展览展销类、文艺演出类、体育赛事类的其他所有活动，包括游园、</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;&nbsp;&nbsp;<font face="宋体">灯会、庙会、花会、焰火晚会、人才招聘会、现场开奖的彩票销售等。</font></span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><b><span style="font-family: 宋体; font-size: 10.5pt;">11.请您如实填写投保信息</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">，根据《中华人民共和国保险法》第十六条规定：投保人故意或因重大过失未履行如实告知义务的，足以影响保险公司决定是否同意承保或者提高保险费率的，保险公司有权解除合同。投保人故意不履行如实告知义务的，保险公司对于合同解除前发生的保险事故，不承担赔偿或者给付保险金的责任，并不退还保险费。投保人因重大过失未履行如实告知义务，对保险事故的发生有严重影响的，保险公司对于合同解除前发生的保险事故，不承担赔偿或者给付保险金的责任，但应当退还保险费</span><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="15" style="margin-top:7.8500pt;mso-para-margin-top:0.5000gd;mso-para-margin-left:0.0000gd;text-autospace:ideograph-numeric;mso-pagination:none;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;">12.</span><b><span style="font-family: 宋体; font-size: 10.5pt;">客户信息收集条款：</span></b><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:10.5000pt;mso-font-kerning:1.0000pt;"><font face="宋体">本人授权华泰保险，除法律另有规定外，将本人提供给华泰保险的信息、享受华泰保险服务产生的信息（包括本保单签署之前提供和产生的信息）以及华泰保险根据本条约定查询、收集的信息，用于华泰保险及其因服务必须委托的合作伙伴为本人提供服务、推荐产品、开展市场调查与信息数据分析。本人授权华泰保险，除法律另有规定外，基于为本人提供更优质服务和产品的目的，向华泰保险因服务必要开展合作的伙伴提供、查询、收集本人的信息。为确保本人信息的安全，华泰保险及其合作伙伴对上述信息负有保密义务，并采取各种措施保证信息安全。本条款自本单证签署时生效，具有独立法律效力，不受合同成立与否及效力状态变化的影响。本条所称</font>“华泰保险”是指华泰保险集团股份有限公司及其直接或间接控股的公司，以及华泰保险集团股份有限公司直接或间接作为其单一最大股东的公司。如您不同意上述授权条款的部分或全部，可致电客服热线 4006095509 取消或变更授权。</span><b><span style="font-family: 宋体; font-size: 12pt;"><o:p></o:p></span></b></p></span><p class="MsoNormal" align="center" style="mso-pagination:widow-orphan;text-align:center;"><b><span style="font-family: 宋体; font-size: 12pt;"><br clear="all" style="page-break-before:always"></span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 14pt;">责任免除</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 14pt;"><o:p></o:p></span></b></p><p class="MsoNormal" style="margin-top: 7.85pt; margin-bottom: 7.85pt; margin-left: 0pt; text-indent: 21pt;"><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">出现下列任一情形时，保险人不负责赔偿：</font> </span><span style="font-family: Calibri; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（一）对于未载入本保险单明细表而属于被保险人的或其所占有的或以其名义使用的任何牲畜、自行车、汽车、机车、各类船只、飞机、电梯、升降机、自动梯、起重机、吊车或其他升降装置；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（二）被保险人或其雇员、代表出售、赠与产品、货物、商品；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（三）有缺陷的卫生装置或任何类型的中毒或任何不洁或有害的食物或饮料；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（四）被保险人或其雇员因从事医师、律师、会计师等属专门职业性质的工作过程中所发生的赔偿责任。</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（五）被保险人从事建筑、安装或装修工程。</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;">第六条</span></b><b><span style="font-family: Georgia-Bold; color: rgb(0, 0, 0); font-size: 10.5pt;">&nbsp;</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">下列原因造成的损失、费用或责任，保险人不负责赔偿：</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（一）被保险人或其雇员或其代表的故意或重大过失行为、犯罪行为；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（二）战争、敌对行为、军事行动、武装冲突、恐怖主义活动、罢工、暴动、民众骚乱；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（三）行政行为、司法行为；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（四）自然灾害；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（五）火灾、爆炸、烟熏；（六）核反应、核辐射、核爆炸及其他放射性污染；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（七）大气、土地、水污染及其他非放射性污染；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（八）被保险人或其雇员或以被保险人名义从事相关工作者超越其经营范围或职责范围的行为；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（九）接触、使用石棉、石棉制品或含有石棉成分的物质。</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;">第七条</span></b><b><span style="font-family: Georgia-Bold; color: rgb(0, 0, 0); font-size: 10.5pt;">&nbsp;</span></b><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">对于下列损失、费用或责任，保险人不负责赔偿：</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（一）被保险人或其雇员或其代表的人身损害；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（二）被保险人或其雇员或其代表所有的或由其保管的或由其控制的财产的损失；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（三）被保险人或其雇员或其代表因经营或职责需要一直使用或占用的任何物品、土地、房屋或其他建筑的损失；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（四）为被保险人提供服务的任何人的人身损害和财产损失；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（五）被保险人或其雇员、代表因从事加工、修理、改进、承揽等工作造成委托人的人身损害和财产损失；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（六）罚款、罚金或惩罚性赔款；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（七）在合同或协议中约定的应由被保险人承担的赔偿责任，但即使没有这种合同或协议，被保险人依法仍应承担的赔偿责任不在本款责任免除范围内；</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;"><font face="宋体">（八）保险单中载明的应由被保险人自行承担的免赔额。</font> </span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-left: 0pt; text-indent: 21.1pt;"><b><span style="font-family: 宋体; color: rgb(0, 0, 0); font-size: 10.5pt;">不属于保险责任范围内的其他损失、费用和赔偿责任，保险人不负责赔偿。</span></b><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" align="center" style="text-align:center;"><span style="mso-spacerun:\'yes\';font-family:宋体;font-size:14.0000pt;mso-font-kerning:1.0000pt;">投保人声明</span><span style="mso-spacerun:\'yes\';font-family:宋体;mso-ascii-font-family:Calibri;mso-hansi-font-family:Calibri;mso-bidi-font-family:\'Times New Roman\';font-size:18.0000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-left: 0pt; text-indent: 0pt; line-height: 150%;"><!--[if !supportLists]--><span style="font-family: &quot;Times New Roman&quot;; font-size: 10.5pt;">1.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; font-size: 10.5pt;">本投保人兹声明上述各项投保内容填写属实；</span><span style="font-family: 宋体; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal" style="margin-left: 0pt; text-indent: 0pt; line-height: 150%;"><!--[if !supportLists]--><span style="font-family: &quot;Times New Roman&quot;; font-size: 10.5pt;">2.&nbsp;</span><!--[endif]--><span style="font-family: 宋体; font-size: 10.5pt;">本投保人确认购买本保险产品前，已仔细阅读并充分理解并同意接受本《投保须知》和《保险条款》、《责任免除》、《投保人声明》等，特别是其中有关责任条款及免除责任条款、退保规则、投保人和被保险人义务的内容等重大事项。</span><span style="font-family: Calibri; font-size: 10.5pt;"><o:p></o:p></span></p><p class="MsoNormal"><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;">&nbsp;</span><span style="mso-spacerun:\'yes\';font-family:Calibri;mso-fareast-font-family:宋体;mso-bidi-font-family:\'Times New Roman\';font-size:10.5000pt;mso-font-kerning:1.0000pt;"><o:p></o:p></span></p>'+starP);
        $('#closeUMsg').text('已阅读、理解并完全接受');
        $('.contacts-bottom-oth span.sureoth').removeClass('sureoth_color');
        dingshi1(10);
    }
    function goBack(){
        history.go(-1);
    }
    function dingshi(isDo){
        if(isDo > 0){
            setTimeout(function() {
                isDo --;
                $('#closeUMsg').text('已阅读并同意('+isDo+')');
                dingshi(isDo);
            },1000);
        }else{
            $('#closeUMsg').text('已阅读并同意');
            $('.contacts-bottom-oth span.sureoth').addClass('sureoth_color');
            <c:if test="${fn:contains(pd.product_code,'GZX-HT')}">
            $('#closeUMsg').attr('onclick','closeUMsg1();');
            </c:if>
            <c:if test="${!fn:contains(pd.product_code,'GZX-HT')}">
            $('#closeUMsg').attr('onclick','closeUMsg();');
            </c:if>
        }
    }
    function dingshi1(isDo){
        if(isDo > 0){
            setTimeout(function() {
                isDo --;
                $('#closeUMsg').text('已阅读、理解并完全接受('+isDo+')');
                dingshi1(isDo);
            },1000);
        }else{
            $('#closeUMsg').text('已阅读、理解并完全接受');
            $('.contacts-bottom-oth span.sureoth').addClass('sureoth_color');
            $('#closeUMsg').attr('onclick','closeUMsg();');
        }
    }
    $(function () {
        if('${empty dto.oid ? '0' : '1'}' == '0'){
            var khgzs = '<div class="contacts_modal_oth" style="width: 820px;top: 120px;"><h2 class="contacts-title">确认进入投保流程</h2><div id="_bContent" style="margin: 20px;height: 450px;overflow: auto;"><p style="margin-top: 0;margin-bottom: 10px;">尊敬的客户:</p><p style="margin-top: 0;margin-bottom: 10px;">&nbsp;&nbsp;&nbsp;您即将进入投保流程，请仔细阅读保险条款。本保险产品由【${pd.insurance_name}】承保，由上海亚太保险经纪有限公司提供销售和协助理赔等保险服务。</p><p style="margin-top: 0;margin-bottom: 10px;">投保前请您阅读名户告知书</p><p style="margin-top: 0;margin-bottom: 10px;">点击“已阅读并同意”，您在销售页面的操作将被依法记录和候存。</p><div style="width: 780px;height: 220px;overflow-y: scroll;" id="khgzs"><img style="width: 775px" src="/resources/images/客户告知书-亚太保险经纪（盖章件）.png"> </div></div><div class="contacts-bottom-oth"><span id="closeUMsg" class="sureoth">已阅读并同意(10)</span>&nbsp;<span onclick="history.go(-1)">返回</span></div></div><div class="black-mask-oth"></div>';
            $('body').append(khgzs);
            $('.contacts_modal_oth').show();
            $('.black-mask-oth').show();
            dingshi(10);
        }
        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas({sys_client_user_id: '${userdetail.oid}'},'/pc/commonApplicant/company/query',false,false,function(json){
            var str = "";
            if (json.length > 0){
                for (var i = 0; i < json.length; i++) {
                    str += '<li><p data-text="' + JSON.stringify(json[i]).replace(/"/ig,'\'') + '">' + json[i].company_name + '</p></li>';
                }
            }
            if(str != ""){
                var lxr_html = '<div class="contacts_modal"><h2 class="contacts-title">选择常用投保人<span class="title-cancel"><i class="glyphicon glyphicon-remove"></i></span></h2><ul id="userList"></ul><div class="contacts-bottom"><span class="sure">填入</span>&nbsp;<span class="cancel">取消</span></div></div><div class="black-mask"></div>';
                $('body').append(lxr_html);
                $("#userList").html(str);
                addCylxr();
            }
        });
        function addCylxr(){
            //点击联系人
            $('.contacts_modal ul li').click(function () {
                $('.contacts_modal ul li').removeClass('active');
                $(this).addClass('active');
                if(!$('.contacts-bottom .sure').hasClass('sure_color')){
                    $('.contacts-bottom span.sure').addClass('sure_color');
                }
            });
            //点击取消
            $('.contacts-bottom .cancel').click(function () {
                $('.contacts_modal').hide();
                $('.black-mask').hide();
                $('.contacts_modal ul li').removeClass('active');
            });
            $('.contacts_modal .title-cancel').click(function () {
                $('.contacts_modal').hide();
                $('.black-mask').hide();
                $('.contacts_modal ul li').removeClass('active');
            });
            //点击填入
            $('.contacts-bottom .sure').click(function () {
                if($(this).hasClass('sure_color')){
                    setTBR($('.contacts_modal ul li.active').find('p').attr('data-text'));
                    $('.contacts_modal').hide();
                    $('.black-mask').hide();
                    $('.contacts_modal ul li').removeClass('active');
                }else{
                    //没有点击选择联系人
                    // alert('请选择一个联系人！');
                }
            })
            var _html = '投保单位信息<a href="javascript:;" style="float: right;margin-right: 16px" onclick="showContractsModals(\'1\')">选择常用投保人</a>';
            var _html_bb = '被保险人信息<a href="javascript:;" style="float: right;margin-right: 16px" onclick="showContractsModals(\'2\')">选择常用投保人</a>';
            $("#cy_lxr").html(_html);
            $("#cy_lxr_bb").html(_html_bb);
        }
        function setTBR(_json){
            var _sg = $('.contacts-bottom .sure').attr('data-sg');
            var json = eval("(" + _json + ")");
            if(_sg == '1'){//设置投保人
                $("#role_namecn_0").val(json.company_name);//企业名称
                $("#role_idType_0").val(json.certificate_type);//证件类型
                if(json.certificate_code != ''){
                    var cccode = json.certificate_code;
                    if(json.certificate_type == '1'){
                        cccode = json.certificate_code.substring(0,json.certificate_code.length-1)+'-'+json.certificate_code.substring(json.certificate_code.length-1,json.certificate_code.length);
                    }
                    $("#role_organizationCode_0").val(cccode);//证件号码
                }
                $("#role_regAddress_0").val(json.address);//详细地址
                $("#regProvince").val(json.province);//省
                $("#regProvince").change();
                setTimeout(function(){
                    $("#regCity").val(json.city);//市
                    $("#regCity").change();
                    setTimeout(function(){
                        $("#regDistrict").val(json.district);//区
                    },1000);
                },1000);
                $("#role_linkName_0").val(json.user_name);//联系人
                $("#role_linkTel_0").val(json.telephone);//手机
            }else if(_sg == '2'){//设置被保险人
                $("#role_namecn_1").val(json.company_name);//企业名称
                $("#role_idType_1").val(json.certificate_type);//证件类型
                if(json.certificate_code != ''){
                    var cccode = json.certificate_code;
                    if(json.certificate_type == '1'){
                        cccode = json.certificate_code.substring(0,json.certificate_code.length-1)+'-'+json.certificate_code.substring(json.certificate_code.length-1,json.certificate_code.length);
                    }
                    $("#role_organizationCode_1").val(cccode);//证件号码
                }
                $("#regAddress_1").val(json.address);//详细地址
                $("#regProvince_1").val(json.province);//省
                $("#regProvince_1").change();
                setTimeout(function(){
                    $("#regCity_1").val(json.city);//市
                    $("#regCity_1").change();
                    setTimeout(function(){
                        $("#regDistrict_1").val(json.district);//区
                    },1000);
                },1000);
                $("#role_linkName_1").val(json.user_name);//联系人
                $("#role_linkTel_1").val(json.telephone);//手机
            }

        }

        //配套js(/resources/commonJS/con-common.js)1.表单参数，2.请求地址，3.是否同步，4.是否遮盖，5.返回处理
        setParamDatas('','/pc/tb-mail-address/${userdetail.oid}',false,false,function(json){
            if(json != undefined && json != null){
                if('${dto.oid}' == ''){
                    $('#need_insur_bill').on('click',function(){//纸质发票
                        if($(this).is(":checked")){
                            $("#receiverName").val(json.user_name);
                            $("#receiverMobile").val(json.telephone);
                            $("#receiverAddressDetail").val(json.address);
                        }
                    });
                    $('#need_receipt').on('click',function(){//电子发票
                        if($(this).is(":checked")){
                            $("#takerName").val(json.user_name);
                            $("#takerMobile").val(json.telephone);
                            $("#takerAddressDetail").val(json.address);
                        }
                    });
                    $('#is_send_einvoice').on('click',function(){//电子发票
                        if($(this).is(":checked")){
                            $("#takerName").val(json.user_name);
                            $("#takerMobile").val(json.telephone);
                            $("#takerAddressDetail").val(json.address);
                        }
                    });
                }
            }

        });
        document.onmousedown = function(ev){
            ev = ev || window.event;
            var nr = '已阅读并同意 已阅读、理解并完全接受 roleSubjectList[0].reg_address appOrganizingPath_file roleSubjectList[1].reg_address appOrganizingPath1_file 【批量上传】 report_begin_date ex_acreage inception_date check_007_for roleSubjectList[0].bank_account mailPolicyVo.taxpayer_number_invoice 暂存本页 下一步 ';
            var x=ev.clientX;
            var y=ev.clientY;
            if((ev.target.childNodes.length > 0 && ev.target.childNodes[0]!=undefined && nr.indexOf(ev.target.childNodes[0].data)!=-1) || (ev.target.name != '' && nr.indexOf(ev.target.name)!=-1) || (ev.target.id != '' && ev.target.id!=undefined && nr.indexOf(ev.target.id)!=-1 )){
                insOperation('${dto.oid}','${dto.trade_serial_number}','投保信息提交');
            }
        }
    })
    //点击弹窗出现
    function showContractsModals(_sg) {
        $('.contacts_modal').show();
        $('.black-mask').show();
        $('.contacts-bottom .sure').attr('data-sg',_sg);
    }

</script>

<script type="text/javascript">
    var baseUrl = '${pageContext.request.contextPath }';

    function openImgView(img_url){
        top.layer.open({
            type: 1,
            skin: 'layui-layer-rim', //加上边框
            area: ['420px', '350px'], //宽高
            content: '<div><img src='+baseUrl+img_url+' width="100%" /></div>'
        });
    }
    var count = 2;
    $(function(){
        changeFrameSet(0,'');//加载当前内容高度并重置iframe
        if($("#need_insur_bill").is(':checked')){
            $("#mod_1").fadeIn(1000);
        }else{
            $("#mod_1").fadeOut(1000);
        }
        if($("#need_receipt").is(':checked')){
            var _invoice_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
            $("#mod_2").fadeIn(1000);
            if(_invoice_val == "0"){//普通发票
                $("#mod_2_1").fadeIn(1000);
            }else{//专用发票,VATINVOICE
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
            }
        }else if($("#is_send_einvoice").is(':checked')){
            $('#invoice_type_2').parent().parent().hide();//隐藏增值税选项
            $("#mod_2").fadeIn(1000);
            $("#mod_2_1").fadeOut(1000);
        }else{
            $("#mod_2").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2_2").fadeOut(1000);
            $("#mod_2_3").fadeOut(1000);
        }
    });

    function save_policy_gzx(){
        //如果校验没问题
        if(customsVerify()){
            //index是遮罩层，layer.load弹出层
            var index = laySomenType(0,null,'',0);
            $.ajax({
                type: 'POST',
                //ajax动态调用pendingGMRPolicyVoPolicy方法，都会保存订单
                url:baseUrl + '/api/gzx/policy/pendingSpecialPublicDutyVoPolicy',
                //表单所有信息
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    //关闭遮罩
                    laySomenType(2,index,'',0);
                    //保存订单信息成功状态码
                    if(json.statusCode == '200') {
                        //页面跳转
                        window.location.href = baseUrl + '/api/gzx/policy/confirmPage/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                    }else{
                        //关闭遮罩
                        laySomenType(1,null,json.message,0);
                    }
                },
                //返回错误
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    //关闭遮罩
                    laySomenType(2,index,'',0);
                    //返回错误信息在遮罩层上
                    laySomenType(1,null,textStatus,0);
                }
            });
        }
    }
    function customsVerify(){
        var flag = true;
        $("input[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Date Required"){
                    if($(this).val() == ''){
                        document.getElementById(this.id).scrollIntoView();
                        laySomenType(1,null,"必填项不能为空！",0);
                        loser_has(this);
                        $(this).focus();
                        flag = false;
                        return true;
                    }else{
                        if($(this).val().length>40){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"长度超出限制！",0);
                            loser_has(this);
                            $(this).focus();
                            flag = false;
                            return true;
                        }else{
                            var _val = $(this).val();
                            var _id = this.id;
                            if(_id == 'role_doBusinessAddress_0'||_id == 'role_regAddress_0'||_id == 'regAddress_1'){
                                if(_val.length<8||_val.length>60){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"内容长度不能少于8位！",0);
                                    loser_has(this);
                                    $(this).focus();
                                    flag = false;
                                    return true;
                                }
                            }

                        }
                    }

                }
            }
            if(dataVal == "FILE Required"){//FILE Required
                if($(this).val() == ''){
                    document.getElementById(this.id+'_file-5').scrollIntoView();
                    laySomenType(1,null,"上传文件不能为空！",0);
                    $(this).focus();
                    flag = false;
                    return true;
                }
            }
        });
        if(flag){
            $("input[Data-Val]").each(function() {
                var dataVal = $(this).attr("Data-Val");
                if ($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden") {
                    if (dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required" || dataVal == "Date Required") {
                        $(this).blur();
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            flag = false;
                            return true;
                        }else{
                            if(this.id == 'start_datetime'){
                                if(Gdate.getDaysDiff($(this).val(), Gdate.curtime())<=0){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"起保日期必须大于今天！",0);
                                    flag = false;
                                    return true;
                                }
                            }
                        }
                    }
                }
            });
            if(!flag){
                laySomenType(1,null,"请正确填写相关信息！",0);
            }
        }
        if(flag){
            $("select[Data-Val]").each(function(){
                var dataVal = $(this).attr("Data-Val");
                if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                    if(dataVal == "Required"){
                        if($(this).val() == ''){
                            document.getElementById(this.id).scrollIntoView();
                            laySomenType(1,null,"必填项不能为空！",0);
                            loser_has(this);
                            $(this).focus();
                            flag = false;
                            return true;
                        }

                    }
                }
            });
            if(flag){
                $("textarea[Data-Val]").each(function(){
                    var dataVal = $(this).attr("Data-Val");
                    if($(this).attr("type") != "hidden" && $(this).attr("data-status") != "hidden"){
                        if(dataVal == "Point Required" || dataVal == "Num Required" || dataVal == "Required"){
                            if($(this).val() == ''){
                                document.getElementById(this.id).scrollIntoView();
                                laySomenType(1,null,"必填项不能为空！",0);
                                loser_has(this);
                                $(this).focus();
                                flag = false;
                                return true;
                            }else{
                                if($(this).val().length>100){
                                    document.getElementById(this.id).scrollIntoView();
                                    laySomenType(1,null,"长度超出限制(100字符)！",0);
                                    loser_has(this);
                                    $(this).focus();
                                    flag = false;
                                    return true;
                                }
                            }

                        }
                    }
                });

            }
        }
        mailSet();
        return flag;
    }
    function saveGZXInfo(){
        mailSet();
        if(isAllNull() == 1){
            var index = laySomenType(0,null,'',0);
            $.ajax({
                type: 'POST',
                url:baseUrl + '/api/gzx/policy/pendingSpecialPublicDutyVoPolicy',
                data:$("#policyInfoForm").serialize(),
                dataType:"json",
                success: function(json){
                    laySomenType(2,index,'',0);
                    laySomenType(1,null,json.message,0);
                    if(json.statusCode == '200') {
                        window.location.href = baseUrl + '/api/gzx/policy/'+json.navTabId+'?ACCESS_TOKEN=${ACCESS_TOKEN}';
                    }
                },
                error : function(XMLHttpRequest, textStatus, errorThrown) {
                    laySomenType(2,index,'',0);
                    laySomenType(1,null,textStatus,0);
                }
            });
        }else{
            laySomenType(1,null,"表单未检索到数据，请完善信息后暂存！",0);
        }
    }
    function mailSet(){
        var invoice_type_val = $("input[name='mailPolicyVo.invoice_type']:checked").val();
        if(invoice_type_val == "0"){
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
            $("#mod_2_3").find("select").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_insur_bill").is(':checked')){
            $("#mod_1").find("input").each(function(){
                $(this).val('');
            });
        }
        if(!$("#need_receipt").is(':checked')&&!$("#is_send_einvoice").is(':checked')){
            $("#mod_2_2").find("input").each(function(){
                $(this).val('');
            });
            $("#mod_2_3").find("input").each(function(){
                if($(this).attr("type") == "hidden"){
                    if($(this).val() != ''){
                        $(this).next().find(".fileinput-remove-button").click();
                    }
                }
                loser_sty(this.id);
            });
        }
    }
    function isAllNull(){
        var values, index;
        values = $("#policyInfoForm").serializeArray();
        for (index = 0; index < values.length; ++index){
            var controls=document.getElementsByName(values[index].name);
            for(var i=0;i<controls.length;i++){
                if (!$("#"+controls[i].id).is(":hidden")&&values[index].value !=''){
                    return 1;//可见输入框存在至少一个框有填数据，暂存校验通过
                }
            }
        }
        return 0;//可见输入框不存在至少一个已填数据的框，暂存校验不通过
    }
    $(function(){
        $('[data-toggle="tooltip"]').tooltip();
        $("input[id=need_insur_bill]").on("click",function(){
            if($(this).is(':checked')){
                $("#mod_1").fadeIn(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
            }else{
                $("#mod_1").fadeOut(1000);
                $("#mod_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                    $(this).val('');
                });
            }
            setTimeout("changeFrameSet(0,'')",1050);//加载当前内容高度并重置iframe
        });
        $("input[id=need_receipt]").on("click",function(){
            $("#need_receipt").attr("checked",false);//纸质发票不选中
            $("input[name='mailPolicyVo.need_receipt']").val('');
            if($(this).is(':checked')){
                $('#invoice_type_1').click();
                $('#invoice_type_2').parent().parent().hide();//隐藏增值税选项
                $("#mod_2").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                mailSet();
                $("input[name='mailPolicyVo.is_send_einvoice']").val('1');
            }else{

                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_2").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2").fadeOut(1000);
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $('#invoice_type_2').parent().parent().show();//显示增值税选项
                $("input[name='mailPolicyVo.is_send_einvoice']").val('0');
            }
            // needReceiptMethod();
            setTimeout("changeFrameSet(0,'')",1050);//加载当前内容高度并重置iframe
        });

        $("input[id=is_send_einvoice]").on("click",function(){
            $("#need_receipt").attr("checked",false);//纸质发票不选中
            $("input[name='mailPolicyVo.need_receipt']").val('');
            if($(this).is(':checked')){
                $('#invoice_type_1').click();
                $('#invoice_type_2').parent().parent().hide();//隐藏增值税选项
                $("#mod_2").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                mailSet();
                $("input[name='mailPolicyVo.is_send_einvoice']").val('1');
            }else{

                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_2").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2").fadeOut(1000);
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $('#invoice_type_2').parent().parent().show();//显示增值税选项
                $("input[name='mailPolicyVo.is_send_einvoice']").val('0');
            }
            setTimeout(changeFrameSet(0,''),1050);//加载当前内容高度并重置iframe
        });

        $("input[name='mailPolicyVo.invoice_type']").on("click",function(){
            if($(this).val() == "1"){
                $("#taxpayerNumberInvoice_1").parent().hide();
                $("#mod_2_1").fadeIn(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_3").fadeIn(1000);
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#taxpayerNumberInvoice_1").attr("data-status","hidden");
            }else{
                $("#taxpayerNumberInvoice_1").parent().show();
                $("#mod_2_3").fadeOut(1000);
                $("#mod_2_1").fadeOut(1000);
                $("#mod_2_2").fadeIn(1000);
                $("#mod_2_2").find("input").each(function(){
                    $(this).attr("data-status","");
                });
                $("#mod_2_3").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#mod_2_1").find("input").each(function(){
                    $(this).attr("data-status","hidden");
                });
                $("#taxpayerNumberInvoice_1").attr("data-status","");
            }
            setTimeout("changeFrameSet(0,'')",1050);//加载当前内容高度并重置iframe
        });

        limitAmountCalc();

        $("input[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if(dataVal == "Required"){
                var _class = $(this).attr("class");
                if(_class.indexOf('laydate-icon')!=-1){

                }else{
                    $(this).on("blur",function(){
                        var _val = $(this).val();
                        var _id = this.id;
                        if(_val == ''){
//                        被保险人信息的6个输入框匹配id字段
                            if(_id == 'role_namecn_0'){
                                laySomenType(1,null,"投保单位名称不能为空！",0);
                            } else if(_id == 'role_organizationCode_0'){
                                laySomenType(1,null,"投保单位证件号码不能为空！",0);
                            } else if(_id == 'role_totalEmp_0'){
                                laySomenType(1,null,"企业总人数不能为空！",0);
                            } else if(_id == 'role_doBusinessAddress_0'){
                                laySomenType(1,null,"办公地址不能为空！",0);
                            } else if(_id == 'role_phone_0'){
                                laySomenType(1,null,"办公电话不能为空！",0);
                            } else if(_id == 'role_linkName_0'){
                                laySomenType(1,null,"联系人姓名不能为空！",0);
                            } else if(_id == 'role_linkTel_0'){
                                laySomenType(1,null,"联系人手机不能为空！",0);
                            } else if(_id == 'role_linkEmail_0'){
                                laySomenType(1,null,"联系人email不能为空！",0);
                            } else if(_id == 'role_zipCode_0'){
                                laySomenType(1,null,"邮政编码不能为空！",0);
                            } else if(_id == 'role_regAddress_0'||_id == 'regAddress_1'){
                                laySomenType(1,null,"请填写具体地址（包含：镇、乡或街道）！",0);
                            } else if(_id == 'role_namecn_1'){
                                laySomenType(1,null,"被保险人名称不能为空！",0);
                            } else if(_id == 'role_organizationCode_1'){
                                laySomenType(1,null,"被保险人证件号码不能为空！",0);
                            } else if(_id == 'report_name'){
                                laySomenType(1,null,"活动名称不能为空！",0);
                            } else if(_id == 'report_begin_date' || _id == 'report_end_date'){
                                laySomenType(1,null,"活动时间不能为空！",0);
                            } else if(_id == 'report_local'){
                                laySomenType(1,null,"承保区域不能为空！",0);
                            } else if(_id == 'receiptHead'){
                                laySomenType(1,null,"单位名称不能为空！",0);
                            } else if(_id == 'takerName'){
                                laySomenType(1,null,"收票人姓名不能为空！",0);
                            } else if(_id == 'takerMobile'){
                                laySomenType(1,null,"收票人手机不能为空！",0);
                            } else if(_id == 'takerAddressDetail'){
                                laySomenType(1,null,"收票人地址不能为空！",0);
                            } else if(_id == 'receiverName'){
                                laySomenType(1,null,"收件人名称不能为空！",0);
                            } else if(_id == 'receiverMobile'){
                                laySomenType(1,null,"收件人手机不能为空！",0);
                            } else if(_id == 'receiverAddressDetail'){
                                laySomenType(1,null,"收件人地址不能为空！",0);
                            } else if(_id == 'taxpayerNumberInvoice_1'){
                                laySomenType(1,null,"纳税人识别号不能为空！",0);
                            } else if(_id == 'taxpayerNumberInvoice'){
                                laySomenType(1,null,"纳税人识别号不能为空！",0);
                            } else if(_id == 'registerAddressInvoice'){
                                laySomenType(1,null,"注册地址不能为空！",0);
                            } else if(_id == 'receiptPhone'){
                                laySomenType(1,null,"企业电话不能为空！",0);
                            } else if(_id == 'bankProvince'){
                                laySomenType(1,null,"开户银行省不能为空！",0);
                            } else if(_id == 'bankCity'){
                                laySomenType(1,null,"开户银行市不能为空！",0);
                            } else if(_id == 'bankInvoice'){
                                laySomenType(1,null,"开户银行不能为空！",0);
                            } else if(_id == 'bankAccountInvoice'){
                                laySomenType(1,null,"企业银行账号不能为空！",0);
                            }else {
                                laySomenType(1,null,"该项为必填字段,不能为空！",0);
                            }
                            loser_has(this);
                            return;
                            /*if(_id.indexOf('_0')!=-1){
                                loser_has(this);
                            }else{
                                loser_has_ins(this);
                            }*/
                        }else{
                            if(_val.length>32){
                                laySomenType(1,null,"超过最长限制长度！",0);
                                loser_has(this);
                                $(this).val('');
                                return;
                            }else{
                                if(_id.indexOf("role_namecn")!=-1){
                                    if(_val.length<8){
                                        laySomenType(1,null,Number(_id.split("_")[2]) == 0 ? '请填写完整的投保人名称！' : '请填写完整的被保险人名称！',0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }
                                if(_id.indexOf("role_namecn")!=-1){
                                    var isCN = new RegExp("[\\u4E00-\\u9FFF]+","g");
                                    if(isCN.test(_val)){//中文
                                        if(_val.indexOf('(') > -1 || _val.indexOf(')') > -1){
                                            laySomenType(1,null,"中文企业名称中的括号必须使用中文！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    }else{
                                        if(_val.indexOf('（') > -1 || _val.indexOf('）') > -1){
                                            laySomenType(1,null,"英文企业名称中的括号必须使用英文！",0);
                                            loser_has(this);
                                            $(this).val('');
                                        }else{
                                            success_has(this);
                                        }
                                    }
                                }else if(_id == 'role_linkName_0'||_id == 'role_linkName_1'){
                                    var isName=/[\u4E00-\u9FA5]{2,5}(?:·[\u4E00-\u9FA5]{2,8})*/;
                                    if(!isName.test(_val)||_val.length>13){
                                        laySomenType(1,null,"请输入正确姓名！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }

                                }else if(_id == 'role_phone_0'){
                                    var isPhone=/^((0\d{2,3})-)?(\d{7,8})?(-(\d{1,4}))?$/;
                                    if(!isPhone.test(_val)){
                                        laySomenType(1,null,"格式错误，请输入格式如0592-1234567！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_linkTel_0'||_id == 'role_linkTel_1'){
                                    if(checkMobile(_val) == false){
                                        laySomenType(1,null,"手机号格式不正确，格式参考13800138000！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_doBusinessAddress_0'){
                                    if(_val.length<8||_val.length>60){
                                        laySomenType(1,null,"请输入8位以上的办公详细地址！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_regAddress_0'||_id == 'role_doBusinessAddress_0'||_id == 'regAddress_1'){
                                    if(_val.length<8||_val.length>60){
                                        laySomenType(1,null,"请输入8位以上的注册地址！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_zipCode_0'){
                                    if(checkZipCode(_val) == false){
                                        laySomenType(1,null,"请输入正确的邮政编码！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id.indexOf('role_mobile')!=-1){
                                    if(checkMobile(_val) == false){
                                        laySomenType(1,null,"手机号格式不正确，格式参考13800138000！",0);
                                        loser_has_ins(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'role_linkEmail_0'){
                                    if(checkEmail(_val) == false){
                                        laySomenType(1,null,"电子邮箱格式不正确，格式参考：blbservice@baichuanxin.com！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }else{
                                        success_has(this);
                                    }
                                }else if(_id == 'taxpayerNumberInvoice_1'){
                                    if(_val.length < 21 && _val.length > 9){
                                        success_has(this);
                                    }else{
                                        laySomenType(1,null,"纳税人识别号格式有误！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }
                                }else if(_id == 'taxpayerNumberInvoice'){
                                    if(_val.length < 21 && _val.length > 9){
                                        success_has(this);
                                    }else{
                                        laySomenType(1,null,"纳税人识别号格式有误！",0);
                                        loser_has(this);
                                        $(this).val('');
                                        return;
                                    }
                                }else if(_id.indexOf('role_organizationCode')!=-1){
                                    if(_id == 'role_organizationCode_0' || _id == 'role_organizationCode_1'){
                                        var _idVal = $(this).attr("GIST-ID");
                                        var _gistVal = $("#"+_idVal).val();
                                        if(_gistVal == '1'){//组织机构代码证校验
                                            if(checkOrganizingCode(_val) == 0){
                                                laySomenType(1,null,"只能包含数字或英文大写字母，必须用连字符“-”隔开！",0);
                                                loser_has(this);
                                                $(this).val('');
                                                return;
                                            }else{
                                                success_has(this);
                                            }
                                        }else if(_gistVal == '2'){//三证合一信用代码证校验
                                            if(doValidCreditCode(_val) == 0){
                                                laySomenType(1,null,"由数字或大写英文字母组成，共18位！",0);
                                                loser_has(this);
                                                $(this).val('');
                                                return;
                                            }else{
                                                success_has(this);
                                            }
                                        }else if(_gistVal == '6'){//税务登记证校验
                                            var flass = false;
                                            var reg= /^[A-Za-z]+$/;
                                            if(_val.length == 15&&checkInt1(_val)){
                                                flass = true;
                                            }else if(_val.length == 20&&(checkInt1(_val)||(checkInt1(_val.substring(0,_val.length-1))&&reg.test(_val.substring(_val.length-1,_val.length))))){
                                                flass = true;
                                            }else{
                                                if(doValidCreditCode(_val) == 0){

                                                }else{
                                                    flass = true;
                                                }
                                            }
                                            if(flass){
                                                success_has(this);
                                            }else{
                                                laySomenType(1,null,"请输入正确的税务登记证或信用代码证代码！",0);
                                                loser_has(this);
                                                $(this).val('');
                                                return;
                                            }
                                        }else if(_gistVal == '7'){//营业执照校验
                                            var reg= /^\d{15}$/;
                                            if(!reg.test(_val)){
                                                laySomenType(1,null,"只能为15位数字！",0);
                                                loser_has(this);
                                                $(this).val('');
                                                return;
                                            }else{
                                                success_has(this);
                                            }
                                        }else{
                                            laySomenType(1,null,"请先选择证件类型！",0);
                                            loser_has(this);
                                            $(this).val('');
                                            return;
                                        }
                                    }else{//被保险人证件号校验

                                    }
                                }else{
                                    if(_id.indexOf('_0')!=-1){
                                        success_has(this);
                                    }else{
                                        success_has(this);
                                    }
                                }
                            }
                        }
                    });
                }
            }
            if(dataVal == "Date Required"){
                $(this).on("change",function(){
                    if($(this).val() == ''){
                        laySomenType(1,null,"请选择起保日期！",0);
                        loser_has(this);
                        $(this).val('');
                    }else{
                        success_has(this);
                    }
                });
            }
            if(dataVal == "Point"||dataVal == "Point Required"){
                $(this).on("keyup",function(){

                    var regm = /^[0-9]+.?[0-9]*$/;
                    if(dataVal == "Point Required"){
                        if(isNaN($(this).val())){
                            laySomenType(1,null,"请输入正确的数字格式！",0);
                            loser_has(this);
                            $(this).val('');
                        }else{
                            success_has(this);
                        }
                    }else{
                        if($(this).val() != ''){
                            if(isNaN($(this).val())){
                                laySomenType(1,null,"请输入正确的数字格式！",0);
                                loser_has(this);
                                $(this).val('');
                            }else{
                                success_has(this);
                            }
                        }else{
                            loser_sty(this);
                        }
                    }
                });
            }
            if(dataVal == "Num"||dataVal == "Num Required"){
                $(this).on("blur",function(){//ex_acreage
                    var _val = $(this).val();
                    var _id = this.id;
                    if(_id != 'people_num' && _id != 'ex_acreage'){
                        var regm = /^[0-9]*[0-9][0-9]*$/;
                        if(dataVal == "Num Required"){
                            if(!regm.test($(this).val())){
                                laySomenType(1,null,"请输入正确的数字格式！",0);
                                loser_has(this);
                                $(this).val('');
                                return;
                            }else{
                                success_has(this);
                            }
                        }else{
                            if($(this).val() != ''){
                                if(!regm.test($(this).val())){
                                    laySomenType(1,null,"请输入正确的数字格式！",0);
                                    loser_has(this);
                                    $(this).val('');
                                    return;
                                }else{
                                    success_has(this);
                                }
                            }else{
                                loser_sty(this);
                            }
                        }
                    }else{
                        if($(this).val() != ''){
                            var regm = /^[0-9]*[0-9][0-9]*$/;
                            if(!regm.test($(this).val())){
                                laySomenType(1,null,"请输入正确的数字格式！",0);
                                loser_has(this);
                                $(this).val('');
                                return;
                            }else{
                                success_has(this);
                            }
                        }
                    }

                });
            }
        });
        $("select[Data-Val]").each(function(){
            var dataVal = $(this).attr("Data-Val");
            if(dataVal == "Required") {
                $(this).on("change", function () {
                    var _val = $(this).val();
                    var _id = this.id;
                    if (_val == '') {
                        if(_id == 'role_comNature_0'){
                            laySomenType(1,null,"请选择营业性质！",0);
                        } else if(_id == 'role_idType_0' || _id == 'role_idType_1'){
                            laySomenType(1,null,"请选择证件类型！",0);
                        }  else if(_id == 'start_datetime'){
                            laySomenType(1,null,"起保日期不能为空！",0);
                        } else if(_id == 'regProvince' || _id == 'regCity' || _id == 'regDistrict' || _id == 'regProvince_1' || _id == 'regCity_1' || _id == 'regDistrict_1'){
                            laySomenType(1,null,"地址不能为空！",0);
                        }else {
                            laySomenType(1,null,"该项为必填项，不能为空！",0);
                        }
                        loser_has(this);
                        /*if (_id.indexOf('_0') != -1) {
                            loser_has(this);
                        } else {
                            loser_has_ins(this);
                        }*/
                        $(this).val('');
                    } else {
                        success_has(this);
                    }
                });
            }
        });

    });

    function changeDistrict(districtID, areaID, level, obj) {
        $("#" + districtID).empty();
        if(areaID != '') {
            $("#" + areaID).empty();
            $("#" + areaID).append("<option value=''>--请选择区县--</option>");
        }
        var code = obj.value;
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findCity.json',
            data:{"codeLevel":level,"parentCode":code},
            dataType:"json",
            async: false,
            success: function(json) {
                if(level == '2') {
                    $("#" + districtID).append("<option value=''>请选择市</option>");
                } else if(level == '3') {
                    $("#" + districtID).append("<option value=''>请选择区／县</option>");
                } else {
                    $("#" + districtID).append("<option value=''>--请选择--</option>");
                }
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + districtID).append(appendStr);
                }
            }
        });
    }
    function changeBankType(districtID, obj) {
        $("#" + districtID).empty();
        var code = obj.value;
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findBankType.json',
            data:{"area":code},
            dataType:"json",
            async: false,
            success: function(json) {
                $("#" + districtID).append("<option value=''>请选择名称</option>");
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + districtID).append(appendStr);
                }
            }
        });
    }
    function changeBankAddr(addrID, areaID, obj) {
        $("#" + addrID).empty();
        var code = obj.options[obj.selectedIndex].text;
        $.ajax({
            type: 'POST',
            url: baseUrl + '/synopsis/findBankAddr.json',
            data:{"area":$("#" + areaID).val(),"bankName":code},
            dataType:"json",
            async: false,
            success: function(json) {
                $("#" + addrID).append("<option value=''>请选择地址</option>");
                for(var i = 0; i < json.length; i++) {
                    var obj = json[i];
                    var appendStr = "<option value='" + obj.codes + "' ";
                    appendStr = appendStr + ">" + obj.named + "</option>"
                    $("#" + addrID).append(appendStr);
                }
            }
        });
    }
    function changeBankName(bankNameID, obj) {
        $("#" + bankNameID).val(obj.options[obj.selectedIndex].text);
    }

    function checkToradio(_id, type){
        var o = $("#"+_id);
        if(type=="radio"){
            o.prop('checked',true);
            if(o.val() == "1"){
                $("#arbitralInstitution").parent().show();
            }else if(o.val() == "0"){
                $("#arbitralInstitution").val('');
                $("#arbitralInstitution").parent().hide();
            }else{
                o.click();
            }
        }else if(type=="checkbox"){

            if($("#"+_id).attr('checked')) {
                o.attr('checked', false);
            } else {
                o.attr('checked', true);
            }
            o.click();
        }
    }

    function clearBase64Byinput(_el){
        var _file_id = _el.id;
        _file_id = _file_id.substring(0,_file_id.length-7);
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        $("#"+_file_id).val('');
    }
    function base64convert(_el,_file){
        var flag = false;
        var fileName = _file.name;
        var type = fileName.split(".")[fileName.split(".").length-1];

        var fileKeyName = "/policy/"+fileName;
        var _file_id = _el.attr("name").replace("_file","").trim();
        if($("#"+_file_id).val() != ''){
            ajaxFormDataDelete(_file_id);
        }
        ajaxFormDataLoad(_file,_file_id,"policy/",type);
        flag = true;
        return flag;
    }

    function ajaxFormDataLoad(file,_id,directoryName,fileType){
        var index = laySomenType(0,null,'',0);
        var _myData = new Date();
        var _times = _myData.getTime();
        var name = "/"+directoryName+_times+"."+fileType;
        var formData = new FormData();
        formData.append('file', file);
        formData.append('fileName', _times+"."+fileType);
        formData.append('directoryName', directoryName);
        var uul = baseUrl + '/file/ajaxFormDataLoad';
        $.ajax({
            type: 'POST',
            url: uul,
            dataType:"json",
            data: formData,
            processData: false,
            contentType: false,
            success: function(result){
                laySomenType(2,index,'',0);
                if(result.statusCode == '200'){
                    $("#"+_id).val(result.message);
                }else{
                    laySomenType(1,null,result.message,0);
                }
            }
        });
    }

    function ajaxFormDataDelete(_id){
        var formData = new FormData();
        formData.append('url', $("#"+_id).val());
        var uul = baseUrl + '/file/ajaxFormDataDelete';
        $.ajax({
            url: uul,
            type: 'POST',
            cache: false,
            data: formData,
            processData: false,
            contentType: false
        }).done(function(res) {
            $("#"+_id).val('');
        }).fail(function(res) {

        });
    }
    var report_begin_date = {
        elem: '#report_begin_date',
        format: 'YYYY-MM-DD',
        min: laydate.now(+1), //设定最小日期为当前日期
        max: '2099-06-16', //最大日期
        istime: true,
        istoday: false,
        choose: function(datas){
            report_end_date.min = datas; //开始日选好后，重置结束日的最小日期
            var bs = $("#buss_days").val();
            var ts = $("#tear_days").val();
            var ols = 29;
            if(bs != ''){
                ols = ols - Number(bs);
            }
            if(ts != ''){
                ols = ols - Number(ts);
            }
            report_end_date.max = dateAddOrSubDays(datas,ols,'+');
            var minDate = new Date((new Date(datas)/1000-86400*Number(bs))*1000);
            var maxDate = new Date(datas);
            _star.min = minDate.getFullYear()+"-"+(minDate.getMonth()+1)+"-"+minDate.getDate();
            _star.max = maxDate.getFullYear()+"-"+(maxDate.getMonth()+1)+"-"+maxDate.getDate();
            premiumCalc();
        }
    };

    //日期加天数的方法
    //dataStr日期字符串
    //dayCount 要增加的天数
    //sn 增加或减少的标识
    //return 增加n天后的日期字符串
    function dateAddOrSubDays(dataStr,dayCount,sn) {
        var strdate=dataStr; //日期字符串
        var isdate = new Date(strdate.replace(/-/g,"/"));  //把日期字符串转换成日期格式
        if(sn == '+'){
            isdate = new Date((isdate/1000+(86400*dayCount))*1000);  //日期加1天
        }else{
            isdate = new Date((isdate/1000-(86400*dayCount))*1000);  //日期减1天
        }
        var pdate = isdate.getFullYear()+"-"+(isdate.getMonth()+1)+"-"+(isdate.getDate());   //把日期格式转换成字符串

        return pdate;
    }

    var report_end_date = {
        elem: '#report_end_date',
        format: 'YYYY-MM-DD',
        min: '1900-01-01',
        max: '2099-06-16',
        istime: true,
        istoday: false,
        choose: function(datas){
            var ts = $("#tear_days").val();
            var minDate = new Date(datas);
            _end.min = minDate.getFullYear()+"-"+(minDate.getMonth()+1)+"-"+minDate.getDate();
            var maxDate = new Date((minDate/1000+86400*Number(ts))*1000);
            _end.max = maxDate.getFullYear()+"-"+(maxDate.getMonth()+1)+"-"+maxDate.getDate();
            premiumCalc();
        }
    };
    laydate(report_begin_date);
    laydate(report_end_date);

    function gzx_sumDate(){//预计天数计算
        var begin1 = $("#report_begin_date").val();//活动开始日期
        var end1 = $("#report_end_date").val();//活动结束日期
        var bs = $("#buss_days").val();//搭建天数
        var ts = $("#tear_days").val();//拆除天数
        var _bs = 0,_ts = 0;
        if(bs != ''){
            _bs = Number(bs);
            var oldDate = report_begin_date.min;
            var newDate = laydate.now(+(_bs+1));
            if(oldDate.substring(0,10) != newDate.substring(0,10)){//旧日期跟计算出来的日期不一致说明搭建天数改变，开始活动开始日期限制重置
                report_begin_date.min = newDate;//如果搭建天数有变，重新为活动开始时间的最小选择日期做限制
                $("#report_begin_date").val('');
                // $("#start_datetime").val('');
                // $("#end_datetime").val('');
                if(begin1 != ''){
                    laySomenType(1,null,"搭建天数已变更请重新选择活动时间！",0);
                }
                return;
            }
        }
        if(ts != ''){
            _ts = Number(ts);
        }
        if((_bs+_ts)>15){
//            $("#buss_days").val("");
//            $("#tear_days").val("");
            loser_sty('buss_days');
            loser_sty('tear_days');
            laySomenType(1,null,"拆搭建天数总和不能大于15天",0);
            return;
        }
        if ( begin1 == '' || end1 == ''){
            return;
        }
        var isBegin = new Date(begin1.split(' ')[0].replace(/-/g,"/"));
        var isEnd = new Date(end1.split(' ')[0].replace(/-/g,"/"));
        var sum = parseInt(isEnd/86400/1000) - parseInt(isBegin/86400/1000);//获取活动区间间隔天数
        var checkSum = isEnd - isBegin;
        // $("#start_datetime").val('');
        // $("#end_datetime").val('');
        if(checkSum >= 0){
            var tols = sum+_bs+_ts;//计算涵盖拆搭建天数及活动天数得出的总天数，因计算方式为开始的00时结束的23时，所以该天数比实际少1天，下方设值有补加1天
            if(tols<30){
                $("#activity_days_html").html(tols+1);
                $("#activity_days").val(tols+1);
                // $("#start_datetime").val(dateAddOrSubDays(begin1,_bs,'-'));//保险期限起期由活动开始日期减搭建天数（保险期限需要涵盖活动整个过程的总天数）
                // $("#end_datetime").val(dateAddOrSubDays(end1,_ts,'+'));//保险期限止期由活动结束日期加拆除天数
            }else{
                $("#activity_days_html").html("");
                $("#activity_days").val("");
                $("#report_begin_date").val('');
                $("#report_end_date").val('');
                laySomenType(1,null,"活动期间加上拆搭建天数不能大于30天",0);
            }

        }else{
            $("#activity_days_html").html("");
            $("#activity_days").val("");
            laySomenType(1,null,"活动截止时间不能小于活动开始时间",0);
        }
    }

    function gzx_premiumCalc(){//方案计算保费
        var activity = "${fn:split(pd.product_code, '-')[2]}";
        var activityScheme = $("input[name='activity_scheme']:checked").val();//方案：1,2,3
        var exAcreage =$('#ex_acreage').val();//场所面积
        var peopleNum =$('#policyExtrapeopleNum').val();//场所面积
        gzx_sumDate();
        var activityLocal = $("input[name='activity_local']:checked").val();//地点：露天，室内，广场
        var activityDays =$('#activity_days').val();//预计天数
        if(activity == 'ZL'){
            if(activityScheme == '1'){//1
                $("#person-amount").html("10万");
                $("#sg-amount").html("100万");
                $('#insured_amount').val("1000000");
                if(exAcreage != ''){
                    if(Number(exAcreage)>10000||Number(exAcreage)<1){
                        laySomenType(1,null,"当前方案场所面积在1~10000平米之间",0);
                        loser_has('ex_acreage');
                        $('#ex_acreage').val('');
                    }else{
                        success_has('ex_acreage');
                    }
                }
                if(activityDays != ''){
                    var ads = Number(activityDays);
                    //计算保费
                    if(activityLocal == 'INDOOR'){//室内场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("1580.00元");
                            $("#premium").val("1580");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("1890.00元");
                            $("#premium").val("1890");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("2930.00元");
                            $("#premium").val("2930");
                        }
                    }else if(activityLocal == 'OPEN'){//露天场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("1960.00元");
                            $("#premium").val("1960");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("2340.00元");
                            $("#premium").val("2340");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("3480.00元");
                            $("#premium").val("3480");
                        }
                    }else{//户外场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("2310.00元");
                            $("#premium").val("2310");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("2750.00元");
                            $("#premium").val("2750");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("3980.00元");
                            $("#premium").val("3980");
                        }
                    }
                }

            }else if(activityScheme == '2'){//2
                $("#person-amount").html("15万");
                $("#sg-amount").html("200万");
                $('#insured_amount').val("2000000");
                if(exAcreage != ''){
                    if(Number(exAcreage)>20000||Number(exAcreage)<1){
                        laySomenType(1,null,"当前方案场所面积在1~20000平米之间",0);
                        loser_has('ex_acreage');
                        $('#ex_acreage').val('');
                        //success_has(this);
                    }else{
                        success_has('ex_acreage');
                    }
                }

                if(activityDays != ''){
                    var ads = Number(activityDays);
                    //计算保费
                    if(activityLocal == 'INDOOR'){//室内场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("1960.00元");
                            $("#premium").val("1960");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("2350.00元");
                            $("#premium").val("2350");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("3620.00元");
                            $("#premium").val("3620");
                        }
                    }else if(activityLocal == 'OPEN'){//露天场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("2410.00元");
                            $("#premium").val("2410");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("2890.00元");
                            $("#premium").val("2890");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("4270.00元");
                            $("#premium").val("4270");
                        }
                    }else{//户外场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("2830.00元");
                            $("#premium").val("2830");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("3390.00元");
                            $("#premium").val("3390");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("4870.00元");
                            $("#premium").val("4870");
                        }
                    }
                }
            }else{//3
                $("#person-amount").html("20万");
                $("#sg-amount").html("500万");
                $('#insured_amount').val("5000000");
                if(exAcreage != ''){
                    if(Number(exAcreage)<1){
                        laySomenType(1,null,"请填写正确的场所面积",0);
                        loser_has('ex_acreage');
                        $('#ex_acreage').val('');
                        //success_has(this);
                    }else{
                        success_has('ex_acreage');
                    }
                }

                if(activityDays != ''){
                    var ads = Number(activityDays);
                    //计算保费
                    if(activityLocal == 'INDOOR'){//室内场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("2350.00元");
                            $("#premium").val("2350");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("2820.00元");
                            $("#premium").val("2820");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("4320.00元");
                            $("#premium").val("4320");
                        }
                    }else if(activityLocal == 'OPEN'){//露天场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("2950.00元");
                            $("#premium").val("2950");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("3440.00元");
                            $("#premium").val("3440");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("5020.00元");
                            $("#premium").val("5020");
                        }
                    }else{//户外场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("3310.00元");
                            $("#premium").val("3310");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("4010.00元");
                            $("#premium").val("4010");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("5620.00元");
                            $("#premium").val("5620");
                        }
                    }
                }
            }
        }else if(activity == 'WY'){//平安文艺演出类公众责任险
            if(activityScheme == '1'){//1
                $("#person-amount").html("10万");
                $("#sg-amount").html("100万");
                $('#insured_amount').val("1000000");
                if(peopleNum != ''){
                    if(Number(peopleNum)>10000||Number(peopleNum)<1){
                        laySomenType(1,null,"当前方案场所人数在1~10000人之间",0);
                        loser_has('policyExtrapeopleNum');
                        $('#policyExtrapeopleNum').val('');
                        //success_has(this);
                    }else{
                        success_has('policyExtrapeopleNum');
                    }
                }
                if(activityDays != ''){
                    var ads = Number(activityDays);
                    //计算保费
                    if(activityLocal == 'INDOOR'){//室内场馆
                        $("#premiumDiv").html("1850.00元");
                        $("#premium").val("1850");
                    }else if(activityLocal == 'OPEN'){//露天场馆
                        $("#premiumDiv").html("2250.00元");
                        $("#premium").val("2250");
                    }else{//户外场馆
                        $("#premiumDiv").html("2550.00元");
                        $("#premium").val("2550");
                    }
                }

            }else if(activityScheme == '2'){//2
                $("#person-amount").html("15万");
                $("#sg-amount").html("200万");
                $('#insured_amount').val("2000000");
                if(peopleNum != ''){
                    if(Number(peopleNum)>50000||Number(peopleNum)<1){
                        laySomenType(1,null,"当前方案场所面积在1~50000人之间",0);
                        loser_has('policyExtrapeopleNum');
                        $('#policyExtrapeopleNum').val('');
                        //success_has(this);
                    }else{
                        success_has('policyExtrapeopleNum');
                    }
                }

                if(activityDays != ''){
                    var ads = Number(activityDays);
                    //计算保费
                    if(activityLocal == 'INDOOR'){//室内场馆
                        $("#premiumDiv").html("2300.00元");
                        $("#premium").val("2300");
                    }else if(activityLocal == 'OPEN'){//露天场馆
                        $("#premiumDiv").html("2700.00元");
                        $("#premium").val("2700");
                    }else{//户外场馆
                        $("#premiumDiv").html("3000.00元");
                        $("#premium").val("3000");
                    }
                }
            }else{//3
                $("#person-amount").html("20万");
                $("#sg-amount").html("500万");
                $('#insured_amount').val("5000000");
                if(peopleNum != ''){
                    if(Number(peopleNum)<1){
                        laySomenType(1,null,"请填写正确的人员数量",0);
                        loser_has('policyExtrapeopleNum');
                        $('#policyExtrapeopleNum').val('');
                        //success_has(this);
                    }else{
                        success_has('policyExtrapeopleNum');
                    }
                }

                if(activityDays != ''){
                    var ads = Number(activityDays);
                    //计算保费
                    if(activityLocal == 'INDOOR'){//室内场馆
                        $("#premiumDiv").html("2860.00元");
                        $("#premium").val("2860");
                    }else if(activityLocal == 'OPEN'){//露天场馆
                        $("#premiumDiv").html("3300.00元");
                        $("#premium").val("3300");
                    }else{//户外场馆
                        $("#premiumDiv").html("3600.00元");
                        $("#premium").val("3600");
                    }
                }
            }
        }else if(activity == 'TY'){//平安体育赛事类公众责任险
            if(activityScheme == '1'){//1
                $("#person-amount").html("10万");
                $("#sg-amount").html("100万");
                $('#insured_amount').val("1000000");
                if(peopleNum != ''){
                    if(Number(peopleNum)>10000||Number(peopleNum)<1){
                        laySomenType(1,null,"当前方案场所人数在1~10000人之间",0);
                        loser_has('policyExtrapeopleNum');
                        $('#policyExtrapeopleNum').val('');
                        //success_has(this);
                    }else{
                        success_has('policyExtrapeopleNum');
                    }
                }
                if(activityDays != ''){
                    var ads = Number(activityDays);
                    //计算保费
                    if(activityLocal == 'INDOOR'){//室内场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("3950.00元");
                            $("#premium").val("3950");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("5055.00元");
                            $("#premium").val("5055");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("7230.00元");
                            $("#premium").val("7230");
                        }
                    }else if(activityLocal == 'OPEN'){//露天场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("4490.00元");
                            $("#premium").val("4490");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("5740.00元");
                            $("#premium").val("5740");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("8030.00元");
                            $("#premium").val("8030");
                        }
                    }else{//户外场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("4990.00元");
                            $("#premium").val("4990");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("6340.00元");
                            $("#premium").val("6340");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("8730.00元");
                            $("#premium").val("8730");
                        }
                    }
                }

            }else if(activityScheme == '2'){//2
                $("#person-amount").html("15万");
                $("#sg-amount").html("200万");
                $('#insured_amount').val("2000000");
                if(peopleNum != ''){
                    if(Number(peopleNum)>50000||Number(peopleNum)<1){
                        laySomenType(1,null,"当前方案场所面积在1~50000人之间",0);
                        loser_has('policyExtrapeopleNum');
                        $('#policyExtrapeopleNum').val('');
                        //success_has(this);
                    }else{
                        success_has('policyExtrapeopleNum');
                    }
                }

                if(activityDays != ''){
                    var ads = Number(activityDays);
                    //计算保费
                    if(activityLocal == 'INDOOR'){//室内场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("4850.00元");
                            $("#premium").val("4850");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("6250.00元");
                            $("#premium").val("6250");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("8750.00元");
                            $("#premium").val("8750");
                        }
                    }else if(activityLocal == 'OPEN'){//露天场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("5450.00元");
                            $("#premium").val("5450");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("6950.00元");
                            $("#premium").val("6950");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("11090.00元");
                            $("#premium").val("11090");
                        }
                    }else{//户外场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("6000.00元");
                            $("#premium").val("6000");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("7600.00元");
                            $("#premium").val("7600");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("11890.00元");
                            $("#premium").val("11890");
                        }
                    }
                }
            }else{//3
                $("#person-amount").html("20万");
                $("#sg-amount").html("500万");
                $('#insured_amount').val("5000000");
                if(peopleNum != ''){
                    if(Number(peopleNum)<1){
                        laySomenType(1,null,"请填写正确的人员数量",0);
                        loser_has('policyExtrapeopleNum');
                        $('#policyExtrapeopleNum').val('');
                        //success_has(this);
                    }else{
                        success_has('policyExtrapeopleNum');
                    }
                }

                if(activityDays != ''){
                    var ads = Number(activityDays);
                    //计算保费
                    if(activityLocal == 'INDOOR'){//室内场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("5850.00元");
                            $("#premium").val("5850");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("6940.00元");
                            $("#premium").val("6940");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("10650.00元");
                            $("#premium").val("10650");
                        }
                    }else if(activityLocal == 'OPEN'){//露天场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("6550.00元");
                            $("#premium").val("6550");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("7720.00元");
                            $("#premium").val("7720");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("11670.00元");
                            $("#premium").val("11670");
                        }
                    }else{//户外场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("7230.00元");
                            $("#premium").val("7230");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("8470.00元");
                            $("#premium").val("8470");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("12670.00元");
                            $("#premium").val("12670");
                        }
                    }
                }
            }
        }else if(activity == 'QT'){//平安其他活动类公众责任险
            if(activityScheme == '1'){//1
                $("#person-amount").html("10万");
                $("#sg-amount").html("100万");
                $('#insured_amount').val("1000000");
                if(peopleNum != ''){
                    if(Number(peopleNum)>10000||Number(peopleNum)<1){
                        laySomenType(1,null,"当前方案场所人数在1~10000人之间",0);
                        loser_has('policyExtrapeopleNum');
                        $('#policyExtrapeopleNum').val('');
                        //success_has(this);
                    }else{
                        success_has('policyExtrapeopleNum');
                    }
                }
                if(activityDays != ''){
                    var ads = Number(activityDays);
                    //计算保费
                    if(activityLocal == 'INDOOR'){//室内场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("4355.00元");
                            $("#premium").val("4355");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("5427.00元");
                            $("#premium").val("5427");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("8485.00元");
                            $("#premium").val("8485");
                        }
                    }else if(activityLocal == 'OPEN'){//露天场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("5000.00元");
                            $("#premium").val("5000");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("6300.00元");
                            $("#premium").val("6300");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("9250.00元");
                            $("#premium").val("9250");
                        }
                    }else{//户外场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("5540.00元");
                            $("#premium").val("5540");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("6950.00元");
                            $("#premium").val("6950");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("10050.00元");
                            $("#premium").val("10050");
                        }
                    }
                }

            }else if(activityScheme == '2'){//2
                $("#person-amount").html("15万");
                $("#sg-amount").html("200万");
                $('#insured_amount').val("2000000");
                if(peopleNum != ''){
                    if(Number(peopleNum)>50000||Number(peopleNum)<1){
                        laySomenType(1,null,"当前方案场所面积在1~50000人之间",0);
                        loser_has('policyExtrapeopleNum');
                        $('#policyExtrapeopleNum').val('');
                        //success_has(this);
                    }else{
                        success_has('policyExtrapeopleNum');
                    }
                }

                if(activityDays != ''){
                    var ads = Number(activityDays);
                    //计算保费
                    if(activityLocal == 'INDOOR'){//室内场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("5380.00元");
                            $("#premium").val("5380");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("6870.00元");
                            $("#premium").val("6870");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("10020.00元");
                            $("#premium").val("10020");
                        }
                    }else if(activityLocal == 'OPEN'){//露天场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("6100.00元");
                            $("#premium").val("6100");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("7670.00元");
                            $("#premium").val("7670");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("11040.00元");
                            $("#premium").val("11040");
                        }
                    }else{//户外场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("6750.00元");
                            $("#premium").val("6750");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("8370.00元");
                            $("#premium").val("8370");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("11940.00元");
                            $("#premium").val("11940");
                        }
                    }
                }
            }else{//3
                $("#person-amount").html("20万");
                $("#sg-amount").html("500万");
                $('#insured_amount').val("5000000");
                if(peopleNum != ''){
                    if(Number(peopleNum)<1){
                        laySomenType(1,null,"请填写正确的人员数量",0);
                        loser_has('policyExtrapeopleNum');
                        $('#policyExtrapeopleNum').val('');
                        //success_has(this);
                    }else{
                        success_has('policyExtrapeopleNum');
                    }
                }

                if(activityDays != ''){
                    var ads = Number(activityDays);
                    //计算保费
                    if(activityLocal == 'INDOOR'){//室内场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("6500.00元");
                            $("#premium").val("6500");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("7640.00元");
                            $("#premium").val("7640");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("12130.00元");
                            $("#premium").val("12130");
                        }
                    }else if(activityLocal == 'OPEN'){//露天场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("7300.00元");
                            $("#premium").val("7300");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("8540.00元");
                            $("#premium").val("8540");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("13270.00元");
                            $("#premium").val("13270");
                        }
                    }else{//户外场馆
                        if(ads>=1 && ads<=3){
                            $("#premiumDiv").html("8020.00元");
                            $("#premium").val("8020");
                        }else if(ads>=4 && ads<=7){
                            $("#premiumDiv").html("9340.00元");
                            $("#premium").val("9340");
                        }else if(ads>=8 && ads<=30){
                            $("#premiumDiv").html("14270.00元");
                            $("#premium").val("14270");
                        }
                    }
                }
            }
        }


    }

    function laySomenType(ty,idx,msg,times){//ty:layer类型，如0打开遮盖，1消息提示，2关闭遮盖层；win_sign:当前0内嵌或1外嵌
        if(win_sign == 0){//本站内嵌
            if(ty==0){//打开遮盖
                return layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            }else if(ty==1){//消息提示
                if(times == 0){
                    layer.msg(msg);
                }else{
                    layer.msg(msg, {time:times});
                }
            }else if(ty == 2){
                layer.close(idx);
            }
        }else{//它站内嵌
            if(ty==0){//打开遮盖
                return layer.load(0, {shade: [0.3,'#808080'],scrollbar: false});
            }else if(ty==1){//消息提示
                if(times == 0){
                    layer.msg(msg);
                }else{
                    layer.msg(msg, {time:times});
                }
            }else if(ty == 2){
                layer.close(idx);
            }
        }
        return null;
    }
    function getActivityByPss(obj){
        var thr_order_id = obj.value;
        if(thr_order_id != ''){
            $.ajax({
                type: 'POST',
                url: baseUrl + '/api/gzx/getActivityByPss/'+thr_order_id,
                dataType:"json",
                success: function(json) {
                    if(json != undefined && json != '' && json != null){
                        $("#policyExtrareportName").val(json.name);
                        $("#thr_order_id").val(json.activity_id);
                        $("#report_begin_date").val(json.startDate);
                        $("#report_end_date").val(json.endDate);
                        $("#report_local").val(json.address);
                        $("#people_num").val(json.peakNum);
                        $("input:radio[name='activity_local']").each(function(){
                            if(this.value == json.addressType){
                                $(this).attr("checked",true);
                            }
                        });
                        premiumCalc();
                        //以下为设置发票信息
                        if(json.invoiceExpressMode != '0'){
                            if(!$('#need_receipt').is(':checked')) {//没选中
                                $('#need_receipt').attr("checked",true);
                                $('#need_receipt').click();
                                // needReceiptMethod($('#need_receipt').is(':checked'));
                            }
                            var _invoice = '0';
                            if(json.invoiceExpressMode == '1'){//普票
                                _invoice = '0';
                            }
                            $("#takerName").val(json.ticketName);
                            $("#takerMobile").val(json.ticketPhone);
                            $("#takerAddressDetail").val(json.ticketAddress);
                            $("#taxpayerNumberInvoice_1").val(json.taxpayerNumberInvoice);
                            if(json.invoiceExpressMode == '2'){//专票票
                                _invoice = '1';
                                $("#taxpayerNumberInvoice_1").val('');
                                $("#taxpayerNumberInvoice").val(json.taxpayerNumberInvoice);
                                $("#receipt_head").val(json.companyNameInvoice);
                                $("#registerAddressInvoice").val(json.registerAddressInvoice);
                                $("#receiptPhone").val(json.contactPhoneInvoice);
                                $("#bankInvoice").val(json.bankInvoice);
                                $("#bankAccountInvoice").val(json.bankAccountInvoice);
                            }
                            $("input:radio[name='mailPolicyVo.invoice_type']").each(function(){
                                if(this.value == _invoice){
                                    $(this).attr("checked",true);
                                    $(this).click();
                                }
                            });

                        }else{
                            if($('#need_receipt').is(':checked')) {
                                $('#need_receipt').attr("checked",false);
                                $('#need_receipt').click();
                                // needReceiptMethod($('#need_receipt').is(':checked'));
                            }
                        }
                    }
                }
            });
        }
    }
    /*function needReceiptMethod(flag){
        if(flag){
            $("#mod_2").fadeIn(1000);
            $("#mod_2_2").fadeIn(1000);
            $("#mod_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","");
            });
        }else{
            $("#mod_2_3").fadeOut(1000);
            $("#mod_2_2").fadeOut(1000);
            $("#mod_2_1").fadeOut(1000);
            $("#mod_2").fadeOut(1000);
            $("#mod_2_3").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2_2").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2_1").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
            $("#mod_2").find("input").each(function(){
                $(this).attr("data-status","hidden");
            });
        }
    }*/

    function limitAmount(obj){
        if (obj==null ||obj.value==""){
            parent.layer.alert('限额不能为空，请仔细查看文本框的提示信息', {
                skin: 'layui-layer-molv' //样式类名
                ,closeBtn: 0
            });
            return;
        }
        var minLimit = $("#min_limit").val();
        var maxLimit = $("#max_limit").val();

        if (Number(obj.value)<minLimit||Number(obj.value)>=maxLimit) {
            parent.layer.alert('限额填写出错，请仔细查看文本框的提示信息', {
                skin: 'layui-layer-molv' //样式类名
                ,closeBtn: 0
            });
            obj.value = "";
        } else {
            premiumCalc();
        }
    }

    function natureChange(_this,_id){
        var code = _this.value;
        if(code != ""){
            $.ajax({
                type: 'POST',
                url: baseUrl + '/synopsis/natureChange.json',
                data:{"nID":code},
                dataType:"json",
                async: false,
                success: function(json) {
                    $("#" + _id).empty();
                    var t = 0;
                    $("#" + _id).append("<option value=''>-请选择-</option>");
                    for (var prop in json) {
                        if (json.hasOwnProperty(prop)) {
                            t ++;
                            var appendStr = "<option value='" + prop + "' ";
                            appendStr = appendStr + ">" + json[prop] + "</option>"
                            $("#" + _id).append(appendStr);
                        }
                    }
                    if(t > 0){
                        $("#"+_id).parent().show();
                    }else{
                        $("#"+_id).parent().hide();
                    }

                }
            });
        }else{
            $("#"+_id).parent().hide();
        }
    }

    function premiumCalc(){
        gzx_sumDate();
        var activityLocal = $("input[name='activity_local']:checked").val();
        var guest = $("input[name='guest']:checked").val();
        var danger = $("input[name='danger']:checked").val();
        var activityFireFight = $("input[name='activity_fire_fight']:checked").val();
        var startDate =$('#start_datetime').val();
        var endDate =$('#end_datetime').val();
        if(startDate == '' || endDate == ''){
            return;
        }
        var isBegin = new Date(startDate.replace(/-/g,"/"));
        var isEnd = new Date(endDate.replace(/-/g,"/"));
        var checkSum = isEnd - isBegin;
        if(checkSum < 0){
            loser_has('end_datetime');
            $('#end_datetime').val('');
            laySomenType(1,null,"终保日期不能小于起保日期",0);
            return;
        }
        var policyAmount =$('#policyAmount').val();
        var policyExtraReportActive =$('#policyExtraReportActive').val();
        var policyExtrapeopleNum =$('#policyExtrapeopleNum').val();
        $.ajax({
            type:'post',
            url: baseUrl + "/api/afr/premiumCalc",
            data:{
                'insured_amount':policyAmount,
                'activity_local':activityLocal,
                'guest':guest,
                'danger':danger,
                'activity_fire_fight':activityFireFight,
                'report_begin_date':startDate,
                'report_end_date':endDate,
                'people_num':policyExtrapeopleNum,
                'report_active':policyExtraReportActive
            },
            dateType:'json',
            success:function(json){
                if(json.statusCode =="200"){

                    $("#premiumDiv").html("￥ "+json.message);
                    $("#premium").val(json.message);

                }

            }
        });
    }

    function limitAmountCalc(){
        var policyExtrapeopleNum =$('#policyExtrapeopleNum').val();
        if(policyExtrapeopleNum==''){
            return;
        }
        $.ajax({
            type:'post',
            url: baseUrl + "/api/afr/limitAmountCalc",
            data:{
                'people_num':policyExtrapeopleNum
            },
            dateType:'json',
            success:function(json){
                if (json==''){
                    return;
                }
                var limitStr = json.split("#");
                var minLimit = limitStr[0];
                var maxLimit = limitStr[1];
                if ( minLimit != '' && maxLimit != ''){
                    $("#policyAmount").attr('placeholder','最小限额为'+minLimit+'万元，最大限额为'+maxLimit+'万元');
                    $("#amountTips").attr("title","根据预计活动参与人数，请填写"+minLimit+"万（含）至3500万（含）之间的数值");
                    $("#amountTips").attr("data-original-title","根据预计活动参与人数，请填写"+minLimit+"万（含）至3500万（含）之间的数值");
                    $("#min_limit").val(minLimit);
                    $("#max_limit").val(maxLimit);
                    // $("#policyAmount").blur();
                    $("#policyAmount").val('');

                    // $("#amountTips").addClass("hintmess");
                }

            }
        });
        // premiumCalc();
    }

    Date.prototype.pattern=function(fmt) {
        var o = {
            "M+" : this.getMonth()+1, //月份
            "d+" : this.getDate(), //日
            "h+" : this.getHours()%12 == 0 ? 12 : this.getHours()%12, //小时
            "H+" : this.getHours(), //小时
            "m+" : this.getMinutes(), //分
            "s+" : this.getSeconds(), //秒
            "q+" : Math.floor((this.getMonth()+3)/3), //季度
            "S" : this.getMilliseconds() //毫秒
        };
        var week = {
            "0" : "/u65e5",
            "1" : "/u4e00",
            "2" : "/u4e8c",
            "3" : "/u4e09",
            "4" : "/u56db",
            "5" : "/u4e94",
            "6" : "/u516d"
        };
        if(/(y+)/.test(fmt)){
            fmt=fmt.replace(RegExp.$1, (this.getFullYear()+"").substr(4 - RegExp.$1.length));
        }
        if(/(E+)/.test(fmt)){
            fmt=fmt.replace(RegExp.$1, ((RegExp.$1.length>1) ? (RegExp.$1.length>2 ? "/u661f/u671f" : "/u5468") : "")+week[this.getDay()+""]);
        }
        for(var k in o){
            if(new RegExp("("+ k +")").test(fmt)){
                fmt = fmt.replace(RegExp.$1, (RegExp.$1.length==1) ? (o[k]) : (("00"+ o[k]).substr((""+ o[k]).length)));
            }
        }
        return fmt;
    }
    var curDate = new Date();
    var date = new Date((curDate/1000+86400)*1000);
    var nextDate = date.pattern("yyyy-MM-dd");
    //日期范围限制
    var _star = {
        elem: '#start_datetime',
        format: 'YYYY-MM-DD',
        min: nextDate, //设定最小日期为当前日期
        max: '2099-06-16', //最大日期
        choose: function(datas){
            premiumCalc();
        }
    };
    var _end = {
        elem: '#end_datetime',
        format: 'YYYY-MM-DD',
        min: nextDate,
        max: '2099-06-16',
        choose: function(datas){
            premiumCalc();
        }
    };
    laydate(_star);
    laydate(_end);
</script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput.js' />"></script>
<script type="text/javascript" src="<c:url value='/resources/versions-2.0/js/fileinput/fileinput_locale_zh.js' />"></script>
</html>