package com.bcxin.ins.weixin.web;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.util.GlobalResources;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.weixin.usercenter.service.WeiXinUserCenterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;

/***/
@Controller
@RequestMapping("${weixin}/usercenter")
public class WeiXinUserCenterController extends BaseController {

	/**  用户中心 */
	private static final String INDEX = getViewPath("weixin/usercenter/weixin_index");

	/**  企业资料 */
	private static final String COMPANY = getViewPath("weixin/usercenter/weixin_user_info_company");

	/**  个人资料 */
	private static final String PERSON= getViewPath("weixin/usercenter/weixin_user_info_person");

	/**  修改密码 */
	private static final String PWD = getViewPath("weixin/usercenter/weixin_user_pwd");

	/**  分享产品 */
	private static final String SHARE = getViewPath("weixin/usercenter/weixin_user_share");


	@Autowired
	private WeiXinUserCenterService weiXinUserCenterService;


	@RequestMapping(value = "/index")
	public String login(Model model, @RequestParam Map<Object,Object> params) {

		ClientUserVo  weixinVo= (ClientUserVo) getRequest().getSession().getAttribute("wxUserVo");
		getRequest().setAttribute("weixinVo",weixinVo);
		return INDEX;
	}

	@RequestMapping(value = "/company")
	public String companyInit(Model model, @RequestParam Map<Object,Object> params ) {
		ClientUserVo  weixinVo= (ClientUserVo) getRequest().getSession().getAttribute("wxUserVo");
		getRequest().setAttribute("weixinVo",weixinVo);
		model.addAttribute("address",RegionUtils.getRegionNameByALLCode(weixinVo.getProvince(),weixinVo.getCity(),weixinVo.getDistrict()));
		return COMPANY;
	}

	@RequestMapping(value = "/person")
	public String personInit(Model model, @RequestParam Map<Object,Object> params) {
		ClientUserVo  weixinVo= (ClientUserVo) getRequest().getSession().getAttribute("wxUserVo");
		getRequest().setAttribute("weixinVo",weixinVo);
		return PERSON;
	}


	@RequestMapping(value = "/pwd")
	public String pwdInit(Model model, @RequestParam Map<Object,Object> params ) {
		ClientUserVo  weixinVo= (ClientUserVo) getRequest().getSession().getAttribute("wxUserVo");
		getRequest().setAttribute("weixinVo",weixinVo);
		return PWD;
	}


	/** 保存新密码 */
	@RequestMapping(value = "/savePwd")
	public @ResponseBody
	JSONObject savePwd(Model model, @RequestParam Map<Object,Object> params) {
		ClientUserVo  weixinVo= (ClientUserVo) getRequest().getSession().getAttribute("wxUserVo");
		return   weiXinUserCenterService.savePwd(params,getRequest(),getResponse(),weixinVo) ;
	}

	@RequestMapping(value = "/share")
	public String shareInit(Model model, @RequestParam Map<Object,Object> params ) {
		ClientUserVo  weixinVo= (ClientUserVo) getRequest().getSession().getAttribute("wxUserVo");
		getRequest().setAttribute("weixinVo",weixinVo);
		model.addAttribute("url", GlobalResources.WEB_PRO_URL+"/weixin/product/win/list?recommendCode="+weixinVo.getBusiness_support_id());
		return SHARE;
	}






}