package com.bcxin.ins.weixin.web;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.service.SysUserService;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.IpAddress;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.weixin.login.service.WeiXinLoginService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Map;
/**
 *@Author:liyongqiang
 *@Description: 登录和注册模块
 *@Date: 2017-09-18 10:41
 */
@Controller
@RequestMapping("${weixin}/login")
public class WeiXinLoginController extends BaseController {

	@Autowired
	private SysUserService sysUserService;

	@Autowired
	private WeiXinLoginService weiXinLoginService;


	/** 登录页面 */
	private static final String LOGIN_INIT = getViewPath("weixin/login/weixin_login");

	/** 注册页面 */
	private static final String REGISTER_INIT = getViewPath("weixin/login/weixin_register");

	/** 找回密码一 */
	private static final String RESET_PWD_ONE = getViewPath("weixin/login/weixin_reset_one");

	/** 找回密码二 */
	private static final String RESET_PWD_TWO = getViewPath("weixin/login/weixin_reset_two");

	/** 找回密码三 */
	private static final String RESET_PWD_THREE = getViewPath("weixin/login/weixin_reset_three");


	/** 登录初始页面 */
	@RequestMapping(value = "/init")
	public String loginInit(Model model, @RequestParam Map<Object,Object> params , HttpServletRequest req, HttpServletResponse resp) {
		return LOGIN_INIT;
	}

	/** 登录 */
	@RequestMapping(value = "/login")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_LOGIN_BLB_WC,title ="【请求】微信-登录")
	public @ResponseBody
	JSONObject login(Model model, @RequestParam Map<Object,Object> params ) {
		return   weiXinLoginService.login(params,getRequest(),getResponse()) ;
	}

	/** 注册页面 */
	@RequestMapping(value = "/register/init")
	public String registerInit(Model model, @RequestParam Map<Object,Object> params ) {
		return REGISTER_INIT;
	}


	/** 注册 */
	@RequestMapping(value = "/register")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【请求】微信-注册")
	public @ResponseBody JSONObject register(Model model, @RequestParam Map<Object,Object> params ) {
		return weiXinLoginService.register(params,getRequest(),getResponse());
	}

	/** 找回密码1 */
	@RequestMapping(value = "/resetOne")
	public String resetOne(Model model, @RequestParam Map<Object,Object> params ) {
		return RESET_PWD_ONE;
	}


	/** 找回密码2 */
	@RequestMapping(value = "/resetTwo")
	public String resetTwo(Model model, @RequestParam Map<Object,Object> params ) {
		String email = JedisUtils.get(ConstProp.YH_RESETPWDEMAIL+ IpAddress.getIpAddress(getRequest()));
//		String email =getRequest().getSession().getAttribute("resetPwdEmail")==null?null:getRequest().getSession().getAttribute("resetPwdEmail").toString();
		if(email==null){
			return RESET_PWD_ONE;
		}
		model.addAttribute("email",email);
		return RESET_PWD_TWO;
	}


	/** 找回密码3 */
	@RequestMapping(value = "/resetThree")
	public String resetThree(Model model, @RequestParam Map<Object,Object> params ) {
		String email = JedisUtils.get(ConstProp.YH_RESETPWDEMAIL+IpAddress.getIpAddress(getRequest()));
//		String email =getRequest().getSession().getAttribute("resetPwdEmail")==null?null:getRequest().getSession().getAttribute("resetPwdEmail").toString();
		if(email==null){
			return RESET_PWD_ONE;
		}
		return RESET_PWD_THREE;
	}


	/** 找回密码 */
	@RequestMapping("/resetPassword")
	@ResponseBody
	public JSONObject resetPassword(HttpServletRequest request,@RequestParam Map<Object,Object> params) {
		return weiXinLoginService.resetPassword(request,params);
	}

	/** 重置密码3 */
	@RequestMapping("/register/checkUserExist")
	@ResponseBody
	public JSONObject checkUserExist(String email, HttpServletRequest request) {
		return weiXinLoginService.checkUserExist(email,request);
	}

	/** 退出 */
	@RequestMapping(value = "/exit")
	public String exit(Model model, @RequestParam Map<Object,Object> params ) {
		getRequest().getSession().invalidate();
		return LOGIN_INIT;
	}

	/** 查询注册的验证码  是否匹配 */
	@RequestMapping("/register/checkCodeExist")
	@ResponseBody
	public JSONObject checkCode(String code) {
		return weiXinLoginService.checkCodeExist(code,getRequest());
	}

	/** 发送验证邮箱 code */
	@RequestMapping("/sendEmailCode")
	@ResponseBody
	public JSONObject sendEmailCode(String email) {
		return  weiXinLoginService.sendEmailCode(email,getRequest());
	}

	/** 发送验证手机 code */
	@RequestMapping("/sendTelPhoneCode")
	@ResponseBody
	public JSONObject sendTelPhoneCode(String tel) {
		return weiXinLoginService.sendTelPhoneCode(tel,getRequest());
	}

	/** 发送验证码 code */
	@RequestMapping("/sendCode")
	@ResponseBody
	public JSONObject sendCode(String eOrT) {
		return weiXinLoginService.sendCode(eOrT,getRequest());
	}

	/** 检查邮箱是否存在 code */
	@RequestMapping("/register/checkEmail")
	@ResponseBody
	public JSONObject checkEmail(String email) {
		return weiXinLoginService.ckeckEmail(email,getRequest());
	}

	/** 检查手机是否存在*/
	@RequestMapping("/register/checkMobile")
	@ResponseBody
	public JSONObject checkMobile( String tel) {
		return weiXinLoginService.checkMobile(tel,getRequest());
	}


}