package com.bcxin.ins.weixin.util;
import com.bcxin.mybatisplus.toolkit.StringUtils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
public class ZipUtils {

    /**
     * 使用gzip进行压缩
     */
    public static String gzip(String primStr) {
        if (primStr == null || primStr.length() == 0) {
            return primStr;
        }
        try(ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(out);) {
            gzip.write(primStr.getBytes());
            return new sun.misc.BASE64Encoder().encode(out.toByteArray());
        } catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    /**
     * <p>Description:使用gzip进行解压缩</p>
     *
     * @param compressedStr
     * @return
     */
    public static String gunzip(String compressedStr) {
        if (compressedStr == null) {
            return null;
        }
        byte[] compressed = null;
        String decompressed = null;
        try {
            compressed = new sun.misc.BASE64Decoder().decodeBuffer(compressedStr);
        } catch (IOException e) {
            e.printStackTrace();
        }
        try(ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(compressed);
            GZIPInputStream ginzip = new GZIPInputStream(in);) {
            byte[] buffer = new byte[1024];
            int offset = -1;
            while ((offset = ginzip.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            decompressed = out.toString();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return decompressed;
    }

    /**
     * 使用zip进行压缩
     *
     * @param str 压缩前的文本
     * @return 返回压缩后的文本
     */
    public static final String zip(String str) {
        if (StringUtils.isEmpty(str)) {
            return null;
        }
        byte[] compressed;
        String compressedStr = null;
        try(ByteArrayOutputStream out = new ByteArrayOutputStream();
            ZipOutputStream zout = new ZipOutputStream(out);) {
            zout.putNextEntry(new ZipEntry("0"));
            zout.write(str.getBytes());
            zout.closeEntry();
            compressed = out.toByteArray();
            compressedStr = new sun.misc.BASE64Encoder().encodeBuffer(compressed);
        } catch (IOException e) {

        }
        return compressedStr;
    }

    /**
     * 使用zip进行解压缩
     *压缩后的文本
     * @param
     * @return 解压后的字符串
     */
    public static final String unzip(String compressedStr) {
        if (compressedStr == null) {
            return null;
        }

        String decompressed = null;
        byte[] compressed;
        try {
            compressed = new sun.misc.BASE64Decoder().decodeBuffer(compressedStr);
        } catch (IOException e) {
            return decompressed;
        }
        try(ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(compressed);
            ZipInputStream zin = new ZipInputStream(in);) {
            zin.getNextEntry();
            byte[] buffer = new byte[1024];
            int offset = -1;
            while ((offset = zin.read(buffer)) != -1) {
                out.write(buffer, 0, offset);
            }
            decompressed = out.toString();
        } catch (IOException e) {

        }
        return decompressed;
    }

    public static void main(String[] args) {
        String  str="1111111111111,22222222222,222222222222,333331212122,1111111111111,22222222222,222222222222,333331212122";

        System.out.println(ZipUtils.gzip(str));
        System.out.println(ZipUtils.gunzip(ZipUtils.gzip(str)));
    }
}