package com.bcxin.ins.supply.business.impl;

import com.bcxin.ins.entity.policy_core.*;
import com.bcxin.ins.service.order.*;
import com.bcxin.ins.supply.business.BizInsureService;
import com.bcxin.ins.supply.business.entity.*;
import com.bcxin.ins.utils.CopyUtil;
import com.bcxin.mybatisplus.mapper.EntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @author hzp
 * @date 2018/06/22
 */
@Component
public class BizInsureServiceImpl implements BizInsureService {

    @Autowired
    private InsInsuranceSlipAPIService orderService;
    @Autowired
    private InsAgreementAPIService agreementService;
    @Autowired
    private InsMailPolicyAPIService mailPostService;
    @Autowired
    private InsTransactionAPIService transactionService;
    @Autowired
    private InsRoleInpolicyAPIService policyService;
    @Autowired
    private InsUnderwriteAPIService underwriteService;

    @Override
    public InsureCommonView getInsureCommonView(Map<String, Object> map, Long orderId) {
        try {
            InsureCommonView commonView = new InsureCommonView();
            InsInsuranceSlip insInsuranceSlip = orderService.selectById(orderId);
            InsureOrderView orderView=CopyUtil.copy(insInsuranceSlip,new InsureOrderView());

            InsAgreement insAgreement = agreementService.selectOne(new EntityWrapper<InsAgreement>().addFilter("ins_insurance_slip_id={0}", orderId));
            InsureAgreementView agreementView=CopyUtil.copy(insAgreement,new InsureAgreementView());

            InsTransaction insTransaction =  transactionService.selectOne(new EntityWrapper<InsTransaction>().addFilter("insurance_slip_id={0}", orderId));
            InsureTransactionView transactionView=CopyUtil.copy(insTransaction,new InsureTransactionView());

            List<InsRoleInpolicy> policys = policyService.selectList(new EntityWrapper<InsRoleInpolicy>().addFilter("insurance_slip_id={0}", orderId));
            List<InsureRoleInpolicyView> policyList=new ArrayList<InsureRoleInpolicyView>();
            for(InsRoleInpolicy p: policys){
                policyList.add(CopyUtil.copy(p,new InsureRoleInpolicyView()));
            }

            List<InsureRoleInpolicyView> benefitViewList = new ArrayList<InsureRoleInpolicyView>();
            for (InsureRoleInpolicyView tmp : policyList) {
                if (tmp.getKind().equals("1")) {
                    //投保人
                    commonView.setPolicyHolderView(tmp);
                } else {
                    //受益人
                    benefitViewList.add(tmp);
                }
            }

            commonView.setOrderView(orderView);
            commonView.setAgreementView(agreementView);
            commonView.setTransactionView(transactionView);
            commonView.setBenefitViewList(benefitViewList);

            if(orderView!=null) {
                InsUnderwrite insUnderwrite = underwriteService.selectOne(new EntityWrapper<InsUnderwrite>().addFilter("underwrite_id={0}", orderView.getUnderwrite()));
                InsureUnderwriteView underwriteView = CopyUtil.copy(insUnderwrite, new InsureUnderwriteView());
                commonView.setUnderwriteView(underwriteView);
            }

            if(agreementView!=null) {
                InsMailPolicy insMailPolicy = mailPostService.selectOne(new EntityWrapper<InsMailPolicy>().addFilter("ins_mail_policy_id={0}", agreementView.getMail_policy_id()));
                InsureMailPolicyView mailPostView = CopyUtil.copy(insMailPolicy, new InsureMailPolicyView());
                commonView.setMailPostView(mailPostView);
            }
            return commonView;
        }catch (Exception e){
            e.printStackTrace();
        }
        return null;
    }
}