package com.bcxin.ins.coninsweb.thrApi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.common.http.MessageUtils;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.preservation.InsPreservationDetailAPIService;
import com.bcxin.ins.service.preservation.InsPreservationRecordAPIService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.util.SysDictUtils;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.*;


/**
 * 我的订单
 * @author 070
 *
 */
@Controller
@RequestMapping("/api/order")
public class Order_API_Controller extends BaseController {


	@Autowired
	private PolicyService policyService;

	@Autowired
	private ProductService productService;

	@Autowired
	private InsPreservationRecordAPIService insPreservationRecordAPIService;

	@Autowired
	private InsPreservationDetailAPIService insPreservationDetailAPIService;

	private static String POLICYTOTALS = "policyTotals";
	private static String POLICYSTATUS = "policyStatus";
	private static String TYPELIST = "typeList";
	private static String NATURELIST = "natureList";

	/**
	 * 百保盾做增员，减员调用的方法
	 * 调用百联保 保全页面数据展示的接口
	 * @author zxf
	 * @return
	 */
	@RequestMapping(value = "/addPreservationView")
	public ModelAndView addPreservationView(String data) {

		ModelAndView view = new ModelAndView();

		Map<String, Object> map = new HashMap<String, Object>();
		List<InsPreservationDetailVo> list= null;
		try {
			list= MessageUtils.getList(data,InsPreservationDetailVo.class,"vo");
			String orderNo = MessageUtils.getStringValueByKey(data,"orderNo");//订单号
			String inceptionDate = MessageUtils.getStringValueByKey(data,"inceptionDate");//生效日期
			String reviseType = MessageUtils.getStringValueByKey(data,"reviseType");//保全类型
			if(DictConst.REVISE_TYPE_Z.equals(reviseType)){
				view.setViewName("/coninsweb/personalCenter/preservation/api/add_preservation_list");
			}else if(DictConst.REVISE_TYPE_J.equals(reviseType)){
				view.setViewName("/coninsweb/personalCenter/preservation/api/minus_preservation_list");
			}

			InsPreservationRecordVo iprVo = new InsPreservationRecordVo();
			iprVo.setIns_insurance_slip_id(orderNo);
			iprVo.setInception_date(inceptionDate);
			iprVo.setRevise_type(reviseType);
			iprVo.setInsPreservationDetailVoList(list);
			view.addObject("iprVo",iprVo);
			setTokenByApi(view);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return view;
	}

	/**
	 * 调用百联保 保全的接口
	 * @author lyq
	 * @return
	 */
	@RequestMapping(value = "/saveOrderPreservation")
	public void saveOrderPreservation(String data,HttpServletResponse response) {

		Map<String, Object> map = new HashMap<String, Object>();
		List<InsPreservationDetailVo> list= null;
		try {
			list= MessageUtils.getList(data,InsPreservationDetailVo.class,"vo");
			String orderNo = MessageUtils.getStringValueByKey(data,"orderNo");//订单号
			String inceptionDate = MessageUtils.getStringValueByKey(data,"inceptionDate");//生效日期
			String reviseType = MessageUtils.getStringValueByKey(data,"reviseType");//保全类型
			for(InsPreservationDetailVo ipdVo : list){
				String result = insPreservationDetailAPIService.personnelToCheck(ipdVo,reviseType);
				if(ConstProp.CODE_FAILURE.equals(result.split(ConstProp.POUND_SIGN)[0])){
					returnFailedMessage(map,result.split(ConstProp.POUND_SIGN)[1],response);
				}
				ipdVo.setRevise_type(reviseType);
			}
			map.put("vo", list);//生成密钥 当密钥的时候才能进行查询
			map.put("orderNo", orderNo);
			map.put("inceptionDate", inceptionDate);
			map.put("reviseType", reviseType);
			OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(orderNo));
			ProductVo pd = productService.getProduct(Long.parseLong(dto.getProduct_oid()));
			map.put("externalReference", dto.getExternal_reference());//保单号
			map.put("applicantName",dto.getApplicant_name());//投保人
			map.put("productName",pd.getProduct_name());//保险产品
			map.put("responsibilityVo1",pd.getResponsibilityVoList().get(0).getShow_name()+pd.getResponsibilityVoList().get(0).getFcy());
			map.put("responsibilityVo2",pd.getResponsibilityVoList().get(1).getShow_name()+pd.getResponsibilityVoList().get(1).getFcy());
			map.put("responsibilityVo3",pd.getResponsibilityVoList().get(2).getShow_name()+pd.getResponsibilityVoList().get(2).getFcy());
			//创建保全申请单，更新保全人员
			List<InsPreservationDetailVo> dList = insPreservationRecordAPIService.saveOrderPreservation(map);
			if (dList != null) {
				map.put("list",dList);
				returnSuccessStatus(map,response);
			}else{
				returnFailedStatus(map,response);
			}
		} catch (Exception e) {
			returnFailedStatus(map,response);
			e.printStackTrace();
		}
	}

	/**
	 * 调用百联保保存线下订单接口
	 * @author lyq
	 * @return
	 */
	/*@RequestMapping(value = "/saveOrderUnder")
	public void saveOrderUnder(String data,HttpServletResponse response) {


		OrderUnderVo underVo= null;
		Map<String, Object> map = new HashMap<String, Object>();
		try {
			String webType = messageUtils.getStringValueByKey(data,"webType");//网站类型
			underVo= messageUtils.getObject(data,OrderUnderVo.class,"orderVo");
			map.put("vo", underVo);//生成密钥 当密钥的时候才能进行查询
			//查询接口
			String url = GlobalResources.DISTRIBUTION_IP + "/interaction/order/saveOrderUnder";

			String result = messageUtils.doPostPackaging(url, messageUtils.packageMap(map,webType));
			String status = messageUtils.getStringValueByKey(result, "status");
			if (StringUtil.isNotEmpty(status) && "200".equals(status)) {
				returnSuccessStatus(map,response);
			}else{
				returnFailedStatus(map,response);
			}
		} catch (Exception e) {
			returnFailedStatus(map,response);
			e.printStackTrace();

		}

	}*/


	private void returnSuccessStatus(Map<String, Object> map,HttpServletResponse response) {
		map.put("status", ConstProp.CODE_SUCCESS);
		map.put("message", "Operate Success!");
		MessageUtils.returnMessage(MessageUtils.packageMap(map),response);
	}

	private void returnFailedMessage(Map<String, Object> map,String msg,HttpServletResponse response) {
		map.put("status",ConstProp.CODE_FAILURE);
		map.put("message", msg);
		MessageUtils.returnMessage(MessageUtils.packageMap(map),response);
	}

	private void returnFailedStatus(Map<String, Object> map,HttpServletResponse response) {
		map.put("status",ConstProp.CODE_FAILURE);
		map.put("message", "Operate Error!");
		MessageUtils.returnMessage(MessageUtils.packageMap(map),response);
	}

	private void returnFailedKeyStatus(Map<String, Object> map,HttpServletResponse response) {
		map.put("status","301");
		map.put("message", "Operate Error!");
		MessageUtils.returnMessage(MessageUtils.packageMap(map),response);
	}



	/**
	 * <b>我的订单-出口险 页面初始化 </b>
	 *
	 * @param policyStatus
	 * @param page
	 * @return
	 * @author ZXF
	 * @date 2016年12月29日 下午5:54:59
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("myOrder")
	public ModelAndView myOrderInit(String policyStatus, DwzPage page, HttpServletRequest request){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if (  userdetail == null ) {
			return new ModelAndView("forward:/synopsis/loseView");
		}
		ModelAndView view = new ModelAndView("/coninsweb/api/order/orderList");
		if(policyStatus == null){
			policyStatus = ConstProp.DIGIT_ONE;
		}
		page.setNumPerPage(5);
		String businessType = getRequest().getParameter("businessType");
		String keyword = getRequest().getParameter("keyword");
		String starDate = getRequest().getParameter("starDate");
		String endDate = getRequest().getParameter("endDate");
		view.addObject("businessType",businessType);
		view.addObject(ConstProp.USERDETAIL,userdetail);
		try {
			InsOrderSearchVo search = InsOrderSearchVo.build(Long.parseLong(userdetail.getOid()),policyStatus,getProductSn(userdetail.getWeb_type()), keyword, starDate, endDate, businessType,page);
			view.addObject(POLICYTOTALS,policyService.findTotalPolicyNum(search));
			view.addObject(ConstProp.ORDERLIST,policyService.findPolicyForPage(search));
		}catch (Exception e){
			e.printStackTrace();
		}
		view.addObject(POLICYSTATUS,policyStatus);
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>我的订单-各状态值汇总 </b>
	 *
	 * @param policyStatus
	 * @return
	 * @author ZXF
	 * @date 2016年12月29日 下午5:54:59
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("tabTotal")
	public ModelAndView tabTotal(String policyStatus){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		ModelAndView view = new ModelAndView("/coninsweb/api/order/tabTotal");
		if(StringUtils.isEmpty(policyStatus) || "null".equals(policyStatus)){
			policyStatus = ConstProp.DIGIT_ONE;
		}
		if(userdetail == null){
			view.addObject(POLICYTOTALS,null);
		}else{
			String businessType = getRequest().getParameter("businessType");
			String keyword = getRequest().getParameter("keyword");
			String starDate = getRequest().getParameter("starDate");
			String endDate = getRequest().getParameter("endDate");
			InsOrderSearchVo search = InsOrderSearchVo.build(Long.parseLong(userdetail.getOid()),policyStatus,getProductSn(userdetail.getWeb_type()), keyword, starDate, endDate, businessType,null);
			view.addObject(POLICYTOTALS,policyService.findTotalPolicyNum(search));
		}
		view.addObject(POLICYSTATUS,policyStatus);
		setTokenByApi(view);
		return view;
	}

	/**
	 * 搜索平台标识对应的产品下的订单
	 * @param webType 平台标识
	 * @return
	 */
	private String getProductSn(String webType){
		String result = ConstProp.BLANK_CHAR;
		if(webType.contains(ConstProp.ARS)){
			result = "TYX,GZZRX";
		}else if(webType.contains(ConstProp.PSS)){
			result = "TYX,GZX,ZZX";
		}
		return result;
	}

	@RequestMapping("getOrderListForPage")
	public ModelAndView getOrderListForPage(String policyStatus, DwzPage page, HttpServletRequest request){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if (  userdetail == null ) {
			return new ModelAndView("forward:/synopsis/loseView");
		}
		String businessType = getRequest().getParameter("businessType");
		String keyword = getRequest().getParameter("keyword");
		String starDate = getRequest().getParameter("starDate");
		String endDate = getRequest().getParameter("endDate");
		ModelAndView view = new ModelAndView("/coninsweb/api/order/orderList_table");
		InsOrderSearchVo search = InsOrderSearchVo.build(Long.parseLong(userdetail.getOid()),policyStatus,getProductSn(userdetail.getWeb_type()), keyword, starDate, endDate, businessType,page);
		view.addObject(ConstProp.ORDERLIST,policyService.findPolicyForPage(search));
		setTokenByApi(view);
		return view;
	}
	
	@RequestMapping("getOnGoingOrderListForPage")
	public ModelAndView getOnGoingOrderListForPage(String policyStatus, DwzPage page, HttpServletRequest request){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if (  userdetail == null ) {
			return new ModelAndView("forward:/synopsis/loseView");
		}
		String keyword = getRequest().getParameter("keyword");
		String starDate = getRequest().getParameter("starDate");
		String endDate = getRequest().getParameter("endDate");
		ModelAndView view = new ModelAndView("/coninsweb/api/order/orderList_table");
		InsOrderSearchVo search = InsOrderSearchVo.build(Long.parseLong(userdetail.getOid()),policyStatus,getProductSn(userdetail.getWeb_type()), keyword, starDate, endDate, "",page);
		view.addObject(ConstProp.ORDERLIST,policyService.findPolicyForPage(search));
		setTokenByApi(view);
		return view;
	}
	
	/**
	 * <b>查看订单详情 </b> 
	 * 
	 * @param order_id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月12日 上午10:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("orderDetailByOrderID/{order_id}")
	public ModelAndView exportDetailByOrderID(@PathVariable Long order_id, HttpServletRequest request){
		ModelAndView view = new ModelAndView();
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if (  userdetail == null ) {
			return new ModelAndView("forward:/synopsis/loseView");
		}
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
		if(dto == null ){
			view.addObject(ConstProp.USERDETAIL,userdetail);
			setTokenByApi(view);
			return view;
		}
		if(StringUtils.isEmpty(dto.getProduct_code())){
			view.addObject(ConstProp.DTO, dto);
			view.addObject(ConstProp.USERDETAIL,userdetail);
			setTokenByApi(view);
			return view;
		}
		ProductVo pd = productService.getProduct(Long.parseLong(dto.getProduct_oid()));
		view.addObject(ConstProp.PD,pd);
		if(ConstProp.TYX.equals(dto.getProduct_code().split(ConstProp.MINUS)[0])){
			view.setViewName("/coninsweb/api/order/gmr_policyDetail");
			GMRPolicyVo vo = policyService.accordingToOrderIDToGetGMRPolicyVo(order_id);
			if(vo != null){
				List<IdType> typeList = IdType.doList();
				List<NatureLinkage> natureList = NatureLinkage.doList();
				view.addObject(ConstProp.VO, vo);
				view.addObject(TYPELIST,typeList);
				view.addObject(NATURELIST,natureList);
				view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
				if(vo.getSpecialExhibitionVo() != null){
					view.addObject("ex_pca", RegionUtils.getRegionNameByALLCode(vo.getSpecialExhibitionVo().getEx_province(),vo.getSpecialExhibitionVo().getEx_city(),vo.getSpecialExhibitionVo().getEx_county()));
				}
			}
		}else if(ConstProp.ZZX.equals(dto.getProduct_code().split(ConstProp.MINUS)[0])){
			view.setViewName("/coninsweb/api/lote/policyDetails/lote_policy_detail");
			LOTEPolicyVo vo = policyService.accordingToOrderIDToGetLOTEPolicyVo(order_id);
			view.addObject(ConstProp.VO,vo);
			view.addObject("comTypeList", IdType.comList());
			List<NatureLinkage> natureList = NatureLinkage.doList();
			view.addObject(NATURELIST,natureList);
			view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
			view.addObject(ConstProp.REG_ROLE_1, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(), vo.getRoleSubjectList().get(1).getReg_city(), vo.getRoleSubjectList().get(1).getReg_district()));
			view.addObject("ex_pca", RegionUtils.getRegionNameByALLCode(vo.getSpecialExhibitionVo().getEx_province(),vo.getSpecialExhibitionVo().getEx_city(),vo.getSpecialExhibitionVo().getEx_county()));
		}else if(dto.getProduct_code().contains(ConstProp.GZX_PAC)){
			view.setViewName("/coninsweb/api/gzx/policyDetails/gzx_policy_detail");
			SpecialPublicDutyVo vo = policyService.accordingToOrderIDToGetSpecialPublicDutyVo(order_id);
			view.addObject("comTypeList", IdType.comList());
			List<NatureLinkage> natureList = NatureLinkage.doList();
			view.addObject(NATURELIST,natureList);
			view.addObject(ConstProp.VO,vo);
			view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
			view.addObject(ConstProp.REG_ROLE_1, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(), vo.getRoleSubjectList().get(1).getReg_city(), vo.getRoleSubjectList().get(1).getReg_district()));
		}else if(dto.getProduct_code().contains(ConstProp.GZX_HT)){
			view.setViewName("/coninsweb/api/gzx/policyDetails/gzx_policy_detail");
			SpecialPublicDutyVo vo = policyService.accordingToOrderIDToGetSpecialPublicDutyVo(order_id);
			view.addObject("comTypeList", IdType.comList());
			List<NatureLinkage> natureList = NatureLinkage.doList();
			view.addObject(NATURELIST,natureList);
			view.addObject(ConstProp.PD,productService.getProduct(Long.parseLong(dto.getProduct_oid())));
			view.addObject(ConstProp.VO,vo);
			view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
			view.addObject(ConstProp.REG_ROLE_1, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(), vo.getRoleSubjectList().get(1).getReg_city(), vo.getRoleSubjectList().get(1).getReg_district()));
		} else if(dto.getProduct_code().contains(ConstProp.GYX)){
			view.setViewName("/coninsweb/api/gyx/gyx_policyDetail");
			GYXPolicyVo vo = policyService.accordingToOrderIDToGetGYXPolicyVo(order_id);
			if(vo != null){
				List<IdType> typeList = IdType.doList();
				view.addObject(ConstProp.VO, vo);
				view.addObject(TYPELIST,typeList);
				view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(), vo.getRoleSubjectList().get(0).getReg_city(), vo.getRoleSubjectList().get(0).getReg_district()));
			}
		}else if(StringUtils.isEmpty(dto.getProduct_code()) ? false : dto.getProduct_code().contains(ConstProp.GZZRX)){
			view.setViewName("/coninsweb/api/gzzrx/policyDetails/gzzrx_policy_detail");
			view.addObject(ConstProp.PD,productService.getProduct(Long.parseLong(dto.getProduct_oid())));
			SpecialHirelingVo vo = policyService.accordingToOrderIDToGetSpecialHirelingVo(order_id);
			List<IdType> typeList = IdType.doList();
			List<NatureLinkage> natureList = NatureLinkage.doList();
			view.addObject(TYPELIST,typeList);
			view.addObject(NATURELIST,natureList);
			view.addObject(ConstProp.VO,vo);
			view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
			view.addObject(ConstProp.REG_ROLE_1, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(),vo.getRoleSubjectList().get(1).getReg_city(),vo.getRoleSubjectList().get(1).getReg_district()));
		}
		view.addObject(ConstProp.DTO, dto);
		view.addObject(ConstProp.USERDETAIL,userdetail);
		setTokenByApi(view);
		return view;
	}

	@RequestMapping("copyOrder")
	@ResponseBody
	public ResultDto copyOrder( HttpServletRequest request){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if (  userdetail == null ) {
			return new ResultDto("用户已过期，请重新登录！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		String order_id = request.getParameter(ConstProp.ORDER_ID);
		if(StringUtils.isEmpty(order_id)){
			return new ResultDto("订单ID不能为空！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(isCopyCount(userdetail.getOid())){
			return new ResultDto("复制功能使用次数已超过上限！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		return policyService.copyPolicy(Long.parseLong(order_id));
	}

	/**
	 * <b> 计算该用户复制功能触发次数是否超过限制（当前10次），如果超过返回true </b>
	 * @author ZXF
	 * @create 2021/12/01 0001 16:09
	 * @version
	 * @注意事项 </b>
	 */
	private boolean isCopyCount(String uId){
		String key = ConstProp.REDIS_HEAD_CPOY+uId;
		String countStr = JedisUtils.get(key);
		int count = 1;
		if(StringUtils.isNotEmpty(countStr)){
			count = Integer.parseInt(countStr);
			//每天限制订单最多复制10次，超过次数只能等第二天重置
			if(count == 10){
				return true;
			}
			count ++;
		}
		JedisUtils.set(key,count+"",ConstProp.ONE_DAY_TIMEOUT_SECONDS);
		return false;
	}

	@RequestMapping("deleteOrder")
	@ResponseBody
	public JSONObject deleteOrder( HttpServletRequest request){
		JSONObject json = new JSONObject();
		String message  = ConstProp.BLANK_CHAR;
		String status =ConstProp.CODE_FAILURE;
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if (  userdetail == null ) {
			message="用户已过期，请重新登录！";
		}else{
			String order_id = request.getParameter(ConstProp.ORDER_ID);
			OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
			if(!dto.getPolicy_status().equals(DictConst.ORDER_STATUS_TBZ) && !dto.getPolicy_status().equals(DictConst.ORDER_STATUS_DZF)){
				message = "状态为："+ SysDictUtils.getDictLabel(dto.getPolicy_status(), "order_status", ConstProp.BLANK_CHAR) + " 订单无法删除！";
			}else{
				dto.setPolicy_status(DictConst.ORDER_STATUS_YFQ);
				String orderID = policyService.updateOrderFormStatus(dto);
				if(StringUtils.isNotEmpty(orderID)){
					message="订单删除成功！";
					status=ConstProp.CODE_SUCCESS;
				}else{
					message="订单删除失败！";
				}
			}
		}
		json.put("message", message);
		json.put("status", status);
		return json;
	}


	@RequestMapping("/policyDal")
	public void policyDal(String data,HttpServletResponse response) throws IOException{
		Map<String,Object> map = new HashMap<String,Object>();
		String order_id = MessageUtils.getStringValueByKey(data, ConstProp.ORDER_ID);
		if(StringUtils.isNotEmpty(order_id)){
			OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(Long.parseLong(order_id));
			if(dto != null){
				map.put(ConstProp.ORDER_ID,dto.getOid());//订单id
				map.put("product_name",dto.getProduct_name());//产品名称
				map.put("insurance_ame",dto.getInsurance_name());//保险公司名称
				map.put("inception_date",dto.getInception_date());//生效日期
				map.put("planned_end_date",dto.getPlanned_end_date());//失效日期
				map.put("gross_premium",dto.getGross_premium());//保费
				map.put("applicant_name",dto.getApplicant_name());//投保人名称
				GMRPolicyVo vo = policyService.accordingToOrderIDToGetGMRPolicyVo(Long.parseLong(order_id));
				if(vo != null){
					if(vo.getRoleSubjectList().size()>1){
						map.put("ins_count",String.valueOf(vo.getRoleSubjectList().size()-1));//被保险人数量
					}
				}
				returnSuccessStatus(map);
			}else{
				returnFailedStatus(map);
			}
		}else{
			returnFailedStatus(map);
		}
		MessageUtils.returnMessage(MessageUtils.packageMap(map), response);
	}

	private void returnSuccessStatus(Map<String,Object> map){
		map.put("status", ConstProp.CODE_SUCCESS);
		map.put("message", "Operate Success!");
	}

	private void returnFailedStatus(Map<String,Object> map){
		map.put("status", ConstProp.CODE_FAILURE);
		map.put("message", "Operate Error!");
	}
}
