package com.bcxin.ins.coninsweb.report.controller.app;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.Auth;
import com.bcxin.ins.core.service.MyTposThrUserService;
import com.bcxin.ins.dto.Result;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.order.InsCommonReportAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.vo.*;
import com.bcxin.ins.vo.report_pac.InsCommonReportVo;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;

/**
 * saas-app的报案理赔控制器
 * @author zxf
 *
 */
@Controller
@RequestMapping("/app/report")
public class InsCommonReport_APP_Controller extends BaseController {

	@Autowired
	private InsCommonReportAPIService insCommonReportAPIService;

	@Autowired
	private PolicyService policyService;

	@Autowired
	private ClientUserService clientUserService;

	@Autowired
	private MyTposThrUserService myTposThrUserService;

	/**
	 * <b>第三方平台用户调用接口,token验证通过后，判断是否存在，存在：设置登录状态，不存在：新增用户并设置登录状态</b>
	 * @param token
	 * @param party 平台标识
	 * @return
	 * @author ZXF
	 * @date 2017年03月13日 下午1:40:41
	 * @注意事项 </b>
	 * <b>
	 */
	private Result checkLogin(String party, String token){
		Auth auth = myTposThrUserService.isAuth(party,token,getRequest());
		//白名单通过
		if(auth.isSuccess()){
			JSONObject json = (JSONObject)auth.getData();
			if(clientUserService.saveClientUserVo(party
					,json.get("login_name") != null ? String.valueOf(json.get("login_name")) : String.valueOf(json.get("user_id"))
					,String.valueOf(json.get("user_id")))){
				if(party.contains(ConstProp.SAAS)){
					return Result.success("登录成功!");
				}else{
					return Result.fail("无效来源！");
				}
			}else{
				return Result.fail("登录失败！");
			}
		}else{
			return Result.fail(auth.getMsg());
		}
	}

	/**
	 * <b> 报案列表 </b>
	 * @param saasIdCardNo saas的人员身份证
	 * @param status 理赔状态：0.待提交；1.审核中；2.已结案
	 * @author ZXF
	 * @create 2020/06/19 0019 14:34
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("reportList")
	@ResponseBody
	public Result reportList() throws UnsupportedEncodingException {
		String party = getRequest().getParameter("party");
		String token = getRequest().getParameter("token");
		if(StringUtils.isEmpty(party)||StringUtils.isEmpty(token)){
			return Result.fail("平台信息不能为空！");
		}
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail==null) {
			Result result = checkLogin(party, token);
			if (Result.ERROR.equals(result.getRetType())) {
				return result;
			}
		}
		String saasIdCardNo = getRequest().getParameter("saasIdCardNo");
		String status = getRequest().getParameter("status");
		if(StringUtils.isEmpty(saasIdCardNo)||StringUtils.isEmpty(status)){
			return Result.fail("参数不能为空");
		}
		List<Map<String, String>> list = insCommonReportAPIService.selectReportListByIdCardNo(status, saasIdCardNo);
		return Result.success(Result.SUCCESS_MSG,list);
	}
	
	/**
	 * <b>查看报案信息详情 </b>
	 * 
	 * @param report_id
	 * @return
	 * @author ZXF 
	 * @date 2017年1月12日 上午10:39:35
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("getReportById/{report_id}")
	@ResponseBody
	public Result getReportById(@PathVariable Long report_id){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail==null){
			String party = getRequest().getParameter("party");
			String token = getRequest().getParameter("token");
			if(StringUtils.isEmpty(party)||StringUtils.isEmpty(token)){
				return Result.fail("平台信息不能为空！");
			}
			Result result = checkLogin(party, token);
			if(Result.ERROR.equals(result.getRetType())){
				return result;
			}
		}
		return Result.success(Result.SUCCESS_MSG,insCommonReportAPIService.getInsCommonReportVoInfoById(report_id,0));
	}

	/**
	 * <b> 提交报案信息 </b>
	 * @author ZXF
	 * @create 2019/11/29 0029 14:11
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/saveReport")
	@ResponseBody
	public Result saveReport(InsCommonReportVo vo) {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail==null){
			String party = getRequest().getParameter("party");
			String token = getRequest().getParameter("token");
			if(StringUtils.isEmpty(party)||StringUtils.isEmpty(token)){
				return Result.fail("平台信息不能为空！");
			}
			Result result = checkLogin(party, token);
			if(Result.ERROR.equals(result.getRetType())){
				return result;
			}
			userdetail = UserSupportUtil.getSessionUser();
		}
		vo.setSaas_com_id(userdetail.getWeb_id());
		ResultDto dto = insCommonReportAPIService.saveInsCommonReportByApp(vo,Long.parseLong(userdetail.getOid()));
		if(ConstProp.CODE_FAILURE.equals(dto.getStatusCode())){
			return Result.fail(dto.getMessage());
		}
		return Result.success(Result.SUCCESS_MSG,dto.getNavTabId());
	}

	/**
	 * <b> 报案理流程附件补传 </b>
	 * @author ZXF
	 * @create 2019/11/29 0029 14:11
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/saveUploadFile")
	@ResponseBody
	public Result saveUploadFile(InsCommonReportVo vo) {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail==null){
			String party = getRequest().getParameter("party");
			String token = getRequest().getParameter("token");
			if(StringUtils.isEmpty(party)||StringUtils.isEmpty(token)){
				return Result.fail("平台信息不能为空！");
			}
			Result result = checkLogin(party, token);
			if(Result.ERROR.equals(result.getRetType())){
				return result;
			}
		}
		ResultDto dto = insCommonReportAPIService.saveUploadFile(vo);
		if(ConstProp.CODE_FAILURE.equals(dto.getStatusCode())){
			return Result.fail(dto.getMessage());
		}
		return Result.success(Result.SUCCESS_MSG);
	}

	/**
	 * <b> 通过图片地址上传到平安ibos平台，激活fileId并返回 </b>
	 * @author ZXF
	 * @create 2019/11/29 0029 14:11
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/getFileIdByPath")
	@ResponseBody
	public Result getFileIdByPath() {
		logger.info("getFileIdByPath:star");
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail==null){
			String party = getRequest().getParameter("party");
			String token = getRequest().getParameter("token");
			if(StringUtils.isEmpty(party)||StringUtils.isEmpty(token)){
				return Result.fail("平台信息不能为空！");
			}
			Result result = checkLogin(party, token);
			if(Result.ERROR.equals(result.getRetType())){
				return result;
			}
		}
		logger.info("getFileIdByPath:auth success");
		String path = getRequest().getParameter("path");
		String sign = getRequest().getParameter("sign");
		if(StringUtils.isEmpty(path)){
			return Result.fail("path不能为空！");
		}
		if(StringUtils.isEmpty(sign)){
			return Result.fail("sign不能为空！");
		}
		path = path.replaceAll("%3A",":").replaceAll("%2F","/");
		String fileId = insCommonReportAPIService.getFileIdByPath(path, sign);
		logger.info("getFileIdByPath:fileId checked");
		if(StringUtils.isEmpty(fileId)){
			return Result.fail("fileId获取失败！");
		}
		logger.info("getFileIdByPath:end");
		return Result.success(Result.SUCCESS_MSG,fileId);
	}

	/**
	 * <b> 根据身份证查询有过参与投保的保单记录 </b>
	 * @author ZXF
	 * @create 2020/06/29 0029 18:06
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/findPolicyByIdCard")
	@ResponseBody
	public Result findPolicyByIdCard() {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail==null){
			String party = getRequest().getParameter("party");
			String token = getRequest().getParameter("token");
			if(StringUtils.isEmpty(party)||StringUtils.isEmpty(token)){
				return Result.fail("平台信息不能为空！");
			}
			Result result = checkLogin(party, token);
			if(Result.ERROR.equals(result.getRetType())){
				return result;
			}
		}
		String saasIdCardNo = getRequest().getParameter("saasIdCardNo");
		if(StringUtils.isEmpty(saasIdCardNo)){
			return Result.fail("idCardNo不能为空！");
		}
		List<Map<String, Object>> list = policyService.orderList(saasIdCardNo);
		if(list.size()==0){
			return Result.fail("无保单！");
		}
		return Result.success(Result.SUCCESS_MSG,list);
	}
}
