package com.bcxin.ins.coninsweb.order.stragegy.order.impl;

import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyStrategy;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyType;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;

/**
 * 不同产品投保页面表单数据提交更新数据库策略
 * @author zxf
 * @date 2018/08/30
 * @说明 策略方案提议及案例提供人：hzp 2018/06/12
 */
@Component
@OrderSupplyType(type = OrderSupplyType.OrderSupplyTypeEnum.PENDING_POLICY)
public class StragegyPendingPolicy implements OrderSupplyStrategy {

    @Autowired
    private PolicyService policyService;

    @Autowired
    private ProductService productService;

    /**
     * 产品id
     */
    private final static String PRODUCT_ID = "product_id";
    /**
     * 分页（1,2,3）场景：如诉讼产品投保页面分3页，每页提交都对应相应业务处理，当碰到需要分成多个页面就需要传该字段用于下列业务区分
     */
    private final static String PAGE = "page";

    @Override
    public ModelAndView policyInitService(HttpServletRequest request, Long product_id) {
        return null;
    }

    @Override
    public ModelAndView getPolicyService(Long order_id, int page) {
        return null;
    }

    @Override
    public ResultDto pendingPolicyService(Object object, HttpServletRequest request) {
        String product_id = request.getParameter(PRODUCT_ID);
        String recommendCode = request.getParameter(ConstProp.RECOMMENDCODE);
        ProductVo pd = productService.getProduct(Long.parseLong(product_id));
        if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.XYX_DQCK)){
            String spage = request.getParameter(PAGE);
            if(StringUtils.isEmpty(spage)){
                return new ResultDto("页面未指定操作参数！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
            int page = Integer.parseInt(spage);
            if(page == 1){
                return policyService.pendingCommonExportVo_1Policy((CommonExportVo_1)object, recommendCode);
            }else if(page == 2){
                return policyService.pendingCommonExportVo_2Policy((CommonExportVo_2)object);
            }else if(page == 3){
                return policyService.pendingCommonExportVo_3Policy((CommonExportVo_3)object);
            }else{
                return new ResultDto("页面指定操作参数错误！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.XYX_XWCK)){
            return policyService.pendingMicroExportPolicy((MicroExportVo)object, recommendCode);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.BZX_SSBQ)){
            String spage = request.getParameter(PAGE);
            if(StringUtils.isEmpty(spage)){
                return new ResultDto("页面未指定操作参数！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
            int page = Integer.parseInt(spage);
            if(page == 1){
                return policyService.pendingSpecialLitigation_1VoPolicy((SpecialLitigationVo_1)object, recommendCode);
            }else if(page == 2){
                return policyService.pendingSpecialLitigation_2VoPolicy((SpecialLitigationVo_2)object);
            }else if(page == 3){
                return policyService.pendingSpecialLitigation_3VoPolicy((SpecialLitigationVo_3)object);
            }else{
                return new ResultDto("页面指定操作参数错误！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZX)){
            return policyService.pendingSpecialPublicDutyVoPolicy((SpecialPublicDutyVo)object, recommendCode);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.TYX)){
            return policyService.pendingGMRPolicyVoPolicy((GMRPolicyVo)object, recommendCode);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GZZRX)){
            return policyService.pendingSpecialHirelingVoPolicy((SpecialHirelingVo)object, recommendCode);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.ZZX)){
            return policyService.pendingLOTEPolicyVoPolicy((LOTEPolicyVo)object, recommendCode);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GCTB)){
            return policyService.pendingSpecialBidPolicy((SpecialBidVo)object, recommendCode);
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GCLY)){
            String spage = request.getParameter(PAGE);
            if(StringUtils.isEmpty(spage)){
                return new ResultDto("页面未指定操作参数！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
            int page = Integer.parseInt(spage);
            if(page == 1){
                return policyService.pendingSpecialPerformance_1VoPolicy((SpecialPerformanceVo_1)object, recommendCode);
            }else if(page == 2){
                return policyService.pendingSpecialPerformance_2VoPolicy((SpecialPerformanceVo_2)object);
            }else if(page == 3){
                return policyService.pendingSpecialPerformance_3VoPolicy((SpecialPerformanceVo_3)object);
            }else{
                return new ResultDto("页面指定操作参数错误！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
        }else if(StringUtils.isEmpty(pd.getProduct_code()) ? false : pd.getProduct_code().contains(ConstProp.GYX)){
            return policyService.pendingGYXPolicyVoPolicy((GYXPolicyVo)object, recommendCode);
        }
        return null;
    }

    @Override
    public ModelAndView confirmPolicyService(Long order_id) {
        return null;
    }

    @Override
    public ModelAndView paymentRequestService(Long order_id) {
        return null;
    }

    @Override
    public ResultDto underwritingRequestService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto insuranceCalculationService(HttpServletRequest request) {
        return null;
    }

    @Override
    public ResultDto getElectronicInsuranceService(Long order_id) {
        return null;
    }

}
