package com.bcxin.ins.coninsweb.order.stragegy.order;

import com.bcxin.ins.vo.ResultDto;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 投保流程专属策略
 * @author hzp
 * @date 2018/06/12
 */
public interface OrderSupplyStrategy {

    /*初始化订单页面业务处理，统一根据 产品id获取产品类型来区别各个产品下单对应的业务以及跳转页面*/
    ModelAndView policyInitService(HttpServletRequest request, Long product_id);

    /*根据订单id查询对应的页面渲染数据，用于继续投保、返回修改等业务调用*/
    ModelAndView getPolicyService(Long order_id, int page);

    /*订单信息更新业务操作*/
    ResultDto pendingPolicyService(Object object, HttpServletRequest request);

    /*根据订单id查询对应的页面渲染数据，用于订单确认等业务调用*/
    ModelAndView confirmPolicyService(Long order_id);

    /*根据订单id请求加载订单支付相关业务*/
    ModelAndView paymentRequestService(Long order_id);

    /*订单核保接口操作相关业务*/
    ResultDto underwritingRequestService(HttpServletRequest request);

    /*保费计算操作相关业务*/
    ResultDto insuranceCalculationService(HttpServletRequest request);

    /*获取电子保单操作相关业务*/
    ResultDto getElectronicInsuranceService(Long order_id);
}
