package com.bcxin.ins.coninsweb.order.controller.export.web;

import com.bcxin.ins.service.order.InsTopBuyersAPIService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.util.Constant;
import com.bcxin.ins.util.DSUtil;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.TopBuyersVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * <b> 信用额度管理首页 （接口--）</b>
 */
// @RestController
@Controller
@RequestMapping(value = "/exports")
public class InsExportAPIController extends BaseController {
    @Autowired
    private InsTopBuyersAPIService insTopBuyersService;


    @RequestMapping("/index")
    public ModelAndView policyChange(HttpServletRequest request, ModelMap model) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/index");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (  userdetail == null ) {
            return new ModelAndView(DSUtil.operation()+"/exports/index");
        }
        view.addObject(ConstProp.USERDETAIL,userdetail);
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("userId",userdetail.getOid());
//		map.put("type", 1);//企业短期

        try {
            Long wStatus = insTopBuyersService.getInsTopBuyerPifu(Long.parseLong(userdetail.getOid()));
            Long pStatus = insTopBuyersService.getInsTopBuyerWPifu(Long.parseLong(userdetail.getOid()));
            view.addObject("wpf",wStatus);
            view.addObject("pf",pStatus);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return view;
    }



    /**
     * <b>限额批复状态 --未批复</b>
     *
     * @param request
     * @param model
     * @return
     * @author liyongqiang
     * @date 2016年12月23日 下午4:11:09
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("/findLimitAmountNo")
    public ModelAndView findLimitAmountNo(HttpServletRequest request, ModelMap model,DwzPage  page) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/index/findLimitAmountNo");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (  userdetail == null ) {
            return new ModelAndView(DSUtil.operation()+"/exports/findLimitAmountNo");
        }
        view.addObject(ConstProp.USERDETAIL,userdetail);
        page.setNumPerPage(10);
        List<TopBuyersVo> blist = insTopBuyersService.findPifuList(Long.parseLong(userdetail.getOid()),  page, ConstProp.DIGIT_ZERO);//
        view.addObject("blist", blist);
        view.addObject("dwzPage", page);
        return view;
    }



    @RequestMapping("/findLimitAmountNoSearch")
    public ModelAndView findLimitAmountNoSearch(HttpServletRequest request, ModelMap model,DwzPage  page) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/index/findLimitAmountNo_table");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (  userdetail == null ) {
            return new ModelAndView(DSUtil.operation()+"/exports/findLimitAmountNoSearch");
        }
        view.addObject(ConstProp.USERDETAIL,userdetail);
        page.setNumPerPage(10);
        List<TopBuyersVo> blist = insTopBuyersService.findPifuList(Long.parseLong(userdetail.getOid()),  page, ConstProp.DIGIT_ZERO);//
        view.addObject("blist", blist);
        view.addObject("dwzPage", page);

        return view;
    }




    /**
     * <b>限额批复状态 --已批复</b>
     *
     * @param request
     * @param model
     * @return
     * @author liyongqiang
     * @date 2016年12月23日 下午4:11:09
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("/findLimitAmountOk")
    public ModelAndView findLimitAmountOk(HttpServletRequest request, ModelMap model,DwzPage  page) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/index/findLimitAmountOk");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (  userdetail == null ) {
            return new ModelAndView(DSUtil.operation()+"/exports/findLimitAmountOk");
        }
        view.addObject(ConstProp.USERDETAIL,userdetail);
        page.setNumPerPage(10);
        List<TopBuyersVo> blist = insTopBuyersService.findPifuList(Long.parseLong(userdetail.getOid()),  page, "1");//
        view.addObject("blist", blist);
        view.addObject("dwzPage", page);


        return view;
    }



    @RequestMapping("/findLimitAmountOkSearch")
    public ModelAndView findLimitAmountOkSearch(HttpServletRequest request, ModelMap model,DwzPage page) {
        ModelAndView view = new ModelAndView("/coninsweb/personalCenter/exports/index/findLimitAmountOk_table");
        ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        if (  userdetail == null ) {
            return new ModelAndView(DSUtil.operation()+"/exports/findLimitAmountOkSearch");
        }
        view.addObject(ConstProp.USERDETAIL,userdetail);
        page.setNumPerPage(10);
        List<TopBuyersVo> blist = insTopBuyersService.findPifuList(Long.parseLong(userdetail.getOid()),  page, "1");//
        view.addObject("blist", blist);
        view.addObject("dwzPage", page);

        return view;
    }




}
