package com.bcxin.ins.coninsweb.order.controller.api.zzx;

import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.service.ComBankCodeService;
import com.bcxin.ins.enums.TransTypeEnum;
import com.bcxin.ins.service.order.InsTransactionAPIService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.entity.policy_core.InsTransaction;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.third.zzx.huatai.ZZX_HTRequestService;
import com.bcxin.ins.util.DateUtil;
import com.bcxin.ins.util.RegionUtils;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.vo.*;
import com.bcxin.mybatisplus.toolkit.IdWorker;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 负责前台展责险投保流程的业务逻辑处理
 * ZZX-ZA-1,ZZX-ZA-2,ZZX-ZA-3
 * @author zxf
 *
 */
@Controller
@RequestMapping("/api/lote")
public class ZZX_Policy_API_Controller extends BaseController {


	@Autowired
	private PolicyService policyService;

	@Autowired
	private ProductService productService;
	@Autowired
	private ZZX_HTRequestService zZX_HTRequestService;

	@Autowired
	private InsTransactionAPIService insTransactionAPIService;
	@Autowired
	private ComBankCodeService comBankCodeService;

	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】产品-访问投保页")
	@LoginRequired(methodParamKey={"1#product_id"}, redirectUrl = "insurance/policy_init_iframe/{product_id}")
	@RequestMapping("/policyInit/{product_id}")
	public ModelAndView policyInit(HttpServletRequest request, @PathVariable Long product_id, ModelMap model) {
		//请求百保盾返回企业信息及员工信息
		LOTEPolicyVo vo = new LOTEPolicyVo();
		MailPolicyVo mVo = new MailPolicyVo();
//		mVo.setNeed_receipt(ConstProp.DIGIT_ONE);
		vo.setMailPolicyVo(mVo);
		ModelAndView view = new ModelAndView();
		view.addObject(ConstProp.VO, vo);
		view.addObject(ConstProp.RECOMMEND_CODE,UserSupportUtil.getRecommendCode());
		orderAllotInit(product_id, view);
		return view;
	}

	private String createOrderAndGetOrderIDByProductID(Long product_id, Long user_id, String recommendCode,String trade_serial_number){
		Map<String, Object> map = policyService.createOrderFormByProductOid(product_id, user_id, recommendCode, trade_serial_number);
		if(map.get(ConstProp.ORDER_ID) != null){
			return (String)map.get(ConstProp.ORDER_ID);
		}
		return "";
	}

	/**
	 * <b>通过订单ID跳转到投保界面 </b>
	 *
	 * @param request
	 * @param order_id
	 * @return
	 * @author ZXF
	 * @date 2016年12月21日 下午1:46:44
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"1#order_id"}, redirectUrl = "insurance/lote/policy/policy_iframe/{order_id}")
	@RequestMapping("/policy/{order_id}")
	public ModelAndView enterInfo(HttpServletRequest request, @PathVariable Long order_id) {
		ModelAndView view = new ModelAndView();
		orderAllot(order_id, view);
		setTokenByApi(view);
		return view;
	}

	private void orderAllotInit(Long product_id, ModelAndView view) {
		ProductVo pd = productService.getProduct(product_id);
		OrderFormVo dto = new OrderFormVo();
		dto.setProduct_oid(pd.getOid());
		dto.setProduct_code(pd.getProduct_code());
		dto.setGross_premium(pd.getPremium_min());
		dto.setTrade_serial_number(String.valueOf(com.bcxin.ins.util.IdWorker.getId()));
		view.addObject("sigId", String.valueOf(com.bcxin.ins.util.IdWorker.getId()));//普通的页面标识
		view.addObject(ConstProp.PD,pd);
		view.addObject(ConstProp.DTO,dto);
		view.addObject("comTypeList", IdType.comList());
		view.addObject("natureList", NatureLinkage.getListByProvince(""));
		if(StringUtils.isNotEmpty(pd.getProduct_code())){
			if(ConstProp.ZZX.equals(pd.getProduct_code().split(ConstProp.MINUS)[0])){
				try {
					view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
				}catch (Exception e){
					e.printStackTrace();
				}
				view.setViewName("/coninsweb/api/lote/policy/lote_enterBasicInfo");
			}
		}
	}

	private void orderAllot(Long order_id, ModelAndView view) {
		try {
			OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
			view.addObject("comTypeList", IdType.comList());
			view.addObject("natureList", NatureLinkage.getListByProvince(""));
			ProductVo pd = productService.getProduct(Long.parseLong(dto.getProduct_oid()));
			view.addObject(ConstProp.PD,pd);
			view.addObject(ConstProp.DTO,dto);
			if(StringUtils.isEmpty(dto.getProduct_code()) || !ConstProp.ZZX.equals(dto.getProduct_code().split(ConstProp.MINUS)[0])){
				return;
			}
			LOTEPolicyVo vo = policyService.accordingToOrderIDToGetLOTEPolicyVo(order_id);
			view.addObject(ConstProp.VO,vo);
			view.setViewName("/coninsweb/api/lote/policy/lote_enterBasicInfo");
			if(vo == null){
				return;
			}
			view.addObject(ConstProp.PROVINCELIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_ONE, ConstProp.BLANK_CHAR));
			if(vo.getRoleSubjectList() != null){
				if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getNature_two())
						&&StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getCom_nature())){
					view.addObject("natureTwoList", NatureLinkage.getListByProvince(vo.getRoleSubjectList().get(0).getCom_nature()));
				}
				if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_province())){
					view.addObject(ConstProp.CITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(0).getReg_province()));
				}
				if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getBank_province())){
					view.addObject("bankCityList", RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(0).getBank_province()));
				}
				if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getBank_city())){
					view.addObject("bankTypeList", comBankCodeService.getAllBankType(vo.getRoleSubjectList().get(0).getBank_city()));
				}
				if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getBank_type())){
					view.addObject("bankAddrList", comBankCodeService.getAllBankAddr(vo.getRoleSubjectList().get(0).getBank_city(),vo.getRoleSubjectList().get(0).getBank_type()));
				}
				if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(0).getReg_city())){
					view.addObject(ConstProp.AREALIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(0).getReg_city()));
				}
				//被保险人地址
				if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(1).getNature_two())
						&&StringUtils.isNotEmpty(vo.getRoleSubjectList().get(1).getCom_nature())){
					view.addObject("natureTwoList1", NatureLinkage.getListByProvince(vo.getRoleSubjectList().get(1).getCom_nature()));
				}
				if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(1).getReg_province())){
					view.addObject(ConstProp.REG_CITY_1_LIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getRoleSubjectList().get(1).getReg_province()));
				}
				if(StringUtils.isNotEmpty(vo.getRoleSubjectList().get(1).getReg_city())){
					view.addObject(ConstProp.REG_AREA_1_LIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getRoleSubjectList().get(1).getReg_city()));
				}
			}
			if(vo.getSpecialExhibitionVo() != null){
				if(StringUtils.isNotEmpty(vo.getSpecialExhibitionVo().getEx_province())){
					view.addObject("exCityList", RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getSpecialExhibitionVo().getEx_province()));
				}
				if(StringUtils.isNotEmpty(vo.getSpecialExhibitionVo().getEx_city())){
					view.addObject("exAreaList", RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_THREE, vo.getSpecialExhibitionVo().getEx_city()));
				}
			}
			if(vo.getMailPolicyVo() != null){
				if(StringUtils.isNotEmpty(vo.getMailPolicyVo().getBank_province())){
					view.addObject(ConstProp.BANKCITYLIST, RegionUtils.findDistrictByParentCode(ConstProp.DIGIT_TWO, vo.getMailPolicyVo().getBank_province()));
				}
			}
		}catch (Exception e){
			e.printStackTrace();
		}

	}

	/**
	 * <b>展责险投保界面跳转到确认页面中间的业务 </b>
	 *
	 * @param order_id
	 * @param request
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月28日 下午4:21:44
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"0#order_id"}, redirectUrl = "insurance/lote/policy/policy_iframe/{order_id}")
	@RequestMapping("/policy/confirmPage/{order_id}")
	public ModelAndView confirmPage(@PathVariable Long order_id, HttpServletRequest request) throws Exception{
		ModelAndView view = new ModelAndView();
		OrderFormVo dto = policyService.accordingToOrderIDToGetPolicyDto(order_id);
		ProductVo pd = productService.getProduct(Long.parseLong(dto.getProduct_oid()));
		view.addObject(ConstProp.PD,pd);
		view.addObject(ConstProp.DTO,dto);
		view.addObject("comTypeList", IdType.comList());
		if(StringUtils.isEmpty(dto.getProduct_code()) ? false : ConstProp.ZZX.equals(dto.getProduct_code().split(ConstProp.MINUS)[0])){
			view.setViewName("/coninsweb/api/lote/policy/policyConfirm");
			List<NatureLinkage> natureList = NatureLinkage.doList();
			LOTEPolicyVo vo = policyService.accordingToOrderIDToGetLOTEPolicyVo(order_id);
			view.addObject(ConstProp.VO,vo);
			view.addObject("natureList",natureList);
			view.addObject(ConstProp.REG_ROLE, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(0).getReg_province(),vo.getRoleSubjectList().get(0).getReg_city(),vo.getRoleSubjectList().get(0).getReg_district()));
			view.addObject(ConstProp.REG_ROLE_1, RegionUtils.getRegionNameByALLCode(vo.getRoleSubjectList().get(1).getReg_province(), vo.getRoleSubjectList().get(1).getReg_city(), vo.getRoleSubjectList().get(1).getReg_district()));
			view.addObject("ex_pca", RegionUtils.getRegionNameByALLCode(vo.getSpecialExhibitionVo().getEx_province(),vo.getSpecialExhibitionVo().getEx_city(),vo.getSpecialExhibitionVo().getEx_county()));
		}
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>展责险投保单客户填一半暂存，方法 </b>
	 *
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月21日 下午1:47:55
	 * @注意事项 </b>
	 * <b>
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_ORDER,title ="【请求】产品-订单投保")
	@RequestMapping("/policy/pendingLOTEPolicyVoPolicy")
	@ResponseBody
	public ResultDto pendingLOTEPolicyVoPolicy(LOTEPolicyVo vo, HttpServletRequest request, HttpServletResponse response) throws Exception{
		String recommendCode = request.getParameter(ConstProp.RECOMMENDCODE);
		return policyService.pendingLOTEPolicyVoPolicy(vo, recommendCode);
	}

	/**
	 * <b>修改订单状态</b>
	 *
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月21日 下午1:47:55
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired
	@RequestMapping("/policy/updateOrderFormStatus")
	@ResponseBody
	public ResultDto updateOrderFormStatus(HttpServletRequest request) throws Exception{
		String order_id = request.getParameter(ConstProp.ORDER_ID);
		String status = request.getParameter("status");
		if(StringUtils.isEmpty(order_id) || StringUtils.isEmpty(status)){
			return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		OrderFormVo vo = new OrderFormVo();
		vo.setOid(String.valueOf(order_id));
		vo.setPolicy_status(status);
		String orderID = policyService.updateOrderFormStatus(vo);
		if(StringUtils.isNotEmpty(orderID)){
			return new ResultDto("订单录入成功。", ConstProp.CODE_SUCCESS, orderID, ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR);
		}else{
			return new ResultDto("数据丢失，请刷新页面后重试！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 * <b>业务逻辑处理，保存保单信息
	 * 页面流转：点击保单保存，跳转支付页面 </b>
	 *
	 * @param order_id 保单id
	 * @return
	 * @author ZXF
	 * @date 2016年12月21日 下午1:48:20
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"0#order_id"}, redirectUrl = "insurance/lote/policy/payment_iframe/{order_id}")
	@RequestMapping("/policy/policyPayment/{order_id}")
	public ModelAndView savePolicy(@PathVariable long order_id, HttpServletRequest request) {
		ModelAndView view = null;
		try {
			OrderFormVo vo = policyService.accordingToOrderIDToGetPolicyDto(order_id);
			ProductVo pd = productService.getProduct(Long.parseLong(vo.getProduct_oid()));
			if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_DSH)){//待核保
				view = new ModelAndView("/coninsweb/api/lote/transaction/waitOffer");
			}else if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_YCB)){//核保通过
				view = new ModelAndView("/coninsweb/api/lote/transaction/passUnderwriting");
			}else if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_YJB)){//拒保
				view = new ModelAndView("/coninsweb/api/lote/transaction/declinature");
			}else if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_DZF)){//待支付
				if(productService.api_request_sign(vo.getProduct_code()) == 1){//众安
					view = new ModelAndView("/coninsweb/api/lote/transaction/policyPayment_ZA");
				}else if(productService.api_request_sign(vo.getProduct_code()) == 2){//平安财
					view = new ModelAndView("/coninsweb/api/lote/transaction/policyPayment_PAC");
				}else if(productService.api_request_sign(vo.getProduct_code()) == 3){//永安
					view = new ModelAndView("/coninsweb/api/lote/transaction/policyPayment_YA");
					List<InsTransaction> tList = insTransactionAPIService.selectInsTransactionByInsOrderForm(order_id);
					if(tList.size()>0){
						String du = tList.get(0).getDeal_url();
						view.addObject("deal_url",du);
					}
				}else if(productService.api_request_sign(vo.getProduct_code()) == 5){
					view = new ModelAndView("/coninsweb/api/lote/transaction/policyPayment_HT");
					ZZX_HT_Payment(order_id, view, vo);
				}
			}else if(vo.getPolicy_status().equals(DictConst.ORDER_STATUS_DCB)){//待承保
				view = new ModelAndView("/coninsweb/api/lote/transaction/finishPay");
			}

			view.addObject(ConstProp.PD,pd);
			view.addObject(ConstProp.DTO,vo);
		}catch (Exception e){
			e.printStackTrace();
		}

		view.addObject(ConstProp.NOWTIME,new Date());
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b> 华泰支付页面信息 </b>
	 * @author ZXF
	 * @create 2020/09/28 0028 10:05
	 * @version
	 * @注意事项 </b>
	 */
	private void ZZX_HT_Payment(@PathVariable long order_id, ModelAndView view, OrderFormVo vo) throws Exception {
		//判断是否为当天的支付号，如果不是就从新获取支付地址
		String yxDate = DateUtil.convertDateToString(new Date(),DateUtil.FORMAT6);
		boolean boo = StringUtils.isEmpty(vo.getPay_order_number())?false:vo.getPay_order_number().contains(yxDate);
		if(StringUtils.isNotEmpty(vo.getShow_url()) && boo){
			view.addObject("payurl",vo.getShow_url());
		}else{
			String result = zZX_HTRequestService.request_ht_zzx(Long.parseLong(vo.getOid()), TransTypeEnum.ZFDZ.getValue(),null);
			String[] strs = result.split(ConstProp.POUND_SIGN);
			if(ConstProp.CODE_SUCCESS.equals(strs[0])){
				policyService.payUrlChangeCA(order_id, IdWorker.getId()+"",strs[1]);
				view.addObject("payurl",strs[1]);
			}
		}
	}

	@RequestMapping("/policy/requestEPolicy/{product_code}/{oid}")
	@ResponseBody
	public ResultDto requestEPolicy(@PathVariable String product_code, @PathVariable Long oid) throws Exception {
		OrderFormVo vo = policyService.accordingToOrderIDToGetPolicyDto(oid);
		if(product_code.indexOf("ZZX-PAC")!=-1){
			String path = policyService.HTTP_PAC_ZZX_DZBD(oid);
			if(StringUtils.isNotEmpty(path)){
				return new ResultDto(ConstProp.BLANK_CHAR, ConstProp.CODE_SUCCESS, path, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			return new ResultDto("获取电子保单失败，请联系客服人员", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		if(StringUtils.isNotEmpty(vo.getInsure_path())){
			return new ResultDto(ConstProp.BLANK_CHAR, ConstProp.CODE_SUCCESS, vo.getInsure_path(), ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		return new ResultDto("电子保单下载异常，请联系客服人员", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
	}

	@RequestMapping("/sessionInfo")
	@ResponseBody
	public ResultDto sessionInfo(HttpServletRequest reqeust, ModelMap model) {
		String name = reqeust.getParameter("name");
		String base64 = reqeust.getParameter("base64");
		model.addAttribute(name, base64);
		return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
	}

	/**
	 * <b> 展责险各保险公司计算保费 </b>
	 * @author ZXF
	 * @create 2018/04/10 0010 14:13
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/policy/computePremium")
	@ResponseBody
	public ResultDto computePremium(HttpServletRequest request) {
		String productCode = request.getParameter("productCode");//产品编码
		String exAcreage = request.getParameter("exAcreage");//展位面积
		String result = policyService.zzx_amount_count(productCode,exAcreage);
		if(ConstProp.CODE_SUCCESS.equals(result.split(ConstProp.POUND_SIGN)[0])){
			return new ResultDto(result.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		return new ResultDto(result.split(ConstProp.POUND_SIGN)[1], ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		/*String msg = "";
		if(StringUtils.isNotEmpty(productCode)&&StringUtils.isNotEmpty(exAcreage)){
			Double ead = Double.valueOf(exAcreage);
			String prm = "";
			if("ZZX-PAC-1".equals(productCode)){
				if(0<ead && ead<37){
					prm = "180.00";
				}else{
					msg = "该方案展位总面积在1~36平米之间！";
				}
			}else if("ZZX-PAC-2".equals(productCode)){
				if(0<ead && ead<37){//1-37
					prm = "240.00";
				}else if(36<ead && ead<101){//38-100
					prm = "340.00";
				}else{
					msg = "该方案展位总面积在1~100平米之间！";
				}
			}else if("ZZX-PAC-3".equals(productCode)){
				if(0<ead && ead<37){//<37
					prm = "300.00";
				}else if(36<ead && ead<101){//37-100
					prm = "400.00";
				}else if(ead>100){//>100
					prm = "490.00";
				}else{
					msg = "展位总面积在1平米以上！";
				}
			}else if("ZZX-YA-1".equals(productCode)){
				if(0<ead && ead<37){//<37
					prm = "200.00";
				}else if(36<ead && ead<109){//37-100
					prm = "280.00";
				}else if(108<ead && ead<217){//>100
					prm = "380.00";
				}else if(ead>216){//>100
					int _y = 0;
					if((Integer.parseInt(exAcreage)-216)%108>0){
						_y = 1;
					}
					prm = String.valueOf(380 + (((Integer.parseInt(exAcreage)-216)/108) + _y)*30)+".00";
				}else{
					msg = "展位总面积在1平米以上！";
				}
			}else if("ZZX-YA-2".equals(productCode)){
				if(0<ead && ead<37){//<37
					prm = "260.00";
				}else if(36<ead && ead<109){//37-100
					prm = "360.00";
				}else if(108<ead && ead<217){//>100
					prm = "470.00";
				}else if(ead>216){//>100
					int _y = 0;
					if((Integer.parseInt(exAcreage)-216)%108>0){
						_y = 1;
					}
					prm = String.valueOf(470 + (((Integer.parseInt(exAcreage)-216)/108) + _y)*30)+".00";
				}else{
					msg = "展位总面积在1平米以上！";
				}
			}else if("ZZX-YA-3".equals(productCode)){
				if(0<ead && ead<37){//<37
					prm = "330.00";
				}else if(36<ead && ead<109){//37-100
					prm = "430.00";
				}else if(108<ead && ead<217){//>100
					prm = "520.00";
				}else if(ead>216){//>100
					int _y = 0;
					if((Integer.parseInt(exAcreage)-216)%108>0){
						_y = 1;
					}
					prm = String.valueOf(520 + (((Integer.parseInt(exAcreage)-216)/108) + _y)*30)+".00";
				}else{
					msg = "展位总面积在1平米以上！";
				}
			}else{
				if(productCode.contains(ConstProp.ZZX_ZA)){
					if(0<ead && ead<109){
						if(ConstProp.ZZX_ZA_1.equals(productCode)){
							prm = "450.00";
						}else if(ConstProp.ZZX_ZA_2.equals(productCode)){
							prm = "500.00";
						}else if(ConstProp.ZZX_ZA_3.equals(productCode)){
							prm = "600.00";
						}else{
							msg = "未匹配到对应产品！";
						}
					}else{
						msg = "展位总面积在1~108平米之间！";
					}
				}else{
					msg = "未匹配到对应产品！";
				}
			}
			if(StringUtils.isNotEmpty(prm)){
				return new ResultDto(prm, ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			msg = "信息丢失！";
		}*/
	}

}
