package com.bcxin.ins.coninsweb.order.controller;

import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyStragegyFactory;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyStrategy;
import com.bcxin.ins.coninsweb.order.stragegy.order.OrderSupplyType;
import com.bcxin.ins.service.product.ProductService;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.ProductVo;
import com.bcxin.ins.vo.ResultDto;
import com.bcxin.mybatisplus.toolkit.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;

/**
 * 订单投保主流程业务处理控制器
 * @author zxf
 *
 */
@Controller
@RequestMapping("/order-handle")
public class OrderHandleController extends BaseController {

	@Autowired
	private ProductService productService;
	@Autowired
	private PolicyService policyService;

	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】产品-访问投保页")
	@LoginRequired(methodParamKey={"1#product_id"}, redirectUrl = "order-handle/open-policy-init/{product_id}")
	@RequestMapping("/policy-init/{product_id}")
	public ModelAndView policyInit(HttpServletRequest request, @PathVariable Long product_id) {
		return getStrategy(OrderSupplyType.OrderSupplyTypeEnum.POLICY_INIT.getKey())
				.policyInitService(request,product_id);
	}

	/**
	 * <b>通过订单ID跳转到投保界面 </b>
	 *
	 * @param order_id 订单id
	 * @param page 当前投保内容页（如果投保页只有一页默认传1，如果多页传对应页：1、2、3）
	 * @return
	 * @author ZXF
	 * @date 2016年12月21日 下午1:46:44
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"0#order_id"}, redirectUrl = "order-handle/open-get-policy/{order_id}")
	@RequestMapping("/get-policy/{order_id}/{page}")
	public ModelAndView getPolicy(@PathVariable Long order_id, @PathVariable int page) {
		return getStrategy(OrderSupplyType.OrderSupplyTypeEnum.GET_POLICY.getKey())
				.getPolicyService(order_id, page);
	}

	/**
	 * <b>投保界面跳转到确认页面中间的业务 </b>
	 *
	 * @param order_id
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月28日 下午4:21:44
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"0#order_id"}, redirectUrl = "order-handle/open-get-policy/{order_id}")
	@RequestMapping("/confirm-policy/{order_id}")
	public ModelAndView confirmPolicy(@PathVariable Long order_id) throws Exception{
		return getStrategy(OrderSupplyType.OrderSupplyTypeEnum.CONFIRM_POLICY.getKey())
				.confirmPolicyService(order_id);
	}

	/**
	 * <b>投保页面表单提交接收数据统一方法(暂存、下一步操作时调用) </b>
	 *
	 * @param request 投保页多页时，request需要传参数（page=1\2\3页码）,代表当前提交的是第几页的业务，后台根据页码去对应的业务做处理
	 * @return
	 * @throws Exception
	 * @author ZXF
	 * @date 2016年12月21日 下午1:47:55
	 * @注意事项 </b>
	 * <b>
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT_ORDER,title ="【请求】产品-订单投保")
	@RequestMapping("/pending-policy")
	@ResponseBody
	public ResultDto pendingPolicy(Object object, HttpServletRequest request) throws Exception{
		return getStrategy(OrderSupplyType.OrderSupplyTypeEnum.PENDING_POLICY.getKey())
				.pendingPolicyService(object, request);
	}

	/**
	 * <b>业务逻辑处理，保存保单信息
	 * 页面流转：点击保单保存，跳转支付页面 </b>
	 *
	 * @param order_id 保单id
	 * @return
	 * @author ZXF
	 * @date 2016年12月21日 下午1:48:20
	 * @注意事项 </b>
	 * <b>
	 */
	@LoginRequired(methodParamKey={"0#order_id"}, redirectUrl = "order-handle/open-payment-request/{order_id}")
	@RequestMapping("/payment-request/{order_id}")
	public ModelAndView paymentRequest(@PathVariable long order_id) {
		return getStrategy(OrderSupplyType.OrderSupplyTypeEnum.PAYMENT_REQUEST.getKey())
				.paymentRequestService(order_id);
	}

	/**
	 * <b> 核保接口请求 </b>
	 *
	 * @author ZXF
	 * @create 2018/08/31 0031 14:23
	 * @version
	 * @注意事项 </b>
	 */
	@LoginRequired
	@RequestMapping("/underwriting-request")
	@ResponseBody
	public ResultDto underwritingRequest(HttpServletRequest request) {
		return getStrategy(OrderSupplyType.OrderSupplyTypeEnum.UNDERWRITING_REQUEST.getKey())
				.underwritingRequestService(request);
	}

	/**
	 * <b> 订单状态变更 </b>
	 *
	 * @param request (order_id:订单id,status:订单状态)
	 * @author ZXF
	 * @create 2018/08/31 0031 14:23
	 * @version
	 * @注意事项 </b>
	 */
	@LoginRequired
	@RequestMapping("/update-policy-status-request")
	@ResponseBody
	public ResultDto updatePolicyStatusRequest(HttpServletRequest request) {
		return policyService.updateOrderFormStatusByRequest(request);
	}

	/**
	 *
	 * <b>跳转到投保界面 iframe页面，再通过iframe中的加载地址加载页面</b>
	 * 对policyInit对投保页面初始化方法头部@LoginRequired的支持
	 * @param product_id 产品id
	 * @return
	 * @author ZXF
	 * @date 2016年12月14日 下午5:22:29
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/open-policy-init/{product_id}")
	@LoginRequired(methodParamKey={"1#product_id"}, redirectUrl = "order-handle/open-policy-init/{product_id}")
	public String openPolicyInit(@PathVariable long product_id) {
		ProductVo pd = productService.getProduct(product_id);
		String loadUrl;
		if(StringUtils.isEmpty(pd.getProduct_code()) ? false : (pd.getProduct_code().indexOf(ConstProp.GYX)!=-1
				||pd.getProduct_code().indexOf(ConstProp.TYX)!=-1
				||pd.getProduct_code().indexOf(ConstProp.GZX_PAC)!=-1
				||pd.getProduct_code().indexOf(ConstProp.ZZX)!=-1
				||pd.getProduct_code().indexOf(ConstProp.GZZRX)!=-1)){
			loadUrl = "forward:/order-handle/open-iframe-policy-init/"+product_id;
		}else {
			loadUrl = "forward:/order-handle/policy-init/"+product_id;
		}
		return loadUrl;
	}

	/**
	 * <b> 与openPolicyInit方法连用，主要是给openPolicyInit方法中需要外套iframe的业务做跳转 </b>
	 * @author ZXF
	 * @create 2018/08/31 0031 15:06
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/open-iframe-policy-init/{product_id}")
	public ModelAndView openIframePolicyInit(@PathVariable long product_id) {
		ModelAndView view = new ModelAndView("/coninsweb/api/order/open_iframe_policy_init");
		view.addObject("product_id", product_id);
		return view;
	}

	/**
	 *
	 * <b>继续投保、返回修改 iframe页面，再通过iframe中的加载地址加载页面</b>
	 * 对getPolicy对继续投保、返回修改方法头部@LoginRequired的支持
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2016年12月14日 下午5:22:29
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/open-get-policy/{order_id}")
	@LoginRequired(methodParamKey={"1#order_id"}, redirectUrl = "order-handle/open-get-policy/{order_id}")
	public String openGetPolicy(@PathVariable long order_id) {
		OrderFormVo vo = policyService.accordingToOrderIDToGetPolicyDto(order_id);
		String loadUrl;
		if(StringUtils.isEmpty(vo.getProduct_code()) ? false : (vo.getProduct_code().indexOf(ConstProp.GYX)!=-1
				||vo.getProduct_code().indexOf(ConstProp.TYX)!=-1
				||vo.getProduct_code().indexOf(ConstProp.GZX_PAC)!=-1
				||vo.getProduct_code().indexOf(ConstProp.ZZX)!=-1
				||vo.getProduct_code().indexOf(ConstProp.GZZRX)!=-1)){
			loadUrl = "forward:/order-handle/open-iframe-get-policy/"+order_id;
		}else {
			loadUrl = "forward:/order-handle/get-policy/"+order_id;
		}
		return loadUrl;
	}

	/**
	 * <b> 与openGwtPolicy方法连用，主要是给openGwtPolicy方法中需要外套iframe的业务做跳转 </b>
	 * @author ZXF
	 * @create 2018/08/31 0031 15:06
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/open-iframe-get-policy/{order_id}")
	public ModelAndView openIframeGetPolicy(@PathVariable long order_id) {
		ModelAndView view = new ModelAndView("/coninsweb/api/order/open_iframe_get_policy");
		view.addObject("order_id", order_id);
		return view;
	}

	/**
	 *
	 * <b>返回支付操作 iframe页面，再通过iframe中的加载地址加载页面</b>
	 * 对paymentRequest对支付业务方法头部@LoginRequired的支持
	 * @param order_id 订单id
	 * @return
	 * @author ZXF
	 * @date 2016年12月14日 下午5:22:29
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("/open-payment-request/{order_id}")
	@LoginRequired(methodParamKey={"1#order_id"}, redirectUrl = "order-handle/open-payment-request/{order_id}")
	public String openPaymentRequest(@PathVariable long order_id) {
		OrderFormVo vo = policyService.accordingToOrderIDToGetPolicyDto(order_id);
		String loadUrl;
		if(StringUtils.isEmpty(vo.getProduct_code()) ? false : (vo.getProduct_code().indexOf(ConstProp.GYX)!=-1
				||vo.getProduct_code().indexOf(ConstProp.TYX)!=-1
				||vo.getProduct_code().indexOf(ConstProp.GZX_PAC)!=-1
				||vo.getProduct_code().indexOf(ConstProp.ZZX)!=-1
				||vo.getProduct_code().indexOf(ConstProp.GZZRX)!=-1)){
			loadUrl = "forward:/order-handle/open-iframe-payment-request/"+order_id;
		}else {
			loadUrl = "forward:/order-handle/payment-request/"+order_id;
		}
		return loadUrl;
	}

	/**
	 * <b> 与openPaymentRequest方法连用，主要是给openPaymentRequest方法中需要外套iframe的业务做跳转 </b>
	 * @author ZXF
	 * @create 2018/08/31 0031 15:06
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/open-iframe-payment-request/{order_id}")
	public ModelAndView openIframePaymentRequest(@PathVariable long order_id) {
		ModelAndView view = new ModelAndView("/coninsweb/api/order/open_iframe_payment_request");
		view.addObject("order_id", order_id);
		return view;
	}

	private OrderSupplyStrategy getStrategy(String type){
		return OrderSupplyStragegyFactory.getStrategy(type);
	}
}
