package com.bcxin.ins.coninsweb.common.controller;

import com.bcxin.ins.service.common.ModelSendService;
import com.bcxin.ins.service.common.SysClientUserPostService;
import com.bcxin.ins.service.order.PolicyService;
import com.bcxin.ins.rest.UserSupportUtil;
import com.bcxin.ins.service.user.ClientCompanyService;
import com.bcxin.ins.service.user.ClientUserService;
import com.bcxin.ins.core.base.web.BaseController;
import com.bcxin.ins.core.entity.ME;
import com.bcxin.ins.dto.ResultDto;
import com.bcxin.ins.entity.user.SysClientCompany;
import com.bcxin.ins.entity.user.SysClientUserPost;
import com.bcxin.ins.spring.annotation.LoginRequired;
import com.bcxin.ins.spring.annotation.OperationLog;
import com.bcxin.ins.spring.executor.MyAsyncExecutor;
import com.bcxin.ins.spring.util.JedisUtils;
import com.bcxin.ins.util.*;
import com.bcxin.ins.util.email.EmailModel;
import com.bcxin.ins.util.email.EmailMsgType;
import com.bcxin.ins.util.email.SendEmailAndMsgUtil;
import com.bcxin.ins.util.enums.IdType;
import com.bcxin.ins.util.enums.NatureLinkage;
import com.bcxin.ins.vo.ClientUserVo;
import com.bcxin.ins.vo.ConstProp;
import com.bcxin.ins.vo.DwzPage;
import com.bcxin.ins.vo.InsOrderSearchVo;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * 个人中心(我的账户)
 * @author zxf
 *
 */
@Controller
@RequestMapping("/pc")
public class PersonalCenterController extends BaseController {



	@Autowired
	private PolicyService policyService;

	@Autowired
	private SysClientUserPostService sysClientUserPostService;

	@Autowired
	private ClientUserService userService;

	@Autowired
	private ClientCompanyService companyService;
	@Autowired
	private ModelSendService mss;

	@Autowired
	private MyAsyncExecutor myAsyncExecutor;

	/**
	 * <b>我的账户 </b>
	 */
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的账户")
	@LoginRequired(redirectUrl = "redirect:/pc/index")
	@RequestMapping("index")
	public ModelAndView personalCenterIndex(DwzPage page){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(page == null){
			page = new DwzPage();
		}
		page.setNumPerPage(5);
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/index");
		//投标保证险由于支付完后信息并未实时生成结果，这边增加异步去请求所有存在投保单号但缺失保单号的订单请求太保接口查询订单承保信息
		myAsyncExecutor.execute(()->{
			try {
				if(GlobalResources.IS_POLICY_TP107001_OPEN.equals("YES")){
					policyService.policyEndStatus(userdetail.getOid());//TODO 检索投标产品支付完成重置状态并获取电子保单保函（等接口对接再使用）
				}
			} catch(Exception e) {

			}
		});
		String keyword = getRequest().getParameter("keyword");
		String starDate = getRequest().getParameter("starDate");
		String endDate = getRequest().getParameter("endDate");
		try {
			InsOrderSearchVo search = InsOrderSearchVo.build(Long.parseLong(userdetail.getOid()),ConstProp.DIGIT_ONE,ConstProp.BLANK_CHAR, keyword, starDate, endDate, ConstProp.BLANK_CHAR,page);
			view.addObject("policyTotals",policyService.findTotalPolicyNum(search));
			view.addObject(ConstProp.ORDERLIST,policyService.findPolicyForPage(search));
			view.addObject("policyStatus",ConstProp.DIGIT_ONE);
			view.addObject("num",getNum(userdetail));
			view.addObject("date", DateUtil.getCurrentDateTime());

		}catch (Exception ex){
			logger.error("我的账户",ex);
		}

		setTokenByApi(view);
		return view;
	}
	

	/**
	 * <b>理赔查询 </b>
	 */
	@RequestMapping("claimList")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的账户-理赔查询")
	public ModelAndView claimListInit(DwzPage page){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null){
			return new ModelAndView(DSUtil.operation()+"/pc/claimList");
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/claimList_new");
		page.setNumPerPage(5);
		view.addObject(ConstProp.USERDETAIL,userdetail);
		setTokenByApi(view);
		return view;
	}

	/**
	 * <b>邮寄地址 </b>
	 */
	@RequestMapping("/mailAddress")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的账户-邮寄地址")
	public String mailAddress(@RequestParam Map<Object,Object> params, Model model){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null){
			return DSUtil.operation()+"/pc/mailAddress";
		}
		model.addAttribute("userdetail",userdetail);

		//查看是否存在用户
		model.addAttribute("row",sysClientUserPostService.selectByMap(new ME().put("sys_client_user_id",userdetail.getOid()).getM()));
		setTokenByApi(model);
		return "/coninsweb/personalCenter/mailAddress";
	}

	/**
	 * <b>投保单邮寄地址 </b>
	 */
	@RequestMapping("/tb-mail-address/{uid}")
	public @ResponseBody Object tbMailAddress(@PathVariable String uid){
		List<SysClientUserPost> ar = sysClientUserPostService.selectByMap(new ME().put("sys_client_user_id", uid).getM());
		if(ar != null && ar.size()>0){
			SysClientUserPost scup = ar.get(0);
			String address = RegionUtils.getRegionNameByALLCode(scup.getProvince(),scup.getCity(),scup.getDistrict())+scup.getAddress();
			scup.setAddress(address);
			return scup;
		}
		return null;
	}

	/**
	 * <b>邮寄地址 保存</b>
	 */
	@RequestMapping(value="/mailAddress/save")
	public @ResponseBody Object mailAddressSave(@RequestParam Map<Object,Object> params, Model model){
		if(UserSupportUtil.getSessionUser() == null) return DSUtil.operation()+"/pc/mailAddress";
		return sysClientUserPostService.add(params);
	}


	/**
	 * <b>我的资料 </b>
	 */
	@RequestMapping("myAccount")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的账户-我的资料")
	public ModelAndView myAccount(){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null){
			return new ModelAndView(DSUtil.operation()+"/pc/myAccount");
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/myAccount");
		if(Constant.TERMINAL_TYPE_COMPANY.equals(userdetail.getTerminal_type())){
            //如果是公司完善资料页面
            view.addObject("idTypeList", IdType.companyList());
			view.addObject("companyIdTypeList", IdType.companyCodeList());
			view.addObject("natureList", NatureLinkage.getListByProvince(""));
			if(StringUtils.isNotEmpty(userdetail.getEnterprise_type())){
				view.addObject("natureTwoList", NatureLinkage.getListByProvince(userdetail.getEnterprise_type()));
			}
        }
        view.addObject(ConstProp.USERDETAIL,userdetail);
		setTokenByApi(view);
		return view;
	}

	private String getNum(ClientUserVo userdetail) {
		int num=0;
		if(Constant.IS_CERTIFICATION.equals(userdetail.getIs_certification())){
			num=60;//个人认证
		}
        if(Constant.IS_CERTIFICATION.equals(userdetail.getC_is_certification())){
            num=60;//公司认证
        }
		if(StringUtils.isNotEmpty(userdetail.getEmail())){
			num=num+20;
		}
		if(StringUtils.isNotEmpty(userdetail.getTelephone())){
			num=num+20;
		}
		 return num+"";
	}


	@RequestMapping("/myAccount/saveInfo")
	@ResponseBody
	public ResultDto saveAccountInfo(SysClientCompany company, HttpServletRequest request) {
			ClientUserVo vo= UserSupportUtil.getSessionUser();
			//判断手机是否存在，存在不让其绑定
			company.setIs_certification(Constant.IS_CERTIFICATION);
			if(companyService.saveCompany(company,vo)){

				return new ResultDto("保存成功", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			} else {
				return new ResultDto("保存失败", com.bcxin.ins.vo.ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}

	}


	/**
	 * <b>实名认证
	 */
	@RequestMapping("realNameAuthentication")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的账户-实名认证")
	public ModelAndView realNameAuthentication(){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null){
			return new ModelAndView(DSUtil.operation()+"/pc/realNameAuthentication");
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/realNameAuthentication");
		view.addObject(ConstProp.USERDETAIL,userdetail);
		setTokenByApi(view);
		return view;
	}


	/**
	 *有在用
	 *发送手机验证码
	 */
	@RequestMapping("/sendAuthCode")
	@ResponseBody
	public ResultDto sendAuthCode(HttpServletRequest request) {
		return new ResultDto("手机发送失败", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		/*ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(StringUtils.isNotEmpty(userdetail.getTelephone())){
			String code = MathUtil.getRandomCode();
			logger.info("实名认证-验证码："+code);
			MessageModel mm = new MessageModel(code, EmailMsgType.AUTHCODE);
			logger.info("实名认证-手机验证码内容："+mm.getContent());
			//华为短信发送
			SMSUtil.sendHuaWeiSMS(new HuaWeiSmsContent(
					ConstProp.SMSPLATFORM_BCXIN,
					ConstProp.SMSCODE_P01,
					userdetail.getTelephone(),
					JSON.toJSONString(new String[]{code})));
			request.getSession().setAttribute("authenticationCode",code);
			return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}else{
			return new ResultDto("手机发送失败", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}*/
	}

	/**
	 * 发送邮件
	 * @param request
	 * @return
	 */
	@RequestMapping("/sendEmailCode")
	@ResponseBody
	public ResultDto sendEmailCode(HttpServletRequest request) {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
        String  type=request.getParameter("type");
		if(StringUtils.isNotEmpty(userdetail.getEmail())){
			String code= MathUtil.getRandomCode();
			EmailModel em = new EmailModel(code,EmailMsgType.SMYZM);
			if(StringUtils.isNotEmpty(type)){//验证绑定邮箱中的身份认证
				em = new EmailModel(code,EmailMsgType.TYYZM);
			}
			em.addTo(userdetail.getEmail());
			try {
				SendEmailAndMsgUtil.sendEmail(em);
				String keyac = ConstProp.YZM_AC+IpAddress.getIpAddress(getRequest());
				JedisUtils.set(keyac,code,5 * 60);
//				request.getSession().setAttribute("authenticationCode",code);
				return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}catch (Exception e){
				return new ResultDto("服务器未响应，请联系管理员！！", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("邮箱不能为空", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}

	}
	@RequestMapping("/sendEmailAgainCode")
	@ResponseBody
	public ResultDto sendEmailAgainCode(HttpServletRequest request) {
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String  email =request.getParameter("email");
		//这边需要做判断验证邮箱是否存在
		if(StringUtils.isNotEmpty(email)){
			String code= MathUtil.getRandomCode();
			EmailModel em = new EmailModel(code,EmailMsgType.BDYZM);
			em.addTo(email);
			try {
				SendEmailAndMsgUtil.sendEmail(em);
				String keyauac = ConstProp.YZM_AUAC+IpAddress.getIpAddress(getRequest());
				JedisUtils.set(keyauac,code,5 * 60);
//				request.getSession().setAttribute("authenticationAgainCode",code);
				return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}catch (Exception e){
				return new ResultDto("服务器未响应，请联系管理员！！", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}

		}else{
			return new ResultDto("邮箱不能为空", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}

	}


	@RequestMapping("/sendPhoneAgainCode")
	@ResponseBody
	public ResultDto sendPhoneAgainCode(HttpServletRequest request) {
		return new ResultDto("手机发送失败", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		/*ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		String  tel=  request.getParameter("phone");
		if(StringUtils.isNotEmpty(tel)){
			String code = MathUtil.getRandomCode();
			logger.info("实名认证-验证码："+code);
			MessageModel mm = new MessageModel(code, EmailMsgType.AUTHCODE);
			logger.info("实名认证-手机验证码内容："+mm.getContent());
			//华为短信发送
			SMSUtil.sendHuaWeiSMS(new HuaWeiSmsContent(
					ConstProp.SMSPLATFORM_BCXIN,
					ConstProp.SMSCODE_P01,
					tel,
					JSON.toJSONString(new String[]{code})));
			request.getSession().setAttribute("authenticationAgainCode",code);
			return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}else{
			return new ResultDto("手机发送失败", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}*/
	}


	/**
	 * 验证实名的code 是否正确
	 */
	@RequestMapping("/checkAuthCode")
	@ResponseBody
	public ResultDto checkAuthCode(@RequestParam String code, HttpServletRequest request) {
		if(StringUtils.isNotEmpty(code)){
			String keyac = ConstProp.YZM_AC+IpAddress.getIpAddress(getRequest());
			String codeAuth = JedisUtils.get(keyac);
            if(StringUtils.isEmpty(codeAuth)){
                return new ResultDto("", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
            }
//			String codeAuth=request.getSession().getAttribute("authenticationCode").toString();
			if(codeAuth.equals(code)){
				return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}


	/**
	 * 验证实名的code 是否正确
	 */
	@RequestMapping("/checkAuthAgainCode")
	@ResponseBody
	public ResultDto checkAuthAgainCode(@RequestParam String code, HttpServletRequest request) {
		if(StringUtils.isNotEmpty(code)){
			String keyauac = ConstProp.YZM_AUAC+IpAddress.getIpAddress(getRequest());
			String codeAuth=JedisUtils.get(keyauac);
			if(StringUtils.isEmpty(codeAuth)){
				return new ResultDto("", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
//			String codeAuth=request.getSession().getAttribute("authenticationAgainCode").toString();
			if(codeAuth.equals(code)){
				return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}else{
				return new ResultDto("", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else{
			return new ResultDto("", ConstProp.CODE_FAILURE, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}
	/**
	 * 保存认证信息
	 * @param request
	 * @return
	 */
	@RequestMapping("/realNameAuthentication/saveInfo")
	@ResponseBody
	public ResultDto saveInfo(HttpServletRequest request) {
		String realName =request.getParameter("real_name");//真实姓名
		String realCard =request.getParameter("real_card");//身份证
		if(StringUtils.isNotEmpty(realName)&& IdCardVerify.isValidatedAllIdcard(realCard)){
			ClientUserVo vo= UserSupportUtil.getSessionUser();
			if(userService.updClientUserVoInfo(vo,realName,realCard)){

				return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			} else {
				return new ResultDto("保存失败", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}

		}else {
			return new ResultDto("身份证错误", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}


	@RequestMapping("/email/saveInfo")
	@ResponseBody
	public ResultDto saveEmailInfo(HttpServletRequest request) {
		String email =request.getParameter("again_email");//

		if(StringUtils.isNotEmpty(email)){
			ClientUserVo vo= UserSupportUtil.getSessionUser();
			//判断邮箱是否存在，存在不让其绑定
			if(!userService.getUserEmailForRegister(email, Constant.WEB_TYPE_COINS)){
				return new ResultDto("邮箱已经被注册，请更换邮箱", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			if(userService.updClientUserVoEmail(vo,email)){
				return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			} else {
				return new ResultDto("更新邮箱失败", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}

		}else {
			return new ResultDto("数据丢失", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}


	@RequestMapping("/phone/saveInfo")
	@ResponseBody
	public ResultDto savePhoneInfo(HttpServletRequest request) {
		String phone =request.getParameter("again_phone");//
		if(StringUtils.isNotEmpty(phone)){
			ClientUserVo vo= UserSupportUtil.getSessionUser();
			//判断手机是否存在，存在不让其绑定
//			if(UserSupportUtil.getUserPhoneExist(phone)){
			if(!userService.getUserMobileForRegister(phone, Constant.WEB_TYPE_COINS)){
				return new ResultDto("保存失败", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
			if(userService.updClientUserVoPhone(vo,phone)){
				return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			} else {
				return new ResultDto("保存失败", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}

		}else {
			return new ResultDto("身份证错误", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}

	/**
	 *   初始化 绑定 手机号码
	 */
	@RequestMapping("phoneInit")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的账户-绑定手机号码")
	public ModelAndView phoneInit(){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null){
			return new ModelAndView(DSUtil.operation()+"/pc/phoneInit");
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/phoneInit");
		view.addObject(ConstProp.USERDETAIL,userdetail);
		setTokenByApi(view);
		return view;
	}


	/**
	 *   初始化 绑定 邮箱
	 */
	@RequestMapping("emailInit")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的账户-绑定邮箱")
	public ModelAndView emailInit(){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null){
			return new ModelAndView(DSUtil.operation()+"/pc/emailInit");
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/emailInit");
		view.addObject(ConstProp.USERDETAIL,userdetail);
		setTokenByApi(view);
		return view;
	}


	/**
	 *   初始化修改密码
	 */
	@RequestMapping("updPwdInit")
	@OperationLog(source = OperationLog.SOURCETYPE.FRONT,title ="【视图】我的账户-修改密码")
	public ModelAndView updPwdInit(){
		ClientUserVo userdetail = UserSupportUtil.getSessionUser();
		if(userdetail == null){
			return new ModelAndView(DSUtil.operation()+"/pc/updPwdInit");
		}
		ModelAndView view = new ModelAndView("/coninsweb/personalCenter/updPwdInit");
		view.addObject(ConstProp.USERDETAIL,userdetail);
		setTokenByApi(view);
		return view;
	}


	@RequestMapping("/pwd/checkOldPwd")
	@ResponseBody
	public ResultDto checkOldPwd(HttpServletRequest request) {

		String oldPwd =request.getParameter("oldPwd");//
		if(StringUtils.isNotEmpty(oldPwd)){
			ClientUserVo vo= UserSupportUtil.getSessionUser();
			if(Sha1Util.validatePassword(oldPwd,vo.getPassword())){
			//判断旧的密码是否相同
				return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			} else {
				return new ResultDto("密码错误", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}

		}else {
			return new ResultDto("密码错误", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
	}


	@RequestMapping("/pwd/savePwd")
	@ResponseBody
	public ResultDto savePwd(HttpServletRequest request) {
		String newPwd =request.getParameter("newPwd");//
		if(StringUtils.isNotEmpty(newPwd)){
			ClientUserVo vo= UserSupportUtil.getSessionUser();

			if(userService.getUserPassword(vo.getLogin_name(),newPwd)){
				vo.setPassword(Sha1Util.entryptPassword(newPwd));
				UserSupportUtil.setSessionUser(vo);
				//判断旧的密码是否相同
				return new ResultDto("", ConstProp.CODE_SUCCESS, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			} else {
				return new ResultDto("保存新密码失败", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
			}
		}else {
			return new ResultDto("保存新密码失败", "300", ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
		}
		//
	}

	/**
	 * <b> 下载保障人员名单 </b>
	 * @author ZXF
	 * @create 2019/11/07 0007 14:37
	 * @version
	 * @注意事项 </b>
	 */
	@RequestMapping("/down_security_personnel/{oid}")
	public void downSecurityPersonnel(@PathVariable Long oid, HttpServletResponse resp) {
		policyService.downSecurityPersonnel(oid,resp);
	}
}
